/* valastruct.c generated by valac, the Vala compiler
 * generated from valastruct.vala, do not modify */

/* valastruct.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_SUBROUTINE (vala_subroutine_get_type ())
#define VALA_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutine))
#define VALA_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))
#define VALA_IS_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SUBROUTINE))
#define VALA_IS_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SUBROUTINE))
#define VALA_SUBROUTINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))

typedef struct _ValaSubroutine ValaSubroutine;
typedef struct _ValaSubroutineClass ValaSubroutineClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;
typedef struct _ValaTypeSymbolPrivate ValaTypeSymbolPrivate;
typedef struct _ValaStructPrivate ValaStructPrivate;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_MEMBER_BINDING (vala_member_binding_get_type ())

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_PARAMETER (vala_parameter_get_type ())
#define VALA_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PARAMETER, ValaParameter))
#define VALA_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PARAMETER, ValaParameterClass))
#define VALA_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PARAMETER))
#define VALA_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PARAMETER))
#define VALA_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PARAMETER, ValaParameterClass))

typedef struct _ValaParameter ValaParameter;
typedef struct _ValaParameterClass ValaParameterClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;

#define VALA_TYPE_PROFILE (vala_profile_get_type ())
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_VALUE_TYPE (vala_value_type_get_type ())
#define VALA_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VALUE_TYPE, ValaValueType))
#define VALA_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))
#define VALA_IS_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VALUE_TYPE))
#define VALA_IS_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VALUE_TYPE))
#define VALA_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))

typedef struct _ValaValueType ValaValueType;
typedef struct _ValaValueTypeClass ValaValueTypeClass;

#define VALA_TYPE_STRUCT_VALUE_TYPE (vala_struct_value_type_get_type ())
#define VALA_STRUCT_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType))
#define VALA_STRUCT_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueTypeClass))
#define VALA_IS_STRUCT_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT_VALUE_TYPE))
#define VALA_IS_STRUCT_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT_VALUE_TYPE))
#define VALA_STRUCT_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueTypeClass))

typedef struct _ValaStructValueType ValaStructValueType;
typedef struct _ValaStructValueTypeClass ValaStructValueTypeClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

struct _ValaTypeSymbol {
	ValaSymbol parent_instance;
	ValaTypeSymbolPrivate * priv;
};

struct _ValaTypeSymbolClass {
	ValaSymbolClass parent_class;
	gboolean (*is_reference_type) (ValaTypeSymbol* self);
	gboolean (*is_subtype_of) (ValaTypeSymbol* self, ValaTypeSymbol* t);
	gint (*get_type_parameter_index) (ValaTypeSymbol* self, const gchar* name);
};

struct _ValaStruct {
	ValaTypeSymbol parent_instance;
	ValaStructPrivate * priv;
};

struct _ValaStructClass {
	ValaTypeSymbolClass parent_class;
};

struct _ValaStructPrivate {
	ValaList* type_parameters;
	ValaList* constants;
	ValaList* fields;
	ValaList* methods;
	ValaList* properties;
	ValaDataType* _base_type;
	gboolean* boolean_type;
	gboolean* integer_type;
	gboolean* floating_type;
	gboolean* decimal_floating_type;
	gboolean* simple_type;
	gint* rank;
	gint* _width;
	gboolean* _signed;
	gboolean* _is_immutable;
	ValaMethod* _default_construction_method;
};

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;

typedef enum  {
	VALA_MEMBER_BINDING_INSTANCE,
	VALA_MEMBER_BINDING_CLASS,
	VALA_MEMBER_BINDING_STATIC
} ValaMemberBinding;

typedef enum  {
	VALA_PROFILE_POSIX,
	VALA_PROFILE_GOBJECT,
	VALA_PROFILE_DOVA
} ValaProfile;


static gpointer vala_struct_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_subroutine_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
GType vala_typeparameter_get_type (void) G_GNUC_CONST;
#define VALA_STRUCT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_STRUCT, ValaStructPrivate))
enum  {
	VALA_STRUCT_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
ValaStruct* vala_struct_new (const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
ValaStruct* vala_struct_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
ValaTypeSymbol* vala_typesymbol_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
void vala_struct_add_type_parameter (ValaStruct* self, ValaTypeParameter* p);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
void vala_scope_add (ValaScope* self, const gchar* name, ValaSymbol* sym);
const gchar* vala_symbol_get_name (ValaSymbol* self);
ValaList* vala_struct_get_type_parameters (ValaStruct* self);
static void vala_struct_real_add_constant (ValaSymbol* base, ValaConstant* c);
static void vala_struct_real_add_field (ValaSymbol* base, ValaField* f);
GType vala_symbol_accessibility_get_type (void) G_GNUC_CONST;
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
ValaList* vala_struct_get_fields (ValaStruct* self);
ValaList* vala_struct_get_constants (ValaStruct* self);
static void vala_struct_real_add_method (ValaSymbol* base, ValaMethod* m);
GType vala_member_binding_get_type (void) G_GNUC_CONST;
ValaMemberBinding vala_method_get_binding (ValaMethod* self);
GType vala_creation_method_get_type (void) G_GNUC_CONST;
ValaDataType* vala_semantic_analyzer_get_data_type_for_symbol (ValaTypeSymbol* sym);
ValaParameter* vala_parameter_new (const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
ValaParameter* vala_parameter_construct (GType object_type, const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
GType vala_parameter_get_type (void) G_GNUC_CONST;
void vala_method_set_this_parameter (ValaMethod* self, ValaParameter* value);
ValaParameter* vala_method_get_this_parameter (ValaMethod* self);
ValaDataType* vala_method_get_return_type (ValaMethod* self);
GType vala_void_type_get_type (void) G_GNUC_CONST;
ValaCodeContext* vala_code_context_get (void);
GType vala_profile_get_type (void) G_GNUC_CONST;
ValaProfile vala_code_context_get_profile (ValaCodeContext* self);
ValaList* vala_method_get_postconditions (ValaMethod* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
ValaLocalVariable* vala_local_variable_new (ValaDataType* variable_type, const gchar* name, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaLocalVariable* vala_local_variable_construct (GType object_type, ValaDataType* variable_type, const gchar* name, ValaExpression* initializer, ValaSourceReference* source_reference);
GType vala_local_variable_get_type (void) G_GNUC_CONST;
void vala_subroutine_set_result_var (ValaSubroutine* self, ValaLocalVariable* value);
ValaLocalVariable* vala_subroutine_get_result_var (ValaSubroutine* self);
void vala_local_variable_set_is_result (ValaLocalVariable* self, gboolean value);
void vala_struct_set_default_construction_method (ValaStruct* self, ValaMethod* value);
void vala_symbol_set_name (ValaSymbol* self, const gchar* value);
const gchar* vala_creation_method_get_class_name (ValaCreationMethod* self);
void vala_report_error (ValaSourceReference* source, const gchar* message);
gchar* vala_symbol_get_full_name (ValaSymbol* self);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
ValaList* vala_struct_get_methods (ValaStruct* self);
static void vala_struct_real_add_property (ValaSymbol* base, ValaProperty* prop);
void vala_property_set_this_parameter (ValaProperty* self, ValaParameter* value);
ValaParameter* vala_property_get_this_parameter (ValaProperty* self);
ValaField* vala_property_get_field (ValaProperty* self);
void vala_symbol_add_field (ValaSymbol* self, ValaField* f);
ValaList* vala_struct_get_properties (ValaStruct* self);
static void vala_struct_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_struct (ValaCodeVisitor* self, ValaStruct* st);
static void vala_struct_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaDataType* vala_struct_get_base_type (ValaStruct* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
gboolean vala_struct_is_boolean_type (ValaStruct* self);
ValaStruct* vala_struct_get_base_struct (ValaStruct* self);
ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const gchar* name);
static gboolean* _bool_dup (gboolean* self);
gboolean vala_struct_is_integer_type (ValaStruct* self);
gboolean vala_struct_is_floating_type (ValaStruct* self);
gboolean vala_struct_is_decimal_floating_type (ValaStruct* self);
gboolean vala_code_node_get_attribute_bool (ValaCodeNode* self, const gchar* attribute, const gchar* argument, gboolean default_value);
gint vala_struct_get_rank (ValaStruct* self);
gboolean vala_code_node_has_attribute_argument (ValaCodeNode* self, const gchar* attribute, const gchar* argument);
gint vala_code_node_get_attribute_integer (ValaCodeNode* self, const gchar* attribute, const gchar* argument, gint default_value);
static gint* _int_dup (gint* self);
void vala_struct_set_rank (ValaStruct* self, gint rank);
void vala_code_node_set_attribute_integer (ValaCodeNode* self, const gchar* attribute, const gchar* argument, gint value, ValaSourceReference* source_reference);
static gint vala_struct_real_get_type_parameter_index (ValaTypeSymbol* base, const gchar* name);
gboolean vala_struct_is_simple_type (ValaStruct* self);
void vala_struct_set_simple_type (ValaStruct* self, gboolean simple_type);
void vala_code_node_set_attribute (ValaCodeNode* self, const gchar* name, gboolean value, ValaSourceReference* source_reference);
static void vala_struct_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
void vala_struct_set_base_type (ValaStruct* self, ValaDataType* value);
static gboolean vala_struct_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
gboolean vala_typesymbol_is_subtype_of (ValaTypeSymbol* self, ValaTypeSymbol* t);
gboolean vala_struct_is_disposable (ValaStruct* self);
gchar* vala_code_node_get_attribute_string (ValaCodeNode* self, const gchar* attribute, const gchar* argument);
ValaMemberBinding vala_field_get_binding (ValaField* self);
ValaDataType* vala_variable_get_variable_type (ValaVariable* self);
gboolean vala_data_type_is_disposable (ValaDataType* self);
static gboolean vala_struct_is_recursive_value_type (ValaStruct* self, ValaDataType* type);
GType vala_value_type_get_type (void) G_GNUC_CONST;
GType vala_struct_value_type_get_type (void) G_GNUC_CONST;
gboolean vala_data_type_get_nullable (ValaDataType* self);
ValaTypeSymbol* vala_value_type_get_type_symbol (ValaValueType* self);
static gboolean vala_struct_real_check (ValaCodeNode* base, ValaCodeContext* context);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
ValaSemanticAnalyzer* vala_code_context_get_analyzer (ValaCodeContext* self);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaCodeContext* context);
gchar* vala_code_node_to_string (ValaCodeNode* self);
ValaExpression* vala_variable_get_initializer (ValaVariable* self);
gboolean vala_symbol_get_external (ValaSymbol* self);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
ValaMethod* vala_struct_get_default_construction_method (ValaStruct* self);
gboolean vala_struct_get_is_immutable (ValaStruct* self);
void vala_struct_set_is_immutable (ValaStruct* self, gboolean value);
gint vala_struct_get_width (ValaStruct* self);
void vala_struct_set_width (ValaStruct* self, gint value);
gboolean vala_struct_get_signed (ValaStruct* self);
void vala_struct_set_signed (ValaStruct* self, gboolean value);
void vala_code_node_set_attribute_bool (ValaCodeNode* self, const gchar* attribute, const gchar* argument, gboolean value, ValaSourceReference* source_reference);
static void vala_struct_finalize (ValaCodeNode* obj);


/**
 * Creates a new struct.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @return                 newly created struct
 */
ValaStruct* vala_struct_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaStruct* self = NULL;
	const gchar* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaComment* _tmp2_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = source_reference;
	_tmp2_ = comment;
	self = (ValaStruct*) vala_typesymbol_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	return self;
}


ValaStruct* vala_struct_new (const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_struct_construct (VALA_TYPE_STRUCT, name, source_reference, comment);
}


/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void vala_struct_add_type_parameter (ValaStruct* self, ValaTypeParameter* p) {
	ValaList* _tmp0_;
	ValaTypeParameter* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaTypeParameter* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaTypeParameter* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	_tmp1_ = p;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = p;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = p;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Returns a copy of the type parameter list.
 *
 * @return list of type parameters
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_struct_get_type_parameters (ValaStruct* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified constant as a member to this struct.
 *
 * @param c a constant
 */
static void vala_struct_real_add_constant (ValaSymbol* base, ValaConstant* c) {
	ValaStruct * self;
	ValaList* _tmp0_;
	ValaConstant* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaConstant* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaConstant* _tmp7_;
	self = (ValaStruct*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->constants;
	_tmp1_ = c;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = c;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = c;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Adds the specified field as a member to this struct.
 *
 * @param f a field
 */
static void vala_struct_real_add_field (ValaSymbol* base, ValaField* f) {
	ValaStruct * self;
	ValaField* _tmp0_;
	ValaList* _tmp1_;
	ValaField* _tmp2_;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	ValaField* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	ValaField* _tmp8_;
	self = (ValaStruct*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = f;
	vala_symbol_set_access ((ValaSymbol*) _tmp0_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp1_ = self->priv->fields;
	_tmp2_ = f;
	vala_collection_add ((ValaCollection*) _tmp1_, _tmp2_);
	_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = f;
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = f;
	vala_scope_add (_tmp4_, _tmp7_, (ValaSymbol*) _tmp8_);
}


/**
 * Returns a copy of the list of fields.
 *
 * @return list of fields
 */
ValaList* vala_struct_get_fields (ValaStruct* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->fields;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of constants.
 *
 * @return list of constants
 */
ValaList* vala_struct_get_constants (ValaStruct* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->constants;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified method as a member to this struct.
 *
 * @param m a method
 */
static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void vala_struct_real_add_method (ValaSymbol* base, ValaMethod* m) {
	ValaStruct * self;
	ValaMethod* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaMethod* _tmp2_;
	ValaMemberBinding _tmp3_;
	ValaMemberBinding _tmp4_;
	gboolean _tmp6_;
	gboolean _tmp23_ = FALSE;
	ValaMethod* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp26_;
	gboolean _tmp39_;
	ValaMethod* _tmp53_;
	ValaList* _tmp82_;
	ValaMethod* _tmp83_;
	ValaScope* _tmp84_;
	ValaScope* _tmp85_;
	ValaMethod* _tmp86_;
	const gchar* _tmp87_;
	const gchar* _tmp88_;
	ValaMethod* _tmp89_;
	self = (ValaStruct*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp2_ = m;
	_tmp3_ = vala_method_get_binding (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == VALA_MEMBER_BINDING_INSTANCE) {
		_tmp1_ = TRUE;
	} else {
		ValaMethod* _tmp5_;
		_tmp5_ = m;
		_tmp1_ = VALA_IS_CREATION_METHOD (_tmp5_);
	}
	_tmp6_ = _tmp1_;
	if (_tmp6_) {
		ValaMethod* _tmp7_;
		ValaDataType* _tmp8_ = NULL;
		ValaDataType* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		ValaMethod* _tmp12_;
		ValaScope* _tmp13_;
		ValaScope* _tmp14_;
		ValaMethod* _tmp15_;
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		ValaMethod* _tmp20_;
		ValaParameter* _tmp21_;
		ValaParameter* _tmp22_;
		_tmp7_ = m;
		_tmp8_ = vala_semantic_analyzer_get_data_type_for_symbol ((ValaTypeSymbol*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_parameter_new ("this", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		vala_method_set_this_parameter (_tmp7_, _tmp11_);
		_vala_code_node_unref0 (_tmp11_);
		_vala_code_node_unref0 (_tmp9_);
		_tmp12_ = m;
		_tmp13_ = vala_symbol_get_scope ((ValaSymbol*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = m;
		_tmp16_ = vala_method_get_this_parameter (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_symbol_get_name ((ValaSymbol*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = m;
		_tmp21_ = vala_method_get_this_parameter (_tmp20_);
		_tmp22_ = _tmp21_;
		vala_scope_add (_tmp14_, _tmp19_, (ValaSymbol*) _tmp22_);
	}
	_tmp24_ = m;
	_tmp25_ = vala_method_get_return_type (_tmp24_);
	_tmp26_ = _tmp25_;
	if (!VALA_IS_VOID_TYPE (_tmp26_)) {
		gboolean _tmp27_ = FALSE;
		ValaCodeContext* _tmp28_ = NULL;
		ValaCodeContext* _tmp29_;
		ValaProfile _tmp30_;
		ValaProfile _tmp31_;
		gboolean _tmp32_;
		gboolean _tmp38_;
		_tmp28_ = vala_code_context_get ();
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_code_context_get_profile (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = _tmp31_ == VALA_PROFILE_DOVA;
		_vala_code_context_unref0 (_tmp29_);
		if (_tmp32_) {
			_tmp27_ = TRUE;
		} else {
			ValaMethod* _tmp33_;
			ValaList* _tmp34_ = NULL;
			ValaList* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			_tmp33_ = m;
			_tmp34_ = vala_method_get_postconditions (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp27_ = _tmp37_ > 0;
			_vala_iterable_unref0 (_tmp35_);
		}
		_tmp38_ = _tmp27_;
		_tmp23_ = _tmp38_;
	} else {
		_tmp23_ = FALSE;
	}
	_tmp39_ = _tmp23_;
	if (_tmp39_) {
		ValaMethod* _tmp40_;
		ValaMethod* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		ValaDataType* _tmp44_ = NULL;
		ValaDataType* _tmp45_;
		ValaSourceReference* _tmp46_;
		ValaSourceReference* _tmp47_;
		ValaLocalVariable* _tmp48_;
		ValaLocalVariable* _tmp49_;
		ValaMethod* _tmp50_;
		ValaLocalVariable* _tmp51_;
		ValaLocalVariable* _tmp52_;
		_tmp40_ = m;
		_tmp41_ = m;
		_tmp42_ = vala_method_get_return_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_copy (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_local_variable_new (_tmp45_, "result", NULL, _tmp47_);
		_tmp49_ = _tmp48_;
		vala_subroutine_set_result_var ((ValaSubroutine*) _tmp40_, _tmp49_);
		_vala_code_node_unref0 (_tmp49_);
		_vala_code_node_unref0 (_tmp45_);
		_tmp50_ = m;
		_tmp51_ = vala_subroutine_get_result_var ((ValaSubroutine*) _tmp50_);
		_tmp52_ = _tmp51_;
		vala_local_variable_set_is_result (_tmp52_, TRUE);
	}
	_tmp53_ = m;
	if (VALA_IS_CREATION_METHOD (_tmp53_)) {
		ValaMethod* _tmp54_;
		const gchar* _tmp55_;
		const gchar* _tmp56_;
		ValaMethod* _tmp59_;
		ValaCreationMethod* _tmp60_;
		ValaCreationMethod* cm;
		gboolean _tmp61_ = FALSE;
		ValaCreationMethod* _tmp62_;
		const gchar* _tmp63_;
		const gchar* _tmp64_;
		gboolean _tmp70_;
		_tmp54_ = m;
		_tmp55_ = vala_symbol_get_name ((ValaSymbol*) _tmp54_);
		_tmp56_ = _tmp55_;
		if (_tmp56_ == NULL) {
			ValaMethod* _tmp57_;
			ValaMethod* _tmp58_;
			_tmp57_ = m;
			vala_struct_set_default_construction_method (self, _tmp57_);
			_tmp58_ = m;
			vala_symbol_set_name ((ValaSymbol*) _tmp58_, ".new");
		}
		_tmp59_ = m;
		_tmp60_ = _vala_code_node_ref0 (VALA_CREATION_METHOD (_tmp59_));
		cm = _tmp60_;
		_tmp62_ = cm;
		_tmp63_ = vala_creation_method_get_class_name (_tmp62_);
		_tmp64_ = _tmp63_;
		if (_tmp64_ != NULL) {
			ValaCreationMethod* _tmp65_;
			const gchar* _tmp66_;
			const gchar* _tmp67_;
			const gchar* _tmp68_;
			const gchar* _tmp69_;
			_tmp65_ = cm;
			_tmp66_ = vala_creation_method_get_class_name (_tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp69_ = _tmp68_;
			_tmp61_ = g_strcmp0 (_tmp67_, _tmp69_) != 0;
		} else {
			_tmp61_ = FALSE;
		}
		_tmp70_ = _tmp61_;
		if (_tmp70_) {
			ValaMethod* _tmp71_;
			ValaSourceReference* _tmp72_;
			ValaSourceReference* _tmp73_;
			gchar* _tmp74_ = NULL;
			gchar* _tmp75_;
			ValaCreationMethod* _tmp76_;
			const gchar* _tmp77_;
			const gchar* _tmp78_;
			gchar* _tmp79_ = NULL;
			gchar* _tmp80_;
			ValaMethod* _tmp81_;
			_tmp71_ = m;
			_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp71_);
			_tmp73_ = _tmp72_;
			_tmp74_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp75_ = _tmp74_;
			_tmp76_ = cm;
			_tmp77_ = vala_creation_method_get_class_name (_tmp76_);
			_tmp78_ = _tmp77_;
			_tmp79_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp75_, _tmp78_);
			_tmp80_ = _tmp79_;
			vala_report_error (_tmp73_, _tmp80_);
			_g_free0 (_tmp80_);
			_g_free0 (_tmp75_);
			_tmp81_ = m;
			vala_code_node_set_error ((ValaCodeNode*) _tmp81_, TRUE);
			_vala_code_node_unref0 (cm);
			return;
		}
		_vala_code_node_unref0 (cm);
	}
	_tmp82_ = self->priv->methods;
	_tmp83_ = m;
	vala_collection_add ((ValaCollection*) _tmp82_, _tmp83_);
	_tmp84_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp85_ = _tmp84_;
	_tmp86_ = m;
	_tmp87_ = vala_symbol_get_name ((ValaSymbol*) _tmp86_);
	_tmp88_ = _tmp87_;
	_tmp89_ = m;
	vala_scope_add (_tmp85_, _tmp88_, (ValaSymbol*) _tmp89_);
}


/**
 * Returns a copy of the list of methods.
 *
 * @return list of methods
 */
ValaList* vala_struct_get_methods (ValaStruct* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->methods;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified property as a member to this struct.
 *
 * @param prop a property
 */
static void vala_struct_real_add_property (ValaSymbol* base, ValaProperty* prop) {
	ValaStruct * self;
	ValaList* _tmp0_;
	ValaProperty* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaProperty* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaProperty* _tmp7_;
	ValaProperty* _tmp8_;
	ValaDataType* _tmp9_ = NULL;
	ValaDataType* _tmp10_;
	ValaParameter* _tmp11_;
	ValaParameter* _tmp12_;
	ValaProperty* _tmp13_;
	ValaScope* _tmp14_;
	ValaScope* _tmp15_;
	ValaProperty* _tmp16_;
	ValaParameter* _tmp17_;
	ValaParameter* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	ValaProperty* _tmp21_;
	ValaParameter* _tmp22_;
	ValaParameter* _tmp23_;
	ValaProperty* _tmp24_;
	ValaField* _tmp25_;
	ValaField* _tmp26_;
	self = (ValaStruct*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->properties;
	_tmp1_ = prop;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = prop;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = prop;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
	_tmp8_ = prop;
	_tmp9_ = vala_semantic_analyzer_get_data_type_for_symbol ((ValaTypeSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_parameter_new ("this", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	vala_property_set_this_parameter (_tmp8_, _tmp12_);
	_vala_code_node_unref0 (_tmp12_);
	_vala_code_node_unref0 (_tmp10_);
	_tmp13_ = prop;
	_tmp14_ = vala_symbol_get_scope ((ValaSymbol*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = prop;
	_tmp17_ = vala_property_get_this_parameter (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = prop;
	_tmp22_ = vala_property_get_this_parameter (_tmp21_);
	_tmp23_ = _tmp22_;
	vala_scope_add (_tmp15_, _tmp20_, (ValaSymbol*) _tmp23_);
	_tmp24_ = prop;
	_tmp25_ = vala_property_get_field (_tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ != NULL) {
		ValaProperty* _tmp27_;
		ValaField* _tmp28_;
		ValaField* _tmp29_;
		_tmp27_ = prop;
		_tmp28_ = vala_property_get_field (_tmp27_);
		_tmp29_ = _tmp28_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp29_);
	}
}


/**
 * Returns a copy of the list of properties.
 *
 * @return list of properties
 */
ValaList* vala_struct_get_properties (ValaStruct* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->properties;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void vala_struct_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaStruct * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaStruct*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_struct (_tmp0_, self);
}


static void vala_struct_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaStruct * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaStruct*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_struct_get_base_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaCodeVisitor* _tmp4_;
		_tmp2_ = vala_struct_get_base_type (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, _tmp4_);
	}
	{
		ValaList* _tmp5_;
		ValaList* _tmp6_;
		ValaList* _p_list;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _p_size;
		gint _p_index;
		_tmp5_ = self->priv->type_parameters;
		_tmp6_ = _vala_iterable_ref0 (_tmp5_);
		_p_list = _tmp6_;
		_tmp7_ = _p_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_p_size = _tmp9_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			ValaList* _tmp13_;
			gint _tmp14_;
			gpointer _tmp15_ = NULL;
			ValaTypeParameter* p;
			ValaTypeParameter* _tmp16_;
			ValaCodeVisitor* _tmp17_;
			_tmp10_ = _p_index;
			_p_index = _tmp10_ + 1;
			_tmp11_ = _p_index;
			_tmp12_ = _p_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _p_list;
			_tmp14_ = _p_index;
			_tmp15_ = vala_list_get (_tmp13_, _tmp14_);
			p = (ValaTypeParameter*) _tmp15_;
			_tmp16_ = p;
			_tmp17_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp16_, _tmp17_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _tmp18_;
		ValaList* _tmp19_;
		ValaList* _f_list;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _f_size;
		gint _f_index;
		_tmp18_ = self->priv->fields;
		_tmp19_ = _vala_iterable_ref0 (_tmp18_);
		_f_list = _tmp19_;
		_tmp20_ = _f_list;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_f_size = _tmp22_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			ValaList* _tmp26_;
			gint _tmp27_;
			gpointer _tmp28_ = NULL;
			ValaField* f;
			ValaField* _tmp29_;
			ValaCodeVisitor* _tmp30_;
			_tmp23_ = _f_index;
			_f_index = _tmp23_ + 1;
			_tmp24_ = _f_index;
			_tmp25_ = _f_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _f_list;
			_tmp27_ = _f_index;
			_tmp28_ = vala_list_get (_tmp26_, _tmp27_);
			f = (ValaField*) _tmp28_;
			_tmp29_ = f;
			_tmp30_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp29_, _tmp30_);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _tmp31_;
		ValaList* _tmp32_;
		ValaList* _c_list;
		ValaList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _c_size;
		gint _c_index;
		_tmp31_ = self->priv->constants;
		_tmp32_ = _vala_iterable_ref0 (_tmp31_);
		_c_list = _tmp32_;
		_tmp33_ = _c_list;
		_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_c_size = _tmp35_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			ValaList* _tmp39_;
			gint _tmp40_;
			gpointer _tmp41_ = NULL;
			ValaConstant* c;
			ValaConstant* _tmp42_;
			ValaCodeVisitor* _tmp43_;
			_tmp36_ = _c_index;
			_c_index = _tmp36_ + 1;
			_tmp37_ = _c_index;
			_tmp38_ = _c_size;
			if (!(_tmp37_ < _tmp38_)) {
				break;
			}
			_tmp39_ = _c_list;
			_tmp40_ = _c_index;
			_tmp41_ = vala_list_get (_tmp39_, _tmp40_);
			c = (ValaConstant*) _tmp41_;
			_tmp42_ = c;
			_tmp43_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp42_, _tmp43_);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _tmp44_;
		ValaList* _tmp45_;
		ValaList* _m_list;
		ValaList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		gint _m_size;
		gint _m_index;
		_tmp44_ = self->priv->methods;
		_tmp45_ = _vala_iterable_ref0 (_tmp44_);
		_m_list = _tmp45_;
		_tmp46_ = _m_list;
		_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_m_size = _tmp48_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			ValaList* _tmp52_;
			gint _tmp53_;
			gpointer _tmp54_ = NULL;
			ValaMethod* m;
			ValaMethod* _tmp55_;
			ValaCodeVisitor* _tmp56_;
			_tmp49_ = _m_index;
			_m_index = _tmp49_ + 1;
			_tmp50_ = _m_index;
			_tmp51_ = _m_size;
			if (!(_tmp50_ < _tmp51_)) {
				break;
			}
			_tmp52_ = _m_list;
			_tmp53_ = _m_index;
			_tmp54_ = vala_list_get (_tmp52_, _tmp53_);
			m = (ValaMethod*) _tmp54_;
			_tmp55_ = m;
			_tmp56_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp55_, _tmp56_);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _tmp57_;
		ValaList* _tmp58_;
		ValaList* _prop_list;
		ValaList* _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		gint _prop_size;
		gint _prop_index;
		_tmp57_ = self->priv->properties;
		_tmp58_ = _vala_iterable_ref0 (_tmp57_);
		_prop_list = _tmp58_;
		_tmp59_ = _prop_list;
		_tmp60_ = vala_collection_get_size ((ValaCollection*) _tmp59_);
		_tmp61_ = _tmp60_;
		_prop_size = _tmp61_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp62_;
			gint _tmp63_;
			gint _tmp64_;
			ValaList* _tmp65_;
			gint _tmp66_;
			gpointer _tmp67_ = NULL;
			ValaProperty* prop;
			ValaProperty* _tmp68_;
			ValaCodeVisitor* _tmp69_;
			_tmp62_ = _prop_index;
			_prop_index = _tmp62_ + 1;
			_tmp63_ = _prop_index;
			_tmp64_ = _prop_size;
			if (!(_tmp63_ < _tmp64_)) {
				break;
			}
			_tmp65_ = _prop_list;
			_tmp66_ = _prop_index;
			_tmp67_ = vala_list_get (_tmp65_, _tmp66_);
			prop = (ValaProperty*) _tmp67_;
			_tmp68_ = prop;
			_tmp69_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp68_, _tmp69_);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
}


/**
 * Returns whether this is a boolean type.
 *
 * @return true if this is a boolean type, false otherwise
 */
static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer __bool_dup0 (gpointer self) {
	return self ? _bool_dup (self) : NULL;
}


gboolean vala_struct_is_boolean_type (ValaStruct* self) {
	gboolean result = FALSE;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* _tmp2_;
	ValaStruct* st;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	gboolean _tmp7_;
	gboolean* _tmp8_;
	gboolean* _tmp13_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	st = _tmp2_;
	_tmp4_ = st;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = st;
		_tmp6_ = vala_struct_is_boolean_type (_tmp5_);
		_tmp3_ = _tmp6_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp7_ = _tmp3_;
	if (_tmp7_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp8_ = self->priv->boolean_type;
	if (_tmp8_ == NULL) {
		ValaAttribute* _tmp9_ = NULL;
		ValaAttribute* _tmp10_;
		gboolean _tmp11_;
		gboolean* _tmp12_;
		_tmp9_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "BooleanType");
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_ != NULL;
		_tmp12_ = __bool_dup0 (&_tmp11_);
		_g_free0 (self->priv->boolean_type);
		self->priv->boolean_type = _tmp12_;
		_vala_code_node_unref0 (_tmp10_);
	}
	_tmp13_ = self->priv->boolean_type;
	result = *_tmp13_;
	_vala_code_node_unref0 (st);
	return result;
}


/**
 * Returns whether this is an integer type.
 *
 * @return true if this is an integer type, false otherwise
 */
gboolean vala_struct_is_integer_type (ValaStruct* self) {
	gboolean result = FALSE;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* _tmp2_;
	ValaStruct* st;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	gboolean _tmp7_;
	gboolean* _tmp8_;
	gboolean* _tmp13_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	st = _tmp2_;
	_tmp4_ = st;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = st;
		_tmp6_ = vala_struct_is_integer_type (_tmp5_);
		_tmp3_ = _tmp6_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp7_ = _tmp3_;
	if (_tmp7_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp8_ = self->priv->integer_type;
	if (_tmp8_ == NULL) {
		ValaAttribute* _tmp9_ = NULL;
		ValaAttribute* _tmp10_;
		gboolean _tmp11_;
		gboolean* _tmp12_;
		_tmp9_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "IntegerType");
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_ != NULL;
		_tmp12_ = __bool_dup0 (&_tmp11_);
		_g_free0 (self->priv->integer_type);
		self->priv->integer_type = _tmp12_;
		_vala_code_node_unref0 (_tmp10_);
	}
	_tmp13_ = self->priv->integer_type;
	result = *_tmp13_;
	_vala_code_node_unref0 (st);
	return result;
}


/**
 * Returns whether this is a floating point type.
 *
 * @return true if this is a floating point type, false otherwise
 */
gboolean vala_struct_is_floating_type (ValaStruct* self) {
	gboolean result = FALSE;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* _tmp2_;
	ValaStruct* st;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	gboolean _tmp7_;
	gboolean* _tmp8_;
	gboolean* _tmp13_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	st = _tmp2_;
	_tmp4_ = st;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = st;
		_tmp6_ = vala_struct_is_floating_type (_tmp5_);
		_tmp3_ = _tmp6_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp7_ = _tmp3_;
	if (_tmp7_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp8_ = self->priv->floating_type;
	if (_tmp8_ == NULL) {
		ValaAttribute* _tmp9_ = NULL;
		ValaAttribute* _tmp10_;
		gboolean _tmp11_;
		gboolean* _tmp12_;
		_tmp9_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "FloatingType");
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_ != NULL;
		_tmp12_ = __bool_dup0 (&_tmp11_);
		_g_free0 (self->priv->floating_type);
		self->priv->floating_type = _tmp12_;
		_vala_code_node_unref0 (_tmp10_);
	}
	_tmp13_ = self->priv->floating_type;
	result = *_tmp13_;
	_vala_code_node_unref0 (st);
	return result;
}


gboolean vala_struct_is_decimal_floating_type (ValaStruct* self) {
	gboolean result = FALSE;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* _tmp2_;
	ValaStruct* st;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	gboolean _tmp7_;
	gboolean* _tmp8_;
	gboolean* _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	st = _tmp2_;
	_tmp4_ = st;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = st;
		_tmp6_ = vala_struct_is_decimal_floating_type (_tmp5_);
		_tmp3_ = _tmp6_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp7_ = _tmp3_;
	if (_tmp7_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp8_ = self->priv->decimal_floating_type;
	if (_tmp8_ == NULL) {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_;
		gboolean* _tmp11_;
		_tmp9_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "FloatingType", "decimal", FALSE);
		_tmp10_ = _tmp9_;
		_tmp11_ = __bool_dup0 (&_tmp10_);
		_g_free0 (self->priv->decimal_floating_type);
		self->priv->decimal_floating_type = _tmp11_;
	}
	_tmp12_ = self->priv->decimal_floating_type;
	result = *_tmp12_;
	_vala_code_node_unref0 (st);
	return result;
}


/**
 * Returns the rank of this integer or floating point type.
 *
 * @return the rank if this is an integer or floating point type
 */
static gint* _int_dup (gint* self) {
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer __int_dup0 (gpointer self) {
	return self ? _int_dup (self) : NULL;
}


gint vala_struct_get_rank (ValaStruct* self) {
	gint result = 0;
	gint* _tmp0_;
	gint* _tmp20_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->rank;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp4_;
		_tmp2_ = vala_struct_is_integer_type (self);
		if (_tmp2_) {
			gboolean _tmp3_ = FALSE;
			_tmp3_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) self, "IntegerType", "rank");
			_tmp1_ = _tmp3_;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp4_ = _tmp1_;
		if (_tmp4_) {
			gint _tmp5_ = 0;
			gint _tmp6_;
			gint* _tmp7_;
			_tmp5_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) self, "IntegerType", "rank", 0);
			_tmp6_ = _tmp5_;
			_tmp7_ = __int_dup0 (&_tmp6_);
			_g_free0 (self->priv->rank);
			self->priv->rank = _tmp7_;
		} else {
			gboolean _tmp8_ = FALSE;
			_tmp8_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) self, "FloatingType", "rank");
			if (_tmp8_) {
				gint _tmp9_ = 0;
				gint _tmp10_;
				gint* _tmp11_;
				_tmp9_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) self, "FloatingType", "rank", 0);
				_tmp10_ = _tmp9_;
				_tmp11_ = __int_dup0 (&_tmp10_);
				_g_free0 (self->priv->rank);
				self->priv->rank = _tmp11_;
			} else {
				ValaStruct* _tmp12_;
				ValaStruct* _tmp13_;
				ValaStruct* _tmp14_;
				ValaStruct* st;
				ValaStruct* _tmp15_;
				_tmp12_ = vala_struct_get_base_struct (self);
				_tmp13_ = _tmp12_;
				_tmp14_ = _vala_code_node_ref0 (_tmp13_);
				st = _tmp14_;
				_tmp15_ = st;
				if (_tmp15_ != NULL) {
					ValaStruct* _tmp16_;
					gint _tmp17_ = 0;
					gint _tmp18_;
					gint* _tmp19_;
					_tmp16_ = st;
					_tmp17_ = vala_struct_get_rank (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = __int_dup0 (&_tmp18_);
					_g_free0 (self->priv->rank);
					self->priv->rank = _tmp19_;
				}
				_vala_code_node_unref0 (st);
			}
		}
	}
	_tmp20_ = self->priv->rank;
	result = *_tmp20_;
	return result;
}


/**
 * Sets the rank of this integer or floating point type.
 *
 * @return the rank if this is an integer or floating point type
 */
void vala_struct_set_rank (ValaStruct* self, gint rank) {
	gint _tmp0_;
	gint* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = rank;
	_tmp1_ = __int_dup0 (&_tmp0_);
	_g_free0 (self->priv->rank);
	self->priv->rank = _tmp1_;
	_tmp2_ = vala_struct_is_integer_type (self);
	if (_tmp2_) {
		gint _tmp3_;
		_tmp3_ = rank;
		vala_code_node_set_attribute_integer ((ValaCodeNode*) self, "IntegerType", "rank", _tmp3_, NULL);
	} else {
		gint _tmp4_;
		_tmp4_ = rank;
		vala_code_node_set_attribute_integer ((ValaCodeNode*) self, "FloatingType", "rank", _tmp4_, NULL);
	}
}


static gint vala_struct_real_get_type_parameter_index (ValaTypeSymbol* base, const gchar* name) {
	ValaStruct * self;
	gint result = 0;
	gint i;
	self = (ValaStruct*) base;
	g_return_val_if_fail (name != NULL, 0);
	i = 0;
	{
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		ValaList* _p_list;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_size;
		gint _p_index;
		_tmp0_ = self->priv->type_parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			ValaTypeParameter* p;
			ValaTypeParameter* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			_tmp5_ = _p_index;
			_p_index = _tmp5_ + 1;
			_tmp6_ = _p_index;
			_tmp7_ = _p_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _p_list;
			_tmp9_ = _p_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			p = (ValaTypeParameter*) _tmp10_;
			_tmp11_ = p;
			_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = name;
			if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
				result = i;
				_vala_code_node_unref0 (p);
				_vala_iterable_unref0 (_p_list);
				return result;
			}
			_tmp15_ = i;
			i = _tmp15_ + 1;
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	result = -1;
	return result;
}


/**
 * Returns whether this struct is a simple type, i.e. whether
 * instances are passed by value.
 */
gboolean vala_struct_is_simple_type (ValaStruct* self) {
	gboolean result = FALSE;
	ValaCodeContext* _tmp0_ = NULL;
	ValaCodeContext* _tmp1_;
	ValaProfile _tmp2_;
	ValaProfile _tmp3_;
	gboolean _tmp4_;
	ValaStruct* _tmp5_;
	ValaStruct* _tmp6_;
	ValaStruct* _tmp7_;
	ValaStruct* st;
	gboolean _tmp8_ = FALSE;
	ValaStruct* _tmp9_;
	gboolean _tmp12_;
	gboolean* _tmp13_;
	gboolean* _tmp30_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_profile (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ == VALA_PROFILE_DOVA;
	_vala_code_context_unref0 (_tmp1_);
	if (_tmp4_) {
		result = TRUE;
		return result;
	}
	_tmp5_ = vala_struct_get_base_struct (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _vala_code_node_ref0 (_tmp6_);
	st = _tmp7_;
	_tmp9_ = st;
	if (_tmp9_ != NULL) {
		ValaStruct* _tmp10_;
		gboolean _tmp11_ = FALSE;
		_tmp10_ = st;
		_tmp11_ = vala_struct_is_simple_type (_tmp10_);
		_tmp8_ = _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	if (_tmp12_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp13_ = self->priv->simple_type;
	if (_tmp13_ == NULL) {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		ValaAttribute* _tmp17_ = NULL;
		ValaAttribute* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp22_;
		gboolean _tmp25_;
		gboolean _tmp28_;
		gboolean* _tmp29_;
		_tmp17_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "SimpleType");
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_ != NULL;
		_vala_code_node_unref0 (_tmp18_);
		if (_tmp19_) {
			_tmp16_ = TRUE;
		} else {
			ValaAttribute* _tmp20_ = NULL;
			ValaAttribute* _tmp21_;
			_tmp20_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "BooleanType");
			_tmp21_ = _tmp20_;
			_tmp16_ = _tmp21_ != NULL;
			_vala_code_node_unref0 (_tmp21_);
		}
		_tmp22_ = _tmp16_;
		if (_tmp22_) {
			_tmp15_ = TRUE;
		} else {
			ValaAttribute* _tmp23_ = NULL;
			ValaAttribute* _tmp24_;
			_tmp23_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "IntegerType");
			_tmp24_ = _tmp23_;
			_tmp15_ = _tmp24_ != NULL;
			_vala_code_node_unref0 (_tmp24_);
		}
		_tmp25_ = _tmp15_;
		if (_tmp25_) {
			_tmp14_ = TRUE;
		} else {
			ValaAttribute* _tmp26_ = NULL;
			ValaAttribute* _tmp27_;
			_tmp26_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "FloatingType");
			_tmp27_ = _tmp26_;
			_tmp14_ = _tmp27_ != NULL;
			_vala_code_node_unref0 (_tmp27_);
		}
		_tmp28_ = _tmp14_;
		_tmp29_ = __bool_dup0 (&_tmp28_);
		_g_free0 (self->priv->simple_type);
		self->priv->simple_type = _tmp29_;
	}
	_tmp30_ = self->priv->simple_type;
	result = *_tmp30_;
	_vala_code_node_unref0 (st);
	return result;
}


/**
 * Marks this struct as simple type, i.e. instances will be passed by
 * value.
 */
void vala_struct_set_simple_type (ValaStruct* self, gboolean simple_type) {
	gboolean _tmp0_;
	gboolean* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = simple_type;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (self->priv->simple_type);
	self->priv->simple_type = _tmp1_;
	_tmp2_ = simple_type;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "SimpleType", _tmp2_, NULL);
}


static void vala_struct_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaStruct * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	self = (ValaStruct*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_struct_get_base_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_type;
	if (_tmp1_ == _tmp2_) {
		ValaDataType* _tmp3_;
		_tmp3_ = new_type;
		vala_struct_set_base_type (self, _tmp3_);
	}
}


static gboolean vala_struct_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t) {
	ValaStruct * self;
	gboolean result = FALSE;
	ValaTypeSymbol* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	self = (ValaStruct*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	_tmp0_ = t;
	if (VALA_TYPESYMBOL (self) == _tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp1_ = vala_struct_get_base_type (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		gboolean _tmp14_;
		_tmp4_ = vala_struct_get_base_type (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_data_type_get_data_type (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ != NULL) {
			ValaDataType* _tmp8_;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			gboolean _tmp13_ = FALSE;
			_tmp8_ = vala_struct_get_base_type (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_data_type_get_data_type (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = t;
			_tmp13_ = vala_typesymbol_is_subtype_of (_tmp11_, _tmp12_);
			_tmp3_ = _tmp13_;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp14_ = _tmp3_;
		if (_tmp14_) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


gboolean vala_struct_is_disposable (ValaStruct* self) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "CCode", "destroy_function");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		ValaList* _f_list;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _f_size;
		gint _f_index;
		_tmp3_ = self->priv->fields;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_f_list = _tmp4_;
		_tmp5_ = _f_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_f_size = _tmp7_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_ = NULL;
			ValaField* f;
			gboolean _tmp14_ = FALSE;
			ValaField* _tmp15_;
			ValaMemberBinding _tmp16_;
			ValaMemberBinding _tmp17_;
			gboolean _tmp22_;
			_tmp8_ = _f_index;
			_f_index = _tmp8_ + 1;
			_tmp9_ = _f_index;
			_tmp10_ = _f_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _f_list;
			_tmp12_ = _f_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			f = (ValaField*) _tmp13_;
			_tmp15_ = f;
			_tmp16_ = vala_field_get_binding (_tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp17_ == VALA_MEMBER_BINDING_INSTANCE) {
				ValaField* _tmp18_;
				ValaDataType* _tmp19_;
				ValaDataType* _tmp20_;
				gboolean _tmp21_ = FALSE;
				_tmp18_ = f;
				_tmp19_ = vala_variable_get_variable_type ((ValaVariable*) _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = vala_data_type_is_disposable (_tmp20_);
				_tmp14_ = _tmp21_;
			} else {
				_tmp14_ = FALSE;
			}
			_tmp22_ = _tmp14_;
			if (_tmp22_) {
				result = TRUE;
				_vala_code_node_unref0 (f);
				_vala_iterable_unref0 (_f_list);
				return result;
			}
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	result = FALSE;
	return result;
}


static gboolean vala_struct_is_recursive_value_type (ValaStruct* self, ValaDataType* type) {
	gboolean result = FALSE;
	ValaDataType* _tmp0_;
	ValaStructValueType* _tmp1_;
	ValaStructValueType* struct_type;
	gboolean _tmp2_ = FALSE;
	ValaStructValueType* _tmp3_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = type;
	_tmp1_ = _vala_code_node_ref0 (VALA_IS_STRUCT_VALUE_TYPE (_tmp0_) ? ((ValaStructValueType*) _tmp0_) : NULL);
	struct_type = _tmp1_;
	_tmp3_ = struct_type;
	if (_tmp3_ != NULL) {
		ValaStructValueType* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = struct_type;
		_tmp5_ = vala_data_type_get_nullable ((ValaDataType*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = !_tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		ValaStructValueType* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		ValaTypeSymbol* _tmp10_;
		ValaStruct* _tmp11_;
		ValaStruct* st;
		ValaStruct* _tmp12_;
		_tmp8_ = struct_type;
		_tmp9_ = vala_value_type_get_type_symbol ((ValaValueType*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _vala_code_node_ref0 (VALA_STRUCT (_tmp10_));
		st = _tmp11_;
		_tmp12_ = st;
		if (_tmp12_ == self) {
			result = TRUE;
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (struct_type);
			return result;
		}
		{
			ValaStruct* _tmp13_;
			ValaList* _tmp14_;
			ValaList* _tmp15_;
			ValaList* _f_list;
			ValaList* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _f_size;
			gint _f_index;
			_tmp13_ = st;
			_tmp14_ = _tmp13_->priv->fields;
			_tmp15_ = _vala_iterable_ref0 (_tmp14_);
			_f_list = _tmp15_;
			_tmp16_ = _f_list;
			_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
			_tmp18_ = _tmp17_;
			_f_size = _tmp18_;
			_f_index = -1;
			while (TRUE) {
				gint _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				ValaList* _tmp22_;
				gint _tmp23_;
				gpointer _tmp24_ = NULL;
				ValaField* f;
				gboolean _tmp25_ = FALSE;
				ValaField* _tmp26_;
				ValaMemberBinding _tmp27_;
				ValaMemberBinding _tmp28_;
				gboolean _tmp33_;
				_tmp19_ = _f_index;
				_f_index = _tmp19_ + 1;
				_tmp20_ = _f_index;
				_tmp21_ = _f_size;
				if (!(_tmp20_ < _tmp21_)) {
					break;
				}
				_tmp22_ = _f_list;
				_tmp23_ = _f_index;
				_tmp24_ = vala_list_get (_tmp22_, _tmp23_);
				f = (ValaField*) _tmp24_;
				_tmp26_ = f;
				_tmp27_ = vala_field_get_binding (_tmp26_);
				_tmp28_ = _tmp27_;
				if (_tmp28_ == VALA_MEMBER_BINDING_INSTANCE) {
					ValaField* _tmp29_;
					ValaDataType* _tmp30_;
					ValaDataType* _tmp31_;
					gboolean _tmp32_ = FALSE;
					_tmp29_ = f;
					_tmp30_ = vala_variable_get_variable_type ((ValaVariable*) _tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = vala_struct_is_recursive_value_type (self, _tmp31_);
					_tmp25_ = _tmp32_;
				} else {
					_tmp25_ = FALSE;
				}
				_tmp33_ = _tmp25_;
				if (_tmp33_) {
					result = TRUE;
					_vala_code_node_unref0 (f);
					_vala_iterable_unref0 (_f_list);
					_vala_code_node_unref0 (st);
					_vala_code_node_unref0 (struct_type);
					return result;
				}
				_vala_code_node_unref0 (f);
			}
			_vala_iterable_unref0 (_f_list);
		}
		_vala_code_node_unref0 (st);
	}
	result = FALSE;
	_vala_code_node_unref0 (struct_type);
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean vala_struct_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaStruct * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaCodeContext* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaSourceFile* old_source_file;
	ValaCodeContext* _tmp10_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaSemanticAnalyzer* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSymbol* old_symbol;
	ValaSourceReference* _tmp16_;
	ValaSourceReference* _tmp17_;
	ValaCodeContext* _tmp25_;
	ValaSemanticAnalyzer* _tmp26_;
	ValaSemanticAnalyzer* _tmp27_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	gboolean _tmp133_ = FALSE;
	gboolean _tmp134_;
	gboolean _tmp135_;
	gboolean _tmp138_;
	ValaCodeContext* _tmp180_;
	ValaSemanticAnalyzer* _tmp181_;
	ValaSemanticAnalyzer* _tmp182_;
	ValaSourceFile* _tmp183_;
	ValaCodeContext* _tmp184_;
	ValaSemanticAnalyzer* _tmp185_;
	ValaSemanticAnalyzer* _tmp186_;
	ValaSymbol* _tmp187_;
	gboolean _tmp188_;
	gboolean _tmp189_;
	self = (ValaStruct*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = context;
	_tmp5_ = vala_code_context_get_analyzer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_source_file (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_source_file_ref0 (_tmp8_);
	old_source_file = _tmp9_;
	_tmp10_ = context;
	_tmp11_ = vala_code_context_get_analyzer (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_semantic_analyzer_get_current_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _vala_code_node_ref0 (_tmp14_);
	old_symbol = _tmp15_;
	_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaCodeContext* _tmp18_;
		ValaSemanticAnalyzer* _tmp19_;
		ValaSemanticAnalyzer* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaSourceReference* _tmp22_;
		ValaSourceFile* _tmp23_;
		ValaSourceFile* _tmp24_;
		_tmp18_ = context;
		_tmp19_ = vala_code_context_get_analyzer (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_source_reference_get_file (_tmp22_);
		_tmp24_ = _tmp23_;
		vala_semantic_analyzer_set_current_source_file (_tmp20_, _tmp24_);
	}
	_tmp25_ = context;
	_tmp26_ = vala_code_context_get_analyzer (_tmp25_);
	_tmp27_ = _tmp26_;
	vala_semantic_analyzer_set_current_symbol (_tmp27_, (ValaSymbol*) self);
	_tmp28_ = vala_struct_get_base_type (self);
	_tmp29_ = _tmp28_;
	if (_tmp29_ != NULL) {
		ValaDataType* _tmp30_;
		ValaDataType* _tmp31_;
		ValaCodeContext* _tmp32_;
		ValaDataType* _tmp33_;
		ValaDataType* _tmp34_;
		_tmp30_ = vala_struct_get_base_type (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp31_, _tmp32_);
		_tmp33_ = vala_struct_get_base_type (self);
		_tmp34_ = _tmp33_;
		if (!VALA_IS_VALUE_TYPE (_tmp34_)) {
			ValaSourceReference* _tmp35_;
			ValaSourceReference* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_;
			gchar* _tmp43_ = NULL;
			gchar* _tmp44_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_struct_get_base_type (self);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_code_node_to_string ((ValaCodeNode*) _tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strdup_printf ("The base type `%s` of struct `%s` is not a struct", _tmp40_, _tmp42_);
			_tmp44_ = _tmp43_;
			vala_report_error (_tmp36_, _tmp44_);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	}
	{
		ValaList* _tmp45_;
		ValaList* _tmp46_;
		ValaList* _p_list;
		ValaList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		gint _p_size;
		gint _p_index;
		_tmp45_ = self->priv->type_parameters;
		_tmp46_ = _vala_iterable_ref0 (_tmp45_);
		_p_list = _tmp46_;
		_tmp47_ = _p_list;
		_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
		_tmp49_ = _tmp48_;
		_p_size = _tmp49_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			ValaList* _tmp53_;
			gint _tmp54_;
			gpointer _tmp55_ = NULL;
			ValaTypeParameter* p;
			ValaTypeParameter* _tmp56_;
			ValaCodeContext* _tmp57_;
			_tmp50_ = _p_index;
			_p_index = _tmp50_ + 1;
			_tmp51_ = _p_index;
			_tmp52_ = _p_size;
			if (!(_tmp51_ < _tmp52_)) {
				break;
			}
			_tmp53_ = _p_list;
			_tmp54_ = _p_index;
			_tmp55_ = vala_list_get (_tmp53_, _tmp54_);
			p = (ValaTypeParameter*) _tmp55_;
			_tmp56_ = p;
			_tmp57_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp56_, _tmp57_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _tmp58_;
		ValaList* _tmp59_;
		ValaList* _f_list;
		ValaList* _tmp60_;
		gint _tmp61_;
		gint _tmp62_;
		gint _f_size;
		gint _f_index;
		_tmp58_ = self->priv->fields;
		_tmp59_ = _vala_iterable_ref0 (_tmp58_);
		_f_list = _tmp59_;
		_tmp60_ = _f_list;
		_tmp61_ = vala_collection_get_size ((ValaCollection*) _tmp60_);
		_tmp62_ = _tmp61_;
		_f_size = _tmp62_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			ValaList* _tmp66_;
			gint _tmp67_;
			gpointer _tmp68_ = NULL;
			ValaField* f;
			ValaField* _tmp69_;
			ValaCodeContext* _tmp70_;
			gboolean _tmp71_ = FALSE;
			ValaField* _tmp72_;
			ValaMemberBinding _tmp73_;
			ValaMemberBinding _tmp74_;
			gboolean _tmp79_;
			gboolean _tmp83_ = FALSE;
			ValaField* _tmp84_;
			ValaMemberBinding _tmp85_;
			ValaMemberBinding _tmp86_;
			gboolean _tmp90_;
			_tmp63_ = _f_index;
			_f_index = _tmp63_ + 1;
			_tmp64_ = _f_index;
			_tmp65_ = _f_size;
			if (!(_tmp64_ < _tmp65_)) {
				break;
			}
			_tmp66_ = _f_list;
			_tmp67_ = _f_index;
			_tmp68_ = vala_list_get (_tmp66_, _tmp67_);
			f = (ValaField*) _tmp68_;
			_tmp69_ = f;
			_tmp70_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp69_, _tmp70_);
			_tmp72_ = f;
			_tmp73_ = vala_field_get_binding (_tmp72_);
			_tmp74_ = _tmp73_;
			if (_tmp74_ == VALA_MEMBER_BINDING_INSTANCE) {
				ValaField* _tmp75_;
				ValaDataType* _tmp76_;
				ValaDataType* _tmp77_;
				gboolean _tmp78_ = FALSE;
				_tmp75_ = f;
				_tmp76_ = vala_variable_get_variable_type ((ValaVariable*) _tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_struct_is_recursive_value_type (self, _tmp77_);
				_tmp71_ = _tmp78_;
			} else {
				_tmp71_ = FALSE;
			}
			_tmp79_ = _tmp71_;
			if (_tmp79_) {
				ValaField* _tmp80_;
				ValaSourceReference* _tmp81_;
				ValaSourceReference* _tmp82_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp80_ = f;
				_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp80_);
				_tmp82_ = _tmp81_;
				vala_report_error (_tmp82_, "Recursive value types are not allowed");
				result = FALSE;
				_vala_code_node_unref0 (f);
				_vala_iterable_unref0 (_f_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp84_ = f;
			_tmp85_ = vala_field_get_binding (_tmp84_);
			_tmp86_ = _tmp85_;
			if (_tmp86_ == VALA_MEMBER_BINDING_INSTANCE) {
				ValaField* _tmp87_;
				ValaExpression* _tmp88_;
				ValaExpression* _tmp89_;
				_tmp87_ = f;
				_tmp88_ = vala_variable_get_initializer ((ValaVariable*) _tmp87_);
				_tmp89_ = _tmp88_;
				_tmp83_ = _tmp89_ != NULL;
			} else {
				_tmp83_ = FALSE;
			}
			_tmp90_ = _tmp83_;
			if (_tmp90_) {
				ValaField* _tmp91_;
				ValaSourceReference* _tmp92_;
				ValaSourceReference* _tmp93_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp91_ = f;
				_tmp92_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp91_);
				_tmp93_ = _tmp92_;
				vala_report_error (_tmp93_, "Instance field initializers not supported");
				result = FALSE;
				_vala_code_node_unref0 (f);
				_vala_iterable_unref0 (_f_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _tmp94_;
		ValaList* _tmp95_;
		ValaList* _c_list;
		ValaList* _tmp96_;
		gint _tmp97_;
		gint _tmp98_;
		gint _c_size;
		gint _c_index;
		_tmp94_ = self->priv->constants;
		_tmp95_ = _vala_iterable_ref0 (_tmp94_);
		_c_list = _tmp95_;
		_tmp96_ = _c_list;
		_tmp97_ = vala_collection_get_size ((ValaCollection*) _tmp96_);
		_tmp98_ = _tmp97_;
		_c_size = _tmp98_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp99_;
			gint _tmp100_;
			gint _tmp101_;
			ValaList* _tmp102_;
			gint _tmp103_;
			gpointer _tmp104_ = NULL;
			ValaConstant* c;
			ValaConstant* _tmp105_;
			ValaCodeContext* _tmp106_;
			_tmp99_ = _c_index;
			_c_index = _tmp99_ + 1;
			_tmp100_ = _c_index;
			_tmp101_ = _c_size;
			if (!(_tmp100_ < _tmp101_)) {
				break;
			}
			_tmp102_ = _c_list;
			_tmp103_ = _c_index;
			_tmp104_ = vala_list_get (_tmp102_, _tmp103_);
			c = (ValaConstant*) _tmp104_;
			_tmp105_ = c;
			_tmp106_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp105_, _tmp106_);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _tmp107_;
		ValaList* _tmp108_;
		ValaList* _m_list;
		ValaList* _tmp109_;
		gint _tmp110_;
		gint _tmp111_;
		gint _m_size;
		gint _m_index;
		_tmp107_ = self->priv->methods;
		_tmp108_ = _vala_iterable_ref0 (_tmp107_);
		_m_list = _tmp108_;
		_tmp109_ = _m_list;
		_tmp110_ = vala_collection_get_size ((ValaCollection*) _tmp109_);
		_tmp111_ = _tmp110_;
		_m_size = _tmp111_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp112_;
			gint _tmp113_;
			gint _tmp114_;
			ValaList* _tmp115_;
			gint _tmp116_;
			gpointer _tmp117_ = NULL;
			ValaMethod* m;
			ValaMethod* _tmp118_;
			ValaCodeContext* _tmp119_;
			_tmp112_ = _m_index;
			_m_index = _tmp112_ + 1;
			_tmp113_ = _m_index;
			_tmp114_ = _m_size;
			if (!(_tmp113_ < _tmp114_)) {
				break;
			}
			_tmp115_ = _m_list;
			_tmp116_ = _m_index;
			_tmp117_ = vala_list_get (_tmp115_, _tmp116_);
			m = (ValaMethod*) _tmp117_;
			_tmp118_ = m;
			_tmp119_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp118_, _tmp119_);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _tmp120_;
		ValaList* _tmp121_;
		ValaList* _prop_list;
		ValaList* _tmp122_;
		gint _tmp123_;
		gint _tmp124_;
		gint _prop_size;
		gint _prop_index;
		_tmp120_ = self->priv->properties;
		_tmp121_ = _vala_iterable_ref0 (_tmp120_);
		_prop_list = _tmp121_;
		_tmp122_ = _prop_list;
		_tmp123_ = vala_collection_get_size ((ValaCollection*) _tmp122_);
		_tmp124_ = _tmp123_;
		_prop_size = _tmp124_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp125_;
			gint _tmp126_;
			gint _tmp127_;
			ValaList* _tmp128_;
			gint _tmp129_;
			gpointer _tmp130_ = NULL;
			ValaProperty* prop;
			ValaProperty* _tmp131_;
			ValaCodeContext* _tmp132_;
			_tmp125_ = _prop_index;
			_prop_index = _tmp125_ + 1;
			_tmp126_ = _prop_index;
			_tmp127_ = _prop_size;
			if (!(_tmp126_ < _tmp127_)) {
				break;
			}
			_tmp128_ = _prop_list;
			_tmp129_ = _prop_index;
			_tmp130_ = vala_list_get (_tmp128_, _tmp129_);
			prop = (ValaProperty*) _tmp130_;
			_tmp131_ = prop;
			_tmp132_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp131_, _tmp132_);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_tmp134_ = vala_symbol_get_external ((ValaSymbol*) self);
	_tmp135_ = _tmp134_;
	if (!_tmp135_) {
		gboolean _tmp136_;
		gboolean _tmp137_;
		_tmp136_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp137_ = _tmp136_;
		_tmp133_ = !_tmp137_;
	} else {
		_tmp133_ = FALSE;
	}
	_tmp138_ = _tmp133_;
	if (_tmp138_) {
		gboolean _tmp139_ = FALSE;
		gboolean _tmp140_ = FALSE;
		gboolean _tmp141_ = FALSE;
		gboolean _tmp142_ = FALSE;
		ValaDataType* _tmp143_;
		ValaDataType* _tmp144_;
		gboolean _tmp149_;
		gboolean _tmp151_;
		gboolean _tmp153_;
		gboolean _tmp155_;
		_tmp143_ = vala_struct_get_base_type (self);
		_tmp144_ = _tmp143_;
		if (_tmp144_ == NULL) {
			ValaList* _tmp145_ = NULL;
			ValaList* _tmp146_;
			gint _tmp147_;
			gint _tmp148_;
			_tmp145_ = vala_struct_get_fields (self);
			_tmp146_ = _tmp145_;
			_tmp147_ = vala_collection_get_size ((ValaCollection*) _tmp146_);
			_tmp148_ = _tmp147_;
			_tmp142_ = _tmp148_ == 0;
			_vala_iterable_unref0 (_tmp146_);
		} else {
			_tmp142_ = FALSE;
		}
		_tmp149_ = _tmp142_;
		if (_tmp149_) {
			gboolean _tmp150_ = FALSE;
			_tmp150_ = vala_struct_is_boolean_type (self);
			_tmp141_ = !_tmp150_;
		} else {
			_tmp141_ = FALSE;
		}
		_tmp151_ = _tmp141_;
		if (_tmp151_) {
			gboolean _tmp152_ = FALSE;
			_tmp152_ = vala_struct_is_integer_type (self);
			_tmp140_ = !_tmp152_;
		} else {
			_tmp140_ = FALSE;
		}
		_tmp153_ = _tmp140_;
		if (_tmp153_) {
			gboolean _tmp154_ = FALSE;
			_tmp154_ = vala_struct_is_floating_type (self);
			_tmp139_ = !_tmp154_;
		} else {
			_tmp139_ = FALSE;
		}
		_tmp155_ = _tmp139_;
		if (_tmp155_) {
			ValaSourceReference* _tmp156_;
			ValaSourceReference* _tmp157_;
			const gchar* _tmp158_;
			const gchar* _tmp159_;
			gchar* _tmp160_ = NULL;
			gchar* _tmp161_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp156_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp157_ = _tmp156_;
			_tmp158_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp159_ = _tmp158_;
			_tmp160_ = g_strdup_printf ("structs cannot be empty: %s", _tmp159_);
			_tmp161_ = _tmp160_;
			vala_report_error (_tmp157_, _tmp161_);
			_g_free0 (_tmp161_);
		} else {
			ValaDataType* _tmp162_;
			ValaDataType* _tmp163_;
			_tmp162_ = vala_struct_get_base_type (self);
			_tmp163_ = _tmp162_;
			if (_tmp163_ != NULL) {
				{
					ValaList* _tmp164_;
					ValaList* _tmp165_;
					ValaList* _f_list;
					ValaList* _tmp166_;
					gint _tmp167_;
					gint _tmp168_;
					gint _f_size;
					gint _f_index;
					_tmp164_ = self->priv->fields;
					_tmp165_ = _vala_iterable_ref0 (_tmp164_);
					_f_list = _tmp165_;
					_tmp166_ = _f_list;
					_tmp167_ = vala_collection_get_size ((ValaCollection*) _tmp166_);
					_tmp168_ = _tmp167_;
					_f_size = _tmp168_;
					_f_index = -1;
					while (TRUE) {
						gint _tmp169_;
						gint _tmp170_;
						gint _tmp171_;
						ValaList* _tmp172_;
						gint _tmp173_;
						gpointer _tmp174_ = NULL;
						ValaField* f;
						ValaField* _tmp175_;
						ValaMemberBinding _tmp176_;
						ValaMemberBinding _tmp177_;
						_tmp169_ = _f_index;
						_f_index = _tmp169_ + 1;
						_tmp170_ = _f_index;
						_tmp171_ = _f_size;
						if (!(_tmp170_ < _tmp171_)) {
							break;
						}
						_tmp172_ = _f_list;
						_tmp173_ = _f_index;
						_tmp174_ = vala_list_get (_tmp172_, _tmp173_);
						f = (ValaField*) _tmp174_;
						_tmp175_ = f;
						_tmp176_ = vala_field_get_binding (_tmp175_);
						_tmp177_ = _tmp176_;
						if (_tmp177_ == VALA_MEMBER_BINDING_INSTANCE) {
							ValaSourceReference* _tmp178_;
							ValaSourceReference* _tmp179_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp178_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp179_ = _tmp178_;
							vala_report_error (_tmp179_, "derived structs may not have instance fields");
							_vala_code_node_unref0 (f);
							break;
						}
						_vala_code_node_unref0 (f);
					}
					_vala_iterable_unref0 (_f_list);
				}
			}
		}
	}
	_tmp180_ = context;
	_tmp181_ = vala_code_context_get_analyzer (_tmp180_);
	_tmp182_ = _tmp181_;
	_tmp183_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp182_, _tmp183_);
	_tmp184_ = context;
	_tmp185_ = vala_code_context_get_analyzer (_tmp184_);
	_tmp186_ = _tmp185_;
	_tmp187_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp186_, _tmp187_);
	_tmp188_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp189_ = _tmp188_;
	result = !_tmp189_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaDataType* vala_struct_get_base_type (ValaStruct* self) {
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_type;
	result = _tmp0_;
	return result;
}


void vala_struct_set_base_type (ValaStruct* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp0_, (ValaCodeNode*) self);
	_tmp1_ = value;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	_vala_code_node_unref0 (self->priv->_base_type);
	self->priv->_base_type = _tmp2_;
}


ValaStruct* vala_struct_get_base_struct (ValaStruct* self) {
	ValaStruct* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_type;
	if (_tmp0_ != NULL) {
		ValaDataType* _tmp1_;
		ValaTypeSymbol* _tmp2_;
		ValaTypeSymbol* _tmp3_;
		_tmp1_ = self->priv->_base_type;
		_tmp2_ = vala_data_type_get_data_type (_tmp1_);
		_tmp3_ = _tmp2_;
		result = VALA_IS_STRUCT (_tmp3_) ? ((ValaStruct*) _tmp3_) : NULL;
		return result;
	}
	result = NULL;
	return result;
}


ValaMethod* vala_struct_get_default_construction_method (ValaStruct* self) {
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}


void vala_struct_set_default_construction_method (ValaStruct* self, ValaMethod* value) {
	ValaMethod* _tmp0_;
	ValaMethod* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp1_;
}


gboolean vala_struct_get_is_immutable (ValaStruct* self) {
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_ = NULL;
		ValaAttribute* _tmp2_;
		gboolean _tmp3_;
		gboolean* _tmp4_;
		_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_ != NULL;
		_tmp4_ = __bool_dup0 (&_tmp3_);
		_g_free0 (self->priv->_is_immutable);
		self->priv->_is_immutable = _tmp4_;
		_vala_code_node_unref0 (_tmp2_);
	}
	_tmp5_ = self->priv->_is_immutable;
	result = *_tmp5_;
	return result;
}


void vala_struct_set_is_immutable (ValaStruct* self, gboolean value) {
	gboolean _tmp0_;
	gboolean* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (self->priv->_is_immutable);
	self->priv->_is_immutable = _tmp1_;
	_tmp2_ = value;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Immutable", _tmp2_, NULL);
}


gint vala_struct_get_width (ValaStruct* self) {
	gint result;
	gint* _tmp0_;
	gint* _tmp8_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_width;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		_tmp1_ = vala_struct_is_integer_type (self);
		if (_tmp1_) {
			gint _tmp2_ = 0;
			gint _tmp3_;
			gint* _tmp4_;
			_tmp2_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) self, "IntegerType", "width", 32);
			_tmp3_ = _tmp2_;
			_tmp4_ = __int_dup0 (&_tmp3_);
			_g_free0 (self->priv->_width);
			self->priv->_width = _tmp4_;
		} else {
			gint _tmp5_ = 0;
			gint _tmp6_;
			gint* _tmp7_;
			_tmp5_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) self, "FloatingType", "width", 32);
			_tmp6_ = _tmp5_;
			_tmp7_ = __int_dup0 (&_tmp6_);
			_g_free0 (self->priv->_width);
			self->priv->_width = _tmp7_;
		}
	}
	_tmp8_ = self->priv->_width;
	result = *_tmp8_;
	return result;
}


void vala_struct_set_width (ValaStruct* self, gint value) {
	gint _tmp0_;
	gint* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __int_dup0 (&_tmp0_);
	_g_free0 (self->priv->_width);
	self->priv->_width = _tmp1_;
	_tmp2_ = vala_struct_is_integer_type (self);
	if (_tmp2_) {
		gint _tmp3_;
		_tmp3_ = value;
		vala_code_node_set_attribute_integer ((ValaCodeNode*) self, "IntegerType", "width", _tmp3_, NULL);
	} else {
		gint _tmp4_;
		_tmp4_ = value;
		vala_code_node_set_attribute_integer ((ValaCodeNode*) self, "FloatingType", "width", _tmp4_, NULL);
	}
}


gboolean vala_struct_get_signed (ValaStruct* self) {
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_signed;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_;
		gboolean* _tmp3_;
		_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "IntegerType", "signed", TRUE);
		_tmp2_ = _tmp1_;
		_tmp3_ = __bool_dup0 (&_tmp2_);
		_g_free0 (self->priv->_signed);
		self->priv->_signed = _tmp3_;
	}
	_tmp4_ = self->priv->_signed;
	result = *_tmp4_;
	return result;
}


void vala_struct_set_signed (ValaStruct* self, gboolean value) {
	gboolean _tmp0_;
	gboolean* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (self->priv->_signed);
	self->priv->_signed = _tmp1_;
	_tmp2_ = value;
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "IntegerType", "signed", _tmp2_, NULL);
}


static void vala_struct_class_init (ValaStructClass * klass) {
	vala_struct_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_struct_finalize;
	g_type_class_add_private (klass, sizeof (ValaStructPrivate));
	VALA_SYMBOL_CLASS (klass)->add_constant = vala_struct_real_add_constant;
	VALA_SYMBOL_CLASS (klass)->add_field = vala_struct_real_add_field;
	VALA_SYMBOL_CLASS (klass)->add_method = vala_struct_real_add_method;
	VALA_SYMBOL_CLASS (klass)->add_property = vala_struct_real_add_property;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_struct_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_struct_real_accept_children;
	VALA_TYPESYMBOL_CLASS (klass)->get_type_parameter_index = vala_struct_real_get_type_parameter_index;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_struct_real_replace_type;
	VALA_TYPESYMBOL_CLASS (klass)->is_subtype_of = vala_struct_real_is_subtype_of;
	VALA_CODE_NODE_CLASS (klass)->check = vala_struct_real_check;
}


static void vala_struct_instance_init (ValaStruct * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	GEqualFunc _tmp8_;
	ValaArrayList* _tmp9_;
	self->priv = VALA_STRUCT_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp0_);
	self->priv->type_parameters = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp2_);
	self->priv->constants = (ValaList*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp4_);
	self->priv->fields = (ValaList*) _tmp5_;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp6_);
	self->priv->methods = (ValaList*) _tmp7_;
	_tmp8_ = g_direct_equal;
	_tmp9_ = vala_array_list_new (VALA_TYPE_PROPERTY, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp8_);
	self->priv->properties = (ValaList*) _tmp9_;
	self->priv->_base_type = NULL;
}


static void vala_struct_finalize (ValaCodeNode* obj) {
	ValaStruct * self;
	self = VALA_STRUCT (obj);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_iterable_unref0 (self->priv->constants);
	_vala_iterable_unref0 (self->priv->fields);
	_vala_iterable_unref0 (self->priv->methods);
	_vala_iterable_unref0 (self->priv->properties);
	_vala_code_node_unref0 (self->priv->_base_type);
	_g_free0 (self->priv->boolean_type);
	_g_free0 (self->priv->integer_type);
	_g_free0 (self->priv->floating_type);
	_g_free0 (self->priv->decimal_floating_type);
	_g_free0 (self->priv->simple_type);
	_g_free0 (self->priv->rank);
	_g_free0 (self->priv->_width);
	_g_free0 (self->priv->_signed);
	_g_free0 (self->priv->_is_immutable);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	VALA_CODE_NODE_CLASS (vala_struct_parent_class)->finalize (obj);
}


/**
 * Represents a struct declaration in the source code.
 */
GType vala_struct_get_type (void) {
	static volatile gsize vala_struct_type_id__volatile = 0;
	if (g_once_init_enter (&vala_struct_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaStructClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_struct_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaStruct), 0, (GInstanceInitFunc) vala_struct_instance_init, NULL };
		GType vala_struct_type_id;
		vala_struct_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaStruct", &g_define_type_info, 0);
		g_once_init_leave (&vala_struct_type_id__volatile, vala_struct_type_id);
	}
	return vala_struct_type_id__volatile;
}



