/* valagsignalmodule.c generated by valac, the Vala compiler
 * generated from valagsignalmodule.vala, do not modify */

/* valagsignalmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>


#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT (vala_ccode_base_module_emit_context_get_type ())
#define VALA_CCODE_BASE_MODULE_EMIT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT, ValaCCodeBaseModuleEmitContext))
#define VALA_CCODE_BASE_MODULE_EMIT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT, ValaCCodeBaseModuleEmitContextClass))
#define VALA_CCODE_BASE_MODULE_IS_EMIT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT))
#define VALA_CCODE_BASE_MODULE_IS_EMIT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT))
#define VALA_CCODE_BASE_MODULE_EMIT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT, ValaCCodeBaseModuleEmitContextClass))

typedef struct _ValaCCodeBaseModuleEmitContext ValaCCodeBaseModuleEmitContext;
typedef struct _ValaCCodeBaseModuleEmitContextClass ValaCCodeBaseModuleEmitContextClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_ARRAY_MODULE (vala_ccode_array_module_get_type ())
#define VALA_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModule))
#define VALA_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))
#define VALA_IS_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_IS_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_CCODE_ARRAY_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))

typedef struct _ValaCCodeArrayModule ValaCCodeArrayModule;
typedef struct _ValaCCodeArrayModuleClass ValaCCodeArrayModuleClass;
typedef struct _ValaCCodeArrayModulePrivate ValaCCodeArrayModulePrivate;

#define VALA_TYPE_CCODE_DELEGATE_MODULE (vala_ccode_delegate_module_get_type ())
#define VALA_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule))
#define VALA_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))
#define VALA_IS_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_IS_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_CCODE_DELEGATE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))

typedef struct _ValaCCodeDelegateModule ValaCCodeDelegateModule;
typedef struct _ValaCCodeDelegateModuleClass ValaCCodeDelegateModuleClass;
typedef struct _ValaCCodeDelegateModulePrivate ValaCCodeDelegateModulePrivate;

#define VALA_TYPE_GERROR_MODULE (vala_gerror_module_get_type ())
#define VALA_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModule))
#define VALA_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))
#define VALA_IS_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GERROR_MODULE))
#define VALA_IS_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GERROR_MODULE))
#define VALA_GERROR_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))

typedef struct _ValaGErrorModule ValaGErrorModule;
typedef struct _ValaGErrorModuleClass ValaGErrorModuleClass;
typedef struct _ValaGErrorModulePrivate ValaGErrorModulePrivate;

#define VALA_TYPE_GTYPE_MODULE (vala_gtype_module_get_type ())
#define VALA_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModule))
#define VALA_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))
#define VALA_IS_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GTYPE_MODULE))
#define VALA_IS_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GTYPE_MODULE))
#define VALA_GTYPE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))

typedef struct _ValaGTypeModule ValaGTypeModule;
typedef struct _ValaGTypeModuleClass ValaGTypeModuleClass;
typedef struct _ValaGTypeModulePrivate ValaGTypeModulePrivate;

#define VALA_TYPE_GOBJECT_MODULE (vala_gobject_module_get_type ())
#define VALA_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule))
#define VALA_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))
#define VALA_IS_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GOBJECT_MODULE))
#define VALA_IS_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GOBJECT_MODULE))
#define VALA_GOBJECT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))

typedef struct _ValaGObjectModule ValaGObjectModule;
typedef struct _ValaGObjectModuleClass ValaGObjectModuleClass;
typedef struct _ValaGObjectModulePrivate ValaGObjectModulePrivate;

#define VALA_TYPE_GSIGNAL_MODULE (vala_gsignal_module_get_type ())
#define VALA_GSIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule))
#define VALA_GSIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModuleClass))
#define VALA_IS_GSIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GSIGNAL_MODULE))
#define VALA_IS_GSIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GSIGNAL_MODULE))
#define VALA_GSIGNAL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModuleClass))

typedef struct _ValaGSignalModule ValaGSignalModule;
typedef struct _ValaGSignalModuleClass ValaGSignalModuleClass;
typedef struct _ValaGSignalModulePrivate ValaGSignalModulePrivate;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaCCodeBaseModule {
	ValaCodeGenerator parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaCCodeBaseModuleEmitContext* emit_context;
	ValaCCodeFile* header_file;
	ValaCCodeFile* internal_header_file;
	ValaCCodeFile* cfile;
	ValaCCodeBaseModuleEmitContext* class_init_context;
	ValaCCodeBaseModuleEmitContext* base_init_context;
	ValaCCodeBaseModuleEmitContext* class_finalize_context;
	ValaCCodeBaseModuleEmitContext* base_finalize_context;
	ValaCCodeBaseModuleEmitContext* instance_init_context;
	ValaCCodeBaseModuleEmitContext* instance_finalize_context;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaSet* user_marshal_set;
	ValaSet* predefined_marshal_set;
	gint next_regex_id;
	gboolean in_constructor;
	gboolean in_static_or_class_context;
	gint next_coroutine_state;
	ValaDataType* void_type;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* regex_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaClass* gnode_type;
	ValaClass* gvaluearray_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaTypeSymbol* gthreadpool_type;
	ValaDataType* gdestroynotify_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaClass* gvariant_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_proxy_type;
	gboolean in_plugin;
	gchar* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	ValaSet* wrappers;
};

struct _ValaCCodeBaseModuleClass {
	ValaCodeGeneratorClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	gboolean (*generate_enum_declaration) (ValaCCodeBaseModule* self, ValaEnum* en, ValaCCodeFile* decl_space);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeFile* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeFile* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeFile* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeFile* decl_space, ValaMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, ValaMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
	gchar* (*append_struct_array_free) (ValaCCodeBaseModule* self, ValaStruct* st);
	ValaCCodeExpression* (*destroy_value) (ValaCCodeBaseModule* self, ValaTargetValue* value, gboolean is_macro_definition);
	void (*append_scope_free) (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCodeNode* stop_at);
	ValaTargetValue* (*get_local_cvalue) (ValaCCodeBaseModule* self, ValaLocalVariable* local);
	ValaTargetValue* (*get_parameter_cvalue) (ValaCCodeBaseModule* self, ValaParameter* param);
	ValaTargetValue* (*get_field_cvalue) (ValaCCodeBaseModule* self, ValaField* field, ValaTargetValue* instance);
	ValaTargetValue* (*load_this_parameter) (ValaCCodeBaseModule* self, ValaTypeSymbol* sym);
	void (*store_value) (ValaCCodeBaseModule* self, ValaTargetValue* lvalue, ValaTargetValue* value);
	gchar* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const gchar* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr, ValaCCodeExpression** delegate_target_destroy_notify);
	ValaCCodeExpression* (*get_delegate_target_cvalue) (ValaCCodeBaseModule* self, ValaTargetValue* value);
	ValaCCodeExpression* (*get_delegate_target_destroy_notify_cvalue) (ValaCCodeBaseModule* self, ValaTargetValue* value);
	gchar* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const gchar* delegate_cname);
	ValaTargetValue* (*copy_value) (ValaCCodeBaseModule* self, ValaTargetValue* value, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeFile* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeFile* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeFile* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeFile* decl_space);
	ValaCCodeExpression* (*deserialize_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaCCodeExpression* variant_expr, ValaCCodeExpression* expr, ValaCCodeExpression* error_expr, gboolean* may_fail);
	ValaCCodeExpression* (*serialize_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaCCodeExpression* expr);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaCodeNode* node);
	gboolean (*is_gobject_property) (ValaCCodeBaseModule* self, ValaProperty* prop);
	gchar* (*get_custom_creturn_type) (ValaCCodeBaseModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeBaseModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeBaseModule* self, ValaMethod* method);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeBaseModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeBaseModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	void (*register_dbus_info) (ValaCCodeBaseModule* self, ValaCCodeBlock* block, ValaObjectTypeSymbol* bindable);
	gchar* (*get_dynamic_property_getter_cname) (ValaCCodeBaseModule* self, ValaDynamicProperty* node);
	gchar* (*get_dynamic_property_setter_cname) (ValaCCodeBaseModule* self, ValaDynamicProperty* node);
	gchar* (*get_dynamic_signal_cname) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	gchar* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	gchar* (*get_dynamic_signal_connect_after_wrapper_name) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	gchar* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	gchar* (*get_array_length_cname) (ValaCCodeBaseModule* self, const gchar* array_cname, gint dim);
	gchar* (*get_parameter_array_length_cname) (ValaCCodeBaseModule* self, ValaParameter* param, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeBaseModule* self, ValaExpression* array_expr, gint dim);
	ValaCCodeExpression* (*get_array_length_cvalue) (ValaCCodeBaseModule* self, ValaTargetValue* value, gint dim);
	gchar* (*get_array_size_cname) (ValaCCodeBaseModule* self, const gchar* array_cname);
	void (*add_simple_check) (ValaCCodeBaseModule* self, ValaCodeNode* node, gboolean always_fails);
	gchar* (*generate_ready_function) (ValaCCodeBaseModule* self, ValaMethod* m);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeFile* decl_space, ValaCCodeFunction* cfunc, ValaMap* cparam_map, ValaMap* carg_map);
	ValaCCodeParameter* (*generate_parameter) (ValaCCodeMethodModule* self, ValaParameter* param, ValaCCodeFile* decl_space, ValaMap* cparam_map, ValaMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};

struct _ValaCCodeArrayModule {
	ValaCCodeMethodCallModule parent_instance;
	ValaCCodeArrayModulePrivate * priv;
};

struct _ValaCCodeArrayModuleClass {
	ValaCCodeMethodCallModuleClass parent_class;
};

struct _ValaCCodeDelegateModule {
	ValaCCodeArrayModule parent_instance;
	ValaCCodeDelegateModulePrivate * priv;
};

struct _ValaCCodeDelegateModuleClass {
	ValaCCodeArrayModuleClass parent_class;
};

struct _ValaGErrorModule {
	ValaCCodeDelegateModule parent_instance;
	ValaGErrorModulePrivate * priv;
};

struct _ValaGErrorModuleClass {
	ValaCCodeDelegateModuleClass parent_class;
	void (*return_with_exception) (ValaGErrorModule* self, ValaCCodeExpression* error_expr);
};

struct _ValaGTypeModule {
	ValaGErrorModule parent_instance;
	ValaGTypeModulePrivate * priv;
};

struct _ValaGTypeModuleClass {
	ValaGErrorModuleClass parent_class;
	void (*generate_virtual_method_declaration) (ValaGTypeModule* self, ValaMethod* m, ValaCCodeFile* decl_space, ValaCCodeStruct* type_struct);
	void (*generate_class_init) (ValaGTypeModule* self, ValaClass* cl);
};

struct _ValaGObjectModule {
	ValaGTypeModule parent_instance;
	ValaGObjectModulePrivate * priv;
};

struct _ValaGObjectModuleClass {
	ValaGTypeModuleClass parent_class;
};

struct _ValaGSignalModule {
	ValaGObjectModule parent_instance;
	ValaGSignalModulePrivate * priv;
};

struct _ValaGSignalModuleClass {
	ValaGObjectModuleClass parent_class;
};


static gpointer vala_gsignal_module_parent_class = NULL;

GType vala_ccode_base_module_get_type (void) G_GNUC_CONST;
gpointer vala_ccode_base_module_emit_context_ref (gpointer instance);
void vala_ccode_base_module_emit_context_unref (gpointer instance);
GParamSpec* vala_ccode_base_module_param_spec_emit_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_ccode_base_module_value_set_emit_context (GValue* value, gpointer v_object);
void vala_ccode_base_module_value_take_emit_context (GValue* value, gpointer v_object);
gpointer vala_ccode_base_module_value_get_emit_context (const GValue* value);
GType vala_ccode_base_module_emit_context_get_type (void) G_GNUC_CONST;
GType vala_ccode_struct_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_method_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_control_flow_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_member_access_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_assignment_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_method_call_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_array_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_delegate_module_get_type (void) G_GNUC_CONST;
GType vala_gerror_module_get_type (void) G_GNUC_CONST;
GType vala_gtype_module_get_type (void) G_GNUC_CONST;
GType vala_gobject_module_get_type (void) G_GNUC_CONST;
GType vala_gsignal_module_get_type (void) G_GNUC_CONST;
enum  {
	VALA_GSIGNAL_MODULE_DUMMY_PROPERTY
};
static gchar* vala_gsignal_module_get_marshaller_type_name (ValaGSignalModule* self, ValaDataType* t);
static gchar* vala_gsignal_module_get_marshaller_type_name_for_parameter (ValaGSignalModule* self, ValaParameter* param);
static gchar* vala_gsignal_module_get_marshaller_function (ValaGSignalModule* self, ValaList* params, ValaDataType* return_type, const gchar* prefix);
static gchar* vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self, ValaList* params, ValaDataType* return_type);
static gchar* vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self, ValaDataType* t);
static gchar* vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self, ValaParameter* p);
static ValaCCodeExpression* vala_gsignal_module_get_signal_name_cexpression (ValaGSignalModule* self, ValaSignal* sig, ValaExpression* detail_expr, ValaCodeNode* node);
ValaLocalVariable* vala_ccode_base_module_get_temp_variable (ValaCCodeBaseModule* self, ValaDataType* type, gboolean value_owned, ValaCodeNode* node_reference, gboolean init);
void vala_ccode_base_module_emit_temp_var (ValaCCodeBaseModule* self, ValaLocalVariable* local, gboolean always_init);
ValaArrayList* vala_ccode_base_module_get_temp_ref_vars (ValaCCodeBaseModule* self);
ValaCCodeExpression* vala_ccode_base_module_get_cvalue (ValaCCodeBaseModule* self, ValaExpression* expr);
ValaCCodeFunction* vala_ccode_base_module_get_ccode (ValaCCodeBaseModule* self);
ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const gchar* name);
static void vala_gsignal_module_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
ValaCCodeParameter* vala_ccode_method_module_generate_parameter (ValaCCodeMethodModule* self, ValaParameter* param, ValaCCodeFile* decl_space, ValaMap* cparam_map, ValaMap* carg_map);
static void vala_gsignal_module_generate_marshaller (ValaGSignalModule* self, ValaList* params, ValaDataType* return_type);
void vala_ccode_base_module_push_function (ValaCCodeBaseModule* self, ValaCCodeFunction* func);
void vala_ccode_base_module_pop_function (ValaCCodeBaseModule* self);
static ValaCCodeFunctionCall* vala_gsignal_module_real_get_signal_creation (ValaCCodeBaseModule* base, ValaSignal* sig, ValaTypeSymbol* type);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static void vala_gsignal_module_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr);
void vala_ccode_base_module_set_cvalue (ValaCCodeBaseModule* self, ValaExpression* expr, ValaCCodeExpression* cvalue);
static gboolean vala_gsignal_module_in_gobject_instance (ValaGSignalModule* self, ValaMethod* m);
static void vala_gsignal_module_emit_signal_assignment (ValaGSignalModule* self, ValaAssignment* assignment);
static ValaCCodeExpression* vala_gsignal_module_connect_signal (ValaGSignalModule* self, ValaSignal* sig, ValaExpression* signal_access, ValaExpression* handler, gboolean disconnect, gboolean after, ValaCodeNode* expr);
static void vala_gsignal_module_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* assignment);
static void vala_gsignal_module_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr);
ValaClass* vala_ccode_base_module_get_current_class (ValaCCodeBaseModule* self);
static void vala_gsignal_module_real_visit_method_call (ValaCodeVisitor* base, ValaMethodCall* expr);
gchar* vala_ccode_base_module_get_dynamic_signal_connect_wrapper_name (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
gchar* vala_ccode_base_module_get_dynamic_signal_connect_after_wrapper_name (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
gchar* vala_ccode_base_module_get_dynamic_signal_disconnect_wrapper_name (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
ValaCCodeExpression* vala_ccode_base_module_get_ccodenode (ValaCCodeBaseModule* self, ValaExpression* node);
ValaCCodeExpression* vala_ccode_base_module_get_result_cexpression (ValaCCodeBaseModule* self, const gchar* cname);
ValaCCodeExpression* vala_ccode_base_module_get_delegate_target_cexpression (ValaCCodeBaseModule* self, ValaExpression* delegate_expr, ValaCCodeExpression** delegate_target_destroy_notify);
ValaGSignalModule* vala_gsignal_module_new (void);
ValaGSignalModule* vala_gsignal_module_construct (GType object_type);
ValaGObjectModule* vala_gobject_module_new (void);
ValaGObjectModule* vala_gobject_module_construct (GType object_type);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gchar* vala_gsignal_module_get_marshaller_type_name (ValaGSignalModule* self, ValaDataType* t) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	if (VALA_IS_POINTER_TYPE (t)) {
		_tmp0_ = TRUE;
	} else {
		ValaTypeParameter* _tmp1_ = NULL;
		_tmp1_ = vala_data_type_get_type_parameter (t);
		_tmp0_ = _tmp1_ != NULL;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("POINTER");
		result = _tmp2_;
		return result;
	} else {
		if (VALA_IS_ERROR_TYPE (t)) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("POINTER");
			result = _tmp3_;
			return result;
		} else {
			if (VALA_IS_ARRAY_TYPE (t)) {
				ValaDataType* _tmp4_ = NULL;
				ValaTypeSymbol* _tmp5_ = NULL;
				ValaTypeSymbol* _tmp6_ = NULL;
				_tmp4_ = vala_array_type_get_element_type (VALA_ARRAY_TYPE (t));
				_tmp5_ = vala_data_type_get_data_type (_tmp4_);
				_tmp6_ = vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type);
				if (_tmp5_ == _tmp6_) {
					gchar* _tmp7_;
					_tmp7_ = g_strdup ("BOXED,INT");
					result = _tmp7_;
					return result;
				} else {
					gchar* _tmp8_;
					_tmp8_ = g_strdup ("POINTER,INT");
					result = _tmp8_;
					return result;
				}
			} else {
				if (VALA_IS_VOID_TYPE (t)) {
					gchar* _tmp9_;
					_tmp9_ = g_strdup ("VOID");
					result = _tmp9_;
					return result;
				} else {
					ValaTypeSymbol* _tmp10_ = NULL;
					_tmp10_ = vala_data_type_get_data_type (t);
					if (VALA_IS_ENUM (_tmp10_)) {
						ValaTypeSymbol* _tmp11_ = NULL;
						ValaEnum* _tmp12_;
						ValaEnum* en;
						gchar* _tmp13_ = NULL;
						_tmp11_ = vala_data_type_get_data_type (t);
						_tmp12_ = _vala_code_node_ref0 (VALA_ENUM (_tmp11_));
						en = _tmp12_;
						_tmp13_ = vala_typesymbol_get_marshaller_type_name ((ValaTypeSymbol*) en);
						result = _tmp13_;
						_vala_code_node_unref0 (en);
						return result;
					} else {
						ValaTypeSymbol* _tmp14_ = NULL;
						gchar* _tmp15_ = NULL;
						_tmp14_ = vala_data_type_get_data_type (t);
						_tmp15_ = vala_typesymbol_get_marshaller_type_name (_tmp14_);
						result = _tmp15_;
						return result;
					}
				}
			}
		}
	}
}


static gchar* vala_gsignal_module_get_marshaller_type_name_for_parameter (ValaGSignalModule* self, ValaParameter* param) {
	gchar* result = NULL;
	ValaParameterDirection _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (param != NULL, NULL);
	_tmp0_ = vala_parameter_get_direction (param);
	if (_tmp0_ != VALA_PARAMETER_DIRECTION_IN) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("POINTER");
		result = _tmp1_;
		return result;
	} else {
		ValaDataType* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = vala_variable_get_variable_type ((ValaVariable*) param);
		_tmp3_ = vala_gsignal_module_get_marshaller_type_name (self, _tmp2_);
		result = _tmp3_;
		return result;
	}
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		GRegex* _tmp2_ = NULL;
		GRegex* _tmp3_;
		GRegex* regex;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp0_ = g_regex_escape_string (old, -1);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		regex = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp5_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* vala_gsignal_module_get_marshaller_function (ValaGSignalModule* self, ValaList* params, ValaDataType* return_type, const gchar* prefix) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* signature;
	gchar* ret = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = vala_gsignal_module_get_marshaller_signature (self, params, return_type);
	signature = _tmp0_;
	if (prefix == NULL) {
		gboolean _tmp1_;
		_tmp1_ = vala_collection_contains ((ValaCollection*) ((ValaCCodeBaseModule*) self)->predefined_marshal_set, signature);
		if (_tmp1_) {
			prefix = "g_cclosure_marshal";
		} else {
			prefix = "g_cclosure_user_marshal";
		}
	}
	_tmp2_ = vala_gsignal_module_get_marshaller_type_name (self, return_type);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s_%s_", prefix, _tmp3_);
	_g_free0 (ret);
	ret = _tmp4_;
	_g_free0 (_tmp3_);
	if (params == NULL) {
		_tmp5_ = TRUE;
	} else {
		gint _tmp6_;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) params);
		_tmp5_ = _tmp6_ == 0;
	}
	if (_tmp5_) {
		gchar* _tmp7_;
		_tmp7_ = g_strconcat (ret, "_VOID", NULL);
		_g_free0 (ret);
		ret = _tmp7_;
	} else {
		{
			ValaList* _tmp8_;
			ValaList* _p_list;
			gint _tmp9_;
			gint _p_size;
			gint _p_index;
			_tmp8_ = _vala_iterable_ref0 (params);
			_p_list = _tmp8_;
			_tmp9_ = vala_collection_get_size ((ValaCollection*) _p_list);
			_p_size = _tmp9_;
			_p_index = -1;
			while (TRUE) {
				gpointer _tmp10_ = NULL;
				ValaParameter* p;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				gchar* _tmp15_ = NULL;
				_p_index = _p_index + 1;
				if (!(_p_index < _p_size)) {
					break;
				}
				_tmp10_ = vala_list_get (_p_list, _p_index);
				p = (ValaParameter*) _tmp10_;
				_tmp11_ = vala_gsignal_module_get_marshaller_type_name_for_parameter (self, p);
				_tmp12_ = _tmp11_;
				_tmp13_ = string_replace (_tmp12_, ",", "_");
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strdup_printf ("%s_%s", ret, _tmp14_);
				_g_free0 (ret);
				ret = _tmp15_;
				_g_free0 (_tmp14_);
				_g_free0 (_tmp12_);
				_vala_code_node_unref0 (p);
			}
			_vala_iterable_unref0 (_p_list);
		}
	}
	result = ret;
	_g_free0 (signature);
	return result;
}


static gchar* vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self, ValaDataType* t) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	if (VALA_IS_POINTER_TYPE (t)) {
		_tmp0_ = TRUE;
	} else {
		ValaTypeParameter* _tmp1_ = NULL;
		_tmp1_ = vala_data_type_get_type_parameter (t);
		_tmp0_ = _tmp1_ != NULL;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("gpointer");
		result = _tmp2_;
		return result;
	} else {
		if (VALA_IS_VOID_TYPE (t)) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("void");
			result = _tmp3_;
			return result;
		} else {
			ValaTypeSymbol* _tmp4_ = NULL;
			ValaTypeSymbol* _tmp5_ = NULL;
			_tmp4_ = vala_data_type_get_data_type (t);
			_tmp5_ = vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type);
			if (_tmp4_ == _tmp5_) {
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("const char*");
				result = _tmp6_;
				return result;
			} else {
				gboolean _tmp7_ = FALSE;
				ValaTypeSymbol* _tmp8_ = NULL;
				_tmp8_ = vala_data_type_get_data_type (t);
				if (VALA_IS_CLASS (_tmp8_)) {
					_tmp7_ = TRUE;
				} else {
					ValaTypeSymbol* _tmp9_ = NULL;
					_tmp9_ = vala_data_type_get_data_type (t);
					_tmp7_ = VALA_IS_INTERFACE (_tmp9_);
				}
				if (_tmp7_) {
					gchar* _tmp10_;
					_tmp10_ = g_strdup ("gpointer");
					result = _tmp10_;
					return result;
				} else {
					ValaTypeSymbol* _tmp11_ = NULL;
					_tmp11_ = vala_data_type_get_data_type (t);
					if (VALA_IS_STRUCT (_tmp11_)) {
						ValaTypeSymbol* _tmp12_ = NULL;
						ValaStruct* _tmp13_;
						ValaStruct* st;
						gboolean _tmp14_;
						_tmp12_ = vala_data_type_get_data_type (t);
						_tmp13_ = _vala_code_node_ref0 (VALA_STRUCT (_tmp12_));
						st = _tmp13_;
						_tmp14_ = vala_struct_is_simple_type (st);
						if (_tmp14_) {
							ValaTypeSymbol* _tmp15_ = NULL;
							gchar* _tmp16_ = NULL;
							_tmp15_ = vala_data_type_get_data_type (t);
							_tmp16_ = vala_typesymbol_get_cname (_tmp15_, FALSE);
							result = _tmp16_;
							_vala_code_node_unref0 (st);
							return result;
						} else {
							gchar* _tmp17_;
							_tmp17_ = g_strdup ("gpointer");
							result = _tmp17_;
							_vala_code_node_unref0 (st);
							return result;
						}
						_vala_code_node_unref0 (st);
					} else {
						ValaTypeSymbol* _tmp18_ = NULL;
						_tmp18_ = vala_data_type_get_data_type (t);
						if (VALA_IS_ENUM (_tmp18_)) {
							gchar* _tmp19_;
							_tmp19_ = g_strdup ("gint");
							result = _tmp19_;
							return result;
						} else {
							if (VALA_IS_ARRAY_TYPE (t)) {
								gchar* _tmp20_;
								_tmp20_ = g_strdup ("gpointer");
								result = _tmp20_;
								return result;
							} else {
								if (VALA_IS_ERROR_TYPE (t)) {
									gchar* _tmp21_;
									_tmp21_ = g_strdup ("gpointer");
									result = _tmp21_;
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}


static gchar* vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self, ValaParameter* p) {
	gchar* result = NULL;
	ValaParameterDirection _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	_tmp0_ = vala_parameter_get_direction (p);
	if (_tmp0_ != VALA_PARAMETER_DIRECTION_IN) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("gpointer");
		result = _tmp1_;
		return result;
	} else {
		ValaDataType* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = vala_variable_get_variable_type ((ValaVariable*) p);
		_tmp3_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, _tmp2_);
		result = _tmp3_;
		return result;
	}
}


static gchar* vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self, ValaList* params, ValaDataType* return_type) {
	gchar* result = NULL;
	gchar* signature = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = vala_gsignal_module_get_marshaller_type_name (self, return_type);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s:", _tmp1_);
	_g_free0 (signature);
	signature = _tmp2_;
	_g_free0 (_tmp1_);
	if (params == NULL) {
		_tmp3_ = TRUE;
	} else {
		gint _tmp4_;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) params);
		_tmp3_ = _tmp4_ == 0;
	}
	if (_tmp3_) {
		gchar* _tmp5_;
		_tmp5_ = g_strconcat (signature, "VOID", NULL);
		_g_free0 (signature);
		signature = _tmp5_;
	} else {
		gboolean first;
		first = TRUE;
		{
			ValaList* _tmp6_;
			ValaList* _p_list;
			gint _tmp7_;
			gint _p_size;
			gint _p_index;
			_tmp6_ = _vala_iterable_ref0 (params);
			_p_list = _tmp6_;
			_tmp7_ = vala_collection_get_size ((ValaCollection*) _p_list);
			_p_size = _tmp7_;
			_p_index = -1;
			while (TRUE) {
				gpointer _tmp8_ = NULL;
				ValaParameter* p;
				_p_index = _p_index + 1;
				if (!(_p_index < _p_size)) {
					break;
				}
				_tmp8_ = vala_list_get (_p_list, _p_index);
				p = (ValaParameter*) _tmp8_;
				if (first) {
					gchar* _tmp9_ = NULL;
					gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp9_ = vala_gsignal_module_get_marshaller_type_name_for_parameter (self, p);
					_tmp10_ = _tmp9_;
					_tmp11_ = g_strconcat (signature, _tmp10_, NULL);
					_g_free0 (signature);
					signature = _tmp11_;
					_g_free0 (_tmp10_);
					first = FALSE;
				} else {
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_;
					gchar* _tmp14_ = NULL;
					_tmp12_ = vala_gsignal_module_get_marshaller_type_name_for_parameter (self, p);
					_tmp13_ = _tmp12_;
					_tmp14_ = g_strdup_printf ("%s,%s", signature, _tmp13_);
					_g_free0 (signature);
					signature = _tmp14_;
					_g_free0 (_tmp13_);
				}
				_vala_code_node_unref0 (p);
			}
			_vala_iterable_unref0 (_p_list);
		}
	}
	result = signature;
	return result;
}


static ValaCCodeExpression* vala_gsignal_module_get_signal_name_cexpression (ValaGSignalModule* self, ValaSignal* sig, ValaExpression* detail_expr, ValaCodeNode* node) {
	ValaCCodeExpression* result = NULL;
	gboolean _tmp1_ = FALSE;
	ValaDataType* _tmp2_ = NULL;
	ValaDataType* _tmp10_ = NULL;
	ValaLocalVariable* _tmp11_ = NULL;
	ValaLocalVariable* detail_decl;
	ValaArrayList* _tmp12_ = NULL;
	ValaCCodeIdentifier* _tmp13_ = NULL;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_ = NULL;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeConstant* _tmp17_ = NULL;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeExpression* _tmp19_ = NULL;
	ValaCCodeExpression* _tmp20_;
	ValaCCodeConstant* _tmp21_ = NULL;
	ValaCCodeConstant* _tmp22_;
	ValaCCodeFunction* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	ValaCCodeExpression* _tmp25_ = NULL;
	ValaCCodeExpression* _tmp26_;
	const gchar* _tmp27_ = NULL;
	ValaCCodeExpression* _tmp28_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	if (detail_expr == NULL) {
		ValaCCodeConstant* _tmp0_ = NULL;
		_tmp0_ = vala_signal_get_canonical_cconstant (sig, NULL);
		result = (ValaCCodeExpression*) _tmp0_;
		return result;
	}
	_tmp2_ = vala_expression_get_value_type (detail_expr);
	if (VALA_IS_NULL_TYPE (_tmp2_)) {
		_tmp1_ = TRUE;
	} else {
		ValaDataType* _tmp3_ = NULL;
		gboolean _tmp4_;
		_tmp3_ = vala_expression_get_value_type (detail_expr);
		_tmp4_ = vala_data_type_compatible (_tmp3_, ((ValaCCodeBaseModule*) self)->string_type);
		_tmp1_ = !_tmp4_;
	}
	if (_tmp1_) {
		ValaSourceReference* _tmp5_ = NULL;
		vala_code_node_set_error (node, TRUE);
		_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) detail_expr);
		vala_report_error (_tmp5_, "only string details are supported");
		result = NULL;
		return result;
	}
	if (VALA_IS_STRING_LITERAL (detail_expr)) {
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		ValaCCodeConstant* _tmp8_ = NULL;
		ValaCCodeExpression* _tmp9_;
		_tmp6_ = vala_string_literal_eval (VALA_STRING_LITERAL (detail_expr));
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_signal_get_canonical_cconstant (sig, _tmp7_);
		_tmp9_ = (ValaCCodeExpression*) _tmp8_;
		_g_free0 (_tmp7_);
		result = _tmp9_;
		return result;
	}
	_tmp10_ = vala_expression_get_value_type (detail_expr);
	_tmp11_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp10_, TRUE, node, TRUE);
	detail_decl = _tmp11_;
	vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, detail_decl, FALSE);
	_tmp12_ = vala_ccode_base_module_get_temp_ref_vars ((ValaCCodeBaseModule*) self);
	vala_list_insert ((ValaList*) _tmp12_, 0, detail_decl);
	_tmp13_ = vala_ccode_identifier_new ("g_strconcat");
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp14_);
	_tmp16_ = _tmp15_;
	_vala_ccode_node_unref0 (_tmp14_);
	ccall = _tmp16_;
	_tmp17_ = vala_signal_get_canonical_cconstant (sig, "");
	_tmp18_ = _tmp17_;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, detail_expr);
	_tmp20_ = _tmp19_;
	vala_ccode_function_call_add_argument (ccall, _tmp20_);
	_vala_ccode_node_unref0 (_tmp20_);
	_tmp21_ = vala_ccode_constant_new ("NULL");
	_tmp22_ = _tmp21_;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp23_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp24_ = vala_symbol_get_name ((ValaSymbol*) detail_decl);
	_tmp25_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp24_);
	_tmp26_ = _tmp25_;
	vala_ccode_function_add_assignment (_tmp23_, _tmp26_, (ValaCCodeExpression*) ccall);
	_vala_ccode_node_unref0 (_tmp26_);
	_tmp27_ = vala_symbol_get_name ((ValaSymbol*) detail_decl);
	_tmp28_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp27_);
	result = _tmp28_;
	_vala_ccode_node_unref0 (ccall);
	_vala_code_node_unref0 (detail_decl);
	return result;
}


static void vala_gsignal_module_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
	ValaGSignalModule * self;
	ValaSymbol* _tmp0_ = NULL;
	ValaSymbol* _tmp1_;
	ValaClass* _tmp2_;
	ValaClass* cl;
	gboolean _tmp3_ = FALSE;
	ValaList* _tmp22_ = NULL;
	ValaList* _tmp23_;
	ValaDataType* _tmp24_ = NULL;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp1_) ? ((ValaClass*) _tmp1_) : NULL);
	cl = _tmp2_;
	if (cl != NULL) {
		gboolean _tmp4_;
		_tmp4_ = vala_class_get_is_compact (cl);
		_tmp3_ = _tmp4_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaSourceReference* _tmp5_ = NULL;
		vala_code_node_set_error ((ValaCodeNode*) sig, TRUE);
		_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) sig);
		vala_report_error (_tmp5_, "Signals are not supported in compact classes");
		_vala_code_node_unref0 (cl);
		return;
	}
	if (cl != NULL) {
		{
			ValaList* _tmp6_ = NULL;
			ValaList* _base_type_list;
			gint _tmp7_;
			gint _base_type_size;
			gint _base_type_index;
			_tmp6_ = vala_class_get_base_types (cl);
			_base_type_list = _tmp6_;
			_tmp7_ = vala_collection_get_size ((ValaCollection*) _base_type_list);
			_base_type_size = _tmp7_;
			_base_type_index = -1;
			while (TRUE) {
				gpointer _tmp8_ = NULL;
				ValaDataType* base_type;
				ValaTypeSymbol* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				ValaSymbol* _tmp11_ = NULL;
				ValaSymbol* _tmp12_;
				gboolean _tmp13_;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp8_ = vala_list_get (_base_type_list, _base_type_index);
				base_type = (ValaDataType*) _tmp8_;
				_tmp9_ = vala_data_type_get_data_type (base_type);
				_tmp10_ = vala_symbol_get_name ((ValaSymbol*) sig);
				_tmp11_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp9_, _tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = VALA_IS_SIGNAL (_tmp12_);
				_vala_code_node_unref0 (_tmp12_);
				if (_tmp13_) {
					ValaSourceReference* _tmp14_ = NULL;
					vala_code_node_set_error ((ValaCodeNode*) sig, TRUE);
					_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) sig);
					vala_report_error (_tmp14_, "Signals with the same name as a signal in a base type are not supporte" \
"d");
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					_vala_code_node_unref0 (cl);
					return;
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
	}
	vala_code_node_accept_children ((ValaCodeNode*) sig, (ValaCodeVisitor*) self);
	{
		ValaList* _tmp15_ = NULL;
		ValaList* _p_list;
		gint _tmp16_;
		gint _p_size;
		gint _p_index;
		_tmp15_ = vala_signal_get_parameters (sig);
		_p_list = _tmp15_;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _p_list);
		_p_size = _tmp16_;
		_p_index = -1;
		while (TRUE) {
			gpointer _tmp17_ = NULL;
			ValaParameter* p;
			ValaHashMap* _tmp18_ = NULL;
			ValaHashMap* _tmp19_;
			ValaCCodeParameter* _tmp20_ = NULL;
			ValaCCodeParameter* _tmp21_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp17_ = vala_list_get (_p_list, _p_index);
			p = (ValaParameter*) _tmp17_;
			_tmp18_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_ccode_method_module_generate_parameter ((ValaCCodeMethodModule*) self, p, ((ValaCCodeBaseModule*) self)->cfile, (ValaMap*) _tmp19_, NULL);
			_tmp21_ = _tmp20_;
			_vala_ccode_node_unref0 (_tmp21_);
			_vala_map_unref0 (_tmp19_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp22_ = vala_signal_get_parameters (sig);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_signal_get_return_type (sig);
	vala_gsignal_module_generate_marshaller (self, _tmp23_, _tmp24_);
	_vala_iterable_unref0 (_tmp23_);
	_vala_code_node_unref0 (cl);
}


static void vala_gsignal_module_generate_marshaller (ValaGSignalModule* self, ValaList* params, ValaDataType* return_type) {
	gchar* signature = NULL;
	gint n_params = 0;
	gint i = 0;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_ = NULL;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* signal_marshaller;
	ValaCCodeParameter* _tmp8_ = NULL;
	ValaCCodeParameter* _tmp9_;
	ValaCCodeParameter* _tmp10_ = NULL;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_ = NULL;
	ValaCCodeParameter* _tmp13_;
	ValaCCodeParameter* _tmp14_ = NULL;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeParameter* _tmp16_ = NULL;
	ValaCCodeParameter* _tmp17_;
	ValaCCodeParameter* _tmp18_ = NULL;
	ValaCCodeParameter* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	ValaCCodeFunctionDeclarator* _tmp22_ = NULL;
	ValaCCodeFunctionDeclarator* _tmp23_;
	ValaCCodeFunctionDeclarator* callback_decl;
	ValaCCodeParameter* _tmp24_ = NULL;
	ValaCCodeParameter* _tmp25_;
	ValaCCodeParameter* _tmp41_ = NULL;
	ValaCCodeParameter* _tmp42_;
	ValaCCodeFunction* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_;
	ValaCCodeTypeDefinition* _tmp46_ = NULL;
	ValaCCodeTypeDefinition* _tmp47_;
	ValaCCodeFunction* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_;
	ValaCCodeVariableDeclarator* _tmp51_ = NULL;
	ValaCCodeVariableDeclarator* _tmp52_;
	ValaCCodeFunction* _tmp53_ = NULL;
	ValaCCodeIdentifier* _tmp54_ = NULL;
	ValaCCodeIdentifier* _tmp55_;
	ValaCCodeCastExpression* _tmp56_ = NULL;
	ValaCCodeCastExpression* _tmp57_;
	ValaCCodeVariableDeclarator* _tmp58_ = NULL;
	ValaCCodeVariableDeclarator* _tmp59_;
	ValaCCodeFunction* _tmp60_ = NULL;
	ValaCCodeVariableDeclarator* _tmp61_ = NULL;
	ValaCCodeVariableDeclarator* _tmp62_;
	ValaCCodeFunction* _tmp63_ = NULL;
	ValaCCodeVariableDeclarator* _tmp64_ = NULL;
	ValaCCodeVariableDeclarator* _tmp65_;
	ValaCCodeFunctionCall* fc = NULL;
	gboolean _tmp66_ = FALSE;
	ValaTypeSymbol* _tmp67_ = NULL;
	ValaCCodeIdentifier* _tmp84_ = NULL;
	ValaCCodeIdentifier* _tmp85_;
	ValaCCodeFunctionCall* _tmp86_ = NULL;
	ValaCCodeIdentifier* _tmp87_ = NULL;
	ValaCCodeIdentifier* _tmp88_;
	gchar* _tmp89_ = NULL;
	gchar* _tmp90_;
	ValaCCodeConstant* _tmp91_ = NULL;
	ValaCCodeConstant* _tmp92_;
	ValaCCodeBinaryExpression* _tmp93_ = NULL;
	ValaCCodeBinaryExpression* _tmp94_;
	ValaCCodeFunction* _tmp95_ = NULL;
	ValaCCodeIdentifier* _tmp96_ = NULL;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeMemberAccess* _tmp98_ = NULL;
	ValaCCodeMemberAccess* _tmp99_;
	ValaCCodeMemberAccess* data;
	ValaCCodeIdentifier* _tmp100_ = NULL;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeMemberAccess* _tmp102_ = NULL;
	ValaCCodeMemberAccess* _tmp103_;
	ValaCCodeMemberAccess* _tmp104_ = NULL;
	ValaCCodeMemberAccess* _tmp105_;
	ValaCCodeMemberAccess* param;
	ValaCCodeConstant* _tmp106_ = NULL;
	ValaCCodeConstant* _tmp107_;
	ValaCCodeFunctionCall* _tmp108_ = NULL;
	ValaCCodeFunctionCall* _tmp109_;
	ValaCCodeFunctionCall* cond;
	ValaCCodeIdentifier* _tmp110_ = NULL;
	ValaCCodeIdentifier* _tmp111_;
	ValaCCodeFunction* _tmp112_ = NULL;
	ValaCCodeFunction* _tmp113_ = NULL;
	ValaCCodeIdentifier* _tmp114_ = NULL;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunction* _tmp116_ = NULL;
	ValaCCodeIdentifier* _tmp117_ = NULL;
	ValaCCodeIdentifier* _tmp118_;
	ValaCCodeFunction* _tmp119_ = NULL;
	ValaCCodeFunction* _tmp120_ = NULL;
	ValaCCodeIdentifier* _tmp121_ = NULL;
	ValaCCodeIdentifier* _tmp122_;
	ValaCCodeFunction* _tmp123_ = NULL;
	ValaCCodeIdentifier* _tmp124_ = NULL;
	ValaCCodeIdentifier* _tmp125_;
	ValaCCodeFunction* _tmp126_ = NULL;
	ValaCCodeIdentifier* _tmp127_ = NULL;
	ValaCCodeIdentifier* _tmp128_;
	ValaCCodeIdentifier* _tmp129_ = NULL;
	ValaCCodeIdentifier* _tmp130_;
	ValaCCodeIdentifier* _tmp131_ = NULL;
	ValaCCodeIdentifier* _tmp132_;
	ValaCCodeMemberAccess* _tmp133_ = NULL;
	ValaCCodeMemberAccess* _tmp134_;
	ValaCCodeConditionalExpression* _tmp135_ = NULL;
	ValaCCodeConditionalExpression* _tmp136_;
	gchar* _tmp137_ = NULL;
	gchar* _tmp138_;
	ValaCCodeCastExpression* _tmp139_ = NULL;
	ValaCCodeCastExpression* _tmp140_;
	ValaCCodeCastExpression* c_assign_rhs;
	ValaCCodeFunction* _tmp141_ = NULL;
	ValaCCodeIdentifier* _tmp142_ = NULL;
	ValaCCodeIdentifier* _tmp143_;
	ValaCCodeIdentifier* _tmp144_ = NULL;
	ValaCCodeIdentifier* _tmp145_;
	ValaCCodeFunctionCall* _tmp146_ = NULL;
	ValaCCodeIdentifier* _tmp147_ = NULL;
	ValaCCodeIdentifier* _tmp148_;
	ValaCCodeIdentifier* _tmp195_ = NULL;
	ValaCCodeIdentifier* _tmp196_;
	gboolean _tmp197_ = FALSE;
	ValaTypeSymbol* _tmp198_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (params != NULL);
	g_return_if_fail (return_type != NULL);
	_tmp0_ = vala_gsignal_module_get_marshaller_signature (self, params, return_type);
	_g_free0 (signature);
	signature = _tmp0_;
	_tmp2_ = vala_collection_contains ((ValaCollection*) ((ValaCCodeBaseModule*) self)->predefined_marshal_set, signature);
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_;
		_tmp3_ = vala_collection_contains ((ValaCollection*) ((ValaCCodeBaseModule*) self)->user_marshal_set, signature);
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		_g_free0 (signature);
		return;
	}
	_tmp4_ = vala_gsignal_module_get_marshaller_function (self, params, return_type, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "void");
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	signal_marshaller = _tmp7_;
	vala_ccode_function_set_modifiers (signal_marshaller, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = vala_ccode_parameter_new ("closure", "GClosure *");
	_tmp9_ = _tmp8_;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = vala_ccode_parameter_new ("return_value", "GValue *");
	_tmp11_ = _tmp10_;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp11_);
	_vala_ccode_node_unref0 (_tmp11_);
	_tmp12_ = vala_ccode_parameter_new ("n_param_values", "guint");
	_tmp13_ = _tmp12_;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp13_);
	_vala_ccode_node_unref0 (_tmp13_);
	_tmp14_ = vala_ccode_parameter_new ("param_values", "const GValue *");
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_parameter_new ("invocation_hint", "gpointer");
	_tmp17_ = _tmp16_;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp17_);
	_vala_ccode_node_unref0 (_tmp17_);
	_tmp18_ = vala_ccode_parameter_new ("marshal_data", "gpointer");
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, signal_marshaller);
	_tmp20_ = vala_gsignal_module_get_marshaller_function (self, params, return_type, "GMarshalFunc");
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_function_declarator_new (_tmp21_);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	callback_decl = _tmp23_;
	_tmp24_ = vala_ccode_parameter_new ("data1", "gpointer");
	_tmp25_ = _tmp24_;
	vala_ccode_function_declarator_add_parameter (callback_decl, _tmp25_);
	_vala_ccode_node_unref0 (_tmp25_);
	n_params = 1;
	{
		ValaList* _tmp26_;
		ValaList* _p_list;
		gint _tmp27_;
		gint _p_size;
		gint _p_index;
		_tmp26_ = _vala_iterable_ref0 (params);
		_p_list = _tmp26_;
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _p_list);
		_p_size = _tmp27_;
		_p_index = -1;
		while (TRUE) {
			gpointer _tmp28_ = NULL;
			ValaParameter* p;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_;
			ValaCCodeParameter* _tmp33_ = NULL;
			ValaCCodeParameter* _tmp34_;
			ValaDataType* _tmp35_ = NULL;
			gboolean _tmp36_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp28_ = vala_list_get (_p_list, _p_index);
			p = (ValaParameter*) _tmp28_;
			_tmp29_ = g_strdup_printf ("arg_%d", n_params);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_gsignal_module_get_value_type_name_from_parameter (self, p);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_ccode_parameter_new (_tmp30_, _tmp32_);
			_tmp34_ = _tmp33_;
			vala_ccode_function_declarator_add_parameter (callback_decl, _tmp34_);
			_vala_ccode_node_unref0 (_tmp34_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp30_);
			n_params++;
			_tmp35_ = vala_variable_get_variable_type ((ValaVariable*) p);
			_tmp36_ = vala_data_type_is_array (_tmp35_);
			if (_tmp36_) {
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_;
				ValaCCodeParameter* _tmp39_ = NULL;
				ValaCCodeParameter* _tmp40_;
				_tmp37_ = g_strdup_printf ("arg_%d", n_params);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_ccode_parameter_new (_tmp38_, "gint");
				_tmp40_ = _tmp39_;
				vala_ccode_function_declarator_add_parameter (callback_decl, _tmp40_);
				_vala_ccode_node_unref0 (_tmp40_);
				_g_free0 (_tmp38_);
				n_params++;
			}
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp41_ = vala_ccode_parameter_new ("data2", "gpointer");
	_tmp42_ = _tmp41_;
	vala_ccode_function_declarator_add_parameter (callback_decl, _tmp42_);
	_vala_ccode_node_unref0 (_tmp42_);
	_tmp43_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp44_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type);
	_tmp45_ = _tmp44_;
	_tmp46_ = vala_ccode_type_definition_new (_tmp45_, (ValaCCodeDeclarator*) callback_decl);
	_tmp47_ = _tmp46_;
	vala_ccode_function_add_statement (_tmp43_, (ValaCCodeNode*) _tmp47_);
	_vala_ccode_node_unref0 (_tmp47_);
	_g_free0 (_tmp45_);
	_tmp48_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp49_ = vala_gsignal_module_get_marshaller_function (self, params, return_type, "GMarshalFunc");
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_ccode_variable_declarator_new ("callback", NULL, NULL);
	_tmp52_ = _tmp51_;
	vala_ccode_function_add_declaration (_tmp48_, _tmp50_, (ValaCCodeDeclarator*) _tmp52_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp52_);
	_g_free0 (_tmp50_);
	_tmp53_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp54_ = vala_ccode_identifier_new ("closure");
	_tmp55_ = _tmp54_;
	_tmp56_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp55_, "GCClosure *");
	_tmp57_ = _tmp56_;
	_tmp58_ = vala_ccode_variable_declarator_new ("cc", (ValaCCodeExpression*) _tmp57_, NULL);
	_tmp59_ = _tmp58_;
	vala_ccode_function_add_declaration (_tmp53_, "GCClosure *", (ValaCCodeDeclarator*) _tmp59_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp59_);
	_vala_ccode_node_unref0 (_tmp57_);
	_vala_ccode_node_unref0 (_tmp55_);
	_tmp60_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp61_ = vala_ccode_variable_declarator_new ("data1", NULL, NULL);
	_tmp62_ = _tmp61_;
	vala_ccode_function_add_declaration (_tmp60_, "gpointer", (ValaCCodeDeclarator*) _tmp62_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp62_);
	_tmp63_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp64_ = vala_ccode_variable_declarator_new ("data2", NULL, NULL);
	_tmp65_ = _tmp64_;
	vala_ccode_function_add_declaration (_tmp63_, "gpointer", (ValaCCodeDeclarator*) _tmp65_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp65_);
	_tmp67_ = vala_data_type_get_data_type (return_type);
	if (_tmp67_ != NULL) {
		_tmp66_ = TRUE;
	} else {
		gboolean _tmp68_;
		_tmp68_ = vala_data_type_is_array (return_type);
		_tmp66_ = _tmp68_;
	}
	if (_tmp66_) {
		ValaCCodeFunction* _tmp69_ = NULL;
		gchar* _tmp70_ = NULL;
		gchar* _tmp71_;
		ValaCCodeVariableDeclarator* _tmp72_ = NULL;
		ValaCCodeVariableDeclarator* _tmp73_;
		ValaCCodeIdentifier* _tmp74_ = NULL;
		ValaCCodeIdentifier* _tmp75_;
		ValaCCodeFunctionCall* _tmp76_ = NULL;
		ValaCCodeIdentifier* _tmp77_ = NULL;
		ValaCCodeIdentifier* _tmp78_;
		ValaCCodeConstant* _tmp79_ = NULL;
		ValaCCodeConstant* _tmp80_;
		ValaCCodeBinaryExpression* _tmp81_ = NULL;
		ValaCCodeBinaryExpression* _tmp82_;
		ValaCCodeFunction* _tmp83_ = NULL;
		_tmp69_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp70_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_ccode_variable_declarator_new ("v_return", NULL, NULL);
		_tmp73_ = _tmp72_;
		vala_ccode_function_add_declaration (_tmp69_, _tmp71_, (ValaCCodeDeclarator*) _tmp73_, 0);
		_vala_ccode_node_unref0 (_tmp73_);
		_g_free0 (_tmp71_);
		_tmp74_ = vala_ccode_identifier_new ("g_return_if_fail");
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp75_);
		_vala_ccode_node_unref0 (fc);
		fc = _tmp76_;
		_vala_ccode_node_unref0 (_tmp75_);
		_tmp77_ = vala_ccode_identifier_new ("return_value");
		_tmp78_ = _tmp77_;
		_tmp79_ = vala_ccode_constant_new ("NULL");
		_tmp80_ = _tmp79_;
		_tmp81_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) _tmp78_, (ValaCCodeExpression*) _tmp80_);
		_tmp82_ = _tmp81_;
		vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) _tmp82_);
		_vala_ccode_node_unref0 (_tmp82_);
		_vala_ccode_node_unref0 (_tmp80_);
		_vala_ccode_node_unref0 (_tmp78_);
		_tmp83_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		vala_ccode_function_add_expression (_tmp83_, (ValaCCodeExpression*) fc);
	}
	_tmp84_ = vala_ccode_identifier_new ("g_return_if_fail");
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp85_);
	_vala_ccode_node_unref0 (fc);
	fc = _tmp86_;
	_vala_ccode_node_unref0 (_tmp85_);
	_tmp87_ = vala_ccode_identifier_new ("n_param_values");
	_tmp88_ = _tmp87_;
	_tmp89_ = g_strdup_printf ("%i", n_params);
	_tmp90_ = _tmp89_;
	_tmp91_ = vala_ccode_constant_new (_tmp90_);
	_tmp92_ = _tmp91_;
	_tmp93_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp88_, (ValaCCodeExpression*) _tmp92_);
	_tmp94_ = _tmp93_;
	vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) _tmp94_);
	_vala_ccode_node_unref0 (_tmp94_);
	_vala_ccode_node_unref0 (_tmp92_);
	_g_free0 (_tmp90_);
	_vala_ccode_node_unref0 (_tmp88_);
	_tmp95_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	vala_ccode_function_add_expression (_tmp95_, (ValaCCodeExpression*) fc);
	_tmp96_ = vala_ccode_identifier_new ("closure");
	_tmp97_ = _tmp96_;
	_tmp98_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp97_, "data", TRUE);
	_tmp99_ = _tmp98_;
	_vala_ccode_node_unref0 (_tmp97_);
	data = _tmp99_;
	_tmp100_ = vala_ccode_identifier_new ("param_values");
	_tmp101_ = _tmp100_;
	_tmp102_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp101_, "data[0]", TRUE);
	_tmp103_ = _tmp102_;
	_tmp104_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp103_, "v_pointer", FALSE);
	_tmp105_ = _tmp104_;
	_vala_ccode_node_unref0 (_tmp103_);
	_vala_ccode_node_unref0 (_tmp101_);
	param = _tmp105_;
	_tmp106_ = vala_ccode_constant_new ("G_CCLOSURE_SWAP_DATA");
	_tmp107_ = _tmp106_;
	_tmp108_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp107_);
	_tmp109_ = _tmp108_;
	_vala_ccode_node_unref0 (_tmp107_);
	cond = _tmp109_;
	_tmp110_ = vala_ccode_identifier_new ("closure");
	_tmp111_ = _tmp110_;
	vala_ccode_function_call_add_argument (cond, (ValaCCodeExpression*) _tmp111_);
	_vala_ccode_node_unref0 (_tmp111_);
	_tmp112_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	vala_ccode_function_open_if (_tmp112_, (ValaCCodeExpression*) cond);
	_tmp113_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp114_ = vala_ccode_identifier_new ("data1");
	_tmp115_ = _tmp114_;
	vala_ccode_function_add_assignment (_tmp113_, (ValaCCodeExpression*) _tmp115_, (ValaCCodeExpression*) data);
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp116_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp117_ = vala_ccode_identifier_new ("data2");
	_tmp118_ = _tmp117_;
	vala_ccode_function_add_assignment (_tmp116_, (ValaCCodeExpression*) _tmp118_, (ValaCCodeExpression*) param);
	_vala_ccode_node_unref0 (_tmp118_);
	_tmp119_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	vala_ccode_function_add_else (_tmp119_);
	_tmp120_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp121_ = vala_ccode_identifier_new ("data1");
	_tmp122_ = _tmp121_;
	vala_ccode_function_add_assignment (_tmp120_, (ValaCCodeExpression*) _tmp122_, (ValaCCodeExpression*) param);
	_vala_ccode_node_unref0 (_tmp122_);
	_tmp123_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp124_ = vala_ccode_identifier_new ("data2");
	_tmp125_ = _tmp124_;
	vala_ccode_function_add_assignment (_tmp123_, (ValaCCodeExpression*) _tmp125_, (ValaCCodeExpression*) data);
	_vala_ccode_node_unref0 (_tmp125_);
	_tmp126_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	vala_ccode_function_close (_tmp126_);
	_tmp127_ = vala_ccode_identifier_new ("marshal_data");
	_tmp128_ = _tmp127_;
	_tmp129_ = vala_ccode_identifier_new ("marshal_data");
	_tmp130_ = _tmp129_;
	_tmp131_ = vala_ccode_identifier_new ("cc");
	_tmp132_ = _tmp131_;
	_tmp133_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp132_, "callback", TRUE);
	_tmp134_ = _tmp133_;
	_tmp135_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp128_, (ValaCCodeExpression*) _tmp130_, (ValaCCodeExpression*) _tmp134_);
	_tmp136_ = _tmp135_;
	_tmp137_ = vala_gsignal_module_get_marshaller_function (self, params, return_type, "GMarshalFunc");
	_tmp138_ = _tmp137_;
	_tmp139_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp136_, _tmp138_);
	_tmp140_ = _tmp139_;
	_g_free0 (_tmp138_);
	_vala_ccode_node_unref0 (_tmp136_);
	_vala_ccode_node_unref0 (_tmp134_);
	_vala_ccode_node_unref0 (_tmp132_);
	_vala_ccode_node_unref0 (_tmp130_);
	_vala_ccode_node_unref0 (_tmp128_);
	c_assign_rhs = _tmp140_;
	_tmp141_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp142_ = vala_ccode_identifier_new ("callback");
	_tmp143_ = _tmp142_;
	vala_ccode_function_add_assignment (_tmp141_, (ValaCCodeExpression*) _tmp143_, (ValaCCodeExpression*) c_assign_rhs);
	_vala_ccode_node_unref0 (_tmp143_);
	_tmp144_ = vala_ccode_identifier_new ("callback");
	_tmp145_ = _tmp144_;
	_tmp146_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp145_);
	_vala_ccode_node_unref0 (fc);
	fc = _tmp146_;
	_vala_ccode_node_unref0 (_tmp145_);
	_tmp147_ = vala_ccode_identifier_new ("data1");
	_tmp148_ = _tmp147_;
	vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) _tmp148_);
	_vala_ccode_node_unref0 (_tmp148_);
	i = 1;
	{
		ValaList* _tmp149_;
		ValaList* _p_list;
		gint _tmp150_;
		gint _p_size;
		gint _p_index;
		_tmp149_ = _vala_iterable_ref0 (params);
		_p_list = _tmp149_;
		_tmp150_ = vala_collection_get_size ((ValaCollection*) _p_list);
		_p_size = _tmp150_;
		_p_index = -1;
		while (TRUE) {
			gpointer _tmp151_ = NULL;
			ValaParameter* p;
			gchar* get_value_function = NULL;
			ValaDataType* _tmp152_ = NULL;
			gboolean _tmp153_;
			gboolean is_array;
			ValaParameterDirection _tmp154_;
			ValaCCodeIdentifier* _tmp172_ = NULL;
			ValaCCodeIdentifier* _tmp173_;
			ValaCCodeFunctionCall* _tmp174_ = NULL;
			ValaCCodeFunctionCall* _tmp175_;
			ValaCCodeFunctionCall* inner_fc;
			ValaCCodeIdentifier* _tmp176_ = NULL;
			ValaCCodeIdentifier* _tmp177_;
			gchar* _tmp178_ = NULL;
			gchar* _tmp179_;
			ValaCCodeIdentifier* _tmp180_ = NULL;
			ValaCCodeIdentifier* _tmp181_;
			ValaCCodeBinaryExpression* _tmp182_ = NULL;
			ValaCCodeBinaryExpression* _tmp183_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp151_ = vala_list_get (_p_list, _p_index);
			p = (ValaParameter*) _tmp151_;
			_tmp152_ = vala_variable_get_variable_type ((ValaVariable*) p);
			_tmp153_ = vala_data_type_is_array (_tmp152_);
			is_array = _tmp153_;
			_tmp154_ = vala_parameter_get_direction (p);
			if (_tmp154_ != VALA_PARAMETER_DIRECTION_IN) {
				gchar* _tmp155_;
				_tmp155_ = g_strdup ("g_value_get_pointer");
				_g_free0 (get_value_function);
				get_value_function = _tmp155_;
			} else {
				if (is_array) {
					ValaDataType* _tmp156_ = NULL;
					ValaDataType* _tmp157_ = NULL;
					ValaTypeSymbol* _tmp158_ = NULL;
					ValaTypeSymbol* _tmp159_ = NULL;
					_tmp156_ = vala_variable_get_variable_type ((ValaVariable*) p);
					_tmp157_ = vala_array_type_get_element_type (VALA_ARRAY_TYPE (_tmp156_));
					_tmp158_ = vala_data_type_get_data_type (_tmp157_);
					_tmp159_ = vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type);
					if (_tmp158_ == _tmp159_) {
						gchar* _tmp160_;
						_tmp160_ = g_strdup ("g_value_get_boxed");
						_g_free0 (get_value_function);
						get_value_function = _tmp160_;
					} else {
						gchar* _tmp161_;
						_tmp161_ = g_strdup ("g_value_get_pointer");
						_g_free0 (get_value_function);
						get_value_function = _tmp161_;
					}
				} else {
					gboolean _tmp162_ = FALSE;
					ValaDataType* _tmp163_ = NULL;
					_tmp163_ = vala_variable_get_variable_type ((ValaVariable*) p);
					if (VALA_IS_POINTER_TYPE (_tmp163_)) {
						_tmp162_ = TRUE;
					} else {
						ValaDataType* _tmp164_ = NULL;
						ValaTypeParameter* _tmp165_ = NULL;
						_tmp164_ = vala_variable_get_variable_type ((ValaVariable*) p);
						_tmp165_ = vala_data_type_get_type_parameter (_tmp164_);
						_tmp162_ = _tmp165_ != NULL;
					}
					if (_tmp162_) {
						gchar* _tmp166_;
						_tmp166_ = g_strdup ("g_value_get_pointer");
						_g_free0 (get_value_function);
						get_value_function = _tmp166_;
					} else {
						ValaDataType* _tmp167_ = NULL;
						_tmp167_ = vala_variable_get_variable_type ((ValaVariable*) p);
						if (VALA_IS_ERROR_TYPE (_tmp167_)) {
							gchar* _tmp168_;
							_tmp168_ = g_strdup ("g_value_get_pointer");
							_g_free0 (get_value_function);
							get_value_function = _tmp168_;
						} else {
							ValaDataType* _tmp169_ = NULL;
							ValaTypeSymbol* _tmp170_ = NULL;
							gchar* _tmp171_ = NULL;
							_tmp169_ = vala_variable_get_variable_type ((ValaVariable*) p);
							_tmp170_ = vala_data_type_get_data_type (_tmp169_);
							_tmp171_ = vala_typesymbol_get_get_value_function (_tmp170_);
							_g_free0 (get_value_function);
							get_value_function = _tmp171_;
						}
					}
				}
			}
			_tmp172_ = vala_ccode_identifier_new (get_value_function);
			_tmp173_ = _tmp172_;
			_tmp174_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp173_);
			_tmp175_ = _tmp174_;
			_vala_ccode_node_unref0 (_tmp173_);
			inner_fc = _tmp175_;
			_tmp176_ = vala_ccode_identifier_new ("param_values");
			_tmp177_ = _tmp176_;
			_tmp178_ = g_strdup_printf ("%i", i);
			_tmp179_ = _tmp178_;
			_tmp180_ = vala_ccode_identifier_new (_tmp179_);
			_tmp181_ = _tmp180_;
			_tmp182_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp177_, (ValaCCodeExpression*) _tmp181_);
			_tmp183_ = _tmp182_;
			vala_ccode_function_call_add_argument (inner_fc, (ValaCCodeExpression*) _tmp183_);
			_vala_ccode_node_unref0 (_tmp183_);
			_vala_ccode_node_unref0 (_tmp181_);
			_g_free0 (_tmp179_);
			_vala_ccode_node_unref0 (_tmp177_);
			vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) inner_fc);
			i++;
			if (is_array) {
				ValaCCodeIdentifier* _tmp184_ = NULL;
				ValaCCodeIdentifier* _tmp185_;
				ValaCCodeFunctionCall* _tmp186_ = NULL;
				ValaCCodeIdentifier* _tmp187_ = NULL;
				ValaCCodeIdentifier* _tmp188_;
				gchar* _tmp189_ = NULL;
				gchar* _tmp190_;
				ValaCCodeIdentifier* _tmp191_ = NULL;
				ValaCCodeIdentifier* _tmp192_;
				ValaCCodeBinaryExpression* _tmp193_ = NULL;
				ValaCCodeBinaryExpression* _tmp194_;
				_tmp184_ = vala_ccode_identifier_new ("g_value_get_int");
				_tmp185_ = _tmp184_;
				_tmp186_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp185_);
				_vala_ccode_node_unref0 (inner_fc);
				inner_fc = _tmp186_;
				_vala_ccode_node_unref0 (_tmp185_);
				_tmp187_ = vala_ccode_identifier_new ("param_values");
				_tmp188_ = _tmp187_;
				_tmp189_ = g_strdup_printf ("%i", i);
				_tmp190_ = _tmp189_;
				_tmp191_ = vala_ccode_identifier_new (_tmp190_);
				_tmp192_ = _tmp191_;
				_tmp193_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp188_, (ValaCCodeExpression*) _tmp192_);
				_tmp194_ = _tmp193_;
				vala_ccode_function_call_add_argument (inner_fc, (ValaCCodeExpression*) _tmp194_);
				_vala_ccode_node_unref0 (_tmp194_);
				_vala_ccode_node_unref0 (_tmp192_);
				_g_free0 (_tmp190_);
				_vala_ccode_node_unref0 (_tmp188_);
				vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) inner_fc);
				i++;
			}
			_vala_ccode_node_unref0 (inner_fc);
			_g_free0 (get_value_function);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp195_ = vala_ccode_identifier_new ("data2");
	_tmp196_ = _tmp195_;
	vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) _tmp196_);
	_vala_ccode_node_unref0 (_tmp196_);
	_tmp198_ = vala_data_type_get_data_type (return_type);
	if (_tmp198_ != NULL) {
		_tmp197_ = TRUE;
	} else {
		gboolean _tmp199_;
		_tmp199_ = vala_data_type_is_array (return_type);
		_tmp197_ = _tmp199_;
	}
	if (_tmp197_) {
		ValaCCodeFunction* _tmp200_ = NULL;
		ValaCCodeIdentifier* _tmp201_ = NULL;
		ValaCCodeIdentifier* _tmp202_;
		ValaCCodeFunctionCall* set_fc = NULL;
		gboolean _tmp203_;
		ValaCCodeIdentifier* _tmp237_ = NULL;
		ValaCCodeIdentifier* _tmp238_;
		ValaCCodeIdentifier* _tmp239_ = NULL;
		ValaCCodeIdentifier* _tmp240_;
		ValaCCodeFunction* _tmp241_ = NULL;
		_tmp200_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp201_ = vala_ccode_identifier_new ("v_return");
		_tmp202_ = _tmp201_;
		vala_ccode_function_add_assignment (_tmp200_, (ValaCCodeExpression*) _tmp202_, (ValaCCodeExpression*) fc);
		_vala_ccode_node_unref0 (_tmp202_);
		_tmp203_ = vala_data_type_is_array (return_type);
		if (_tmp203_) {
			ValaDataType* _tmp204_ = NULL;
			ValaTypeSymbol* _tmp205_ = NULL;
			ValaTypeSymbol* _tmp206_ = NULL;
			_tmp204_ = vala_array_type_get_element_type (VALA_ARRAY_TYPE (return_type));
			_tmp205_ = vala_data_type_get_data_type (_tmp204_);
			_tmp206_ = vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type);
			if (_tmp205_ == _tmp206_) {
				ValaCCodeIdentifier* _tmp207_ = NULL;
				ValaCCodeIdentifier* _tmp208_;
				ValaCCodeFunctionCall* _tmp209_ = NULL;
				_tmp207_ = vala_ccode_identifier_new ("g_value_take_boxed");
				_tmp208_ = _tmp207_;
				_tmp209_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp208_);
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp209_;
				_vala_ccode_node_unref0 (_tmp208_);
			} else {
				ValaCCodeIdentifier* _tmp210_ = NULL;
				ValaCCodeIdentifier* _tmp211_;
				ValaCCodeFunctionCall* _tmp212_ = NULL;
				_tmp210_ = vala_ccode_identifier_new ("g_value_set_pointer");
				_tmp211_ = _tmp210_;
				_tmp212_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp211_);
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp212_;
				_vala_ccode_node_unref0 (_tmp211_);
			}
		} else {
			ValaTypeParameter* _tmp213_ = NULL;
			_tmp213_ = vala_data_type_get_type_parameter (return_type);
			if (_tmp213_ != NULL) {
				ValaCCodeIdentifier* _tmp214_ = NULL;
				ValaCCodeIdentifier* _tmp215_;
				ValaCCodeFunctionCall* _tmp216_ = NULL;
				_tmp214_ = vala_ccode_identifier_new ("g_value_set_pointer");
				_tmp215_ = _tmp214_;
				_tmp216_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp215_);
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp216_;
				_vala_ccode_node_unref0 (_tmp215_);
			} else {
				if (VALA_IS_ERROR_TYPE (return_type)) {
					ValaCCodeIdentifier* _tmp217_ = NULL;
					ValaCCodeIdentifier* _tmp218_;
					ValaCCodeFunctionCall* _tmp219_ = NULL;
					_tmp217_ = vala_ccode_identifier_new ("g_value_set_pointer");
					_tmp218_ = _tmp217_;
					_tmp219_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp218_);
					_vala_ccode_node_unref0 (set_fc);
					set_fc = _tmp219_;
					_vala_ccode_node_unref0 (_tmp218_);
				} else {
					ValaTypeSymbol* _tmp220_ = NULL;
					ValaTypeSymbol* _tmp221_ = NULL;
					_tmp220_ = vala_data_type_get_data_type (return_type);
					_tmp221_ = vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type);
					if (_tmp220_ == _tmp221_) {
						ValaCCodeIdentifier* _tmp222_ = NULL;
						ValaCCodeIdentifier* _tmp223_;
						ValaCCodeFunctionCall* _tmp224_ = NULL;
						_tmp222_ = vala_ccode_identifier_new ("g_value_take_string");
						_tmp223_ = _tmp222_;
						_tmp224_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp223_);
						_vala_ccode_node_unref0 (set_fc);
						set_fc = _tmp224_;
						_vala_ccode_node_unref0 (_tmp223_);
					} else {
						gboolean _tmp225_ = FALSE;
						ValaTypeSymbol* _tmp226_ = NULL;
						_tmp226_ = vala_data_type_get_data_type (return_type);
						if (VALA_IS_CLASS (_tmp226_)) {
							_tmp225_ = TRUE;
						} else {
							ValaTypeSymbol* _tmp227_ = NULL;
							_tmp227_ = vala_data_type_get_data_type (return_type);
							_tmp225_ = VALA_IS_INTERFACE (_tmp227_);
						}
						if (_tmp225_) {
							ValaCCodeIdentifier* _tmp228_ = NULL;
							ValaCCodeIdentifier* _tmp229_;
							ValaCCodeFunctionCall* _tmp230_ = NULL;
							_tmp228_ = vala_ccode_identifier_new ("g_value_take_object");
							_tmp229_ = _tmp228_;
							_tmp230_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp229_);
							_vala_ccode_node_unref0 (set_fc);
							set_fc = _tmp230_;
							_vala_ccode_node_unref0 (_tmp229_);
						} else {
							ValaTypeSymbol* _tmp231_ = NULL;
							gchar* _tmp232_ = NULL;
							gchar* _tmp233_;
							ValaCCodeIdentifier* _tmp234_ = NULL;
							ValaCCodeIdentifier* _tmp235_;
							ValaCCodeFunctionCall* _tmp236_ = NULL;
							_tmp231_ = vala_data_type_get_data_type (return_type);
							_tmp232_ = vala_typesymbol_get_set_value_function (_tmp231_);
							_tmp233_ = _tmp232_;
							_tmp234_ = vala_ccode_identifier_new (_tmp233_);
							_tmp235_ = _tmp234_;
							_tmp236_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp235_);
							_vala_ccode_node_unref0 (set_fc);
							set_fc = _tmp236_;
							_vala_ccode_node_unref0 (_tmp235_);
							_g_free0 (_tmp233_);
						}
					}
				}
			}
		}
		_tmp237_ = vala_ccode_identifier_new ("return_value");
		_tmp238_ = _tmp237_;
		vala_ccode_function_call_add_argument (set_fc, (ValaCCodeExpression*) _tmp238_);
		_vala_ccode_node_unref0 (_tmp238_);
		_tmp239_ = vala_ccode_identifier_new ("v_return");
		_tmp240_ = _tmp239_;
		vala_ccode_function_call_add_argument (set_fc, (ValaCCodeExpression*) _tmp240_);
		_vala_ccode_node_unref0 (_tmp240_);
		_tmp241_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		vala_ccode_function_add_expression (_tmp241_, (ValaCCodeExpression*) set_fc);
		_vala_ccode_node_unref0 (set_fc);
	} else {
		ValaCCodeFunction* _tmp242_ = NULL;
		_tmp242_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		vala_ccode_function_add_expression (_tmp242_, (ValaCCodeExpression*) fc);
	}
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	vala_ccode_file_add_function_declaration (((ValaCCodeBaseModule*) self)->cfile, signal_marshaller);
	vala_ccode_file_add_function (((ValaCCodeBaseModule*) self)->cfile, signal_marshaller);
	vala_collection_add ((ValaCollection*) ((ValaCCodeBaseModule*) self)->user_marshal_set, signature);
	_vala_ccode_node_unref0 (c_assign_rhs);
	_vala_ccode_node_unref0 (cond);
	_vala_ccode_node_unref0 (param);
	_vala_ccode_node_unref0 (data);
	_vala_ccode_node_unref0 (fc);
	_vala_ccode_node_unref0 (callback_decl);
	_vala_ccode_node_unref0 (signal_marshaller);
	_g_free0 (signature);
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static ValaCCodeFunctionCall* vala_gsignal_module_real_get_signal_creation (ValaCCodeBaseModule* base, ValaSignal* sig, ValaTypeSymbol* type) {
	ValaGSignalModule * self;
	ValaCCodeFunctionCall* result = NULL;
	ValaCCodeIdentifier* _tmp0_ = NULL;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_ = NULL;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* csignew;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	ValaCCodeConstant* _tmp8_ = NULL;
	ValaCCodeConstant* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	ValaCCodeIdentifier* _tmp12_ = NULL;
	ValaCCodeIdentifier* _tmp13_;
	gchar** _tmp14_ = NULL;
	gchar** flags;
	gint flags_length1;
	gint _flags_size_;
	const gchar* _tmp15_ = NULL;
	gboolean _tmp20_;
	gboolean _tmp22_;
	gboolean _tmp24_;
	gboolean _tmp26_;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	ValaCCodeConstant* _tmp30_ = NULL;
	ValaCCodeConstant* _tmp31_;
	ValaMethod* _tmp32_ = NULL;
	ValaCCodeConstant* _tmp53_ = NULL;
	ValaCCodeConstant* _tmp54_;
	ValaCCodeConstant* _tmp55_ = NULL;
	ValaCCodeConstant* _tmp56_;
	ValaList* _tmp57_ = NULL;
	ValaList* _tmp58_;
	ValaDataType* _tmp59_ = NULL;
	gchar* _tmp60_ = NULL;
	gchar* _tmp61_;
	gchar* marshaller;
	ValaCCodeIdentifier* _tmp62_ = NULL;
	ValaCCodeIdentifier* marshal_arg;
	ValaList* _tmp63_ = NULL;
	ValaList* params;
	gboolean _tmp64_ = FALSE;
	ValaDataType* _tmp65_ = NULL;
	gint params_len;
	gchar* _tmp88_ = NULL;
	gchar* _tmp89_;
	ValaCCodeConstant* _tmp90_ = NULL;
	ValaCCodeConstant* _tmp91_;
	self = (ValaGSignalModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = vala_ccode_identifier_new ("g_signal_new");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	csignew = _tmp3_;
	_tmp4_ = vala_signal_get_cname (sig);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("\"%s\"", _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_ccode_constant_new (_tmp7_);
	_tmp9_ = _tmp8_;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp10_ = vala_typesymbol_get_type_id (type);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_ccode_identifier_new (_tmp11_);
	_tmp13_ = _tmp12_;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp13_);
	_vala_ccode_node_unref0 (_tmp13_);
	_g_free0 (_tmp11_);
	_tmp14_ = g_new0 (gchar*, 0 + 1);
	flags = _tmp14_;
	flags_length1 = 0;
	_flags_size_ = flags_length1;
	_tmp15_ = vala_signal_get_run_type (sig);
	if (g_strcmp0 (_tmp15_, "first") == 0) {
		gchar* _tmp16_;
		_tmp16_ = g_strdup ("G_SIGNAL_RUN_FIRST");
		_vala_array_add1 (&flags, &flags_length1, &_flags_size_, _tmp16_);
	} else {
		const gchar* _tmp17_ = NULL;
		_tmp17_ = vala_signal_get_run_type (sig);
		if (g_strcmp0 (_tmp17_, "cleanup") == 0) {
			gchar* _tmp18_;
			_tmp18_ = g_strdup ("G_SIGNAL_RUN_CLEANUP");
			_vala_array_add2 (&flags, &flags_length1, &_flags_size_, _tmp18_);
		} else {
			gchar* _tmp19_;
			_tmp19_ = g_strdup ("G_SIGNAL_RUN_LAST");
			_vala_array_add3 (&flags, &flags_length1, &_flags_size_, _tmp19_);
		}
	}
	_tmp20_ = vala_signal_get_is_detailed (sig);
	if (_tmp20_) {
		gchar* _tmp21_;
		_tmp21_ = g_strdup ("G_SIGNAL_DETAILED");
		_vala_array_add4 (&flags, &flags_length1, &_flags_size_, _tmp21_);
	}
	_tmp22_ = vala_signal_get_no_recurse (sig);
	if (_tmp22_) {
		gchar* _tmp23_;
		_tmp23_ = g_strdup ("G_SIGNAL_NO_RECURSE");
		_vala_array_add5 (&flags, &flags_length1, &_flags_size_, _tmp23_);
	}
	_tmp24_ = vala_signal_get_is_action (sig);
	if (_tmp24_) {
		gchar* _tmp25_;
		_tmp25_ = g_strdup ("G_SIGNAL_ACTION");
		_vala_array_add6 (&flags, &flags_length1, &_flags_size_, _tmp25_);
	}
	_tmp26_ = vala_signal_get_no_hooks (sig);
	if (_tmp26_) {
		gchar* _tmp27_;
		_tmp27_ = g_strdup ("G_SIGNAL_NO_HOOKS");
		_vala_array_add7 (&flags, &flags_length1, &_flags_size_, _tmp27_);
	}
	_tmp28_ = g_strjoinv (" | ", flags);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_ccode_constant_new (_tmp29_);
	_tmp31_ = _tmp30_;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp31_);
	_vala_ccode_node_unref0 (_tmp31_);
	_g_free0 (_tmp29_);
	_tmp32_ = vala_signal_get_default_handler (sig);
	if (_tmp32_ == NULL) {
		ValaCCodeConstant* _tmp33_ = NULL;
		ValaCCodeConstant* _tmp34_;
		_tmp33_ = vala_ccode_constant_new ("0");
		_tmp34_ = _tmp33_;
		vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp34_);
		_vala_ccode_node_unref0 (_tmp34_);
	} else {
		ValaCCodeIdentifier* _tmp35_ = NULL;
		ValaCCodeIdentifier* _tmp36_;
		ValaCCodeFunctionCall* _tmp37_ = NULL;
		ValaCCodeFunctionCall* _tmp38_;
		ValaCCodeFunctionCall* struct_offset;
		ValaMethod* _tmp49_ = NULL;
		const gchar* _tmp50_ = NULL;
		ValaCCodeIdentifier* _tmp51_ = NULL;
		ValaCCodeIdentifier* _tmp52_;
		_tmp35_ = vala_ccode_identifier_new ("G_STRUCT_OFFSET");
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp36_);
		_tmp38_ = _tmp37_;
		_vala_ccode_node_unref0 (_tmp36_);
		struct_offset = _tmp38_;
		if (VALA_IS_CLASS (type)) {
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_;
			ValaCCodeIdentifier* _tmp43_ = NULL;
			ValaCCodeIdentifier* _tmp44_;
			_tmp39_ = vala_typesymbol_get_cname (type, FALSE);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strdup_printf ("%sClass", _tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = vala_ccode_identifier_new (_tmp42_);
			_tmp44_ = _tmp43_;
			vala_ccode_function_call_add_argument (struct_offset, (ValaCCodeExpression*) _tmp44_);
			_vala_ccode_node_unref0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
		} else {
			gchar* _tmp45_ = NULL;
			gchar* _tmp46_;
			ValaCCodeIdentifier* _tmp47_ = NULL;
			ValaCCodeIdentifier* _tmp48_;
			_tmp45_ = vala_interface_get_type_cname (VALA_INTERFACE (type));
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_ccode_identifier_new (_tmp46_);
			_tmp48_ = _tmp47_;
			vala_ccode_function_call_add_argument (struct_offset, (ValaCCodeExpression*) _tmp48_);
			_vala_ccode_node_unref0 (_tmp48_);
			_g_free0 (_tmp46_);
		}
		_tmp49_ = vala_signal_get_default_handler (sig);
		_tmp50_ = vala_method_get_vfunc_name (_tmp49_);
		_tmp51_ = vala_ccode_identifier_new (_tmp50_);
		_tmp52_ = _tmp51_;
		vala_ccode_function_call_add_argument (struct_offset, (ValaCCodeExpression*) _tmp52_);
		_vala_ccode_node_unref0 (_tmp52_);
		vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) struct_offset);
		_vala_ccode_node_unref0 (struct_offset);
	}
	_tmp53_ = vala_ccode_constant_new ("NULL");
	_tmp54_ = _tmp53_;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp54_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp55_ = vala_ccode_constant_new ("NULL");
	_tmp56_ = _tmp55_;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp56_);
	_vala_ccode_node_unref0 (_tmp56_);
	_tmp57_ = vala_signal_get_parameters (sig);
	_tmp58_ = _tmp57_;
	_tmp59_ = vala_signal_get_return_type (sig);
	_tmp60_ = vala_gsignal_module_get_marshaller_function (self, _tmp58_, _tmp59_, NULL);
	_tmp61_ = _tmp60_;
	_vala_iterable_unref0 (_tmp58_);
	marshaller = _tmp61_;
	_tmp62_ = vala_ccode_identifier_new (marshaller);
	marshal_arg = _tmp62_;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) marshal_arg);
	_tmp63_ = vala_signal_get_parameters (sig);
	params = _tmp63_;
	_tmp65_ = vala_signal_get_return_type (sig);
	if (VALA_IS_POINTER_TYPE (_tmp65_)) {
		_tmp64_ = TRUE;
	} else {
		ValaDataType* _tmp66_ = NULL;
		ValaTypeParameter* _tmp67_ = NULL;
		_tmp66_ = vala_signal_get_return_type (sig);
		_tmp67_ = vala_data_type_get_type_parameter (_tmp66_);
		_tmp64_ = _tmp67_ != NULL;
	}
	if (_tmp64_) {
		ValaCCodeConstant* _tmp68_ = NULL;
		ValaCCodeConstant* _tmp69_;
		_tmp68_ = vala_ccode_constant_new ("G_TYPE_POINTER");
		_tmp69_ = _tmp68_;
		vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp69_);
		_vala_ccode_node_unref0 (_tmp69_);
	} else {
		ValaDataType* _tmp70_ = NULL;
		_tmp70_ = vala_signal_get_return_type (sig);
		if (VALA_IS_ERROR_TYPE (_tmp70_)) {
			ValaCCodeConstant* _tmp71_ = NULL;
			ValaCCodeConstant* _tmp72_;
			_tmp71_ = vala_ccode_constant_new ("G_TYPE_POINTER");
			_tmp72_ = _tmp71_;
			vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp72_);
			_vala_ccode_node_unref0 (_tmp72_);
		} else {
			ValaDataType* _tmp73_ = NULL;
			ValaTypeSymbol* _tmp74_ = NULL;
			_tmp73_ = vala_signal_get_return_type (sig);
			_tmp74_ = vala_data_type_get_data_type (_tmp73_);
			if (_tmp74_ == NULL) {
				ValaCCodeConstant* _tmp75_ = NULL;
				ValaCCodeConstant* _tmp76_;
				_tmp75_ = vala_ccode_constant_new ("G_TYPE_NONE");
				_tmp76_ = _tmp75_;
				vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp76_);
				_vala_ccode_node_unref0 (_tmp76_);
			} else {
				ValaDataType* _tmp77_ = NULL;
				ValaTypeSymbol* _tmp78_ = NULL;
				gchar* _tmp79_ = NULL;
				gchar* _tmp80_;
				ValaCCodeConstant* _tmp81_ = NULL;
				ValaCCodeConstant* _tmp82_;
				_tmp77_ = vala_signal_get_return_type (sig);
				_tmp78_ = vala_data_type_get_data_type (_tmp77_);
				_tmp79_ = vala_typesymbol_get_type_id (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = vala_ccode_constant_new (_tmp80_);
				_tmp82_ = _tmp81_;
				vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp82_);
				_vala_ccode_node_unref0 (_tmp82_);
				_g_free0 (_tmp80_);
			}
		}
	}
	params_len = 0;
	{
		ValaList* _tmp83_;
		ValaList* _param_list;
		gint _tmp84_;
		gint _param_size;
		gint _param_index;
		_tmp83_ = _vala_iterable_ref0 (params);
		_param_list = _tmp83_;
		_tmp84_ = vala_collection_get_size ((ValaCollection*) _param_list);
		_param_size = _tmp84_;
		_param_index = -1;
		while (TRUE) {
			gpointer _tmp85_ = NULL;
			ValaParameter* param;
			ValaDataType* _tmp86_ = NULL;
			gboolean _tmp87_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp85_ = vala_list_get (_param_list, _param_index);
			param = (ValaParameter*) _tmp85_;
			params_len++;
			_tmp86_ = vala_variable_get_variable_type ((ValaVariable*) param);
			_tmp87_ = vala_data_type_is_array (_tmp86_);
			if (_tmp87_) {
				params_len++;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp88_ = g_strdup_printf ("%d", params_len);
	_tmp89_ = _tmp88_;
	_tmp90_ = vala_ccode_constant_new (_tmp89_);
	_tmp91_ = _tmp90_;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp91_);
	_vala_ccode_node_unref0 (_tmp91_);
	_g_free0 (_tmp89_);
	{
		ValaList* _tmp92_;
		ValaList* _param_list;
		gint _tmp93_;
		gint _param_size;
		gint _param_index;
		_tmp92_ = _vala_iterable_ref0 (params);
		_param_list = _tmp92_;
		_tmp93_ = vala_collection_get_size ((ValaCollection*) _param_list);
		_param_size = _tmp93_;
		_param_index = -1;
		while (TRUE) {
			gpointer _tmp94_ = NULL;
			ValaParameter* param;
			ValaDataType* _tmp95_ = NULL;
			gboolean _tmp96_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp94_ = vala_list_get (_param_list, _param_index);
			param = (ValaParameter*) _tmp94_;
			_tmp95_ = vala_variable_get_variable_type ((ValaVariable*) param);
			_tmp96_ = vala_data_type_is_array (_tmp95_);
			if (_tmp96_) {
				ValaDataType* _tmp97_ = NULL;
				ValaDataType* _tmp98_ = NULL;
				ValaTypeSymbol* _tmp99_ = NULL;
				ValaTypeSymbol* _tmp100_ = NULL;
				ValaCCodeConstant* _tmp105_ = NULL;
				ValaCCodeConstant* _tmp106_;
				_tmp97_ = vala_variable_get_variable_type ((ValaVariable*) param);
				_tmp98_ = vala_array_type_get_element_type (VALA_ARRAY_TYPE (_tmp97_));
				_tmp99_ = vala_data_type_get_data_type (_tmp98_);
				_tmp100_ = vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type);
				if (_tmp99_ == _tmp100_) {
					ValaCCodeConstant* _tmp101_ = NULL;
					ValaCCodeConstant* _tmp102_;
					_tmp101_ = vala_ccode_constant_new ("G_TYPE_STRV");
					_tmp102_ = _tmp101_;
					vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp102_);
					_vala_ccode_node_unref0 (_tmp102_);
				} else {
					ValaCCodeConstant* _tmp103_ = NULL;
					ValaCCodeConstant* _tmp104_;
					_tmp103_ = vala_ccode_constant_new ("G_TYPE_POINTER");
					_tmp104_ = _tmp103_;
					vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp104_);
					_vala_ccode_node_unref0 (_tmp104_);
				}
				_tmp105_ = vala_ccode_constant_new ("G_TYPE_INT");
				_tmp106_ = _tmp105_;
				vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp106_);
				_vala_ccode_node_unref0 (_tmp106_);
			} else {
				gboolean _tmp107_ = FALSE;
				gboolean _tmp108_ = FALSE;
				ValaDataType* _tmp109_ = NULL;
				_tmp109_ = vala_variable_get_variable_type ((ValaVariable*) param);
				if (VALA_IS_POINTER_TYPE (_tmp109_)) {
					_tmp108_ = TRUE;
				} else {
					ValaDataType* _tmp110_ = NULL;
					ValaTypeParameter* _tmp111_ = NULL;
					_tmp110_ = vala_variable_get_variable_type ((ValaVariable*) param);
					_tmp111_ = vala_data_type_get_type_parameter (_tmp110_);
					_tmp108_ = _tmp111_ != NULL;
				}
				if (_tmp108_) {
					_tmp107_ = TRUE;
				} else {
					ValaParameterDirection _tmp112_;
					_tmp112_ = vala_parameter_get_direction (param);
					_tmp107_ = _tmp112_ != VALA_PARAMETER_DIRECTION_IN;
				}
				if (_tmp107_) {
					ValaCCodeConstant* _tmp113_ = NULL;
					ValaCCodeConstant* _tmp114_;
					_tmp113_ = vala_ccode_constant_new ("G_TYPE_POINTER");
					_tmp114_ = _tmp113_;
					vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp114_);
					_vala_ccode_node_unref0 (_tmp114_);
				} else {
					ValaDataType* _tmp115_ = NULL;
					_tmp115_ = vala_variable_get_variable_type ((ValaVariable*) param);
					if (VALA_IS_ERROR_TYPE (_tmp115_)) {
						ValaCCodeConstant* _tmp116_ = NULL;
						ValaCCodeConstant* _tmp117_;
						_tmp116_ = vala_ccode_constant_new ("G_TYPE_POINTER");
						_tmp117_ = _tmp116_;
						vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp117_);
						_vala_ccode_node_unref0 (_tmp117_);
					} else {
						ValaDataType* _tmp118_ = NULL;
						ValaTypeSymbol* _tmp119_ = NULL;
						gchar* _tmp120_ = NULL;
						gchar* _tmp121_;
						ValaCCodeConstant* _tmp122_ = NULL;
						ValaCCodeConstant* _tmp123_;
						_tmp118_ = vala_variable_get_variable_type ((ValaVariable*) param);
						_tmp119_ = vala_data_type_get_data_type (_tmp118_);
						_tmp120_ = vala_typesymbol_get_type_id (_tmp119_);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_ccode_constant_new (_tmp121_);
						_tmp123_ = _tmp122_;
						vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp123_);
						_vala_ccode_node_unref0 (_tmp123_);
						_g_free0 (_tmp121_);
					}
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	vala_ccode_identifier_set_name (marshal_arg, marshaller);
	result = csignew;
	_vala_iterable_unref0 (params);
	_vala_ccode_node_unref0 (marshal_arg);
	_g_free0 (marshaller);
	flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void vala_gsignal_module_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr) {
	ValaGSignalModule * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_ = NULL;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp2_ = vala_element_access_get_container (expr);
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		ValaExpression* _tmp3_ = NULL;
		ValaSymbol* _tmp4_ = NULL;
		_tmp3_ = vala_element_access_get_container (expr);
		_tmp4_ = vala_expression_get_symbol_reference (_tmp3_);
		_tmp1_ = VALA_IS_SIGNAL (_tmp4_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaCodeNode* _tmp5_ = NULL;
		_tmp5_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
		_tmp0_ = VALA_IS_METHOD_CALL (_tmp5_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaSymbol* _tmp6_ = NULL;
		ValaSignal* _tmp7_;
		ValaSignal* sig;
		ValaExpression* _tmp8_ = NULL;
		ValaMemberAccess* _tmp9_;
		ValaMemberAccess* ma;
		ValaList* _tmp10_ = NULL;
		ValaList* _tmp11_;
		gpointer _tmp12_ = NULL;
		ValaExpression* _tmp13_;
		ValaExpression* detail_expr;
		ValaCCodeExpression* _tmp14_ = NULL;
		ValaCCodeExpression* signal_name_cexpr;
		ValaCCodeIdentifier* _tmp15_ = NULL;
		ValaCCodeIdentifier* _tmp16_;
		ValaCCodeFunctionCall* _tmp17_ = NULL;
		ValaCCodeFunctionCall* _tmp18_;
		ValaCCodeFunctionCall* ccall;
		ValaExpression* _tmp19_ = NULL;
		ValaCCodeExpression* _tmp20_ = NULL;
		ValaCCodeExpression* _tmp21_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
		_tmp7_ = _vala_code_node_ref0 (VALA_SIGNAL (_tmp6_));
		sig = _tmp7_;
		_tmp8_ = vala_element_access_get_container (expr);
		_tmp9_ = _vala_code_node_ref0 (VALA_MEMBER_ACCESS (_tmp8_));
		ma = _tmp9_;
		_tmp10_ = vala_element_access_get_indices (expr);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_list_get (_tmp11_, 0);
		_tmp13_ = (ValaExpression*) _tmp12_;
		_vala_iterable_unref0 (_tmp11_);
		detail_expr = _tmp13_;
		_tmp14_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, detail_expr, (ValaCodeNode*) expr);
		signal_name_cexpr = _tmp14_;
		_tmp15_ = vala_ccode_identifier_new ("g_signal_emit_by_name");
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp16_);
		_tmp18_ = _tmp17_;
		_vala_ccode_node_unref0 (_tmp16_);
		ccall = _tmp18_;
		_tmp19_ = vala_member_access_get_inner (ma);
		_tmp20_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp19_);
		_tmp21_ = _tmp20_;
		vala_ccode_function_call_add_argument (ccall, _tmp21_);
		_vala_ccode_node_unref0 (_tmp21_);
		if (signal_name_cexpr != NULL) {
			vala_ccode_function_call_add_argument (ccall, signal_name_cexpr);
		}
		vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) ccall);
		_vala_ccode_node_unref0 (ccall);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		_vala_code_node_unref0 (detail_expr);
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (sig);
	} else {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_element_access ((ValaCodeVisitor*) VALA_GOBJECT_MODULE (self), expr);
	}
}


static gboolean vala_gsignal_module_in_gobject_instance (ValaGSignalModule* self, ValaMethod* m) {
	gboolean result = FALSE;
	gboolean _result_;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	_result_ = FALSE;
	_tmp0_ = vala_method_get_binding (m);
	if (_tmp0_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaParameter* _tmp1_ = NULL;
		ValaDataType* _tmp2_ = NULL;
		ValaTypeSymbol* _tmp3_ = NULL;
		gboolean _tmp4_;
		_tmp1_ = vala_method_get_this_parameter (m);
		_tmp2_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1_);
		_tmp3_ = vala_data_type_get_data_type (_tmp2_);
		_tmp4_ = vala_typesymbol_is_subtype_of (_tmp3_, ((ValaCCodeBaseModule*) self)->gobject_type);
		_result_ = _tmp4_;
	}
	result = _result_;
	return result;
}


static void vala_gsignal_module_emit_signal_assignment (ValaGSignalModule* self, ValaAssignment* assignment) {
	ValaExpression* _tmp0_ = NULL;
	ValaSymbol* _tmp1_ = NULL;
	ValaSignal* _tmp2_;
	ValaSignal* sig;
	gboolean disconnect;
	ValaAssignmentOperator _tmp3_;
	ValaExpression* _tmp6_ = NULL;
	ValaExpression* _tmp7_ = NULL;
	ValaCCodeExpression* _tmp8_ = NULL;
	ValaCCodeExpression* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (assignment != NULL);
	_tmp0_ = vala_assignment_get_left (assignment);
	_tmp1_ = vala_expression_get_symbol_reference (_tmp0_);
	_tmp2_ = _vala_code_node_ref0 (VALA_SIGNAL (_tmp1_));
	sig = _tmp2_;
	disconnect = FALSE;
	_tmp3_ = vala_assignment_get_operator (assignment);
	if (_tmp3_ == VALA_ASSIGNMENT_OPERATOR_ADD) {
	} else {
		ValaAssignmentOperator _tmp4_;
		_tmp4_ = vala_assignment_get_operator (assignment);
		if (_tmp4_ == VALA_ASSIGNMENT_OPERATOR_SUB) {
			disconnect = TRUE;
		} else {
			ValaSourceReference* _tmp5_ = NULL;
			vala_code_node_set_error ((ValaCodeNode*) assignment, TRUE);
			_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) assignment);
			vala_report_error (_tmp5_, "Specified compound assignment type for signals not supported.");
			_vala_code_node_unref0 (sig);
			return;
		}
	}
	_tmp6_ = vala_assignment_get_left (assignment);
	_tmp7_ = vala_assignment_get_right (assignment);
	_tmp8_ = vala_gsignal_module_connect_signal (self, sig, _tmp6_, _tmp7_, disconnect, FALSE, (ValaCodeNode*) assignment);
	_tmp9_ = _tmp8_;
	_vala_ccode_node_unref0 (_tmp9_);
	_vala_code_node_unref0 (sig);
}


static void vala_gsignal_module_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* assignment) {
	ValaGSignalModule * self;
	ValaExpression* _tmp0_ = NULL;
	ValaSymbol* _tmp1_ = NULL;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (assignment != NULL);
	_tmp0_ = vala_assignment_get_left (assignment);
	_tmp1_ = vala_expression_get_symbol_reference (_tmp0_);
	if (VALA_IS_SIGNAL (_tmp1_)) {
		gboolean _tmp2_ = FALSE;
		ValaExpression* _tmp3_ = NULL;
		gboolean _tmp4_;
		_tmp3_ = vala_assignment_get_left (assignment);
		_tmp4_ = vala_code_node_get_error ((ValaCodeNode*) _tmp3_);
		if (_tmp4_) {
			_tmp2_ = TRUE;
		} else {
			ValaExpression* _tmp5_ = NULL;
			gboolean _tmp6_;
			_tmp5_ = vala_assignment_get_right (assignment);
			_tmp6_ = vala_code_node_get_error ((ValaCodeNode*) _tmp5_);
			_tmp2_ = _tmp6_;
		}
		if (_tmp2_) {
			vala_code_node_set_error ((ValaCodeNode*) assignment, TRUE);
			return;
		}
		vala_gsignal_module_emit_signal_assignment (self, assignment);
	} else {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_assignment ((ValaCodeVisitor*) VALA_GOBJECT_MODULE (self), assignment);
	}
}


static void vala_gsignal_module_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr) {
	ValaGSignalModule * self;
	ValaSymbol* _tmp0_ = NULL;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
	if (VALA_IS_SIGNAL (_tmp0_)) {
		ValaCCodeExpression* pub_inst;
		ValaExpression* _tmp1_ = NULL;
		ValaSymbol* _tmp4_ = NULL;
		ValaSignal* _tmp5_;
		ValaSignal* sig;
		ValaSymbol* _tmp6_ = NULL;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* cl;
		gboolean _tmp8_ = FALSE;
		ValaExpression* _tmp9_ = NULL;
		gboolean _tmp33_;
		pub_inst = NULL;
		_tmp1_ = vala_member_access_get_inner (expr);
		if (_tmp1_ != NULL) {
			ValaExpression* _tmp2_ = NULL;
			ValaCCodeExpression* _tmp3_ = NULL;
			_tmp2_ = vala_member_access_get_inner (expr);
			_tmp3_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp2_);
			_vala_ccode_node_unref0 (pub_inst);
			pub_inst = _tmp3_;
		}
		_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
		_tmp5_ = _vala_code_node_ref0 (VALA_SIGNAL (_tmp4_));
		sig = _tmp5_;
		_tmp6_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
		_tmp7_ = _vala_code_node_ref0 (VALA_TYPESYMBOL (_tmp6_));
		cl = _tmp7_;
		_tmp9_ = vala_member_access_get_inner (expr);
		if (VALA_IS_BASE_ACCESS (_tmp9_)) {
			gboolean _tmp10_;
			_tmp10_ = vala_signal_get_is_virtual (sig);
			_tmp8_ = _tmp10_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			ValaMethod* _tmp11_ = NULL;
			ValaMethod* _tmp12_;
			ValaMethod* m;
			ValaSymbol* _tmp13_ = NULL;
			ValaClass* _tmp14_;
			ValaClass* base_class;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			ValaCCodeIdentifier* _tmp19_ = NULL;
			ValaCCodeIdentifier* _tmp20_;
			ValaCCodeFunctionCall* _tmp21_ = NULL;
			ValaCCodeFunctionCall* _tmp22_;
			ValaCCodeFunctionCall* vcast;
			ValaClass* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			ValaCCodeIdentifier* _tmp28_ = NULL;
			ValaCCodeIdentifier* _tmp29_;
			const gchar* _tmp30_ = NULL;
			ValaCCodeMemberAccess* _tmp31_ = NULL;
			ValaCCodeMemberAccess* _tmp32_;
			_tmp11_ = vala_signal_get_default_handler (sig);
			_tmp12_ = _vala_code_node_ref0 (_tmp11_);
			m = _tmp12_;
			_tmp13_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
			_tmp14_ = _vala_code_node_ref0 (VALA_CLASS (_tmp13_));
			base_class = _tmp14_;
			_tmp15_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strdup_printf ("%s_CLASS", _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_ccode_identifier_new (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp20_);
			_tmp22_ = _tmp21_;
			_vala_ccode_node_unref0 (_tmp20_);
			_g_free0 (_tmp18_);
			_g_free0 (_tmp16_);
			vcast = _tmp22_;
			_tmp23_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp24_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) _tmp23_, NULL);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strdup_printf ("%s_parent_class", _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = vala_ccode_identifier_new (_tmp27_);
			_tmp29_ = _tmp28_;
			vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) _tmp29_);
			_vala_ccode_node_unref0 (_tmp29_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp25_);
			_tmp30_ = vala_symbol_get_name ((ValaSymbol*) m);
			_tmp31_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, _tmp30_);
			_tmp32_ = _tmp31_;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp32_);
			_vala_ccode_node_unref0 (_tmp32_);
			_vala_ccode_node_unref0 (vcast);
			_vala_code_node_unref0 (base_class);
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (sig);
			_vala_ccode_node_unref0 (pub_inst);
			return;
		}
		_tmp33_ = vala_signal_get_has_emitter (sig);
		if (_tmp33_) {
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_;
			const gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			gchar* _tmp38_;
			ValaCCodeIdentifier* _tmp39_ = NULL;
			ValaCCodeIdentifier* _tmp40_;
			ValaCCodeFunctionCall* _tmp41_ = NULL;
			ValaCCodeFunctionCall* _tmp42_;
			ValaCCodeFunctionCall* ccall;
			_tmp34_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_symbol_get_name ((ValaSymbol*) sig);
			_tmp37_ = g_strdup_printf ("%s_%s", _tmp35_, _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_ccode_identifier_new (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp40_);
			_tmp42_ = _tmp41_;
			_vala_ccode_node_unref0 (_tmp40_);
			_g_free0 (_tmp38_);
			_g_free0 (_tmp35_);
			ccall = _tmp42_;
			vala_ccode_function_call_add_argument (ccall, pub_inst);
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) ccall);
			_vala_ccode_node_unref0 (ccall);
		} else {
			ValaCCodeIdentifier* _tmp43_ = NULL;
			ValaCCodeIdentifier* _tmp44_;
			ValaCCodeFunctionCall* _tmp45_ = NULL;
			ValaCCodeFunctionCall* _tmp46_;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeConstant* _tmp47_ = NULL;
			ValaCCodeConstant* _tmp48_;
			_tmp43_ = vala_ccode_identifier_new ("g_signal_emit_by_name");
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp44_);
			_tmp46_ = _tmp45_;
			_vala_ccode_node_unref0 (_tmp44_);
			ccall = _tmp46_;
			vala_ccode_function_call_add_argument (ccall, pub_inst);
			_tmp47_ = vala_signal_get_canonical_cconstant (sig, NULL);
			_tmp48_ = _tmp47_;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp48_);
			_vala_ccode_node_unref0 (_tmp48_);
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) ccall);
			_vala_ccode_node_unref0 (ccall);
		}
		_vala_code_node_unref0 (cl);
		_vala_code_node_unref0 (sig);
		_vala_ccode_node_unref0 (pub_inst);
	} else {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_member_access ((ValaCodeVisitor*) VALA_GOBJECT_MODULE (self), expr);
	}
}


static void vala_gsignal_module_real_visit_method_call (ValaCodeVisitor* base, ValaMethodCall* expr) {
	ValaGSignalModule * self;
	ValaExpression* _tmp0_ = NULL;
	ValaDataType* _tmp1_ = NULL;
	ValaDataType* _tmp2_;
	ValaMethodType* _tmp3_;
	ValaMethodType* method_type;
	gboolean _tmp4_ = FALSE;
	ValaMethod* _tmp7_ = NULL;
	ValaSymbol* _tmp8_ = NULL;
	ValaSignal* _tmp9_;
	ValaSignal* sig;
	ValaExpression* _tmp10_ = NULL;
	ValaExpression* _tmp11_ = NULL;
	ValaExpression* _tmp12_;
	ValaExpression* signal_access;
	ValaList* _tmp13_ = NULL;
	ValaList* _tmp14_;
	gpointer _tmp15_ = NULL;
	ValaExpression* _tmp16_;
	ValaExpression* handler;
	ValaMethod* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gboolean disconnect;
	ValaMethod* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gboolean after;
	ValaCCodeExpression* _tmp21_ = NULL;
	ValaCCodeExpression* cexpr;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = vala_expression_get_value_type (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_code_node_ref0 (VALA_IS_METHOD_TYPE (_tmp2_) ? ((ValaMethodType*) _tmp2_) : NULL);
	method_type = _tmp3_;
	if (method_type == NULL) {
		_tmp4_ = TRUE;
	} else {
		ValaMethod* _tmp5_ = NULL;
		ValaSymbol* _tmp6_ = NULL;
		_tmp5_ = vala_method_type_get_method_symbol (method_type);
		_tmp6_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp5_);
		_tmp4_ = !VALA_IS_SIGNAL (_tmp6_);
	}
	if (_tmp4_) {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_method_call ((ValaCodeVisitor*) VALA_GOBJECT_MODULE (self), expr);
		_vala_code_node_unref0 (method_type);
		return;
	}
	_tmp7_ = vala_method_type_get_method_symbol (method_type);
	_tmp8_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp7_);
	_tmp9_ = _vala_code_node_ref0 (VALA_SIGNAL (_tmp8_));
	sig = _tmp9_;
	_tmp10_ = vala_method_call_get_call (expr);
	_tmp11_ = vala_member_access_get_inner (VALA_MEMBER_ACCESS (_tmp10_));
	_tmp12_ = _vala_code_node_ref0 (_tmp11_);
	signal_access = _tmp12_;
	_tmp13_ = vala_method_call_get_argument_list (expr);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_list_get (_tmp14_, 0);
	_tmp16_ = (ValaExpression*) _tmp15_;
	_vala_iterable_unref0 (_tmp14_);
	handler = _tmp16_;
	_tmp17_ = vala_method_type_get_method_symbol (method_type);
	_tmp18_ = vala_symbol_get_name ((ValaSymbol*) _tmp17_);
	disconnect = g_strcmp0 (_tmp18_, "disconnect") == 0;
	_tmp19_ = vala_method_type_get_method_symbol (method_type);
	_tmp20_ = vala_symbol_get_name ((ValaSymbol*) _tmp19_);
	after = g_strcmp0 (_tmp20_, "connect_after") == 0;
	_tmp21_ = vala_gsignal_module_connect_signal (self, sig, signal_access, handler, disconnect, after, (ValaCodeNode*) expr);
	cexpr = _tmp21_;
	vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, cexpr);
	_vala_ccode_node_unref0 (cexpr);
	_vala_code_node_unref0 (handler);
	_vala_code_node_unref0 (signal_access);
	_vala_code_node_unref0 (sig);
	_vala_code_node_unref0 (method_type);
}


static ValaCCodeExpression* vala_gsignal_module_connect_signal (ValaGSignalModule* self, ValaSignal* sig, ValaExpression* signal_access, ValaExpression* handler, gboolean disconnect, gboolean after, ValaCodeNode* expr) {
	ValaCCodeExpression* result = NULL;
	gchar* connect_func = NULL;
	ValaSymbol* _tmp0_ = NULL;
	ValaMethod* _tmp1_;
	ValaMethod* m;
	ValaCCodeIdentifier* _tmp13_ = NULL;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_ = NULL;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeExpression* signal_name_cexpr;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp27_ = NULL;
	ValaCCodeExpression* _tmp81_ = NULL;
	ValaCCodeExpression* _tmp82_;
	ValaCCodeCastExpression* _tmp83_ = NULL;
	ValaCCodeCastExpression* _tmp84_;
	gboolean _tmp85_;
	gboolean _tmp114_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (signal_access != NULL, NULL);
	g_return_val_if_fail (handler != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	_tmp0_ = vala_expression_get_symbol_reference (handler);
	_tmp1_ = _vala_code_node_ref0 (VALA_METHOD (_tmp0_));
	m = _tmp1_;
	if (!disconnect) {
		if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
			if (!after) {
				gchar* _tmp2_ = NULL;
				_tmp2_ = vala_ccode_base_module_get_dynamic_signal_connect_wrapper_name ((ValaCCodeBaseModule*) self, VALA_DYNAMIC_SIGNAL (sig));
				_g_free0 (connect_func);
				connect_func = _tmp2_;
			} else {
				gchar* _tmp3_ = NULL;
				_tmp3_ = vala_ccode_base_module_get_dynamic_signal_connect_after_wrapper_name ((ValaCCodeBaseModule*) self, VALA_DYNAMIC_SIGNAL (sig));
				_g_free0 (connect_func);
				connect_func = _tmp3_;
			}
		} else {
			gboolean _tmp4_;
			_tmp4_ = vala_method_get_closure (m);
			if (_tmp4_) {
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("g_signal_connect_data");
				_g_free0 (connect_func);
				connect_func = _tmp5_;
			} else {
				gboolean _tmp6_;
				_tmp6_ = vala_gsignal_module_in_gobject_instance (self, m);
				if (_tmp6_) {
					gchar* _tmp7_;
					_tmp7_ = g_strdup ("g_signal_connect_object");
					_g_free0 (connect_func);
					connect_func = _tmp7_;
				} else {
					if (!after) {
						gchar* _tmp8_;
						_tmp8_ = g_strdup ("g_signal_connect");
						_g_free0 (connect_func);
						connect_func = _tmp8_;
					} else {
						gchar* _tmp9_;
						_tmp9_ = g_strdup ("g_signal_connect_after");
						_g_free0 (connect_func);
						connect_func = _tmp9_;
					}
				}
			}
		}
	} else {
		if (VALA_IS_LAMBDA_EXPRESSION (handler)) {
			ValaSourceReference* _tmp10_ = NULL;
			_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) handler);
			vala_report_error (_tmp10_, "Cannot disconnect lambda expression from signal. Use Object.disconnect" \
".");
		}
		if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
			gchar* _tmp11_ = NULL;
			_tmp11_ = vala_ccode_base_module_get_dynamic_signal_disconnect_wrapper_name ((ValaCCodeBaseModule*) self, VALA_DYNAMIC_SIGNAL (sig));
			_g_free0 (connect_func);
			connect_func = _tmp11_;
		} else {
			gchar* _tmp12_;
			_tmp12_ = g_strdup ("g_signal_handlers_disconnect_matched");
			_g_free0 (connect_func);
			connect_func = _tmp12_;
		}
	}
	_tmp13_ = vala_ccode_identifier_new (connect_func);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp14_);
	_tmp16_ = _tmp15_;
	_vala_ccode_node_unref0 (_tmp14_);
	ccall = _tmp16_;
	signal_name_cexpr = NULL;
	if (VALA_IS_ELEMENT_ACCESS (signal_access)) {
		ValaElementAccess* _tmp17_;
		ValaElementAccess* ea;
		ValaExpression* _tmp18_ = NULL;
		ValaMemberAccess* _tmp19_;
		ValaList* _tmp20_ = NULL;
		ValaList* _tmp21_;
		gpointer _tmp22_ = NULL;
		ValaExpression* _tmp23_;
		ValaExpression* detail_expr;
		ValaCCodeExpression* _tmp24_ = NULL;
		_tmp17_ = _vala_code_node_ref0 (VALA_ELEMENT_ACCESS (signal_access));
		ea = _tmp17_;
		_tmp18_ = vala_element_access_get_container (ea);
		_tmp19_ = _vala_code_node_ref0 (VALA_MEMBER_ACCESS (_tmp18_));
		_vala_code_node_unref0 (ma);
		ma = _tmp19_;
		_tmp20_ = vala_element_access_get_indices (ea);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_list_get (_tmp21_, 0);
		_tmp23_ = (ValaExpression*) _tmp22_;
		_vala_iterable_unref0 (_tmp21_);
		detail_expr = _tmp23_;
		_tmp24_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, detail_expr, expr);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		signal_name_cexpr = _tmp24_;
		if (signal_name_cexpr == NULL) {
			result = NULL;
			_vala_code_node_unref0 (detail_expr);
			_vala_code_node_unref0 (ea);
			_vala_code_node_unref0 (ma);
			_vala_ccode_node_unref0 (signal_name_cexpr);
			_vala_ccode_node_unref0 (ccall);
			_vala_code_node_unref0 (m);
			_g_free0 (connect_func);
			return result;
		}
		_vala_code_node_unref0 (detail_expr);
		_vala_code_node_unref0 (ea);
	} else {
		ValaMemberAccess* _tmp25_;
		ValaCCodeExpression* _tmp26_ = NULL;
		_tmp25_ = _vala_code_node_ref0 (VALA_MEMBER_ACCESS (signal_access));
		_vala_code_node_unref0 (ma);
		ma = _tmp25_;
		_tmp26_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, NULL, expr);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		signal_name_cexpr = _tmp26_;
	}
	_tmp27_ = vala_member_access_get_inner (ma);
	if (_tmp27_ != NULL) {
		ValaExpression* _tmp28_ = NULL;
		ValaCCodeExpression* _tmp29_ = NULL;
		ValaCCodeExpression* _tmp30_;
		_tmp28_ = vala_member_access_get_inner (ma);
		_tmp29_ = vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, _tmp28_);
		_tmp30_ = VALA_CCODE_EXPRESSION (_tmp29_);
		vala_ccode_function_call_add_argument (ccall, _tmp30_);
		_vala_ccode_node_unref0 (_tmp30_);
	} else {
		ValaCCodeExpression* _tmp31_ = NULL;
		ValaCCodeExpression* _tmp32_;
		_tmp31_ = vala_ccode_base_module_get_result_cexpression ((ValaCCodeBaseModule*) self, "self");
		_tmp32_ = _tmp31_;
		vala_ccode_function_call_add_argument (ccall, _tmp32_);
		_vala_ccode_node_unref0 (_tmp32_);
	}
	if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		ValaCCodeConstant* _tmp36_ = NULL;
		ValaCCodeConstant* _tmp37_;
		_tmp33_ = vala_symbol_get_name ((ValaSymbol*) sig);
		_tmp34_ = g_strdup_printf ("\"%s\"", _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_ccode_constant_new (_tmp35_);
		_tmp37_ = _tmp36_;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp37_);
		_vala_ccode_node_unref0 (_tmp37_);
		_g_free0 (_tmp35_);
	} else {
		if (!disconnect) {
			vala_ccode_function_call_add_argument (ccall, signal_name_cexpr);
		} else {
			ValaLocalVariable* _tmp42_ = NULL;
			ValaLocalVariable* temp_decl;
			ValaCCodeIdentifier* _tmp43_ = NULL;
			ValaCCodeIdentifier* _tmp44_;
			ValaCCodeFunctionCall* _tmp45_ = NULL;
			ValaCCodeFunctionCall* _tmp46_;
			ValaCCodeFunctionCall* parse_call;
			ValaSymbol* _tmp47_ = NULL;
			ValaTypeSymbol* _tmp48_;
			ValaTypeSymbol* decl_type;
			gchar* _tmp49_ = NULL;
			gchar* _tmp50_;
			ValaCCodeIdentifier* _tmp51_ = NULL;
			ValaCCodeIdentifier* _tmp52_;
			const gchar* _tmp53_ = NULL;
			ValaCCodeExpression* _tmp54_ = NULL;
			ValaCCodeExpression* _tmp55_;
			ValaCCodeUnaryExpression* _tmp56_ = NULL;
			ValaCCodeUnaryExpression* _tmp57_;
			ValaLocalVariable* detail_temp_decl;
			ValaCCodeFunction* _tmp70_ = NULL;
			const gchar* _tmp71_ = NULL;
			ValaCCodeExpression* _tmp72_ = NULL;
			ValaCCodeExpression* _tmp73_;
			ValaCCodeConstant* _tmp79_ = NULL;
			ValaCCodeConstant* _tmp80_;
			if (!VALA_IS_ELEMENT_ACCESS (signal_access)) {
				ValaCCodeConstant* _tmp38_ = NULL;
				ValaCCodeConstant* _tmp39_;
				_tmp38_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA");
				_tmp39_ = _tmp38_;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp39_);
				_vala_ccode_node_unref0 (_tmp39_);
			} else {
				ValaCCodeConstant* _tmp40_ = NULL;
				ValaCCodeConstant* _tmp41_;
				_tmp40_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SI" \
"GNAL_MATCH_DATA");
				_tmp41_ = _tmp40_;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp41_);
				_vala_ccode_node_unref0 (_tmp41_);
			}
			_tmp42_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->uint_type, TRUE, NULL, TRUE);
			temp_decl = _tmp42_;
			vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, temp_decl, FALSE);
			_tmp43_ = vala_ccode_identifier_new ("g_signal_parse_name");
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp44_);
			_tmp46_ = _tmp45_;
			_vala_ccode_node_unref0 (_tmp44_);
			parse_call = _tmp46_;
			vala_ccode_function_call_add_argument (parse_call, signal_name_cexpr);
			_tmp47_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
			_tmp48_ = _vala_code_node_ref0 (VALA_TYPESYMBOL (_tmp47_));
			decl_type = _tmp48_;
			_tmp49_ = vala_typesymbol_get_type_id (decl_type);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_ccode_identifier_new (_tmp50_);
			_tmp52_ = _tmp51_;
			vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) _tmp52_);
			_vala_ccode_node_unref0 (_tmp52_);
			_g_free0 (_tmp50_);
			_tmp53_ = vala_symbol_get_name ((ValaSymbol*) temp_decl);
			_tmp54_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp55_);
			_tmp57_ = _tmp56_;
			vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) _tmp57_);
			_vala_ccode_node_unref0 (_tmp57_);
			_vala_ccode_node_unref0 (_tmp55_);
			detail_temp_decl = NULL;
			if (!VALA_IS_ELEMENT_ACCESS (signal_access)) {
				ValaCCodeConstant* _tmp58_ = NULL;
				ValaCCodeConstant* _tmp59_;
				ValaCCodeConstant* _tmp60_ = NULL;
				ValaCCodeConstant* _tmp61_;
				_tmp58_ = vala_ccode_constant_new ("NULL");
				_tmp59_ = _tmp58_;
				vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) _tmp59_);
				_vala_ccode_node_unref0 (_tmp59_);
				_tmp60_ = vala_ccode_constant_new ("FALSE");
				_tmp61_ = _tmp60_;
				vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) _tmp61_);
				_vala_ccode_node_unref0 (_tmp61_);
			} else {
				ValaLocalVariable* _tmp62_ = NULL;
				const gchar* _tmp63_ = NULL;
				ValaCCodeIdentifier* _tmp64_ = NULL;
				ValaCCodeIdentifier* _tmp65_;
				ValaCCodeUnaryExpression* _tmp66_ = NULL;
				ValaCCodeUnaryExpression* _tmp67_;
				ValaCCodeConstant* _tmp68_ = NULL;
				ValaCCodeConstant* _tmp69_;
				_tmp62_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->gquark_type, TRUE, NULL, TRUE);
				_vala_code_node_unref0 (detail_temp_decl);
				detail_temp_decl = _tmp62_;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, detail_temp_decl, FALSE);
				_tmp63_ = vala_symbol_get_name ((ValaSymbol*) detail_temp_decl);
				_tmp64_ = vala_ccode_identifier_new (_tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp65_);
				_tmp67_ = _tmp66_;
				vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) _tmp67_);
				_vala_ccode_node_unref0 (_tmp67_);
				_vala_ccode_node_unref0 (_tmp65_);
				_tmp68_ = vala_ccode_constant_new ("TRUE");
				_tmp69_ = _tmp68_;
				vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) _tmp69_);
				_vala_ccode_node_unref0 (_tmp69_);
			}
			_tmp70_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			vala_ccode_function_add_expression (_tmp70_, (ValaCCodeExpression*) parse_call);
			_tmp71_ = vala_symbol_get_name ((ValaSymbol*) temp_decl);
			_tmp72_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp71_);
			_tmp73_ = _tmp72_;
			vala_ccode_function_call_add_argument (ccall, _tmp73_);
			_vala_ccode_node_unref0 (_tmp73_);
			if (detail_temp_decl == NULL) {
				ValaCCodeConstant* _tmp74_ = NULL;
				ValaCCodeConstant* _tmp75_;
				_tmp74_ = vala_ccode_constant_new ("0");
				_tmp75_ = _tmp74_;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp75_);
				_vala_ccode_node_unref0 (_tmp75_);
			} else {
				const gchar* _tmp76_ = NULL;
				ValaCCodeExpression* _tmp77_ = NULL;
				ValaCCodeExpression* _tmp78_;
				_tmp76_ = vala_symbol_get_name ((ValaSymbol*) detail_temp_decl);
				_tmp77_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp76_);
				_tmp78_ = _tmp77_;
				vala_ccode_function_call_add_argument (ccall, _tmp78_);
				_vala_ccode_node_unref0 (_tmp78_);
			}
			_tmp79_ = vala_ccode_constant_new ("NULL");
			_tmp80_ = _tmp79_;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp80_);
			_vala_ccode_node_unref0 (_tmp80_);
			_vala_code_node_unref0 (detail_temp_decl);
			_vala_code_node_unref0 (decl_type);
			_vala_ccode_node_unref0 (parse_call);
			_vala_code_node_unref0 (temp_decl);
		}
	}
	_tmp81_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, handler);
	_tmp82_ = _tmp81_;
	_tmp83_ = vala_ccode_cast_expression_new (_tmp82_, "GCallback");
	_tmp84_ = _tmp83_;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp84_);
	_vala_ccode_node_unref0 (_tmp84_);
	_vala_ccode_node_unref0 (_tmp82_);
	_tmp85_ = vala_method_get_closure (m);
	if (_tmp85_) {
		ValaCCodeExpression* handler_destroy_notify = NULL;
		ValaCCodeExpression* _tmp86_ = NULL;
		ValaCCodeExpression* _tmp87_ = NULL;
		ValaCCodeExpression* _tmp88_;
		ValaCCodeCastExpression* _tmp89_ = NULL;
		ValaCCodeCastExpression* _tmp90_;
		_tmp87_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, handler, &_tmp86_);
		_vala_ccode_node_unref0 (handler_destroy_notify);
		handler_destroy_notify = _tmp86_;
		_tmp88_ = _tmp87_;
		vala_ccode_function_call_add_argument (ccall, _tmp88_);
		_vala_ccode_node_unref0 (_tmp88_);
		_tmp89_ = vala_ccode_cast_expression_new (handler_destroy_notify, "GClosureNotify");
		_tmp90_ = _tmp89_;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp90_);
		_vala_ccode_node_unref0 (_tmp90_);
		if (!after) {
			ValaCCodeConstant* _tmp91_ = NULL;
			ValaCCodeConstant* _tmp92_;
			_tmp91_ = vala_ccode_constant_new ("0");
			_tmp92_ = _tmp91_;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp92_);
			_vala_ccode_node_unref0 (_tmp92_);
		} else {
			ValaCCodeConstant* _tmp93_ = NULL;
			ValaCCodeConstant* _tmp94_;
			_tmp93_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
			_tmp94_ = _tmp93_;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp94_);
			_vala_ccode_node_unref0 (_tmp94_);
		}
		_vala_ccode_node_unref0 (handler_destroy_notify);
	} else {
		ValaMemberBinding _tmp95_;
		_tmp95_ = vala_method_get_binding (m);
		if (_tmp95_ == VALA_MEMBER_BINDING_INSTANCE) {
			gboolean _tmp105_ = FALSE;
			gboolean _tmp106_ = FALSE;
			if (VALA_IS_MEMBER_ACCESS (handler)) {
				ValaMemberAccess* _tmp96_;
				ValaMemberAccess* right_ma;
				ValaExpression* _tmp97_ = NULL;
				_tmp96_ = _vala_code_node_ref0 (VALA_MEMBER_ACCESS (handler));
				right_ma = _tmp96_;
				_tmp97_ = vala_member_access_get_inner (right_ma);
				if (_tmp97_ != NULL) {
					ValaExpression* _tmp98_ = NULL;
					ValaCCodeExpression* _tmp99_ = NULL;
					ValaCCodeExpression* _tmp100_;
					_tmp98_ = vala_member_access_get_inner (right_ma);
					_tmp99_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp98_);
					_tmp100_ = _tmp99_;
					vala_ccode_function_call_add_argument (ccall, _tmp100_);
					_vala_ccode_node_unref0 (_tmp100_);
				} else {
					ValaCCodeExpression* _tmp101_ = NULL;
					ValaCCodeExpression* _tmp102_;
					_tmp101_ = vala_ccode_base_module_get_result_cexpression ((ValaCCodeBaseModule*) self, "self");
					_tmp102_ = _tmp101_;
					vala_ccode_function_call_add_argument (ccall, _tmp102_);
					_vala_ccode_node_unref0 (_tmp102_);
				}
				_vala_code_node_unref0 (right_ma);
			} else {
				if (VALA_IS_LAMBDA_EXPRESSION (handler)) {
					ValaCCodeExpression* _tmp103_ = NULL;
					ValaCCodeExpression* _tmp104_;
					_tmp103_ = vala_ccode_base_module_get_result_cexpression ((ValaCCodeBaseModule*) self, "self");
					_tmp104_ = _tmp103_;
					vala_ccode_function_call_add_argument (ccall, _tmp104_);
					_vala_ccode_node_unref0 (_tmp104_);
				}
			}
			if (!disconnect) {
				_tmp106_ = !VALA_IS_DYNAMIC_SIGNAL (sig);
			} else {
				_tmp106_ = FALSE;
			}
			if (_tmp106_) {
				gboolean _tmp107_;
				_tmp107_ = vala_gsignal_module_in_gobject_instance (self, m);
				_tmp105_ = _tmp107_;
			} else {
				_tmp105_ = FALSE;
			}
			if (_tmp105_) {
				if (!after) {
					ValaCCodeConstant* _tmp108_ = NULL;
					ValaCCodeConstant* _tmp109_;
					_tmp108_ = vala_ccode_constant_new ("0");
					_tmp109_ = _tmp108_;
					vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp109_);
					_vala_ccode_node_unref0 (_tmp109_);
				} else {
					ValaCCodeConstant* _tmp110_ = NULL;
					ValaCCodeConstant* _tmp111_;
					_tmp110_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
					_tmp111_ = _tmp110_;
					vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp111_);
					_vala_ccode_node_unref0 (_tmp111_);
				}
			}
		} else {
			ValaCCodeConstant* _tmp112_ = NULL;
			ValaCCodeConstant* _tmp113_;
			_tmp112_ = vala_ccode_constant_new ("NULL");
			_tmp113_ = _tmp112_;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp113_);
			_vala_ccode_node_unref0 (_tmp113_);
		}
	}
	if (disconnect) {
		_tmp114_ = TRUE;
	} else {
		ValaCodeNode* _tmp115_ = NULL;
		_tmp115_ = vala_code_node_get_parent_node (expr);
		_tmp114_ = VALA_IS_EXPRESSION_STATEMENT (_tmp115_);
	}
	if (_tmp114_) {
		ValaCCodeFunction* _tmp116_ = NULL;
		_tmp116_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		vala_ccode_function_add_expression (_tmp116_, (ValaCCodeExpression*) ccall);
		result = NULL;
		_vala_code_node_unref0 (ma);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		_vala_ccode_node_unref0 (ccall);
		_vala_code_node_unref0 (m);
		_g_free0 (connect_func);
		return result;
	} else {
		ValaLocalVariable* _tmp117_ = NULL;
		ValaLocalVariable* temp_var;
		const gchar* _tmp118_ = NULL;
		ValaCCodeExpression* _tmp119_ = NULL;
		ValaCCodeExpression* temp_ref;
		ValaCCodeFunction* _tmp120_ = NULL;
		_tmp117_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->ulong_type, TRUE, NULL, TRUE);
		temp_var = _tmp117_;
		_tmp118_ = vala_symbol_get_name ((ValaSymbol*) temp_var);
		_tmp119_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp118_);
		temp_ref = _tmp119_;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, temp_var, FALSE);
		_tmp120_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		vala_ccode_function_add_assignment (_tmp120_, temp_ref, (ValaCCodeExpression*) ccall);
		result = temp_ref;
		_vala_code_node_unref0 (temp_var);
		_vala_code_node_unref0 (ma);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		_vala_ccode_node_unref0 (ccall);
		_vala_code_node_unref0 (m);
		_g_free0 (connect_func);
		return result;
	}
	_vala_code_node_unref0 (ma);
	_vala_ccode_node_unref0 (signal_name_cexpr);
	_vala_ccode_node_unref0 (ccall);
	_vala_code_node_unref0 (m);
	_g_free0 (connect_func);
}


ValaGSignalModule* vala_gsignal_module_construct (GType object_type) {
	ValaGSignalModule* self = NULL;
	self = (ValaGSignalModule*) vala_gobject_module_construct (object_type);
	return self;
}


ValaGSignalModule* vala_gsignal_module_new (void) {
	return vala_gsignal_module_construct (VALA_TYPE_GSIGNAL_MODULE);
}


static void vala_gsignal_module_class_init (ValaGSignalModuleClass * klass) {
	vala_gsignal_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = vala_gsignal_module_real_visit_signal;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_signal_creation = vala_gsignal_module_real_get_signal_creation;
	VALA_CODE_VISITOR_CLASS (klass)->visit_element_access = vala_gsignal_module_real_visit_element_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_assignment = vala_gsignal_module_real_visit_assignment;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member_access = vala_gsignal_module_real_visit_member_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method_call = vala_gsignal_module_real_visit_method_call;
}


static void vala_gsignal_module_instance_init (ValaGSignalModule * self) {
}


GType vala_gsignal_module_get_type (void) {
	static volatile gsize vala_gsignal_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gsignal_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGSignalModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gsignal_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGSignalModule), 0, (GInstanceInitFunc) vala_gsignal_module_instance_init, NULL };
		GType vala_gsignal_module_type_id;
		vala_gsignal_module_type_id = g_type_register_static (VALA_TYPE_GOBJECT_MODULE, "ValaGSignalModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_gsignal_module_type_id__volatile, vala_gsignal_module_type_id);
	}
	return vala_gsignal_module_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



