/* valasignal.c generated by valac, the Vala compiler
 * generated from valasignal.vala, do not modify */

/* valasignal.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <float.h>
#include <math.h>
#include <valaccode.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_SUBROUTINE (vala_subroutine_get_type ())
#define VALA_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutine))
#define VALA_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))
#define VALA_IS_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SUBROUTINE))
#define VALA_IS_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SUBROUTINE))
#define VALA_SUBROUTINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))

typedef struct _ValaSubroutine ValaSubroutine;
typedef struct _ValaSubroutineClass ValaSubroutineClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;

#define VALA_TYPE_LOCKABLE (vala_lockable_get_type ())
#define VALA_LOCKABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCKABLE, ValaLockable))
#define VALA_IS_LOCKABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCKABLE))
#define VALA_LOCKABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_LOCKABLE, ValaLockableIface))

typedef struct _ValaLockable ValaLockable;
typedef struct _ValaLockableIface ValaLockableIface;
typedef struct _ValaSignalPrivate ValaSignalPrivate;

#define VALA_TYPE_PARAMETER (vala_parameter_get_type ())
#define VALA_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PARAMETER, ValaParameter))
#define VALA_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PARAMETER, ValaParameterClass))
#define VALA_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PARAMETER))
#define VALA_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PARAMETER))
#define VALA_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PARAMETER, ValaParameterClass))

typedef struct _ValaParameter ValaParameter;
typedef struct _ValaParameterClass ValaParameterClass;

#define VALA_TYPE_BLOCK (vala_block_get_type ())
#define VALA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BLOCK, ValaBlock))
#define VALA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BLOCK, ValaBlockClass))
#define VALA_IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BLOCK))
#define VALA_IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BLOCK))
#define VALA_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BLOCK, ValaBlockClass))

typedef struct _ValaBlock ValaBlock;
typedef struct _ValaBlockClass ValaBlockClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_MEMBER_ACCESS (vala_member_access_get_type ())
#define VALA_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess))
#define VALA_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))
#define VALA_IS_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_ACCESS))
#define VALA_IS_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_ACCESS))
#define VALA_MEMBER_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))

typedef struct _ValaMemberAccess ValaMemberAccess;
typedef struct _ValaMemberAccessClass ValaMemberAccessClass;

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	gchar* (*get_cprefix) (ValaSymbol* self);
	gchar* (*get_lower_case_cname) (ValaSymbol* self, const gchar* infix);
	gchar* (*get_lower_case_cprefix) (ValaSymbol* self);
	ValaList* (*get_cheader_filenames) (ValaSymbol* self);
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*process_deprecated_attribute) (ValaSymbol* self, ValaAttribute* attr);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

struct _ValaLockableIface {
	GTypeInterface parent_iface;
	gboolean (*get_lock_used) (ValaLockable* self);
	void (*set_lock_used) (ValaLockable* self, gboolean used);
};

struct _ValaSignal {
	ValaSymbol parent_instance;
	ValaSignalPrivate * priv;
};

struct _ValaSignalClass {
	ValaSymbolClass parent_class;
};

struct _ValaSignalPrivate {
	gboolean _has_emitter;
	gboolean _is_virtual;
	ValaList* parameters;
	ValaMethod* _default_handler;
	gboolean _is_detailed;
	gboolean _no_recurse;
	gchar* _run_type;
	gboolean _is_action;
	gboolean _no_hooks;
	gchar* cname;
	gboolean lock_used;
	ValaDataType* _return_type;
	ValaBlock* _body;
};

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;


static gpointer vala_signal_parent_class = NULL;
static ValaLockableIface* vala_signal_vala_lockable_parent_iface = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_local_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_subroutine_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
GType vala_lockable_get_type (void) G_GNUC_CONST;
GType vala_parameter_get_type (void) G_GNUC_CONST;
GType vala_block_get_type (void) G_GNUC_CONST;
#define VALA_SIGNAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SIGNAL, ValaSignalPrivate))
enum  {
	VALA_SIGNAL_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
ValaSignal* vala_signal_new (const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment);
ValaSignal* vala_signal_construct (GType object_type, const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment);
ValaSymbol* vala_symbol_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
void vala_signal_set_return_type (ValaSignal* self, ValaDataType* value);
void vala_signal_set_run_type (ValaSignal* self, const gchar* value);
void vala_signal_add_parameter (ValaSignal* self, ValaParameter* param);
void vala_parameter_set_cparameter_position (ValaParameter* self, gdouble value);
gdouble vala_parameter_get_cparameter_position (ValaParameter* self);
void vala_parameter_set_carray_length_parameter_position (ValaParameter* self, gdouble value);
void vala_parameter_set_cdelegate_target_parameter_position (ValaParameter* self, gdouble value);
void vala_parameter_set_cdestroy_notify_parameter_position (ValaParameter* self, gdouble value);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
void vala_scope_add (ValaScope* self, const gchar* name, ValaSymbol* sym);
const gchar* vala_symbol_get_name (ValaSymbol* self);
ValaList* vala_signal_get_parameters (ValaSignal* self);
ValaDelegate* vala_signal_get_delegate (ValaSignal* self, ValaDataType* sender_type, ValaCodeNode* node_reference);
ValaDataType* vala_signal_get_return_type (ValaSignal* self);
GType vala_member_access_get_type (void) G_GNUC_CONST;
ValaDataType* vala_data_type_get_actual_type (ValaDataType* self, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference);
ValaDelegate* vala_delegate_new (const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment);
ValaDelegate* vala_delegate_construct (GType object_type, const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment);
void vala_delegate_set_has_target (ValaDelegate* self, gboolean value);
GType vala_symbol_accessibility_get_type (void) G_GNUC_CONST;
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
void vala_symbol_set_owner (ValaSymbol* self, ValaScope* value);
ValaDataType* vala_data_type_copy (ValaDataType* self);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
void vala_data_type_set_nullable (ValaDataType* self, gboolean value);
void vala_delegate_set_sender_type (ValaDelegate* self, ValaDataType* value);
ValaParameter* vala_parameter_copy (ValaParameter* self);
ValaDataType* vala_variable_get_variable_type (ValaVariable* self);
void vala_variable_set_variable_type (ValaVariable* self, ValaDataType* value);
void vala_delegate_add_parameter (ValaDelegate* self, ValaParameter* param);
gchar* vala_signal_get_cname (ValaSignal* self);
gchar* vala_symbol_camel_case_to_lower_case (const gchar* camel_case);
void vala_signal_set_cname (ValaSignal* self, const gchar* cname);
ValaCCodeConstant* vala_signal_get_canonical_cconstant (ValaSignal* self, const gchar* detail);
static void vala_signal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_signal (ValaCodeVisitor* self, ValaSignal* sig);
static void vala_signal_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
ValaMethod* vala_signal_get_default_handler (ValaSignal* self);
ValaBlock* vala_signal_get_body (ValaSignal* self);
static void vala_signal_process_signal_attribute (ValaSignal* self, ValaAttribute* a);
gboolean vala_attribute_has_argument (ValaAttribute* self, const gchar* name);
gboolean vala_attribute_get_bool (ValaAttribute* self, const gchar* name);
void vala_signal_set_is_detailed (ValaSignal* self, gboolean value);
void vala_signal_set_no_recurse (ValaSignal* self, gboolean value);
gchar* vala_attribute_get_string (ValaAttribute* self, const gchar* name);
void vala_signal_set_is_action (ValaSignal* self, gboolean value);
void vala_signal_set_no_hooks (ValaSignal* self, gboolean value);
void vala_signal_process_attributes (ValaSignal* self);
const gchar* vala_attribute_get_name (ValaAttribute* self);
void vala_signal_set_has_emitter (ValaSignal* self, gboolean value);
void vala_symbol_process_deprecated_attribute (ValaSymbol* self, ValaAttribute* attr);
static gboolean vala_signal_real_get_lock_used (ValaLockable* base);
static void vala_signal_real_set_lock_used (ValaLockable* base, gboolean used);
static void vala_signal_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gboolean vala_signal_real_check (ValaCodeNode* base, ValaCodeContext* context);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaCodeContext* context);
gboolean vala_signal_get_is_virtual (ValaSignal* self);
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
ValaMethod* vala_method_new (const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment);
ValaMethod* vala_method_construct (GType object_type, const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment);
static void vala_signal_set_default_handler (ValaSignal* self, ValaMethod* value);
ValaScope* vala_symbol_get_owner (ValaSymbol* self);
ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self);
gboolean vala_symbol_get_external (ValaSymbol* self);
void vala_symbol_set_external (ValaSymbol* self, gboolean value);
void vala_method_set_is_virtual (ValaMethod* self, gboolean value);
void vala_method_set_vfunc_name (ValaMethod* self, const gchar* value);
void vala_method_set_signal_reference (ValaMethod* self, ValaSignal* value);
void vala_subroutine_set_body (ValaSubroutine* self, ValaBlock* value);
void vala_method_add_parameter (ValaMethod* self, ValaParameter* param);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
void vala_object_type_symbol_add_hidden_method (ValaObjectTypeSymbol* self, ValaMethod* m);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
gboolean vala_symbol_get_hides (ValaSymbol* self);
ValaSymbol* vala_symbol_get_hidden_member (ValaSymbol* self);
void vala_report_warning (ValaSourceReference* source, const gchar* message);
gchar* vala_symbol_get_full_name (ValaSymbol* self);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
void vala_signal_set_body (ValaSignal* self, ValaBlock* value);
gboolean vala_signal_get_has_emitter (ValaSignal* self);
void vala_signal_set_is_virtual (ValaSignal* self, gboolean value);
gboolean vala_signal_get_is_detailed (ValaSignal* self);
gboolean vala_signal_get_no_recurse (ValaSignal* self);
const gchar* vala_signal_get_run_type (ValaSignal* self);
gboolean vala_signal_get_is_action (ValaSignal* self);
gboolean vala_signal_get_no_hooks (ValaSignal* self);
static void vala_signal_finalize (ValaCodeNode* obj);


/**
 * Creates a new signal.
 *
 * @param name        signal name
 * @param return_type signal return type
 * @param source      reference to source code
 * @return            newly created signal
 */
ValaSignal* vala_signal_construct (GType object_type, const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaSignal* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaSignal*) vala_symbol_construct (object_type, name, source_reference, comment);
	vala_signal_set_return_type (self, return_type);
	vala_signal_set_run_type (self, "last");
	return self;
}


ValaSignal* vala_signal_new (const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_signal_construct (VALA_TYPE_SIGNAL, name, return_type, source_reference, comment);
}


/**
 * Appends parameter to signal handler.
 *
 * @param param a formal parameter
 */
void vala_signal_add_parameter (ValaSignal* self, ValaParameter* param) {
	gint _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	ValaScope* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (param != NULL);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) self->priv->parameters);
	vala_parameter_set_cparameter_position (param, (gdouble) (_tmp0_ + 1));
	_tmp1_ = vala_parameter_get_cparameter_position (param);
	vala_parameter_set_carray_length_parameter_position (param, _tmp1_ + 0.1);
	_tmp2_ = vala_parameter_get_cparameter_position (param);
	vala_parameter_set_cdelegate_target_parameter_position (param, _tmp2_ + 0.1);
	_tmp3_ = vala_parameter_get_cparameter_position (param);
	vala_parameter_set_cdestroy_notify_parameter_position (param, _tmp3_ + 0.1);
	vala_collection_add ((ValaCollection*) self->priv->parameters, param);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) param);
	vala_scope_add (_tmp4_, _tmp5_, (ValaSymbol*) param);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_signal_get_parameters (ValaSignal* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->parameters);
	result = _tmp0_;
	return result;
}


/**
 * Returns generated delegate to be used for signal handlers.
 *
 * @return delegate
 */
ValaDelegate* vala_signal_get_delegate (ValaSignal* self, ValaDataType* sender_type, ValaCodeNode* node_reference) {
	ValaDelegate* result = NULL;
	ValaDataType* _tmp0_ = NULL;
	ValaDataType* _tmp1_ = NULL;
	ValaDataType* actual_return_type;
	ValaDelegate* _tmp2_ = NULL;
	ValaDelegate* generated_delegate;
	ValaScope* _tmp3_ = NULL;
	ValaDataType* _tmp4_ = NULL;
	ValaDataType* sender_param_type;
	ValaScope* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sender_type != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	_tmp0_ = vala_signal_get_return_type (self);
	_tmp1_ = vala_data_type_get_actual_type (_tmp0_, sender_type, NULL, node_reference);
	actual_return_type = _tmp1_;
	_tmp2_ = vala_delegate_new (NULL, actual_return_type, NULL, NULL);
	generated_delegate = _tmp2_;
	vala_delegate_set_has_target (generated_delegate, TRUE);
	vala_symbol_set_access ((ValaSymbol*) generated_delegate, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
	vala_symbol_set_owner ((ValaSymbol*) generated_delegate, _tmp3_);
	_tmp4_ = vala_data_type_copy (sender_type);
	sender_param_type = _tmp4_;
	vala_data_type_set_value_owned (sender_param_type, FALSE);
	vala_data_type_set_nullable (sender_param_type, FALSE);
	vala_delegate_set_sender_type (generated_delegate, sender_param_type);
	{
		ValaList* _tmp5_;
		ValaList* _param_list;
		gint _tmp6_;
		gint _param_size;
		gint _param_index;
		_tmp5_ = _vala_iterable_ref0 (self->priv->parameters);
		_param_list = _tmp5_;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _param_list);
		_param_size = _tmp6_;
		_param_index = -1;
		while (TRUE) {
			gpointer _tmp7_ = NULL;
			ValaParameter* param;
			ValaParameter* _tmp8_ = NULL;
			ValaParameter* actual_param;
			ValaDataType* _tmp9_ = NULL;
			ValaDataType* _tmp10_ = NULL;
			ValaDataType* _tmp11_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp7_ = vala_list_get (_param_list, _param_index);
			param = (ValaParameter*) _tmp7_;
			_tmp8_ = vala_parameter_copy (param);
			actual_param = _tmp8_;
			_tmp9_ = vala_variable_get_variable_type ((ValaVariable*) actual_param);
			_tmp10_ = vala_data_type_get_actual_type (_tmp9_, sender_type, NULL, node_reference);
			_tmp11_ = _tmp10_;
			vala_variable_set_variable_type ((ValaVariable*) actual_param, _tmp11_);
			_vala_code_node_unref0 (_tmp11_);
			vala_delegate_add_parameter (generated_delegate, actual_param);
			_vala_code_node_unref0 (actual_param);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp12_ = vala_symbol_get_scope ((ValaSymbol*) self);
	vala_scope_add (_tmp12_, NULL, (ValaSymbol*) generated_delegate);
	result = generated_delegate;
	_vala_code_node_unref0 (sender_param_type);
	_vala_code_node_unref0 (actual_return_type);
	return result;
}


/**
 * Returns the name of this signal as it is used in C code.
 *
 * @return the name to be used in C code
 */
gchar* vala_signal_get_cname (ValaSignal* self) {
	gchar* result = NULL;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->cname == NULL) {
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp0_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp1_ = vala_symbol_camel_case_to_lower_case (_tmp0_);
		_tmp2_ = _tmp1_;
		_g_free0 (self->priv->cname);
		self->priv->cname = _tmp2_;
	}
	_tmp3_ = g_strdup (self->priv->cname);
	result = _tmp3_;
	return result;
}


void vala_signal_set_cname (ValaSignal* self, const gchar* cname) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	_tmp0_ = g_strdup (cname);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->cname);
	self->priv->cname = _tmp1_;
}


/**
 * Returns the string literal of this signal to be used in C code.
 *
 * @return string literal to be used in C code
 */
static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_utf8_get_char (((gchar*) self) + index);
	result = _tmp0_;
	return result;
}


ValaCCodeConstant* vala_signal_get_canonical_cconstant (ValaSignal* self, const gchar* detail) {
	ValaCCodeConstant* result = NULL;
	GString* _tmp0_ = NULL;
	GString* str;
	gchar* _tmp1_ = NULL;
	gchar* i;
	ValaCCodeConstant* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("\"");
	str = _tmp0_;
	_tmp1_ = vala_signal_get_cname (self);
	i = _tmp1_;
	while (TRUE) {
		gint _tmp2_;
		gunichar _tmp3_;
		gunichar c;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = strlen (i);
		if (!(_tmp2_ > 0)) {
			break;
		}
		_tmp3_ = string_get_char (i, (glong) 0);
		c = _tmp3_;
		if (c == '_') {
			g_string_append_c (str, '-');
		} else {
			g_string_append_unichar (str, c);
		}
		_tmp4_ = g_utf8_next_char (i);
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (i);
		i = _tmp6_;
	}
	if (detail != NULL) {
		g_string_append (str, "::");
		g_string_append (str, detail);
	}
	g_string_append_c (str, '"');
	_tmp7_ = vala_ccode_constant_new (str->str);
	result = _tmp7_;
	_g_free0 (i);
	_g_string_free0 (str);
	return result;
}


static void vala_signal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaSignal * self;
	self = (ValaSignal*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_signal (visitor, self);
}


static void vala_signal_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaSignal * self;
	ValaDataType* _tmp0_ = NULL;
	gboolean _tmp4_ = FALSE;
	self = (ValaSignal*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_signal_get_return_type (self);
	vala_code_node_accept ((ValaCodeNode*) _tmp0_, visitor);
	{
		ValaList* _tmp1_;
		ValaList* _param_list;
		gint _tmp2_;
		gint _param_size;
		gint _param_index;
		_tmp1_ = _vala_iterable_ref0 (self->priv->parameters);
		_param_list = _tmp1_;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _param_list);
		_param_size = _tmp2_;
		_param_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			ValaParameter* param;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp3_ = vala_list_get (_param_list, _param_index);
			param = (ValaParameter*) _tmp3_;
			vala_code_node_accept ((ValaCodeNode*) param, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	if (self->priv->_default_handler == NULL) {
		ValaBlock* _tmp5_ = NULL;
		_tmp5_ = vala_signal_get_body (self);
		_tmp4_ = _tmp5_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaBlock* _tmp6_ = NULL;
		_tmp6_ = vala_signal_get_body (self);
		vala_code_node_accept ((ValaCodeNode*) _tmp6_, visitor);
	} else {
		if (self->priv->_default_handler != NULL) {
			vala_code_node_accept ((ValaCodeNode*) self->priv->_default_handler, visitor);
		}
	}
}


static void vala_signal_process_signal_attribute (ValaSignal* self, ValaAttribute* a) {
	gboolean _tmp0_;
	gboolean _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp6_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	_tmp0_ = vala_attribute_has_argument (a, "detailed");
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = vala_attribute_get_bool (a, "detailed");
		vala_signal_set_is_detailed (self, _tmp1_);
	}
	_tmp2_ = vala_attribute_has_argument (a, "no_recurse");
	if (_tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = vala_attribute_get_bool (a, "no_recurse");
		vala_signal_set_no_recurse (self, _tmp3_);
	}
	_tmp4_ = vala_attribute_has_argument (a, "run");
	if (_tmp4_) {
		gchar* _tmp5_ = NULL;
		gchar* arg;
		_tmp5_ = vala_attribute_get_string (a, "run");
		arg = _tmp5_;
		if (g_strcmp0 (arg, "first") == 0) {
			vala_signal_set_run_type (self, "first");
		} else {
			if (g_strcmp0 (arg, "last") == 0) {
				vala_signal_set_run_type (self, "last");
			} else {
				if (g_strcmp0 (arg, "cleanup") == 0) {
					vala_signal_set_run_type (self, "cleanup");
				}
			}
		}
		_g_free0 (arg);
	}
	_tmp6_ = vala_attribute_has_argument (a, "action");
	if (_tmp6_) {
		gboolean _tmp7_;
		_tmp7_ = vala_attribute_get_bool (a, "action");
		vala_signal_set_is_action (self, _tmp7_);
	}
	_tmp8_ = vala_attribute_has_argument (a, "no_hooks");
	if (_tmp8_) {
		gboolean _tmp9_;
		_tmp9_ = vala_attribute_get_bool (a, "no_hooks");
		vala_signal_set_no_hooks (self, _tmp9_);
	}
}


/**
 * Process all associated attributes.
 */
static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_signal_process_attributes (ValaSignal* self) {
	g_return_if_fail (self != NULL);
	{
		GList* a_collection;
		GList* a_it;
		a_collection = ((ValaCodeNode*) self)->attributes;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* _tmp0_;
			ValaAttribute* a;
			_tmp0_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
			a = _tmp0_;
			{
				const gchar* _tmp1_ = NULL;
				_tmp1_ = vala_attribute_get_name (a);
				if (g_strcmp0 (_tmp1_, "HasEmitter") == 0) {
					vala_signal_set_has_emitter (self, TRUE);
				} else {
					const gchar* _tmp2_ = NULL;
					_tmp2_ = vala_attribute_get_name (a);
					if (g_strcmp0 (_tmp2_, "Signal") == 0) {
						vala_signal_process_signal_attribute (self, a);
					} else {
						const gchar* _tmp3_ = NULL;
						_tmp3_ = vala_attribute_get_name (a);
						if (g_strcmp0 (_tmp3_, "Deprecated") == 0) {
							vala_symbol_process_deprecated_attribute ((ValaSymbol*) self, a);
						}
					}
				}
				_vala_code_node_unref0 (a);
			}
		}
	}
}


static gboolean vala_signal_real_get_lock_used (ValaLockable* base) {
	ValaSignal * self;
	gboolean result = FALSE;
	self = (ValaSignal*) base;
	result = self->priv->lock_used;
	return result;
}


static void vala_signal_real_set_lock_used (ValaLockable* base, gboolean used) {
	ValaSignal * self;
	self = (ValaSignal*) base;
	self->priv->lock_used = used;
}


static void vala_signal_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaSignal * self;
	ValaDataType* _tmp0_ = NULL;
	self = (ValaSignal*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_signal_get_return_type (self);
	if (_tmp0_ == old_type) {
		vala_signal_set_return_type (self, new_type);
	}
}


static gboolean vala_signal_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaSignal * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	ValaDataType* _tmp2_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_;
	gboolean _tmp40_;
	self = (ValaSignal*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = vala_code_node_get_error ((ValaCodeNode*) self);
		result = !_tmp1_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_signal_process_attributes (self);
	_tmp2_ = vala_signal_get_return_type (self);
	vala_code_node_check ((ValaCodeNode*) _tmp2_, context);
	{
		ValaList* _tmp3_;
		ValaList* _param_list;
		gint _tmp4_;
		gint _param_size;
		gint _param_index;
		_tmp3_ = _vala_iterable_ref0 (self->priv->parameters);
		_param_list = _tmp3_;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _param_list);
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gpointer _tmp5_ = NULL;
			ValaParameter* param;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = vala_list_get (_param_list, _param_index);
			param = (ValaParameter*) _tmp5_;
			vala_code_node_check ((ValaCodeNode*) param, context);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	if (!self->priv->_is_virtual) {
		ValaBlock* _tmp7_ = NULL;
		_tmp7_ = vala_signal_get_body (self);
		_tmp6_ = _tmp7_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaSourceReference* _tmp8_ = NULL;
		_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		vala_report_error (_tmp8_, "Only virtual signals can have a default signal handler body");
	}
	if (self->priv->_is_virtual) {
		const gchar* _tmp9_ = NULL;
		ValaDataType* _tmp10_ = NULL;
		ValaSourceReference* _tmp11_ = NULL;
		ValaMethod* _tmp12_ = NULL;
		ValaMethod* _tmp13_;
		ValaScope* _tmp14_ = NULL;
		ValaSymbolAccessibility _tmp15_;
		gboolean _tmp16_;
		const gchar* _tmp17_ = NULL;
		ValaBlock* _tmp18_ = NULL;
		ValaSymbol* _tmp22_ = NULL;
		ValaSymbol* _tmp23_;
		ValaObjectTypeSymbol* _tmp24_;
		ValaObjectTypeSymbol* cl;
		_tmp9_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp10_ = vala_signal_get_return_type (self);
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp12_ = vala_method_new (_tmp9_, _tmp10_, _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		vala_signal_set_default_handler (self, _tmp13_);
		_vala_code_node_unref0 (_tmp13_);
		_tmp14_ = vala_symbol_get_owner ((ValaSymbol*) self);
		vala_symbol_set_owner ((ValaSymbol*) self->priv->_default_handler, _tmp14_);
		_tmp15_ = vala_symbol_get_access ((ValaSymbol*) self);
		vala_symbol_set_access ((ValaSymbol*) self->priv->_default_handler, _tmp15_);
		_tmp16_ = vala_symbol_get_external ((ValaSymbol*) self);
		vala_symbol_set_external ((ValaSymbol*) self->priv->_default_handler, _tmp16_);
		vala_method_set_is_virtual (self->priv->_default_handler, TRUE);
		_tmp17_ = vala_symbol_get_name ((ValaSymbol*) self);
		vala_method_set_vfunc_name (self->priv->_default_handler, _tmp17_);
		vala_method_set_signal_reference (self->priv->_default_handler, self);
		_tmp18_ = vala_signal_get_body (self);
		vala_subroutine_set_body ((ValaSubroutine*) self->priv->_default_handler, _tmp18_);
		{
			ValaList* _tmp19_;
			ValaList* _param_list;
			gint _tmp20_;
			gint _param_size;
			gint _param_index;
			_tmp19_ = _vala_iterable_ref0 (self->priv->parameters);
			_param_list = _tmp19_;
			_tmp20_ = vala_collection_get_size ((ValaCollection*) _param_list);
			_param_size = _tmp20_;
			_param_index = -1;
			while (TRUE) {
				gpointer _tmp21_ = NULL;
				ValaParameter* param;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp21_ = vala_list_get (_param_list, _param_index);
				param = (ValaParameter*) _tmp21_;
				vala_method_add_parameter (self->priv->_default_handler, param);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp22_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp24_ = _vala_code_node_ref0 ((_tmp23_ = _tmp22_, VALA_IS_OBJECT_TYPE_SYMBOL (_tmp23_) ? ((ValaObjectTypeSymbol*) _tmp23_) : NULL));
		cl = _tmp24_;
		vala_object_type_symbol_add_hidden_method (cl, self->priv->_default_handler);
		vala_code_node_check ((ValaCodeNode*) self->priv->_default_handler, context);
		_vala_code_node_unref0 (cl);
	}
	_tmp27_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	if (!_tmp27_) {
		gboolean _tmp28_;
		_tmp28_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp26_ = !_tmp28_;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		ValaSymbol* _tmp29_ = NULL;
		ValaSymbol* _tmp30_;
		_tmp29_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp30_ = _tmp29_;
		_tmp25_ = _tmp30_ != NULL;
		_vala_code_node_unref0 (_tmp30_);
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		ValaSourceReference* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		ValaSymbol* _tmp34_ = NULL;
		ValaSymbol* _tmp35_;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_;
		_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp32_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_symbol_get_full_name (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strdup_printf ("%s hides inherited signal `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp33_, _tmp37_);
		_tmp39_ = _tmp38_;
		vala_report_warning (_tmp31_, _tmp39_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
		_vala_code_node_unref0 (_tmp35_);
		_g_free0 (_tmp33_);
	}
	_tmp40_ = vala_code_node_get_error ((ValaCodeNode*) self);
	result = !_tmp40_;
	return result;
}


ValaDataType* vala_signal_get_return_type (ValaSignal* self) {
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_return_type;
	return result;
}


void vala_signal_set_return_type (ValaSignal* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp1_;
	vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_return_type, (ValaCodeNode*) self);
}


ValaBlock* vala_signal_get_body (ValaSignal* self) {
	ValaBlock* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_body;
	return result;
}


void vala_signal_set_body (ValaSignal* self, ValaBlock* value) {
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp1_;
	if (self->priv->_body != NULL) {
		ValaScope* _tmp2_ = NULL;
		_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
		vala_symbol_set_owner ((ValaSymbol*) self->priv->_body, _tmp2_);
	}
}


gboolean vala_signal_get_has_emitter (ValaSignal* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_emitter;
	return result;
}


void vala_signal_set_has_emitter (ValaSignal* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_emitter = value;
}


gboolean vala_signal_get_is_virtual (ValaSignal* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}


void vala_signal_set_is_virtual (ValaSignal* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}


ValaMethod* vala_signal_get_default_handler (ValaSignal* self) {
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_default_handler;
	return result;
}


static void vala_signal_set_default_handler (ValaSignal* self, ValaMethod* value) {
	ValaMethod* _tmp0_;
	ValaMethod* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_code_node_unref0 (self->priv->_default_handler);
	self->priv->_default_handler = _tmp1_;
}


gboolean vala_signal_get_is_detailed (ValaSignal* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_detailed;
	return result;
}


void vala_signal_set_is_detailed (ValaSignal* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_detailed = value;
}


gboolean vala_signal_get_no_recurse (ValaSignal* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_no_recurse;
	return result;
}


void vala_signal_set_no_recurse (ValaSignal* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_no_recurse = value;
}


const gchar* vala_signal_get_run_type (ValaSignal* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_run_type;
	return result;
}


void vala_signal_set_run_type (ValaSignal* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_run_type);
	self->priv->_run_type = _tmp1_;
}


gboolean vala_signal_get_is_action (ValaSignal* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_action;
	return result;
}


void vala_signal_set_is_action (ValaSignal* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_action = value;
}


gboolean vala_signal_get_no_hooks (ValaSignal* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_no_hooks;
	return result;
}


void vala_signal_set_no_hooks (ValaSignal* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_no_hooks = value;
}


static void vala_signal_class_init (ValaSignalClass * klass) {
	vala_signal_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_signal_finalize;
	g_type_class_add_private (klass, sizeof (ValaSignalPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_signal_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_signal_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_signal_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_signal_real_check;
}


static void vala_signal_vala_lockable_interface_init (ValaLockableIface * iface) {
	vala_signal_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = (gboolean (*)(ValaLockable*)) vala_signal_real_get_lock_used;
	iface->set_lock_used = (void (*)(ValaLockable* ,gboolean)) vala_signal_real_set_lock_used;
}


static void vala_signal_instance_init (ValaSignal * self) {
	ValaArrayList* _tmp0_ = NULL;
	self->priv = VALA_SIGNAL_GET_PRIVATE (self);
	_tmp0_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->parameters = (ValaList*) _tmp0_;
	self->priv->lock_used = FALSE;
}


static void vala_signal_finalize (ValaCodeNode* obj) {
	ValaSignal * self;
	self = VALA_SIGNAL (obj);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_code_node_unref0 (self->priv->_default_handler);
	_g_free0 (self->priv->_run_type);
	_g_free0 (self->priv->cname);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_code_node_unref0 (self->priv->_body);
	VALA_CODE_NODE_CLASS (vala_signal_parent_class)->finalize (obj);
}


/**
 * Represents an object signal. Signals enable objects to provide notifications.
 */
GType vala_signal_get_type (void) {
	static volatile gsize vala_signal_type_id__volatile = 0;
	if (g_once_init_enter (&vala_signal_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSignalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_signal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSignal), 0, (GInstanceInitFunc) vala_signal_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_signal_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_signal_type_id;
		vala_signal_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaSignal", &g_define_type_info, 0);
		g_type_add_interface_static (vala_signal_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		g_once_init_leave (&vala_signal_type_id__volatile, vala_signal_type_id);
	}
	return vala_signal_type_id__volatile;
}



