/* valageniescanner.c generated by valac, the Vala compiler
 * generated from valageniescanner.vala, do not modify */

/* valageniescanner.vala
 *
 * Copyright (C) 2008  Jamie McCracken, Jürg Billeter
 * Based on code by Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jamie McCracken jamiemcc gnome org
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_GENIE_TYPE_SCANNER (vala_genie_scanner_get_type ())
#define VALA_GENIE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GENIE_TYPE_SCANNER, ValaGenieScanner))
#define VALA_GENIE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GENIE_TYPE_SCANNER, ValaGenieScannerClass))
#define VALA_GENIE_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GENIE_TYPE_SCANNER))
#define VALA_GENIE_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GENIE_TYPE_SCANNER))
#define VALA_GENIE_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GENIE_TYPE_SCANNER, ValaGenieScannerClass))

typedef struct _ValaGenieScanner ValaGenieScanner;
typedef struct _ValaGenieScannerClass ValaGenieScannerClass;
typedef struct _ValaGenieScannerPrivate ValaGenieScannerPrivate;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_GENIE_TYPE_TOKEN_TYPE (vala_genie_token_type_get_type ())

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_GENIE_SCANNER_TYPE_CONDITIONAL (vala_genie_scanner_conditional_get_type ())
typedef struct _ValaGenieScannerConditional ValaGenieScannerConditional;

#define VALA_GENIE_SCANNER_TYPE_STATE (vala_genie_scanner_state_get_type ())
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))

#define VALA_TYPE_SOURCE_LOCATION (vala_source_location_get_type ())
typedef struct _ValaSourceLocation ValaSourceLocation;

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;
typedef struct _ValaGenieParamSpecScanner ValaGenieParamSpecScanner;

struct _ValaGenieScanner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGenieScannerPrivate * priv;
};

struct _ValaGenieScannerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGenieScanner *self);
};

typedef enum  {
	VALA_GENIE_TOKEN_TYPE_NONE,
	VALA_GENIE_TOKEN_TYPE_ABSTRACT,
	VALA_GENIE_TOKEN_TYPE_ARRAY,
	VALA_GENIE_TOKEN_TYPE_AS,
	VALA_GENIE_TOKEN_TYPE_ASSERT,
	VALA_GENIE_TOKEN_TYPE_ASSIGN,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB,
	VALA_GENIE_TOKEN_TYPE_ASYNC,
	VALA_GENIE_TOKEN_TYPE_BITWISE_AND,
	VALA_GENIE_TOKEN_TYPE_BITWISE_OR,
	VALA_GENIE_TOKEN_TYPE_BREAK,
	VALA_GENIE_TOKEN_TYPE_CARRET,
	VALA_GENIE_TOKEN_TYPE_CASE,
	VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL,
	VALA_GENIE_TOKEN_TYPE_CLASS,
	VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE,
	VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET,
	VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS,
	VALA_GENIE_TOKEN_TYPE_CLOSE_REGEX_LITERAL,
	VALA_GENIE_TOKEN_TYPE_CLOSE_TEMPLATE,
	VALA_GENIE_TOKEN_TYPE_COLON,
	VALA_GENIE_TOKEN_TYPE_COMMA,
	VALA_GENIE_TOKEN_TYPE_CONST,
	VALA_GENIE_TOKEN_TYPE_CONSTRUCT,
	VALA_GENIE_TOKEN_TYPE_CONTINUE,
	VALA_GENIE_TOKEN_TYPE_DEDENT,
	VALA_GENIE_TOKEN_TYPE_DEF,
	VALA_GENIE_TOKEN_TYPE_DEFAULT,
	VALA_GENIE_TOKEN_TYPE_DELEGATE,
	VALA_GENIE_TOKEN_TYPE_DELETE,
	VALA_GENIE_TOKEN_TYPE_DICT,
	VALA_GENIE_TOKEN_TYPE_DIV,
	VALA_GENIE_TOKEN_TYPE_DO,
	VALA_GENIE_TOKEN_TYPE_DOT,
	VALA_GENIE_TOKEN_TYPE_DOWNTO,
	VALA_GENIE_TOKEN_TYPE_DYNAMIC,
	VALA_GENIE_TOKEN_TYPE_ELLIPSIS,
	VALA_GENIE_TOKEN_TYPE_ELSE,
	VALA_GENIE_TOKEN_TYPE_ENUM,
	VALA_GENIE_TOKEN_TYPE_ENSURES,
	VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN,
	VALA_GENIE_TOKEN_TYPE_EOF,
	VALA_GENIE_TOKEN_TYPE_EOL,
	VALA_GENIE_TOKEN_TYPE_EVENT,
	VALA_GENIE_TOKEN_TYPE_EXCEPT,
	VALA_GENIE_TOKEN_TYPE_EXTERN,
	VALA_GENIE_TOKEN_TYPE_FALSE,
	VALA_GENIE_TOKEN_TYPE_FINAL,
	VALA_GENIE_TOKEN_TYPE_FINALLY,
	VALA_GENIE_TOKEN_TYPE_FOR,
	VALA_GENIE_TOKEN_TYPE_GET,
	VALA_GENIE_TOKEN_TYPE_HASH,
	VALA_GENIE_TOKEN_TYPE_IDENTIFIER,
	VALA_GENIE_TOKEN_TYPE_IF,
	VALA_GENIE_TOKEN_TYPE_IMPLEMENTS,
	VALA_GENIE_TOKEN_TYPE_IN,
	VALA_GENIE_TOKEN_TYPE_INDENT,
	VALA_GENIE_TOKEN_TYPE_INIT,
	VALA_GENIE_TOKEN_TYPE_INLINE,
	VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL,
	VALA_GENIE_TOKEN_TYPE_INTERFACE,
	VALA_GENIE_TOKEN_TYPE_INTERNAL,
	VALA_GENIE_TOKEN_TYPE_INTERR,
	VALA_GENIE_TOKEN_TYPE_IS,
	VALA_GENIE_TOKEN_TYPE_ISA,
	VALA_GENIE_TOKEN_TYPE_LAMBDA,
	VALA_GENIE_TOKEN_TYPE_LIST,
	VALA_GENIE_TOKEN_TYPE_LOCK,
	VALA_GENIE_TOKEN_TYPE_MINUS,
	VALA_GENIE_TOKEN_TYPE_NAMESPACE,
	VALA_GENIE_TOKEN_TYPE_NEW,
	VALA_GENIE_TOKEN_TYPE_NULL,
	VALA_GENIE_TOKEN_TYPE_OF,
	VALA_GENIE_TOKEN_TYPE_OUT,
	VALA_GENIE_TOKEN_TYPE_OP_AND,
	VALA_GENIE_TOKEN_TYPE_OP_DEC,
	VALA_GENIE_TOKEN_TYPE_OP_EQ,
	VALA_GENIE_TOKEN_TYPE_OP_GE,
	VALA_GENIE_TOKEN_TYPE_OP_GT,
	VALA_GENIE_TOKEN_TYPE_OP_INC,
	VALA_GENIE_TOKEN_TYPE_OP_LE,
	VALA_GENIE_TOKEN_TYPE_OP_LT,
	VALA_GENIE_TOKEN_TYPE_OP_NE,
	VALA_GENIE_TOKEN_TYPE_OP_NEG,
	VALA_GENIE_TOKEN_TYPE_OP_OR,
	VALA_GENIE_TOKEN_TYPE_OP_PTR,
	VALA_GENIE_TOKEN_TYPE_OP_SHIFT_LEFT,
	VALA_GENIE_TOKEN_TYPE_OPEN_BRACE,
	VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET,
	VALA_GENIE_TOKEN_TYPE_OPEN_PARENS,
	VALA_GENIE_TOKEN_TYPE_OPEN_REGEX_LITERAL,
	VALA_GENIE_TOKEN_TYPE_OPEN_TEMPLATE,
	VALA_GENIE_TOKEN_TYPE_OVERRIDE,
	VALA_GENIE_TOKEN_TYPE_OWNED,
	VALA_GENIE_TOKEN_TYPE_PARAMS,
	VALA_GENIE_TOKEN_TYPE_PASS,
	VALA_GENIE_TOKEN_TYPE_PERCENT,
	VALA_GENIE_TOKEN_TYPE_PLUS,
	VALA_GENIE_TOKEN_TYPE_PRINT,
	VALA_GENIE_TOKEN_TYPE_PRIVATE,
	VALA_GENIE_TOKEN_TYPE_PROP,
	VALA_GENIE_TOKEN_TYPE_PROTECTED,
	VALA_GENIE_TOKEN_TYPE_PUBLIC,
	VALA_GENIE_TOKEN_TYPE_RAISE,
	VALA_GENIE_TOKEN_TYPE_RAISES,
	VALA_GENIE_TOKEN_TYPE_REAL_LITERAL,
	VALA_GENIE_TOKEN_TYPE_READONLY,
	VALA_GENIE_TOKEN_TYPE_REF,
	VALA_GENIE_TOKEN_TYPE_REGEX_LITERAL,
	VALA_GENIE_TOKEN_TYPE_REQUIRES,
	VALA_GENIE_TOKEN_TYPE_RETURN,
	VALA_GENIE_TOKEN_TYPE_SEMICOLON,
	VALA_GENIE_TOKEN_TYPE_SET,
	VALA_GENIE_TOKEN_TYPE_SIZEOF,
	VALA_GENIE_TOKEN_TYPE_STAR,
	VALA_GENIE_TOKEN_TYPE_STATIC,
	VALA_GENIE_TOKEN_TYPE_STRING_LITERAL,
	VALA_GENIE_TOKEN_TYPE_STRUCT,
	VALA_GENIE_TOKEN_TYPE_SUPER,
	VALA_GENIE_TOKEN_TYPE_TEMPLATE_STRING_LITERAL,
	VALA_GENIE_TOKEN_TYPE_THIS,
	VALA_GENIE_TOKEN_TYPE_TILDE,
	VALA_GENIE_TOKEN_TYPE_TO,
	VALA_GENIE_TOKEN_TYPE_TRUE,
	VALA_GENIE_TOKEN_TYPE_TRY,
	VALA_GENIE_TOKEN_TYPE_TYPEOF,
	VALA_GENIE_TOKEN_TYPE_UNOWNED,
	VALA_GENIE_TOKEN_TYPE_USES,
	VALA_GENIE_TOKEN_TYPE_VAR,
	VALA_GENIE_TOKEN_TYPE_VERBATIM_STRING_LITERAL,
	VALA_GENIE_TOKEN_TYPE_VIRTUAL,
	VALA_GENIE_TOKEN_TYPE_VOID,
	VALA_GENIE_TOKEN_TYPE_VOLATILE,
	VALA_GENIE_TOKEN_TYPE_WEAK,
	VALA_GENIE_TOKEN_TYPE_WHEN,
	VALA_GENIE_TOKEN_TYPE_WHILE,
	VALA_GENIE_TOKEN_TYPE_WRITEONLY,
	VALA_GENIE_TOKEN_TYPE_YIELD
} ValaGenieTokenType;

struct _ValaGenieScannerConditional {
	gboolean matched;
	gboolean else_found;
	gboolean skip_section;
};

typedef enum  {
	VALA_GENIE_SCANNER_STATE_PARENS,
	VALA_GENIE_SCANNER_STATE_BRACE,
	VALA_GENIE_SCANNER_STATE_BRACKET,
	VALA_GENIE_SCANNER_STATE_REGEX_LITERAL,
	VALA_GENIE_SCANNER_STATE_TEMPLATE,
	VALA_GENIE_SCANNER_STATE_TEMPLATE_PART
} ValaGenieScannerState;

struct _ValaGenieScannerPrivate {
	ValaSourceFile* _source_file;
	gint _indent_spaces;
	gchar* begin;
	gchar* current;
	gchar* end;
	gint line;
	gint column;
	gint current_indent_level;
	gint indent_level;
	gint pending_dedents;
	gint open_parens_count;
	gint open_brace_count;
	ValaGenieTokenType last_token;
	gboolean parse_started;
	ValaComment* _comment;
	ValaGenieScannerConditional* conditional_stack;
	gint conditional_stack_length1;
	gint _conditional_stack_size_;
	ValaGenieScannerState* state_stack;
	gint state_stack_length1;
	gint _state_stack_size_;
};

struct _ValaSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _ValaGenieParamSpecScanner {
	GParamSpec parent_instance;
};


static gpointer vala_genie_scanner_parent_class = NULL;

gpointer vala_genie_scanner_ref (gpointer instance);
void vala_genie_scanner_unref (gpointer instance);
GParamSpec* vala_genie_param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_genie_value_set_scanner (GValue* value, gpointer v_object);
void vala_genie_value_take_scanner (GValue* value, gpointer v_object);
gpointer vala_genie_value_get_scanner (const GValue* value);
GType vala_genie_scanner_get_type (void) G_GNUC_CONST;
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
GType vala_genie_token_type_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
static GType vala_genie_scanner_conditional_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGenieScannerConditional* vala_genie_scanner_conditional_dup (const ValaGenieScannerConditional* self);
static void vala_genie_scanner_conditional_free (ValaGenieScannerConditional* self);
static GType vala_genie_scanner_state_get_type (void) G_GNUC_UNUSED;
#define VALA_GENIE_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_GENIE_TYPE_SCANNER, ValaGenieScannerPrivate))
enum  {
	VALA_GENIE_SCANNER_DUMMY_PROPERTY
};
ValaGenieScanner* vala_genie_scanner_new (ValaSourceFile* source_file);
ValaGenieScanner* vala_genie_scanner_construct (GType object_type, ValaSourceFile* source_file);
static void vala_genie_scanner_set_source_file (ValaGenieScanner* self, ValaSourceFile* value);
gchar* vala_source_file_get_mapped_contents (ValaSourceFile* self);
gsize vala_source_file_get_mapped_length (ValaSourceFile* self);
static gboolean vala_genie_scanner_in_template (ValaGenieScanner* self);
static gboolean vala_genie_scanner_in_template_part (ValaGenieScanner* self);
static gboolean vala_genie_scanner_is_ident_char (ValaGenieScanner* self, gchar c);
static gboolean vala_genie_scanner_in_regex_literal (ValaGenieScanner* self);
GType vala_source_location_get_type (void) G_GNUC_CONST;
ValaSourceLocation* vala_source_location_dup (const ValaSourceLocation* self);
void vala_source_location_free (ValaSourceLocation* self);
ValaGenieTokenType vala_genie_scanner_read_regex_token (ValaGenieScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaSourceFile* vala_genie_scanner_get_source_file (ValaGenieScanner* self);
ValaSourceReference* vala_source_reference_new (ValaSourceFile* _file, gint _first_line, gint _first_column, gint _last_line, gint _last_column);
ValaSourceReference* vala_source_reference_construct (GType object_type, ValaSourceFile* _file, gint _first_line, gint _first_column, gint _last_line, gint _last_column);
ValaGenieTokenType vala_genie_scanner_read_token (ValaGenieScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
void vala_genie_scanner_seek (ValaGenieScanner* self, ValaSourceLocation* location);
static ValaGenieTokenType vala_genie_scanner_get_identifier_or_keyword (ValaGenieScanner* self, gchar* begin, gint len);
static gboolean vala_genie_scanner_matches (ValaGenieScanner* self, gchar* begin, const gchar* keyword);
ValaGenieTokenType vala_genie_scanner_read_template_token (ValaGenieScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
static void _vala_array_add2 (ValaGenieScannerState** array, int* length, int* size, ValaGenieScannerState value);
static void _vala_array_add3 (ValaGenieScannerState** array, int* length, int* size, ValaGenieScannerState value);
static void _vala_array_add4 (ValaGenieScannerState** array, int* length, int* size, ValaGenieScannerState value);
static void _vala_array_add5 (ValaGenieScannerState** array, int* length, int* size, ValaGenieScannerState value);
static void vala_genie_scanner_space (ValaGenieScanner* self);
static void vala_genie_scanner_skip_space_tabs (ValaGenieScanner* self);
static inline gboolean vala_genie_scanner_newline (ValaGenieScanner* self);
static gboolean vala_genie_scanner_skip_newlines (ValaGenieScanner* self);
static gint vala_genie_scanner_count_tabs (ValaGenieScanner* self);
static void _vala_array_add6 (ValaGenieScannerState** array, int* length, int* size, ValaGenieScannerState value);
static void _vala_array_add7 (ValaGenieScannerState** array, int* length, int* size, ValaGenieScannerState value);
static void _vala_array_add8 (ValaGenieScannerState** array, int* length, int* size, ValaGenieScannerState value);
static void _vala_array_add9 (ValaGenieScannerState** array, int* length, int* size, ValaGenieScannerState value);
static void _vala_array_add10 (ValaGenieScannerState** array, int* length, int* size, ValaGenieScannerState value);
static gboolean vala_genie_scanner_whitespace (ValaGenieScanner* self);
static void vala_genie_scanner_pp_directive (ValaGenieScanner* self);
static gboolean vala_genie_scanner_comment (ValaGenieScanner* self, gboolean file_comment);
static void vala_genie_scanner_push_comment (ValaGenieScanner* self, const gchar* comment_item, ValaSourceReference* source_reference, gboolean file_comment);
static gboolean vala_genie_scanner_skip_tabs (ValaGenieScanner* self);
void vala_genie_scanner_parse_file_comments (ValaGenieScanner* self);
ValaComment* vala_comment_new (const gchar* comment, ValaSourceReference* _source_reference);
ValaComment* vala_comment_construct (GType object_type, const gchar* comment, ValaSourceReference* _source_reference);
void vala_source_file_add_comment (ValaSourceFile* self, ValaComment* comment);
ValaComment* vala_genie_scanner_pop_comment (ValaGenieScanner* self);
static gboolean vala_genie_scanner_pp_whitespace (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_if (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_elif (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_else (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_endif (ValaGenieScanner* self);
static void vala_genie_scanner_pp_eol (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_expression (ValaGenieScanner* self);
static void _vala_array_add11 (ValaGenieScannerConditional** array, int* length, int* size, const ValaGenieScannerConditional* value);
static gboolean vala_genie_scanner_parse_pp_symbol (ValaGenieScanner* self);
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
ValaCodeContext* vala_source_file_get_context (ValaSourceFile* self);
gboolean vala_code_context_is_defined (ValaCodeContext* self, const gchar* define);
static gboolean vala_genie_scanner_parse_pp_primary_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_unary_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_equality_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_and_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_or_expression (ValaGenieScanner* self);
gint vala_genie_scanner_get_indent_spaces (ValaGenieScanner* self);
void vala_genie_scanner_set_indent_spaces (ValaGenieScanner* self, gint value);
static void vala_genie_scanner_finalize (ValaGenieScanner* obj);


static GType vala_genie_scanner_state_get_type (void) {
	static volatile gsize vala_genie_scanner_state_type_id__volatile = 0;
	if (g_once_init_enter (&vala_genie_scanner_state_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_GENIE_SCANNER_STATE_PARENS, "VALA_GENIE_SCANNER_STATE_PARENS", "parens"}, {VALA_GENIE_SCANNER_STATE_BRACE, "VALA_GENIE_SCANNER_STATE_BRACE", "brace"}, {VALA_GENIE_SCANNER_STATE_BRACKET, "VALA_GENIE_SCANNER_STATE_BRACKET", "bracket"}, {VALA_GENIE_SCANNER_STATE_REGEX_LITERAL, "VALA_GENIE_SCANNER_STATE_REGEX_LITERAL", "regex-literal"}, {VALA_GENIE_SCANNER_STATE_TEMPLATE, "VALA_GENIE_SCANNER_STATE_TEMPLATE", "template"}, {VALA_GENIE_SCANNER_STATE_TEMPLATE_PART, "VALA_GENIE_SCANNER_STATE_TEMPLATE_PART", "template-part"}, {0, NULL, NULL}};
		GType vala_genie_scanner_state_type_id;
		vala_genie_scanner_state_type_id = g_enum_register_static ("ValaGenieScannerState", values);
		g_once_init_leave (&vala_genie_scanner_state_type_id__volatile, vala_genie_scanner_state_type_id);
	}
	return vala_genie_scanner_state_type_id__volatile;
}


ValaGenieScanner* vala_genie_scanner_construct (GType object_type, ValaSourceFile* source_file) {
	ValaGenieScanner* self = NULL;
	gchar* _tmp0_ = NULL;
	gsize _tmp1_;
	g_return_val_if_fail (source_file != NULL, NULL);
	self = (ValaGenieScanner*) g_type_create_instance (object_type);
	vala_genie_scanner_set_source_file (self, source_file);
	_tmp0_ = vala_source_file_get_mapped_contents (source_file);
	self->priv->begin = _tmp0_;
	_tmp1_ = vala_source_file_get_mapped_length (source_file);
	self->priv->end = self->priv->begin + _tmp1_;
	self->priv->current = self->priv->begin;
	self->priv->_indent_spaces = 0;
	self->priv->line = 1;
	self->priv->column = 1;
	self->priv->current_indent_level = 0;
	self->priv->indent_level = 0;
	self->priv->pending_dedents = 0;
	self->priv->open_parens_count = 0;
	self->priv->open_brace_count = 0;
	self->priv->parse_started = FALSE;
	self->priv->last_token = VALA_GENIE_TOKEN_TYPE_NONE;
	return self;
}


ValaGenieScanner* vala_genie_scanner_new (ValaSourceFile* source_file) {
	return vala_genie_scanner_construct (VALA_GENIE_TYPE_SCANNER, source_file);
}


static gboolean vala_genie_scanner_in_template (ValaGenieScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->state_stack_length1 > 0) {
		_tmp0_ = self->priv->state_stack[self->priv->state_stack_length1 - 1] == VALA_GENIE_SCANNER_STATE_TEMPLATE;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean vala_genie_scanner_in_template_part (ValaGenieScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->state_stack_length1 > 0) {
		_tmp0_ = self->priv->state_stack[self->priv->state_stack_length1 - 1] == VALA_GENIE_SCANNER_STATE_TEMPLATE_PART;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean vala_genie_scanner_is_ident_char (ValaGenieScanner* self, gchar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = g_ascii_isalnum (c);
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = c == '_';
	}
	result = _tmp0_;
	return result;
}


static gboolean vala_genie_scanner_in_regex_literal (ValaGenieScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->state_stack_length1 > 0) {
		_tmp0_ = self->priv->state_stack[self->priv->state_stack_length1 - 1] == VALA_GENIE_SCANNER_STATE_REGEX_LITERAL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


ValaGenieTokenType vala_genie_scanner_read_regex_token (ValaGenieScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaSourceLocation _token_begin = {0};
	ValaSourceLocation _token_end = {0};
	ValaGenieTokenType result = 0;
	ValaGenieTokenType type = 0;
	gchar* begin;
	gint token_length_in_chars;
	g_return_val_if_fail (self != NULL, 0);
	begin = self->priv->current;
	_token_begin.pos = begin;
	_token_begin.line = self->priv->line;
	_token_begin.column = self->priv->column;
	token_length_in_chars = -1;
	if (self->priv->current >= self->priv->end) {
		type = VALA_GENIE_TOKEN_TYPE_EOF;
	} else {
		switch (self->priv->current[0]) {
			case '/':
			{
				gboolean fl_i;
				gboolean fl_s;
				gboolean fl_m;
				gboolean fl_x;
				type = VALA_GENIE_TOKEN_TYPE_CLOSE_REGEX_LITERAL;
				self->priv->current++;
				self->priv->state_stack_length1--;
				fl_i = FALSE;
				fl_s = FALSE;
				fl_m = FALSE;
				fl_x = FALSE;
				while (TRUE) {
					gboolean _tmp0_ = FALSE;
					gboolean _tmp1_ = FALSE;
					gboolean _tmp2_ = FALSE;
					if (self->priv->current[0] == 'i') {
						_tmp2_ = TRUE;
					} else {
						_tmp2_ = self->priv->current[0] == 's';
					}
					if (_tmp2_) {
						_tmp1_ = TRUE;
					} else {
						_tmp1_ = self->priv->current[0] == 'm';
					}
					if (_tmp1_) {
						_tmp0_ = TRUE;
					} else {
						_tmp0_ = self->priv->current[0] == 'x';
					}
					if (!_tmp0_) {
						break;
					}
					switch (self->priv->current[0]) {
						case 'i':
						{
							if (fl_i) {
								ValaSourceReference* _tmp3_ = NULL;
								ValaSourceReference* _tmp4_;
								_tmp3_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
								_tmp4_ = _tmp3_;
								vala_report_error (_tmp4_, "modifier 'i' used more than once");
								_vala_source_reference_unref0 (_tmp4_);
							}
							fl_i = TRUE;
							break;
						}
						case 's':
						{
							if (fl_s) {
								ValaSourceReference* _tmp5_ = NULL;
								ValaSourceReference* _tmp6_;
								_tmp5_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
								_tmp6_ = _tmp5_;
								vala_report_error (_tmp6_, "modifier 's' used more than once");
								_vala_source_reference_unref0 (_tmp6_);
							}
							fl_s = TRUE;
							break;
						}
						case 'm':
						{
							if (fl_m) {
								ValaSourceReference* _tmp7_ = NULL;
								ValaSourceReference* _tmp8_;
								_tmp7_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
								_tmp8_ = _tmp7_;
								vala_report_error (_tmp8_, "modifier 'm' used more than once");
								_vala_source_reference_unref0 (_tmp8_);
							}
							fl_m = TRUE;
							break;
						}
						case 'x':
						{
							if (fl_x) {
								ValaSourceReference* _tmp9_ = NULL;
								ValaSourceReference* _tmp10_;
								_tmp9_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
								_tmp10_ = _tmp9_;
								vala_report_error (_tmp10_, "modifier 'x' used more than once");
								_vala_source_reference_unref0 (_tmp10_);
							}
							fl_x = TRUE;
							break;
						}
						default:
						break;
					}
					self->priv->current++;
					token_length_in_chars++;
				}
				break;
			}
			default:
			{
				gboolean _tmp20_ = FALSE;
				type = VALA_GENIE_TOKEN_TYPE_REGEX_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp11_ = FALSE;
					if (self->priv->current < self->priv->end) {
						_tmp11_ = self->priv->current[0] != '/';
					} else {
						_tmp11_ = FALSE;
					}
					if (!_tmp11_) {
						break;
					}
					if (self->priv->current[0] == '\\') {
						self->priv->current++;
						token_length_in_chars++;
						if (self->priv->current >= self->priv->end) {
							break;
						}
						switch (self->priv->current[0]) {
							case '\'':
							case '"':
							case '\\':
							case '/':
							case '^':
							case '$':
							case '.':
							case '[':
							case ']':
							case '{':
							case '}':
							case '(':
							case ')':
							case '?':
							case '*':
							case '+':
							case '-':
							case '#':
							case '&':
							case '~':
							case ':':
							case ';':
							case '<':
							case '>':
							case '|':
							case '%':
							case '=':
							case '@':
							case '0':
							case 'b':
							case 'B':
							case 'f':
							case 'n':
							case 'r':
							case 't':
							case 'a':
							case 'A':
							case 'p':
							case 'P':
							case 'e':
							case 'd':
							case 'D':
							case 's':
							case 'S':
							case 'w':
							case 'W':
							case 'G':
							case 'z':
							case 'Z':
							{
								self->priv->current++;
								token_length_in_chars++;
								break;
							}
							case 'x':
							{
								self->priv->current++;
								token_length_in_chars++;
								while (TRUE) {
									gboolean _tmp12_ = FALSE;
									if (self->priv->current < self->priv->end) {
										gboolean _tmp13_;
										_tmp13_ = g_ascii_isxdigit (self->priv->current[0]);
										_tmp12_ = _tmp13_;
									} else {
										_tmp12_ = FALSE;
									}
									if (!_tmp12_) {
										break;
									}
									self->priv->current++;
									token_length_in_chars++;
								}
								break;
							}
							default:
							{
								ValaSourceReference* _tmp14_ = NULL;
								ValaSourceReference* _tmp15_;
								_tmp14_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
								_tmp15_ = _tmp14_;
								vala_report_error (_tmp15_, "invalid escape sequence");
								_vala_source_reference_unref0 (_tmp15_);
								break;
							}
						}
					} else {
						if (self->priv->current[0] == '\n') {
							break;
						} else {
							gunichar _tmp16_;
							gunichar u;
							_tmp16_ = g_utf8_get_char_validated ((const gchar*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
							u = _tmp16_;
							if (u != ((gunichar) (-1))) {
								gint _tmp17_;
								_tmp17_ = g_unichar_to_utf8 (u, NULL);
								self->priv->current = self->priv->current + _tmp17_;
								token_length_in_chars++;
							} else {
								ValaSourceReference* _tmp18_ = NULL;
								ValaSourceReference* _tmp19_;
								self->priv->current++;
								_tmp18_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
								_tmp19_ = _tmp18_;
								vala_report_error (_tmp19_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp19_);
							}
						}
					}
				}
				if (self->priv->current >= self->priv->end) {
					_tmp20_ = TRUE;
				} else {
					_tmp20_ = self->priv->current[0] == '\n';
				}
				if (_tmp20_) {
					ValaSourceReference* _tmp21_ = NULL;
					ValaSourceReference* _tmp22_;
					ValaSourceLocation _tmp23_ = {0};
					ValaSourceLocation _tmp24_ = {0};
					ValaGenieTokenType _tmp25_;
					_tmp21_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
					_tmp22_ = _tmp21_;
					vala_report_error (_tmp22_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp22_);
					self->priv->state_stack_length1--;
					_tmp25_ = vala_genie_scanner_read_token (self, &_tmp23_, &_tmp24_);
					_token_begin = _tmp23_;
					_token_end = _tmp24_;
					result = _tmp25_;
					if (token_begin) {
						*token_begin = _token_begin;
					}
					if (token_end) {
						*token_end = _token_end;
					}
					return result;
				}
				break;
			}
		}
	}
	if (token_length_in_chars < 0) {
		self->priv->column = self->priv->column + ((gint) (self->priv->current - begin));
	} else {
		self->priv->column = self->priv->column + token_length_in_chars;
	}
	_token_end.pos = self->priv->current;
	_token_end.line = self->priv->line;
	_token_end.column = self->priv->column - 1;
	result = type;
	if (token_begin) {
		*token_begin = _token_begin;
	}
	if (token_end) {
		*token_end = _token_end;
	}
	return result;
}


void vala_genie_scanner_seek (ValaGenieScanner* self, ValaSourceLocation* location) {
	ValaGenieScannerConditional* _tmp0_;
	ValaGenieScannerState* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->current = (*location).pos;
	self->priv->line = (*location).line;
	self->priv->column = (*location).column;
	_tmp0_ = NULL;
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->conditional_stack_length1 = 0;
	self->priv->_conditional_stack_size_ = self->priv->conditional_stack_length1;
	self->priv->conditional_stack = _tmp0_;
	_tmp1_ = NULL;
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
	self->priv->state_stack_length1 = 0;
	self->priv->_state_stack_size_ = self->priv->state_stack_length1;
	self->priv->state_stack = _tmp1_;
}


static ValaGenieTokenType vala_genie_scanner_get_identifier_or_keyword (ValaGenieScanner* self, gchar* begin, gint len) {
	ValaGenieTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	switch (len) {
		case 2:
		{
			switch (begin[0]) {
				case 'a':
				{
					gboolean _tmp0_;
					_tmp0_ = vala_genie_scanner_matches (self, begin, "as");
					if (_tmp0_) {
						result = VALA_GENIE_TOKEN_TYPE_AS;
						return result;
					}
					break;
				}
				case 'd':
				{
					gboolean _tmp1_;
					_tmp1_ = vala_genie_scanner_matches (self, begin, "do");
					if (_tmp1_) {
						result = VALA_GENIE_TOKEN_TYPE_DO;
						return result;
					}
					break;
				}
				case 'i':
				{
					switch (begin[1]) {
						case 'f':
						{
							result = VALA_GENIE_TOKEN_TYPE_IF;
							return result;
						}
						case 'n':
						{
							result = VALA_GENIE_TOKEN_TYPE_IN;
							return result;
						}
						case 's':
						{
							result = VALA_GENIE_TOKEN_TYPE_IS;
							return result;
						}
						default:
						break;
					}
					break;
				}
				case 'o':
				{
					gboolean _tmp2_;
					gboolean _tmp3_;
					_tmp2_ = vala_genie_scanner_matches (self, begin, "of");
					if (_tmp2_) {
						result = VALA_GENIE_TOKEN_TYPE_OF;
						return result;
					}
					_tmp3_ = vala_genie_scanner_matches (self, begin, "or");
					if (_tmp3_) {
						result = VALA_GENIE_TOKEN_TYPE_OP_OR;
						return result;
					}
					break;
				}
				case 't':
				{
					gboolean _tmp4_;
					_tmp4_ = vala_genie_scanner_matches (self, begin, "to");
					if (_tmp4_) {
						result = VALA_GENIE_TOKEN_TYPE_TO;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 3:
		{
			switch (begin[0]) {
				case 'a':
				{
					gboolean _tmp5_;
					_tmp5_ = vala_genie_scanner_matches (self, begin, "and");
					if (_tmp5_) {
						result = VALA_GENIE_TOKEN_TYPE_OP_AND;
						return result;
					}
					break;
				}
				case 'd':
				{
					gboolean _tmp6_;
					_tmp6_ = vala_genie_scanner_matches (self, begin, "def");
					if (_tmp6_) {
						result = VALA_GENIE_TOKEN_TYPE_DEF;
						return result;
					}
					break;
				}
				case 'f':
				{
					gboolean _tmp7_;
					_tmp7_ = vala_genie_scanner_matches (self, begin, "for");
					if (_tmp7_) {
						result = VALA_GENIE_TOKEN_TYPE_FOR;
						return result;
					}
					break;
				}
				case 'g':
				{
					gboolean _tmp8_;
					_tmp8_ = vala_genie_scanner_matches (self, begin, "get");
					if (_tmp8_) {
						result = VALA_GENIE_TOKEN_TYPE_GET;
						return result;
					}
					break;
				}
				case 'i':
				{
					gboolean _tmp9_;
					_tmp9_ = vala_genie_scanner_matches (self, begin, "isa");
					if (_tmp9_) {
						result = VALA_GENIE_TOKEN_TYPE_ISA;
						return result;
					}
					break;
				}
				case 'n':
				{
					switch (begin[1]) {
						case 'e':
						{
							gboolean _tmp10_;
							_tmp10_ = vala_genie_scanner_matches (self, begin, "new");
							if (_tmp10_) {
								result = VALA_GENIE_TOKEN_TYPE_NEW;
								return result;
							}
							break;
						}
						case 'o':
						{
							gboolean _tmp11_;
							_tmp11_ = vala_genie_scanner_matches (self, begin, "not");
							if (_tmp11_) {
								result = VALA_GENIE_TOKEN_TYPE_OP_NEG;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'o':
				{
					gboolean _tmp12_;
					_tmp12_ = vala_genie_scanner_matches (self, begin, "out");
					if (_tmp12_) {
						result = VALA_GENIE_TOKEN_TYPE_OUT;
						return result;
					}
					break;
				}
				case 'r':
				{
					gboolean _tmp13_;
					_tmp13_ = vala_genie_scanner_matches (self, begin, "ref");
					if (_tmp13_) {
						result = VALA_GENIE_TOKEN_TYPE_REF;
						return result;
					}
					break;
				}
				case 's':
				{
					gboolean _tmp14_;
					_tmp14_ = vala_genie_scanner_matches (self, begin, "set");
					if (_tmp14_) {
						result = VALA_GENIE_TOKEN_TYPE_SET;
						return result;
					}
					break;
				}
				case 't':
				{
					gboolean _tmp15_;
					_tmp15_ = vala_genie_scanner_matches (self, begin, "try");
					if (_tmp15_) {
						result = VALA_GENIE_TOKEN_TYPE_TRY;
						return result;
					}
					break;
				}
				case 'v':
				{
					gboolean _tmp16_;
					_tmp16_ = vala_genie_scanner_matches (self, begin, "var");
					if (_tmp16_) {
						result = VALA_GENIE_TOKEN_TYPE_VAR;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 4:
		{
			switch (begin[0]) {
				case 'c':
				{
					gboolean _tmp17_;
					_tmp17_ = vala_genie_scanner_matches (self, begin, "case");
					if (_tmp17_) {
						result = VALA_GENIE_TOKEN_TYPE_CASE;
						return result;
					}
					break;
				}
				case 'd':
				{
					gboolean _tmp18_;
					_tmp18_ = vala_genie_scanner_matches (self, begin, "dict");
					if (_tmp18_) {
						result = VALA_GENIE_TOKEN_TYPE_DICT;
						return result;
					}
					break;
				}
				case 'e':
				{
					switch (begin[1]) {
						case 'l':
						{
							gboolean _tmp19_;
							_tmp19_ = vala_genie_scanner_matches (self, begin, "else");
							if (_tmp19_) {
								result = VALA_GENIE_TOKEN_TYPE_ELSE;
								return result;
							}
							break;
						}
						case 'n':
						{
							gboolean _tmp20_;
							_tmp20_ = vala_genie_scanner_matches (self, begin, "enum");
							if (_tmp20_) {
								result = VALA_GENIE_TOKEN_TYPE_ENUM;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'i':
				{
					gboolean _tmp21_;
					_tmp21_ = vala_genie_scanner_matches (self, begin, "init");
					if (_tmp21_) {
						result = VALA_GENIE_TOKEN_TYPE_INIT;
						return result;
					}
					break;
				}
				case 'l':
				{
					switch (begin[1]) {
						case 'i':
						{
							gboolean _tmp22_;
							_tmp22_ = vala_genie_scanner_matches (self, begin, "list");
							if (_tmp22_) {
								result = VALA_GENIE_TOKEN_TYPE_LIST;
								return result;
							}
							break;
						}
						case 'o':
						{
							gboolean _tmp23_;
							_tmp23_ = vala_genie_scanner_matches (self, begin, "lock");
							if (_tmp23_) {
								result = VALA_GENIE_TOKEN_TYPE_LOCK;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'n':
				{
					gboolean _tmp24_;
					_tmp24_ = vala_genie_scanner_matches (self, begin, "null");
					if (_tmp24_) {
						result = VALA_GENIE_TOKEN_TYPE_NULL;
						return result;
					}
					break;
				}
				case 'p':
				{
					switch (begin[1]) {
						case 'a':
						{
							gboolean _tmp25_;
							_tmp25_ = vala_genie_scanner_matches (self, begin, "pass");
							if (_tmp25_) {
								result = VALA_GENIE_TOKEN_TYPE_PASS;
								return result;
							}
							break;
						}
						case 'r':
						{
							gboolean _tmp26_;
							_tmp26_ = vala_genie_scanner_matches (self, begin, "prop");
							if (_tmp26_) {
								result = VALA_GENIE_TOKEN_TYPE_PROP;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 's':
				{
					gboolean _tmp27_;
					_tmp27_ = vala_genie_scanner_matches (self, begin, "self");
					if (_tmp27_) {
						result = VALA_GENIE_TOKEN_TYPE_THIS;
						return result;
					}
					break;
				}
				case 't':
				{
					gboolean _tmp28_;
					_tmp28_ = vala_genie_scanner_matches (self, begin, "true");
					if (_tmp28_) {
						result = VALA_GENIE_TOKEN_TYPE_TRUE;
						return result;
					}
					break;
				}
				case 'u':
				{
					gboolean _tmp29_;
					_tmp29_ = vala_genie_scanner_matches (self, begin, "uses");
					if (_tmp29_) {
						result = VALA_GENIE_TOKEN_TYPE_USES;
						return result;
					}
					break;
				}
				case 'v':
				{
					gboolean _tmp30_;
					_tmp30_ = vala_genie_scanner_matches (self, begin, "void");
					if (_tmp30_) {
						result = VALA_GENIE_TOKEN_TYPE_VOID;
						return result;
					}
					break;
				}
				case 'w':
				{
					switch (begin[1]) {
						case 'e':
						{
							gboolean _tmp31_;
							_tmp31_ = vala_genie_scanner_matches (self, begin, "weak");
							if (_tmp31_) {
								result = VALA_GENIE_TOKEN_TYPE_WEAK;
								return result;
							}
							break;
						}
						case 'h':
						{
							gboolean _tmp32_;
							_tmp32_ = vala_genie_scanner_matches (self, begin, "when");
							if (_tmp32_) {
								result = VALA_GENIE_TOKEN_TYPE_WHEN;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 5:
		{
			switch (begin[0]) {
				case 'a':
				{
					switch (begin[1]) {
						case 'r':
						{
							gboolean _tmp33_;
							_tmp33_ = vala_genie_scanner_matches (self, begin, "array");
							if (_tmp33_) {
								result = VALA_GENIE_TOKEN_TYPE_ARRAY;
								return result;
							}
							break;
						}
						case 's':
						{
							gboolean _tmp34_;
							_tmp34_ = vala_genie_scanner_matches (self, begin, "async");
							if (_tmp34_) {
								result = VALA_GENIE_TOKEN_TYPE_ASYNC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'b':
				{
					gboolean _tmp35_;
					_tmp35_ = vala_genie_scanner_matches (self, begin, "break");
					if (_tmp35_) {
						result = VALA_GENIE_TOKEN_TYPE_BREAK;
						return result;
					}
					break;
				}
				case 'c':
				{
					switch (begin[1]) {
						case 'l':
						{
							gboolean _tmp36_;
							_tmp36_ = vala_genie_scanner_matches (self, begin, "class");
							if (_tmp36_) {
								result = VALA_GENIE_TOKEN_TYPE_CLASS;
								return result;
							}
							break;
						}
						case 'o':
						{
							gboolean _tmp37_;
							_tmp37_ = vala_genie_scanner_matches (self, begin, "const");
							if (_tmp37_) {
								result = VALA_GENIE_TOKEN_TYPE_CONST;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					gboolean _tmp38_;
					_tmp38_ = vala_genie_scanner_matches (self, begin, "event");
					if (_tmp38_) {
						result = VALA_GENIE_TOKEN_TYPE_EVENT;
						return result;
					}
					break;
				}
				case 'f':
				{
					switch (begin[1]) {
						case 'a':
						{
							gboolean _tmp39_;
							_tmp39_ = vala_genie_scanner_matches (self, begin, "false");
							if (_tmp39_) {
								result = VALA_GENIE_TOKEN_TYPE_FALSE;
								return result;
							}
							break;
						}
						case 'i':
						{
							gboolean _tmp40_;
							_tmp40_ = vala_genie_scanner_matches (self, begin, "final");
							if (_tmp40_) {
								result = VALA_GENIE_TOKEN_TYPE_FINAL;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'o':
				{
					gboolean _tmp41_;
					_tmp41_ = vala_genie_scanner_matches (self, begin, "owned");
					if (_tmp41_) {
						result = VALA_GENIE_TOKEN_TYPE_OWNED;
						return result;
					}
					break;
				}
				case 'p':
				{
					gboolean _tmp42_;
					_tmp42_ = vala_genie_scanner_matches (self, begin, "print");
					if (_tmp42_) {
						result = VALA_GENIE_TOKEN_TYPE_PRINT;
						return result;
					}
					break;
				}
				case 's':
				{
					gboolean _tmp43_;
					_tmp43_ = vala_genie_scanner_matches (self, begin, "super");
					if (_tmp43_) {
						result = VALA_GENIE_TOKEN_TYPE_SUPER;
						return result;
					}
					break;
				}
				case 'r':
				{
					gboolean _tmp44_;
					_tmp44_ = vala_genie_scanner_matches (self, begin, "raise");
					if (_tmp44_) {
						result = VALA_GENIE_TOKEN_TYPE_RAISE;
						return result;
					}
					break;
				}
				case 'w':
				{
					gboolean _tmp45_;
					_tmp45_ = vala_genie_scanner_matches (self, begin, "while");
					if (_tmp45_) {
						result = VALA_GENIE_TOKEN_TYPE_WHILE;
						return result;
					}
					break;
				}
				case 'y':
				{
					gboolean _tmp46_;
					_tmp46_ = vala_genie_scanner_matches (self, begin, "yield");
					if (_tmp46_) {
						result = VALA_GENIE_TOKEN_TYPE_YIELD;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 6:
		{
			switch (begin[0]) {
				case 'a':
				{
					gboolean _tmp47_;
					_tmp47_ = vala_genie_scanner_matches (self, begin, "assert");
					if (_tmp47_) {
						result = VALA_GENIE_TOKEN_TYPE_ASSERT;
						return result;
					}
					break;
				}
				case 'd':
				{
					switch (begin[1]) {
						case 'e':
						{
							gboolean _tmp48_;
							_tmp48_ = vala_genie_scanner_matches (self, begin, "delete");
							if (_tmp48_) {
								result = VALA_GENIE_TOKEN_TYPE_DELETE;
								return result;
							}
							break;
						}
						case 'o':
						{
							gboolean _tmp49_;
							_tmp49_ = vala_genie_scanner_matches (self, begin, "downto");
							if (_tmp49_) {
								result = VALA_GENIE_TOKEN_TYPE_DOWNTO;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					switch (begin[1]) {
						case 'x':
						{
							switch (begin[2]) {
								case 'c':
								{
									gboolean _tmp50_;
									_tmp50_ = vala_genie_scanner_matches (self, begin, "except");
									if (_tmp50_) {
										result = VALA_GENIE_TOKEN_TYPE_EXCEPT;
										return result;
									}
									break;
								}
								case 't':
								{
									gboolean _tmp51_;
									_tmp51_ = vala_genie_scanner_matches (self, begin, "extern");
									if (_tmp51_) {
										result = VALA_GENIE_TOKEN_TYPE_EXTERN;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'i':
				{
					gboolean _tmp52_;
					_tmp52_ = vala_genie_scanner_matches (self, begin, "inline");
					if (_tmp52_) {
						result = VALA_GENIE_TOKEN_TYPE_INLINE;
						return result;
					}
					break;
				}
				case 'p':
				{
					switch (begin[1]) {
						case 'a':
						{
							gboolean _tmp53_;
							_tmp53_ = vala_genie_scanner_matches (self, begin, "params");
							if (_tmp53_) {
								result = VALA_GENIE_TOKEN_TYPE_PARAMS;
								return result;
							}
							break;
						}
						case 'u':
						{
							gboolean _tmp54_;
							_tmp54_ = vala_genie_scanner_matches (self, begin, "public");
							if (_tmp54_) {
								result = VALA_GENIE_TOKEN_TYPE_PUBLIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'r':
				{
					switch (begin[1]) {
						case 'a':
						{
							gboolean _tmp55_;
							_tmp55_ = vala_genie_scanner_matches (self, begin, "raises");
							if (_tmp55_) {
								result = VALA_GENIE_TOKEN_TYPE_RAISES;
								return result;
							}
							break;
						}
						case 'e':
						{
							gboolean _tmp56_;
							_tmp56_ = vala_genie_scanner_matches (self, begin, "return");
							if (_tmp56_) {
								result = VALA_GENIE_TOKEN_TYPE_RETURN;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 's':
				{
					switch (begin[1]) {
						case 'i':
						{
							gboolean _tmp57_;
							_tmp57_ = vala_genie_scanner_matches (self, begin, "sizeof");
							if (_tmp57_) {
								result = VALA_GENIE_TOKEN_TYPE_SIZEOF;
								return result;
							}
							break;
						}
						case 't':
						{
							switch (begin[2]) {
								case 'a':
								{
									gboolean _tmp58_;
									_tmp58_ = vala_genie_scanner_matches (self, begin, "static");
									if (_tmp58_) {
										result = VALA_GENIE_TOKEN_TYPE_STATIC;
										return result;
									}
									break;
								}
								case 'r':
								{
									gboolean _tmp59_;
									_tmp59_ = vala_genie_scanner_matches (self, begin, "struct");
									if (_tmp59_) {
										result = VALA_GENIE_TOKEN_TYPE_STRUCT;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 't':
				{
					gboolean _tmp60_;
					_tmp60_ = vala_genie_scanner_matches (self, begin, "typeof");
					if (_tmp60_) {
						result = VALA_GENIE_TOKEN_TYPE_TYPEOF;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 7:
		{
			switch (begin[0]) {
				case 'd':
				{
					switch (begin[1]) {
						case 'e':
						{
							gboolean _tmp61_;
							_tmp61_ = vala_genie_scanner_matches (self, begin, "default");
							if (_tmp61_) {
								result = VALA_GENIE_TOKEN_TYPE_DEFAULT;
								return result;
							}
							break;
						}
						case 'y':
						{
							gboolean _tmp62_;
							_tmp62_ = vala_genie_scanner_matches (self, begin, "dynamic");
							if (_tmp62_) {
								result = VALA_GENIE_TOKEN_TYPE_DYNAMIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					gboolean _tmp63_;
					_tmp63_ = vala_genie_scanner_matches (self, begin, "ensures");
					if (_tmp63_) {
						result = VALA_GENIE_TOKEN_TYPE_ENSURES;
						return result;
					}
					break;
				}
				case 'f':
				{
					switch (begin[1]) {
						case 'i':
						{
							gboolean _tmp64_;
							_tmp64_ = vala_genie_scanner_matches (self, begin, "finally");
							if (_tmp64_) {
								result = VALA_GENIE_TOKEN_TYPE_FINALLY;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'p':
				{
					gboolean _tmp65_;
					_tmp65_ = vala_genie_scanner_matches (self, begin, "private");
					if (_tmp65_) {
						result = VALA_GENIE_TOKEN_TYPE_PRIVATE;
						return result;
					}
					break;
				}
				case 'u':
				{
					gboolean _tmp66_;
					_tmp66_ = vala_genie_scanner_matches (self, begin, "unowned");
					if (_tmp66_) {
						result = VALA_GENIE_TOKEN_TYPE_UNOWNED;
						return result;
					}
					break;
				}
				case 'v':
				{
					gboolean _tmp67_;
					_tmp67_ = vala_genie_scanner_matches (self, begin, "virtual");
					if (_tmp67_) {
						result = VALA_GENIE_TOKEN_TYPE_VIRTUAL;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 8:
		{
			switch (begin[0]) {
				case 'a':
				{
					gboolean _tmp68_;
					_tmp68_ = vala_genie_scanner_matches (self, begin, "abstract");
					if (_tmp68_) {
						result = VALA_GENIE_TOKEN_TYPE_ABSTRACT;
						return result;
					}
					break;
				}
				case 'c':
				{
					gboolean _tmp69_;
					_tmp69_ = vala_genie_scanner_matches (self, begin, "continue");
					if (_tmp69_) {
						result = VALA_GENIE_TOKEN_TYPE_CONTINUE;
						return result;
					}
					break;
				}
				case 'd':
				{
					gboolean _tmp70_;
					_tmp70_ = vala_genie_scanner_matches (self, begin, "delegate");
					if (_tmp70_) {
						result = VALA_GENIE_TOKEN_TYPE_DELEGATE;
						return result;
					}
					break;
				}
				case 'i':
				{
					gboolean _tmp71_;
					_tmp71_ = vala_genie_scanner_matches (self, begin, "internal");
					if (_tmp71_) {
						result = VALA_GENIE_TOKEN_TYPE_INTERNAL;
						return result;
					}
					break;
				}
				case 'o':
				{
					gboolean _tmp72_;
					_tmp72_ = vala_genie_scanner_matches (self, begin, "override");
					if (_tmp72_) {
						result = VALA_GENIE_TOKEN_TYPE_OVERRIDE;
						return result;
					}
					break;
				}
				case 'r':
				{
					switch (begin[2]) {
						case 'a':
						{
							gboolean _tmp73_;
							_tmp73_ = vala_genie_scanner_matches (self, begin, "readonly");
							if (_tmp73_) {
								result = VALA_GENIE_TOKEN_TYPE_READONLY;
								return result;
							}
							break;
						}
						case 'q':
						{
							gboolean _tmp74_;
							_tmp74_ = vala_genie_scanner_matches (self, begin, "requires");
							if (_tmp74_) {
								result = VALA_GENIE_TOKEN_TYPE_REQUIRES;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'v':
				{
					gboolean _tmp75_;
					_tmp75_ = vala_genie_scanner_matches (self, begin, "volatile");
					if (_tmp75_) {
						result = VALA_GENIE_TOKEN_TYPE_VOLATILE;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 9:
		{
			switch (begin[0]) {
				case 'c':
				{
					gboolean _tmp76_;
					_tmp76_ = vala_genie_scanner_matches (self, begin, "construct");
					if (_tmp76_) {
						result = VALA_GENIE_TOKEN_TYPE_CONSTRUCT;
						return result;
					}
					break;
				}
				case 'e':
				{
					gboolean _tmp77_;
					_tmp77_ = vala_genie_scanner_matches (self, begin, "exception");
					if (_tmp77_) {
						result = VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN;
						return result;
					}
					break;
				}
				case 'i':
				{
					gboolean _tmp78_;
					_tmp78_ = vala_genie_scanner_matches (self, begin, "interface");
					if (_tmp78_) {
						result = VALA_GENIE_TOKEN_TYPE_INTERFACE;
						return result;
					}
					break;
				}
				case 'n':
				{
					gboolean _tmp79_;
					_tmp79_ = vala_genie_scanner_matches (self, begin, "namespace");
					if (_tmp79_) {
						result = VALA_GENIE_TOKEN_TYPE_NAMESPACE;
						return result;
					}
					break;
				}
				case 'p':
				{
					gboolean _tmp80_;
					_tmp80_ = vala_genie_scanner_matches (self, begin, "protected");
					if (_tmp80_) {
						result = VALA_GENIE_TOKEN_TYPE_PROTECTED;
						return result;
					}
					break;
				}
				case 'w':
				{
					gboolean _tmp81_;
					_tmp81_ = vala_genie_scanner_matches (self, begin, "writeonly");
					if (_tmp81_) {
						result = VALA_GENIE_TOKEN_TYPE_WRITEONLY;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 10:
		{
			switch (begin[0]) {
				case 'i':
				{
					gboolean _tmp82_;
					_tmp82_ = vala_genie_scanner_matches (self, begin, "implements");
					if (_tmp82_) {
						result = VALA_GENIE_TOKEN_TYPE_IMPLEMENTS;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		default:
		break;
	}
	result = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
	return result;
}


static void _vala_array_add2 (ValaGenieScannerState** array, int* length, int* size, ValaGenieScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add3 (ValaGenieScannerState** array, int* length, int* size, ValaGenieScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add4 (ValaGenieScannerState** array, int* length, int* size, ValaGenieScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add5 (ValaGenieScannerState** array, int* length, int* size, ValaGenieScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


ValaGenieTokenType vala_genie_scanner_read_template_token (ValaGenieScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaSourceLocation _token_begin = {0};
	ValaSourceLocation _token_end = {0};
	ValaGenieTokenType result = 0;
	ValaGenieTokenType type = 0;
	gchar* begin;
	gint token_length_in_chars;
	g_return_val_if_fail (self != NULL, 0);
	begin = self->priv->current;
	_token_begin.pos = begin;
	_token_begin.line = self->priv->line;
	_token_begin.column = self->priv->column;
	token_length_in_chars = -1;
	if (self->priv->current >= self->priv->end) {
		type = VALA_GENIE_TOKEN_TYPE_EOF;
	} else {
		switch (self->priv->current[0]) {
			case '"':
			{
				type = VALA_GENIE_TOKEN_TYPE_CLOSE_TEMPLATE;
				self->priv->current++;
				self->priv->state_stack_length1--;
				break;
			}
			case '$':
			{
				gboolean _tmp0_ = FALSE;
				gboolean _tmp1_;
				_token_begin.pos++;
				self->priv->current++;
				_tmp1_ = g_ascii_isalpha (self->priv->current[0]);
				if (_tmp1_) {
					_tmp0_ = TRUE;
				} else {
					_tmp0_ = self->priv->current[0] == '_';
				}
				if (_tmp0_) {
					gint len;
					len = 0;
					while (TRUE) {
						gboolean _tmp2_ = FALSE;
						if (self->priv->current < self->priv->end) {
							gboolean _tmp3_;
							_tmp3_ = vala_genie_scanner_is_ident_char (self, self->priv->current[0]);
							_tmp2_ = _tmp3_;
						} else {
							_tmp2_ = FALSE;
						}
						if (!_tmp2_) {
							break;
						}
						self->priv->current++;
						len++;
					}
					type = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
					_vala_array_add2 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_TEMPLATE_PART);
				} else {
					if (self->priv->current[0] == '(') {
						ValaSourceLocation _tmp4_ = {0};
						ValaSourceLocation _tmp5_ = {0};
						ValaGenieTokenType _tmp6_;
						self->priv->current++;
						self->priv->column = self->priv->column + 2;
						_vala_array_add3 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_PARENS);
						_tmp6_ = vala_genie_scanner_read_token (self, &_tmp4_, &_tmp5_);
						_token_begin = _tmp4_;
						_token_end = _tmp5_;
						result = _tmp6_;
						if (token_begin) {
							*token_begin = _token_begin;
						}
						if (token_end) {
							*token_end = _token_end;
						}
						return result;
					} else {
						if (self->priv->current[0] == '$') {
							type = VALA_GENIE_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
							self->priv->current++;
							_vala_array_add4 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_TEMPLATE_PART);
						} else {
							ValaSourceReference* _tmp7_ = NULL;
							ValaSourceReference* _tmp8_;
							ValaSourceLocation _tmp9_ = {0};
							ValaSourceLocation _tmp10_ = {0};
							ValaGenieTokenType _tmp11_;
							_tmp7_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + 1, self->priv->line, self->priv->column + 1);
							_tmp8_ = _tmp7_;
							vala_report_error (_tmp8_, "unexpected character");
							_vala_source_reference_unref0 (_tmp8_);
							_tmp11_ = vala_genie_scanner_read_template_token (self, &_tmp9_, &_tmp10_);
							_token_begin = _tmp9_;
							_token_end = _tmp10_;
							result = _tmp11_;
							if (token_begin) {
								*token_begin = _token_begin;
							}
							if (token_end) {
								*token_end = _token_end;
							}
							return result;
						}
					}
				}
				break;
			}
			default:
			{
				gboolean _tmp22_ = FALSE;
				type = VALA_GENIE_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_ = FALSE;
					if (self->priv->current < self->priv->end) {
						_tmp13_ = self->priv->current[0] != '"';
					} else {
						_tmp13_ = FALSE;
					}
					if (_tmp13_) {
						_tmp12_ = self->priv->current[0] != '$';
					} else {
						_tmp12_ = FALSE;
					}
					if (!_tmp12_) {
						break;
					}
					if (self->priv->current[0] == '\\') {
						self->priv->current++;
						token_length_in_chars++;
						if (self->priv->current >= self->priv->end) {
							break;
						}
						switch (self->priv->current[0]) {
							case '\'':
							case '"':
							case '\\':
							case '0':
							case 'b':
							case 'f':
							case 'n':
							case 'r':
							case 't':
							{
								self->priv->current++;
								token_length_in_chars++;
								break;
							}
							case 'x':
							{
								self->priv->current++;
								token_length_in_chars++;
								while (TRUE) {
									gboolean _tmp14_ = FALSE;
									if (self->priv->current < self->priv->end) {
										gboolean _tmp15_;
										_tmp15_ = g_ascii_isxdigit (self->priv->current[0]);
										_tmp14_ = _tmp15_;
									} else {
										_tmp14_ = FALSE;
									}
									if (!_tmp14_) {
										break;
									}
									self->priv->current++;
									token_length_in_chars++;
								}
								break;
							}
							default:
							{
								ValaSourceReference* _tmp16_ = NULL;
								ValaSourceReference* _tmp17_;
								_tmp16_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
								_tmp17_ = _tmp16_;
								vala_report_error (_tmp17_, "invalid escape sequence");
								_vala_source_reference_unref0 (_tmp17_);
								break;
							}
						}
					} else {
						if (self->priv->current[0] == '\n') {
							break;
						} else {
							gunichar _tmp18_;
							gunichar u;
							_tmp18_ = g_utf8_get_char_validated ((const gchar*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
							u = _tmp18_;
							if (u != ((gunichar) (-1))) {
								gint _tmp19_;
								_tmp19_ = g_unichar_to_utf8 (u, NULL);
								self->priv->current = self->priv->current + _tmp19_;
								token_length_in_chars++;
							} else {
								ValaSourceReference* _tmp20_ = NULL;
								ValaSourceReference* _tmp21_;
								self->priv->current++;
								_tmp20_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
								_tmp21_ = _tmp20_;
								vala_report_error (_tmp21_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp21_);
							}
						}
					}
				}
				if (self->priv->current >= self->priv->end) {
					_tmp22_ = TRUE;
				} else {
					_tmp22_ = self->priv->current[0] == '\n';
				}
				if (_tmp22_) {
					ValaSourceReference* _tmp23_ = NULL;
					ValaSourceReference* _tmp24_;
					ValaSourceLocation _tmp25_ = {0};
					ValaSourceLocation _tmp26_ = {0};
					ValaGenieTokenType _tmp27_;
					_tmp23_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
					_tmp24_ = _tmp23_;
					vala_report_error (_tmp24_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp24_);
					self->priv->state_stack_length1--;
					_tmp27_ = vala_genie_scanner_read_token (self, &_tmp25_, &_tmp26_);
					_token_begin = _tmp25_;
					_token_end = _tmp26_;
					result = _tmp27_;
					if (token_begin) {
						*token_begin = _token_begin;
					}
					if (token_end) {
						*token_end = _token_end;
					}
					return result;
				}
				_vala_array_add5 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_TEMPLATE_PART);
				break;
			}
		}
	}
	if (token_length_in_chars < 0) {
		self->priv->column = self->priv->column + ((gint) (self->priv->current - begin));
	} else {
		self->priv->column = self->priv->column + token_length_in_chars;
	}
	_token_end.pos = self->priv->current;
	_token_end.line = self->priv->line;
	_token_end.column = self->priv->column - 1;
	result = type;
	if (token_begin) {
		*token_begin = _token_begin;
	}
	if (token_end) {
		*token_end = _token_end;
	}
	return result;
}


static void _vala_array_add6 (ValaGenieScannerState** array, int* length, int* size, ValaGenieScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add7 (ValaGenieScannerState** array, int* length, int* size, ValaGenieScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add8 (ValaGenieScannerState** array, int* length, int* size, ValaGenieScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add9 (ValaGenieScannerState** array, int* length, int* size, ValaGenieScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add10 (ValaGenieScannerState** array, int* length, int* size, ValaGenieScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


ValaGenieTokenType vala_genie_scanner_read_token (ValaGenieScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaSourceLocation _token_begin = {0};
	ValaSourceLocation _token_end = {0};
	ValaGenieTokenType result = 0;
	gboolean _tmp0_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_;
	ValaGenieTokenType type = 0;
	gchar* begin;
	gint token_length_in_chars;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_genie_scanner_in_template (self);
	if (_tmp0_) {
		ValaSourceLocation _tmp1_ = {0};
		ValaSourceLocation _tmp2_ = {0};
		ValaGenieTokenType _tmp3_;
		_tmp3_ = vala_genie_scanner_read_template_token (self, &_tmp1_, &_tmp2_);
		_token_begin = _tmp1_;
		_token_end = _tmp2_;
		result = _tmp3_;
		if (token_begin) {
			*token_begin = _token_begin;
		}
		if (token_end) {
			*token_end = _token_end;
		}
		return result;
	} else {
		gboolean _tmp4_;
		_tmp4_ = vala_genie_scanner_in_template_part (self);
		if (_tmp4_) {
			self->priv->state_stack_length1--;
			_token_begin.pos = self->priv->current;
			_token_begin.line = self->priv->line;
			_token_begin.column = self->priv->column;
			_token_end.pos = self->priv->current;
			_token_end.line = self->priv->line;
			_token_end.column = self->priv->column - 1;
			result = VALA_GENIE_TOKEN_TYPE_COMMA;
			if (token_begin) {
				*token_begin = _token_begin;
			}
			if (token_end) {
				*token_end = _token_end;
			}
			return result;
		} else {
			gboolean _tmp5_;
			_tmp5_ = vala_genie_scanner_in_regex_literal (self);
			if (_tmp5_) {
				ValaSourceLocation _tmp6_ = {0};
				ValaSourceLocation _tmp7_ = {0};
				ValaGenieTokenType _tmp8_;
				_tmp8_ = vala_genie_scanner_read_regex_token (self, &_tmp6_, &_tmp7_);
				_token_begin = _tmp6_;
				_token_end = _tmp7_;
				result = _tmp8_;
				if (token_begin) {
					*token_begin = _token_begin;
				}
				if (token_end) {
					*token_end = _token_end;
				}
				return result;
			}
		}
	}
	if (self->priv->pending_dedents > 0) {
		self->priv->pending_dedents--;
		self->priv->indent_level--;
		_token_begin.pos = self->priv->current;
		_token_begin.line = self->priv->line;
		_token_begin.column = self->priv->column;
		_token_end.pos = self->priv->current;
		_token_end.line = self->priv->line;
		_token_end.column = self->priv->column;
		self->priv->last_token = VALA_GENIE_TOKEN_TYPE_DEDENT;
		result = VALA_GENIE_TOKEN_TYPE_DEDENT;
		if (token_begin) {
			*token_begin = _token_begin;
		}
		if (token_end) {
			*token_end = _token_end;
		}
		return result;
	}
	if (self->priv->_indent_spaces == 0) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = self->priv->last_token != VALA_GENIE_TOKEN_TYPE_EOL;
	}
	if (_tmp9_) {
		vala_genie_scanner_space (self);
	}
	while (TRUE) {
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		if (self->priv->current < self->priv->end) {
			_tmp11_ = self->priv->current[0] == '\\';
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			_tmp10_ = self->priv->current[1] == '\n';
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			break;
		}
		self->priv->current = self->priv->current + 2;
		self->priv->line++;
		vala_genie_scanner_skip_space_tabs (self);
	}
	while (TRUE) {
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		if (self->priv->current < self->priv->end) {
			_tmp13_ = self->priv->current[0] == '\n';
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			gboolean _tmp14_ = FALSE;
			if (self->priv->open_parens_count > 0) {
				_tmp14_ = TRUE;
			} else {
				_tmp14_ = self->priv->open_brace_count > 0;
			}
			_tmp12_ = _tmp14_;
		} else {
			_tmp12_ = FALSE;
		}
		if (!_tmp12_) {
			break;
		}
		self->priv->current++;
		self->priv->line++;
		vala_genie_scanner_skip_space_tabs (self);
	}
	_tmp18_ = vala_genie_scanner_newline (self);
	if (_tmp18_) {
		_tmp17_ = self->priv->parse_started;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		_tmp16_ = self->priv->last_token != VALA_GENIE_TOKEN_TYPE_EOL;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		_tmp15_ = self->priv->last_token != VALA_GENIE_TOKEN_TYPE_SEMICOLON;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		_token_begin.pos = self->priv->current;
		_token_begin.line = self->priv->line;
		_token_begin.column = self->priv->column;
		_token_end.pos = self->priv->current;
		_token_end.line = self->priv->line;
		_token_end.column = self->priv->column;
		self->priv->last_token = VALA_GENIE_TOKEN_TYPE_EOL;
		result = VALA_GENIE_TOKEN_TYPE_EOL;
		if (token_begin) {
			*token_begin = _token_begin;
		}
		if (token_end) {
			*token_end = _token_end;
		}
		return result;
	}
	while (TRUE) {
		gboolean _tmp19_;
		gint _tmp20_;
		_tmp19_ = vala_genie_scanner_skip_newlines (self);
		if (!_tmp19_) {
			break;
		}
		_token_begin.pos = self->priv->current;
		_token_begin.line = self->priv->line;
		_token_begin.column = self->priv->column;
		_tmp20_ = vala_genie_scanner_count_tabs (self);
		self->priv->current_indent_level = _tmp20_;
		if (self->priv->current_indent_level == (-1)) {
			continue;
		}
		if (self->priv->current_indent_level > self->priv->indent_level) {
			self->priv->indent_level = self->priv->current_indent_level;
			_token_end.pos = self->priv->current;
			_token_end.line = self->priv->line;
			_token_end.column = self->priv->column;
			self->priv->last_token = VALA_GENIE_TOKEN_TYPE_INDENT;
			result = VALA_GENIE_TOKEN_TYPE_INDENT;
			if (token_begin) {
				*token_begin = _token_begin;
			}
			if (token_end) {
				*token_end = _token_end;
			}
			return result;
		} else {
			if (self->priv->current_indent_level < self->priv->indent_level) {
				self->priv->indent_level--;
				self->priv->pending_dedents = self->priv->indent_level - self->priv->current_indent_level;
				_token_end.pos = self->priv->current;
				_token_end.line = self->priv->line;
				_token_end.column = self->priv->column;
				self->priv->last_token = VALA_GENIE_TOKEN_TYPE_DEDENT;
				result = VALA_GENIE_TOKEN_TYPE_DEDENT;
				if (token_begin) {
					*token_begin = _token_begin;
				}
				if (token_end) {
					*token_end = _token_end;
				}
				return result;
			}
		}
	}
	begin = self->priv->current;
	_token_begin.pos = begin;
	_token_begin.line = self->priv->line;
	_token_begin.column = self->priv->column;
	token_length_in_chars = -1;
	self->priv->parse_started = TRUE;
	if (self->priv->current >= self->priv->end) {
		if (self->priv->indent_level > 0) {
			self->priv->indent_level--;
			self->priv->pending_dedents = self->priv->indent_level;
			type = VALA_GENIE_TOKEN_TYPE_DEDENT;
		} else {
			type = VALA_GENIE_TOKEN_TYPE_EOF;
		}
	} else {
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_;
		_tmp22_ = g_ascii_isalpha (self->priv->current[0]);
		if (_tmp22_) {
			_tmp21_ = TRUE;
		} else {
			_tmp21_ = self->priv->current[0] == '_';
		}
		if (_tmp21_) {
			gint len;
			ValaGenieTokenType _tmp25_;
			len = 0;
			while (TRUE) {
				gboolean _tmp23_ = FALSE;
				if (self->priv->current < self->priv->end) {
					gboolean _tmp24_;
					_tmp24_ = vala_genie_scanner_is_ident_char (self, self->priv->current[0]);
					_tmp23_ = _tmp24_;
				} else {
					_tmp23_ = FALSE;
				}
				if (!_tmp23_) {
					break;
				}
				self->priv->current++;
				len++;
			}
			_tmp25_ = vala_genie_scanner_get_identifier_or_keyword (self, begin, len);
			type = _tmp25_;
		} else {
			if (self->priv->current[0] == '@') {
				gboolean _tmp26_ = FALSE;
				if (self->priv->current < (self->priv->end - 1)) {
					_tmp26_ = self->priv->current[1] == '"';
				} else {
					_tmp26_ = FALSE;
				}
				if (_tmp26_) {
					type = VALA_GENIE_TOKEN_TYPE_OPEN_TEMPLATE;
					self->priv->current = self->priv->current + 2;
					_vala_array_add6 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_TEMPLATE);
				} else {
					gint len;
					_token_begin.pos++;
					self->priv->current++;
					len = 0;
					while (TRUE) {
						gboolean _tmp27_ = FALSE;
						if (self->priv->current < self->priv->end) {
							gboolean _tmp28_;
							_tmp28_ = vala_genie_scanner_is_ident_char (self, self->priv->current[0]);
							_tmp27_ = _tmp28_;
						} else {
							_tmp27_ = FALSE;
						}
						if (!_tmp27_) {
							break;
						}
						self->priv->current++;
						len++;
					}
					type = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
				}
			} else {
				gboolean _tmp29_;
				_tmp29_ = g_ascii_isdigit (self->priv->current[0]);
				if (_tmp29_) {
					gboolean _tmp32_ = FALSE;
					while (TRUE) {
						gboolean _tmp30_ = FALSE;
						if (self->priv->current < self->priv->end) {
							gboolean _tmp31_;
							_tmp31_ = g_ascii_isdigit (self->priv->current[0]);
							_tmp30_ = _tmp31_;
						} else {
							_tmp30_ = FALSE;
						}
						if (!_tmp30_) {
							break;
						}
						self->priv->current++;
					}
					type = VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL;
					if (self->priv->current < self->priv->end) {
						gchar _tmp33_;
						_tmp33_ = g_ascii_tolower (self->priv->current[0]);
						_tmp32_ = _tmp33_ == 'l';
					} else {
						_tmp32_ = FALSE;
					}
					if (_tmp32_) {
						gboolean _tmp34_ = FALSE;
						self->priv->current++;
						if (self->priv->current < self->priv->end) {
							gchar _tmp35_;
							_tmp35_ = g_ascii_tolower (self->priv->current[0]);
							_tmp34_ = _tmp35_ == 'l';
						} else {
							_tmp34_ = FALSE;
						}
						if (_tmp34_) {
							self->priv->current++;
						}
					} else {
						gboolean _tmp36_ = FALSE;
						if (self->priv->current < self->priv->end) {
							gchar _tmp37_;
							_tmp37_ = g_ascii_tolower (self->priv->current[0]);
							_tmp36_ = _tmp37_ == 'u';
						} else {
							_tmp36_ = FALSE;
						}
						if (_tmp36_) {
							gboolean _tmp38_ = FALSE;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								gchar _tmp39_;
								_tmp39_ = g_ascii_tolower (self->priv->current[0]);
								_tmp38_ = _tmp39_ == 'l';
							} else {
								_tmp38_ = FALSE;
							}
							if (_tmp38_) {
								gboolean _tmp40_ = FALSE;
								self->priv->current++;
								if (self->priv->current < self->priv->end) {
									gchar _tmp41_;
									_tmp41_ = g_ascii_tolower (self->priv->current[0]);
									_tmp40_ = _tmp41_ == 'l';
								} else {
									_tmp40_ = FALSE;
								}
								if (_tmp40_) {
									self->priv->current++;
								}
							}
						} else {
							gboolean _tmp42_ = FALSE;
							gboolean _tmp43_ = FALSE;
							if (self->priv->current < (self->priv->end - 1)) {
								_tmp43_ = self->priv->current[0] == '.';
							} else {
								_tmp43_ = FALSE;
							}
							if (_tmp43_) {
								gboolean _tmp44_;
								_tmp44_ = g_ascii_isdigit (self->priv->current[1]);
								_tmp42_ = _tmp44_;
							} else {
								_tmp42_ = FALSE;
							}
							if (_tmp42_) {
								gboolean _tmp47_ = FALSE;
								gboolean _tmp53_ = FALSE;
								self->priv->current++;
								while (TRUE) {
									gboolean _tmp45_ = FALSE;
									if (self->priv->current < self->priv->end) {
										gboolean _tmp46_;
										_tmp46_ = g_ascii_isdigit (self->priv->current[0]);
										_tmp45_ = _tmp46_;
									} else {
										_tmp45_ = FALSE;
									}
									if (!_tmp45_) {
										break;
									}
									self->priv->current++;
								}
								if (self->priv->current < self->priv->end) {
									gchar _tmp48_;
									_tmp48_ = g_ascii_tolower (self->priv->current[0]);
									_tmp47_ = _tmp48_ == 'e';
								} else {
									_tmp47_ = FALSE;
								}
								if (_tmp47_) {
									gboolean _tmp49_ = FALSE;
									self->priv->current++;
									if (self->priv->current < self->priv->end) {
										gboolean _tmp50_ = FALSE;
										if (self->priv->current[0] == '+') {
											_tmp50_ = TRUE;
										} else {
											_tmp50_ = self->priv->current[0] == '-';
										}
										_tmp49_ = _tmp50_;
									} else {
										_tmp49_ = FALSE;
									}
									if (_tmp49_) {
										self->priv->current++;
									}
									while (TRUE) {
										gboolean _tmp51_ = FALSE;
										if (self->priv->current < self->priv->end) {
											gboolean _tmp52_;
											_tmp52_ = g_ascii_isdigit (self->priv->current[0]);
											_tmp51_ = _tmp52_;
										} else {
											_tmp51_ = FALSE;
										}
										if (!_tmp51_) {
											break;
										}
										self->priv->current++;
									}
								}
								if (self->priv->current < self->priv->end) {
									gchar _tmp54_;
									_tmp54_ = g_ascii_tolower (self->priv->current[0]);
									_tmp53_ = _tmp54_ == 'f';
								} else {
									_tmp53_ = FALSE;
								}
								if (_tmp53_) {
									self->priv->current++;
								}
								type = VALA_GENIE_TOKEN_TYPE_REAL_LITERAL;
							} else {
								gboolean _tmp55_ = FALSE;
								gboolean _tmp56_ = FALSE;
								gboolean _tmp57_ = FALSE;
								gboolean _tmp58_ = FALSE;
								if (self->priv->current < self->priv->end) {
									_tmp58_ = self->priv->current == (begin + 1);
								} else {
									_tmp58_ = FALSE;
								}
								if (_tmp58_) {
									_tmp57_ = begin[0] == '0';
								} else {
									_tmp57_ = FALSE;
								}
								if (_tmp57_) {
									_tmp56_ = begin[1] == 'x';
								} else {
									_tmp56_ = FALSE;
								}
								if (_tmp56_) {
									gboolean _tmp59_;
									_tmp59_ = g_ascii_isxdigit (begin[2]);
									_tmp55_ = _tmp59_;
								} else {
									_tmp55_ = FALSE;
								}
								if (_tmp55_) {
									self->priv->current++;
									while (TRUE) {
										gboolean _tmp60_ = FALSE;
										if (self->priv->current < self->priv->end) {
											gboolean _tmp61_;
											_tmp61_ = g_ascii_isxdigit (self->priv->current[0]);
											_tmp60_ = _tmp61_;
										} else {
											_tmp60_ = FALSE;
										}
										if (!_tmp60_) {
											break;
										}
										self->priv->current++;
									}
								} else {
									gboolean _tmp62_ = FALSE;
									if (self->priv->current < self->priv->end) {
										gboolean _tmp63_;
										_tmp63_ = vala_genie_scanner_is_ident_char (self, self->priv->current[0]);
										_tmp62_ = _tmp63_;
									} else {
										_tmp62_ = FALSE;
									}
									if (_tmp62_) {
										while (TRUE) {
											gboolean _tmp64_ = FALSE;
											if (self->priv->current < self->priv->end) {
												gboolean _tmp65_;
												_tmp65_ = vala_genie_scanner_is_ident_char (self, self->priv->current[0]);
												_tmp64_ = _tmp65_;
											} else {
												_tmp64_ = FALSE;
											}
											if (!_tmp64_) {
												break;
											}
											self->priv->current++;
										}
										type = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
									}
								}
							}
						}
					}
				} else {
					switch (self->priv->current[0]) {
						case '{':
						{
							type = VALA_GENIE_TOKEN_TYPE_OPEN_BRACE;
							self->priv->open_brace_count++;
							_vala_array_add7 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_BRACE);
							self->priv->current++;
							break;
						}
						case '}':
						{
							type = VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE;
							self->priv->open_brace_count--;
							if (self->priv->state_stack_length1 > 0) {
								self->priv->state_stack_length1--;
							}
							self->priv->current++;
							break;
						}
						case '(':
						{
							type = VALA_GENIE_TOKEN_TYPE_OPEN_PARENS;
							self->priv->open_parens_count++;
							_vala_array_add8 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_PARENS);
							self->priv->current++;
							break;
						}
						case ')':
						{
							gboolean _tmp66_;
							type = VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS;
							self->priv->open_parens_count--;
							self->priv->current++;
							if (self->priv->state_stack_length1 > 0) {
								self->priv->state_stack_length1--;
							}
							_tmp66_ = vala_genie_scanner_in_template (self);
							if (_tmp66_) {
								type = VALA_GENIE_TOKEN_TYPE_COMMA;
							}
							break;
						}
						case '[':
						{
							type = VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET;
							_vala_array_add9 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_BRACKET);
							self->priv->current++;
							break;
						}
						case ']':
						{
							type = VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET;
							if (self->priv->state_stack_length1 > 0) {
								self->priv->state_stack_length1--;
							}
							self->priv->current++;
							break;
						}
						case '.':
						{
							type = VALA_GENIE_TOKEN_TYPE_DOT;
							self->priv->current++;
							if (self->priv->current < (self->priv->end - 1)) {
								gboolean _tmp67_ = FALSE;
								if (self->priv->current[0] == '.') {
									_tmp67_ = self->priv->current[1] == '.';
								} else {
									_tmp67_ = FALSE;
								}
								if (_tmp67_) {
									type = VALA_GENIE_TOKEN_TYPE_ELLIPSIS;
									self->priv->current = self->priv->current + 2;
								}
							}
							break;
						}
						case ':':
						{
							type = VALA_GENIE_TOKEN_TYPE_COLON;
							self->priv->current++;
							break;
						}
						case ',':
						{
							type = VALA_GENIE_TOKEN_TYPE_COMMA;
							self->priv->current++;
							break;
						}
						case ';':
						{
							type = VALA_GENIE_TOKEN_TYPE_SEMICOLON;
							self->priv->current++;
							break;
						}
						case '#':
						{
							type = VALA_GENIE_TOKEN_TYPE_HASH;
							self->priv->current++;
							break;
						}
						case '?':
						{
							type = VALA_GENIE_TOKEN_TYPE_INTERR;
							self->priv->current++;
							break;
						}
						case '|':
						{
							type = VALA_GENIE_TOKEN_TYPE_BITWISE_OR;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								switch (self->priv->current[0]) {
									case '=':
									{
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR;
										self->priv->current++;
										break;
									}
									case '|':
									{
										type = VALA_GENIE_TOKEN_TYPE_OP_OR;
										self->priv->current++;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '&':
						{
							type = VALA_GENIE_TOKEN_TYPE_BITWISE_AND;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								switch (self->priv->current[0]) {
									case '=':
									{
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND;
										self->priv->current++;
										break;
									}
									case '&':
									{
										type = VALA_GENIE_TOKEN_TYPE_OP_AND;
										self->priv->current++;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '^':
						{
							gboolean _tmp68_ = FALSE;
							type = VALA_GENIE_TOKEN_TYPE_CARRET;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								_tmp68_ = self->priv->current[0] == '=';
							} else {
								_tmp68_ = FALSE;
							}
							if (_tmp68_) {
								type = VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR;
								self->priv->current++;
							}
							break;
						}
						case '~':
						{
							type = VALA_GENIE_TOKEN_TYPE_TILDE;
							self->priv->current++;
							break;
						}
						case '=':
						{
							type = VALA_GENIE_TOKEN_TYPE_ASSIGN;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								switch (self->priv->current[0]) {
									case '=':
									{
										type = VALA_GENIE_TOKEN_TYPE_OP_EQ;
										self->priv->current++;
										break;
									}
									case '>':
									{
										type = VALA_GENIE_TOKEN_TYPE_LAMBDA;
										self->priv->current++;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '<':
						{
							type = VALA_GENIE_TOKEN_TYPE_OP_LT;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								switch (self->priv->current[0]) {
									case '=':
									{
										type = VALA_GENIE_TOKEN_TYPE_OP_LE;
										self->priv->current++;
										break;
									}
									case '<':
									{
										gboolean _tmp69_ = FALSE;
										type = VALA_GENIE_TOKEN_TYPE_OP_SHIFT_LEFT;
										self->priv->current++;
										if (self->priv->current < self->priv->end) {
											_tmp69_ = self->priv->current[0] == '=';
										} else {
											_tmp69_ = FALSE;
										}
										if (_tmp69_) {
											type = VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT;
											self->priv->current++;
										}
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '>':
						{
							gboolean _tmp70_ = FALSE;
							type = VALA_GENIE_TOKEN_TYPE_OP_GT;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								_tmp70_ = self->priv->current[0] == '=';
							} else {
								_tmp70_ = FALSE;
							}
							if (_tmp70_) {
								type = VALA_GENIE_TOKEN_TYPE_OP_GE;
								self->priv->current++;
							}
							break;
						}
						case '!':
						{
							gboolean _tmp71_ = FALSE;
							type = VALA_GENIE_TOKEN_TYPE_OP_NEG;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								_tmp71_ = self->priv->current[0] == '=';
							} else {
								_tmp71_ = FALSE;
							}
							if (_tmp71_) {
								type = VALA_GENIE_TOKEN_TYPE_OP_NE;
								self->priv->current++;
							}
							break;
						}
						case '+':
						{
							type = VALA_GENIE_TOKEN_TYPE_PLUS;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								switch (self->priv->current[0]) {
									case '=':
									{
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD;
										self->priv->current++;
										break;
									}
									case '+':
									{
										type = VALA_GENIE_TOKEN_TYPE_OP_INC;
										self->priv->current++;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '-':
						{
							type = VALA_GENIE_TOKEN_TYPE_MINUS;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								switch (self->priv->current[0]) {
									case '=':
									{
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB;
										self->priv->current++;
										break;
									}
									case '-':
									{
										type = VALA_GENIE_TOKEN_TYPE_OP_DEC;
										self->priv->current++;
										break;
									}
									case '>':
									{
										type = VALA_GENIE_TOKEN_TYPE_OP_PTR;
										self->priv->current++;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '*':
						{
							gboolean _tmp72_ = FALSE;
							type = VALA_GENIE_TOKEN_TYPE_STAR;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								_tmp72_ = self->priv->current[0] == '=';
							} else {
								_tmp72_ = FALSE;
							}
							if (_tmp72_) {
								type = VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL;
								self->priv->current++;
							}
							break;
						}
						case '/':
						{
							switch (self->priv->last_token) {
								case VALA_GENIE_TOKEN_TYPE_ASSIGN:
								case VALA_GENIE_TOKEN_TYPE_COMMA:
								case VALA_GENIE_TOKEN_TYPE_MINUS:
								case VALA_GENIE_TOKEN_TYPE_OP_AND:
								case VALA_GENIE_TOKEN_TYPE_OP_DEC:
								case VALA_GENIE_TOKEN_TYPE_OP_EQ:
								case VALA_GENIE_TOKEN_TYPE_OP_GE:
								case VALA_GENIE_TOKEN_TYPE_OP_GT:
								case VALA_GENIE_TOKEN_TYPE_OP_INC:
								case VALA_GENIE_TOKEN_TYPE_OP_LE:
								case VALA_GENIE_TOKEN_TYPE_OP_LT:
								case VALA_GENIE_TOKEN_TYPE_OP_NE:
								case VALA_GENIE_TOKEN_TYPE_OP_NEG:
								case VALA_GENIE_TOKEN_TYPE_OP_OR:
								case VALA_GENIE_TOKEN_TYPE_OPEN_BRACE:
								case VALA_GENIE_TOKEN_TYPE_OPEN_PARENS:
								case VALA_GENIE_TOKEN_TYPE_PLUS:
								case VALA_GENIE_TOKEN_TYPE_RETURN:
								{
									type = VALA_GENIE_TOKEN_TYPE_OPEN_REGEX_LITERAL;
									_vala_array_add10 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_REGEX_LITERAL);
									self->priv->current++;
									break;
								}
								default:
								{
									gboolean _tmp73_ = FALSE;
									type = VALA_GENIE_TOKEN_TYPE_DIV;
									self->priv->current++;
									if (self->priv->current < self->priv->end) {
										_tmp73_ = self->priv->current[0] == '=';
									} else {
										_tmp73_ = FALSE;
									}
									if (_tmp73_) {
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV;
										self->priv->current++;
									}
									break;
								}
							}
							break;
						}
						case '%':
						{
							gboolean _tmp74_ = FALSE;
							type = VALA_GENIE_TOKEN_TYPE_PERCENT;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								_tmp74_ = self->priv->current[0] == '=';
							} else {
								_tmp74_ = FALSE;
							}
							if (_tmp74_) {
								type = VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT;
								self->priv->current++;
							}
							break;
						}
						case '\'':
						case '"':
						{
							gboolean _tmp96_ = FALSE;
							if (begin[0] == '\'') {
								type = VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL;
							} else {
								gboolean _tmp75_ = FALSE;
								gboolean _tmp76_ = FALSE;
								if (self->priv->current < (self->priv->end - 6)) {
									_tmp76_ = begin[1] == '"';
								} else {
									_tmp76_ = FALSE;
								}
								if (_tmp76_) {
									_tmp75_ = begin[2] == '"';
								} else {
									_tmp75_ = FALSE;
								}
								if (_tmp75_) {
									gboolean _tmp83_ = FALSE;
									gboolean _tmp84_ = FALSE;
									type = VALA_GENIE_TOKEN_TYPE_VERBATIM_STRING_LITERAL;
									token_length_in_chars = 6;
									self->priv->current = self->priv->current + 3;
									while (TRUE) {
										gboolean _tmp77_ = FALSE;
										gboolean _tmp78_ = FALSE;
										if (!(self->priv->current < (self->priv->end - 4))) {
											break;
										}
										if (self->priv->current[0] == '"') {
											_tmp78_ = self->priv->current[1] == '"';
										} else {
											_tmp78_ = FALSE;
										}
										if (_tmp78_) {
											_tmp77_ = self->priv->current[2] == '"';
										} else {
											_tmp77_ = FALSE;
										}
										if (_tmp77_) {
											break;
										} else {
											if (self->priv->current[0] == '\n') {
												self->priv->current++;
												self->priv->line++;
												self->priv->column = 1;
												token_length_in_chars = 3;
											} else {
												gunichar _tmp79_;
												gunichar u;
												_tmp79_ = g_utf8_get_char_validated ((const gchar*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
												u = _tmp79_;
												if (u != ((gunichar) (-1))) {
													gint _tmp80_;
													_tmp80_ = g_unichar_to_utf8 (u, NULL);
													self->priv->current = self->priv->current + _tmp80_;
													token_length_in_chars++;
												} else {
													ValaSourceReference* _tmp81_ = NULL;
													ValaSourceReference* _tmp82_;
													_tmp81_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
													_tmp82_ = _tmp81_;
													vala_report_error (_tmp82_, "invalid UTF-8 character");
													_vala_source_reference_unref0 (_tmp82_);
												}
											}
										}
									}
									if (self->priv->current[0] == '"') {
										_tmp84_ = self->priv->current[1] == '"';
									} else {
										_tmp84_ = FALSE;
									}
									if (_tmp84_) {
										_tmp83_ = self->priv->current[2] == '"';
									} else {
										_tmp83_ = FALSE;
									}
									if (_tmp83_) {
										self->priv->current = self->priv->current + 3;
									} else {
										ValaSourceReference* _tmp85_ = NULL;
										ValaSourceReference* _tmp86_;
										_tmp85_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
										_tmp86_ = _tmp85_;
										vala_report_error (_tmp86_, "syntax error, expected \"\"\"");
										_vala_source_reference_unref0 (_tmp86_);
									}
									break;
								} else {
									type = VALA_GENIE_TOKEN_TYPE_STRING_LITERAL;
								}
							}
							token_length_in_chars = 2;
							self->priv->current++;
							while (TRUE) {
								gboolean _tmp87_ = FALSE;
								if (self->priv->current < self->priv->end) {
									_tmp87_ = self->priv->current[0] != begin[0];
								} else {
									_tmp87_ = FALSE;
								}
								if (!_tmp87_) {
									break;
								}
								if (self->priv->current[0] == '\\') {
									self->priv->current++;
									token_length_in_chars++;
									if (self->priv->current >= self->priv->end) {
										break;
									}
									switch (self->priv->current[0]) {
										case '\'':
										case '"':
										case '\\':
										case '0':
										case 'b':
										case 'f':
										case 'n':
										case 'r':
										case 't':
										{
											self->priv->current++;
											token_length_in_chars++;
											break;
										}
										case 'x':
										{
											self->priv->current++;
											token_length_in_chars++;
											while (TRUE) {
												gboolean _tmp88_ = FALSE;
												if (self->priv->current < self->priv->end) {
													gboolean _tmp89_;
													_tmp89_ = g_ascii_isxdigit (self->priv->current[0]);
													_tmp88_ = _tmp89_;
												} else {
													_tmp88_ = FALSE;
												}
												if (!_tmp88_) {
													break;
												}
												self->priv->current++;
												token_length_in_chars++;
											}
											break;
										}
										default:
										{
											ValaSourceReference* _tmp90_ = NULL;
											ValaSourceReference* _tmp91_;
											_tmp90_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
											_tmp91_ = _tmp90_;
											vala_report_error (_tmp91_, "invalid escape sequence");
											_vala_source_reference_unref0 (_tmp91_);
											break;
										}
									}
								} else {
									if (self->priv->current[0] == '\n') {
										break;
									} else {
										gunichar _tmp92_;
										gunichar u;
										_tmp92_ = g_utf8_get_char_validated ((const gchar*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
										u = _tmp92_;
										if (u != ((gunichar) (-1))) {
											gint _tmp93_;
											_tmp93_ = g_unichar_to_utf8 (u, NULL);
											self->priv->current = self->priv->current + _tmp93_;
											token_length_in_chars++;
										} else {
											ValaSourceReference* _tmp94_ = NULL;
											ValaSourceReference* _tmp95_;
											self->priv->current++;
											_tmp94_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
											_tmp95_ = _tmp94_;
											vala_report_error (_tmp95_, "invalid UTF-8 character");
											_vala_source_reference_unref0 (_tmp95_);
										}
									}
								}
							}
							if (self->priv->current < self->priv->end) {
								_tmp96_ = self->priv->current[0] != '\n';
							} else {
								_tmp96_ = FALSE;
							}
							if (_tmp96_) {
								self->priv->current++;
							} else {
								ValaSourceReference* _tmp97_ = NULL;
								ValaSourceReference* _tmp98_;
								gchar* _tmp99_ = NULL;
								gchar* _tmp100_;
								_tmp97_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
								_tmp98_ = _tmp97_;
								_tmp99_ = g_strdup_printf ("syntax error, expected %c", (gint) begin[0]);
								_tmp100_ = _tmp99_;
								vala_report_error (_tmp98_, _tmp100_);
								_g_free0 (_tmp100_);
								_vala_source_reference_unref0 (_tmp98_);
							}
							break;
						}
						default:
						{
							gunichar _tmp101_;
							gunichar u;
							ValaSourceLocation _tmp107_ = {0};
							ValaSourceLocation _tmp108_ = {0};
							ValaGenieTokenType _tmp109_;
							_tmp101_ = g_utf8_get_char_validated ((const gchar*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
							u = _tmp101_;
							if (u != ((gunichar) (-1))) {
								gint _tmp102_;
								ValaSourceReference* _tmp103_ = NULL;
								ValaSourceReference* _tmp104_;
								_tmp102_ = g_unichar_to_utf8 (u, NULL);
								self->priv->current = self->priv->current + _tmp102_;
								_tmp103_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
								_tmp104_ = _tmp103_;
								vala_report_error (_tmp104_, "syntax error, unexpected character");
								_vala_source_reference_unref0 (_tmp104_);
							} else {
								ValaSourceReference* _tmp105_ = NULL;
								ValaSourceReference* _tmp106_;
								self->priv->current++;
								_tmp105_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
								_tmp106_ = _tmp105_;
								vala_report_error (_tmp106_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp106_);
							}
							self->priv->column++;
							self->priv->last_token = VALA_GENIE_TOKEN_TYPE_STRING_LITERAL;
							_tmp109_ = vala_genie_scanner_read_token (self, &_tmp107_, &_tmp108_);
							_token_begin = _tmp107_;
							_token_end = _tmp108_;
							result = _tmp109_;
							if (token_begin) {
								*token_begin = _token_begin;
							}
							if (token_end) {
								*token_end = _token_end;
							}
							return result;
						}
					}
				}
			}
		}
	}
	if (token_length_in_chars < 0) {
		self->priv->column = self->priv->column + ((gint) (self->priv->current - begin));
	} else {
		self->priv->column = self->priv->column + token_length_in_chars;
	}
	_token_end.pos = self->priv->current;
	_token_end.line = self->priv->line;
	_token_end.column = self->priv->column - 1;
	self->priv->last_token = type;
	result = type;
	if (token_begin) {
		*token_begin = _token_begin;
	}
	if (token_end) {
		*token_end = _token_end;
	}
	return result;
}


static gint vala_genie_scanner_count_tabs (ValaGenieScanner* self) {
	gint result = 0;
	gint tab_count;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	tab_count = 0;
	if (self->priv->_indent_spaces == 0) {
		while (TRUE) {
			gboolean _tmp0_ = FALSE;
			if (self->priv->current < self->priv->end) {
				_tmp0_ = self->priv->current[0] == '\t';
			} else {
				_tmp0_ = FALSE;
			}
			if (!_tmp0_) {
				break;
			}
			self->priv->current++;
			self->priv->column++;
			tab_count++;
		}
	} else {
		gint space_count;
		space_count = 0;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			if (self->priv->current < self->priv->end) {
				_tmp1_ = self->priv->current[0] == ' ';
			} else {
				_tmp1_ = FALSE;
			}
			if (!_tmp1_) {
				break;
			}
			self->priv->current++;
			self->priv->column++;
			space_count++;
		}
		tab_count = space_count / self->priv->_indent_spaces;
	}
	vala_genie_scanner_space (self);
	if (self->priv->current < self->priv->end) {
		_tmp2_ = self->priv->current[0] == '\n';
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = -1;
		return result;
	}
	result = tab_count;
	return result;
}


static gboolean vala_genie_scanner_matches (ValaGenieScanner* self, gchar* begin, const gchar* keyword) {
	gboolean result = FALSE;
	gchar* keyword_array;
	gint _tmp0_;
	glong len;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (keyword != NULL, FALSE);
	keyword_array = (gchar*) keyword;
	_tmp0_ = strlen (keyword);
	len = (glong) _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				if (!(i < len)) {
					break;
				}
				if (begin[i] != keyword_array[i]) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean vala_genie_scanner_whitespace (ValaGenieScanner* self) {
	gboolean result = FALSE;
	gboolean found;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (self->priv->current < self->priv->end) {
			gboolean _tmp2_;
			_tmp2_ = g_ascii_isspace (self->priv->current[0]);
			_tmp1_ = _tmp2_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = self->priv->current[0] != '\n';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		found = TRUE;
		self->priv->current++;
		self->priv->column++;
	}
	if (self->priv->column == 1) {
		_tmp4_ = self->priv->current < self->priv->end;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = self->priv->current[0] == '#';
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		vala_genie_scanner_pp_directive (self);
		result = TRUE;
		return result;
	}
	result = found;
	return result;
}


static inline gboolean vala_genie_scanner_newline (ValaGenieScanner* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->current[0] == '\n') {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean vala_genie_scanner_skip_newlines (ValaGenieScanner* self) {
	gboolean result = FALSE;
	gboolean new_lines;
	g_return_val_if_fail (self != NULL, FALSE);
	new_lines = FALSE;
	while (TRUE) {
		gboolean _tmp0_;
		_tmp0_ = vala_genie_scanner_newline (self);
		if (!_tmp0_) {
			break;
		}
		self->priv->current++;
		self->priv->line++;
		self->priv->column = 1;
		self->priv->current_indent_level = 0;
		new_lines = TRUE;
	}
	result = new_lines;
	return result;
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp1_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp1_;
	return result;
}


static gboolean vala_genie_scanner_comment (ValaGenieScanner* self, gboolean file_comment) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->current > (self->priv->end - 2)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->current[0] != '/';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (self->priv->current[1] != '/') {
			_tmp2_ = self->priv->current[1] != '*';
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (self->priv->current[1] == '/') {
		ValaSourceReference* source_reference;
		gboolean _tmp6_ = FALSE;
		source_reference = NULL;
		if (file_comment) {
			ValaSourceReference* _tmp3_ = NULL;
			ValaSourceReference* _tmp4_;
			_tmp3_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
			_tmp4_ = _tmp3_;
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp4_;
		}
		self->priv->current = self->priv->current + 2;
		while (TRUE) {
			gboolean _tmp5_ = FALSE;
			if (self->priv->current < self->priv->end) {
				_tmp5_ = self->priv->current[0] != '\n';
			} else {
				_tmp5_ = FALSE;
			}
			if (!_tmp5_) {
				break;
			}
			self->priv->current++;
		}
		if (self->priv->current[0] == '\n') {
			_tmp6_ = self->priv->last_token == VALA_GENIE_TOKEN_TYPE_EOL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			self->priv->current++;
			self->priv->line++;
			self->priv->column = 1;
			self->priv->current_indent_level = 0;
		}
		if (source_reference != NULL) {
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			_tmp7_ = string_substring ((const gchar*) self->priv->begin, (glong) 0, (glong) (self->priv->current - self->priv->begin));
			_tmp8_ = _tmp7_;
			vala_genie_scanner_push_comment (self, _tmp8_, source_reference, file_comment);
			_g_free0 (_tmp8_);
		}
		_vala_source_reference_unref0 (source_reference);
	} else {
		ValaSourceReference* source_reference;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gchar* begin;
		source_reference = NULL;
		if (file_comment) {
			_tmp9_ = self->priv->current[2] == '*';
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			result = FALSE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		if (self->priv->current[2] == '*') {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = file_comment;
		}
		if (_tmp10_) {
			ValaSourceReference* _tmp11_ = NULL;
			ValaSourceReference* _tmp12_;
			_tmp11_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
			_tmp12_ = _tmp11_;
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp12_;
		}
		self->priv->current = self->priv->current + 2;
		begin = self->priv->current;
		while (TRUE) {
			gboolean _tmp13_ = FALSE;
			if (self->priv->current < (self->priv->end - 1)) {
				gboolean _tmp14_ = FALSE;
				if (self->priv->current[0] != '*') {
					_tmp14_ = TRUE;
				} else {
					_tmp14_ = self->priv->current[1] != '/';
				}
				_tmp13_ = _tmp14_;
			} else {
				_tmp13_ = FALSE;
			}
			if (!_tmp13_) {
				break;
			}
			if (self->priv->current[0] == '\n') {
				self->priv->line++;
				self->priv->column = 0;
			}
			self->priv->current++;
			self->priv->column++;
		}
		if (self->priv->current == (self->priv->end - 1)) {
			ValaSourceReference* _tmp15_ = NULL;
			ValaSourceReference* _tmp16_;
			_tmp15_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
			_tmp16_ = _tmp15_;
			vala_report_error (_tmp16_, "syntax error, expected */");
			_vala_source_reference_unref0 (_tmp16_);
			result = TRUE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		if (source_reference != NULL) {
			gchar* _tmp17_ = NULL;
			gchar* comment;
			_tmp17_ = string_substring ((const gchar*) begin, (glong) 0, (glong) (self->priv->current - begin));
			comment = _tmp17_;
			vala_genie_scanner_push_comment (self, comment, source_reference, file_comment);
			_g_free0 (comment);
		}
		self->priv->current = self->priv->current + 2;
		self->priv->column = self->priv->column + 2;
		_vala_source_reference_unref0 (source_reference);
	}
	result = TRUE;
	return result;
}


static gboolean vala_genie_scanner_skip_tabs (ValaGenieScanner* self) {
	gboolean result = FALSE;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (self->priv->current < self->priv->end) {
			_tmp0_ = self->priv->current[0] == '\t';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		self->priv->current++;
		self->priv->column++;
		found = TRUE;
	}
	result = found;
	return result;
}


static void vala_genie_scanner_skip_space_tabs (ValaGenieScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_;
		_tmp2_ = vala_genie_scanner_whitespace (self);
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp3_;
			_tmp3_ = vala_genie_scanner_skip_tabs (self);
			_tmp1_ = _tmp3_;
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp4_;
			_tmp4_ = vala_genie_scanner_comment (self, FALSE);
			_tmp0_ = _tmp4_;
		}
		if (!_tmp0_) {
			break;
		}
	}
}


static void vala_genie_scanner_space (ValaGenieScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		_tmp1_ = vala_genie_scanner_whitespace (self);
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_;
			_tmp2_ = vala_genie_scanner_comment (self, FALSE);
			_tmp0_ = _tmp2_;
		}
		if (!_tmp0_) {
			break;
		}
	}
}


void vala_genie_scanner_parse_file_comments (ValaGenieScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		_tmp1_ = vala_genie_scanner_whitespace (self);
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_;
			_tmp2_ = vala_genie_scanner_comment (self, TRUE);
			_tmp0_ = _tmp2_;
		}
		if (!_tmp0_) {
			break;
		}
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static void vala_genie_scanner_push_comment (ValaGenieScanner* self, const gchar* comment_item, ValaSourceReference* source_reference, gboolean file_comment) {
	gchar _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment_item != NULL);
	g_return_if_fail (source_reference != NULL);
	_tmp0_ = string_get (comment_item, (glong) 0);
	if (_tmp0_ == '*') {
		ValaComment* _tmp1_ = NULL;
		ValaComment* _tmp2_;
		_tmp1_ = vala_comment_new (comment_item, source_reference);
		_tmp2_ = _tmp1_;
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = _tmp2_;
	}
	if (file_comment) {
		ValaComment* _tmp3_ = NULL;
		ValaComment* _tmp4_;
		ValaComment* _tmp5_;
		_tmp3_ = vala_comment_new (comment_item, source_reference);
		_tmp4_ = _tmp3_;
		vala_source_file_add_comment (self->priv->_source_file, _tmp4_);
		_vala_comment_unref0 (_tmp4_);
		_tmp5_ = NULL;
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = _tmp5_;
	}
}


/**
 * Clears and returns the content of the comment stack.
 *
 * @return saved comment
 */
static gpointer _vala_comment_ref0 (gpointer self) {
	return self ? vala_comment_ref (self) : NULL;
}


ValaComment* vala_genie_scanner_pop_comment (ValaGenieScanner* self) {
	ValaComment* result = NULL;
	ValaComment* _tmp0_;
	ValaComment* comment;
	ValaComment* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_comment == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = _vala_comment_ref0 (self->priv->_comment);
	comment = _tmp0_;
	_tmp1_ = NULL;
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->_comment = _tmp1_;
	result = comment;
	return result;
}


static gboolean vala_genie_scanner_pp_whitespace (ValaGenieScanner* self) {
	gboolean result = FALSE;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (self->priv->current < self->priv->end) {
			gboolean _tmp2_;
			_tmp2_ = g_ascii_isspace (self->priv->current[0]);
			_tmp1_ = _tmp2_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = self->priv->current[0] != '\n';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		found = TRUE;
		self->priv->current++;
		self->priv->column++;
	}
	result = found;
	return result;
}


static void vala_genie_scanner_pp_directive (ValaGenieScanner* self) {
	gchar* begin;
	gint len;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	self->priv->current++;
	self->priv->column++;
	vala_genie_scanner_pp_whitespace (self);
	begin = self->priv->current;
	len = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (self->priv->current < self->priv->end) {
			gboolean _tmp1_;
			_tmp1_ = g_ascii_isalnum (self->priv->current[0]);
			_tmp0_ = _tmp1_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		self->priv->current++;
		self->priv->column++;
		len++;
	}
	if (len == 2) {
		gboolean _tmp3_;
		_tmp3_ = vala_genie_scanner_matches (self, begin, "if");
		_tmp2_ = _tmp3_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		vala_genie_scanner_parse_pp_if (self);
	} else {
		gboolean _tmp4_ = FALSE;
		if (len == 4) {
			gboolean _tmp5_;
			_tmp5_ = vala_genie_scanner_matches (self, begin, "elif");
			_tmp4_ = _tmp5_;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			vala_genie_scanner_parse_pp_elif (self);
		} else {
			gboolean _tmp6_ = FALSE;
			if (len == 4) {
				gboolean _tmp7_;
				_tmp7_ = vala_genie_scanner_matches (self, begin, "else");
				_tmp6_ = _tmp7_;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				vala_genie_scanner_parse_pp_else (self);
			} else {
				gboolean _tmp8_ = FALSE;
				if (len == 5) {
					gboolean _tmp9_;
					_tmp9_ = vala_genie_scanner_matches (self, begin, "endif");
					_tmp8_ = _tmp9_;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					vala_genie_scanner_parse_pp_endif (self);
				} else {
					ValaSourceReference* _tmp10_ = NULL;
					ValaSourceReference* _tmp11_;
					_tmp10_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column - len, self->priv->line, self->priv->column);
					_tmp11_ = _tmp10_;
					vala_report_error (_tmp11_, "syntax error, invalid preprocessing directive");
					_vala_source_reference_unref0 (_tmp11_);
				}
			}
		}
	}
	if (self->priv->conditional_stack_length1 > 0) {
		_tmp12_ = self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].skip_section;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		gboolean bol;
		bol = FALSE;
		while (TRUE) {
			gboolean _tmp13_ = FALSE;
			if (!(self->priv->current < self->priv->end)) {
				break;
			}
			if (bol) {
				_tmp13_ = self->priv->current[0] == '#';
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				self->priv->current = self->priv->current - (self->priv->column - 1);
				self->priv->column = 1;
				return;
			}
			if (self->priv->current[0] == '\n') {
				self->priv->line++;
				self->priv->column = 0;
				bol = TRUE;
			} else {
				gboolean _tmp14_;
				_tmp14_ = g_ascii_isspace (self->priv->current[0]);
				if (!_tmp14_) {
					bol = FALSE;
				}
			}
			self->priv->current++;
			self->priv->column++;
		}
	}
}


static void vala_genie_scanner_pp_eol (ValaGenieScanner* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_whitespace (self);
	if (self->priv->current >= self->priv->end) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->current[0] != '\n';
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp1_ = NULL;
		ValaSourceReference* _tmp2_;
		_tmp1_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
		_tmp2_ = _tmp1_;
		vala_report_error (_tmp2_, "syntax error, expected newline");
		_vala_source_reference_unref0 (_tmp2_);
	}
}


static void _vala_array_add11 (ValaGenieScannerConditional** array, int* length, int* size, const ValaGenieScannerConditional* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerConditional, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void vala_genie_scanner_parse_pp_if (ValaGenieScanner* self) {
	gboolean _tmp0_;
	gboolean condition;
	ValaGenieScannerConditional _tmp1_ = {0};
	ValaGenieScannerConditional _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_whitespace (self);
	_tmp0_ = vala_genie_scanner_parse_pp_expression (self);
	condition = _tmp0_;
	vala_genie_scanner_pp_eol (self);
	memset (&_tmp1_, 0, sizeof (ValaGenieScannerConditional));
	_tmp2_ = _tmp1_;
	_vala_array_add11 (&self->priv->conditional_stack, &self->priv->conditional_stack_length1, &self->priv->_conditional_stack_size_, &_tmp2_);
	if (condition) {
		gboolean _tmp4_ = FALSE;
		if (self->priv->conditional_stack_length1 == 1) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = !self->priv->conditional_stack[self->priv->conditional_stack_length1 - 2].skip_section;
		}
		_tmp3_ = _tmp4_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].matched = TRUE;
	} else {
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].skip_section = TRUE;
	}
}


static void vala_genie_scanner_parse_pp_elif (ValaGenieScanner* self) {
	gboolean _tmp0_;
	gboolean condition;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_whitespace (self);
	_tmp0_ = vala_genie_scanner_parse_pp_expression (self);
	condition = _tmp0_;
	vala_genie_scanner_pp_eol (self);
	if (self->priv->conditional_stack_length1 == 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].else_found;
	}
	if (_tmp1_) {
		ValaSourceReference* _tmp2_ = NULL;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "syntax error, unexpected #elif");
		_vala_source_reference_unref0 (_tmp3_);
		return;
	}
	if (condition) {
		_tmp5_ = !self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].matched;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gboolean _tmp6_ = FALSE;
		if (self->priv->conditional_stack_length1 == 1) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = !self->priv->conditional_stack[self->priv->conditional_stack_length1 - 2].skip_section;
		}
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].matched = TRUE;
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].skip_section = FALSE;
	} else {
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].skip_section = TRUE;
	}
}


static void vala_genie_scanner_parse_pp_else (ValaGenieScanner* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_eol (self);
	if (self->priv->conditional_stack_length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].else_found;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp1_ = NULL;
		ValaSourceReference* _tmp2_;
		_tmp1_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
		_tmp2_ = _tmp1_;
		vala_report_error (_tmp2_, "syntax error, unexpected #else");
		_vala_source_reference_unref0 (_tmp2_);
		return;
	}
	if (!self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].matched) {
		gboolean _tmp4_ = FALSE;
		if (self->priv->conditional_stack_length1 == 1) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = !self->priv->conditional_stack[self->priv->conditional_stack_length1 - 2].skip_section;
		}
		_tmp3_ = _tmp4_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].matched = TRUE;
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].skip_section = FALSE;
	} else {
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].skip_section = TRUE;
	}
}


static void vala_genie_scanner_parse_pp_endif (ValaGenieScanner* self) {
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_eol (self);
	if (self->priv->conditional_stack_length1 == 0) {
		ValaSourceReference* _tmp0_ = NULL;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
		_tmp1_ = _tmp0_;
		vala_report_error (_tmp1_, "syntax error, unexpected #endif");
		_vala_source_reference_unref0 (_tmp1_);
		return;
	}
	self->priv->conditional_stack_length1--;
}


static gboolean vala_genie_scanner_parse_pp_symbol (ValaGenieScanner* self) {
	gboolean result = FALSE;
	gint len;
	gchar* _tmp4_ = NULL;
	gchar* identifier;
	gboolean defined = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	len = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (self->priv->current < self->priv->end) {
			gboolean _tmp1_;
			_tmp1_ = vala_genie_scanner_is_ident_char (self, self->priv->current[0]);
			_tmp0_ = _tmp1_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		self->priv->current++;
		self->priv->column++;
		len++;
	}
	if (len == 0) {
		ValaSourceReference* _tmp2_ = NULL;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp3_);
		result = FALSE;
		return result;
	}
	_tmp4_ = string_substring ((const gchar*) (self->priv->current - len), (glong) 0, (glong) len);
	identifier = _tmp4_;
	if (g_strcmp0 (identifier, "true") == 0) {
		defined = TRUE;
	} else {
		if (g_strcmp0 (identifier, "false") == 0) {
			defined = FALSE;
		} else {
			ValaCodeContext* _tmp5_ = NULL;
			gboolean _tmp6_;
			_tmp5_ = vala_source_file_get_context (self->priv->_source_file);
			_tmp6_ = vala_code_context_is_defined (_tmp5_, identifier);
			defined = _tmp6_;
		}
	}
	result = defined;
	_g_free0 (identifier);
	return result;
}


static gboolean vala_genie_scanner_parse_pp_primary_expression (ValaGenieScanner* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->current >= self->priv->end) {
		ValaSourceReference* _tmp0_ = NULL;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
		_tmp1_ = _tmp0_;
		vala_report_error (_tmp1_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp1_);
	} else {
		gboolean _tmp2_;
		_tmp2_ = vala_genie_scanner_is_ident_char (self, self->priv->current[0]);
		if (_tmp2_) {
			gboolean _tmp3_;
			_tmp3_ = vala_genie_scanner_parse_pp_symbol (self);
			result = _tmp3_;
			return result;
		} else {
			if (self->priv->current[0] == '(') {
				gboolean _tmp4_;
				gboolean _result_;
				gboolean _tmp5_ = FALSE;
				self->priv->current++;
				self->priv->column++;
				vala_genie_scanner_pp_whitespace (self);
				_tmp4_ = vala_genie_scanner_parse_pp_expression (self);
				_result_ = _tmp4_;
				vala_genie_scanner_pp_whitespace (self);
				if (self->priv->current < self->priv->end) {
					_tmp5_ = self->priv->current[0] == ')';
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					self->priv->current++;
					self->priv->column++;
				} else {
					ValaSourceReference* _tmp6_ = NULL;
					ValaSourceReference* _tmp7_;
					_tmp6_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
					_tmp7_ = _tmp6_;
					vala_report_error (_tmp7_, "syntax error, expected `)'");
					_vala_source_reference_unref0 (_tmp7_);
				}
				result = _result_;
				return result;
			} else {
				ValaSourceReference* _tmp8_ = NULL;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "syntax error, expected identifier");
				_vala_source_reference_unref0 (_tmp9_);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean vala_genie_scanner_parse_pp_unary_expression (ValaGenieScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->current < self->priv->end) {
		_tmp0_ = self->priv->current[0] == '!';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp1_;
		self->priv->current++;
		self->priv->column++;
		vala_genie_scanner_pp_whitespace (self);
		_tmp1_ = vala_genie_scanner_parse_pp_unary_expression (self);
		result = !_tmp1_;
		return result;
	}
	_tmp2_ = vala_genie_scanner_parse_pp_primary_expression (self);
	result = _tmp2_;
	return result;
}


static gboolean vala_genie_scanner_parse_pp_equality_expression (ValaGenieScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean left;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_genie_scanner_parse_pp_unary_expression (self);
	left = _tmp0_;
	vala_genie_scanner_pp_whitespace (self);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		if (self->priv->current < (self->priv->end - 1)) {
			_tmp2_ = self->priv->current[0] == '=';
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = self->priv->current[1] == '=';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gboolean _tmp3_;
			gboolean right;
			self->priv->current = self->priv->current + 2;
			self->priv->column = self->priv->column + 2;
			vala_genie_scanner_pp_whitespace (self);
			_tmp3_ = vala_genie_scanner_parse_pp_unary_expression (self);
			right = _tmp3_;
			left = left == right;
		} else {
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			if (self->priv->current < (self->priv->end - 1)) {
				_tmp5_ = self->priv->current[0] == '!';
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				_tmp4_ = self->priv->current[1] == '=';
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				gboolean _tmp6_;
				gboolean right;
				self->priv->current = self->priv->current + 2;
				self->priv->column = self->priv->column + 2;
				vala_genie_scanner_pp_whitespace (self);
				_tmp6_ = vala_genie_scanner_parse_pp_unary_expression (self);
				right = _tmp6_;
				left = left != right;
			} else {
				break;
			}
		}
	}
	result = left;
	return result;
}


static gboolean vala_genie_scanner_parse_pp_and_expression (ValaGenieScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean left;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_genie_scanner_parse_pp_equality_expression (self);
	left = _tmp0_;
	vala_genie_scanner_pp_whitespace (self);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		gboolean right;
		gboolean _tmp4_ = FALSE;
		if (self->priv->current < (self->priv->end - 1)) {
			_tmp2_ = self->priv->current[0] == '&';
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = self->priv->current[1] == '&';
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		self->priv->current = self->priv->current + 2;
		self->priv->column = self->priv->column + 2;
		vala_genie_scanner_pp_whitespace (self);
		_tmp3_ = vala_genie_scanner_parse_pp_equality_expression (self);
		right = _tmp3_;
		if (left) {
			_tmp4_ = right;
		} else {
			_tmp4_ = FALSE;
		}
		left = _tmp4_;
	}
	result = left;
	return result;
}


static gboolean vala_genie_scanner_parse_pp_or_expression (ValaGenieScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean left;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_genie_scanner_parse_pp_and_expression (self);
	left = _tmp0_;
	vala_genie_scanner_pp_whitespace (self);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		gboolean right;
		gboolean _tmp4_ = FALSE;
		if (self->priv->current < (self->priv->end - 1)) {
			_tmp2_ = self->priv->current[0] == '|';
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = self->priv->current[1] == '|';
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		self->priv->current = self->priv->current + 2;
		self->priv->column = self->priv->column + 2;
		vala_genie_scanner_pp_whitespace (self);
		_tmp3_ = vala_genie_scanner_parse_pp_and_expression (self);
		right = _tmp3_;
		if (left) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = right;
		}
		left = _tmp4_;
	}
	result = left;
	return result;
}


static gboolean vala_genie_scanner_parse_pp_expression (ValaGenieScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_genie_scanner_parse_pp_or_expression (self);
	result = _tmp0_;
	return result;
}


ValaSourceFile* vala_genie_scanner_get_source_file (ValaGenieScanner* self) {
	ValaSourceFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_source_file;
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static void vala_genie_scanner_set_source_file (ValaGenieScanner* self, ValaSourceFile* value) {
	ValaSourceFile* _tmp0_;
	ValaSourceFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_source_file_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_source_file_unref0 (self->priv->_source_file);
	self->priv->_source_file = _tmp1_;
}


gint vala_genie_scanner_get_indent_spaces (ValaGenieScanner* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_indent_spaces;
	return result;
}


void vala_genie_scanner_set_indent_spaces (ValaGenieScanner* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_indent_spaces = value;
}


static ValaGenieScannerConditional* vala_genie_scanner_conditional_dup (const ValaGenieScannerConditional* self) {
	ValaGenieScannerConditional* dup;
	dup = g_new0 (ValaGenieScannerConditional, 1);
	memcpy (dup, self, sizeof (ValaGenieScannerConditional));
	return dup;
}


static void vala_genie_scanner_conditional_free (ValaGenieScannerConditional* self) {
	g_free (self);
}


static GType vala_genie_scanner_conditional_get_type (void) {
	static volatile gsize vala_genie_scanner_conditional_type_id__volatile = 0;
	if (g_once_init_enter (&vala_genie_scanner_conditional_type_id__volatile)) {
		GType vala_genie_scanner_conditional_type_id;
		vala_genie_scanner_conditional_type_id = g_boxed_type_register_static ("ValaGenieScannerConditional", (GBoxedCopyFunc) vala_genie_scanner_conditional_dup, (GBoxedFreeFunc) vala_genie_scanner_conditional_free);
		g_once_init_leave (&vala_genie_scanner_conditional_type_id__volatile, vala_genie_scanner_conditional_type_id);
	}
	return vala_genie_scanner_conditional_type_id__volatile;
}


static void vala_genie_value_scanner_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_genie_value_scanner_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_genie_scanner_unref (value->data[0].v_pointer);
	}
}


static void vala_genie_value_scanner_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_genie_scanner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_genie_value_scanner_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_genie_value_scanner_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaGenieScanner* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_genie_scanner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_genie_value_scanner_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaGenieScanner** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_genie_scanner_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_genie_param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaGenieParamSpecScanner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GENIE_TYPE_SCANNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_genie_value_get_scanner (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GENIE_TYPE_SCANNER), NULL);
	return value->data[0].v_pointer;
}


void vala_genie_value_set_scanner (GValue* value, gpointer v_object) {
	ValaGenieScanner* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GENIE_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GENIE_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_genie_scanner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_genie_scanner_unref (old);
	}
}


void vala_genie_value_take_scanner (GValue* value, gpointer v_object) {
	ValaGenieScanner* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GENIE_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GENIE_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_genie_scanner_unref (old);
	}
}


static void vala_genie_scanner_class_init (ValaGenieScannerClass * klass) {
	vala_genie_scanner_parent_class = g_type_class_peek_parent (klass);
	VALA_GENIE_SCANNER_CLASS (klass)->finalize = vala_genie_scanner_finalize;
	g_type_class_add_private (klass, sizeof (ValaGenieScannerPrivate));
}


static void vala_genie_scanner_instance_init (ValaGenieScanner * self) {
	self->priv = VALA_GENIE_SCANNER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_genie_scanner_finalize (ValaGenieScanner* obj) {
	ValaGenieScanner * self;
	self = VALA_GENIE_SCANNER (obj);
	_vala_source_file_unref0 (self->priv->_source_file);
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
}


/**
 * Lexical scanner for Genie source files.
 */
GType vala_genie_scanner_get_type (void) {
	static volatile gsize vala_genie_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&vala_genie_scanner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_genie_value_scanner_init, vala_genie_value_scanner_free_value, vala_genie_value_scanner_copy_value, vala_genie_value_scanner_peek_pointer, "p", vala_genie_value_scanner_collect_value, "p", vala_genie_value_scanner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGenieScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_genie_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGenieScanner), 0, (GInstanceInitFunc) vala_genie_scanner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_genie_scanner_type_id;
		vala_genie_scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGenieScanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_genie_scanner_type_id__volatile, vala_genie_scanner_type_id);
	}
	return vala_genie_scanner_type_id__volatile;
}


gpointer vala_genie_scanner_ref (gpointer instance) {
	ValaGenieScanner* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_genie_scanner_unref (gpointer instance) {
	ValaGenieScanner* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GENIE_SCANNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



