/* valasourcefile.c generated by valac, the Vala compiler
 * generated from valasourcefile.vala, do not modify */

/* valasourcefile.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;
typedef struct _ValaSourceFilePrivate ValaSourceFilePrivate;

#define VALA_TYPE_SOURCE_FILE_TYPE (vala_source_file_type_get_type ())

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;

#define VALA_TYPE_USING_DIRECTIVE (vala_using_directive_get_type ())
#define VALA_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirective))
#define VALA_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))
#define VALA_IS_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_USING_DIRECTIVE))
#define VALA_IS_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_USING_DIRECTIVE))
#define VALA_USING_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))

typedef struct _ValaUsingDirective ValaUsingDirective;
typedef struct _ValaUsingDirectiveClass ValaUsingDirectiveClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_mapped_file_free0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_free (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
typedef struct _ValaParamSpecSourceFile ValaParamSpecSourceFile;

struct _ValaSourceFile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaSourceFilePrivate * priv;
};

struct _ValaSourceFileClass {
	GTypeClass parent_class;
	void (*finalize) (ValaSourceFile *self);
};

typedef enum  {
	VALA_SOURCE_FILE_TYPE_NONE,
	VALA_SOURCE_FILE_TYPE_SOURCE,
	VALA_SOURCE_FILE_TYPE_PACKAGE,
	VALA_SOURCE_FILE_TYPE_FAST
} ValaSourceFileType;

struct _ValaSourceFilePrivate {
	gchar* _filename;
	ValaSourceFileType _file_type;
	gchar* _gir_namespace;
	gchar* _gir_version;
	ValaCodeContext* _context;
	gboolean _used;
	ValaArrayList* comments;
	ValaList* _current_using_directives;
	ValaList* nodes;
	gchar* _relative_filename;
	gchar* csource_filename;
	gchar* cinclude_filename;
	ValaArrayList* source_array;
	GMappedFile* mapped_file;
	gchar* _content;
};

struct _ValaParamSpecSourceFile {
	GParamSpec parent_instance;
};


static gpointer vala_source_file_parent_class = NULL;

gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
GType vala_source_file_type_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
GType vala_using_directive_get_type (void) G_GNUC_CONST;
#define VALA_SOURCE_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SOURCE_FILE, ValaSourceFilePrivate))
enum  {
	VALA_SOURCE_FILE_DUMMY_PROPERTY
};
ValaSourceFile* vala_source_file_new (ValaCodeContext* context, ValaSourceFileType type, const gchar* filename, const gchar* content);
ValaSourceFile* vala_source_file_construct (GType object_type, ValaCodeContext* context, ValaSourceFileType type, const gchar* filename, const gchar* content);
void vala_source_file_set_context (ValaSourceFile* self, ValaCodeContext* value);
void vala_source_file_set_file_type (ValaSourceFile* self, ValaSourceFileType value);
void vala_source_file_set_filename (ValaSourceFile* self, const gchar* value);
void vala_source_file_set_content (ValaSourceFile* self, const gchar* value);
void vala_source_file_add_comment (ValaSourceFile* self, ValaComment* comment);
ValaList* vala_source_file_get_comments (ValaSourceFile* self);
void vala_source_file_add_using_directive (ValaSourceFile* self, ValaUsingDirective* ns);
ValaList* vala_source_file_get_current_using_directives (ValaSourceFile* self);
void vala_source_file_set_current_using_directives (ValaSourceFile* self, ValaList* value);
void vala_source_file_add_node (ValaSourceFile* self, ValaCodeNode* node);
void vala_source_file_remove_node (ValaSourceFile* self, ValaCodeNode* node);
ValaList* vala_source_file_get_nodes (ValaSourceFile* self);
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
void vala_source_file_accept (ValaSourceFile* self, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_source_file (ValaCodeVisitor* self, ValaSourceFile* source_file);
void vala_source_file_accept_children (ValaSourceFile* self, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
static gchar* vala_source_file_get_subdir (ValaSourceFile* self);
ValaCodeContext* vala_source_file_get_context (ValaSourceFile* self);
const gchar* vala_code_context_get_basedir (ValaCodeContext* self);
const gchar* vala_source_file_get_filename (ValaSourceFile* self);
static gchar* vala_source_file_get_destination_directory (ValaSourceFile* self);
const gchar* vala_code_context_get_directory (ValaCodeContext* self);
static gchar* vala_source_file_get_basename (ValaSourceFile* self);
gchar* vala_source_file_get_relative_filename (ValaSourceFile* self);
gchar* vala_source_file_get_csource_filename (ValaSourceFile* self);
gboolean vala_code_context_get_run_output (ValaCodeContext* self);
const gchar* vala_code_context_get_output (ValaCodeContext* self);
gboolean vala_code_context_get_ccode_only (ValaCodeContext* self);
gboolean vala_code_context_get_save_csources (ValaCodeContext* self);
gchar* vala_source_file_get_cinclude_filename (ValaSourceFile* self);
const gchar* vala_code_context_get_header_filename (ValaCodeContext* self);
const gchar* vala_code_context_get_includedir (ValaCodeContext* self);
gchar* vala_source_file_get_source_line (ValaSourceFile* self, gint lineno);
const gchar* vala_source_file_get_content (ValaSourceFile* self);
static void vala_source_file_read_source_lines (ValaSourceFile* self, const gchar* cont);
static void vala_source_file_read_source_file (ValaSourceFile* self);
gchar* vala_source_file_get_mapped_contents (ValaSourceFile* self);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
void vala_report_error (ValaSourceReference* source, const gchar* message);
gsize vala_source_file_get_mapped_length (ValaSourceFile* self);
gboolean vala_source_file_check (ValaSourceFile* self, ValaCodeContext* context);
gboolean vala_code_node_check (ValaCodeNode* self, ValaCodeContext* context);
void vala_source_file_set_relative_filename (ValaSourceFile* self, const gchar* value);
ValaSourceFileType vala_source_file_get_file_type (ValaSourceFile* self);
const gchar* vala_source_file_get_gir_namespace (ValaSourceFile* self);
void vala_source_file_set_gir_namespace (ValaSourceFile* self, const gchar* value);
const gchar* vala_source_file_get_gir_version (ValaSourceFile* self);
void vala_source_file_set_gir_version (ValaSourceFile* self, const gchar* value);
gboolean vala_source_file_get_used (ValaSourceFile* self);
void vala_source_file_set_used (ValaSourceFile* self, gboolean value);
static void vala_source_file_finalize (ValaSourceFile* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Creates a new source file.
 *
 * @param filename source file name
 * @param pkg      true if this is a VAPI package file
 * @return         newly created source file
 */
ValaSourceFile* vala_source_file_construct (GType object_type, ValaCodeContext* context, ValaSourceFileType type, const gchar* filename, const gchar* content) {
	ValaSourceFile* self = NULL;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	self = (ValaSourceFile*) g_type_create_instance (object_type);
	vala_source_file_set_context (self, context);
	vala_source_file_set_file_type (self, type);
	vala_source_file_set_filename (self, filename);
	vala_source_file_set_content (self, content);
	return self;
}


ValaSourceFile* vala_source_file_new (ValaCodeContext* context, ValaSourceFileType type, const gchar* filename, const gchar* content) {
	return vala_source_file_construct (VALA_TYPE_SOURCE_FILE, context, type, filename, content);
}


/**
 * Adds a header comment to this source file.
 */
void vala_source_file_add_comment (ValaSourceFile* self, ValaComment* comment) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment != NULL);
	vala_collection_add ((ValaCollection*) self->priv->comments, comment);
}


/**
 * Returns a copy of the list of header comments.
 *
 * @return list of comments
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_source_file_get_comments (ValaSourceFile* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 ((ValaList*) self->priv->comments);
	result = _tmp0_;
	return result;
}


/**
 * Adds a new using directive with the specified namespace.
 *
 * @param ns reference to namespace
 */
void vala_source_file_add_using_directive (ValaSourceFile* self, ValaUsingDirective* ns) {
	ValaList* _tmp0_;
	ValaList* old_using_directives;
	ValaArrayList* _tmp1_ = NULL;
	ValaArrayList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->_current_using_directives);
	old_using_directives = _tmp0_;
	_tmp1_ = vala_array_list_new (VALA_TYPE_USING_DIRECTIVE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	_tmp2_ = _tmp1_;
	vala_source_file_set_current_using_directives (self, (ValaList*) _tmp2_);
	_vala_iterable_unref0 (_tmp2_);
	{
		ValaList* _tmp3_;
		ValaList* _using_directive_list;
		gint _tmp4_;
		gint _using_directive_size;
		gint _using_directive_index;
		_tmp3_ = _vala_iterable_ref0 (old_using_directives);
		_using_directive_list = _tmp3_;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _using_directive_list);
		_using_directive_size = _tmp4_;
		_using_directive_index = -1;
		while (TRUE) {
			gpointer _tmp5_ = NULL;
			ValaUsingDirective* using_directive;
			_using_directive_index = _using_directive_index + 1;
			if (!(_using_directive_index < _using_directive_size)) {
				break;
			}
			_tmp5_ = vala_list_get (_using_directive_list, _using_directive_index);
			using_directive = (ValaUsingDirective*) _tmp5_;
			vala_collection_add ((ValaCollection*) self->priv->_current_using_directives, using_directive);
			_vala_code_node_unref0 (using_directive);
		}
		_vala_iterable_unref0 (_using_directive_list);
	}
	vala_collection_add ((ValaCollection*) self->priv->_current_using_directives, ns);
	_vala_iterable_unref0 (old_using_directives);
}


/**
 * Adds the specified code node to this source file.
 *
 * @param node a code node
 */
void vala_source_file_add_node (ValaSourceFile* self, ValaCodeNode* node) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	vala_collection_add ((ValaCollection*) self->priv->nodes, node);
}


void vala_source_file_remove_node (ValaSourceFile* self, ValaCodeNode* node) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	vala_collection_remove ((ValaCollection*) self->priv->nodes, node);
}


/**
 * Returns a copy of the list of code nodes.
 *
 * @return code node list
 */
ValaList* vala_source_file_get_nodes (ValaSourceFile* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->nodes);
	result = _tmp0_;
	return result;
}


void vala_source_file_accept (ValaSourceFile* self, ValaCodeVisitor* visitor) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_source_file (visitor, self);
}


void vala_source_file_accept_children (ValaSourceFile* self, ValaCodeVisitor* visitor) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _node_list;
		gint _tmp1_;
		gint _node_size;
		gint _node_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->nodes);
		_node_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _node_list);
		_node_size = _tmp1_;
		_node_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			ValaCodeNode* node;
			_node_index = _node_index + 1;
			if (!(_node_index < _node_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_node_list, _node_index);
			node = (ValaCodeNode*) _tmp2_;
			vala_code_node_accept (node, visitor);
			_vala_code_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp1_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp1_;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gchar* vala_source_file_get_subdir (ValaSourceFile* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gchar* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_code_context_get_basedir (self->priv->_context);
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_code_context_get_basedir (self->priv->_context);
	_tmp3_ = g_strconcat (_tmp2_, "/", NULL);
	_tmp4_ = g_str_has_prefix (self->priv->_filename, _tmp3_);
	if ((_tmp5_ = _tmp4_, _g_free0 (_tmp3_), _tmp5_)) {
		gchar* _tmp6_ = NULL;
		gchar* basename;
		const gchar* _tmp7_ = NULL;
		gint _tmp8_;
		gint _tmp9_;
		const gchar* _tmp10_ = NULL;
		gint _tmp11_;
		gint _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* subdir;
		_tmp6_ = g_path_get_basename (self->priv->_filename);
		basename = _tmp6_;
		_tmp7_ = vala_code_context_get_basedir (self->priv->_context);
		_tmp8_ = strlen (_tmp7_);
		_tmp9_ = strlen (self->priv->_filename);
		_tmp10_ = vala_code_context_get_basedir (self->priv->_context);
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = strlen (basename);
		_tmp13_ = string_substring (self->priv->_filename, (glong) _tmp8_, (glong) ((_tmp9_ - _tmp11_) - _tmp12_));
		subdir = _tmp13_;
		while (TRUE) {
			gchar _tmp14_;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			_tmp14_ = string_get (subdir, (glong) 0);
			if (!(_tmp14_ == '/')) {
				break;
			}
			_tmp15_ = string_substring (subdir, (glong) 1, (glong) (-1));
			_tmp16_ = _tmp15_;
			_g_free0 (subdir);
			subdir = _tmp16_;
		}
		result = subdir;
		_g_free0 (basename);
		return result;
	}
	_tmp17_ = g_strdup ("");
	result = _tmp17_;
	return result;
}


static gchar* vala_source_file_get_destination_directory (ValaSourceFile* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_code_context_get_directory (self->priv->_context);
	if (_tmp0_ == NULL) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = vala_source_file_get_subdir (self);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_code_context_get_directory (self->priv->_context);
	_tmp3_ = vala_source_file_get_subdir (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s/%s", _tmp2_, _tmp4_);
	result = (_tmp6_ = _tmp5_, _g_free0 (_tmp4_), _tmp6_);
	return result;
}


static gchar* vala_source_file_get_basename (ValaSourceFile* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	glong dot;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_utf8_strrchr (self->priv->_filename, (gssize) (-1), (gunichar) '.');
	dot = (glong) (((gchar*) _tmp0_) - ((gchar*) self->priv->_filename));
	_tmp1_ = string_substring (self->priv->_filename, (glong) 0, dot);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_path_get_basename (_tmp2_);
	result = (_tmp4_ = _tmp3_, _g_free0 (_tmp2_), _tmp4_);
	return result;
}


gchar* vala_source_file_get_relative_filename (ValaSourceFile* self) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_relative_filename != NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self->priv->_relative_filename);
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_path_get_basename (self->priv->_filename);
		result = _tmp1_;
		return result;
	}
}


/**
 * Returns the filename to use when generating C source files.
 *
 * @return generated C source filename
 */
gchar* vala_source_file_get_csource_filename (ValaSourceFile* self) {
	gchar* result = NULL;
	gchar* _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->csource_filename == NULL) {
		gboolean _tmp0_;
		_tmp0_ = vala_code_context_get_run_output (self->priv->_context);
		if (_tmp0_) {
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_;
			_tmp1_ = vala_code_context_get_output (self->priv->_context);
			_tmp2_ = g_strconcat (_tmp1_, ".c", NULL);
			_g_free0 (self->priv->csource_filename);
			self->priv->csource_filename = _tmp2_;
		} else {
			gboolean _tmp3_ = FALSE;
			gboolean _tmp4_;
			_tmp4_ = vala_code_context_get_ccode_only (self->priv->_context);
			if (_tmp4_) {
				_tmp3_ = TRUE;
			} else {
				gboolean _tmp5_;
				_tmp5_ = vala_code_context_get_save_csources (self->priv->_context);
				_tmp3_ = _tmp5_;
			}
			if (_tmp3_) {
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				_tmp6_ = vala_source_file_get_destination_directory (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = vala_source_file_get_basename (self);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strdup_printf ("%s%s.c", _tmp7_, _tmp9_);
				_tmp11_ = _tmp10_;
				_g_free0 (self->priv->csource_filename);
				self->priv->csource_filename = _tmp11_;
				_g_free0 (_tmp9_);
				_g_free0 (_tmp7_);
			} else {
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_;
				_tmp12_ = vala_source_file_get_destination_directory (self);
				_tmp13_ = _tmp12_;
				_tmp14_ = vala_source_file_get_basename (self);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strdup_printf ("%s%s.vala.c", _tmp13_, _tmp15_);
				_tmp17_ = _tmp16_;
				_g_free0 (self->priv->csource_filename);
				self->priv->csource_filename = _tmp17_;
				_g_free0 (_tmp15_);
				_g_free0 (_tmp13_);
			}
		}
	}
	_tmp18_ = g_strdup (self->priv->csource_filename);
	result = _tmp18_;
	return result;
}


/**
 * Returns the filename to use when including the generated C header
 * file.
 *
 * @return C header filename to include
 */
gchar* vala_source_file_get_cinclude_filename (ValaSourceFile* self) {
	gchar* result = NULL;
	gchar* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->cinclude_filename == NULL) {
		const gchar* _tmp0_ = NULL;
		_tmp0_ = vala_code_context_get_header_filename (self->priv->_context);
		if (_tmp0_ != NULL) {
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			const gchar* _tmp4_ = NULL;
			_tmp1_ = vala_code_context_get_header_filename (self->priv->_context);
			_tmp2_ = g_path_get_basename (_tmp1_);
			_tmp3_ = _tmp2_;
			_g_free0 (self->priv->cinclude_filename);
			self->priv->cinclude_filename = _tmp3_;
			_tmp4_ = vala_code_context_get_includedir (self->priv->_context);
			if (_tmp4_ != NULL) {
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				_tmp5_ = vala_code_context_get_includedir (self->priv->_context);
				_tmp6_ = g_strdup_printf ("%s/%s", _tmp5_, self->priv->cinclude_filename);
				_tmp7_ = _tmp6_;
				_g_free0 (self->priv->cinclude_filename);
				self->priv->cinclude_filename = _tmp7_;
			}
		} else {
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			_tmp8_ = vala_source_file_get_subdir (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_source_file_get_basename (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strdup_printf ("%s%s.h", _tmp9_, _tmp11_);
			_tmp13_ = _tmp12_;
			_g_free0 (self->priv->cinclude_filename);
			self->priv->cinclude_filename = _tmp13_;
			_g_free0 (_tmp11_);
			_g_free0 (_tmp9_);
		}
	}
	_tmp14_ = g_strdup (self->priv->cinclude_filename);
	result = _tmp14_;
	return result;
}


/**
 * Returns the requested line from this file, loading it if needed.
 *
 * @param lineno 1-based line number
 * @return       the specified source line
 */
gchar* vala_source_file_get_source_line (ValaSourceFile* self, gint lineno) {
	gchar* result = NULL;
	gboolean _tmp2_ = FALSE;
	gpointer _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->source_array == NULL) {
		const gchar* _tmp0_ = NULL;
		_tmp0_ = vala_source_file_get_content (self);
		if (_tmp0_ != NULL) {
			const gchar* _tmp1_ = NULL;
			_tmp1_ = vala_source_file_get_content (self);
			vala_source_file_read_source_lines (self, _tmp1_);
		} else {
			vala_source_file_read_source_file (self);
		}
	}
	if (lineno < 1) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp3_;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) self->priv->source_array);
		_tmp2_ = lineno > _tmp3_;
	}
	if (_tmp2_) {
		result = NULL;
		return result;
	}
	_tmp4_ = vala_list_get ((ValaList*) self->priv->source_array, lineno - 1);
	result = (gchar*) _tmp4_;
	return result;
}


/**
 * Parses the input file into ::source_array.
 */
static void vala_source_file_read_source_file (ValaSourceFile* self) {
	gchar* cont;
	gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	cont = NULL;
	g_file_get_contents (self->priv->_filename, &_tmp0_, NULL, &_inner_error_);
	_g_free0 (cont);
	cont = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_FILE_ERROR) {
			goto __catch13_g_file_error;
		}
		_g_free0 (cont);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally13;
	__catch13_g_file_error:
	{
		GError * fe;
		fe = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (fe);
		_g_free0 (cont);
		return;
	}
	__finally13:
	if (_inner_error_ != NULL) {
		_g_free0 (cont);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	vala_source_file_read_source_lines (self, cont);
	_g_free0 (cont);
}


static void vala_source_file_read_source_lines (ValaSourceFile* self, const gchar* cont) {
	ValaArrayList* _tmp0_ = NULL;
	ValaArrayList* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp4_;
	gchar** lines;
	gint idx = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cont != NULL);
	_tmp0_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	_tmp1_ = _tmp0_;
	_vala_iterable_unref0 (self->priv->source_array);
	self->priv->source_array = _tmp1_;
	_tmp3_ = _tmp2_ = g_strsplit (cont, "\n", 0);
	_tmp4_ = _tmp3_;
	lines_length1 = _vala_array_length (_tmp2_);
	_lines_size_ = lines_length1;
	lines = _tmp4_;
	{
		gboolean _tmp5_;
		idx = 0;
		_tmp5_ = TRUE;
		while (TRUE) {
			if (!_tmp5_) {
				idx = idx + 1;
			}
			_tmp5_ = FALSE;
			if (!(lines[idx] != NULL)) {
				break;
			}
			vala_collection_add ((ValaCollection*) self->priv->source_array, lines[idx]);
		}
	}
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}


gchar* vala_source_file_get_mapped_contents (ValaSourceFile* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_source_file_get_content (self);
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = vala_source_file_get_content (self);
		result = (gchar*) _tmp1_;
		return result;
	}
	if (self->priv->mapped_file == NULL) {
		GMappedFile* _tmp2_ = NULL;
		GMappedFile* _tmp3_;
		GMappedFile* _tmp4_;
		_tmp2_ = g_mapped_file_new (self->priv->_filename, FALSE, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch14_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp4_ = _tmp3_;
		_g_mapped_file_free0 (self->priv->mapped_file);
		self->priv->mapped_file = _tmp4_;
		goto __finally14;
		__catch14_g_file_error:
		{
			GError * e;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp5_ = g_strdup_printf ("Unable to map file `%s': %s", self->priv->_filename, e->message);
			_tmp6_ = _tmp5_;
			vala_report_error (NULL, _tmp6_);
			_g_free0 (_tmp6_);
			result = NULL;
			_g_error_free0 (e);
			return result;
		}
		__finally14:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp7_ = g_mapped_file_get_contents (self->priv->mapped_file);
	result = _tmp7_;
	return result;
}


gsize vala_source_file_get_mapped_length (ValaSourceFile* self) {
	gsize result = 0UL;
	const gchar* _tmp0_ = NULL;
	gsize _tmp3_;
	g_return_val_if_fail (self != NULL, 0UL);
	_tmp0_ = vala_source_file_get_content (self);
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		gint _tmp2_;
		_tmp1_ = vala_source_file_get_content (self);
		_tmp2_ = strlen (_tmp1_);
		result = (gsize) _tmp2_;
		return result;
	}
	_tmp3_ = g_mapped_file_get_length (self->priv->mapped_file);
	result = _tmp3_;
	return result;
}


gboolean vala_source_file_check (ValaSourceFile* self, ValaCodeContext* context) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	{
		ValaList* _tmp0_;
		ValaList* _node_list;
		gint _tmp1_;
		gint _node_size;
		gint _node_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->nodes);
		_node_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _node_list);
		_node_size = _tmp1_;
		_node_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			ValaCodeNode* node;
			_node_index = _node_index + 1;
			if (!(_node_index < _node_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_node_list, _node_index);
			node = (ValaCodeNode*) _tmp2_;
			vala_code_node_check (node, context);
			_vala_code_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
	result = TRUE;
	return result;
}


const gchar* vala_source_file_get_filename (ValaSourceFile* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_filename;
	return result;
}


void vala_source_file_set_filename (ValaSourceFile* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_filename);
	self->priv->_filename = _tmp1_;
}


void vala_source_file_set_relative_filename (ValaSourceFile* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_relative_filename);
	self->priv->_relative_filename = _tmp1_;
}


ValaSourceFileType vala_source_file_get_file_type (ValaSourceFile* self) {
	ValaSourceFileType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_file_type;
	return result;
}


void vala_source_file_set_file_type (ValaSourceFile* self, ValaSourceFileType value) {
	g_return_if_fail (self != NULL);
	self->priv->_file_type = value;
}


const gchar* vala_source_file_get_gir_namespace (ValaSourceFile* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_gir_namespace;
	return result;
}


void vala_source_file_set_gir_namespace (ValaSourceFile* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_gir_namespace);
	self->priv->_gir_namespace = _tmp1_;
}


const gchar* vala_source_file_get_gir_version (ValaSourceFile* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_gir_version;
	return result;
}


void vala_source_file_set_gir_version (ValaSourceFile* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_gir_version);
	self->priv->_gir_version = _tmp1_;
}


ValaCodeContext* vala_source_file_get_context (ValaSourceFile* self) {
	ValaCodeContext* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_context;
	return result;
}


void vala_source_file_set_context (ValaSourceFile* self, ValaCodeContext* value) {
	g_return_if_fail (self != NULL);
	self->priv->_context = value;
}


const gchar* vala_source_file_get_content (ValaSourceFile* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_content;
	return result;
}


void vala_source_file_set_content (ValaSourceFile* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaArrayList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_content);
	self->priv->_content = _tmp1_;
	_tmp2_ = NULL;
	_vala_iterable_unref0 (self->priv->source_array);
	self->priv->source_array = _tmp2_;
}


gboolean vala_source_file_get_used (ValaSourceFile* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_used;
	return result;
}


void vala_source_file_set_used (ValaSourceFile* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_used = value;
}


ValaList* vala_source_file_get_current_using_directives (ValaSourceFile* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_current_using_directives;
	return result;
}


void vala_source_file_set_current_using_directives (ValaSourceFile* self, ValaList* value) {
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_iterable_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_iterable_unref0 (self->priv->_current_using_directives);
	self->priv->_current_using_directives = _tmp1_;
}


static void vala_value_source_file_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_source_file_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_source_file_unref (value->data[0].v_pointer);
	}
}


static void vala_value_source_file_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_source_file_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_source_file_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_source_file_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaSourceFile* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_source_file_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_source_file_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaSourceFile** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_source_file_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecSourceFile* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_SOURCE_FILE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_source_file (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SOURCE_FILE), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_source_file (GValue* value, gpointer v_object) {
	ValaSourceFile* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SOURCE_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SOURCE_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_source_file_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_source_file_unref (old);
	}
}


void vala_value_take_source_file (GValue* value, gpointer v_object) {
	ValaSourceFile* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SOURCE_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SOURCE_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_source_file_unref (old);
	}
}


static void vala_source_file_class_init (ValaSourceFileClass * klass) {
	vala_source_file_parent_class = g_type_class_peek_parent (klass);
	VALA_SOURCE_FILE_CLASS (klass)->finalize = vala_source_file_finalize;
	g_type_class_add_private (klass, sizeof (ValaSourceFilePrivate));
}


static void vala_source_file_instance_init (ValaSourceFile * self) {
	ValaArrayList* _tmp0_ = NULL;
	ValaArrayList* _tmp1_ = NULL;
	ValaArrayList* _tmp2_ = NULL;
	self->priv = VALA_SOURCE_FILE_GET_PRIVATE (self);
	_tmp0_ = vala_array_list_new (VALA_TYPE_COMMENT, (GBoxedCopyFunc) vala_comment_ref, vala_comment_unref, g_direct_equal);
	self->priv->comments = _tmp0_;
	_tmp1_ = vala_array_list_new (VALA_TYPE_USING_DIRECTIVE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->_current_using_directives = (ValaList*) _tmp1_;
	_tmp2_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->nodes = (ValaList*) _tmp2_;
	self->priv->csource_filename = NULL;
	self->priv->cinclude_filename = NULL;
	self->priv->source_array = NULL;
	self->priv->mapped_file = NULL;
	self->priv->_content = NULL;
	self->ref_count = 1;
}


static void vala_source_file_finalize (ValaSourceFile* obj) {
	ValaSourceFile * self;
	self = VALA_SOURCE_FILE (obj);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_gir_namespace);
	_g_free0 (self->priv->_gir_version);
	_vala_iterable_unref0 (self->priv->comments);
	_vala_iterable_unref0 (self->priv->_current_using_directives);
	_vala_iterable_unref0 (self->priv->nodes);
	_g_free0 (self->priv->_relative_filename);
	_g_free0 (self->priv->csource_filename);
	_g_free0 (self->priv->cinclude_filename);
	_vala_iterable_unref0 (self->priv->source_array);
	_g_mapped_file_free0 (self->priv->mapped_file);
	_g_free0 (self->priv->_content);
}


/**
 * Represents a Vala source or VAPI package file.
 */
GType vala_source_file_get_type (void) {
	static volatile gsize vala_source_file_type_id__volatile = 0;
	if (g_once_init_enter (&vala_source_file_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_source_file_init, vala_value_source_file_free_value, vala_value_source_file_copy_value, vala_value_source_file_peek_pointer, "p", vala_value_source_file_collect_value, "p", vala_value_source_file_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaSourceFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_source_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSourceFile), 0, (GInstanceInitFunc) vala_source_file_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_source_file_type_id;
		vala_source_file_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaSourceFile", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_source_file_type_id__volatile, vala_source_file_type_id);
	}
	return vala_source_file_type_id__volatile;
}


gpointer vala_source_file_ref (gpointer instance) {
	ValaSourceFile* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_source_file_unref (gpointer instance) {
	ValaSourceFile* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_SOURCE_FILE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GType vala_source_file_type_get_type (void) {
	static volatile gsize vala_source_file_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_source_file_type_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_SOURCE_FILE_TYPE_NONE, "VALA_SOURCE_FILE_TYPE_NONE", "none"}, {VALA_SOURCE_FILE_TYPE_SOURCE, "VALA_SOURCE_FILE_TYPE_SOURCE", "source"}, {VALA_SOURCE_FILE_TYPE_PACKAGE, "VALA_SOURCE_FILE_TYPE_PACKAGE", "package"}, {VALA_SOURCE_FILE_TYPE_FAST, "VALA_SOURCE_FILE_TYPE_FAST", "fast"}, {0, NULL, NULL}};
		GType vala_source_file_type_type_id;
		vala_source_file_type_type_id = g_enum_register_static ("ValaSourceFileType", values);
		g_once_init_leave (&vala_source_file_type_type_id__volatile, vala_source_file_type_type_id);
	}
	return vala_source_file_type_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



