/* valascanner.c generated by valac, the Vala compiler
 * generated from valascanner.vala, do not modify */

/* valascanner.vala
 *
 * Copyright (C) 2008-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Jukka-Pekka Iivonen <jp0409@jippii.fi>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_SCANNER (vala_scanner_get_type ())
#define VALA_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCANNER, ValaScanner))
#define VALA_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCANNER, ValaScannerClass))
#define VALA_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCANNER))
#define VALA_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCANNER))
#define VALA_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCANNER, ValaScannerClass))

typedef struct _ValaScanner ValaScanner;
typedef struct _ValaScannerClass ValaScannerClass;
typedef struct _ValaScannerPrivate ValaScannerPrivate;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_TOKEN_TYPE (vala_token_type_get_type ())

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_SCANNER_TYPE_CONDITIONAL (vala_scanner_conditional_get_type ())
typedef struct _ValaScannerConditional ValaScannerConditional;

#define VALA_SCANNER_TYPE_STATE (vala_scanner_state_get_type ())
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))

#define VALA_TYPE_SOURCE_LOCATION (vala_source_location_get_type ())
typedef struct _ValaSourceLocation ValaSourceLocation;

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_PROFILE (vala_profile_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ValaParamSpecScanner ValaParamSpecScanner;

struct _ValaScanner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaScannerPrivate * priv;
};

struct _ValaScannerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaScanner *self);
};

typedef enum  {
	VALA_TOKEN_TYPE_NONE,
	VALA_TOKEN_TYPE_ABSTRACT,
	VALA_TOKEN_TYPE_AS,
	VALA_TOKEN_TYPE_ASSIGN,
	VALA_TOKEN_TYPE_ASSIGN_ADD,
	VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND,
	VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR,
	VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR,
	VALA_TOKEN_TYPE_ASSIGN_DIV,
	VALA_TOKEN_TYPE_ASSIGN_MUL,
	VALA_TOKEN_TYPE_ASSIGN_PERCENT,
	VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT,
	VALA_TOKEN_TYPE_ASSIGN_SUB,
	VALA_TOKEN_TYPE_ASYNC,
	VALA_TOKEN_TYPE_BASE,
	VALA_TOKEN_TYPE_BITWISE_AND,
	VALA_TOKEN_TYPE_BITWISE_OR,
	VALA_TOKEN_TYPE_BREAK,
	VALA_TOKEN_TYPE_CARRET,
	VALA_TOKEN_TYPE_CASE,
	VALA_TOKEN_TYPE_CATCH,
	VALA_TOKEN_TYPE_CHARACTER_LITERAL,
	VALA_TOKEN_TYPE_CLASS,
	VALA_TOKEN_TYPE_CLOSE_BRACE,
	VALA_TOKEN_TYPE_CLOSE_BRACKET,
	VALA_TOKEN_TYPE_CLOSE_PARENS,
	VALA_TOKEN_TYPE_CLOSE_REGEX_LITERAL,
	VALA_TOKEN_TYPE_CLOSE_TEMPLATE,
	VALA_TOKEN_TYPE_COLON,
	VALA_TOKEN_TYPE_COMMA,
	VALA_TOKEN_TYPE_CONST,
	VALA_TOKEN_TYPE_CONSTRUCT,
	VALA_TOKEN_TYPE_CONTINUE,
	VALA_TOKEN_TYPE_DEFAULT,
	VALA_TOKEN_TYPE_DELEGATE,
	VALA_TOKEN_TYPE_DELETE,
	VALA_TOKEN_TYPE_DIV,
	VALA_TOKEN_TYPE_DO,
	VALA_TOKEN_TYPE_DOUBLE_COLON,
	VALA_TOKEN_TYPE_DOT,
	VALA_TOKEN_TYPE_DYNAMIC,
	VALA_TOKEN_TYPE_ELLIPSIS,
	VALA_TOKEN_TYPE_ELSE,
	VALA_TOKEN_TYPE_ENUM,
	VALA_TOKEN_TYPE_ENSURES,
	VALA_TOKEN_TYPE_ERRORDOMAIN,
	VALA_TOKEN_TYPE_EOF,
	VALA_TOKEN_TYPE_EXTERN,
	VALA_TOKEN_TYPE_FALSE,
	VALA_TOKEN_TYPE_FINALLY,
	VALA_TOKEN_TYPE_FOR,
	VALA_TOKEN_TYPE_FOREACH,
	VALA_TOKEN_TYPE_GET,
	VALA_TOKEN_TYPE_HASH,
	VALA_TOKEN_TYPE_IDENTIFIER,
	VALA_TOKEN_TYPE_IF,
	VALA_TOKEN_TYPE_IN,
	VALA_TOKEN_TYPE_INLINE,
	VALA_TOKEN_TYPE_INTEGER_LITERAL,
	VALA_TOKEN_TYPE_INTERFACE,
	VALA_TOKEN_TYPE_INTERNAL,
	VALA_TOKEN_TYPE_INTERR,
	VALA_TOKEN_TYPE_IS,
	VALA_TOKEN_TYPE_LAMBDA,
	VALA_TOKEN_TYPE_LOCK,
	VALA_TOKEN_TYPE_MINUS,
	VALA_TOKEN_TYPE_NAMESPACE,
	VALA_TOKEN_TYPE_NEW,
	VALA_TOKEN_TYPE_NULL,
	VALA_TOKEN_TYPE_OUT,
	VALA_TOKEN_TYPE_OP_AND,
	VALA_TOKEN_TYPE_OP_COALESCING,
	VALA_TOKEN_TYPE_OP_DEC,
	VALA_TOKEN_TYPE_OP_EQ,
	VALA_TOKEN_TYPE_OP_GE,
	VALA_TOKEN_TYPE_OP_GT,
	VALA_TOKEN_TYPE_OP_INC,
	VALA_TOKEN_TYPE_OP_LE,
	VALA_TOKEN_TYPE_OP_LT,
	VALA_TOKEN_TYPE_OP_NE,
	VALA_TOKEN_TYPE_OP_NEG,
	VALA_TOKEN_TYPE_OP_OR,
	VALA_TOKEN_TYPE_OP_PTR,
	VALA_TOKEN_TYPE_OP_SHIFT_LEFT,
	VALA_TOKEN_TYPE_OPEN_BRACE,
	VALA_TOKEN_TYPE_OPEN_BRACKET,
	VALA_TOKEN_TYPE_OPEN_PARENS,
	VALA_TOKEN_TYPE_OPEN_REGEX_LITERAL,
	VALA_TOKEN_TYPE_OPEN_TEMPLATE,
	VALA_TOKEN_TYPE_OVERRIDE,
	VALA_TOKEN_TYPE_OWNED,
	VALA_TOKEN_TYPE_PARAMS,
	VALA_TOKEN_TYPE_PERCENT,
	VALA_TOKEN_TYPE_PLUS,
	VALA_TOKEN_TYPE_PRIVATE,
	VALA_TOKEN_TYPE_PROTECTED,
	VALA_TOKEN_TYPE_PUBLIC,
	VALA_TOKEN_TYPE_REAL_LITERAL,
	VALA_TOKEN_TYPE_REF,
	VALA_TOKEN_TYPE_REGEX_LITERAL,
	VALA_TOKEN_TYPE_REQUIRES,
	VALA_TOKEN_TYPE_RETURN,
	VALA_TOKEN_TYPE_SEALED,
	VALA_TOKEN_TYPE_SEMICOLON,
	VALA_TOKEN_TYPE_SET,
	VALA_TOKEN_TYPE_SIGNAL,
	VALA_TOKEN_TYPE_SIZEOF,
	VALA_TOKEN_TYPE_STAR,
	VALA_TOKEN_TYPE_STATIC,
	VALA_TOKEN_TYPE_STRING_LITERAL,
	VALA_TOKEN_TYPE_STRUCT,
	VALA_TOKEN_TYPE_SWITCH,
	VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL,
	VALA_TOKEN_TYPE_THIS,
	VALA_TOKEN_TYPE_THROW,
	VALA_TOKEN_TYPE_THROWS,
	VALA_TOKEN_TYPE_TILDE,
	VALA_TOKEN_TYPE_TRUE,
	VALA_TOKEN_TYPE_TRY,
	VALA_TOKEN_TYPE_TYPEOF,
	VALA_TOKEN_TYPE_UNOWNED,
	VALA_TOKEN_TYPE_USING,
	VALA_TOKEN_TYPE_VAR,
	VALA_TOKEN_TYPE_VERBATIM_STRING_LITERAL,
	VALA_TOKEN_TYPE_VIRTUAL,
	VALA_TOKEN_TYPE_VOID,
	VALA_TOKEN_TYPE_VOLATILE,
	VALA_TOKEN_TYPE_WEAK,
	VALA_TOKEN_TYPE_WHILE,
	VALA_TOKEN_TYPE_YIELD
} ValaTokenType;

struct _ValaScannerConditional {
	gboolean matched;
	gboolean else_found;
	gboolean skip_section;
};

typedef enum  {
	VALA_SCANNER_STATE_PARENS,
	VALA_SCANNER_STATE_BRACE,
	VALA_SCANNER_STATE_BRACKET,
	VALA_SCANNER_STATE_TEMPLATE,
	VALA_SCANNER_STATE_TEMPLATE_PART,
	VALA_SCANNER_STATE_REGEX_LITERAL
} ValaScannerState;

struct _ValaScannerPrivate {
	ValaSourceFile* _source_file;
	ValaTokenType previous;
	gchar* current;
	gchar* end;
	gint line;
	gint column;
	ValaComment* _comment;
	ValaScannerConditional* conditional_stack;
	gint conditional_stack_length1;
	gint _conditional_stack_size_;
	ValaScannerState* state_stack;
	gint state_stack_length1;
	gint _state_stack_size_;
};

struct _ValaSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

typedef enum  {
	VALA_PROFILE_POSIX,
	VALA_PROFILE_GOBJECT,
	VALA_PROFILE_DOVA
} ValaProfile;

struct _ValaParamSpecScanner {
	GParamSpec parent_instance;
};


static gpointer vala_scanner_parent_class = NULL;

gpointer vala_scanner_ref (gpointer instance);
void vala_scanner_unref (gpointer instance);
GParamSpec* vala_param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scanner (GValue* value, gpointer v_object);
void vala_value_take_scanner (GValue* value, gpointer v_object);
gpointer vala_value_get_scanner (const GValue* value);
GType vala_scanner_get_type (void) G_GNUC_CONST;
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
GType vala_token_type_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
static GType vala_scanner_conditional_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaScannerConditional* vala_scanner_conditional_dup (const ValaScannerConditional* self);
static void vala_scanner_conditional_free (ValaScannerConditional* self);
static GType vala_scanner_state_get_type (void) G_GNUC_UNUSED;
#define VALA_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SCANNER, ValaScannerPrivate))
enum  {
	VALA_SCANNER_DUMMY_PROPERTY
};
ValaScanner* vala_scanner_new (ValaSourceFile* source_file);
ValaScanner* vala_scanner_construct (GType object_type, ValaSourceFile* source_file);
static void vala_scanner_set_source_file (ValaScanner* self, ValaSourceFile* value);
gchar* vala_source_file_get_mapped_contents (ValaSourceFile* self);
gsize vala_source_file_get_mapped_length (ValaSourceFile* self);
GType vala_source_location_get_type (void) G_GNUC_CONST;
ValaSourceLocation* vala_source_location_dup (const ValaSourceLocation* self);
void vala_source_location_free (ValaSourceLocation* self);
void vala_scanner_seek (ValaScanner* self, ValaSourceLocation* location);
static gboolean vala_scanner_in_template (ValaScanner* self);
static gboolean vala_scanner_in_template_part (ValaScanner* self);
static gboolean vala_scanner_in_regex_literal (ValaScanner* self);
static gboolean vala_scanner_is_ident_char (ValaScanner* self, gchar c);
ValaTokenType vala_scanner_read_regex_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaSourceFile* vala_scanner_get_source_file (ValaScanner* self);
ValaSourceReference* vala_source_reference_new (ValaSourceFile* _file, gint _first_line, gint _first_column, gint _last_line, gint _last_column);
ValaSourceReference* vala_source_reference_construct (GType object_type, ValaSourceFile* _file, gint _first_line, gint _first_column, gint _last_line, gint _last_column);
ValaTokenType vala_scanner_read_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
ValaTokenType vala_scanner_get_identifier_or_keyword (gchar* begin, gint len);
static gboolean vala_scanner_matches (gchar* begin, const gchar* keyword);
static ValaTokenType vala_scanner_read_number (ValaScanner* self);
ValaTokenType vala_scanner_read_template_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
static void _vala_array_add14 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add15 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add16 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add17 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void vala_scanner_space (ValaScanner* self);
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
ValaCodeContext* vala_source_file_get_context (ValaSourceFile* self);
GType vala_profile_get_type (void) G_GNUC_CONST;
ValaProfile vala_code_context_get_profile (ValaCodeContext* self);
static void _vala_array_add18 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add19 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add20 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add21 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add22 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add23 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static gboolean vala_scanner_pp_whitespace (ValaScanner* self);
static void vala_scanner_pp_directive (ValaScanner* self);
static void vala_scanner_parse_pp_if (ValaScanner* self);
static void vala_scanner_parse_pp_elif (ValaScanner* self);
static void vala_scanner_parse_pp_else (ValaScanner* self);
static void vala_scanner_parse_pp_endif (ValaScanner* self);
static void vala_scanner_pp_eol (ValaScanner* self);
static gboolean vala_scanner_parse_pp_expression (ValaScanner* self);
static void _vala_array_add24 (ValaScannerConditional** array, int* length, int* size, const ValaScannerConditional* value);
static gboolean vala_scanner_parse_pp_symbol (ValaScanner* self);
gboolean vala_code_context_is_defined (ValaCodeContext* self, const gchar* define);
static gboolean vala_scanner_parse_pp_primary_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_unary_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_equality_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_and_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_or_expression (ValaScanner* self);
static gboolean vala_scanner_whitespace (ValaScanner* self);
static gboolean vala_scanner_comment (ValaScanner* self, gboolean file_comment);
static void vala_scanner_push_comment (ValaScanner* self, const gchar* comment_item, ValaSourceReference* source_reference, gboolean file_comment);
void vala_scanner_parse_file_comments (ValaScanner* self);
void vala_source_file_add_comment (ValaSourceFile* self, ValaComment* comment);
ValaComment* vala_comment_new (const gchar* comment, ValaSourceReference* _source_reference);
ValaComment* vala_comment_construct (GType object_type, const gchar* comment, ValaSourceReference* _source_reference);
ValaComment* vala_scanner_pop_comment (ValaScanner* self);
static void vala_scanner_finalize (ValaScanner* obj);


static GType vala_scanner_state_get_type (void) {
	static volatile gsize vala_scanner_state_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_state_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_SCANNER_STATE_PARENS, "VALA_SCANNER_STATE_PARENS", "parens"}, {VALA_SCANNER_STATE_BRACE, "VALA_SCANNER_STATE_BRACE", "brace"}, {VALA_SCANNER_STATE_BRACKET, "VALA_SCANNER_STATE_BRACKET", "bracket"}, {VALA_SCANNER_STATE_TEMPLATE, "VALA_SCANNER_STATE_TEMPLATE", "template"}, {VALA_SCANNER_STATE_TEMPLATE_PART, "VALA_SCANNER_STATE_TEMPLATE_PART", "template-part"}, {VALA_SCANNER_STATE_REGEX_LITERAL, "VALA_SCANNER_STATE_REGEX_LITERAL", "regex-literal"}, {0, NULL, NULL}};
		GType vala_scanner_state_type_id;
		vala_scanner_state_type_id = g_enum_register_static ("ValaScannerState", values);
		g_once_init_leave (&vala_scanner_state_type_id__volatile, vala_scanner_state_type_id);
	}
	return vala_scanner_state_type_id__volatile;
}


ValaScanner* vala_scanner_construct (GType object_type, ValaSourceFile* source_file) {
	ValaScanner* self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* begin;
	gsize _tmp1_;
	g_return_val_if_fail (source_file != NULL, NULL);
	self = (ValaScanner*) g_type_create_instance (object_type);
	vala_scanner_set_source_file (self, source_file);
	_tmp0_ = vala_source_file_get_mapped_contents (source_file);
	begin = _tmp0_;
	_tmp1_ = vala_source_file_get_mapped_length (source_file);
	self->priv->end = begin + _tmp1_;
	self->priv->current = begin;
	self->priv->line = 1;
	self->priv->column = 1;
	return self;
}


ValaScanner* vala_scanner_new (ValaSourceFile* source_file) {
	return vala_scanner_construct (VALA_TYPE_SCANNER, source_file);
}


void vala_scanner_seek (ValaScanner* self, ValaSourceLocation* location) {
	ValaScannerConditional* _tmp0_;
	ValaScannerState* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->current = (*location).pos;
	self->priv->line = (*location).line;
	self->priv->column = (*location).column;
	_tmp0_ = NULL;
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->conditional_stack_length1 = 0;
	self->priv->_conditional_stack_size_ = self->priv->conditional_stack_length1;
	self->priv->conditional_stack = _tmp0_;
	_tmp1_ = NULL;
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
	self->priv->state_stack_length1 = 0;
	self->priv->_state_stack_size_ = self->priv->state_stack_length1;
	self->priv->state_stack = _tmp1_;
}


static gboolean vala_scanner_in_template (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->state_stack_length1 > 0) {
		_tmp0_ = self->priv->state_stack[self->priv->state_stack_length1 - 1] == VALA_SCANNER_STATE_TEMPLATE;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean vala_scanner_in_template_part (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->state_stack_length1 > 0) {
		_tmp0_ = self->priv->state_stack[self->priv->state_stack_length1 - 1] == VALA_SCANNER_STATE_TEMPLATE_PART;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean vala_scanner_in_regex_literal (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->state_stack_length1 > 0) {
		_tmp0_ = self->priv->state_stack[self->priv->state_stack_length1 - 1] == VALA_SCANNER_STATE_REGEX_LITERAL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean vala_scanner_is_ident_char (ValaScanner* self, gchar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = g_ascii_isalnum (c);
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = c == '_';
	}
	result = _tmp0_;
	return result;
}


ValaTokenType vala_scanner_read_regex_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaSourceLocation _token_begin = {0};
	ValaSourceLocation _token_end = {0};
	ValaTokenType result = 0;
	ValaTokenType type = 0;
	gchar* begin;
	gint token_length_in_chars;
	g_return_val_if_fail (self != NULL, 0);
	begin = self->priv->current;
	_token_begin.pos = begin;
	_token_begin.line = self->priv->line;
	_token_begin.column = self->priv->column;
	token_length_in_chars = -1;
	if (self->priv->current >= self->priv->end) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		switch (self->priv->current[0]) {
			case '/':
			{
				gboolean fl_i;
				gboolean fl_s;
				gboolean fl_m;
				gboolean fl_x;
				type = VALA_TOKEN_TYPE_CLOSE_REGEX_LITERAL;
				self->priv->current++;
				self->priv->state_stack_length1--;
				fl_i = FALSE;
				fl_s = FALSE;
				fl_m = FALSE;
				fl_x = FALSE;
				while (TRUE) {
					gboolean _tmp0_ = FALSE;
					gboolean _tmp1_ = FALSE;
					gboolean _tmp2_ = FALSE;
					if (self->priv->current[0] == 'i') {
						_tmp2_ = TRUE;
					} else {
						_tmp2_ = self->priv->current[0] == 's';
					}
					if (_tmp2_) {
						_tmp1_ = TRUE;
					} else {
						_tmp1_ = self->priv->current[0] == 'm';
					}
					if (_tmp1_) {
						_tmp0_ = TRUE;
					} else {
						_tmp0_ = self->priv->current[0] == 'x';
					}
					if (!_tmp0_) {
						break;
					}
					switch (self->priv->current[0]) {
						case 'i':
						{
							if (fl_i) {
								ValaSourceReference* _tmp3_ = NULL;
								ValaSourceReference* _tmp4_;
								_tmp3_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
								_tmp4_ = _tmp3_;
								vala_report_error (_tmp4_, "modifier 'i' used more than once");
								_vala_source_reference_unref0 (_tmp4_);
							}
							fl_i = TRUE;
							break;
						}
						case 's':
						{
							if (fl_s) {
								ValaSourceReference* _tmp5_ = NULL;
								ValaSourceReference* _tmp6_;
								_tmp5_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
								_tmp6_ = _tmp5_;
								vala_report_error (_tmp6_, "modifier 's' used more than once");
								_vala_source_reference_unref0 (_tmp6_);
							}
							fl_s = TRUE;
							break;
						}
						case 'm':
						{
							if (fl_m) {
								ValaSourceReference* _tmp7_ = NULL;
								ValaSourceReference* _tmp8_;
								_tmp7_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
								_tmp8_ = _tmp7_;
								vala_report_error (_tmp8_, "modifier 'm' used more than once");
								_vala_source_reference_unref0 (_tmp8_);
							}
							fl_m = TRUE;
							break;
						}
						case 'x':
						{
							if (fl_x) {
								ValaSourceReference* _tmp9_ = NULL;
								ValaSourceReference* _tmp10_;
								_tmp9_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
								_tmp10_ = _tmp9_;
								vala_report_error (_tmp10_, "modifier 'x' used more than once");
								_vala_source_reference_unref0 (_tmp10_);
							}
							fl_x = TRUE;
							break;
						}
					}
					self->priv->current++;
					token_length_in_chars++;
				}
				break;
			}
			default:
			{
				gboolean _tmp20_ = FALSE;
				type = VALA_TOKEN_TYPE_REGEX_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp11_ = FALSE;
					if (self->priv->current < self->priv->end) {
						_tmp11_ = self->priv->current[0] != '/';
					} else {
						_tmp11_ = FALSE;
					}
					if (!_tmp11_) {
						break;
					}
					if (self->priv->current[0] == '\\') {
						self->priv->current++;
						token_length_in_chars++;
						if (self->priv->current >= self->priv->end) {
							break;
						}
						switch (self->priv->current[0]) {
							case '\'':
							case '"':
							case '\\':
							case '/':
							case '^':
							case '$':
							case '.':
							case '[':
							case ']':
							case '{':
							case '}':
							case '(':
							case ')':
							case '?':
							case '*':
							case '+':
							case '-':
							case '#':
							case '&':
							case '~':
							case ':':
							case ';':
							case '<':
							case '>':
							case '|':
							case '%':
							case '=':
							case '@':
							case '0':
							case 'b':
							case 'B':
							case 'f':
							case 'n':
							case 'r':
							case 't':
							case 'a':
							case 'A':
							case 'p':
							case 'P':
							case 'e':
							case 'd':
							case 'D':
							case 's':
							case 'S':
							case 'w':
							case 'W':
							case 'G':
							case 'z':
							case 'Z':
							{
								self->priv->current++;
								token_length_in_chars++;
								break;
							}
							case 'x':
							{
								self->priv->current++;
								token_length_in_chars++;
								while (TRUE) {
									gboolean _tmp12_ = FALSE;
									if (self->priv->current < self->priv->end) {
										gboolean _tmp13_;
										_tmp13_ = g_ascii_isxdigit (self->priv->current[0]);
										_tmp12_ = _tmp13_;
									} else {
										_tmp12_ = FALSE;
									}
									if (!_tmp12_) {
										break;
									}
									self->priv->current++;
									token_length_in_chars++;
								}
								break;
							}
							default:
							{
								ValaSourceReference* _tmp14_ = NULL;
								ValaSourceReference* _tmp15_;
								_tmp14_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
								_tmp15_ = _tmp14_;
								vala_report_error (_tmp15_, "invalid escape sequence");
								_vala_source_reference_unref0 (_tmp15_);
								break;
							}
						}
					} else {
						if (self->priv->current[0] == '\n') {
							break;
						} else {
							gunichar _tmp16_;
							gunichar u;
							_tmp16_ = g_utf8_get_char_validated ((const gchar*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
							u = _tmp16_;
							if (u != ((gunichar) (-1))) {
								gint _tmp17_;
								_tmp17_ = g_unichar_to_utf8 (u, NULL);
								self->priv->current = self->priv->current + _tmp17_;
								token_length_in_chars++;
							} else {
								ValaSourceReference* _tmp18_ = NULL;
								ValaSourceReference* _tmp19_;
								self->priv->current++;
								_tmp18_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
								_tmp19_ = _tmp18_;
								vala_report_error (_tmp19_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp19_);
							}
						}
					}
				}
				if (self->priv->current >= self->priv->end) {
					_tmp20_ = TRUE;
				} else {
					_tmp20_ = self->priv->current[0] == '\n';
				}
				if (_tmp20_) {
					ValaSourceReference* _tmp21_ = NULL;
					ValaSourceReference* _tmp22_;
					ValaSourceLocation _tmp23_ = {0};
					ValaSourceLocation _tmp24_ = {0};
					ValaTokenType _tmp25_;
					_tmp21_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
					_tmp22_ = _tmp21_;
					vala_report_error (_tmp22_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp22_);
					self->priv->state_stack_length1--;
					_tmp25_ = vala_scanner_read_token (self, &_tmp23_, &_tmp24_);
					_token_begin = _tmp23_;
					_token_end = _tmp24_;
					result = _tmp25_;
					if (token_begin) {
						*token_begin = _token_begin;
					}
					if (token_end) {
						*token_end = _token_end;
					}
					return result;
				}
				break;
			}
		}
	}
	if (token_length_in_chars < 0) {
		self->priv->column = self->priv->column + ((gint) (self->priv->current - begin));
	} else {
		self->priv->column = self->priv->column + token_length_in_chars;
	}
	_token_end.pos = self->priv->current;
	_token_end.line = self->priv->line;
	_token_end.column = self->priv->column - 1;
	result = type;
	if (token_begin) {
		*token_begin = _token_begin;
	}
	if (token_end) {
		*token_end = _token_end;
	}
	return result;
}


ValaTokenType vala_scanner_get_identifier_or_keyword (gchar* begin, gint len) {
	ValaTokenType result = 0;
	switch (len) {
		case 2:
		{
			switch (begin[0]) {
				case 'a':
				{
					gboolean _tmp0_;
					_tmp0_ = vala_scanner_matches (begin, "as");
					if (_tmp0_) {
						result = VALA_TOKEN_TYPE_AS;
						return result;
					}
					break;
				}
				case 'd':
				{
					gboolean _tmp1_;
					_tmp1_ = vala_scanner_matches (begin, "do");
					if (_tmp1_) {
						result = VALA_TOKEN_TYPE_DO;
						return result;
					}
					break;
				}
				case 'i':
				{
					switch (begin[1]) {
						case 'f':
						{
							result = VALA_TOKEN_TYPE_IF;
							return result;
						}
						case 'n':
						{
							result = VALA_TOKEN_TYPE_IN;
							return result;
						}
						case 's':
						{
							result = VALA_TOKEN_TYPE_IS;
							return result;
						}
					}
					break;
				}
			}
			break;
		}
		case 3:
		{
			switch (begin[0]) {
				case 'f':
				{
					gboolean _tmp2_;
					_tmp2_ = vala_scanner_matches (begin, "for");
					if (_tmp2_) {
						result = VALA_TOKEN_TYPE_FOR;
						return result;
					}
					break;
				}
				case 'g':
				{
					gboolean _tmp3_;
					_tmp3_ = vala_scanner_matches (begin, "get");
					if (_tmp3_) {
						result = VALA_TOKEN_TYPE_GET;
						return result;
					}
					break;
				}
				case 'n':
				{
					gboolean _tmp4_;
					_tmp4_ = vala_scanner_matches (begin, "new");
					if (_tmp4_) {
						result = VALA_TOKEN_TYPE_NEW;
						return result;
					}
					break;
				}
				case 'o':
				{
					gboolean _tmp5_;
					_tmp5_ = vala_scanner_matches (begin, "out");
					if (_tmp5_) {
						result = VALA_TOKEN_TYPE_OUT;
						return result;
					}
					break;
				}
				case 'r':
				{
					gboolean _tmp6_;
					_tmp6_ = vala_scanner_matches (begin, "ref");
					if (_tmp6_) {
						result = VALA_TOKEN_TYPE_REF;
						return result;
					}
					break;
				}
				case 's':
				{
					gboolean _tmp7_;
					_tmp7_ = vala_scanner_matches (begin, "set");
					if (_tmp7_) {
						result = VALA_TOKEN_TYPE_SET;
						return result;
					}
					break;
				}
				case 't':
				{
					gboolean _tmp8_;
					_tmp8_ = vala_scanner_matches (begin, "try");
					if (_tmp8_) {
						result = VALA_TOKEN_TYPE_TRY;
						return result;
					}
					break;
				}
				case 'v':
				{
					gboolean _tmp9_;
					_tmp9_ = vala_scanner_matches (begin, "var");
					if (_tmp9_) {
						result = VALA_TOKEN_TYPE_VAR;
						return result;
					}
					break;
				}
			}
			break;
		}
		case 4:
		{
			switch (begin[0]) {
				case 'b':
				{
					gboolean _tmp10_;
					_tmp10_ = vala_scanner_matches (begin, "base");
					if (_tmp10_) {
						result = VALA_TOKEN_TYPE_BASE;
						return result;
					}
					break;
				}
				case 'c':
				{
					gboolean _tmp11_;
					_tmp11_ = vala_scanner_matches (begin, "case");
					if (_tmp11_) {
						result = VALA_TOKEN_TYPE_CASE;
						return result;
					}
					break;
				}
				case 'e':
				{
					switch (begin[1]) {
						case 'l':
						{
							gboolean _tmp12_;
							_tmp12_ = vala_scanner_matches (begin, "else");
							if (_tmp12_) {
								result = VALA_TOKEN_TYPE_ELSE;
								return result;
							}
							break;
						}
						case 'n':
						{
							gboolean _tmp13_;
							_tmp13_ = vala_scanner_matches (begin, "enum");
							if (_tmp13_) {
								result = VALA_TOKEN_TYPE_ENUM;
								return result;
							}
							break;
						}
					}
					break;
				}
				case 'l':
				{
					gboolean _tmp14_;
					_tmp14_ = vala_scanner_matches (begin, "lock");
					if (_tmp14_) {
						result = VALA_TOKEN_TYPE_LOCK;
						return result;
					}
					break;
				}
				case 'n':
				{
					gboolean _tmp15_;
					_tmp15_ = vala_scanner_matches (begin, "null");
					if (_tmp15_) {
						result = VALA_TOKEN_TYPE_NULL;
						return result;
					}
					break;
				}
				case 't':
				{
					switch (begin[1]) {
						case 'h':
						{
							gboolean _tmp16_;
							_tmp16_ = vala_scanner_matches (begin, "this");
							if (_tmp16_) {
								result = VALA_TOKEN_TYPE_THIS;
								return result;
							}
							break;
						}
						case 'r':
						{
							gboolean _tmp17_;
							_tmp17_ = vala_scanner_matches (begin, "true");
							if (_tmp17_) {
								result = VALA_TOKEN_TYPE_TRUE;
								return result;
							}
							break;
						}
					}
					break;
				}
				case 'v':
				{
					gboolean _tmp18_;
					_tmp18_ = vala_scanner_matches (begin, "void");
					if (_tmp18_) {
						result = VALA_TOKEN_TYPE_VOID;
						return result;
					}
					break;
				}
				case 'w':
				{
					gboolean _tmp19_;
					_tmp19_ = vala_scanner_matches (begin, "weak");
					if (_tmp19_) {
						result = VALA_TOKEN_TYPE_WEAK;
						return result;
					}
					break;
				}
			}
			break;
		}
		case 5:
		{
			switch (begin[0]) {
				case 'a':
				{
					gboolean _tmp20_;
					_tmp20_ = vala_scanner_matches (begin, "async");
					if (_tmp20_) {
						result = VALA_TOKEN_TYPE_ASYNC;
						return result;
					}
					break;
				}
				case 'b':
				{
					gboolean _tmp21_;
					_tmp21_ = vala_scanner_matches (begin, "break");
					if (_tmp21_) {
						result = VALA_TOKEN_TYPE_BREAK;
						return result;
					}
					break;
				}
				case 'c':
				{
					switch (begin[1]) {
						case 'a':
						{
							gboolean _tmp22_;
							_tmp22_ = vala_scanner_matches (begin, "catch");
							if (_tmp22_) {
								result = VALA_TOKEN_TYPE_CATCH;
								return result;
							}
							break;
						}
						case 'l':
						{
							gboolean _tmp23_;
							_tmp23_ = vala_scanner_matches (begin, "class");
							if (_tmp23_) {
								result = VALA_TOKEN_TYPE_CLASS;
								return result;
							}
							break;
						}
						case 'o':
						{
							gboolean _tmp24_;
							_tmp24_ = vala_scanner_matches (begin, "const");
							if (_tmp24_) {
								result = VALA_TOKEN_TYPE_CONST;
								return result;
							}
							break;
						}
					}
					break;
				}
				case 'f':
				{
					gboolean _tmp25_;
					_tmp25_ = vala_scanner_matches (begin, "false");
					if (_tmp25_) {
						result = VALA_TOKEN_TYPE_FALSE;
						return result;
					}
					break;
				}
				case 'o':
				{
					gboolean _tmp26_;
					_tmp26_ = vala_scanner_matches (begin, "owned");
					if (_tmp26_) {
						result = VALA_TOKEN_TYPE_OWNED;
						return result;
					}
					break;
				}
				case 't':
				{
					gboolean _tmp27_;
					_tmp27_ = vala_scanner_matches (begin, "throw");
					if (_tmp27_) {
						result = VALA_TOKEN_TYPE_THROW;
						return result;
					}
					break;
				}
				case 'u':
				{
					gboolean _tmp28_;
					_tmp28_ = vala_scanner_matches (begin, "using");
					if (_tmp28_) {
						result = VALA_TOKEN_TYPE_USING;
						return result;
					}
					break;
				}
				case 'w':
				{
					gboolean _tmp29_;
					_tmp29_ = vala_scanner_matches (begin, "while");
					if (_tmp29_) {
						result = VALA_TOKEN_TYPE_WHILE;
						return result;
					}
					break;
				}
				case 'y':
				{
					gboolean _tmp30_;
					_tmp30_ = vala_scanner_matches (begin, "yield");
					if (_tmp30_) {
						result = VALA_TOKEN_TYPE_YIELD;
						return result;
					}
					break;
				}
			}
			break;
		}
		case 6:
		{
			switch (begin[0]) {
				case 'd':
				{
					gboolean _tmp31_;
					_tmp31_ = vala_scanner_matches (begin, "delete");
					if (_tmp31_) {
						result = VALA_TOKEN_TYPE_DELETE;
						return result;
					}
					break;
				}
				case 'e':
				{
					gboolean _tmp32_;
					_tmp32_ = vala_scanner_matches (begin, "extern");
					if (_tmp32_) {
						result = VALA_TOKEN_TYPE_EXTERN;
						return result;
					}
					break;
				}
				case 'i':
				{
					gboolean _tmp33_;
					_tmp33_ = vala_scanner_matches (begin, "inline");
					if (_tmp33_) {
						result = VALA_TOKEN_TYPE_INLINE;
						return result;
					}
					break;
				}
				case 'p':
				{
					switch (begin[1]) {
						case 'a':
						{
							gboolean _tmp34_;
							_tmp34_ = vala_scanner_matches (begin, "params");
							if (_tmp34_) {
								result = VALA_TOKEN_TYPE_PARAMS;
								return result;
							}
							break;
						}
						case 'u':
						{
							gboolean _tmp35_;
							_tmp35_ = vala_scanner_matches (begin, "public");
							if (_tmp35_) {
								result = VALA_TOKEN_TYPE_PUBLIC;
								return result;
							}
							break;
						}
					}
					break;
				}
				case 'r':
				{
					gboolean _tmp36_;
					_tmp36_ = vala_scanner_matches (begin, "return");
					if (_tmp36_) {
						result = VALA_TOKEN_TYPE_RETURN;
						return result;
					}
					break;
				}
				case 's':
				{
					switch (begin[1]) {
						case 'e':
						{
							gboolean _tmp37_;
							_tmp37_ = vala_scanner_matches (begin, "sealed");
							if (_tmp37_) {
								result = VALA_TOKEN_TYPE_SEALED;
								return result;
							}
							break;
						}
						case 'i':
						{
							switch (begin[2]) {
								case 'g':
								{
									gboolean _tmp38_;
									_tmp38_ = vala_scanner_matches (begin, "signal");
									if (_tmp38_) {
										result = VALA_TOKEN_TYPE_SIGNAL;
										return result;
									}
									break;
								}
								case 'z':
								{
									gboolean _tmp39_;
									_tmp39_ = vala_scanner_matches (begin, "sizeof");
									if (_tmp39_) {
										result = VALA_TOKEN_TYPE_SIZEOF;
										return result;
									}
									break;
								}
							}
							break;
						}
						case 't':
						{
							switch (begin[2]) {
								case 'a':
								{
									gboolean _tmp40_;
									_tmp40_ = vala_scanner_matches (begin, "static");
									if (_tmp40_) {
										result = VALA_TOKEN_TYPE_STATIC;
										return result;
									}
									break;
								}
								case 'r':
								{
									gboolean _tmp41_;
									_tmp41_ = vala_scanner_matches (begin, "struct");
									if (_tmp41_) {
										result = VALA_TOKEN_TYPE_STRUCT;
										return result;
									}
									break;
								}
							}
							break;
						}
						case 'w':
						{
							gboolean _tmp42_;
							_tmp42_ = vala_scanner_matches (begin, "switch");
							if (_tmp42_) {
								result = VALA_TOKEN_TYPE_SWITCH;
								return result;
							}
							break;
						}
					}
					break;
				}
				case 't':
				{
					switch (begin[1]) {
						case 'h':
						{
							gboolean _tmp43_;
							_tmp43_ = vala_scanner_matches (begin, "throws");
							if (_tmp43_) {
								result = VALA_TOKEN_TYPE_THROWS;
								return result;
							}
							break;
						}
						case 'y':
						{
							gboolean _tmp44_;
							_tmp44_ = vala_scanner_matches (begin, "typeof");
							if (_tmp44_) {
								result = VALA_TOKEN_TYPE_TYPEOF;
								return result;
							}
							break;
						}
					}
					break;
				}
			}
			break;
		}
		case 7:
		{
			switch (begin[0]) {
				case 'd':
				{
					switch (begin[1]) {
						case 'e':
						{
							gboolean _tmp45_;
							_tmp45_ = vala_scanner_matches (begin, "default");
							if (_tmp45_) {
								result = VALA_TOKEN_TYPE_DEFAULT;
								return result;
							}
							break;
						}
						case 'y':
						{
							gboolean _tmp46_;
							_tmp46_ = vala_scanner_matches (begin, "dynamic");
							if (_tmp46_) {
								result = VALA_TOKEN_TYPE_DYNAMIC;
								return result;
							}
							break;
						}
					}
					break;
				}
				case 'e':
				{
					gboolean _tmp47_;
					_tmp47_ = vala_scanner_matches (begin, "ensures");
					if (_tmp47_) {
						result = VALA_TOKEN_TYPE_ENSURES;
						return result;
					}
					break;
				}
				case 'f':
				{
					switch (begin[1]) {
						case 'i':
						{
							gboolean _tmp48_;
							_tmp48_ = vala_scanner_matches (begin, "finally");
							if (_tmp48_) {
								result = VALA_TOKEN_TYPE_FINALLY;
								return result;
							}
							break;
						}
						case 'o':
						{
							gboolean _tmp49_;
							_tmp49_ = vala_scanner_matches (begin, "foreach");
							if (_tmp49_) {
								result = VALA_TOKEN_TYPE_FOREACH;
								return result;
							}
							break;
						}
					}
					break;
				}
				case 'p':
				{
					gboolean _tmp50_;
					_tmp50_ = vala_scanner_matches (begin, "private");
					if (_tmp50_) {
						result = VALA_TOKEN_TYPE_PRIVATE;
						return result;
					}
					break;
				}
				case 'u':
				{
					gboolean _tmp51_;
					_tmp51_ = vala_scanner_matches (begin, "unowned");
					if (_tmp51_) {
						result = VALA_TOKEN_TYPE_UNOWNED;
						return result;
					}
					break;
				}
				case 'v':
				{
					gboolean _tmp52_;
					_tmp52_ = vala_scanner_matches (begin, "virtual");
					if (_tmp52_) {
						result = VALA_TOKEN_TYPE_VIRTUAL;
						return result;
					}
					break;
				}
			}
			break;
		}
		case 8:
		{
			switch (begin[0]) {
				case 'a':
				{
					gboolean _tmp53_;
					_tmp53_ = vala_scanner_matches (begin, "abstract");
					if (_tmp53_) {
						result = VALA_TOKEN_TYPE_ABSTRACT;
						return result;
					}
					break;
				}
				case 'c':
				{
					gboolean _tmp54_;
					_tmp54_ = vala_scanner_matches (begin, "continue");
					if (_tmp54_) {
						result = VALA_TOKEN_TYPE_CONTINUE;
						return result;
					}
					break;
				}
				case 'd':
				{
					gboolean _tmp55_;
					_tmp55_ = vala_scanner_matches (begin, "delegate");
					if (_tmp55_) {
						result = VALA_TOKEN_TYPE_DELEGATE;
						return result;
					}
					break;
				}
				case 'i':
				{
					gboolean _tmp56_;
					_tmp56_ = vala_scanner_matches (begin, "internal");
					if (_tmp56_) {
						result = VALA_TOKEN_TYPE_INTERNAL;
						return result;
					}
					break;
				}
				case 'o':
				{
					gboolean _tmp57_;
					_tmp57_ = vala_scanner_matches (begin, "override");
					if (_tmp57_) {
						result = VALA_TOKEN_TYPE_OVERRIDE;
						return result;
					}
					break;
				}
				case 'r':
				{
					gboolean _tmp58_;
					_tmp58_ = vala_scanner_matches (begin, "requires");
					if (_tmp58_) {
						result = VALA_TOKEN_TYPE_REQUIRES;
						return result;
					}
					break;
				}
				case 'v':
				{
					gboolean _tmp59_;
					_tmp59_ = vala_scanner_matches (begin, "volatile");
					if (_tmp59_) {
						result = VALA_TOKEN_TYPE_VOLATILE;
						return result;
					}
					break;
				}
			}
			break;
		}
		case 9:
		{
			switch (begin[0]) {
				case 'c':
				{
					gboolean _tmp60_;
					_tmp60_ = vala_scanner_matches (begin, "construct");
					if (_tmp60_) {
						result = VALA_TOKEN_TYPE_CONSTRUCT;
						return result;
					}
					break;
				}
				case 'i':
				{
					gboolean _tmp61_;
					_tmp61_ = vala_scanner_matches (begin, "interface");
					if (_tmp61_) {
						result = VALA_TOKEN_TYPE_INTERFACE;
						return result;
					}
					break;
				}
				case 'n':
				{
					gboolean _tmp62_;
					_tmp62_ = vala_scanner_matches (begin, "namespace");
					if (_tmp62_) {
						result = VALA_TOKEN_TYPE_NAMESPACE;
						return result;
					}
					break;
				}
				case 'p':
				{
					gboolean _tmp63_;
					_tmp63_ = vala_scanner_matches (begin, "protected");
					if (_tmp63_) {
						result = VALA_TOKEN_TYPE_PROTECTED;
						return result;
					}
					break;
				}
			}
			break;
		}
		case 11:
		{
			gboolean _tmp64_;
			_tmp64_ = vala_scanner_matches (begin, "errordomain");
			if (_tmp64_) {
				result = VALA_TOKEN_TYPE_ERRORDOMAIN;
				return result;
			}
			break;
		}
	}
	result = VALA_TOKEN_TYPE_IDENTIFIER;
	return result;
}


static ValaTokenType vala_scanner_read_number (ValaScanner* self) {
	ValaTokenType result = 0;
	ValaTokenType type;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp13_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	type = VALA_TOKEN_TYPE_INTEGER_LITERAL;
	if (self->priv->current < (self->priv->end - 2)) {
		_tmp2_ = self->priv->current[0] == '0';
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = self->priv->current[1] == 'x';
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp3_;
		_tmp3_ = g_ascii_isxdigit (self->priv->current[2]);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->current = self->priv->current + 2;
		while (TRUE) {
			gboolean _tmp4_ = FALSE;
			if (self->priv->current < self->priv->end) {
				gboolean _tmp5_;
				_tmp5_ = g_ascii_isxdigit (self->priv->current[0]);
				_tmp4_ = _tmp5_;
			} else {
				_tmp4_ = FALSE;
			}
			if (!_tmp4_) {
				break;
			}
			self->priv->current++;
		}
	} else {
		while (TRUE) {
			gboolean _tmp6_ = FALSE;
			if (self->priv->current < self->priv->end) {
				gboolean _tmp7_;
				_tmp7_ = g_ascii_isdigit (self->priv->current[0]);
				_tmp6_ = _tmp7_;
			} else {
				_tmp6_ = FALSE;
			}
			if (!_tmp6_) {
				break;
			}
			self->priv->current++;
		}
	}
	if (self->priv->current < (self->priv->end - 1)) {
		_tmp9_ = self->priv->current[0] == '.';
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gboolean _tmp10_;
		_tmp10_ = g_ascii_isdigit (self->priv->current[1]);
		_tmp8_ = _tmp10_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		type = VALA_TOKEN_TYPE_REAL_LITERAL;
		self->priv->current++;
		while (TRUE) {
			gboolean _tmp11_ = FALSE;
			if (self->priv->current < self->priv->end) {
				gboolean _tmp12_;
				_tmp12_ = g_ascii_isdigit (self->priv->current[0]);
				_tmp11_ = _tmp12_;
			} else {
				_tmp11_ = FALSE;
			}
			if (!_tmp11_) {
				break;
			}
			self->priv->current++;
		}
	}
	if (self->priv->current < self->priv->end) {
		gchar _tmp14_;
		_tmp14_ = g_ascii_tolower (self->priv->current[0]);
		_tmp13_ = _tmp14_ == 'e';
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gboolean _tmp15_ = FALSE;
		type = VALA_TOKEN_TYPE_REAL_LITERAL;
		self->priv->current++;
		if (self->priv->current < self->priv->end) {
			gboolean _tmp16_ = FALSE;
			if (self->priv->current[0] == '+') {
				_tmp16_ = TRUE;
			} else {
				_tmp16_ = self->priv->current[0] == '-';
			}
			_tmp15_ = _tmp16_;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			self->priv->current++;
		}
		while (TRUE) {
			gboolean _tmp17_ = FALSE;
			if (self->priv->current < self->priv->end) {
				gboolean _tmp18_;
				_tmp18_ = g_ascii_isdigit (self->priv->current[0]);
				_tmp17_ = _tmp18_;
			} else {
				_tmp17_ = FALSE;
			}
			if (!_tmp17_) {
				break;
			}
			self->priv->current++;
		}
	}
	if (self->priv->current < self->priv->end) {
		gboolean real_literal;
		gboolean _tmp25_ = FALSE;
		real_literal = type == VALA_TOKEN_TYPE_REAL_LITERAL;
		switch (self->priv->current[0]) {
			case 'l':
			case 'L':
			{
				if (type == VALA_TOKEN_TYPE_INTEGER_LITERAL) {
					gboolean _tmp19_ = FALSE;
					self->priv->current++;
					if (self->priv->current < self->priv->end) {
						gchar _tmp20_;
						_tmp20_ = g_ascii_tolower (self->priv->current[0]);
						_tmp19_ = _tmp20_ == 'l';
					} else {
						_tmp19_ = FALSE;
					}
					if (_tmp19_) {
						self->priv->current++;
					}
				}
				break;
			}
			case 'u':
			case 'U':
			{
				if (type == VALA_TOKEN_TYPE_INTEGER_LITERAL) {
					gboolean _tmp21_ = FALSE;
					self->priv->current++;
					if (self->priv->current < self->priv->end) {
						gchar _tmp22_;
						_tmp22_ = g_ascii_tolower (self->priv->current[0]);
						_tmp21_ = _tmp22_ == 'l';
					} else {
						_tmp21_ = FALSE;
					}
					if (_tmp21_) {
						gboolean _tmp23_ = FALSE;
						self->priv->current++;
						if (self->priv->current < self->priv->end) {
							gchar _tmp24_;
							_tmp24_ = g_ascii_tolower (self->priv->current[0]);
							_tmp23_ = _tmp24_ == 'l';
						} else {
							_tmp23_ = FALSE;
						}
						if (_tmp23_) {
							self->priv->current++;
						}
					}
				}
				break;
			}
			case 'f':
			case 'F':
			case 'd':
			case 'D':
			{
				type = VALA_TOKEN_TYPE_REAL_LITERAL;
				self->priv->current++;
				break;
			}
		}
		if (!real_literal) {
			gboolean _tmp26_;
			_tmp26_ = vala_scanner_is_ident_char (self, self->priv->current[0]);
			_tmp25_ = _tmp26_;
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			while (TRUE) {
				gboolean _tmp27_ = FALSE;
				if (self->priv->current < self->priv->end) {
					gboolean _tmp28_;
					_tmp28_ = vala_scanner_is_ident_char (self, self->priv->current[0]);
					_tmp27_ = _tmp28_;
				} else {
					_tmp27_ = FALSE;
				}
				if (!_tmp27_) {
					break;
				}
				self->priv->current++;
			}
			type = VALA_TOKEN_TYPE_IDENTIFIER;
		}
	}
	result = type;
	return result;
}


static void _vala_array_add14 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add15 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add16 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add17 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


ValaTokenType vala_scanner_read_template_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaSourceLocation _token_begin = {0};
	ValaSourceLocation _token_end = {0};
	ValaTokenType result = 0;
	ValaTokenType type = 0;
	gchar* begin;
	gint token_length_in_chars;
	g_return_val_if_fail (self != NULL, 0);
	begin = self->priv->current;
	_token_begin.pos = begin;
	_token_begin.line = self->priv->line;
	_token_begin.column = self->priv->column;
	token_length_in_chars = -1;
	if (self->priv->current >= self->priv->end) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		switch (self->priv->current[0]) {
			case '"':
			{
				type = VALA_TOKEN_TYPE_CLOSE_TEMPLATE;
				self->priv->current++;
				self->priv->state_stack_length1--;
				break;
			}
			case '$':
			{
				gboolean _tmp0_ = FALSE;
				gboolean _tmp1_;
				_token_begin.pos++;
				self->priv->current++;
				_tmp1_ = g_ascii_isalpha (self->priv->current[0]);
				if (_tmp1_) {
					_tmp0_ = TRUE;
				} else {
					_tmp0_ = self->priv->current[0] == '_';
				}
				if (_tmp0_) {
					gint len;
					len = 0;
					while (TRUE) {
						gboolean _tmp2_ = FALSE;
						if (self->priv->current < self->priv->end) {
							gboolean _tmp3_;
							_tmp3_ = vala_scanner_is_ident_char (self, self->priv->current[0]);
							_tmp2_ = _tmp3_;
						} else {
							_tmp2_ = FALSE;
						}
						if (!_tmp2_) {
							break;
						}
						self->priv->current++;
						len++;
					}
					type = VALA_TOKEN_TYPE_IDENTIFIER;
					_vala_array_add14 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
				} else {
					if (self->priv->current[0] == '(') {
						ValaSourceLocation _tmp4_ = {0};
						ValaSourceLocation _tmp5_ = {0};
						ValaTokenType _tmp6_;
						self->priv->current++;
						self->priv->column = self->priv->column + 2;
						_vala_array_add15 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_PARENS);
						_tmp6_ = vala_scanner_read_token (self, &_tmp4_, &_tmp5_);
						_token_begin = _tmp4_;
						_token_end = _tmp5_;
						result = _tmp6_;
						if (token_begin) {
							*token_begin = _token_begin;
						}
						if (token_end) {
							*token_end = _token_end;
						}
						return result;
					} else {
						if (self->priv->current[0] == '$') {
							type = VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
							self->priv->current++;
							_vala_array_add16 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
						} else {
							ValaSourceReference* _tmp7_ = NULL;
							ValaSourceReference* _tmp8_;
							ValaSourceLocation _tmp9_ = {0};
							ValaSourceLocation _tmp10_ = {0};
							ValaTokenType _tmp11_;
							_tmp7_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + 1, self->priv->line, self->priv->column + 1);
							_tmp8_ = _tmp7_;
							vala_report_error (_tmp8_, "unexpected character");
							_vala_source_reference_unref0 (_tmp8_);
							_tmp11_ = vala_scanner_read_template_token (self, &_tmp9_, &_tmp10_);
							_token_begin = _tmp9_;
							_token_end = _tmp10_;
							result = _tmp11_;
							if (token_begin) {
								*token_begin = _token_begin;
							}
							if (token_end) {
								*token_end = _token_end;
							}
							return result;
						}
					}
				}
				break;
			}
			default:
			{
				type = VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_ = FALSE;
					if (self->priv->current < self->priv->end) {
						_tmp13_ = self->priv->current[0] != '"';
					} else {
						_tmp13_ = FALSE;
					}
					if (_tmp13_) {
						_tmp12_ = self->priv->current[0] != '$';
					} else {
						_tmp12_ = FALSE;
					}
					if (!_tmp12_) {
						break;
					}
					if (self->priv->current[0] == '\\') {
						self->priv->current++;
						token_length_in_chars++;
						if (self->priv->current >= self->priv->end) {
							break;
						}
						switch (self->priv->current[0]) {
							case '\'':
							case '"':
							case '\\':
							case '0':
							case 'b':
							case 'f':
							case 'n':
							case 'r':
							case 't':
							{
								self->priv->current++;
								token_length_in_chars++;
								break;
							}
							case 'x':
							{
								self->priv->current++;
								token_length_in_chars++;
								while (TRUE) {
									gboolean _tmp14_ = FALSE;
									if (self->priv->current < self->priv->end) {
										gboolean _tmp15_;
										_tmp15_ = g_ascii_isxdigit (self->priv->current[0]);
										_tmp14_ = _tmp15_;
									} else {
										_tmp14_ = FALSE;
									}
									if (!_tmp14_) {
										break;
									}
									self->priv->current++;
									token_length_in_chars++;
								}
								break;
							}
							default:
							{
								ValaSourceReference* _tmp16_ = NULL;
								ValaSourceReference* _tmp17_;
								_tmp16_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
								_tmp17_ = _tmp16_;
								vala_report_error (_tmp17_, "invalid escape sequence");
								_vala_source_reference_unref0 (_tmp17_);
								break;
							}
						}
					} else {
						if (self->priv->current[0] == '\n') {
							self->priv->current++;
							self->priv->line++;
							self->priv->column = 1;
							token_length_in_chars = 1;
						} else {
							gunichar _tmp18_;
							gunichar u;
							_tmp18_ = g_utf8_get_char_validated ((const gchar*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
							u = _tmp18_;
							if (u != ((gunichar) (-1))) {
								gint _tmp19_;
								_tmp19_ = g_unichar_to_utf8 (u, NULL);
								self->priv->current = self->priv->current + _tmp19_;
								token_length_in_chars++;
							} else {
								ValaSourceReference* _tmp20_ = NULL;
								ValaSourceReference* _tmp21_;
								self->priv->current++;
								_tmp20_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
								_tmp21_ = _tmp20_;
								vala_report_error (_tmp21_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp21_);
							}
						}
					}
				}
				if (self->priv->current >= self->priv->end) {
					ValaSourceReference* _tmp22_ = NULL;
					ValaSourceReference* _tmp23_;
					ValaSourceLocation _tmp24_ = {0};
					ValaSourceLocation _tmp25_ = {0};
					ValaTokenType _tmp26_;
					_tmp22_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
					_tmp23_ = _tmp22_;
					vala_report_error (_tmp23_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp23_);
					self->priv->state_stack_length1--;
					_tmp26_ = vala_scanner_read_token (self, &_tmp24_, &_tmp25_);
					_token_begin = _tmp24_;
					_token_end = _tmp25_;
					result = _tmp26_;
					if (token_begin) {
						*token_begin = _token_begin;
					}
					if (token_end) {
						*token_end = _token_end;
					}
					return result;
				}
				_vala_array_add17 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
				break;
			}
		}
	}
	if (token_length_in_chars < 0) {
		self->priv->column = self->priv->column + ((gint) (self->priv->current - begin));
	} else {
		self->priv->column = self->priv->column + token_length_in_chars;
	}
	_token_end.pos = self->priv->current;
	_token_end.line = self->priv->line;
	_token_end.column = self->priv->column - 1;
	result = type;
	if (token_begin) {
		*token_begin = _token_begin;
	}
	if (token_end) {
		*token_end = _token_end;
	}
	return result;
}


static void _vala_array_add18 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add19 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add20 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add21 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add22 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add23 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


ValaTokenType vala_scanner_read_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaSourceLocation _token_begin = {0};
	ValaSourceLocation _token_end = {0};
	ValaTokenType result = 0;
	gboolean _tmp0_;
	ValaTokenType type = 0;
	gchar* begin;
	gint token_length_in_chars;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_scanner_in_template (self);
	if (_tmp0_) {
		ValaSourceLocation _tmp1_ = {0};
		ValaSourceLocation _tmp2_ = {0};
		ValaTokenType _tmp3_;
		_tmp3_ = vala_scanner_read_template_token (self, &_tmp1_, &_tmp2_);
		_token_begin = _tmp1_;
		_token_end = _tmp2_;
		result = _tmp3_;
		if (token_begin) {
			*token_begin = _token_begin;
		}
		if (token_end) {
			*token_end = _token_end;
		}
		return result;
	} else {
		gboolean _tmp4_;
		_tmp4_ = vala_scanner_in_template_part (self);
		if (_tmp4_) {
			self->priv->state_stack_length1--;
			_token_begin.pos = self->priv->current;
			_token_begin.line = self->priv->line;
			_token_begin.column = self->priv->column;
			_token_end.pos = self->priv->current;
			_token_end.line = self->priv->line;
			_token_end.column = self->priv->column - 1;
			result = VALA_TOKEN_TYPE_COMMA;
			if (token_begin) {
				*token_begin = _token_begin;
			}
			if (token_end) {
				*token_end = _token_end;
			}
			return result;
		} else {
			gboolean _tmp5_;
			_tmp5_ = vala_scanner_in_regex_literal (self);
			if (_tmp5_) {
				ValaSourceLocation _tmp6_ = {0};
				ValaSourceLocation _tmp7_ = {0};
				ValaTokenType _tmp8_;
				_tmp8_ = vala_scanner_read_regex_token (self, &_tmp6_, &_tmp7_);
				_token_begin = _tmp6_;
				_token_end = _tmp7_;
				result = _tmp8_;
				if (token_begin) {
					*token_begin = _token_begin;
				}
				if (token_end) {
					*token_end = _token_end;
				}
				return result;
			}
		}
	}
	vala_scanner_space (self);
	begin = self->priv->current;
	_token_begin.pos = begin;
	_token_begin.line = self->priv->line;
	_token_begin.column = self->priv->column;
	token_length_in_chars = -1;
	if (self->priv->current >= self->priv->end) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_;
		_tmp10_ = g_ascii_isalpha (self->priv->current[0]);
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = self->priv->current[0] == '_';
		}
		if (_tmp9_) {
			gint len;
			ValaTokenType _tmp13_;
			len = 0;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				if (self->priv->current < self->priv->end) {
					gboolean _tmp12_;
					_tmp12_ = vala_scanner_is_ident_char (self, self->priv->current[0]);
					_tmp11_ = _tmp12_;
				} else {
					_tmp11_ = FALSE;
				}
				if (!_tmp11_) {
					break;
				}
				self->priv->current++;
				len++;
			}
			_tmp13_ = vala_scanner_get_identifier_or_keyword (begin, len);
			type = _tmp13_;
		} else {
			gboolean _tmp14_ = FALSE;
			if (self->priv->current[0] == '@') {
				ValaCodeContext* _tmp15_ = NULL;
				ValaProfile _tmp16_;
				_tmp15_ = vala_source_file_get_context (self->priv->_source_file);
				_tmp16_ = vala_code_context_get_profile (_tmp15_);
				_tmp14_ = _tmp16_ != VALA_PROFILE_DOVA;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				gboolean _tmp17_ = FALSE;
				if (self->priv->current < (self->priv->end - 1)) {
					_tmp17_ = self->priv->current[1] == '"';
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					type = VALA_TOKEN_TYPE_OPEN_TEMPLATE;
					self->priv->current = self->priv->current + 2;
					_vala_array_add18 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE);
				} else {
					gint len;
					_token_begin.pos++;
					self->priv->current++;
					len = 0;
					while (TRUE) {
						gboolean _tmp18_ = FALSE;
						if (self->priv->current < self->priv->end) {
							gboolean _tmp19_;
							_tmp19_ = vala_scanner_is_ident_char (self, self->priv->current[0]);
							_tmp18_ = _tmp19_;
						} else {
							_tmp18_ = FALSE;
						}
						if (!_tmp18_) {
							break;
						}
						self->priv->current++;
						len++;
					}
					type = VALA_TOKEN_TYPE_IDENTIFIER;
				}
			} else {
				gboolean _tmp20_;
				_tmp20_ = g_ascii_isdigit (self->priv->current[0]);
				if (_tmp20_) {
					ValaTokenType _tmp21_;
					_tmp21_ = vala_scanner_read_number (self);
					type = _tmp21_;
				} else {
					switch (self->priv->current[0]) {
						case '{':
						{
							type = VALA_TOKEN_TYPE_OPEN_BRACE;
							self->priv->current++;
							_vala_array_add19 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_BRACE);
							break;
						}
						case '}':
						{
							type = VALA_TOKEN_TYPE_CLOSE_BRACE;
							self->priv->current++;
							if (self->priv->state_stack_length1 > 0) {
								self->priv->state_stack_length1--;
							}
							break;
						}
						case '(':
						{
							type = VALA_TOKEN_TYPE_OPEN_PARENS;
							self->priv->current++;
							_vala_array_add20 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_PARENS);
							break;
						}
						case ')':
						{
							gboolean _tmp22_;
							type = VALA_TOKEN_TYPE_CLOSE_PARENS;
							self->priv->current++;
							if (self->priv->state_stack_length1 > 0) {
								self->priv->state_stack_length1--;
							}
							_tmp22_ = vala_scanner_in_template (self);
							if (_tmp22_) {
								type = VALA_TOKEN_TYPE_COMMA;
							}
							break;
						}
						case '[':
						{
							type = VALA_TOKEN_TYPE_OPEN_BRACKET;
							self->priv->current++;
							_vala_array_add21 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_BRACKET);
							break;
						}
						case ']':
						{
							type = VALA_TOKEN_TYPE_CLOSE_BRACKET;
							self->priv->current++;
							if (self->priv->state_stack_length1 > 0) {
								self->priv->state_stack_length1--;
							}
							break;
						}
						case '.':
						{
							type = VALA_TOKEN_TYPE_DOT;
							self->priv->current++;
							if (self->priv->current < (self->priv->end - 1)) {
								gboolean _tmp23_ = FALSE;
								if (self->priv->current[0] == '.') {
									_tmp23_ = self->priv->current[1] == '.';
								} else {
									_tmp23_ = FALSE;
								}
								if (_tmp23_) {
									type = VALA_TOKEN_TYPE_ELLIPSIS;
									self->priv->current = self->priv->current + 2;
								}
							}
							break;
						}
						case ':':
						{
							gboolean _tmp24_ = FALSE;
							type = VALA_TOKEN_TYPE_COLON;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								_tmp24_ = self->priv->current[0] == ':';
							} else {
								_tmp24_ = FALSE;
							}
							if (_tmp24_) {
								type = VALA_TOKEN_TYPE_DOUBLE_COLON;
								self->priv->current++;
							}
							break;
						}
						case ',':
						{
							type = VALA_TOKEN_TYPE_COMMA;
							self->priv->current++;
							break;
						}
						case ';':
						{
							type = VALA_TOKEN_TYPE_SEMICOLON;
							self->priv->current++;
							break;
						}
						case '#':
						{
							type = VALA_TOKEN_TYPE_HASH;
							self->priv->current++;
							break;
						}
						case '?':
						{
							gboolean _tmp25_ = FALSE;
							type = VALA_TOKEN_TYPE_INTERR;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								_tmp25_ = self->priv->current[0] == '?';
							} else {
								_tmp25_ = FALSE;
							}
							if (_tmp25_) {
								type = VALA_TOKEN_TYPE_OP_COALESCING;
								self->priv->current++;
							}
							break;
						}
						case '|':
						{
							type = VALA_TOKEN_TYPE_BITWISE_OR;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								switch (self->priv->current[0]) {
									case '=':
									{
										type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR;
										self->priv->current++;
										break;
									}
									case '|':
									{
										type = VALA_TOKEN_TYPE_OP_OR;
										self->priv->current++;
										break;
									}
								}
							}
							break;
						}
						case '&':
						{
							type = VALA_TOKEN_TYPE_BITWISE_AND;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								switch (self->priv->current[0]) {
									case '=':
									{
										type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND;
										self->priv->current++;
										break;
									}
									case '&':
									{
										type = VALA_TOKEN_TYPE_OP_AND;
										self->priv->current++;
										break;
									}
								}
							}
							break;
						}
						case '^':
						{
							gboolean _tmp26_ = FALSE;
							type = VALA_TOKEN_TYPE_CARRET;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								_tmp26_ = self->priv->current[0] == '=';
							} else {
								_tmp26_ = FALSE;
							}
							if (_tmp26_) {
								type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR;
								self->priv->current++;
							}
							break;
						}
						case '~':
						{
							type = VALA_TOKEN_TYPE_TILDE;
							self->priv->current++;
							break;
						}
						case '=':
						{
							type = VALA_TOKEN_TYPE_ASSIGN;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								switch (self->priv->current[0]) {
									case '=':
									{
										type = VALA_TOKEN_TYPE_OP_EQ;
										self->priv->current++;
										break;
									}
									case '>':
									{
										type = VALA_TOKEN_TYPE_LAMBDA;
										self->priv->current++;
										break;
									}
								}
							}
							break;
						}
						case '<':
						{
							type = VALA_TOKEN_TYPE_OP_LT;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								switch (self->priv->current[0]) {
									case '=':
									{
										type = VALA_TOKEN_TYPE_OP_LE;
										self->priv->current++;
										break;
									}
									case '<':
									{
										gboolean _tmp27_ = FALSE;
										type = VALA_TOKEN_TYPE_OP_SHIFT_LEFT;
										self->priv->current++;
										if (self->priv->current < self->priv->end) {
											_tmp27_ = self->priv->current[0] == '=';
										} else {
											_tmp27_ = FALSE;
										}
										if (_tmp27_) {
											type = VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT;
											self->priv->current++;
										}
										break;
									}
								}
							}
							break;
						}
						case '>':
						{
							gboolean _tmp28_ = FALSE;
							type = VALA_TOKEN_TYPE_OP_GT;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								_tmp28_ = self->priv->current[0] == '=';
							} else {
								_tmp28_ = FALSE;
							}
							if (_tmp28_) {
								type = VALA_TOKEN_TYPE_OP_GE;
								self->priv->current++;
							}
							break;
						}
						case '!':
						{
							gboolean _tmp29_ = FALSE;
							type = VALA_TOKEN_TYPE_OP_NEG;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								_tmp29_ = self->priv->current[0] == '=';
							} else {
								_tmp29_ = FALSE;
							}
							if (_tmp29_) {
								type = VALA_TOKEN_TYPE_OP_NE;
								self->priv->current++;
							}
							break;
						}
						case '+':
						{
							type = VALA_TOKEN_TYPE_PLUS;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								switch (self->priv->current[0]) {
									case '=':
									{
										type = VALA_TOKEN_TYPE_ASSIGN_ADD;
										self->priv->current++;
										break;
									}
									case '+':
									{
										type = VALA_TOKEN_TYPE_OP_INC;
										self->priv->current++;
										break;
									}
								}
							}
							break;
						}
						case '-':
						{
							type = VALA_TOKEN_TYPE_MINUS;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								switch (self->priv->current[0]) {
									case '=':
									{
										type = VALA_TOKEN_TYPE_ASSIGN_SUB;
										self->priv->current++;
										break;
									}
									case '-':
									{
										type = VALA_TOKEN_TYPE_OP_DEC;
										self->priv->current++;
										break;
									}
									case '>':
									{
										type = VALA_TOKEN_TYPE_OP_PTR;
										self->priv->current++;
										break;
									}
								}
							}
							break;
						}
						case '*':
						{
							gboolean _tmp30_ = FALSE;
							type = VALA_TOKEN_TYPE_STAR;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								_tmp30_ = self->priv->current[0] == '=';
							} else {
								_tmp30_ = FALSE;
							}
							if (_tmp30_) {
								type = VALA_TOKEN_TYPE_ASSIGN_MUL;
								self->priv->current++;
							}
							break;
						}
						case '/':
						{
							switch (self->priv->previous) {
								case VALA_TOKEN_TYPE_ASSIGN:
								case VALA_TOKEN_TYPE_COMMA:
								case VALA_TOKEN_TYPE_MINUS:
								case VALA_TOKEN_TYPE_OP_AND:
								case VALA_TOKEN_TYPE_OP_COALESCING:
								case VALA_TOKEN_TYPE_OP_EQ:
								case VALA_TOKEN_TYPE_OP_GE:
								case VALA_TOKEN_TYPE_OP_GT:
								case VALA_TOKEN_TYPE_OP_LE:
								case VALA_TOKEN_TYPE_OP_LT:
								case VALA_TOKEN_TYPE_OP_NE:
								case VALA_TOKEN_TYPE_OP_NEG:
								case VALA_TOKEN_TYPE_OP_OR:
								case VALA_TOKEN_TYPE_OPEN_BRACE:
								case VALA_TOKEN_TYPE_OPEN_PARENS:
								case VALA_TOKEN_TYPE_PLUS:
								case VALA_TOKEN_TYPE_RETURN:
								{
									type = VALA_TOKEN_TYPE_OPEN_REGEX_LITERAL;
									_vala_array_add22 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_REGEX_LITERAL);
									self->priv->current++;
									break;
								}
								default:
								{
									gboolean _tmp31_ = FALSE;
									type = VALA_TOKEN_TYPE_DIV;
									self->priv->current++;
									if (self->priv->current < self->priv->end) {
										_tmp31_ = self->priv->current[0] == '=';
									} else {
										_tmp31_ = FALSE;
									}
									if (_tmp31_) {
										type = VALA_TOKEN_TYPE_ASSIGN_DIV;
										self->priv->current++;
									}
									break;
								}
							}
							break;
						}
						case '%':
						{
							gboolean _tmp32_ = FALSE;
							type = VALA_TOKEN_TYPE_PERCENT;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								_tmp32_ = self->priv->current[0] == '=';
							} else {
								_tmp32_ = FALSE;
							}
							if (_tmp32_) {
								type = VALA_TOKEN_TYPE_ASSIGN_PERCENT;
								self->priv->current++;
							}
							break;
						}
						case '\'':
						case '"':
						{
							if (begin[0] == '\'') {
								type = VALA_TOKEN_TYPE_CHARACTER_LITERAL;
							} else {
								gboolean _tmp33_ = FALSE;
								gboolean _tmp34_ = FALSE;
								if (self->priv->current < (self->priv->end - 6)) {
									_tmp34_ = begin[1] == '"';
								} else {
									_tmp34_ = FALSE;
								}
								if (_tmp34_) {
									_tmp33_ = begin[2] == '"';
								} else {
									_tmp33_ = FALSE;
								}
								if (_tmp33_) {
									gboolean _tmp42_ = FALSE;
									gboolean _tmp43_ = FALSE;
									type = VALA_TOKEN_TYPE_VERBATIM_STRING_LITERAL;
									token_length_in_chars = 6;
									self->priv->current = self->priv->current + 3;
									while (TRUE) {
										gboolean _tmp35_ = FALSE;
										gboolean _tmp36_ = FALSE;
										gboolean _tmp37_ = FALSE;
										if (!(self->priv->current < (self->priv->end - 4))) {
											break;
										}
										if (self->priv->current[0] == '"') {
											_tmp37_ = self->priv->current[1] == '"';
										} else {
											_tmp37_ = FALSE;
										}
										if (_tmp37_) {
											_tmp36_ = self->priv->current[2] == '"';
										} else {
											_tmp36_ = FALSE;
										}
										if (_tmp36_) {
											_tmp35_ = self->priv->current[3] != '"';
										} else {
											_tmp35_ = FALSE;
										}
										if (_tmp35_) {
											break;
										} else {
											if (self->priv->current[0] == '\n') {
												self->priv->current++;
												self->priv->line++;
												self->priv->column = 1;
												token_length_in_chars = 3;
											} else {
												gunichar _tmp38_;
												gunichar u;
												_tmp38_ = g_utf8_get_char_validated ((const gchar*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
												u = _tmp38_;
												if (u != ((gunichar) (-1))) {
													gint _tmp39_;
													_tmp39_ = g_unichar_to_utf8 (u, NULL);
													self->priv->current = self->priv->current + _tmp39_;
													token_length_in_chars++;
												} else {
													ValaSourceReference* _tmp40_ = NULL;
													ValaSourceReference* _tmp41_;
													_tmp40_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
													_tmp41_ = _tmp40_;
													vala_report_error (_tmp41_, "invalid UTF-8 character");
													_vala_source_reference_unref0 (_tmp41_);
												}
											}
										}
									}
									if (self->priv->current[0] == '"') {
										_tmp43_ = self->priv->current[1] == '"';
									} else {
										_tmp43_ = FALSE;
									}
									if (_tmp43_) {
										_tmp42_ = self->priv->current[2] == '"';
									} else {
										_tmp42_ = FALSE;
									}
									if (_tmp42_) {
										self->priv->current = self->priv->current + 3;
									} else {
										ValaSourceReference* _tmp44_ = NULL;
										ValaSourceReference* _tmp45_;
										_tmp44_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
										_tmp45_ = _tmp44_;
										vala_report_error (_tmp45_, "syntax error, expected \"\"\"");
										_vala_source_reference_unref0 (_tmp45_);
									}
									break;
								} else {
									type = VALA_TOKEN_TYPE_STRING_LITERAL;
								}
							}
							token_length_in_chars = 2;
							self->priv->current++;
							while (TRUE) {
								gboolean _tmp46_ = FALSE;
								gboolean _tmp59_ = FALSE;
								gboolean _tmp60_ = FALSE;
								if (self->priv->current < self->priv->end) {
									_tmp46_ = self->priv->current[0] != begin[0];
								} else {
									_tmp46_ = FALSE;
								}
								if (!_tmp46_) {
									break;
								}
								if (self->priv->current[0] == '\\') {
									self->priv->current++;
									token_length_in_chars++;
									if (self->priv->current >= self->priv->end) {
										break;
									}
									switch (self->priv->current[0]) {
										case '\'':
										case '"':
										case '\\':
										case '0':
										case 'b':
										case 'f':
										case 'n':
										case 'r':
										case 't':
										case '$':
										{
											self->priv->current++;
											token_length_in_chars++;
											break;
										}
										case 'x':
										{
											self->priv->current++;
											token_length_in_chars++;
											while (TRUE) {
												gboolean _tmp47_ = FALSE;
												if (self->priv->current < self->priv->end) {
													gboolean _tmp48_;
													_tmp48_ = g_ascii_isxdigit (self->priv->current[0]);
													_tmp47_ = _tmp48_;
												} else {
													_tmp47_ = FALSE;
												}
												if (!_tmp47_) {
													break;
												}
												self->priv->current++;
												token_length_in_chars++;
											}
											break;
										}
										default:
										{
											ValaSourceReference* _tmp49_ = NULL;
											ValaSourceReference* _tmp50_;
											_tmp49_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
											_tmp50_ = _tmp49_;
											vala_report_error (_tmp50_, "invalid escape sequence");
											_vala_source_reference_unref0 (_tmp50_);
											break;
										}
									}
								} else {
									if (self->priv->current[0] == '\n') {
										self->priv->current++;
										self->priv->line++;
										self->priv->column = 1;
										token_length_in_chars = 1;
									} else {
										gboolean _tmp51_ = FALSE;
										gboolean _tmp52_ = FALSE;
										gunichar _tmp55_;
										gunichar u;
										if (type == VALA_TOKEN_TYPE_STRING_LITERAL) {
											ValaCodeContext* _tmp53_ = NULL;
											ValaProfile _tmp54_;
											_tmp53_ = vala_source_file_get_context (self->priv->_source_file);
											_tmp54_ = vala_code_context_get_profile (_tmp53_);
											_tmp52_ = _tmp54_ == VALA_PROFILE_DOVA;
										} else {
											_tmp52_ = FALSE;
										}
										if (_tmp52_) {
											_tmp51_ = self->priv->current[0] == '$';
										} else {
											_tmp51_ = FALSE;
										}
										if (_tmp51_) {
											type = VALA_TOKEN_TYPE_OPEN_TEMPLATE;
											self->priv->current = begin;
											_vala_array_add23 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE);
											break;
										}
										_tmp55_ = g_utf8_get_char_validated ((const gchar*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
										u = _tmp55_;
										if (u != ((gunichar) (-1))) {
											gint _tmp56_;
											_tmp56_ = g_unichar_to_utf8 (u, NULL);
											self->priv->current = self->priv->current + _tmp56_;
											token_length_in_chars++;
										} else {
											ValaSourceReference* _tmp57_ = NULL;
											ValaSourceReference* _tmp58_;
											self->priv->current++;
											_tmp57_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
											_tmp58_ = _tmp57_;
											vala_report_error (_tmp58_, "invalid UTF-8 character");
											_vala_source_reference_unref0 (_tmp58_);
										}
									}
								}
								if (self->priv->current < self->priv->end) {
									_tmp60_ = begin[0] == '\'';
								} else {
									_tmp60_ = FALSE;
								}
								if (_tmp60_) {
									_tmp59_ = self->priv->current[0] != '\'';
								} else {
									_tmp59_ = FALSE;
								}
								if (_tmp59_) {
									ValaSourceReference* _tmp61_ = NULL;
									ValaSourceReference* _tmp62_;
									_tmp61_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
									_tmp62_ = _tmp61_;
									vala_report_error (_tmp62_, "invalid character literal");
									_vala_source_reference_unref0 (_tmp62_);
								}
							}
							if (self->priv->current < self->priv->end) {
								self->priv->current++;
							} else {
								ValaSourceReference* _tmp63_ = NULL;
								ValaSourceReference* _tmp64_;
								gchar* _tmp65_ = NULL;
								gchar* _tmp66_;
								_tmp63_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars);
								_tmp64_ = _tmp63_;
								_tmp65_ = g_strdup_printf ("syntax error, expected %c", (gint) begin[0]);
								_tmp66_ = _tmp65_;
								vala_report_error (_tmp64_, _tmp66_);
								_g_free0 (_tmp66_);
								_vala_source_reference_unref0 (_tmp64_);
							}
							break;
						}
						default:
						{
							gunichar _tmp67_;
							gunichar u;
							ValaSourceLocation _tmp73_ = {0};
							ValaSourceLocation _tmp74_ = {0};
							ValaTokenType _tmp75_;
							_tmp67_ = g_utf8_get_char_validated ((const gchar*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
							u = _tmp67_;
							if (u != ((gunichar) (-1))) {
								gint _tmp68_;
								ValaSourceReference* _tmp69_ = NULL;
								ValaSourceReference* _tmp70_;
								_tmp68_ = g_unichar_to_utf8 (u, NULL);
								self->priv->current = self->priv->current + _tmp68_;
								_tmp69_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
								_tmp70_ = _tmp69_;
								vala_report_error (_tmp70_, "syntax error, unexpected character");
								_vala_source_reference_unref0 (_tmp70_);
							} else {
								ValaSourceReference* _tmp71_ = NULL;
								ValaSourceReference* _tmp72_;
								self->priv->current++;
								_tmp71_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
								_tmp72_ = _tmp71_;
								vala_report_error (_tmp72_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp72_);
							}
							self->priv->column++;
							_tmp75_ = vala_scanner_read_token (self, &_tmp73_, &_tmp74_);
							_token_begin = _tmp73_;
							_token_end = _tmp74_;
							result = _tmp75_;
							if (token_begin) {
								*token_begin = _token_begin;
							}
							if (token_end) {
								*token_end = _token_end;
							}
							return result;
						}
					}
				}
			}
		}
	}
	if (token_length_in_chars < 0) {
		self->priv->column = self->priv->column + ((gint) (self->priv->current - begin));
	} else {
		self->priv->column = self->priv->column + token_length_in_chars;
	}
	_token_end.pos = self->priv->current;
	_token_end.line = self->priv->line;
	_token_end.column = self->priv->column - 1;
	self->priv->previous = type;
	result = type;
	if (token_begin) {
		*token_begin = _token_begin;
	}
	if (token_end) {
		*token_end = _token_end;
	}
	return result;
}


static gboolean vala_scanner_matches (gchar* begin, const gchar* keyword) {
	gboolean result = FALSE;
	gchar* keyword_array;
	glong _tmp0_;
	glong len;
	g_return_val_if_fail (keyword != NULL, FALSE);
	keyword_array = (gchar*) keyword;
	_tmp0_ = strlen (keyword);
	len = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				if (!(i < len)) {
					break;
				}
				if (begin[i] != keyword_array[i]) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean vala_scanner_pp_whitespace (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (self->priv->current < self->priv->end) {
			gboolean _tmp2_;
			_tmp2_ = g_ascii_isspace (self->priv->current[0]);
			_tmp1_ = _tmp2_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = self->priv->current[0] != '\n';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		found = TRUE;
		self->priv->current++;
		self->priv->column++;
	}
	result = found;
	return result;
}


static void vala_scanner_pp_directive (ValaScanner* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* begin;
	gint len;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp16_ = FALSE;
	g_return_if_fail (self != NULL);
	self->priv->current++;
	self->priv->column++;
	if (self->priv->line == 1) {
		_tmp2_ = self->priv->column == 2;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = self->priv->current < self->priv->end;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->priv->current[0] == '!';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		while (TRUE) {
			gboolean _tmp3_ = FALSE;
			if (self->priv->current < self->priv->end) {
				_tmp3_ = self->priv->current[0] != '\n';
			} else {
				_tmp3_ = FALSE;
			}
			if (!_tmp3_) {
				break;
			}
			self->priv->current++;
		}
		return;
	}
	vala_scanner_pp_whitespace (self);
	begin = self->priv->current;
	len = 0;
	while (TRUE) {
		gboolean _tmp4_ = FALSE;
		if (self->priv->current < self->priv->end) {
			gboolean _tmp5_;
			_tmp5_ = g_ascii_isalnum (self->priv->current[0]);
			_tmp4_ = _tmp5_;
		} else {
			_tmp4_ = FALSE;
		}
		if (!_tmp4_) {
			break;
		}
		self->priv->current++;
		self->priv->column++;
		len++;
	}
	if (len == 2) {
		gboolean _tmp7_;
		_tmp7_ = vala_scanner_matches (begin, "if");
		_tmp6_ = _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		vala_scanner_parse_pp_if (self);
	} else {
		gboolean _tmp8_ = FALSE;
		if (len == 4) {
			gboolean _tmp9_;
			_tmp9_ = vala_scanner_matches (begin, "elif");
			_tmp8_ = _tmp9_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			vala_scanner_parse_pp_elif (self);
		} else {
			gboolean _tmp10_ = FALSE;
			if (len == 4) {
				gboolean _tmp11_;
				_tmp11_ = vala_scanner_matches (begin, "else");
				_tmp10_ = _tmp11_;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				vala_scanner_parse_pp_else (self);
			} else {
				gboolean _tmp12_ = FALSE;
				if (len == 5) {
					gboolean _tmp13_;
					_tmp13_ = vala_scanner_matches (begin, "endif");
					_tmp12_ = _tmp13_;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					vala_scanner_parse_pp_endif (self);
				} else {
					ValaSourceReference* _tmp14_ = NULL;
					ValaSourceReference* _tmp15_;
					_tmp14_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column - len, self->priv->line, self->priv->column);
					_tmp15_ = _tmp14_;
					vala_report_error (_tmp15_, "syntax error, invalid preprocessing directive");
					_vala_source_reference_unref0 (_tmp15_);
				}
			}
		}
	}
	if (self->priv->conditional_stack_length1 > 0) {
		_tmp16_ = self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].skip_section;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		gboolean bol;
		bol = FALSE;
		while (TRUE) {
			gboolean _tmp17_ = FALSE;
			if (!(self->priv->current < self->priv->end)) {
				break;
			}
			if (bol) {
				_tmp17_ = self->priv->current[0] == '#';
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				self->priv->current = self->priv->current - (self->priv->column - 1);
				self->priv->column = 1;
				return;
			}
			if (self->priv->current[0] == '\n') {
				self->priv->line++;
				self->priv->column = 0;
				bol = TRUE;
			} else {
				gboolean _tmp18_;
				_tmp18_ = g_ascii_isspace (self->priv->current[0]);
				if (!_tmp18_) {
					bol = FALSE;
				}
			}
			self->priv->current++;
			self->priv->column++;
		}
	}
}


static void vala_scanner_pp_eol (ValaScanner* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_whitespace (self);
	if (self->priv->current >= self->priv->end) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->current[0] != '\n';
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp1_ = NULL;
		ValaSourceReference* _tmp2_;
		_tmp1_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
		_tmp2_ = _tmp1_;
		vala_report_error (_tmp2_, "syntax error, expected newline");
		_vala_source_reference_unref0 (_tmp2_);
	}
}


static void _vala_array_add24 (ValaScannerConditional** array, int* length, int* size, const ValaScannerConditional* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerConditional, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void vala_scanner_parse_pp_if (ValaScanner* self) {
	gboolean _tmp0_;
	gboolean condition;
	ValaScannerConditional _tmp1_ = {0};
	ValaScannerConditional _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_whitespace (self);
	_tmp0_ = vala_scanner_parse_pp_expression (self);
	condition = _tmp0_;
	vala_scanner_pp_eol (self);
	memset (&_tmp1_, 0, sizeof (ValaScannerConditional));
	_tmp2_ = _tmp1_;
	_vala_array_add24 (&self->priv->conditional_stack, &self->priv->conditional_stack_length1, &self->priv->_conditional_stack_size_, &_tmp2_);
	if (condition) {
		gboolean _tmp4_ = FALSE;
		if (self->priv->conditional_stack_length1 == 1) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = !self->priv->conditional_stack[self->priv->conditional_stack_length1 - 2].skip_section;
		}
		_tmp3_ = _tmp4_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].matched = TRUE;
	} else {
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].skip_section = TRUE;
	}
}


static void vala_scanner_parse_pp_elif (ValaScanner* self) {
	gboolean _tmp0_;
	gboolean condition;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_whitespace (self);
	_tmp0_ = vala_scanner_parse_pp_expression (self);
	condition = _tmp0_;
	vala_scanner_pp_eol (self);
	if (self->priv->conditional_stack_length1 == 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].else_found;
	}
	if (_tmp1_) {
		ValaSourceReference* _tmp2_ = NULL;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "syntax error, unexpected #elif");
		_vala_source_reference_unref0 (_tmp3_);
		return;
	}
	if (condition) {
		_tmp5_ = !self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].matched;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gboolean _tmp6_ = FALSE;
		if (self->priv->conditional_stack_length1 == 1) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = !self->priv->conditional_stack[self->priv->conditional_stack_length1 - 2].skip_section;
		}
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].matched = TRUE;
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].skip_section = FALSE;
	} else {
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].skip_section = TRUE;
	}
}


static void vala_scanner_parse_pp_else (ValaScanner* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_eol (self);
	if (self->priv->conditional_stack_length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].else_found;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp1_ = NULL;
		ValaSourceReference* _tmp2_;
		_tmp1_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
		_tmp2_ = _tmp1_;
		vala_report_error (_tmp2_, "syntax error, unexpected #else");
		_vala_source_reference_unref0 (_tmp2_);
		return;
	}
	if (!self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].matched) {
		gboolean _tmp4_ = FALSE;
		if (self->priv->conditional_stack_length1 == 1) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = !self->priv->conditional_stack[self->priv->conditional_stack_length1 - 2].skip_section;
		}
		_tmp3_ = _tmp4_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].matched = TRUE;
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].skip_section = FALSE;
	} else {
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].skip_section = TRUE;
	}
}


static void vala_scanner_parse_pp_endif (ValaScanner* self) {
	g_return_if_fail (self != NULL);
	vala_scanner_pp_eol (self);
	if (self->priv->conditional_stack_length1 == 0) {
		ValaSourceReference* _tmp0_ = NULL;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
		_tmp1_ = _tmp0_;
		vala_report_error (_tmp1_, "syntax error, unexpected #endif");
		_vala_source_reference_unref0 (_tmp1_);
		return;
	}
	self->priv->conditional_stack_length1--;
}


static gboolean vala_scanner_parse_pp_symbol (ValaScanner* self) {
	gboolean result = FALSE;
	gint len;
	gchar* _tmp4_ = NULL;
	gchar* identifier;
	gboolean defined = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	len = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (self->priv->current < self->priv->end) {
			gboolean _tmp1_;
			_tmp1_ = vala_scanner_is_ident_char (self, self->priv->current[0]);
			_tmp0_ = _tmp1_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		self->priv->current++;
		self->priv->column++;
		len++;
	}
	if (len == 0) {
		ValaSourceReference* _tmp2_ = NULL;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp3_);
		result = FALSE;
		return result;
	}
	_tmp4_ = g_strndup ((const gchar*) (self->priv->current - len), (gsize) len);
	identifier = _tmp4_;
	if (g_strcmp0 (identifier, "true") == 0) {
		defined = TRUE;
	} else {
		if (g_strcmp0 (identifier, "false") == 0) {
			defined = FALSE;
		} else {
			ValaCodeContext* _tmp5_ = NULL;
			gboolean _tmp6_;
			_tmp5_ = vala_source_file_get_context (self->priv->_source_file);
			_tmp6_ = vala_code_context_is_defined (_tmp5_, identifier);
			defined = _tmp6_;
		}
	}
	result = defined;
	_g_free0 (identifier);
	return result;
}


static gboolean vala_scanner_parse_pp_primary_expression (ValaScanner* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->current >= self->priv->end) {
		ValaSourceReference* _tmp0_ = NULL;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
		_tmp1_ = _tmp0_;
		vala_report_error (_tmp1_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp1_);
	} else {
		gboolean _tmp2_;
		_tmp2_ = vala_scanner_is_ident_char (self, self->priv->current[0]);
		if (_tmp2_) {
			gboolean _tmp3_;
			_tmp3_ = vala_scanner_parse_pp_symbol (self);
			result = _tmp3_;
			return result;
		} else {
			if (self->priv->current[0] == '(') {
				gboolean _tmp4_;
				gboolean _result_;
				gboolean _tmp5_ = FALSE;
				self->priv->current++;
				self->priv->column++;
				vala_scanner_pp_whitespace (self);
				_tmp4_ = vala_scanner_parse_pp_expression (self);
				_result_ = _tmp4_;
				vala_scanner_pp_whitespace (self);
				if (self->priv->current < self->priv->end) {
					_tmp5_ = self->priv->current[0] == ')';
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					self->priv->current++;
					self->priv->column++;
				} else {
					ValaSourceReference* _tmp6_ = NULL;
					ValaSourceReference* _tmp7_;
					_tmp6_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
					_tmp7_ = _tmp6_;
					vala_report_error (_tmp7_, "syntax error, expected `)'");
					_vala_source_reference_unref0 (_tmp7_);
				}
				result = _result_;
				return result;
			} else {
				ValaSourceReference* _tmp8_ = NULL;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "syntax error, expected identifier");
				_vala_source_reference_unref0 (_tmp9_);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean vala_scanner_parse_pp_unary_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->current < self->priv->end) {
		_tmp0_ = self->priv->current[0] == '!';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp1_;
		self->priv->current++;
		self->priv->column++;
		vala_scanner_pp_whitespace (self);
		_tmp1_ = vala_scanner_parse_pp_unary_expression (self);
		result = !_tmp1_;
		return result;
	}
	_tmp2_ = vala_scanner_parse_pp_primary_expression (self);
	result = _tmp2_;
	return result;
}


static gboolean vala_scanner_parse_pp_equality_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean left;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_scanner_parse_pp_unary_expression (self);
	left = _tmp0_;
	vala_scanner_pp_whitespace (self);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		if (self->priv->current < (self->priv->end - 1)) {
			_tmp2_ = self->priv->current[0] == '=';
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = self->priv->current[1] == '=';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gboolean _tmp3_;
			gboolean right;
			self->priv->current = self->priv->current + 2;
			self->priv->column = self->priv->column + 2;
			vala_scanner_pp_whitespace (self);
			_tmp3_ = vala_scanner_parse_pp_unary_expression (self);
			right = _tmp3_;
			left = left == right;
		} else {
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			if (self->priv->current < (self->priv->end - 1)) {
				_tmp5_ = self->priv->current[0] == '!';
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				_tmp4_ = self->priv->current[1] == '=';
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				gboolean _tmp6_;
				gboolean right;
				self->priv->current = self->priv->current + 2;
				self->priv->column = self->priv->column + 2;
				vala_scanner_pp_whitespace (self);
				_tmp6_ = vala_scanner_parse_pp_unary_expression (self);
				right = _tmp6_;
				left = left != right;
			} else {
				break;
			}
		}
	}
	result = left;
	return result;
}


static gboolean vala_scanner_parse_pp_and_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean left;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_scanner_parse_pp_equality_expression (self);
	left = _tmp0_;
	vala_scanner_pp_whitespace (self);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		gboolean right;
		gboolean _tmp4_ = FALSE;
		if (self->priv->current < (self->priv->end - 1)) {
			_tmp2_ = self->priv->current[0] == '&';
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = self->priv->current[1] == '&';
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		self->priv->current = self->priv->current + 2;
		self->priv->column = self->priv->column + 2;
		vala_scanner_pp_whitespace (self);
		_tmp3_ = vala_scanner_parse_pp_equality_expression (self);
		right = _tmp3_;
		if (left) {
			_tmp4_ = right;
		} else {
			_tmp4_ = FALSE;
		}
		left = _tmp4_;
	}
	result = left;
	return result;
}


static gboolean vala_scanner_parse_pp_or_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean left;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_scanner_parse_pp_and_expression (self);
	left = _tmp0_;
	vala_scanner_pp_whitespace (self);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		gboolean right;
		gboolean _tmp4_ = FALSE;
		if (self->priv->current < (self->priv->end - 1)) {
			_tmp2_ = self->priv->current[0] == '|';
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = self->priv->current[1] == '|';
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		self->priv->current = self->priv->current + 2;
		self->priv->column = self->priv->column + 2;
		vala_scanner_pp_whitespace (self);
		_tmp3_ = vala_scanner_parse_pp_and_expression (self);
		right = _tmp3_;
		if (left) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = right;
		}
		left = _tmp4_;
	}
	result = left;
	return result;
}


static gboolean vala_scanner_parse_pp_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_scanner_parse_pp_or_expression (self);
	result = _tmp0_;
	return result;
}


static gboolean vala_scanner_whitespace (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean found;
	gboolean bol;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	bol = self->priv->column == 1;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (self->priv->current < self->priv->end) {
			gboolean _tmp1_;
			_tmp1_ = g_ascii_isspace (self->priv->current[0]);
			_tmp0_ = _tmp1_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		if (self->priv->current[0] == '\n') {
			self->priv->line++;
			self->priv->column = 0;
			bol = TRUE;
		}
		found = TRUE;
		self->priv->current++;
		self->priv->column++;
	}
	if (bol) {
		_tmp3_ = self->priv->current < self->priv->end;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = self->priv->current[0] == '#';
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		vala_scanner_pp_directive (self);
		result = TRUE;
		return result;
	}
	result = found;
	return result;
}


static gboolean vala_scanner_comment (ValaScanner* self, gboolean file_comment) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->current == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = self->priv->current > (self->priv->end - 2);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->current[0] != '/';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		if (self->priv->current[1] != '/') {
			_tmp3_ = self->priv->current[1] != '*';
		} else {
			_tmp3_ = FALSE;
		}
		_tmp0_ = _tmp3_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (self->priv->current[1] == '/') {
		ValaSourceReference* source_reference;
		gchar* begin;
		source_reference = NULL;
		if (file_comment) {
			ValaSourceReference* _tmp4_ = NULL;
			ValaSourceReference* _tmp5_;
			_tmp4_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
			_tmp5_ = _tmp4_;
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp5_;
		}
		self->priv->current = self->priv->current + 2;
		begin = self->priv->current;
		while (TRUE) {
			gboolean _tmp6_ = FALSE;
			if (self->priv->current < self->priv->end) {
				_tmp6_ = self->priv->current[0] != '\n';
			} else {
				_tmp6_ = FALSE;
			}
			if (!_tmp6_) {
				break;
			}
			self->priv->current++;
		}
		if (source_reference != NULL) {
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			_tmp7_ = g_strndup ((const gchar*) begin, (gsize) ((glong) (self->priv->current - begin)));
			_tmp8_ = _tmp7_;
			vala_scanner_push_comment (self, _tmp8_, source_reference, file_comment);
			_g_free0 (_tmp8_);
		}
		_vala_source_reference_unref0 (source_reference);
	} else {
		ValaSourceReference* source_reference;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gchar* begin;
		source_reference = NULL;
		if (file_comment) {
			_tmp9_ = self->priv->current[2] == '*';
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			result = FALSE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		if (self->priv->current[2] == '*') {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = file_comment;
		}
		if (_tmp10_) {
			ValaSourceReference* _tmp11_ = NULL;
			ValaSourceReference* _tmp12_;
			_tmp11_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
			_tmp12_ = _tmp11_;
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp12_;
		}
		self->priv->current = self->priv->current + 2;
		begin = self->priv->current;
		while (TRUE) {
			gboolean _tmp13_ = FALSE;
			if (self->priv->current < (self->priv->end - 1)) {
				gboolean _tmp14_ = FALSE;
				if (self->priv->current[0] != '*') {
					_tmp14_ = TRUE;
				} else {
					_tmp14_ = self->priv->current[1] != '/';
				}
				_tmp13_ = _tmp14_;
			} else {
				_tmp13_ = FALSE;
			}
			if (!_tmp13_) {
				break;
			}
			if (self->priv->current[0] == '\n') {
				self->priv->line++;
				self->priv->column = 0;
			}
			self->priv->current++;
			self->priv->column++;
		}
		if (self->priv->current == (self->priv->end - 1)) {
			ValaSourceReference* _tmp15_ = NULL;
			ValaSourceReference* _tmp16_;
			_tmp15_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column);
			_tmp16_ = _tmp15_;
			vala_report_error (_tmp16_, "syntax error, expected */");
			_vala_source_reference_unref0 (_tmp16_);
			result = TRUE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		if (source_reference != NULL) {
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			_tmp17_ = g_strndup ((const gchar*) begin, (gsize) ((glong) (self->priv->current - begin)));
			_tmp18_ = _tmp17_;
			vala_scanner_push_comment (self, _tmp18_, source_reference, file_comment);
			_g_free0 (_tmp18_);
		}
		self->priv->current = self->priv->current + 2;
		self->priv->column = self->priv->column + 2;
		_vala_source_reference_unref0 (source_reference);
	}
	result = TRUE;
	return result;
}


static void vala_scanner_space (ValaScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		_tmp1_ = vala_scanner_whitespace (self);
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_;
			_tmp2_ = vala_scanner_comment (self, FALSE);
			_tmp0_ = _tmp2_;
		}
		if (!_tmp0_) {
			break;
		}
	}
}


void vala_scanner_parse_file_comments (ValaScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		_tmp1_ = vala_scanner_whitespace (self);
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_;
			_tmp2_ = vala_scanner_comment (self, TRUE);
			_tmp0_ = _tmp2_;
		}
		if (!_tmp0_) {
			break;
		}
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static void vala_scanner_push_comment (ValaScanner* self, const gchar* comment_item, ValaSourceReference* source_reference, gboolean file_comment) {
	gchar _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment_item != NULL);
	g_return_if_fail (source_reference != NULL);
	_tmp0_ = string_get (comment_item, (glong) 0);
	if (_tmp0_ == '*') {
		ValaComment* _tmp1_ = NULL;
		ValaComment* _tmp2_;
		if (self->priv->_comment != NULL) {
			vala_source_file_add_comment (self->priv->_source_file, self->priv->_comment);
		}
		_tmp1_ = vala_comment_new (comment_item, source_reference);
		_tmp2_ = _tmp1_;
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = _tmp2_;
	}
	if (file_comment) {
		ValaComment* _tmp3_ = NULL;
		ValaComment* _tmp4_;
		ValaComment* _tmp5_;
		_tmp3_ = vala_comment_new (comment_item, source_reference);
		_tmp4_ = _tmp3_;
		vala_source_file_add_comment (self->priv->_source_file, _tmp4_);
		_vala_comment_unref0 (_tmp4_);
		_tmp5_ = NULL;
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = _tmp5_;
	}
}


/**
 * Clears and returns the content of the comment stack.
 *
 * @return saved comment
 */
static gpointer _vala_comment_ref0 (gpointer self) {
	return self ? vala_comment_ref (self) : NULL;
}


ValaComment* vala_scanner_pop_comment (ValaScanner* self) {
	ValaComment* result = NULL;
	ValaComment* _tmp0_;
	ValaComment* comment;
	ValaComment* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_comment == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = _vala_comment_ref0 (self->priv->_comment);
	comment = _tmp0_;
	_tmp1_ = NULL;
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->_comment = _tmp1_;
	result = comment;
	return result;
}


ValaSourceFile* vala_scanner_get_source_file (ValaScanner* self) {
	ValaSourceFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_source_file;
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static void vala_scanner_set_source_file (ValaScanner* self, ValaSourceFile* value) {
	ValaSourceFile* _tmp0_;
	ValaSourceFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_source_file_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_source_file_unref0 (self->priv->_source_file);
	self->priv->_source_file = _tmp1_;
}


static void vala_scanner_conditional_copy (const ValaScannerConditional* self, ValaScannerConditional* dest) {
	dest->matched = self->matched;
	dest->else_found = self->else_found;
	dest->skip_section = self->skip_section;
}


static void vala_scanner_conditional_destroy (ValaScannerConditional* self) {
}


static ValaScannerConditional* vala_scanner_conditional_dup (const ValaScannerConditional* self) {
	ValaScannerConditional* dup;
	dup = g_new0 (ValaScannerConditional, 1);
	vala_scanner_conditional_copy (self, dup);
	return dup;
}


static void vala_scanner_conditional_free (ValaScannerConditional* self) {
	vala_scanner_conditional_destroy (self);
	g_free (self);
}


static GType vala_scanner_conditional_get_type (void) {
	static volatile gsize vala_scanner_conditional_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_conditional_type_id__volatile)) {
		GType vala_scanner_conditional_type_id;
		vala_scanner_conditional_type_id = g_boxed_type_register_static ("ValaScannerConditional", (GBoxedCopyFunc) vala_scanner_conditional_dup, (GBoxedFreeFunc) vala_scanner_conditional_free);
		g_once_init_leave (&vala_scanner_conditional_type_id__volatile, vala_scanner_conditional_type_id);
	}
	return vala_scanner_conditional_type_id__volatile;
}


static void vala_value_scanner_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_scanner_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_scanner_unref (value->data[0].v_pointer);
	}
}


static void vala_value_scanner_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_scanner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_scanner_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_scanner_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaScanner* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_scanner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_scanner_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaScanner** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_scanner_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecScanner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_SCANNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_scanner (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_scanner (GValue* value, gpointer v_object) {
	ValaScanner* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_scanner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_scanner_unref (old);
	}
}


void vala_value_take_scanner (GValue* value, gpointer v_object) {
	ValaScanner* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_scanner_unref (old);
	}
}


static void vala_scanner_class_init (ValaScannerClass * klass) {
	vala_scanner_parent_class = g_type_class_peek_parent (klass);
	VALA_SCANNER_CLASS (klass)->finalize = vala_scanner_finalize;
	g_type_class_add_private (klass, sizeof (ValaScannerPrivate));
}


static void vala_scanner_instance_init (ValaScanner * self) {
	self->priv = VALA_SCANNER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_scanner_finalize (ValaScanner* obj) {
	ValaScanner * self;
	self = VALA_SCANNER (obj);
	_vala_source_file_unref0 (self->priv->_source_file);
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
}


/**
 * Lexical scanner for Vala source files.
 */
GType vala_scanner_get_type (void) {
	static volatile gsize vala_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_scanner_init, vala_value_scanner_free_value, vala_value_scanner_copy_value, vala_value_scanner_peek_pointer, "p", vala_value_scanner_collect_value, "p", vala_value_scanner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaScanner), 0, (GInstanceInitFunc) vala_scanner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_scanner_type_id;
		vala_scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaScanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_scanner_type_id__volatile, vala_scanner_type_id);
	}
	return vala_scanner_type_id__volatile;
}


gpointer vala_scanner_ref (gpointer instance) {
	ValaScanner* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_scanner_unref (gpointer instance) {
	ValaScanner* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_SCANNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



