/* valadelegate.c generated by valac, the Vala compiler
 * generated from valadelegate.vala, do not modify */

/* valadelegate.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;
typedef struct _ValaTypeSymbolPrivate ValaTypeSymbolPrivate;
typedef struct _ValaDelegatePrivate ValaDelegatePrivate;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;

#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameter ValaFormalParameter;
typedef struct _ValaFormalParameterClass ValaFormalParameterClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_MEMBER_ACCESS (vala_member_access_get_type ())
#define VALA_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess))
#define VALA_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))
#define VALA_IS_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_ACCESS))
#define VALA_IS_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_ACCESS))
#define VALA_MEMBER_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))

typedef struct _ValaMemberAccess ValaMemberAccess;
typedef struct _ValaMemberAccessClass ValaMemberAccessClass;
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

#define VALA_TYPE_MEMBER_BINDING (vala_member_binding_get_type ())

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_PARAMETER_DIRECTION (vala_parameter_direction_get_type ())

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	gchar* (*get_cprefix) (ValaSymbol* self);
	gchar* (*get_lower_case_cname) (ValaSymbol* self, const gchar* infix);
	gchar* (*get_lower_case_cprefix) (ValaSymbol* self);
	ValaList* (*get_cheader_filenames) (ValaSymbol* self);
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*process_deprecated_attribute) (ValaSymbol* self, ValaAttribute* attr);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

struct _ValaTypeSymbol {
	ValaSymbol parent_instance;
	ValaTypeSymbolPrivate * priv;
};

struct _ValaTypeSymbolClass {
	ValaSymbolClass parent_class;
	gchar* (*get_cname) (ValaTypeSymbol* self, gboolean const_type);
	gboolean (*is_reference_type) (ValaTypeSymbol* self);
	gchar* (*get_dup_function) (ValaTypeSymbol* self);
	gchar* (*get_free_function) (ValaTypeSymbol* self);
	gchar* (*get_copy_function) (ValaTypeSymbol* self);
	gchar* (*get_destroy_function) (ValaTypeSymbol* self);
	gboolean (*is_reference_counting) (ValaTypeSymbol* self);
	gchar* (*get_ref_function) (ValaTypeSymbol* self);
	gchar* (*get_unref_function) (ValaTypeSymbol* self);
	gchar* (*get_ref_sink_function) (ValaTypeSymbol* self);
	gchar* (*get_type_id) (ValaTypeSymbol* self);
	gchar* (*get_marshaller_type_name) (ValaTypeSymbol* self);
	gchar* (*get_param_spec_function) (ValaTypeSymbol* self);
	gchar* (*get_get_value_function) (ValaTypeSymbol* self);
	gchar* (*get_set_value_function) (ValaTypeSymbol* self);
	gchar* (*get_take_value_function) (ValaTypeSymbol* self);
	gchar* (*get_upper_case_cname) (ValaTypeSymbol* self, const gchar* infix);
	gchar* (*get_default_value) (ValaTypeSymbol* self);
	gboolean (*is_subtype_of) (ValaTypeSymbol* self, ValaTypeSymbol* t);
	gint (*get_type_parameter_index) (ValaTypeSymbol* self, const gchar* name);
};

struct _ValaDelegate {
	ValaTypeSymbol parent_instance;
	ValaDelegatePrivate * priv;
};

struct _ValaDelegateClass {
	ValaTypeSymbolClass parent_class;
};

struct _ValaDelegatePrivate {
	gboolean _has_target;
	ValaDataType* _sender_type;
	gdouble _cinstance_parameter_position;
	gdouble _carray_length_parameter_position;
	gdouble _cdelegate_target_parameter_position;
	gboolean _no_array_length;
	gboolean _array_null_terminated;
	ValaList* type_parameters;
	ValaList* parameters;
	gchar* cname;
	ValaDataType* _return_type;
};

typedef enum  {
	VALA_MEMBER_BINDING_INSTANCE,
	VALA_MEMBER_BINDING_CLASS,
	VALA_MEMBER_BINDING_STATIC
} ValaMemberBinding;

typedef enum  {
	VALA_PARAMETER_DIRECTION_IN,
	VALA_PARAMETER_DIRECTION_OUT,
	VALA_PARAMETER_DIRECTION_REF
} ValaParameterDirection;


static gpointer vala_delegate_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_local_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
GType vala_typeparameter_get_type (void) G_GNUC_CONST;
GType vala_formal_parameter_get_type (void) G_GNUC_CONST;
#define VALA_DELEGATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DELEGATE, ValaDelegatePrivate))
enum  {
	VALA_DELEGATE_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
ValaDelegate* vala_delegate_new (const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment);
ValaDelegate* vala_delegate_construct (GType object_type, const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment);
ValaTypeSymbol* vala_typesymbol_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
void vala_delegate_set_return_type (ValaDelegate* self, ValaDataType* value);
void vala_delegate_set_cinstance_parameter_position (ValaDelegate* self, gdouble value);
void vala_delegate_set_carray_length_parameter_position (ValaDelegate* self, gdouble value);
void vala_delegate_set_cdelegate_target_parameter_position (ValaDelegate* self, gdouble value);
void vala_delegate_add_type_parameter (ValaDelegate* self, ValaTypeParameter* p);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
void vala_scope_add (ValaScope* self, const gchar* name, ValaSymbol* sym);
const gchar* vala_symbol_get_name (ValaSymbol* self);
ValaList* vala_delegate_get_type_parameters (ValaDelegate* self);
static gint vala_delegate_real_get_type_parameter_index (ValaTypeSymbol* base, const gchar* name);
void vala_delegate_add_parameter (ValaDelegate* self, ValaFormalParameter* param);
void vala_formal_parameter_set_cparameter_position (ValaFormalParameter* self, gdouble value);
gdouble vala_formal_parameter_get_cparameter_position (ValaFormalParameter* self);
void vala_formal_parameter_set_carray_length_parameter_position (ValaFormalParameter* self, gdouble value);
void vala_formal_parameter_set_cdelegate_target_parameter_position (ValaFormalParameter* self, gdouble value);
void vala_formal_parameter_set_cdestroy_notify_parameter_position (ValaFormalParameter* self, gdouble value);
ValaList* vala_delegate_get_parameters (ValaDelegate* self);
gboolean vala_delegate_matches_method (ValaDelegate* self, ValaMethod* m, ValaDataType* dt);
gboolean vala_method_get_coroutine (ValaMethod* self);
ValaDataType* vala_method_get_return_type (ValaMethod* self);
gboolean vala_data_type_stricter (ValaDataType* self, ValaDataType* type2);
ValaDataType* vala_delegate_get_return_type (ValaDelegate* self);
GType vala_member_access_get_type (void) G_GNUC_CONST;
ValaDataType* vala_data_type_get_actual_type (ValaDataType* self, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference);
ValaList* vala_method_get_parameters (ValaMethod* self);
ValaDataType* vala_delegate_get_sender_type (ValaDelegate* self);
ValaDataType* vala_variable_get_variable_type (ValaVariable* self);
GType vala_member_binding_get_type (void) G_GNUC_CONST;
ValaMemberBinding vala_method_get_binding (ValaMethod* self);
gboolean vala_delegate_get_has_target (ValaDelegate* self);
static void vala_delegate_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_delegate (ValaCodeVisitor* self, ValaDelegate* d);
static void vala_delegate_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
ValaList* vala_code_node_get_error_types (ValaCodeNode* self);
static gchar* vala_delegate_real_get_cname (ValaTypeSymbol* base, gboolean const_type);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
gchar* vala_symbol_get_cprefix (ValaSymbol* self);
void vala_delegate_set_cname (ValaDelegate* self, const gchar* cname);
static gchar* vala_delegate_real_get_lower_case_cname (ValaSymbol* base, const gchar* infix);
gchar* vala_symbol_get_lower_case_cprefix (ValaSymbol* self);
gchar* vala_symbol_camel_case_to_lower_case (const gchar* camel_case);
static gchar* vala_delegate_real_get_upper_case_cname (ValaTypeSymbol* base, const gchar* infix);
gchar* vala_symbol_get_lower_case_cname (ValaSymbol* self, const gchar* infix);
static void vala_delegate_process_ccode_attribute (ValaDelegate* self, ValaAttribute* a);
gboolean vala_attribute_has_argument (ValaAttribute* self, const gchar* name);
gchar* vala_attribute_get_string (ValaAttribute* self, const gchar* name);
gboolean vala_attribute_get_bool (ValaAttribute* self, const gchar* name);
void vala_delegate_set_has_target (ValaDelegate* self, gboolean value);
gdouble vala_attribute_get_double (ValaAttribute* self, const gchar* name);
void vala_delegate_set_no_array_length (ValaDelegate* self, gboolean value);
void vala_delegate_set_array_null_terminated (ValaDelegate* self, gboolean value);
void vala_symbol_add_cheader_filename (ValaSymbol* self, const gchar* filename);
void vala_delegate_process_attributes (ValaDelegate* self);
const gchar* vala_attribute_get_name (ValaAttribute* self);
void vala_symbol_process_deprecated_attribute (ValaSymbol* self, ValaAttribute* attr);
static gboolean vala_delegate_real_is_reference_type (ValaTypeSymbol* base);
static gchar* vala_delegate_real_get_type_id (ValaTypeSymbol* base);
static gchar* vala_delegate_real_get_marshaller_type_name (ValaTypeSymbol* base);
static gchar* vala_delegate_real_get_get_value_function (ValaTypeSymbol* base);
static gchar* vala_delegate_real_get_set_value_function (ValaTypeSymbol* base);
static void vala_delegate_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
gchar* vala_delegate_get_prototype_string (ValaDelegate* self, const gchar* name);
static gchar* vala_delegate_get_return_type_string (ValaDelegate* self);
static gchar* vala_delegate_get_parameters_string (ValaDelegate* self);
gboolean vala_data_type_get_value_owned (ValaDataType* self);
GType vala_reference_type_get_type (void) G_GNUC_CONST;
gchar* vala_code_node_to_string (ValaCodeNode* self);
GType vala_parameter_direction_get_type (void) G_GNUC_CONST;
ValaParameterDirection vala_formal_parameter_get_direction (ValaFormalParameter* self);
static gboolean vala_delegate_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
void vala_delegate_set_sender_type (ValaDelegate* self, ValaDataType* value);
gdouble vala_delegate_get_cinstance_parameter_position (ValaDelegate* self);
gdouble vala_delegate_get_carray_length_parameter_position (ValaDelegate* self);
gdouble vala_delegate_get_cdelegate_target_parameter_position (ValaDelegate* self);
gboolean vala_delegate_get_no_array_length (ValaDelegate* self);
gboolean vala_delegate_get_array_null_terminated (ValaDelegate* self);
static void vala_delegate_finalize (ValaCodeNode* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Creates a new delegate.
 *
 * @param name        delegate type name
 * @param return_type return type
 * @param source      reference to source code
 * @return            newly created delegate
 */
ValaDelegate* vala_delegate_construct (GType object_type, const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaDelegate* self = NULL;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaDelegate*) vala_typesymbol_construct (object_type, name, source_reference, comment);
	vala_delegate_set_return_type (self, return_type);
	vala_delegate_set_cinstance_parameter_position (self, (gdouble) (-2));
	vala_delegate_set_carray_length_parameter_position (self, (gdouble) (-3));
	vala_delegate_set_cdelegate_target_parameter_position (self, (gdouble) (-3));
	return self;
}


ValaDelegate* vala_delegate_new (const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_delegate_construct (VALA_TYPE_DELEGATE, name, return_type, source_reference, comment);
}


/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void vala_delegate_add_type_parameter (ValaDelegate* self, ValaTypeParameter* p) {
	ValaScope* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	vala_collection_add ((ValaCollection*) self->priv->type_parameters, p);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp1_ = vala_symbol_get_name ((ValaSymbol*) p);
	vala_scope_add (_tmp0_, _tmp1_, (ValaSymbol*) p);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_delegate_get_type_parameters (ValaDelegate* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->type_parameters);
	result = _tmp0_;
	return result;
}


static gint vala_delegate_real_get_type_parameter_index (ValaTypeSymbol* base, const gchar* name) {
	ValaDelegate * self;
	gint result = 0;
	gint i;
	self = (ValaDelegate*) base;
	g_return_val_if_fail (name != NULL, 0);
	i = 0;
	{
		ValaList* _tmp0_;
		ValaList* _parameter_list;
		gint _tmp1_;
		gint _parameter_size;
		gint _parameter_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->type_parameters);
		_parameter_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _parameter_list);
		_parameter_size = _tmp1_;
		_parameter_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			ValaTypeParameter* parameter;
			const gchar* _tmp3_ = NULL;
			_parameter_index = _parameter_index + 1;
			if (!(_parameter_index < _parameter_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_parameter_list, _parameter_index);
			parameter = (ValaTypeParameter*) _tmp2_;
			_tmp3_ = vala_symbol_get_name ((ValaSymbol*) parameter);
			if (g_strcmp0 (_tmp3_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				_vala_iterable_unref0 (_parameter_list);
				return result;
			}
			i++;
			_vala_code_node_unref0 (parameter);
		}
		_vala_iterable_unref0 (_parameter_list);
	}
	result = -1;
	return result;
}


/**
 * Appends paramater to this callback function.
 *
 * @param param a formal parameter
 */
void vala_delegate_add_parameter (ValaDelegate* self, ValaFormalParameter* param) {
	gint _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	ValaScope* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (param != NULL);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) self->priv->parameters);
	vala_formal_parameter_set_cparameter_position (param, (gdouble) (_tmp0_ + 1));
	_tmp1_ = vala_formal_parameter_get_cparameter_position (param);
	vala_formal_parameter_set_carray_length_parameter_position (param, _tmp1_ + 0.1);
	_tmp2_ = vala_formal_parameter_get_cparameter_position (param);
	vala_formal_parameter_set_cdelegate_target_parameter_position (param, _tmp2_ + 0.1);
	_tmp3_ = vala_formal_parameter_get_cparameter_position (param);
	vala_formal_parameter_set_cdestroy_notify_parameter_position (param, _tmp3_ + 0.1);
	vala_collection_add ((ValaCollection*) self->priv->parameters, param);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) param);
	vala_scope_add (_tmp4_, _tmp5_, (ValaSymbol*) param);
}


/**
 * Return copy of parameter list.
 *
 * @return parameter list
 */
ValaList* vala_delegate_get_parameters (ValaDelegate* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->parameters);
	result = _tmp0_;
	return result;
}


/**
 * Checks whether the arguments and return type of the specified method
 * matches this callback.
 *
 * @param m a method
 * @return  true if the specified method is compatible to this callback
 */
gboolean vala_delegate_matches_method (ValaDelegate* self, ValaMethod* m, ValaDataType* dt) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	ValaDataType* _tmp1_ = NULL;
	ValaDataType* _tmp2_ = NULL;
	ValaDataType* _tmp3_ = NULL;
	ValaDataType* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	ValaList* _tmp7_ = NULL;
	ValaList* method_params;
	ValaIterator* _tmp8_ = NULL;
	ValaIterator* method_params_it;
	gboolean _tmp9_ = FALSE;
	gboolean first;
	gboolean _tmp29_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	g_return_val_if_fail (dt != NULL, FALSE);
	_tmp0_ = vala_method_get_coroutine (m);
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = vala_method_get_return_type (m);
	_tmp2_ = vala_delegate_get_return_type (self);
	_tmp3_ = vala_data_type_get_actual_type (_tmp2_, dt, NULL, (ValaCodeNode*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_data_type_stricter (_tmp1_, _tmp4_);
	if ((_tmp6_ = !_tmp5_, _vala_code_node_unref0 (_tmp4_), _tmp6_)) {
		result = FALSE;
		return result;
	}
	_tmp7_ = vala_method_get_parameters (m);
	method_params = _tmp7_;
	_tmp8_ = vala_iterable_iterator ((ValaIterable*) method_params);
	method_params_it = _tmp8_;
	if (self->priv->_sender_type != NULL) {
		gint _tmp10_;
		gint _tmp11_;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) method_params);
		_tmp11_ = vala_collection_get_size ((ValaCollection*) self->priv->parameters);
		_tmp9_ = _tmp10_ == (_tmp11_ + 1);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gpointer _tmp12_ = NULL;
		ValaFormalParameter* method_param;
		ValaDataType* _tmp13_ = NULL;
		gboolean _tmp14_;
		vala_iterator_next (method_params_it);
		_tmp12_ = vala_iterator_get (method_params_it);
		method_param = (ValaFormalParameter*) _tmp12_;
		_tmp13_ = vala_variable_get_variable_type ((ValaVariable*) method_param);
		_tmp14_ = vala_data_type_stricter (self->priv->_sender_type, _tmp13_);
		if (!_tmp14_) {
			result = FALSE;
			_vala_code_node_unref0 (method_param);
			_vala_iterator_unref0 (method_params_it);
			_vala_iterable_unref0 (method_params);
			return result;
		}
		_vala_code_node_unref0 (method_param);
	}
	first = TRUE;
	{
		ValaList* _tmp15_;
		ValaList* _param_list;
		gint _tmp16_;
		gint _param_size;
		gint _param_index;
		_tmp15_ = _vala_iterable_ref0 (self->priv->parameters);
		_param_list = _tmp15_;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _param_list);
		_param_size = _tmp16_;
		_param_index = -1;
		while (TRUE) {
			gpointer _tmp17_ = NULL;
			ValaFormalParameter* param;
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp21_;
			gpointer _tmp22_ = NULL;
			ValaFormalParameter* method_param;
			ValaDataType* _tmp23_ = NULL;
			ValaDataType* _tmp24_ = NULL;
			ValaDataType* _tmp25_;
			ValaDataType* _tmp26_ = NULL;
			gboolean _tmp27_;
			gboolean _tmp28_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp17_ = vala_list_get (_param_list, _param_index);
			param = (ValaFormalParameter*) _tmp17_;
			if (first) {
				ValaMemberBinding _tmp20_;
				_tmp20_ = vala_method_get_binding (m);
				_tmp19_ = _tmp20_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				_tmp18_ = !self->priv->_has_target;
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				first = FALSE;
				_vala_code_node_unref0 (param);
				continue;
			}
			_tmp21_ = vala_iterator_next (method_params_it);
			if (!_tmp21_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp22_ = vala_iterator_get (method_params_it);
			method_param = (ValaFormalParameter*) _tmp22_;
			_tmp23_ = vala_variable_get_variable_type ((ValaVariable*) param);
			_tmp24_ = vala_data_type_get_actual_type (_tmp23_, dt, NULL, (ValaCodeNode*) self);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_variable_get_variable_type ((ValaVariable*) method_param);
			_tmp27_ = vala_data_type_stricter (_tmp25_, _tmp26_);
			if ((_tmp28_ = !_tmp27_, _vala_code_node_unref0 (_tmp25_), _tmp28_)) {
				result = FALSE;
				_vala_code_node_unref0 (method_param);
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_iterable_unref0 (method_params);
				return result;
			}
			_vala_code_node_unref0 (method_param);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp29_ = vala_iterator_next (method_params_it);
	if (_tmp29_) {
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_iterable_unref0 (method_params);
		return result;
	}
	result = TRUE;
	_vala_iterator_unref0 (method_params_it);
	_vala_iterable_unref0 (method_params);
	return result;
}


static void vala_delegate_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDelegate * self;
	self = (ValaDelegate*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_delegate (visitor, self);
}


static void vala_delegate_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDelegate * self;
	ValaDataType* _tmp3_ = NULL;
	self = (ValaDelegate*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _p_list;
		gint _tmp1_;
		gint _p_size;
		gint _p_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->type_parameters);
		_p_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _p_list);
		_p_size = _tmp1_;
		_p_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			ValaTypeParameter* p;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_p_list, _p_index);
			p = (ValaTypeParameter*) _tmp2_;
			vala_code_node_accept ((ValaCodeNode*) p, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp3_ = vala_delegate_get_return_type (self);
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	{
		ValaList* _tmp4_;
		ValaList* _param_list;
		gint _tmp5_;
		gint _param_size;
		gint _param_index;
		_tmp4_ = _vala_iterable_ref0 (self->priv->parameters);
		_param_list = _tmp4_;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _param_list);
		_param_size = _tmp5_;
		_param_index = -1;
		while (TRUE) {
			gpointer _tmp6_ = NULL;
			ValaFormalParameter* param;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp6_ = vala_list_get (_param_list, _param_index);
			param = (ValaFormalParameter*) _tmp6_;
			vala_code_node_accept ((ValaCodeNode*) param, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _tmp7_ = NULL;
		ValaList* _error_type_list;
		gint _tmp8_;
		gint _error_type_size;
		gint _error_type_index;
		_tmp7_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp7_;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _error_type_list);
		_error_type_size = _tmp8_;
		_error_type_index = -1;
		while (TRUE) {
			gpointer _tmp9_ = NULL;
			ValaDataType* error_type;
			_error_type_index = _error_type_index + 1;
			if (!(_error_type_index < _error_type_size)) {
				break;
			}
			_tmp9_ = vala_list_get (_error_type_list, _error_type_index);
			error_type = (ValaDataType*) _tmp9_;
			vala_code_node_accept ((ValaCodeNode*) error_type, visitor);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
}


static gchar* vala_delegate_real_get_cname (ValaTypeSymbol* base, gboolean const_type) {
	ValaDelegate * self;
	gchar* result = NULL;
	gchar* _tmp6_;
	self = (ValaDelegate*) base;
	if (self->priv->cname == NULL) {
		ValaSymbol* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp1_ = vala_symbol_get_cprefix (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp4_ = g_strdup_printf ("%s%s", _tmp2_, _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (self->priv->cname);
		self->priv->cname = _tmp5_;
		_g_free0 (_tmp2_);
	}
	_tmp6_ = g_strdup (self->priv->cname);
	result = _tmp6_;
	return result;
}


/**
 * Sets the name of this callback as it is used in C code.
 *
 * @param cname the name to be used in C code
 */
void vala_delegate_set_cname (ValaDelegate* self, const gchar* cname) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	_tmp0_ = g_strdup (cname);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->cname);
	self->priv->cname = _tmp1_;
}


static gchar* vala_delegate_real_get_lower_case_cname (ValaSymbol* base, const gchar* infix) {
	ValaDelegate * self;
	gchar* result = NULL;
	ValaSymbol* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	self = (ValaDelegate*) base;
	if (infix == NULL) {
		infix = "";
	}
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = vala_symbol_get_lower_case_cprefix (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp4_ = vala_symbol_camel_case_to_lower_case (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%s%s%s", _tmp2_, infix, _tmp5_);
	result = (_tmp7_ = _tmp6_, _g_free0 (_tmp5_), _g_free0 (_tmp2_), _tmp7_);
	return result;
}


static gchar* vala_delegate_real_get_upper_case_cname (ValaTypeSymbol* base, const gchar* infix) {
	ValaDelegate * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	self = (ValaDelegate*) base;
	_tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, infix);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_strup (_tmp1_, (gssize) (-1));
	result = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	return result;
}


static void vala_delegate_process_ccode_attribute (ValaDelegate* self, ValaAttribute* a) {
	gboolean _tmp0_;
	gboolean _tmp3_;
	gboolean _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp9_;
	gboolean _tmp11_;
	gboolean _tmp13_;
	gboolean _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	_tmp0_ = vala_attribute_has_argument (a, "cname");
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = vala_attribute_get_string (a, "cname");
		_tmp2_ = _tmp1_;
		vala_delegate_set_cname (self, _tmp2_);
		_g_free0 (_tmp2_);
	}
	_tmp3_ = vala_attribute_has_argument (a, "has_target");
	if (_tmp3_) {
		gboolean _tmp4_;
		_tmp4_ = vala_attribute_get_bool (a, "has_target");
		vala_delegate_set_has_target (self, _tmp4_);
	}
	_tmp5_ = vala_attribute_has_argument (a, "instance_pos");
	if (_tmp5_) {
		gdouble _tmp6_;
		_tmp6_ = vala_attribute_get_double (a, "instance_pos");
		vala_delegate_set_cinstance_parameter_position (self, _tmp6_);
	}
	_tmp7_ = vala_attribute_has_argument (a, "array_length");
	if (_tmp7_) {
		gboolean _tmp8_;
		_tmp8_ = vala_attribute_get_bool (a, "array_length");
		vala_delegate_set_no_array_length (self, !_tmp8_);
	}
	_tmp9_ = vala_attribute_has_argument (a, "array_null_terminated");
	if (_tmp9_) {
		gboolean _tmp10_;
		_tmp10_ = vala_attribute_get_bool (a, "array_null_terminated");
		vala_delegate_set_array_null_terminated (self, _tmp10_);
	}
	_tmp11_ = vala_attribute_has_argument (a, "array_length_pos");
	if (_tmp11_) {
		gdouble _tmp12_;
		_tmp12_ = vala_attribute_get_double (a, "array_length_pos");
		vala_delegate_set_carray_length_parameter_position (self, _tmp12_);
	}
	_tmp13_ = vala_attribute_has_argument (a, "delegate_target_pos");
	if (_tmp13_) {
		gdouble _tmp14_;
		_tmp14_ = vala_attribute_get_double (a, "delegate_target_pos");
		vala_delegate_set_cdelegate_target_parameter_position (self, _tmp14_);
	}
	_tmp15_ = vala_attribute_has_argument (a, "cheader_filename");
	if (_tmp15_) {
		gchar* _tmp16_ = NULL;
		gchar* val;
		gchar** _tmp17_;
		gchar** _tmp18_ = NULL;
		_tmp16_ = vala_attribute_get_string (a, "cheader_filename");
		val = _tmp16_;
		_tmp18_ = _tmp17_ = g_strsplit (val, ",", 0);
		{
			gchar** filename_collection;
			int filename_collection_length1;
			int filename_it;
			filename_collection = _tmp18_;
			filename_collection_length1 = _vala_array_length (_tmp17_);
			for (filename_it = 0; filename_it < _vala_array_length (_tmp17_); filename_it = filename_it + 1) {
				gchar* _tmp19_;
				gchar* filename;
				_tmp19_ = g_strdup (filename_collection[filename_it]);
				filename = _tmp19_;
				{
					vala_symbol_add_cheader_filename ((ValaSymbol*) self, filename);
					_g_free0 (filename);
				}
			}
			filename_collection = (_vala_array_free (filename_collection, filename_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (val);
	}
}


/**
 * Process all associated attributes.
 */
static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_delegate_process_attributes (ValaDelegate* self) {
	g_return_if_fail (self != NULL);
	{
		GList* a_collection;
		GList* a_it;
		a_collection = ((ValaCodeNode*) self)->attributes;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* _tmp0_;
			ValaAttribute* a;
			_tmp0_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
			a = _tmp0_;
			{
				const gchar* _tmp1_ = NULL;
				_tmp1_ = vala_attribute_get_name (a);
				if (g_strcmp0 (_tmp1_, "CCode") == 0) {
					vala_delegate_process_ccode_attribute (self, a);
				} else {
					const gchar* _tmp2_ = NULL;
					_tmp2_ = vala_attribute_get_name (a);
					if (g_strcmp0 (_tmp2_, "Deprecated") == 0) {
						vala_symbol_process_deprecated_attribute ((ValaSymbol*) self, a);
					}
				}
				_vala_code_node_unref0 (a);
			}
		}
	}
}


static gboolean vala_delegate_real_is_reference_type (ValaTypeSymbol* base) {
	ValaDelegate * self;
	gboolean result = FALSE;
	self = (ValaDelegate*) base;
	result = FALSE;
	return result;
}


static gchar* vala_delegate_real_get_type_id (ValaTypeSymbol* base) {
	ValaDelegate * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (ValaDelegate*) base;
	_tmp0_ = g_strdup ("G_TYPE_POINTER");
	result = _tmp0_;
	return result;
}


static gchar* vala_delegate_real_get_marshaller_type_name (ValaTypeSymbol* base) {
	ValaDelegate * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (ValaDelegate*) base;
	_tmp0_ = g_strdup ("POINTER");
	result = _tmp0_;
	return result;
}


static gchar* vala_delegate_real_get_get_value_function (ValaTypeSymbol* base) {
	ValaDelegate * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (ValaDelegate*) base;
	_tmp0_ = g_strdup ("g_value_get_pointer");
	result = _tmp0_;
	return result;
}


static gchar* vala_delegate_real_get_set_value_function (ValaTypeSymbol* base) {
	ValaDelegate * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (ValaDelegate*) base;
	_tmp0_ = g_strdup ("g_value_set_pointer");
	result = _tmp0_;
	return result;
}


static void vala_delegate_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaDelegate * self;
	ValaDataType* _tmp0_ = NULL;
	ValaList* _tmp1_ = NULL;
	ValaList* error_types;
	self = (ValaDelegate*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_delegate_get_return_type (self);
	if (_tmp0_ == old_type) {
		vala_delegate_set_return_type (self, new_type);
		return;
	}
	_tmp1_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
	error_types = _tmp1_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gpointer _tmp4_ = NULL;
				ValaDataType* _tmp5_;
				gboolean _tmp6_;
				if (!_tmp2_) {
					i++;
				}
				_tmp2_ = FALSE;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) error_types);
				if (!(i < _tmp3_)) {
					break;
				}
				_tmp4_ = vala_list_get (error_types, i);
				_tmp5_ = (ValaDataType*) _tmp4_;
				if ((_tmp6_ = _tmp5_ == old_type, _vala_code_node_unref0 (_tmp5_), _tmp6_)) {
					vala_list_set (error_types, i, new_type);
					_vala_iterable_unref0 (error_types);
					return;
				}
			}
		}
	}
	_vala_iterable_unref0 (error_types);
}


gchar* vala_delegate_get_prototype_string (ValaDelegate* self, const gchar* name) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = vala_delegate_get_return_type_string (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_delegate_get_parameters_string (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s %s %s", _tmp1_, name, _tmp3_);
	result = (_tmp5_ = _tmp4_, _g_free0 (_tmp3_), _g_free0 (_tmp1_), _tmp5_);
	return result;
}


static gchar* vala_delegate_get_return_type_string (ValaDelegate* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* str;
	gboolean _tmp1_ = FALSE;
	ValaDataType* _tmp2_ = NULL;
	gboolean _tmp3_;
	ValaDataType* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	str = _tmp0_;
	_tmp2_ = vala_delegate_get_return_type (self);
	_tmp3_ = vala_data_type_get_value_owned (_tmp2_);
	if (!_tmp3_) {
		ValaDataType* _tmp4_ = NULL;
		_tmp4_ = vala_delegate_get_return_type (self);
		_tmp1_ = VALA_IS_REFERENCE_TYPE (_tmp4_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_strdup ("weak ");
		_tmp6_ = _tmp5_;
		_g_free0 (str);
		str = _tmp6_;
	}
	_tmp7_ = vala_delegate_get_return_type (self);
	_tmp8_ = vala_code_node_to_string ((ValaCodeNode*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (str, _tmp9_, NULL);
	_g_free0 (str);
	str = _tmp10_;
	_g_free0 (_tmp9_);
	result = str;
	return result;
}


static gchar* vala_delegate_get_parameters_string (ValaDelegate* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* str;
	gint i;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("(");
	str = _tmp0_;
	i = 1;
	{
		ValaList* _tmp1_;
		ValaList* _param_list;
		gint _tmp2_;
		gint _param_size;
		gint _param_index;
		_tmp1_ = _vala_iterable_ref0 (self->priv->parameters);
		_param_list = _tmp1_;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _param_list);
		_param_size = _tmp2_;
		_param_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			ValaFormalParameter* param;
			ValaParameterDirection _tmp5_;
			ValaDataType* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp3_ = vala_list_get (_param_list, _param_index);
			param = (ValaFormalParameter*) _tmp3_;
			if (i > 1) {
				gchar* _tmp4_;
				_tmp4_ = g_strconcat (str, ", ", NULL);
				_g_free0 (str);
				str = _tmp4_;
			}
			_tmp5_ = vala_formal_parameter_get_direction (param);
			if (_tmp5_ == VALA_PARAMETER_DIRECTION_IN) {
				ValaDataType* _tmp6_ = NULL;
				gboolean _tmp7_;
				_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) param);
				_tmp7_ = vala_data_type_get_value_owned (_tmp6_);
				if (_tmp7_) {
					gchar* _tmp8_;
					_tmp8_ = g_strconcat (str, "owned ", NULL);
					_g_free0 (str);
					str = _tmp8_;
				}
			} else {
				ValaParameterDirection _tmp9_;
				gboolean _tmp13_ = FALSE;
				ValaDataType* _tmp14_ = NULL;
				gboolean _tmp15_;
				_tmp9_ = vala_formal_parameter_get_direction (param);
				if (_tmp9_ == VALA_PARAMETER_DIRECTION_REF) {
					gchar* _tmp10_;
					_tmp10_ = g_strconcat (str, "ref ", NULL);
					_g_free0 (str);
					str = _tmp10_;
				} else {
					ValaParameterDirection _tmp11_;
					_tmp11_ = vala_formal_parameter_get_direction (param);
					if (_tmp11_ == VALA_PARAMETER_DIRECTION_OUT) {
						gchar* _tmp12_;
						_tmp12_ = g_strconcat (str, "out ", NULL);
						_g_free0 (str);
						str = _tmp12_;
					}
				}
				_tmp14_ = vala_variable_get_variable_type ((ValaVariable*) param);
				_tmp15_ = vala_data_type_get_value_owned (_tmp14_);
				if (!_tmp15_) {
					ValaDataType* _tmp16_ = NULL;
					_tmp16_ = vala_variable_get_variable_type ((ValaVariable*) param);
					_tmp13_ = VALA_IS_REFERENCE_TYPE (_tmp16_);
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					gchar* _tmp17_;
					_tmp17_ = g_strconcat (str, "weak ", NULL);
					_g_free0 (str);
					str = _tmp17_;
				}
			}
			_tmp18_ = vala_variable_get_variable_type ((ValaVariable*) param);
			_tmp19_ = vala_code_node_to_string ((ValaCodeNode*) _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strconcat (str, _tmp20_, NULL);
			_g_free0 (str);
			str = _tmp21_;
			_g_free0 (_tmp20_);
			i++;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp22_ = g_strconcat (str, ")", NULL);
	_g_free0 (str);
	str = _tmp22_;
	result = str;
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean vala_delegate_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaDelegate * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	ValaSourceFile* _tmp2_ = NULL;
	ValaSourceFile* _tmp3_;
	ValaSourceFile* old_source_file;
	ValaSourceReference* _tmp4_ = NULL;
	ValaDataType* _tmp10_ = NULL;
	gboolean _tmp17_;
	self = (ValaDelegate*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = vala_code_node_get_error ((ValaCodeNode*) self);
		result = !_tmp1_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_delegate_process_attributes (self);
	_tmp2_ = vala_semantic_analyzer_get_current_source_file (analyzer);
	_tmp3_ = _vala_source_file_ref0 (_tmp2_);
	old_source_file = _tmp3_;
	_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	if (_tmp4_ != NULL) {
		ValaSourceReference* _tmp5_ = NULL;
		ValaSourceFile* _tmp6_ = NULL;
		_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		vala_semantic_analyzer_set_current_source_file (analyzer, _tmp6_);
	}
	{
		ValaList* _tmp7_;
		ValaList* _p_list;
		gint _tmp8_;
		gint _p_size;
		gint _p_index;
		_tmp7_ = _vala_iterable_ref0 (self->priv->type_parameters);
		_p_list = _tmp7_;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _p_list);
		_p_size = _tmp8_;
		_p_index = -1;
		while (TRUE) {
			gpointer _tmp9_ = NULL;
			ValaTypeParameter* p;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp9_ = vala_list_get (_p_list, _p_index);
			p = (ValaTypeParameter*) _tmp9_;
			vala_code_node_check ((ValaCodeNode*) p, analyzer);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp10_ = vala_delegate_get_return_type (self);
	vala_code_node_check ((ValaCodeNode*) _tmp10_, analyzer);
	{
		ValaList* _tmp11_;
		ValaList* _param_list;
		gint _tmp12_;
		gint _param_size;
		gint _param_index;
		_tmp11_ = _vala_iterable_ref0 (self->priv->parameters);
		_param_list = _tmp11_;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _param_list);
		_param_size = _tmp12_;
		_param_index = -1;
		while (TRUE) {
			gpointer _tmp13_ = NULL;
			ValaFormalParameter* param;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp13_ = vala_list_get (_param_list, _param_index);
			param = (ValaFormalParameter*) _tmp13_;
			vala_code_node_check ((ValaCodeNode*) param, analyzer);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _tmp14_ = NULL;
		ValaList* _error_type_list;
		gint _tmp15_;
		gint _error_type_size;
		gint _error_type_index;
		_tmp14_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp14_;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _error_type_list);
		_error_type_size = _tmp15_;
		_error_type_index = -1;
		while (TRUE) {
			gpointer _tmp16_ = NULL;
			ValaDataType* error_type;
			_error_type_index = _error_type_index + 1;
			if (!(_error_type_index < _error_type_size)) {
				break;
			}
			_tmp16_ = vala_list_get (_error_type_list, _error_type_index);
			error_type = (ValaDataType*) _tmp16_;
			vala_code_node_check ((ValaCodeNode*) error_type, analyzer);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	vala_semantic_analyzer_set_current_source_file (analyzer, old_source_file);
	_tmp17_ = vala_code_node_get_error ((ValaCodeNode*) self);
	result = !_tmp17_;
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaDataType* vala_delegate_get_return_type (ValaDelegate* self) {
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_return_type;
	return result;
}


void vala_delegate_set_return_type (ValaDelegate* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp1_;
	vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_return_type, (ValaCodeNode*) self);
}


gboolean vala_delegate_get_has_target (ValaDelegate* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_target;
	return result;
}


void vala_delegate_set_has_target (ValaDelegate* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_target = value;
}


ValaDataType* vala_delegate_get_sender_type (ValaDelegate* self) {
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_sender_type;
	return result;
}


void vala_delegate_set_sender_type (ValaDelegate* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_code_node_unref0 (self->priv->_sender_type);
	self->priv->_sender_type = _tmp1_;
}


gdouble vala_delegate_get_cinstance_parameter_position (ValaDelegate* self) {
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_cinstance_parameter_position;
	return result;
}


void vala_delegate_set_cinstance_parameter_position (ValaDelegate* self, gdouble value) {
	g_return_if_fail (self != NULL);
	self->priv->_cinstance_parameter_position = value;
}


gdouble vala_delegate_get_carray_length_parameter_position (ValaDelegate* self) {
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_carray_length_parameter_position;
	return result;
}


void vala_delegate_set_carray_length_parameter_position (ValaDelegate* self, gdouble value) {
	g_return_if_fail (self != NULL);
	self->priv->_carray_length_parameter_position = value;
}


gdouble vala_delegate_get_cdelegate_target_parameter_position (ValaDelegate* self) {
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_cdelegate_target_parameter_position;
	return result;
}


void vala_delegate_set_cdelegate_target_parameter_position (ValaDelegate* self, gdouble value) {
	g_return_if_fail (self != NULL);
	self->priv->_cdelegate_target_parameter_position = value;
}


gboolean vala_delegate_get_no_array_length (ValaDelegate* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_no_array_length;
	return result;
}


void vala_delegate_set_no_array_length (ValaDelegate* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_no_array_length = value;
}


gboolean vala_delegate_get_array_null_terminated (ValaDelegate* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_array_null_terminated;
	return result;
}


void vala_delegate_set_array_null_terminated (ValaDelegate* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_array_null_terminated = value;
}


static void vala_delegate_class_init (ValaDelegateClass * klass) {
	vala_delegate_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_delegate_finalize;
	g_type_class_add_private (klass, sizeof (ValaDelegatePrivate));
	VALA_TYPESYMBOL_CLASS (klass)->get_type_parameter_index = vala_delegate_real_get_type_parameter_index;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_delegate_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_delegate_real_accept_children;
	VALA_TYPESYMBOL_CLASS (klass)->get_cname = vala_delegate_real_get_cname;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cname = vala_delegate_real_get_lower_case_cname;
	VALA_TYPESYMBOL_CLASS (klass)->get_upper_case_cname = vala_delegate_real_get_upper_case_cname;
	VALA_TYPESYMBOL_CLASS (klass)->is_reference_type = vala_delegate_real_is_reference_type;
	VALA_TYPESYMBOL_CLASS (klass)->get_type_id = vala_delegate_real_get_type_id;
	VALA_TYPESYMBOL_CLASS (klass)->get_marshaller_type_name = vala_delegate_real_get_marshaller_type_name;
	VALA_TYPESYMBOL_CLASS (klass)->get_get_value_function = vala_delegate_real_get_get_value_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_set_value_function = vala_delegate_real_get_set_value_function;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_delegate_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_delegate_real_check;
}


static void vala_delegate_instance_init (ValaDelegate * self) {
	ValaArrayList* _tmp0_ = NULL;
	ValaArrayList* _tmp1_ = NULL;
	self->priv = VALA_DELEGATE_GET_PRIVATE (self);
	_tmp0_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->type_parameters = (ValaList*) _tmp0_;
	_tmp1_ = vala_array_list_new (VALA_TYPE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->parameters = (ValaList*) _tmp1_;
}


static void vala_delegate_finalize (ValaCodeNode* obj) {
	ValaDelegate * self;
	self = VALA_DELEGATE (obj);
	_vala_code_node_unref0 (self->priv->_sender_type);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_iterable_unref0 (self->priv->parameters);
	_g_free0 (self->priv->cname);
	_vala_code_node_unref0 (self->priv->_return_type);
	VALA_CODE_NODE_CLASS (vala_delegate_parent_class)->finalize (obj);
}


/**
 * Represents a function callback type.
 */
GType vala_delegate_get_type (void) {
	static volatile gsize vala_delegate_type_id__volatile = 0;
	if (g_once_init_enter (&vala_delegate_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDelegateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_delegate_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDelegate), 0, (GInstanceInitFunc) vala_delegate_instance_init, NULL };
		GType vala_delegate_type_id;
		vala_delegate_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaDelegate", &g_define_type_info, 0);
		g_once_init_leave (&vala_delegate_type_id__volatile, vala_delegate_type_id);
	}
	return vala_delegate_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



