/* valacodecontext.c generated by valac, the Vala compiler
 * generated from valacodecontext.vala, do not modify */

/* valacodecontext.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib/gstdio.h>
#include <config.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;
typedef struct _ValaCodeContextPrivate ValaCodeContextPrivate;

#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROFILE (vala_profile_get_type ())

#define VALA_TYPE_REPORT (vala_report_get_type ())
#define VALA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REPORT, ValaReport))
#define VALA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REPORT, ValaReportClass))
#define VALA_IS_REPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REPORT))
#define VALA_IS_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REPORT))
#define VALA_REPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REPORT, ValaReportClass))

typedef struct _ValaReport ValaReport;
typedef struct _ValaReportClass ValaReportClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

#define VALA_TYPE_SOURCE_FILE_TYPE (vala_source_file_type_get_type ())
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_UNRESOLVED_SYMBOL (vala_unresolved_symbol_get_type ())
#define VALA_UNRESOLVED_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbol))
#define VALA_UNRESOLVED_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbolClass))
#define VALA_IS_UNRESOLVED_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_UNRESOLVED_SYMBOL))
#define VALA_IS_UNRESOLVED_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_UNRESOLVED_SYMBOL))
#define VALA_UNRESOLVED_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbolClass))

typedef struct _ValaUnresolvedSymbol ValaUnresolvedSymbol;
typedef struct _ValaUnresolvedSymbolClass ValaUnresolvedSymbolClass;

#define VALA_TYPE_USING_DIRECTIVE (vala_using_directive_get_type ())
#define VALA_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirective))
#define VALA_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))
#define VALA_IS_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_USING_DIRECTIVE))
#define VALA_IS_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_USING_DIRECTIVE))
#define VALA_USING_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))

typedef struct _ValaUsingDirective ValaUsingDirective;
typedef struct _ValaUsingDirectiveClass ValaUsingDirectiveClass;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _ValaParamSpecCodeContext ValaParamSpecCodeContext;

struct _ValaCodeContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeContextPrivate * priv;
	gchar** vapi_directories;
	gint vapi_directories_length1;
	gchar** gir_directories;
	gint gir_directories_length1;
};

struct _ValaCodeContextClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeContext *self);
};

typedef enum  {
	VALA_PROFILE_POSIX,
	VALA_PROFILE_GOBJECT,
	VALA_PROFILE_DOVA
} ValaProfile;

struct _ValaCodeContextPrivate {
	gboolean _assert;
	gboolean _checking;
	gboolean _deprecated;
	gboolean _experimental;
	gboolean _experimental_non_null;
	gboolean _dbus_transformation;
	gboolean _ccode_only;
	gchar* _header_filename;
	gchar* _internal_header_filename;
	gboolean _use_header;
	gchar* _includedir;
	gchar* _symbols_filename;
	gboolean _compile_only;
	gchar* _output;
	gchar* _basedir;
	gchar* _directory;
	gboolean _debug;
	gint _optlevel;
	gboolean _thread;
	gboolean _mem_profiler;
	ValaMethod* _module_init_method;
	gboolean _save_temps;
	ValaProfile _profile;
	gint _target_glib_major;
	gint _target_glib_minor;
	gboolean _verbose_mode;
	gboolean _version_header;
	gboolean _nostdpkg;
	ValaReport* _report;
	ValaMethod* _entry_point;
	gchar* _entry_point_name;
	gboolean _run_output;
	ValaList* source_files;
	ValaList* c_source_files;
	ValaNamespace* _root;
	ValaList* packages;
	ValaSet* defines;
	ValaCodeGenerator* _codegen;
};

typedef enum  {
	VALA_SOURCE_FILE_TYPE_NONE,
	VALA_SOURCE_FILE_TYPE_SOURCE,
	VALA_SOURCE_FILE_TYPE_PACKAGE,
	VALA_SOURCE_FILE_TYPE_FAST
} ValaSourceFileType;

struct _ValaParamSpecCodeContext {
	GParamSpec parent_instance;
};


static gpointer vala_code_context_parent_class = NULL;
static GStaticPrivate vala_code_context_context_stack_key;
static GStaticPrivate vala_code_context_context_stack_key = {0};

gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_profile_get_type (void) G_GNUC_CONST;
GType vala_report_get_type (void) G_GNUC_CONST;
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
#define VALA_CODE_CONTEXT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CODE_CONTEXT, ValaCodeContextPrivate))
enum  {
	VALA_CODE_CONTEXT_DUMMY_PROPERTY
};
ValaReport* vala_report_new (void);
ValaReport* vala_report_construct (GType object_type);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
ValaNamespace* vala_namespace_new (const gchar* name, ValaSourceReference* source_reference);
ValaNamespace* vala_namespace_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference);
ValaCodeGenerator* vala_code_generator_new (void);
ValaCodeGenerator* vala_code_generator_construct (GType object_type);
gboolean vala_code_context_require_glib_version (ValaCodeContext* self, gint major, gint minor);
gint vala_code_context_get_target_glib_major (ValaCodeContext* self);
gint vala_code_context_get_target_glib_minor (ValaCodeContext* self);
ValaCodeContext* vala_code_context_new (void);
ValaCodeContext* vala_code_context_construct (GType object_type);
ValaCodeContext* vala_code_context_get (void);
void vala_code_context_push (ValaCodeContext* context);
void vala_code_context_pop (void);
ValaList* vala_code_context_get_source_files (ValaCodeContext* self);
ValaList* vala_code_context_get_c_source_files (ValaCodeContext* self);
void vala_code_context_add_source_file (ValaCodeContext* self, ValaSourceFile* file);
void vala_code_context_add_c_source_file (ValaCodeContext* self, const gchar* file);
ValaList* vala_code_context_get_packages (ValaCodeContext* self);
gboolean vala_code_context_has_package (ValaCodeContext* self, const gchar* pkg);
void vala_code_context_add_package (ValaCodeContext* self, const gchar* pkg);
gboolean vala_code_context_add_external_package (ValaCodeContext* self, const gchar* pkg);
gchar* vala_code_context_get_vapi_path (ValaCodeContext* self, const gchar* pkg);
gchar* vala_code_context_get_gir_path (ValaCodeContext* self, const gchar* gir);
void vala_report_error (ValaSourceReference* source, const gchar* message);
GType vala_source_file_type_get_type (void) G_GNUC_CONST;
ValaSourceFile* vala_source_file_new (ValaCodeContext* context, ValaSourceFileType type, const gchar* filename, const gchar* content);
ValaSourceFile* vala_source_file_construct (GType object_type, ValaCodeContext* context, ValaSourceFileType type, const gchar* filename, const gchar* content);
gboolean vala_code_context_add_packages_from_file (ValaCodeContext* self, const gchar* filename);
gboolean vala_code_context_add_source_filename (ValaCodeContext* self, const gchar* filename, gboolean is_source);
gchar* vala_code_context_realpath (const gchar* name);
void vala_source_file_set_relative_filename (ValaSourceFile* self, const gchar* value);
ValaProfile vala_code_context_get_profile (ValaCodeContext* self);
GType vala_unresolved_symbol_get_type (void) G_GNUC_CONST;
ValaUnresolvedSymbol* vala_unresolved_symbol_new (ValaUnresolvedSymbol* inner, const gchar* name, ValaSourceReference* source_reference);
ValaUnresolvedSymbol* vala_unresolved_symbol_construct (GType object_type, ValaUnresolvedSymbol* inner, const gchar* name, ValaSourceReference* source_reference);
ValaUsingDirective* vala_using_directive_new (ValaSymbol* namespace_symbol, ValaSourceReference* source_reference);
ValaUsingDirective* vala_using_directive_construct (GType object_type, ValaSymbol* namespace_symbol, ValaSourceReference* source_reference);
GType vala_using_directive_get_type (void) G_GNUC_CONST;
void vala_source_file_add_using_directive (ValaSourceFile* self, ValaUsingDirective* ns);
ValaNamespace* vala_code_context_get_root (ValaCodeContext* self);
void vala_namespace_add_using_directive (ValaNamespace* self, ValaUsingDirective* ns);
void vala_code_context_accept (ValaCodeContext* self, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
void vala_source_file_accept (ValaSourceFile* self, ValaCodeVisitor* visitor);
void vala_code_context_add_define (ValaCodeContext* self, const gchar* define);
gboolean vala_code_context_is_defined (ValaCodeContext* self, const gchar* define);
static gchar* vala_code_context_get_file_path (ValaCodeContext* self, const gchar* basename, const gchar* versioned_data_dir, const gchar* data_dir, gchar** directories, int directories_length1);
void vala_code_context_write_dependencies (ValaCodeContext* self, const gchar* filename);
ValaSourceFileType vala_source_file_get_file_type (ValaSourceFile* self);
gboolean vala_source_file_get_used (ValaSourceFile* self);
const gchar* vala_source_file_get_filename (ValaSourceFile* self);
static gboolean vala_code_context_ends_with_dir_separator (const gchar* s);
gboolean vala_code_context_get_assert (ValaCodeContext* self);
void vala_code_context_set_assert (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_checking (ValaCodeContext* self);
void vala_code_context_set_checking (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_deprecated (ValaCodeContext* self);
void vala_code_context_set_deprecated (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_experimental (ValaCodeContext* self);
void vala_code_context_set_experimental (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_experimental_non_null (ValaCodeContext* self);
void vala_code_context_set_experimental_non_null (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_dbus_transformation (ValaCodeContext* self);
void vala_code_context_set_dbus_transformation (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_ccode_only (ValaCodeContext* self);
void vala_code_context_set_ccode_only (ValaCodeContext* self, gboolean value);
const gchar* vala_code_context_get_header_filename (ValaCodeContext* self);
void vala_code_context_set_header_filename (ValaCodeContext* self, const gchar* value);
const gchar* vala_code_context_get_internal_header_filename (ValaCodeContext* self);
void vala_code_context_set_internal_header_filename (ValaCodeContext* self, const gchar* value);
gboolean vala_code_context_get_use_header (ValaCodeContext* self);
void vala_code_context_set_use_header (ValaCodeContext* self, gboolean value);
const gchar* vala_code_context_get_includedir (ValaCodeContext* self);
void vala_code_context_set_includedir (ValaCodeContext* self, const gchar* value);
const gchar* vala_code_context_get_symbols_filename (ValaCodeContext* self);
void vala_code_context_set_symbols_filename (ValaCodeContext* self, const gchar* value);
gboolean vala_code_context_get_compile_only (ValaCodeContext* self);
void vala_code_context_set_compile_only (ValaCodeContext* self, gboolean value);
const gchar* vala_code_context_get_output (ValaCodeContext* self);
void vala_code_context_set_output (ValaCodeContext* self, const gchar* value);
const gchar* vala_code_context_get_basedir (ValaCodeContext* self);
void vala_code_context_set_basedir (ValaCodeContext* self, const gchar* value);
const gchar* vala_code_context_get_directory (ValaCodeContext* self);
void vala_code_context_set_directory (ValaCodeContext* self, const gchar* value);
gboolean vala_code_context_get_debug (ValaCodeContext* self);
void vala_code_context_set_debug (ValaCodeContext* self, gboolean value);
gint vala_code_context_get_optlevel (ValaCodeContext* self);
void vala_code_context_set_optlevel (ValaCodeContext* self, gint value);
gboolean vala_code_context_get_thread (ValaCodeContext* self);
void vala_code_context_set_thread (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_mem_profiler (ValaCodeContext* self);
void vala_code_context_set_mem_profiler (ValaCodeContext* self, gboolean value);
ValaMethod* vala_code_context_get_module_init_method (ValaCodeContext* self);
void vala_code_context_set_module_init_method (ValaCodeContext* self, ValaMethod* value);
gboolean vala_code_context_get_save_temps (ValaCodeContext* self);
void vala_code_context_set_save_temps (ValaCodeContext* self, gboolean value);
void vala_code_context_set_profile (ValaCodeContext* self, ValaProfile value);
void vala_code_context_set_target_glib_major (ValaCodeContext* self, gint value);
void vala_code_context_set_target_glib_minor (ValaCodeContext* self, gint value);
gboolean vala_code_context_get_verbose_mode (ValaCodeContext* self);
void vala_code_context_set_verbose_mode (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_version_header (ValaCodeContext* self);
void vala_code_context_set_version_header (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_nostdpkg (ValaCodeContext* self);
void vala_code_context_set_nostdpkg (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_save_csources (ValaCodeContext* self);
ValaReport* vala_code_context_get_report (ValaCodeContext* self);
void vala_code_context_set_report (ValaCodeContext* self, ValaReport* value);
ValaMethod* vala_code_context_get_entry_point (ValaCodeContext* self);
void vala_code_context_set_entry_point (ValaCodeContext* self, ValaMethod* value);
const gchar* vala_code_context_get_entry_point_name (ValaCodeContext* self);
void vala_code_context_set_entry_point_name (ValaCodeContext* self, const gchar* value);
gboolean vala_code_context_get_run_output (ValaCodeContext* self);
void vala_code_context_set_run_output (ValaCodeContext* self, gboolean value);
ValaCodeGenerator* vala_code_context_get_codegen (ValaCodeContext* self);
void vala_code_context_set_codegen (ValaCodeContext* self, ValaCodeGenerator* value);
static void vala_code_context_finalize (ValaCodeContext* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Returns true if the target version of glib is greater than or 
 * equal to the specified version.
 */
gboolean vala_code_context_require_glib_version (ValaCodeContext* self, gint major, gint minor) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_target_glib_major > major) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		if (self->priv->_target_glib_major == major) {
			_tmp1_ = self->priv->_target_glib_minor >= minor;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	result = _tmp0_;
	return result;
}


ValaCodeContext* vala_code_context_construct (GType object_type) {
	ValaCodeContext* self = NULL;
	self = (ValaCodeContext*) g_type_create_instance (object_type);
	return self;
}


ValaCodeContext* vala_code_context_new (void) {
	return vala_code_context_construct (VALA_TYPE_CODE_CONTEXT);
}


/**
 * Return the topmost context from the context stack.
 */
ValaCodeContext* vala_code_context_get (void) {
	ValaCodeContext* result = NULL;
	void* _tmp0_ = NULL;
	ValaList* context_stack;
	gint _tmp1_;
	gpointer _tmp2_ = NULL;
	_tmp0_ = g_static_private_get (&vala_code_context_context_stack_key);
	context_stack = _tmp0_;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) context_stack);
	_tmp2_ = vala_list_get (context_stack, _tmp1_ - 1);
	result = (ValaCodeContext*) _tmp2_;
	return result;
}


/**
 * Push the specified context to the context stack.
 */
void vala_code_context_push (ValaCodeContext* context) {
	void* _tmp0_ = NULL;
	ValaArrayList* context_stack;
	g_return_if_fail (context != NULL);
	_tmp0_ = g_static_private_get (&vala_code_context_context_stack_key);
	context_stack = _tmp0_;
	if (context_stack == NULL) {
		ValaArrayList* _tmp1_ = NULL;
		_tmp1_ = vala_array_list_new (VALA_TYPE_CODE_CONTEXT, (GBoxedCopyFunc) vala_code_context_ref, vala_code_context_unref, g_direct_equal);
		context_stack = _tmp1_;
		g_static_private_set (&vala_code_context_context_stack_key, context_stack, NULL);
	}
	vala_collection_add ((ValaCollection*) context_stack, context);
}


/**
 * Remove the topmost context from the context stack.
 */
void vala_code_context_pop (void) {
	void* _tmp0_ = NULL;
	ValaList* context_stack;
	gint _tmp1_;
	_tmp0_ = g_static_private_get (&vala_code_context_context_stack_key);
	context_stack = _tmp0_;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) context_stack);
	vala_list_remove_at (context_stack, _tmp1_ - 1);
}


/**
 * Returns a copy of the list of source files.
 *
 * @return list of source files
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_code_context_get_source_files (ValaCodeContext* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->source_files);
	result = _tmp0_;
	return result;
}


/**
 * Returns a copy of the list of C source files.
 *
 * @return list of C source files
 */
ValaList* vala_code_context_get_c_source_files (ValaCodeContext* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->c_source_files);
	result = _tmp0_;
	return result;
}


/**
 * Adds the specified file to the list of source files.
 *
 * @param file a source file
 */
void vala_code_context_add_source_file (ValaCodeContext* self, ValaSourceFile* file) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	vala_collection_add ((ValaCollection*) self->priv->source_files, file);
}


/**
 * Adds the specified file to the list of C source files.
 *
 * @param file a C source file
 */
void vala_code_context_add_c_source_file (ValaCodeContext* self, const gchar* file) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	vala_collection_add ((ValaCollection*) self->priv->c_source_files, file);
}


/**
 * Returns a copy of the list of used packages.
 *
 * @return list of used packages
 */
ValaList* vala_code_context_get_packages (ValaCodeContext* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->packages);
	result = _tmp0_;
	return result;
}


/**
 * Returns whether the specified package is being used.
 *
 * @param pkg a package name
 * @return    true if the specified package is being used
 */
gboolean vala_code_context_has_package (ValaCodeContext* self, const gchar* pkg) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pkg != NULL, FALSE);
	_tmp0_ = vala_collection_contains ((ValaCollection*) self->priv->packages, pkg);
	result = _tmp0_;
	return result;
}


/**
 * Adds the specified package to the list of used packages.
 *
 * @param pkg a package name
 */
void vala_code_context_add_package (ValaCodeContext* self, const gchar* pkg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (pkg != NULL);
	vala_collection_add ((ValaCollection*) self->priv->packages, pkg);
}


/**
 * Pull the specified package into the context.
 * The method is tolerant if the package has been already loaded.
 *
 * @param pkg a package name
 * @return false if the package could not be loaded
 *
 */
gboolean vala_code_context_add_external_package (ValaCodeContext* self, const gchar* pkg) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* path;
	ValaSourceFile* _tmp6_ = NULL;
	ValaSourceFile* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* deps_filename;
	gboolean _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pkg != NULL, FALSE);
	_tmp0_ = vala_code_context_has_package (self, pkg);
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp1_ = vala_code_context_get_vapi_path (self, pkg);
	path = _tmp1_;
	if (path == NULL) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = vala_code_context_get_gir_path (self, pkg);
		_tmp3_ = _tmp2_;
		_g_free0 (path);
		path = _tmp3_;
	}
	if (path == NULL) {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp4_ = g_strdup_printf ("Package `%s' not found in specified Vala API directories or GObject-In" \
"trospection GIR directories", pkg);
		_tmp5_ = _tmp4_;
		vala_report_error (NULL, _tmp5_);
		_g_free0 (_tmp5_);
		result = FALSE;
		_g_free0 (path);
		return result;
	}
	vala_code_context_add_package (self, pkg);
	_tmp6_ = vala_source_file_new (self, VALA_SOURCE_FILE_TYPE_PACKAGE, path, NULL);
	_tmp7_ = _tmp6_;
	vala_code_context_add_source_file (self, _tmp7_);
	_vala_source_file_unref0 (_tmp7_);
	_tmp8_ = g_path_get_dirname (path);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf ("%s.deps", pkg);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_build_filename (_tmp9_, _tmp11_, NULL);
	deps_filename = (_tmp13_ = _tmp12_, _g_free0 (_tmp11_), _g_free0 (_tmp9_), _tmp13_);
	_tmp14_ = vala_code_context_add_packages_from_file (self, deps_filename);
	if (!_tmp14_) {
		result = FALSE;
		_g_free0 (deps_filename);
		_g_free0 (path);
		return result;
	}
	result = TRUE;
	_g_free0 (deps_filename);
	_g_free0 (path);
	return result;
}


/**
 * Read the given filename and pull in packages.
 * The method is tolerant if the file does not exist.
 *
 * @param filename a filanem
 * @return false if an error occurs while reading the file or if a package could not be added
 */
static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


gboolean vala_code_context_add_packages_from_file (ValaCodeContext* self, const gchar* filename) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gchar* contents;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = g_file_test (filename, G_FILE_TEST_EXISTS);
	if (!_tmp0_) {
		result = TRUE;
		return result;
	}
	contents = NULL;
	g_file_get_contents (filename, &_tmp1_, NULL, &_inner_error_);
	_g_free0 (contents);
	contents = _tmp1_;
	if (_inner_error_ != NULL) {
		_g_free0 (contents);
		if (_inner_error_->domain == G_FILE_ERROR) {
			goto __catch0_g_file_error;
		}
		_g_free0 (contents);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp3_ = _tmp2_ = g_strsplit (contents, "\n", 0);
	{
		gchar** package_collection;
		int package_collection_length1;
		int package_it;
		package_collection = _tmp3_;
		package_collection_length1 = _vala_array_length (_tmp2_);
		for (package_it = 0; package_it < _vala_array_length (_tmp2_); package_it = package_it + 1) {
			gchar* _tmp4_;
			gchar* package;
			_tmp4_ = g_strdup (package_collection[package_it]);
			package = _tmp4_;
			{
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_;
				_tmp5_ = string_strip (package);
				_tmp6_ = _tmp5_;
				_g_free0 (package);
				package = _tmp6_;
				if (g_strcmp0 (package, "") != 0) {
					vala_code_context_add_external_package (self, package);
				}
				_g_free0 (package);
			}
		}
		package_collection = (_vala_array_free (package_collection, package_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (contents);
	goto __finally0;
	__catch0_g_file_error:
	{
		GError * e;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = g_strdup_printf ("Unable to read dependency file: %s", e->message);
		_tmp8_ = _tmp7_;
		vala_report_error (NULL, _tmp8_);
		_g_free0 (_tmp8_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


/**
 * Add the specified source file to the context. Only .vala, .vapi, .gs,
 * and .c extensions are supported.
 *
 * @param filename a filename
 * @param is_source true to force adding the file as .vala or .gs
 * @return false if the file is not recognized or the file does not exist
 */
gboolean vala_code_context_add_source_filename (ValaCodeContext* self, const gchar* filename, gboolean is_source) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gchar* _tmp3_ = NULL;
	gchar* rpath;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = g_file_test (filename, G_FILE_TEST_EXISTS);
	if (!_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = g_strdup_printf ("%s not found", filename);
		_tmp2_ = _tmp1_;
		vala_report_error (NULL, _tmp2_);
		_g_free0 (_tmp2_);
		result = FALSE;
		return result;
	}
	_tmp3_ = vala_code_context_realpath (filename);
	rpath = _tmp3_;
	if (is_source) {
		_tmp5_ = TRUE;
	} else {
		gboolean _tmp6_;
		_tmp6_ = g_str_has_suffix (filename, ".vala");
		_tmp5_ = _tmp6_;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp7_;
		_tmp7_ = g_str_has_suffix (filename, ".gs");
		_tmp4_ = _tmp7_;
	}
	if (_tmp4_) {
		ValaSourceFile* _tmp8_ = NULL;
		ValaSourceFile* source_file;
		_tmp8_ = vala_source_file_new (self, VALA_SOURCE_FILE_TYPE_SOURCE, rpath, NULL);
		source_file = _tmp8_;
		vala_source_file_set_relative_filename (source_file, filename);
		if (self->priv->_profile == VALA_PROFILE_POSIX) {
			ValaUnresolvedSymbol* _tmp9_ = NULL;
			ValaUnresolvedSymbol* _tmp10_;
			ValaUsingDirective* _tmp11_ = NULL;
			ValaUsingDirective* _tmp12_;
			ValaUsingDirective* ns_ref;
			ValaNamespace* _tmp13_ = NULL;
			_tmp9_ = vala_unresolved_symbol_new (NULL, "Posix", NULL);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_using_directive_new ((ValaSymbol*) _tmp10_, NULL);
			ns_ref = (_tmp12_ = _tmp11_, _vala_code_node_unref0 (_tmp10_), _tmp12_);
			vala_source_file_add_using_directive (source_file, ns_ref);
			_tmp13_ = vala_code_context_get_root (self);
			vala_namespace_add_using_directive (_tmp13_, ns_ref);
			_vala_code_node_unref0 (ns_ref);
		} else {
			if (self->priv->_profile == VALA_PROFILE_GOBJECT) {
				ValaUnresolvedSymbol* _tmp14_ = NULL;
				ValaUnresolvedSymbol* _tmp15_;
				ValaUsingDirective* _tmp16_ = NULL;
				ValaUsingDirective* _tmp17_;
				ValaUsingDirective* ns_ref;
				ValaNamespace* _tmp18_ = NULL;
				_tmp14_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
				_tmp15_ = _tmp14_;
				_tmp16_ = vala_using_directive_new ((ValaSymbol*) _tmp15_, NULL);
				ns_ref = (_tmp17_ = _tmp16_, _vala_code_node_unref0 (_tmp15_), _tmp17_);
				vala_source_file_add_using_directive (source_file, ns_ref);
				_tmp18_ = vala_code_context_get_root (self);
				vala_namespace_add_using_directive (_tmp18_, ns_ref);
				_vala_code_node_unref0 (ns_ref);
			} else {
				if (self->priv->_profile == VALA_PROFILE_DOVA) {
					ValaUnresolvedSymbol* _tmp19_ = NULL;
					ValaUnresolvedSymbol* _tmp20_;
					ValaUsingDirective* _tmp21_ = NULL;
					ValaUsingDirective* _tmp22_;
					ValaUsingDirective* ns_ref;
					ValaNamespace* _tmp23_ = NULL;
					_tmp19_ = vala_unresolved_symbol_new (NULL, "Dova", NULL);
					_tmp20_ = _tmp19_;
					_tmp21_ = vala_using_directive_new ((ValaSymbol*) _tmp20_, NULL);
					ns_ref = (_tmp22_ = _tmp21_, _vala_code_node_unref0 (_tmp20_), _tmp22_);
					vala_source_file_add_using_directive (source_file, ns_ref);
					_tmp23_ = vala_code_context_get_root (self);
					vala_namespace_add_using_directive (_tmp23_, ns_ref);
					_vala_code_node_unref0 (ns_ref);
				}
			}
		}
		vala_code_context_add_source_file (self, source_file);
		_vala_source_file_unref0 (source_file);
	} else {
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_;
		_tmp25_ = g_str_has_suffix (filename, ".vapi");
		if (_tmp25_) {
			_tmp24_ = TRUE;
		} else {
			gboolean _tmp26_;
			_tmp26_ = g_str_has_suffix (filename, ".gir");
			_tmp24_ = _tmp26_;
		}
		if (_tmp24_) {
			ValaSourceFile* _tmp27_ = NULL;
			ValaSourceFile* source_file;
			glong _tmp28_;
			glong _tmp29_;
			gchar* _tmp30_ = NULL;
			gchar* _tmp31_;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_;
			gchar* deps_filename;
			gboolean _tmp34_;
			_tmp27_ = vala_source_file_new (self, VALA_SOURCE_FILE_TYPE_PACKAGE, rpath, NULL);
			source_file = _tmp27_;
			vala_source_file_set_relative_filename (source_file, filename);
			vala_code_context_add_source_file (self, source_file);
			_tmp28_ = strlen (filename);
			_tmp29_ = strlen (".vapi");
			_tmp30_ = g_strndup (filename, (gsize) (_tmp28_ - _tmp29_));
			_tmp31_ = _tmp30_;
			_tmp32_ = g_strdup_printf ("%s.deps", _tmp31_);
			deps_filename = (_tmp33_ = _tmp32_, _g_free0 (_tmp31_), _tmp33_);
			_tmp34_ = vala_code_context_add_packages_from_file (self, deps_filename);
			if (!_tmp34_) {
				result = FALSE;
				_g_free0 (deps_filename);
				_vala_source_file_unref0 (source_file);
				_g_free0 (rpath);
				return result;
			}
			_g_free0 (deps_filename);
			_vala_source_file_unref0 (source_file);
		} else {
			gboolean _tmp35_;
			_tmp35_ = g_str_has_suffix (filename, ".c");
			if (_tmp35_) {
				vala_code_context_add_c_source_file (self, rpath);
			} else {
				gchar* _tmp36_ = NULL;
				gchar* _tmp37_;
				_tmp36_ = g_strdup_printf ("%s is not a supported source file type. Only .vala, .vapi, .gs, and .c" \
" files are supported.", filename);
				_tmp37_ = _tmp36_;
				vala_report_error (NULL, _tmp37_);
				_g_free0 (_tmp37_);
				result = FALSE;
				_g_free0 (rpath);
				return result;
			}
		}
	}
	result = TRUE;
	_g_free0 (rpath);
	return result;
}


/**
 * Visits the complete code tree file by file.
 * It is possible to add new source files while visiting the tree.
 *
 * @param visitor the visitor to be called when traversing
 */
void vala_code_context_accept (ValaCodeContext* self, ValaCodeVisitor* visitor) {
	ValaNamespace* _tmp0_ = NULL;
	gint index;
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_code_context_get_root (self);
	vala_code_node_accept ((ValaCodeNode*) _tmp0_, visitor);
	index = 0;
	while (TRUE) {
		gint _tmp1_;
		gpointer _tmp2_ = NULL;
		ValaSourceFile* source_file;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) self->priv->source_files);
		if (!(index < _tmp1_)) {
			break;
		}
		_tmp2_ = vala_list_get (self->priv->source_files, index);
		source_file = (ValaSourceFile*) _tmp2_;
		vala_source_file_accept (source_file, visitor);
		index++;
		_vala_source_file_unref0 (source_file);
	}
}


void vala_code_context_add_define (ValaCodeContext* self, const gchar* define) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (define != NULL);
	vala_collection_add ((ValaCollection*) self->priv->defines, define);
}


gboolean vala_code_context_is_defined (ValaCodeContext* self, const gchar* define) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (define != NULL, FALSE);
	_tmp0_ = vala_collection_contains ((ValaCollection*) self->priv->defines, define);
	result = _tmp0_;
	return result;
}


gchar* vala_code_context_get_vapi_path (ValaCodeContext* self, const gchar* pkg) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* path;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pkg != NULL, NULL);
	_tmp0_ = g_strconcat (pkg, ".vapi", NULL);
	_tmp1_ = vala_code_context_get_file_path (self, _tmp0_, "vala" PACKAGE_SUFFIX "/vapi", "vala/vapi", self->vapi_directories, self->vapi_directories_length1);
	path = (_tmp2_ = _tmp1_, _g_free0 (_tmp0_), _tmp2_);
	if (path == NULL) {
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* filename;
		gboolean _tmp6_;
		_tmp3_ = g_strconcat (pkg, ".vapi", NULL);
		_tmp4_ = g_build_filename (PACKAGE_DATADIR, "vapi", _tmp3_, NULL);
		filename = (_tmp5_ = _tmp4_, _g_free0 (_tmp3_), _tmp5_);
		_tmp6_ = g_file_test (filename, G_FILE_TEST_EXISTS);
		if (_tmp6_) {
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = g_strdup (filename);
			_tmp8_ = _tmp7_;
			_g_free0 (path);
			path = _tmp8_;
		}
		_g_free0 (filename);
	}
	result = path;
	return result;
}


gchar* vala_code_context_get_gir_path (ValaCodeContext* self, const gchar* gir) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gir != NULL, NULL);
	_tmp0_ = g_strconcat (gir, ".gir", NULL);
	_tmp1_ = vala_code_context_get_file_path (self, _tmp0_, "gir-1.0", NULL, self->gir_directories, self->gir_directories_length1);
	result = (_tmp2_ = _tmp1_, _g_free0 (_tmp0_), _tmp2_);
	return result;
}


static gchar* vala_code_context_get_file_path (ValaCodeContext* self, const gchar* basename, const gchar* versioned_data_dir, const gchar* data_dir, gchar** directories, int directories_length1) {
	gchar* result = NULL;
	gchar* filename;
	gchar** _tmp4_;
	gchar** _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (basename != NULL, NULL);
	g_return_val_if_fail (versioned_data_dir != NULL, NULL);
	filename = NULL;
	if (directories != NULL) {
		{
			gchar** dir_collection;
			int dir_collection_length1;
			int dir_it;
			dir_collection = directories;
			dir_collection_length1 = directories_length1;
			for (dir_it = 0; dir_it < directories_length1; dir_it = dir_it + 1) {
				gchar* _tmp0_;
				gchar* dir;
				_tmp0_ = g_strdup (dir_collection[dir_it]);
				dir = _tmp0_;
				{
					gchar* _tmp1_ = NULL;
					gchar* _tmp2_;
					gboolean _tmp3_;
					_tmp1_ = g_build_filename (dir, basename, NULL);
					_tmp2_ = _tmp1_;
					_g_free0 (filename);
					filename = _tmp2_;
					_tmp3_ = g_file_test (filename, G_FILE_TEST_EXISTS);
					if (_tmp3_) {
						result = filename;
						_g_free0 (dir);
						return result;
					}
					_g_free0 (dir);
				}
			}
		}
	}
	_tmp5_ = _tmp4_ = g_get_system_data_dirs ();
	{
		gchar** dir_collection;
		int dir_collection_length1;
		int dir_it;
		dir_collection = _tmp5_;
		dir_collection_length1 = _vala_array_length (_tmp4_);
		for (dir_it = 0; dir_it < _vala_array_length (_tmp4_); dir_it = dir_it + 1) {
			gchar* _tmp6_;
			gchar* dir;
			_tmp6_ = g_strdup (dir_collection[dir_it]);
			dir = _tmp6_;
			{
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				gboolean _tmp9_;
				_tmp7_ = g_build_filename (dir, versioned_data_dir, basename, NULL);
				_tmp8_ = _tmp7_;
				_g_free0 (filename);
				filename = _tmp8_;
				_tmp9_ = g_file_test (filename, G_FILE_TEST_EXISTS);
				if (_tmp9_) {
					result = filename;
					_g_free0 (dir);
					return result;
				}
				_g_free0 (dir);
			}
		}
	}
	if (data_dir != NULL) {
		gchar** _tmp10_;
		gchar** _tmp11_ = NULL;
		_tmp11_ = _tmp10_ = g_get_system_data_dirs ();
		{
			gchar** dir_collection;
			int dir_collection_length1;
			int dir_it;
			dir_collection = _tmp11_;
			dir_collection_length1 = _vala_array_length (_tmp10_);
			for (dir_it = 0; dir_it < _vala_array_length (_tmp10_); dir_it = dir_it + 1) {
				gchar* _tmp12_;
				gchar* dir;
				_tmp12_ = g_strdup (dir_collection[dir_it]);
				dir = _tmp12_;
				{
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_;
					gboolean _tmp15_;
					_tmp13_ = g_build_filename (dir, data_dir, basename, NULL);
					_tmp14_ = _tmp13_;
					_g_free0 (filename);
					filename = _tmp14_;
					_tmp15_ = g_file_test (filename, G_FILE_TEST_EXISTS);
					if (_tmp15_) {
						result = filename;
						_g_free0 (dir);
						return result;
					}
					_g_free0 (dir);
				}
			}
		}
	}
	result = NULL;
	_g_free0 (filename);
	return result;
}


void vala_code_context_write_dependencies (ValaCodeContext* self, const gchar* filename) {
	FILE* _tmp0_ = NULL;
	FILE* stream;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = fopen (filename, "w");
	stream = _tmp0_;
	if (stream == NULL) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = g_strdup_printf ("unable to open `%s' for writing", filename);
		_tmp2_ = _tmp1_;
		vala_report_error (NULL, _tmp2_);
		_g_free0 (_tmp2_);
		_fclose0 (stream);
		return;
	}
	fprintf (stream, "%s:", filename);
	{
		ValaList* _tmp3_;
		ValaList* _src_list;
		gint _tmp4_;
		gint _src_size;
		gint _src_index;
		_tmp3_ = _vala_iterable_ref0 (self->priv->source_files);
		_src_list = _tmp3_;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _src_list);
		_src_size = _tmp4_;
		_src_index = -1;
		while (TRUE) {
			gpointer _tmp5_ = NULL;
			ValaSourceFile* src;
			gboolean _tmp6_ = FALSE;
			ValaSourceFileType _tmp7_;
			_src_index = _src_index + 1;
			if (!(_src_index < _src_size)) {
				break;
			}
			_tmp5_ = vala_list_get (_src_list, _src_index);
			src = (ValaSourceFile*) _tmp5_;
			_tmp7_ = vala_source_file_get_file_type (src);
			if (_tmp7_ == VALA_SOURCE_FILE_TYPE_FAST) {
				gboolean _tmp8_;
				_tmp8_ = vala_source_file_get_used (src);
				_tmp6_ = _tmp8_;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				const gchar* _tmp9_ = NULL;
				_tmp9_ = vala_source_file_get_filename (src);
				fprintf (stream, " %s", _tmp9_);
			}
			_vala_source_file_unref0 (src);
		}
		_vala_iterable_unref0 (_src_list);
	}
	fprintf (stream, "\n\n");
	_fclose0 (stream);
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}


static gunichar string_get_char (const gchar* self, gint index) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_utf8_get_char (((gchar*) self) + index);
	result = _tmp0_;
	return result;
}


static gboolean vala_code_context_ends_with_dir_separator (const gchar* s) {
	gboolean result = FALSE;
	glong _tmp0_;
	const gchar* _tmp1_ = NULL;
	gunichar _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (s != NULL, FALSE);
	_tmp0_ = strlen (s);
	_tmp1_ = string_offset (s, _tmp0_ - 1);
	_tmp2_ = string_get_char (_tmp1_, 0);
	_tmp3_ = G_IS_DIR_SEPARATOR (_tmp2_);
	result = _tmp3_;
	return result;
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong _tmp0_;
	glong string_length;
	const gchar* _tmp1_ = NULL;
	const gchar* start;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = _tmp0_;
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp1_ = string_offset (self, offset);
	start = _tmp1_;
	_tmp2_ = string_offset (start, len);
	_tmp3_ = g_strndup (start, ((gchar*) _tmp2_) - ((gchar*) start));
	result = _tmp3_;
	return result;
}


static glong string_pointer_to_offset (const gchar* self, const gchar* pos) {
	glong result = 0L;
	g_return_val_if_fail (self != NULL, 0L);
	g_return_val_if_fail (pos != NULL, 0L);
	result = (glong) (((gchar*) pos) - ((gchar*) self));
	return result;
}


gchar* vala_code_context_realpath (const gchar* name) {
	gchar* result = NULL;
	gchar* rpath;
	const gchar* start;
	const gchar* end;
	gboolean _tmp0_;
	const gchar* _tmp7_ = NULL;
	glong _tmp8_;
	glong root_len;
	gboolean _tmp35_ = FALSE;
	glong _tmp36_;
	g_return_val_if_fail (name != NULL, NULL);
	rpath = NULL;
	start = NULL;
	end = NULL;
	_tmp0_ = g_path_is_absolute (name);
	if (!_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = g_get_current_dir ();
		_tmp2_ = _tmp1_;
		_g_free0 (rpath);
		rpath = _tmp2_;
		end = name;
		start = end;
	} else {
		const gchar* _tmp3_ = NULL;
		glong _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp3_ = g_path_skip_root (name);
		end = _tmp3_;
		start = end;
		_tmp4_ = string_pointer_to_offset (name, start);
		_tmp5_ = string_substring (name, (glong) 0, _tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (rpath);
		rpath = _tmp6_;
	}
	_tmp7_ = g_path_skip_root (rpath);
	_tmp8_ = string_pointer_to_offset (rpath, _tmp7_);
	root_len = _tmp8_;
	{
		gboolean _tmp9_;
		_tmp9_ = TRUE;
		while (TRUE) {
			gunichar _tmp10_;
			glong len;
			if (!_tmp9_) {
				start = end;
			}
			_tmp9_ = FALSE;
			_tmp10_ = string_get_char (start, 0);
			if (!(_tmp10_ != 0)) {
				break;
			}
			while (TRUE) {
				gunichar _tmp11_;
				gboolean _tmp12_;
				const gchar* _tmp13_ = NULL;
				_tmp11_ = string_get_char (start, 0);
				_tmp12_ = G_IS_DIR_SEPARATOR (_tmp11_);
				if (!_tmp12_) {
					break;
				}
				_tmp13_ = g_utf8_next_char (start);
				start = _tmp13_;
			}
			len = (glong) 0;
			{
				gboolean _tmp14_;
				end = start;
				_tmp14_ = TRUE;
				while (TRUE) {
					gboolean _tmp16_ = FALSE;
					gunichar _tmp17_;
					if (!_tmp14_) {
						const gchar* _tmp15_ = NULL;
						_tmp15_ = g_utf8_next_char (end);
						end = _tmp15_;
					}
					_tmp14_ = FALSE;
					_tmp17_ = string_get_char (end, 0);
					if (_tmp17_ != 0) {
						gunichar _tmp18_;
						gboolean _tmp19_;
						_tmp18_ = string_get_char (end, 0);
						_tmp19_ = G_IS_DIR_SEPARATOR (_tmp18_);
						_tmp16_ = !_tmp19_;
					} else {
						_tmp16_ = FALSE;
					}
					if (!_tmp16_) {
						break;
					}
					len++;
				}
			}
			if (len == 0) {
				break;
			} else {
				gboolean _tmp20_ = FALSE;
				if (len == 1) {
					gunichar _tmp21_;
					_tmp21_ = string_get_char (start, 0);
					_tmp20_ = _tmp21_ == '.';
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
				} else {
					gboolean _tmp22_ = FALSE;
					if (len == 2) {
						gboolean _tmp23_;
						_tmp23_ = g_str_has_prefix (start, "..");
						_tmp22_ = _tmp23_;
					} else {
						_tmp22_ = FALSE;
					}
					if (_tmp22_) {
						glong _tmp24_;
						_tmp24_ = strlen (rpath);
						if (_tmp24_ > root_len) {
							{
								gboolean _tmp25_;
								_tmp25_ = TRUE;
								while (TRUE) {
									glong _tmp27_;
									gchar* _tmp28_ = NULL;
									gchar* _tmp29_;
									if (!_tmp25_) {
										gboolean _tmp26_;
										_tmp26_ = vala_code_context_ends_with_dir_separator (rpath);
										if (!(!_tmp26_)) {
											break;
										}
									}
									_tmp25_ = FALSE;
									_tmp27_ = strlen (rpath);
									_tmp28_ = string_substring (rpath, (glong) 0, _tmp27_ - 1);
									_tmp29_ = _tmp28_;
									_g_free0 (rpath);
									rpath = _tmp29_;
								}
							}
						}
					} else {
						gboolean _tmp30_;
						gchar* _tmp32_ = NULL;
						gchar* _tmp33_;
						gchar* _tmp34_;
						_tmp30_ = vala_code_context_ends_with_dir_separator (rpath);
						if (!_tmp30_) {
							gchar* _tmp31_;
							_tmp31_ = g_strconcat (rpath, G_DIR_SEPARATOR_S, NULL);
							_g_free0 (rpath);
							rpath = _tmp31_;
						}
						_tmp32_ = string_substring (start, (glong) 0, len);
						_tmp33_ = _tmp32_;
						_tmp34_ = g_strconcat (rpath, _tmp33_, NULL);
						_g_free0 (rpath);
						rpath = _tmp34_;
						_g_free0 (_tmp33_);
					}
				}
			}
		}
	}
	_tmp36_ = strlen (rpath);
	if (_tmp36_ > root_len) {
		gboolean _tmp37_;
		_tmp37_ = vala_code_context_ends_with_dir_separator (rpath);
		_tmp35_ = _tmp37_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		glong _tmp38_;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_;
		_tmp38_ = strlen (rpath);
		_tmp39_ = string_substring (rpath, (glong) 0, _tmp38_ - 1);
		_tmp40_ = _tmp39_;
		_g_free0 (rpath);
		rpath = _tmp40_;
	}
	if (G_DIR_SEPARATOR != '/') {
		gchar** _tmp41_;
		gchar** _tmp42_ = NULL;
		gint components_length1;
		gint _components_size_;
		gchar** _tmp43_;
		gchar** components;
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_;
		_tmp42_ = _tmp41_ = g_strsplit (rpath, "\\", 0);
		_tmp43_ = _tmp42_;
		components_length1 = _vala_array_length (_tmp41_);
		_components_size_ = components_length1;
		components = _tmp43_;
		_tmp44_ = g_strjoinv ("/", components);
		_tmp45_ = _tmp44_;
		_g_free0 (rpath);
		rpath = _tmp45_;
		components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
	}
	result = rpath;
	return result;
}


gboolean vala_code_context_get_assert (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_assert;
	return result;
}


void vala_code_context_set_assert (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_assert = value;
}


gboolean vala_code_context_get_checking (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_checking;
	return result;
}


void vala_code_context_set_checking (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_checking = value;
}


gboolean vala_code_context_get_deprecated (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_deprecated;
	return result;
}


void vala_code_context_set_deprecated (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_deprecated = value;
}


gboolean vala_code_context_get_experimental (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_experimental;
	return result;
}


void vala_code_context_set_experimental (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_experimental = value;
}


gboolean vala_code_context_get_experimental_non_null (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_experimental_non_null;
	return result;
}


void vala_code_context_set_experimental_non_null (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_experimental_non_null = value;
}


gboolean vala_code_context_get_dbus_transformation (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_dbus_transformation;
	return result;
}


void vala_code_context_set_dbus_transformation (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_dbus_transformation = value;
}


gboolean vala_code_context_get_ccode_only (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_ccode_only;
	return result;
}


void vala_code_context_set_ccode_only (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_ccode_only = value;
}


const gchar* vala_code_context_get_header_filename (ValaCodeContext* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_header_filename;
	return result;
}


void vala_code_context_set_header_filename (ValaCodeContext* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_header_filename);
	self->priv->_header_filename = _tmp1_;
}


const gchar* vala_code_context_get_internal_header_filename (ValaCodeContext* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_internal_header_filename;
	return result;
}


void vala_code_context_set_internal_header_filename (ValaCodeContext* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_internal_header_filename);
	self->priv->_internal_header_filename = _tmp1_;
}


gboolean vala_code_context_get_use_header (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_use_header;
	return result;
}


void vala_code_context_set_use_header (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_use_header = value;
}


const gchar* vala_code_context_get_includedir (ValaCodeContext* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_includedir;
	return result;
}


void vala_code_context_set_includedir (ValaCodeContext* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_includedir);
	self->priv->_includedir = _tmp1_;
}


const gchar* vala_code_context_get_symbols_filename (ValaCodeContext* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_symbols_filename;
	return result;
}


void vala_code_context_set_symbols_filename (ValaCodeContext* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_symbols_filename);
	self->priv->_symbols_filename = _tmp1_;
}


gboolean vala_code_context_get_compile_only (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_compile_only;
	return result;
}


void vala_code_context_set_compile_only (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_compile_only = value;
}


const gchar* vala_code_context_get_output (ValaCodeContext* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_output;
	return result;
}


void vala_code_context_set_output (ValaCodeContext* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_output);
	self->priv->_output = _tmp1_;
}


const gchar* vala_code_context_get_basedir (ValaCodeContext* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_basedir;
	return result;
}


void vala_code_context_set_basedir (ValaCodeContext* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_basedir);
	self->priv->_basedir = _tmp1_;
}


const gchar* vala_code_context_get_directory (ValaCodeContext* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_directory;
	return result;
}


void vala_code_context_set_directory (ValaCodeContext* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_directory);
	self->priv->_directory = _tmp1_;
}


gboolean vala_code_context_get_debug (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_debug;
	return result;
}


void vala_code_context_set_debug (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_debug = value;
}


gint vala_code_context_get_optlevel (ValaCodeContext* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_optlevel;
	return result;
}


void vala_code_context_set_optlevel (ValaCodeContext* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_optlevel = value;
}


gboolean vala_code_context_get_thread (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_thread;
	return result;
}


void vala_code_context_set_thread (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_thread = value;
}


gboolean vala_code_context_get_mem_profiler (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_mem_profiler;
	return result;
}


void vala_code_context_set_mem_profiler (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_mem_profiler = value;
}


ValaMethod* vala_code_context_get_module_init_method (ValaCodeContext* self) {
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_module_init_method;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_code_context_set_module_init_method (ValaCodeContext* self, ValaMethod* value) {
	ValaMethod* _tmp0_;
	ValaMethod* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_code_node_unref0 (self->priv->_module_init_method);
	self->priv->_module_init_method = _tmp1_;
}


gboolean vala_code_context_get_save_temps (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_save_temps;
	return result;
}


void vala_code_context_set_save_temps (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_save_temps = value;
}


ValaProfile vala_code_context_get_profile (ValaCodeContext* self) {
	ValaProfile result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_profile;
	return result;
}


void vala_code_context_set_profile (ValaCodeContext* self, ValaProfile value) {
	g_return_if_fail (self != NULL);
	self->priv->_profile = value;
}


gint vala_code_context_get_target_glib_major (ValaCodeContext* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_target_glib_major;
	return result;
}


void vala_code_context_set_target_glib_major (ValaCodeContext* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_target_glib_major = value;
}


gint vala_code_context_get_target_glib_minor (ValaCodeContext* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_target_glib_minor;
	return result;
}


void vala_code_context_set_target_glib_minor (ValaCodeContext* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_target_glib_minor = value;
}


gboolean vala_code_context_get_verbose_mode (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_verbose_mode;
	return result;
}


void vala_code_context_set_verbose_mode (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_verbose_mode = value;
}


gboolean vala_code_context_get_version_header (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_version_header;
	return result;
}


void vala_code_context_set_version_header (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_version_header = value;
}


gboolean vala_code_context_get_nostdpkg (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_nostdpkg;
	return result;
}


void vala_code_context_set_nostdpkg (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_nostdpkg = value;
}


gboolean vala_code_context_get_save_csources (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_save_temps;
	return result;
}


ValaReport* vala_code_context_get_report (ValaCodeContext* self) {
	ValaReport* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_report;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void vala_code_context_set_report (ValaCodeContext* self, ValaReport* value) {
	ValaReport* _tmp0_;
	ValaReport* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_report);
	self->priv->_report = _tmp1_;
}


ValaMethod* vala_code_context_get_entry_point (ValaCodeContext* self) {
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_entry_point;
	return result;
}


void vala_code_context_set_entry_point (ValaCodeContext* self, ValaMethod* value) {
	ValaMethod* _tmp0_;
	ValaMethod* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_code_node_unref0 (self->priv->_entry_point);
	self->priv->_entry_point = _tmp1_;
}


const gchar* vala_code_context_get_entry_point_name (ValaCodeContext* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_entry_point_name;
	return result;
}


void vala_code_context_set_entry_point_name (ValaCodeContext* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_entry_point_name);
	self->priv->_entry_point_name = _tmp1_;
}


gboolean vala_code_context_get_run_output (ValaCodeContext* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_run_output;
	return result;
}


void vala_code_context_set_run_output (ValaCodeContext* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_run_output = value;
}


ValaNamespace* vala_code_context_get_root (ValaCodeContext* self) {
	ValaNamespace* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_root;
	return result;
}


ValaCodeGenerator* vala_code_context_get_codegen (ValaCodeContext* self) {
	ValaCodeGenerator* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_codegen;
	return result;
}


static gpointer _vala_code_visitor_ref0 (gpointer self) {
	return self ? vala_code_visitor_ref (self) : NULL;
}


void vala_code_context_set_codegen (ValaCodeContext* self, ValaCodeGenerator* value) {
	ValaCodeGenerator* _tmp0_;
	ValaCodeGenerator* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_visitor_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_code_visitor_unref0 (self->priv->_codegen);
	self->priv->_codegen = _tmp1_;
}


static void vala_value_code_context_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_code_context_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_code_context_unref (value->data[0].v_pointer);
	}
}


static void vala_value_code_context_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_code_context_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_code_context_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_code_context_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCodeContext* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_code_context_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_code_context_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCodeContext** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_code_context_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCodeContext* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CODE_CONTEXT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_code_context (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_CONTEXT), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_code_context (GValue* value, gpointer v_object) {
	ValaCodeContext* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CODE_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_code_context_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_code_context_unref (old);
	}
}


void vala_value_take_code_context (GValue* value, gpointer v_object) {
	ValaCodeContext* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CODE_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_code_context_unref (old);
	}
}


static void vala_code_context_class_init (ValaCodeContextClass * klass) {
	GStaticPrivate _tmp0_ = {0};
	GStaticPrivate _tmp1_ = {0};
	vala_code_context_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_CONTEXT_CLASS (klass)->finalize = vala_code_context_finalize;
	g_type_class_add_private (klass, sizeof (ValaCodeContextPrivate));
	g_static_private_init (&_tmp0_);
	_tmp1_ = _tmp0_;
	vala_code_context_context_stack_key = _tmp1_;
}


static void vala_code_context_instance_init (ValaCodeContext * self) {
	ValaReport* _tmp0_ = NULL;
	ValaArrayList* _tmp1_ = NULL;
	ValaArrayList* _tmp2_ = NULL;
	ValaNamespace* _tmp3_ = NULL;
	ValaArrayList* _tmp4_ = NULL;
	ValaHashSet* _tmp5_ = NULL;
	ValaCodeGenerator* _tmp6_ = NULL;
	self->priv = VALA_CODE_CONTEXT_GET_PRIVATE (self);
	_tmp0_ = vala_report_new ();
	self->priv->_report = _tmp0_;
	_tmp1_ = vala_array_list_new (VALA_TYPE_SOURCE_FILE, (GBoxedCopyFunc) vala_source_file_ref, vala_source_file_unref, g_direct_equal);
	self->priv->source_files = (ValaList*) _tmp1_;
	_tmp2_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	self->priv->c_source_files = (ValaList*) _tmp2_;
	_tmp3_ = vala_namespace_new (NULL, NULL);
	self->priv->_root = _tmp3_;
	_tmp4_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	self->priv->packages = (ValaList*) _tmp4_;
	_tmp5_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	self->priv->defines = (ValaSet*) _tmp5_;
	_tmp6_ = vala_code_generator_new ();
	self->priv->_codegen = _tmp6_;
	self->ref_count = 1;
}


static void vala_code_context_finalize (ValaCodeContext* obj) {
	ValaCodeContext * self;
	self = VALA_CODE_CONTEXT (obj);
	_g_free0 (self->priv->_header_filename);
	_g_free0 (self->priv->_internal_header_filename);
	_g_free0 (self->priv->_includedir);
	_g_free0 (self->priv->_symbols_filename);
	_g_free0 (self->priv->_output);
	_g_free0 (self->priv->_basedir);
	_g_free0 (self->priv->_directory);
	self->vapi_directories = (_vala_array_free (self->vapi_directories, self->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	self->gir_directories = (_vala_array_free (self->gir_directories, self->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (self->priv->_module_init_method);
	_g_object_unref0 (self->priv->_report);
	_vala_code_node_unref0 (self->priv->_entry_point);
	_g_free0 (self->priv->_entry_point_name);
	_vala_iterable_unref0 (self->priv->source_files);
	_vala_iterable_unref0 (self->priv->c_source_files);
	_vala_code_node_unref0 (self->priv->_root);
	_vala_iterable_unref0 (self->priv->packages);
	_vala_iterable_unref0 (self->priv->defines);
	_vala_code_visitor_unref0 (self->priv->_codegen);
}


/**
 * The root of the code tree.
 */
GType vala_code_context_get_type (void) {
	static volatile gsize vala_code_context_type_id__volatile = 0;
	if (g_once_init_enter (&vala_code_context_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_code_context_init, vala_value_code_context_free_value, vala_value_code_context_copy_value, vala_value_code_context_peek_pointer, "p", vala_value_code_context_collect_value, "p", vala_value_code_context_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCodeContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeContext), 0, (GInstanceInitFunc) vala_code_context_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_code_context_type_id;
		vala_code_context_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCodeContext", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_code_context_type_id__volatile, vala_code_context_type_id);
	}
	return vala_code_context_type_id__volatile;
}


gpointer vala_code_context_ref (gpointer instance) {
	ValaCodeContext* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_code_context_unref (gpointer instance) {
	ValaCodeContext* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CODE_CONTEXT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



