/* valaclasstype.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaclasstype.h>
#include <vala/valadatatype.h>

struct _ValaClassTypePrivate {
	ValaClass* _class_symbol;
};
#define VALA_CLASS_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CLASS_TYPE, ValaClassTypePrivate))
enum  {
	VALA_CLASS_TYPE_DUMMY_PROPERTY,
	VALA_CLASS_TYPE_CLASS_SYMBOL
};
static gpointer vala_class_type_parent_class = NULL;
static void vala_class_type_dispose (GObject * obj);


ValaClassType* vala_class_type_new (ValaClass* class_symbol) {
	ValaClassType * self;
	g_return_val_if_fail (class_symbol == NULL || VALA_IS_CLASS (class_symbol), NULL);
	self = g_object_newv (VALA_TYPE_CLASS_TYPE, 0, NULL);
	vala_data_type_set_data_type (VALA_DATA_TYPE (self), VALA_TYPESYMBOL (class_symbol));
	vala_class_type_set_class_symbol (self, class_symbol);
	return self;
}


ValaClass* vala_class_type_get_class_symbol (ValaClassType* self) {
	g_return_val_if_fail (VALA_IS_CLASS_TYPE (self), NULL);
	return self->priv->_class_symbol;
}


void vala_class_type_set_class_symbol (ValaClassType* self, ValaClass* value) {
	g_return_if_fail (VALA_IS_CLASS_TYPE (self));
	self->priv->_class_symbol = value;
}


static void vala_class_type_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaClassType * self;
	self = VALA_CLASS_TYPE (object);
	switch (property_id) {
		case VALA_CLASS_TYPE_CLASS_SYMBOL:
		g_value_set_object (value, vala_class_type_get_class_symbol (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_class_type_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaClassType * self;
	self = VALA_CLASS_TYPE (object);
	switch (property_id) {
		case VALA_CLASS_TYPE_CLASS_SYMBOL:
		vala_class_type_set_class_symbol (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_class_type_class_init (ValaClassTypeClass * klass) {
	vala_class_type_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaClassTypePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_class_type_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_class_type_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_class_type_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CLASS_TYPE_CLASS_SYMBOL, g_param_spec_object ("class-symbol", "class-symbol", "class-symbol", VALA_TYPE_CLASS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_class_type_init (ValaClassType * self) {
	self->priv = VALA_CLASS_TYPE_GET_PRIVATE (self);
}


static void vala_class_type_dispose (GObject * obj) {
	ValaClassType * self;
	self = VALA_CLASS_TYPE (obj);
	G_OBJECT_CLASS (vala_class_type_parent_class)->dispose (obj);
}


GType vala_class_type_get_type (void) {
	static GType vala_class_type_type_id = 0;
	if (G_UNLIKELY (vala_class_type_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaClassTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClassType), 0, (GInstanceInitFunc) vala_class_type_init };
		vala_class_type_type_id = g_type_register_static (VALA_TYPE_REFERENCE_TYPE, "ValaClassType", &g_define_type_info, 0);
	}
	return vala_class_type_type_id;
}




