/* valanullliteral.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valanullliteral.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>

enum  {
	VALA_NULL_LITERAL_DUMMY_PROPERTY
};
static void vala_null_literal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static char* vala_null_literal_real_to_string (ValaCodeNode* base);
static gpointer vala_null_literal_parent_class = NULL;


/**
 * Creates a new null literal.
 *
 * @param source reference to source code
 * @return       newly created null literal
 */
ValaNullLiteral* vala_null_literal_new (ValaSourceReference* source) {
	ValaNullLiteral * self;
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	self = g_object_newv (VALA_TYPE_NULL_LITERAL, 0, NULL);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source);
	return self;
}


static void vala_null_literal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaNullLiteral * self;
	self = VALA_NULL_LITERAL (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_null_literal (visitor, self);
}


static char* vala_null_literal_real_to_string (ValaCodeNode* base) {
	ValaNullLiteral * self;
	self = VALA_NULL_LITERAL (base);
	return g_strdup ("null");
}


static void vala_null_literal_class_init (ValaNullLiteralClass * klass) {
	vala_null_literal_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->accept = vala_null_literal_real_accept;
	VALA_CODE_NODE_CLASS (klass)->to_string = vala_null_literal_real_to_string;
}


static void vala_null_literal_init (ValaNullLiteral * self) {
}


GType vala_null_literal_get_type (void) {
	static GType vala_null_literal_type_id = 0;
	if (G_UNLIKELY (vala_null_literal_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaNullLiteralClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_null_literal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaNullLiteral), 0, (GInstanceInitFunc) vala_null_literal_init };
		vala_null_literal_type_id = g_type_register_static (VALA_TYPE_LITERAL, "ValaNullLiteral", &g_define_type_info, 0);
	}
	return vala_null_literal_type_id;
}




