/* vala.vapi generated by lt-valac, do not modify. */

[CCode (cprefix = "Vala", lower_case_cprefix = "vala_")]
namespace Vala {
	[CCode (cprefix = "VALA_ASSIGNMENT_OPERATOR_", cheader_filename = "vala/valaassignment.h")]
	public enum AssignmentOperator {
		SIMPLE,
		BITWISE_OR,
		BITWISE_AND,
		BITWISE_XOR,
		ADD,
		SUB,
		MUL,
		DIV,
		PERCENT,
		SHIFT_LEFT,
		SHIFT_RIGHT,
	}
	[CCode (cprefix = "VALA_BINARY_OPERATOR_", cheader_filename = "vala/valabinaryexpression.h")]
	public enum BinaryOperator {
		PLUS,
		MINUS,
		MUL,
		DIV,
		MOD,
		SHIFT_LEFT,
		SHIFT_RIGHT,
		LESS_THAN,
		GREATER_THAN,
		LESS_THAN_OR_EQUAL,
		GREATER_THAN_OR_EQUAL,
		EQUALITY,
		INEQUALITY,
		BITWISE_AND,
		BITWISE_OR,
		BITWISE_XOR,
		AND,
		OR,
		IN,
	}
	[CCode (cprefix = "VALA_SOURCE_FILE_DEPENDENCY_TYPE_", cheader_filename = "vala/valasourcefile.h")]
	public enum SourceFileDependencyType {
		HEADER_FULL,
		HEADER_SHALLOW,
		SOURCE,
	}
	[CCode (cprefix = "VALA_SYMBOL_ACCESSIBILITY_", cheader_filename = "vala/valasymbol.h")]
	public enum SymbolAccessibility {
		PRIVATE,
		INTERNAL,
		PROTECTED,
		PUBLIC,
	}
	[CCode (cprefix = "VALA_UNARY_OPERATOR_", cheader_filename = "vala/valaunaryexpression.h")]
	public enum UnaryOperator {
		PLUS,
		MINUS,
		LOGICAL_NEGATION,
		BITWISE_COMPLEMENT,
		INCREMENT,
		DECREMENT,
		REF,
		OUT,
	}
	[CCode (cheader_filename = "vala/valaaddressofexpression.h")]
	public class AddressofExpression : Vala.Expression {
		public AddressofExpression (Vala.Expression! inner, Vala.SourceReference source_reference = null);
		public Vala.Expression! inner { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valaarray.h")]
	public class Array : Vala.DataType {
		public Array (Vala.DataType! _element_type, int _rank, Vala.SourceReference _source_reference);
		public Array.with_type_parameter (Vala.TypeParameter! _element_type_parameter, int _rank, Vala.SourceReference _source_reference);
		public Vala.ArrayLengthField get_length_field ();
		public Vala.ArrayResizeMethod get_resize_method ();
		public Vala.ArrayMoveMethod get_move_method ();
		public weak Vala.DataType element_type { get; set construct; }
		public weak Vala.TypeParameter element_type_parameter { get; set construct; }
		public weak int rank { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valaarraycreationexpression.h")]
	public class ArrayCreationExpression : Vala.Expression {
		public void append_size (Vala.Expression! size);
		public Gee.List<Vala.Expression> get_sizes ();
		public ArrayCreationExpression (Vala.TypeReference element_type, int rank, Vala.InitializerList initializer_list, Vala.SourceReference source_reference);
		public Vala.TypeReference element_type { get; set construct; }
		public weak int rank { get; set construct; }
		public Vala.InitializerList initializer_list { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valaarraylengthfield.h")]
	public class ArrayLengthField : Vala.Field {
		public ArrayLengthField (Vala.SourceReference source_reference);
	}
	[CCode (cheader_filename = "vala/valaarraymovemethod.h")]
	public class ArrayMoveMethod : Vala.Method {
		public ArrayMoveMethod (Vala.SourceReference source_reference);
	}
	[CCode (cheader_filename = "vala/valaarrayresizemethod.h")]
	public class ArrayResizeMethod : Vala.Method {
		public ArrayResizeMethod (Vala.SourceReference source_reference);
	}
	[CCode (cheader_filename = "vala/valaassignment.h")]
	public class Assignment : Vala.Expression {
		public Assignment (Vala.Expression! left, Vala.Expression! right, Vala.AssignmentOperator operator = AssignmentOperator.SIMPLE, Vala.SourceReference source_reference = null);
		public Vala.Expression! left { get; set construct; }
		public weak Vala.AssignmentOperator operator { get; set; }
		public Vala.Expression! right { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valaattribute.h")]
	public class Attribute : Vala.CodeNode {
		public Gee.List<Vala.NamedArgument> args;
		public Attribute (string! name, Vala.SourceReference source_reference);
		public void add_argument (Vala.NamedArgument! arg);
		public bool has_argument (string! name);
		public string get_string (string! name);
		public int get_integer (string! name);
		public bool get_bool (string! name);
		public string! name { get; set; }
	}
	[CCode (cheader_filename = "vala/valaattributeprocessor.h")]
	public class AttributeProcessor : Vala.CodeVisitor {
		public void process (Vala.CodeContext! context);
		public AttributeProcessor ();
	}
	[CCode (cheader_filename = "vala/valabaseaccess.h")]
	public class BaseAccess : Vala.Expression {
		public BaseAccess (Vala.SourceReference source = null);
	}
	[CCode (cheader_filename = "vala/valabinaryexpression.h")]
	public class BinaryExpression : Vala.Expression {
		public BinaryExpression (Vala.BinaryOperator op, Vala.Expression! _left, Vala.Expression! _right, Vala.SourceReference source = null);
		public weak Vala.BinaryOperator operator { get; set; }
		public Vala.Expression! left { get; set construct; }
		public Vala.Expression! right { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valablock.h")]
	public class Block : Vala.Symbol, Vala.Statement {
		public Block (Vala.SourceReference source_reference = null);
		public void add_statement (Vala.Statement! stmt);
		public Gee.Collection<Vala.Statement> get_statements ();
		public void add_local_variable (Vala.VariableDeclarator! decl);
		public Gee.Collection<Vala.VariableDeclarator> get_local_variables ();
		public weak bool contains_jump_statement { get; set; }
	}
	[CCode (cheader_filename = "vala/valabooleanliteral.h")]
	public class BooleanLiteral : Vala.Literal {
		public BooleanLiteral (bool b, Vala.SourceReference source);
		public weak bool value { get; set; }
	}
	[CCode (cheader_filename = "vala/valabreakstatement.h")]
	public class BreakStatement : Vala.CodeNode, Vala.Statement {
		public BreakStatement (Vala.SourceReference source);
	}
	[CCode (cheader_filename = "vala/valacallback.h")]
	public class Callback : Vala.DataType {
		public Callback (string name, Vala.TypeReference return_type, Vala.SourceReference source_reference = null);
		public void add_type_parameter (Vala.TypeParameter! p);
		public void add_parameter (Vala.FormalParameter! param);
		public Gee.Collection<Vala.FormalParameter> get_parameters ();
		public bool matches_method (Vala.Method! m);
		public void set_cname (string cname);
		public void process_attributes ();
		public Vala.TypeReference return_type { get; set; }
		public weak bool instance { get; set; }
	}
	[CCode (cheader_filename = "vala/valacastexpression.h")]
	public class CastExpression : Vala.Expression {
		public CastExpression (Vala.Expression! inner, Vala.TypeReference! type_reference, Vala.SourceReference source_reference, bool is_silent_cast);
		public Vala.Expression! inner { get; set construct; }
		public Vala.TypeReference! type_reference { get; set construct; }
		public weak bool is_silent_cast { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valacatchclause.h")]
	public class CatchClause : Vala.CodeNode {
		public CatchClause (Vala.TypeReference type_reference, string variable_name, Vala.Block body, Vala.SourceReference source_reference = null);
		public Vala.TypeReference type_reference { get; set; }
		public string variable_name { get; set; }
		public Vala.Block body { get; set; }
		public Vala.VariableDeclarator variable_declarator { get; set; }
	}
	[CCode (cheader_filename = "vala/valacharacterliteral.h")]
	public class CharacterLiteral : Vala.Literal {
		public CharacterLiteral (string! c, Vala.SourceReference source);
		public unichar get_char ();
		public string! value { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valaclass.h")]
	public class Class : Vala.DataType {
		public Class (string! name, Vala.SourceReference source_reference = null);
		public void add_base_type (Vala.TypeReference! type);
		public Gee.Collection<Vala.TypeReference> get_base_types ();
		public void add_type_parameter (Vala.TypeParameter! p);
		public Gee.Collection<Vala.TypeParameter> get_type_parameters ();
		public void add_constant (Vala.Constant! c);
		public void add_field (Vala.Field! f);
		public Gee.Collection<Vala.Field> get_fields ();
		public void add_method (Vala.Method! m);
		public Gee.Collection<Vala.Method> get_methods ();
		public void add_property (Vala.Property! prop, bool no_field = false);
		public Gee.Collection<Vala.Property> get_properties ();
		public void add_signal (Vala.Signal! sig);
		public Gee.Collection<Vala.Signal> get_signals ();
		public void add_class (Vala.Class! cl);
		public void add_struct (Vala.Struct! st);
		public string! get_default_cname ();
		public void set_cname (string! cname);
		public void process_attributes ();
		public void set_type_id (string! type_id);
		public void set_ref_function (string! name);
		public void set_unref_function (string! name);
		public void set_dup_function (string! name);
		public string get_default_free_function ();
		public void set_free_function (string! name);
		public Vala.Class base_class { get; set; }
		public weak bool is_abstract { get; set; }
		public weak bool is_static { get; set; }
		public weak bool has_private_fields { get; }
		public Vala.Method default_construction_method { get; set; }
		public Vala.Constructor constructor { get; set; }
		public Vala.Destructor destructor { get; set; }
	}
	[CCode (cheader_filename = "vala/valacodebinding.h")]
	public abstract class CodeBinding : GLib.Object {
		public abstract void emit ();
	}
	[CCode (cheader_filename = "vala/valacodecontext.h")]
	public class CodeContext : GLib.Object {
		public CodeContext ();
		public Gee.Collection<Vala.SourceFile> get_source_files ();
		public Gee.Collection<string> get_c_source_files ();
		public void add_source_file (Vala.SourceFile! file);
		public void add_c_source_file (string! file);
		public Gee.Collection<string> get_packages ();
		public bool has_package (string! pkg);
		public void add_package (string! pkg);
		public void accept (Vala.CodeVisitor! visitor);
		public void find_header_cycles ();
		public Vala.Namespace! create_namespace (string name, Vala.SourceReference source_reference = null);
		public Vala.Class! create_class (string! name, Vala.SourceReference source_reference = null);
		public Vala.Struct! create_struct (string! name, Vala.SourceReference source_reference = null);
		public Vala.Interface! create_interface (string! name, Vala.SourceReference source_reference = null);
		public Vala.Enum! create_enum (string! name, Vala.SourceReference source_reference = null);
		public Vala.EnumValue! create_enum_value (string! name);
		public Vala.EnumValue! create_enum_value_with_value (string! name, Vala.Expression value);
		public Vala.Callback! create_callback (string name, Vala.TypeReference return_type, Vala.SourceReference source_reference = null);
		public Vala.Constant! create_constant (string! name, Vala.TypeReference! type_reference, Vala.Expression initializer, Vala.SourceReference source_reference);
		public Vala.Field! create_field (string! name, Vala.TypeReference! type_reference, Vala.Expression initializer, Vala.SourceReference source_reference = null);
		public Vala.Method! create_method (string name, Vala.TypeReference return_type, Vala.SourceReference source_reference = null);
		public Vala.CreationMethod! create_creation_method (string type_name, string name, Vala.SourceReference source_reference = null);
		public Vala.FormalParameter! create_formal_parameter (string! name, Vala.TypeReference type_reference, Vala.SourceReference source_reference = null);
		public Vala.FormalParameter! create_formal_parameter_with_ellipsis (Vala.SourceReference source_reference = null);
		public Vala.Property! create_property (string! name, Vala.TypeReference! type_reference, Vala.PropertyAccessor get_accessor, Vala.PropertyAccessor set_accessor, Vala.SourceReference source_reference);
		public Vala.PropertyAccessor! create_property_accessor (bool readable, bool writable, bool construction, Vala.Block body, Vala.SourceReference source_reference);
		public Vala.Signal! create_signal (string! name, Vala.TypeReference! return_type, Vala.SourceReference source_reference = null);
		public Vala.Constructor! create_constructor (Vala.SourceReference source_reference);
		public Vala.Destructor! create_destructor (Vala.SourceReference source_reference = null);
		public Vala.TypeParameter! create_type_parameter (string name, Vala.SourceReference source_reference);
		public Vala.Block! create_block (Vala.SourceReference source_reference = null);
		public Vala.EmptyStatement! create_empty_statement (Vala.SourceReference source_reference = null);
		public Vala.DeclarationStatement! create_declaration_statement (Vala.LocalVariableDeclaration! declaration, Vala.SourceReference source_reference);
		public Vala.LocalVariableDeclaration! create_local_variable_declaration (Vala.TypeReference type_reference, Vala.SourceReference source_reference);
		public Vala.LocalVariableDeclaration! create_local_variable_declaration_var_type (Vala.SourceReference source_reference);
		public Vala.VariableDeclarator! create_variable_declarator (string! name, Vala.Expression initializer = null, Vala.SourceReference source_reference = null);
		public Vala.InitializerList! create_initializer_list (Vala.SourceReference source_reference);
		public Vala.ExpressionStatement! create_expression_statement (Vala.Expression! expression, Vala.SourceReference source_reference = null);
		public Vala.IfStatement! create_if_statement (Vala.Expression! condition, Vala.Block! true_statement, Vala.Block false_statement, Vala.SourceReference source_reference);
		public Vala.SwitchStatement! create_switch_statement (Vala.Expression! expression, Vala.SourceReference source_reference);
		public Vala.SwitchSection! create_switch_section (Vala.SourceReference source_reference);
		public Vala.SwitchLabel! create_switch_label (Vala.Expression expression, Vala.SourceReference source_reference = null);
		public Vala.SwitchLabel! create_switch_label_with_default (Vala.SourceReference source_reference = null);
		public Vala.WhileStatement! create_while_statement (Vala.Expression! condition, Vala.Block! body, Vala.SourceReference source_reference = null);
		public Vala.DoStatement! create_do_statement (Vala.Block! body, Vala.Expression! condition, Vala.SourceReference source_reference = null);
		public Vala.ForStatement! create_for_statement (Vala.Expression condition, Vala.Block body, Vala.SourceReference source_reference = null);
		public Vala.ForeachStatement! create_foreach_statement (Vala.TypeReference! type_reference, string! variable_name, Vala.Expression! collection, Vala.Block body, Vala.SourceReference source_reference);
		public Vala.BreakStatement! create_break_statement (Vala.SourceReference source_reference);
		public Vala.ContinueStatement! create_continue_statement (Vala.SourceReference source_reference);
		public Vala.ReturnStatement! create_return_statement (Vala.Expression return_expression = null, Vala.SourceReference source_reference = null);
		public Vala.ThrowStatement! create_throw_statement (Vala.Expression! error_expression, Vala.SourceReference source_reference = null);
		public Vala.TryStatement! create_try_statement (Vala.Block! body, Vala.Block finally_body, Vala.SourceReference source_reference = null);
		public Vala.CatchClause! create_catch_clause (Vala.TypeReference type_reference, string variable_name, Vala.Block body, Vala.SourceReference source_reference = null);
		public Vala.LockStatement! create_lock_statement (Vala.Expression resource, Vala.Block body, Vala.SourceReference source_reference = null);
		public Vala.ArrayCreationExpression! create_array_creation_expression (Vala.TypeReference element_type, int rank, Vala.InitializerList initializer_list, Vala.SourceReference source_reference);
		public Vala.BooleanLiteral! create_boolean_literal (bool value, Vala.SourceReference source_reference);
		public Vala.CharacterLiteral! create_character_literal (string! value, Vala.SourceReference source_reference);
		public Vala.IntegerLiteral! create_integer_literal (string! value, Vala.SourceReference source_reference = null);
		public Vala.RealLiteral! create_real_literal (string value, Vala.SourceReference source_reference);
		public Vala.StringLiteral! create_string_literal (string value, Vala.SourceReference source_reference);
		public Vala.NullLiteral! create_null_literal (Vala.SourceReference source_reference = null);
		public Vala.LiteralExpression! create_literal_expression (Vala.Literal! literal, Vala.SourceReference source_reference = null);
		public Vala.ParenthesizedExpression! create_parenthesized_expression (Vala.Expression! inner, Vala.SourceReference source_reference);
		public Vala.MemberAccess! create_member_access (Vala.Expression inner, string! member_name, Vala.SourceReference source_reference = null);
		public Vala.MemberAccess! create_member_access_simple (string! member_name, Vala.SourceReference source_reference = null);
		public Vala.InvocationExpression! create_invocation_expression (Vala.Expression! call, Vala.SourceReference source_reference = null);
		public Vala.ElementAccess! create_element_access (Vala.Expression container, Vala.SourceReference source_reference);
		public Vala.BaseAccess! create_base_access (Vala.SourceReference source_reference = null);
		public Vala.PostfixExpression! create_postfix_expression (Vala.Expression! inner, bool increment, Vala.SourceReference source_reference);
		public Vala.ObjectCreationExpression! create_object_creation_expression (Vala.MemberAccess! member_name, Vala.SourceReference source_reference);
		public Vala.SizeofExpression! create_sizeof_expression (Vala.TypeReference! type_reference, Vala.SourceReference source_reference);
		public Vala.TypeofExpression! create_typeof_expression (Vala.TypeReference! type_reference, Vala.SourceReference source_reference);
		public Vala.UnaryExpression! create_unary_expression (Vala.UnaryOperator operator, Vala.Expression! inner, Vala.SourceReference source_reference);
		public Vala.CastExpression! create_cast_expression (Vala.Expression! inner, Vala.TypeReference! type_reference, Vala.SourceReference source_reference, bool is_silent_cast);
		public Vala.PointerIndirection! create_pointer_indirection (Vala.Expression! inner, Vala.SourceReference source_reference = null);
		public Vala.AddressofExpression! create_addressof_expression (Vala.Expression! inner, Vala.SourceReference source_reference = null);
		public Vala.ReferenceTransferExpression! create_reference_transfer_expression (Vala.Expression! inner, Vala.SourceReference source_reference = null);
		public Vala.BinaryExpression! create_binary_expression (Vala.BinaryOperator operator, Vala.Expression! left, Vala.Expression! right, Vala.SourceReference source_reference = null);
		public Vala.TypeCheck! create_type_check (Vala.Expression! expression, Vala.TypeReference! type_reference, Vala.SourceReference source_reference);
		public Vala.ConditionalExpression! create_conditional_expression (Vala.Expression! condition, Vala.Expression! true_expression, Vala.Expression! false_expression, Vala.SourceReference source_reference);
		public Vala.LambdaExpression! create_lambda_expression (Vala.Expression! expression_body, Vala.SourceReference source_reference);
		public Vala.LambdaExpression! create_lambda_expression_with_statement_body (Vala.Block! statement_body, Vala.SourceReference source_reference);
		public Vala.Assignment! create_assignment (Vala.Expression! left, Vala.Expression! right, Vala.AssignmentOperator operator = AssignmentOperator.SIMPLE, Vala.SourceReference source_reference = null);
		public string library { get; set; }
		public weak bool memory_management { get; set; }
		public weak bool assert { get; set; }
		public weak bool checking { get; set; }
		public weak bool ccode_only { get; set; }
		public weak bool compile_only { get; set; }
		public string output { get; set; }
		public string basedir { get; set; }
		public string directory { get; set; }
		public weak bool debug { get; set; }
		public weak int optlevel { get; set; }
		public weak bool thread { get; set; }
		public Vala.Method module_init_method { get; set; }
		public weak bool save_temps { get; set; }
		public weak bool save_csources { get; }
		public weak bool save_cheaders { get; }
		public Vala.Namespace! root { get; }
		public Vala.CodeGenerator codegen { get; set; }
	}
	[CCode (cheader_filename = "vala/valacodegenerator.h")]
	public class CodeGenerator : Vala.CodeVisitor {
		public virtual void emit (Vala.CodeContext! context);
		public virtual Vala.CodeBinding create_namespace_binding (Vala.Namespace! node);
		public virtual Vala.CodeBinding create_class_binding (Vala.Class! node);
		public virtual Vala.CodeBinding create_struct_binding (Vala.Struct! node);
		public virtual Vala.CodeBinding create_interface_binding (Vala.Interface! node);
		public virtual Vala.CodeBinding create_enum_binding (Vala.Enum! node);
		public virtual Vala.CodeBinding create_enum_value_binding (Vala.EnumValue! node);
		public virtual Vala.CodeBinding create_callback_binding (Vala.Callback! node);
		public virtual Vala.CodeBinding create_constant_binding (Vala.Constant! node);
		public virtual Vala.CodeBinding create_field_binding (Vala.Field! node);
		public virtual Vala.CodeBinding create_method_binding (Vala.Method! node);
		public virtual Vala.CodeBinding create_creation_method_binding (Vala.CreationMethod! node);
		public virtual Vala.CodeBinding create_formal_parameter_binding (Vala.FormalParameter! node);
		public virtual Vala.CodeBinding create_property_binding (Vala.Property! node);
		public virtual Vala.CodeBinding create_property_accessor_binding (Vala.PropertyAccessor! node);
		public virtual Vala.CodeBinding create_signal_binding (Vala.Signal! node);
		public virtual Vala.CodeBinding create_constructor_binding (Vala.Constructor! node);
		public virtual Vala.CodeBinding create_destructor_binding (Vala.Destructor! node);
		public virtual Vala.CodeBinding create_type_parameter_binding (Vala.TypeParameter! node);
		public virtual Vala.CodeBinding create_block_binding (Vala.Block! node);
		public virtual Vala.CodeBinding create_empty_statement_binding (Vala.EmptyStatement! node);
		public virtual Vala.CodeBinding create_declaration_statement_binding (Vala.DeclarationStatement! node);
		public virtual Vala.CodeBinding create_local_variable_declaration_binding (Vala.LocalVariableDeclaration! node);
		public virtual Vala.CodeBinding create_variable_declarator_binding (Vala.VariableDeclarator! node);
		public virtual Vala.CodeBinding create_initializer_list_binding (Vala.InitializerList! node);
		public virtual Vala.CodeBinding create_expression_statement_binding (Vala.ExpressionStatement! node);
		public virtual Vala.CodeBinding create_if_statement_binding (Vala.IfStatement! node);
		public virtual Vala.CodeBinding create_switch_statement_binding (Vala.SwitchStatement! node);
		public virtual Vala.CodeBinding create_switch_section_binding (Vala.SwitchSection! node);
		public virtual Vala.CodeBinding create_switch_label_binding (Vala.SwitchLabel! node);
		public virtual Vala.CodeBinding create_while_statement_binding (Vala.WhileStatement! node);
		public virtual Vala.CodeBinding create_do_statement_binding (Vala.DoStatement! node);
		public virtual Vala.CodeBinding create_for_statement_binding (Vala.ForStatement! node);
		public virtual Vala.CodeBinding create_foreach_statement_binding (Vala.ForeachStatement! node);
		public virtual Vala.CodeBinding create_break_statement_binding (Vala.BreakStatement! node);
		public virtual Vala.CodeBinding create_continue_statement_binding (Vala.ContinueStatement! node);
		public virtual Vala.CodeBinding create_return_statement_binding (Vala.ReturnStatement! node);
		public virtual Vala.CodeBinding create_throw_statement_binding (Vala.ThrowStatement! node);
		public virtual Vala.CodeBinding create_try_statement_binding (Vala.TryStatement! node);
		public virtual Vala.CodeBinding create_catch_clause_binding (Vala.CatchClause! node);
		public virtual Vala.CodeBinding create_lock_statement_binding (Vala.LockStatement! node);
		public virtual Vala.CodeBinding create_array_creation_expression_binding (Vala.ArrayCreationExpression! node);
		public virtual Vala.CodeBinding create_boolean_literal_binding (Vala.BooleanLiteral! node);
		public virtual Vala.CodeBinding create_character_literal_binding (Vala.CharacterLiteral! node);
		public virtual Vala.CodeBinding create_integer_literal_binding (Vala.IntegerLiteral! node);
		public virtual Vala.CodeBinding create_real_literal_binding (Vala.RealLiteral! node);
		public virtual Vala.CodeBinding create_string_literal_binding (Vala.StringLiteral! node);
		public virtual Vala.CodeBinding create_null_literal_binding (Vala.NullLiteral! node);
		public virtual Vala.CodeBinding create_literal_expression_binding (Vala.LiteralExpression! node);
		public virtual Vala.CodeBinding create_parenthesized_expression_binding (Vala.ParenthesizedExpression! node);
		public virtual Vala.CodeBinding create_member_access_binding (Vala.MemberAccess! node);
		public virtual Vala.CodeBinding create_member_access_simple_binding (Vala.MemberAccess! node);
		public virtual Vala.CodeBinding create_invocation_expression_binding (Vala.InvocationExpression! node);
		public virtual Vala.CodeBinding create_element_access_binding (Vala.ElementAccess! node);
		public virtual Vala.CodeBinding create_base_access_binding (Vala.BaseAccess! node);
		public virtual Vala.CodeBinding create_postfix_expression_binding (Vala.PostfixExpression! node);
		public virtual Vala.CodeBinding create_object_creation_expression_binding (Vala.ObjectCreationExpression! node);
		public virtual Vala.CodeBinding create_sizeof_expression_binding (Vala.SizeofExpression! node);
		public virtual Vala.CodeBinding create_typeof_expression_binding (Vala.TypeofExpression! node);
		public virtual Vala.CodeBinding create_unary_expression_binding (Vala.UnaryExpression! node);
		public virtual Vala.CodeBinding create_cast_expression_binding (Vala.CastExpression! node);
		public virtual Vala.CodeBinding create_pointer_indirection_binding (Vala.PointerIndirection! node);
		public virtual Vala.CodeBinding create_addressof_expression_binding (Vala.AddressofExpression! node);
		public virtual Vala.CodeBinding create_reference_transfer_expression_binding (Vala.ReferenceTransferExpression! node);
		public virtual Vala.CodeBinding create_binary_expression_binding (Vala.BinaryExpression! node);
		public virtual Vala.CodeBinding create_type_check_binding (Vala.TypeCheck! node);
		public virtual Vala.CodeBinding create_conditional_expression_binding (Vala.ConditionalExpression! node);
		public virtual Vala.CodeBinding create_lambda_expression_binding (Vala.LambdaExpression! node);
		public virtual Vala.CodeBinding create_lambda_expression_with_statement_body_binding (Vala.LambdaExpression! node);
		public virtual Vala.CodeBinding create_assignment_binding (Vala.Assignment! node);
		public CodeGenerator ();
	}
	[CCode (cheader_filename = "vala/valacodenode.h")]
	public abstract class CodeNode : GLib.Object {
		public GLib.List<Vala.Attribute> attributes;
		public virtual void accept (Vala.CodeVisitor! visitor);
		public virtual void accept_children (Vala.CodeVisitor! visitor);
		public virtual void replace (Vala.CodeNode! old_node, Vala.CodeNode! new_node);
		public Vala.Attribute get_attribute (string! name);
		public virtual string! to_string ();
		public weak Vala.CodeNode parent_node { get; set; }
		public Vala.SourceReference source_reference { get; set; }
		public Vala.CCodeNode ccodenode { get; set; }
		public Vala.CodeBinding code_binding { get; set; }
		public weak bool error { get; set; }
		public weak bool tree_can_fail { get; set; }
	}
	[CCode (cheader_filename = "vala/valacodevisitor.h")]
	public abstract class CodeVisitor : GLib.Object {
		public virtual void visit_source_file (Vala.SourceFile! source_file);
		public virtual void visit_namespace (Vala.Namespace! ns);
		public virtual void visit_class (Vala.Class! cl);
		public virtual void visit_struct (Vala.Struct! st);
		public virtual void visit_interface (Vala.Interface! iface);
		public virtual void visit_enum (Vala.Enum! en);
		public virtual void visit_enum_value (Vala.EnumValue! ev);
		public virtual void visit_callback (Vala.Callback! cb);
		public virtual void visit_member (Vala.Member! m);
		public virtual void visit_constant (Vala.Constant! c);
		public virtual void visit_field (Vala.Field! f);
		public virtual void visit_method (Vala.Method! m);
		public virtual void visit_creation_method (Vala.CreationMethod! m);
		public virtual void visit_formal_parameter (Vala.FormalParameter! p);
		public virtual void visit_property (Vala.Property! prop);
		public virtual void visit_property_accessor (Vala.PropertyAccessor! acc);
		public virtual void visit_signal (Vala.Signal! sig);
		public virtual void visit_constructor (Vala.Constructor! c);
		public virtual void visit_destructor (Vala.Destructor! d);
		public virtual void visit_named_argument (Vala.NamedArgument! n);
		public virtual void visit_type_parameter (Vala.TypeParameter! p);
		public virtual void visit_namespace_reference (Vala.NamespaceReference! ns);
		public virtual void visit_type_reference (Vala.TypeReference! type);
		public virtual void visit_block (Vala.Block! b);
		public virtual void visit_empty_statement (Vala.EmptyStatement! stmt);
		public virtual void visit_declaration_statement (Vala.DeclarationStatement! stmt);
		public virtual void visit_local_variable_declaration (Vala.LocalVariableDeclaration! decl);
		public virtual void visit_variable_declarator (Vala.VariableDeclarator! decl);
		public virtual void visit_initializer_list (Vala.InitializerList! list);
		public virtual void visit_expression_statement (Vala.ExpressionStatement! stmt);
		public virtual void visit_if_statement (Vala.IfStatement! stmt);
		public virtual void visit_switch_statement (Vala.SwitchStatement! stmt);
		public virtual void visit_switch_section (Vala.SwitchSection! section);
		public virtual void visit_switch_label (Vala.SwitchLabel! label);
		public virtual void visit_while_statement (Vala.WhileStatement! stmt);
		public virtual void visit_do_statement (Vala.DoStatement! stmt);
		public virtual void visit_for_statement (Vala.ForStatement! stmt);
		public virtual void visit_foreach_statement (Vala.ForeachStatement! stmt);
		public virtual void visit_break_statement (Vala.BreakStatement! stmt);
		public virtual void visit_continue_statement (Vala.ContinueStatement! stmt);
		public virtual void visit_return_statement (Vala.ReturnStatement! stmt);
		public virtual void visit_throw_statement (Vala.ThrowStatement! stmt);
		public virtual void visit_try_statement (Vala.TryStatement! stmt);
		public virtual void visit_catch_clause (Vala.CatchClause! clause);
		public virtual void visit_lock_statement (Vala.LockStatement! stmt);
		public virtual void visit_array_creation_expression (Vala.ArrayCreationExpression! expr);
		public virtual void visit_boolean_literal (Vala.BooleanLiteral! lit);
		public virtual void visit_character_literal (Vala.CharacterLiteral! lit);
		public virtual void visit_integer_literal (Vala.IntegerLiteral! lit);
		public virtual void visit_real_literal (Vala.RealLiteral! lit);
		public virtual void visit_string_literal (Vala.StringLiteral! lit);
		public virtual void visit_null_literal (Vala.NullLiteral! lit);
		public virtual void visit_literal_expression (Vala.LiteralExpression! expr);
		public virtual void visit_parenthesized_expression (Vala.ParenthesizedExpression! expr);
		public virtual void visit_member_access (Vala.MemberAccess! expr);
		public virtual void visit_invocation_expression (Vala.InvocationExpression! expr);
		public virtual void visit_element_access (Vala.ElementAccess! expr);
		public virtual void visit_base_access (Vala.BaseAccess! expr);
		public virtual void visit_postfix_expression (Vala.PostfixExpression! expr);
		public virtual void visit_object_creation_expression (Vala.ObjectCreationExpression! expr);
		public virtual void visit_sizeof_expression (Vala.SizeofExpression! expr);
		public virtual void visit_typeof_expression (Vala.TypeofExpression! expr);
		public virtual void visit_unary_expression (Vala.UnaryExpression! expr);
		public virtual void visit_cast_expression (Vala.CastExpression! expr);
		public virtual void visit_pointer_indirection (Vala.PointerIndirection! expr);
		public virtual void visit_addressof_expression (Vala.AddressofExpression! expr);
		public virtual void visit_reference_transfer_expression (Vala.ReferenceTransferExpression! expr);
		public virtual void visit_binary_expression (Vala.BinaryExpression! expr);
		public virtual void visit_type_check (Vala.TypeCheck! expr);
		public virtual void visit_conditional_expression (Vala.ConditionalExpression! expr);
		public virtual void visit_lambda_expression (Vala.LambdaExpression! expr);
		public virtual void visit_assignment (Vala.Assignment! a);
		public virtual void visit_end_full_expression (Vala.Expression! expr);
	}
	[CCode (cheader_filename = "vala/valaconditionalexpression.h")]
	public class ConditionalExpression : Vala.Expression {
		public ConditionalExpression (Vala.Expression! cond, Vala.Expression! true_expr, Vala.Expression! false_expr, Vala.SourceReference source);
		public Vala.Expression! condition { get; set construct; }
		public Vala.Expression! true_expression { get; set construct; }
		public Vala.Expression! false_expression { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valaconstant.h")]
	public class Constant : Vala.Member, Vala.Lockable {
		public Constant (string! name, Vala.TypeReference! type_reference, Vala.Expression initializer, Vala.SourceReference source_reference);
		public string! get_cname ();
		public bool get_lock_used ();
		public void set_lock_used (bool used);
		public Vala.TypeReference! type_reference { get; set; }
		public Vala.Expression initializer { get; set; }
	}
	[CCode (cheader_filename = "vala/valaconstructor.h")]
	public class Constructor : Vala.Symbol {
		public Constructor (Vala.SourceReference source);
		public Vala.Block body { get; set; }
		public Vala.FormalParameter this_parameter { get; set; }
		public weak bool instance { get; set; }
	}
	[CCode (cheader_filename = "vala/valacontinuestatement.h")]
	public class ContinueStatement : Vala.CodeNode, Vala.Statement {
		public ContinueStatement (Vala.SourceReference source);
	}
	[CCode (cheader_filename = "vala/valacreationmethod.h")]
	public class CreationMethod : Vala.Method {
		public CreationMethod (string type_name, string name, Vala.SourceReference source_reference = null);
		public string type_name { get; set; }
		public weak int n_construction_params { get; set; }
	}
	[CCode (cheader_filename = "vala/valadatatype.h")]
	public abstract class DataType : Vala.Symbol {
		public abstract string get_cname (bool const_type = false);
		public virtual bool is_reference_type ();
		public virtual string get_dup_function ();
		public virtual string get_free_function ();
		public virtual bool is_reference_counting ();
		public virtual string get_ref_function ();
		public virtual string get_unref_function ();
		public virtual string get_type_id ();
		public virtual string get_marshaller_type_name ();
		public virtual string get_get_value_function ();
		public virtual string get_set_value_function ();
		public virtual string get_upper_case_cname (string infix = null);
		public virtual string get_default_value ();
		public void add_cheader_filename (string! filename);
		public Vala.Pointer! get_pointer ();
		public Vala.Array! get_array (int rank);
		public virtual bool is_subtype_of (Vala.DataType! t);
		public virtual int get_type_parameter_index (string! name);
	}
	[CCode (cheader_filename = "vala/valadeclarationstatement.h")]
	public class DeclarationStatement : Vala.CodeNode, Vala.Statement {
		public DeclarationStatement (Vala.LocalVariableDeclaration! decl, Vala.SourceReference source);
		public Vala.LocalVariableDeclaration! declaration { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valadestructor.h")]
	public class Destructor : Vala.Symbol {
		public Destructor (Vala.SourceReference source_reference = null);
		public Vala.Block body { get; set; }
		public weak bool instance { get; set; }
	}
	[CCode (cheader_filename = "vala/valadostatement.h")]
	public class DoStatement : Vala.CodeNode, Vala.Statement {
		public DoStatement (Vala.Block! body, Vala.Expression! condition, Vala.SourceReference source_reference = null);
		public Vala.Block body { get; set; }
		public Vala.Expression! condition { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valaelementaccess.h")]
	public class ElementAccess : Vala.Expression {
		public void append_index (Vala.Expression! index);
		public Gee.List<Vala.Expression> get_indices ();
		public ElementAccess (Vala.Expression container, Vala.SourceReference source_reference);
		public Vala.Expression! container { get; set; }
	}
	[CCode (cheader_filename = "vala/valaemptystatement.h")]
	public class EmptyStatement : Vala.CodeNode, Vala.Statement {
		public EmptyStatement (Vala.SourceReference source);
	}
	[CCode (cheader_filename = "vala/valaenum.h")]
	public class Enum : Vala.DataType {
		public Enum (string! name, Vala.SourceReference source_reference = null);
		public void add_value (Vala.EnumValue! value);
		public void add_method (Vala.Method! m);
		public Gee.Collection<Vala.EnumValue> get_values ();
		public Gee.Collection<Vala.Method> get_methods ();
		public string! get_cprefix ();
		public void set_cprefix (string! cprefix);
		public void process_attributes ();
		public weak bool is_flags { get; set; }
		public weak bool error_domain { get; set; }
	}
	[CCode (cheader_filename = "vala/valaenumvalue.h")]
	public class EnumValue : Vala.Symbol {
		public EnumValue (string! name);
		public EnumValue.with_value (string! name, Vala.Expression value);
		public string! get_cname ();
		public Vala.Expression value { get; set; }
	}
	[CCode (cheader_filename = "vala/valaexpression.h")]
	public abstract class Expression : Vala.CodeNode {
		public Gee.ArrayList<Vala.VariableDeclarator> temp_vars;
		public Vala.TypeReference static_type { get; set; }
		public Vala.TypeReference expected_type { get; set; }
		public weak Vala.Symbol symbol_reference { get; set; }
		public weak bool ref_leaked { get; set; }
		public weak bool ref_missing { get; set; }
		public weak bool ref_sink { get; set; }
		public weak bool can_fail { get; set; }
	}
	[CCode (cheader_filename = "vala/valaexpressionstatement.h")]
	public class ExpressionStatement : Vala.CodeNode, Vala.Statement {
		public ExpressionStatement (Vala.Expression! expression, Vala.SourceReference source_reference = null);
		public Vala.Property assigned_property ();
		public Vala.Expression! expression { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valafield.h")]
	public class Field : Vala.Member, Vala.Invokable, Vala.Lockable {
		public Field (string! name, Vala.TypeReference! type_reference, Vala.Expression initializer, Vala.SourceReference source_reference = null);
		public string! get_cname ();
		public string! get_default_cname ();
		public void process_attributes ();
		public Gee.Collection<Vala.FormalParameter> get_parameters ();
		public Vala.TypeReference get_return_type ();
		public bool is_invokable ();
		public bool get_lock_used ();
		public void set_lock_used (bool used);
		public Vala.TypeReference! type_reference { get; set; }
		public Vala.Expression initializer { get; set; }
		public weak bool instance { get; set; }
		public weak bool no_array_length { get; set; }
	}
	[CCode (cheader_filename = "vala/valaforeachstatement.h")]
	public class ForeachStatement : Vala.Block {
		public ForeachStatement (Vala.TypeReference! type_reference, string! variable_name, Vala.Expression! collection, Vala.Block body, Vala.SourceReference source_reference);
		public Vala.TypeReference! type_reference { get; set construct; }
		public string! variable_name { get; set construct; }
		public Vala.Expression! collection { get; set construct; }
		public Vala.Block body { get; set; }
		public Vala.VariableDeclarator variable_declarator { get; set; }
		public Vala.VariableDeclarator collection_variable_declarator { get; set; }
		public Vala.VariableDeclarator iterator_variable_declarator { get; set; }
	}
	[CCode (cheader_filename = "vala/valaformalparameter.h")]
	public class FormalParameter : Vala.Symbol, Vala.Invokable {
		public FormalParameter (string! _name, Vala.TypeReference type, Vala.SourceReference source = null);
		public FormalParameter.with_ellipsis (Vala.SourceReference source = null);
		public Gee.Collection<Vala.FormalParameter> get_parameters ();
		public Vala.TypeReference get_return_type ();
		public bool is_invokable ();
		public Vala.TypeReference type_reference { get; set; }
		public weak bool ellipsis { get; set; }
		public Vala.Expression default_expression { get; set; }
		public weak bool no_array_length { get; set; }
		public weak bool construct_parameter { get; set; }
	}
	[CCode (cheader_filename = "vala/valaforstatement.h")]
	public class ForStatement : Vala.CodeNode, Vala.Statement {
		public ForStatement (Vala.Expression condition, Vala.Block body, Vala.SourceReference source_reference = null);
		public void add_initializer (Vala.Expression! init);
		public Gee.Collection<Vala.Expression> get_initializer ();
		public void add_iterator (Vala.Expression! iter);
		public Gee.Collection<Vala.Expression> get_iterator ();
		public Vala.Expression! condition { get; set construct; }
		public Vala.Block body { get; set; }
	}
	[CCode (cheader_filename = "vala/valaifstatement.h")]
	public class IfStatement : Vala.CodeNode, Vala.Statement {
		public IfStatement (Vala.Expression! cond, Vala.Block! true_stmt, Vala.Block false_stmt, Vala.SourceReference source);
		public Vala.Expression! condition { get; set construct; }
		public Vala.Block! true_statement { get; set construct; }
		public Vala.Block false_statement { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valainitializerlist.h")]
	public class InitializerList : Vala.Expression {
		public void append (Vala.Expression! expr);
		public Gee.Collection<Vala.Expression> get_initializers ();
		public InitializerList (Vala.SourceReference source_reference);
		public weak int size { get; }
	}
	[CCode (cheader_filename = "vala/valainstancecast.h")]
	public class InstanceCast : Vala.CCodeFunctionCall {
		public InstanceCast (Vala.CCodeExpression! expr, Vala.DataType! type);
		public weak Vala.DataType! type_reference { get; set construct; }
		public Vala.CCodeExpression! inner { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valaintegerliteral.h")]
	public class IntegerLiteral : Vala.Literal {
		public IntegerLiteral (string! i, Vala.SourceReference source = null);
		public string! get_type_name ();
		public string! value { get; set; }
	}
	[CCode (cheader_filename = "vala/valainterface.h")]
	public class Interface : Vala.DataType {
		public Interface (string! name, Vala.SourceReference source_reference = null);
		public void add_type_parameter (Vala.TypeParameter! p);
		public Gee.Collection<Vala.TypeParameter> get_type_parameters ();
		public void add_prerequisite (Vala.TypeReference! type);
		public void prepend_prerequisite (Vala.TypeReference! type);
		public Gee.Collection<Vala.TypeReference> get_prerequisites ();
		public void add_method (Vala.Method! m);
		public Gee.Collection<Vala.Method> get_methods ();
		public void add_field (Vala.Field! f);
		public Gee.Collection<Vala.Field> get_fields ();
		public void add_property (Vala.Property! prop);
		public Gee.Collection<Vala.Property> get_properties ();
		public void add_signal (Vala.Signal! sig);
		public Gee.Collection<Vala.Signal> get_signals ();
		public string! get_lower_case_csuffix ();
		public void set_lower_case_csuffix (string! csuffix);
		public void process_attributes ();
		public string get_type_cname ();
		public void set_type_cname (string! type_cname);
		public weak bool is_static { get; set; }
		public weak bool declaration_only { get; set; }
	}
	[CCode (cheader_filename = "vala/valainterfacewriter.h")]
	public class InterfaceWriter : Vala.CodeVisitor {
		public void write_file (Vala.CodeContext! context, string! filename);
		public InterfaceWriter ();
	}
	[CCode (cheader_filename = "vala/valainvocationexpression.h")]
	public class InvocationExpression : Vala.Expression {
		public Vala.Expression _call;
		public InvocationExpression (Vala.Expression! call, Vala.SourceReference source_reference = null);
		public void add_argument (Vala.Expression! arg);
		public Gee.Collection<Vala.Expression> get_argument_list ();
		public void append_array_size (Vala.CCodeExpression! size);
		public Gee.List<Vala.CCodeExpression> get_array_sizes ();
		public Vala.Expression! call { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valalambdaexpression.h")]
	public class LambdaExpression : Vala.Expression {
		public LambdaExpression (Vala.Expression! expression_body, Vala.SourceReference source_reference);
		public LambdaExpression.with_statement_body (Vala.Block! statement_body, Vala.SourceReference source_reference);
		public void add_parameter (string! param);
		public Gee.Collection<string> get_parameters ();
		public Vala.Expression expression_body { get; set; }
		public Vala.Block statement_body { get; set; }
		public Vala.Method method { get; set; }
	}
	[CCode (cheader_filename = "vala/valaliteral.h")]
	public abstract class Literal : Vala.CodeNode {
		public Vala.TypeReference static_type { get; set; }
	}
	[CCode (cheader_filename = "vala/valaliteralexpression.h")]
	public class LiteralExpression : Vala.Expression {
		public LiteralExpression (Vala.Literal! _literal, Vala.SourceReference source = null);
		public Vala.Literal literal { get; construct; }
	}
	[CCode (cheader_filename = "vala/valalocalvariabledeclaration.h")]
	public class LocalVariableDeclaration : Vala.CodeNode {
		public LocalVariableDeclaration (Vala.TypeReference type_reference, Vala.SourceReference source_reference);
		public LocalVariableDeclaration.var_type (Vala.SourceReference source_reference);
		public void add_declarator (Vala.VariableDeclarator! declarator);
		public Gee.Collection<Vala.VariableDeclarator> get_variable_declarators ();
		public Vala.TypeReference type_reference { get; set; }
	}
	[CCode (cheader_filename = "vala/valalockstatement.h")]
	public class LockStatement : Vala.CodeNode, Vala.Statement {
		public LockStatement (Vala.Expression resource, Vala.Block body, Vala.SourceReference source_reference = null);
		public Vala.Expression! resource { get; set construct; }
		public Vala.Block! body { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valamember.h")]
	public class Member : Vala.Symbol {
		public void add_cheader_filename (string! filename);
		public Member ();
	}
	[CCode (cheader_filename = "vala/valamemberaccess.h")]
	public class MemberAccess : Vala.Expression {
		public MemberAccess (Vala.Expression inner, string! member_name, Vala.SourceReference source_reference = null);
		public MemberAccess.simple (string! member_name, Vala.SourceReference source_reference = null);
		public void add_type_argument (Vala.TypeReference! arg);
		public Gee.Collection<Vala.TypeReference> get_type_arguments ();
		public Vala.Expression inner { get; set; }
		public string! member_name { get; set; }
		public weak bool prototype_access { get; set; }
	}
	[CCode (cheader_filename = "vala/valamemberinitializer.h")]
	public class MemberInitializer : Vala.CodeNode {
		public MemberInitializer (string! name, Vala.Expression! initializer, Vala.SourceReference source_reference = null);
		public string! name { get; set; }
		public Vala.Expression! initializer { get; set; }
		public weak Vala.Symbol symbol_reference { get; set; }
	}
	[CCode (cheader_filename = "vala/valamemorymanager.h")]
	public class MemoryManager : Vala.CodeVisitor {
		public void analyze (Vala.CodeContext! context);
		public MemoryManager ();
	}
	[CCode (cheader_filename = "vala/valamethod.h")]
	public class Method : Vala.Member, Vala.Invokable {
		public const string DEFAULT_SENTINEL;
		public Method (string name, Vala.TypeReference return_type, Vala.SourceReference source_reference = null);
		public void add_parameter (Vala.FormalParameter! param);
		public Gee.Collection<Vala.FormalParameter> get_parameters ();
		public Vala.TypeReference get_return_type ();
		public bool is_invokable ();
		public string! get_cname ();
		public virtual string! get_default_cname ();
		public string! get_real_cname ();
		public void set_cname (string cname);
		public void process_attributes ();
		public bool equals (Vala.Method! m2);
		public void add_error_domain (Vala.TypeReference! error_domain);
		public Gee.Collection<Vala.TypeReference> get_error_domains ();
		public Vala.TypeReference return_type { get; set; }
		public Vala.Block body { get; set; }
		public weak bool instance { get; set; }
		public string! vfunc_name { get; set; }
		public string! sentinel { get; set; }
		public weak bool is_abstract { get; set; }
		public weak bool is_virtual { get; set; }
		public weak bool overrides { get; set; }
		public weak bool returns_modified_pointer { get; set; }
		public weak bool instance_last { get; set; }
		public weak Vala.Method base_method { get; set; }
		public Vala.Method base_interface_method { get; set; }
		public Vala.FormalParameter this_parameter { get; set; }
		public weak bool no_array_length { get; set; }
		public weak bool printf_format { get; set; }
	}
	[CCode (cheader_filename = "vala/valanamedargument.h")]
	public class NamedArgument : Vala.CodeNode {
		public NamedArgument (string! _name, Vala.Expression! arg, Vala.SourceReference source);
		public string! name { get; set construct; }
		public Vala.Expression! argument { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valanamespace.h")]
	public class Namespace : Vala.Symbol {
		public Namespace (string name, Vala.SourceReference source_reference = null);
		public void add_namespace (Vala.Namespace! ns);
		public Gee.Collection<Vala.Namespace> get_namespaces ();
		public void add_class (Vala.Class! cl);
		public void add_interface (Vala.Interface! iface);
		public void add_struct (Vala.Struct! st);
		public void add_enum (Vala.Enum! en);
		public void add_callback (Vala.Callback! cb);
		public Gee.Collection<Vala.Struct> get_structs ();
		public Gee.Collection<Vala.Class> get_classes ();
		public Gee.Collection<Vala.Interface> get_interfaces ();
		public void add_constant (Vala.Constant! constant);
		public void add_field (Vala.Field! f);
		public void add_method (Vala.Method! m);
		public Gee.List<string> get_cprefixes ();
		public void add_cprefix (string! cprefix);
		public void set_lower_case_cprefix (string cprefix);
		public string get_cheader_filename ();
		public void set_cheader_filename (string! cheader_filename);
		public void process_attributes ();
		public weak bool pkg { get; set; }
	}
	[CCode (cheader_filename = "vala/valanamespacereference.h")]
	public class NamespaceReference : Vala.CodeNode {
		public NamespaceReference (string! name, Vala.SourceReference source_reference);
		public string! name { get; set; }
		public weak Vala.Symbol namespace_symbol { get; set; }
	}
	[CCode (cheader_filename = "vala/valanullliteral.h")]
	public class NullLiteral : Vala.Literal {
		public NullLiteral (Vala.SourceReference source = null);
	}
	[CCode (cheader_filename = "vala/valaobjectcreationexpression.h")]
	public class ObjectCreationExpression : Vala.Expression {
		public ObjectCreationExpression (Vala.MemberAccess! member_name, Vala.SourceReference source_reference);
		public void add_argument (Vala.Expression! arg);
		public Gee.Collection<Vala.Expression> get_argument_list ();
		public void add_member_initializer (Vala.MemberInitializer! init);
		public Gee.Collection<Vala.MemberInitializer> get_object_initializer ();
		public Vala.TypeReference type_reference { get; set; }
		public Vala.Method constructor { get; set; }
		public Vala.MemberAccess member_name { get; set; }
	}
	[CCode (cheader_filename = "vala/valaparenthesizedexpression.h")]
	public class ParenthesizedExpression : Vala.Expression {
		public ParenthesizedExpression (Vala.Expression! _inner, Vala.SourceReference source);
		public Vala.Expression! inner { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valaparser.h")]
	public class Parser : Vala.CodeVisitor {
		public void parse (Vala.CodeContext! context);
		public void push_comment (string! comment_item, bool file_comment);
		public string pop_comment ();
		public void parse_file (Vala.SourceFile! source_file);
		public Parser ();
	}
	[CCode (cheader_filename = "vala/valapointer.h")]
	public class Pointer : Vala.DataType {
		public Pointer (Vala.DataType! referent_type, Vala.SourceReference source_reference = null);
		public weak Vala.DataType! referent_type { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valapointerindirection.h")]
	public class PointerIndirection : Vala.Expression {
		public PointerIndirection (Vala.Expression! inner, Vala.SourceReference source_reference = null);
		public Vala.Expression! inner { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valapostfixexpression.h")]
	public class PostfixExpression : Vala.Expression {
		public PostfixExpression (Vala.Expression! _inner, bool inc, Vala.SourceReference source);
		public Vala.Expression! inner { get; set construct; }
		public weak bool increment { get; set; }
	}
	[CCode (cheader_filename = "vala/valapropertyaccessor.h")]
	public class PropertyAccessor : Vala.CodeNode {
		public PropertyAccessor (bool readable, bool writable, bool construction, Vala.Block body, Vala.SourceReference source_reference);
		public weak Vala.Property prop { get; set; }
		public weak bool readable { get; set; }
		public weak bool writable { get; set; }
		public weak bool construction { get; set; }
		public Vala.Block body { get; set; }
		public Vala.FormalParameter value_parameter { get; set; }
	}
	[CCode (cheader_filename = "vala/valaproperty.h")]
	public class Property : Vala.Member, Vala.Lockable {
		public Property (string! _name, Vala.TypeReference! type, Vala.PropertyAccessor _get_accessor, Vala.PropertyAccessor _set_accessor, Vala.SourceReference source);
		public string! get_upper_case_cname ();
		public Vala.CCodeConstant! get_canonical_cconstant ();
		public void process_attributes ();
		public bool get_lock_used ();
		public void set_lock_used (bool used);
		public bool equals (Vala.Property! prop2);
		public Vala.TypeReference! type_reference { get; set construct; }
		public Vala.PropertyAccessor get_accessor { get; set; }
		public Vala.PropertyAccessor set_accessor { get; set; }
		public Vala.FormalParameter this_parameter { get; set; }
		public weak bool notify { get; set; }
		public weak bool no_accessor_method { get; set; }
		public weak bool interface_only { get; set; }
		public weak bool is_abstract { get; set; }
		public weak bool is_virtual { get; set; }
		public weak bool overrides { get; set; }
		public weak Vala.Property base_property { get; set; }
		public Vala.Property base_interface_property { get; set; }
	}
	[CCode (cheader_filename = "vala/valarealliteral.h")]
	public class RealLiteral : Vala.Literal {
		public RealLiteral (string r, Vala.SourceReference source);
		public string! get_type_name ();
		public string value { get; set; }
	}
	[CCode (cheader_filename = "vala/valareferencetransferexpression.h")]
	public class ReferenceTransferExpression : Vala.Expression {
		public ReferenceTransferExpression (Vala.Expression! inner, Vala.SourceReference source_reference = null);
		public Vala.Expression! inner { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valareport.h")]
	public static class Report {
		public static int get_warnings ();
		public static int get_errors ();
		public static void warning (Vala.SourceReference source, string! message);
		public static void error (Vala.SourceReference source, string! message);
	}
	[CCode (cheader_filename = "vala/valareturnstatement.h")]
	public class ReturnStatement : Vala.CodeNode, Vala.Statement {
		public ReturnStatement (Vala.Expression return_expression = null, Vala.SourceReference source_reference = null);
		public Vala.Expression return_expression { get; set; }
	}
	[CCode (cheader_filename = "vala/valascope.h")]
	public class Scope : GLib.Object {
		public Scope (Vala.Symbol owner = null);
		public void add (string name, Vala.Symbol! sym);
		public Vala.Symbol lookup (string! name);
		public weak Vala.Symbol owner { get; set; }
		public weak Vala.Scope parent_scope { get; set; }
	}
	[CCode (cheader_filename = "vala/valasemanticanalyzer.h")]
	public class SemanticAnalyzer : Vala.CodeVisitor {
		public SemanticAnalyzer (bool manage_memory = true);
		public void add_binding_provider (Vala.BindingProvider! binding_provider);
		public void analyze (Vala.CodeContext! context);
		public static Vala.Symbol symbol_lookup_inherited (Vala.Symbol! sym, string! name);
		public static Vala.TypeReference get_actual_type (Vala.TypeReference derived_instance_type, Vala.Symbol generic_member, Vala.TypeReference generic_type, Vala.CodeNode node_reference);
		public weak bool memory_management { get; set; }
	}
	[CCode (cheader_filename = "vala/valasignal.h")]
	public class Signal : Vala.Member, Vala.Invokable, Vala.Lockable {
		public Signal (string! name, Vala.TypeReference! return_type, Vala.SourceReference source_reference = null);
		public void add_parameter (Vala.FormalParameter! param);
		public Gee.Collection<Vala.FormalParameter> get_parameters ();
		public Vala.TypeReference get_return_type ();
		public bool is_invokable ();
		public Vala.Callback! get_callback ();
		public string! get_cname ();
		public void set_cname (string cname);
		public Vala.CCodeConstant! get_canonical_cconstant ();
		public void process_attributes ();
		public bool get_lock_used ();
		public void set_lock_used (bool used);
		public Vala.TypeReference! return_type { get; set; }
		public weak bool has_emitter { get; set; }
	}
	[CCode (cheader_filename = "vala/valasizeofexpression.h")]
	public class SizeofExpression : Vala.Expression {
		public SizeofExpression (Vala.TypeReference! type, Vala.SourceReference source);
		public Vala.TypeReference! type_reference { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valasourcefile.h")]
	public class SourceFile : GLib.Object {
		public SourceFile (Vala.CodeContext! context, string! filename, bool pkg = false);
		public void add_using_directive (Vala.NamespaceReference! ns);
		public Gee.Collection<Vala.NamespaceReference> get_using_directives ();
		public void add_node (Vala.CodeNode! node);
		public Gee.Collection<Vala.CodeNode> get_nodes ();
		public void accept (Vala.CodeVisitor! visitor);
		public void accept_children (Vala.CodeVisitor! visitor);
		public string! get_cheader_filename ();
		public string! get_csource_filename ();
		public string! get_cinclude_filename ();
		public void add_symbol_dependency (Vala.Symbol! sym, Vala.SourceFileDependencyType dep_type);
		public Gee.Collection<string> get_header_external_includes ();
		public void add_header_internal_include (string! include);
		public Gee.Collection<string> get_header_internal_includes ();
		public Gee.Collection<string> get_source_external_includes ();
		public Gee.Collection<string> get_source_internal_includes ();
		public Gee.Collection<weak Vala.SourceFile> get_header_internal_full_dependencies ();
		public Gee.Collection<weak Vala.SourceFile> get_header_internal_dependencies ();
		public string! filename { get; set; }
		public string comment { get; set; }
		public weak bool pkg { get; set; }
		public Vala.SourceFileCycle cycle { get; set; }
		public weak bool is_cycle_head { get; set; }
		public weak int mark { get; set; }
		public weak Vala.CodeContext context { get; set; }
	}
	[CCode (cheader_filename = "vala/valasourcefilecycle.h")]
	public class SourceFileCycle : GLib.Object {
		public Gee.List<weak Vala.SourceFile> files;
		public weak Vala.SourceFile head;
		public SourceFileCycle ();
	}
	[CCode (cheader_filename = "vala/valasourcereference.h")]
	public class SourceReference : GLib.Object {
		public SourceReference (Vala.SourceFile _file, int _first_line = 0, int _first_column = 0, int _last_line = 0, int _last_column = 0);
		public SourceReference.with_comment (Vala.SourceFile _file, int _first_line, int _first_column, int _last_line, int _last_column, string _comment);
		public string! to_string ();
		public weak Vala.SourceFile file { get; set; }
		public weak int first_line { get; set; }
		public weak int first_column { get; set; }
		public weak int last_line { get; set; }
		public weak int last_column { get; set; }
		public string comment { get; set; }
	}
	[CCode (cheader_filename = "vala/valastringliteral.h")]
	public class StringLiteral : Vala.Literal {
		public StringLiteral (string s, Vala.SourceReference source);
		public string eval ();
		public string value { get; set; }
	}
	[CCode (cheader_filename = "vala/valastruct.h")]
	public class Struct : Vala.DataType {
		public Struct (string! name, Vala.SourceReference source_reference = null);
		public void add_type_parameter (Vala.TypeParameter! p);
		public void add_constant (Vala.Constant! c);
		public void add_field (Vala.Field! f);
		public Gee.Collection<Vala.Field> get_fields ();
		public void add_method (Vala.Method! m);
		public Gee.Collection<Vala.Method> get_methods ();
		public bool is_integer_type ();
		public bool is_floating_type ();
		public int get_rank ();
		public void process_attributes ();
		public void set_type_id (string! name);
		public void add_base_type (Vala.TypeReference! type);
		public Gee.Collection<Vala.TypeReference> get_base_types ();
		public bool is_simple_type ();
		public Vala.Method default_construction_method { get; set; }
	}
	[CCode (cheader_filename = "vala/valaswitchlabel.h")]
	public class SwitchLabel : Vala.CodeNode {
		public SwitchLabel (Vala.Expression expr, Vala.SourceReference source = null);
		public SwitchLabel.with_default (Vala.SourceReference source = null);
		public Vala.Expression expression { get; set; }
	}
	[CCode (cheader_filename = "vala/valaswitchsection.h")]
	public class SwitchSection : Vala.Block {
		public SwitchSection (Vala.SourceReference source_reference);
		public void add_label (Vala.SwitchLabel! label);
		public Gee.Collection<Vala.SwitchLabel> get_labels ();
		public bool has_default_label ();
		public void add_statement (Vala.Statement! stmt);
		public Gee.Collection<Vala.Statement> get_statements ();
	}
	[CCode (cheader_filename = "vala/valaswitchstatement.h")]
	public class SwitchStatement : Vala.CodeNode, Vala.Statement {
		public SwitchStatement (Vala.Expression! expression, Vala.SourceReference source_reference);
		public void add_section (Vala.SwitchSection! section);
		public Gee.Collection<Vala.SwitchSection> get_sections ();
		public Vala.Expression! expression { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valasymbol.h")]
	public abstract class Symbol : Vala.CodeNode {
		public bool is_internal_symbol ();
		public string get_full_name ();
		public virtual string! get_cprefix ();
		public virtual string get_lower_case_cname (string infix = null);
		public virtual string! get_lower_case_cprefix ();
		public virtual Gee.Collection<string> get_cheader_filenames ();
		public static string! camel_case_to_lower_case (string! camel_case);
		public weak Vala.Symbol parent_symbol { get; }
		public weak Vala.Scope owner { get; set; }
		public string name { get; set; }
		public weak bool active { get; set; }
		public weak Vala.SymbolAccessibility access { get; set; }
		public Vala.Scope scope { get; }
		public weak bool is_imported { get; set; }
	}
	[CCode (cheader_filename = "vala/valasymbolresolver.h")]
	public class SymbolResolver : Vala.CodeVisitor {
		public void resolve (Vala.CodeContext! context);
		public SymbolResolver ();
	}
	[CCode (cheader_filename = "vala/valathrowstatement.h")]
	public class ThrowStatement : Vala.CodeNode, Vala.Statement {
		public ThrowStatement (Vala.Expression! error_expression, Vala.SourceReference source_reference = null);
		public Vala.Expression error_expression { get; set; }
	}
	[CCode (cheader_filename = "vala/valatrystatement.h")]
	public class TryStatement : Vala.CodeNode, Vala.Statement {
		public TryStatement (Vala.Block! body, Vala.Block finally_body, Vala.SourceReference source_reference = null);
		public void add_catch_clause (Vala.CatchClause! clause);
		public Gee.Collection<Vala.CatchClause> get_catch_clauses ();
		public Vala.Block! body { get; set; }
		public Vala.Block finally_body { get; set; }
	}
	[CCode (cheader_filename = "vala/valatypecheck.h")]
	public class TypeCheck : Vala.Expression {
		public TypeCheck (Vala.Expression! expr, Vala.TypeReference! type, Vala.SourceReference source);
		public Vala.Expression! expression { get; set construct; }
		public Vala.TypeReference! type_reference { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valatypeofexpression.h")]
	public class TypeofExpression : Vala.Expression {
		public TypeofExpression (Vala.TypeReference! type, Vala.SourceReference source);
		public Vala.TypeReference! type_reference { get; set construct; }
	}
	[CCode (cheader_filename = "vala/valatypeparameter.h")]
	public class TypeParameter : Vala.Symbol {
		public weak Vala.DataType type;
		public TypeParameter (string! _name, Vala.SourceReference source);
		public Vala.Array! get_array (int rank);
		public bool equals (Vala.TypeParameter! param2);
	}
	[CCode (cheader_filename = "vala/valatypereference.h")]
	public class TypeReference : Vala.CodeNode {
		public TypeReference ();
		public TypeReference.from_name (string ns, string! type, Vala.SourceReference source = null);
		public static Vala.TypeReference new_from_expression (Vala.Expression! expr);
		public void add_type_argument (Vala.TypeReference! arg);
		public Gee.List<Vala.TypeReference> get_type_arguments ();
		public void remove_all_type_arguments ();
		public string get_cname (bool var_type = false, bool const_type = false);
		public string get_const_cname ();
		public string! to_string ();
		public Vala.TypeReference! copy ();
		public bool equals (Vala.TypeReference! type2);
		public bool stricter (Vala.TypeReference! type2);
		public weak bool transfers_ownership { get; set; }
		public weak bool takes_ownership { get; set; }
		public weak bool is_out { get; set; }
		public weak bool non_null { get; set; }
		public weak bool is_null { get; set; }
		public weak Vala.DataType data_type { get; set; }
		public Vala.TypeParameter type_parameter { get; set; }
		public weak bool floating_reference { get; set; }
		public string namespace_name { get; set; }
		public string type_name { get; set; }
		public weak int array_rank { get; set; }
		public weak int pointer_level { get; set; }
		public weak bool is_ref { get; set; }
		public weak bool is_weak { get; set; }
	}
	[CCode (cheader_filename = "vala/valaunaryexpression.h")]
	public class UnaryExpression : Vala.Expression {
		public UnaryExpression (Vala.UnaryOperator op, Vala.Expression! _inner, Vala.SourceReference source);
		public weak Vala.UnaryOperator operator { get; set; }
		public Vala.Expression! inner { get; set construct; }
		public string! operator_string { get; }
	}
	[CCode (cheader_filename = "vala/valavariabledeclarator.h")]
	public class VariableDeclarator : Vala.Symbol, Vala.Invokable {
		public VariableDeclarator (string! name, Vala.Expression initializer = null, Vala.SourceReference source_reference = null);
		public Gee.Collection<Vala.FormalParameter> get_parameters ();
		public Vala.TypeReference get_return_type ();
		public bool is_invokable ();
		public Vala.Expression initializer { get; set; }
		public Vala.TypeReference type_reference { get; set; }
	}
	[CCode (cheader_filename = "vala/valawhilestatement.h")]
	public class WhileStatement : Vala.CodeNode, Vala.Statement {
		public WhileStatement (Vala.Expression! condition, Vala.Block! body, Vala.SourceReference source_reference = null);
		public Vala.Expression! condition { get; set construct; }
		public Vala.Block body { get; set; }
	}
	[CCode (cheader_filename = "vala/valabindingprovider.h")]
	public interface BindingProvider : GLib.Object {
		public abstract Vala.Symbol get_binding (Vala.MemberAccess! ma);
	}
	[CCode (cheader_filename = "vala/valainvokable.h")]
	public interface Invokable : Vala.Symbol {
		public abstract bool is_invokable ();
		public abstract Vala.TypeReference get_return_type ();
		public abstract Gee.Collection<Vala.FormalParameter> get_parameters ();
	}
	[CCode (cheader_filename = "vala/valalockable.h")]
	public interface Lockable : GLib.Object {
		public abstract bool get_lock_used ();
		public abstract void set_lock_used (bool used);
	}
	[CCode (cheader_filename = "vala/valastatement.h")]
	public interface Statement : Vala.CodeNode {
	}
}
