/* valatyperegisterfunction.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __GOBJECT_VALATYPEREGISTERFUNCTION_H__
#define __GOBJECT_VALATYPEREGISTERFUNCTION_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valadatatype.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodefragment.h>
#include <vala/valasymbol.h>

G_BEGIN_DECLS


#define VALA_TYPE_TYPE_REGISTER_FUNCTION (vala_type_register_function_get_type ())
#define VALA_TYPE_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPE_REGISTER_FUNCTION, ValaTypeRegisterFunction))
#define VALA_TYPE_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPE_REGISTER_FUNCTION, ValaTypeRegisterFunctionClass))
#define VALA_IS_TYPE_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPE_REGISTER_FUNCTION))
#define VALA_IS_TYPE_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPE_REGISTER_FUNCTION))
#define VALA_TYPE_REGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPE_REGISTER_FUNCTION, ValaTypeRegisterFunctionClass))

typedef struct _ValaTypeRegisterFunction ValaTypeRegisterFunction;
typedef struct _ValaTypeRegisterFunctionClass ValaTypeRegisterFunctionClass;
typedef struct _ValaTypeRegisterFunctionPrivate ValaTypeRegisterFunctionPrivate;

/**
 * C function to register a type at runtime.
 */
struct _ValaTypeRegisterFunction {
	GObject parent;
	ValaTypeRegisterFunctionPrivate * priv;
};
struct _ValaTypeRegisterFunctionClass {
	GObjectClass parent;
	ValaDataType* (*get_type_declaration) (ValaTypeRegisterFunction* self);
	char* (*get_type_struct_name) (ValaTypeRegisterFunction* self);
	char* (*get_base_init_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_class_init_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_instance_struct_size) (ValaTypeRegisterFunction* self);
	char* (*get_instance_init_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_parent_type_name) (ValaTypeRegisterFunction* self);
	char* (*get_type_flags) (ValaTypeRegisterFunction* self);
	ValaCCodeFragment* (*get_type_interface_init_declaration) (ValaTypeRegisterFunction* self);
	ValaCCodeFragment* (*get_type_interface_init_statements) (ValaTypeRegisterFunction* self);
	ValaSymbolAccessibility (*get_accessibility) (ValaTypeRegisterFunction* self);
};

void vala_type_register_function_init_from_type (ValaTypeRegisterFunction* self, gboolean plugin);
ValaDataType* vala_type_register_function_get_type_declaration (ValaTypeRegisterFunction* self);
char* vala_type_register_function_get_type_struct_name (ValaTypeRegisterFunction* self);
char* vala_type_register_function_get_base_init_func_name (ValaTypeRegisterFunction* self);
char* vala_type_register_function_get_class_init_func_name (ValaTypeRegisterFunction* self);
char* vala_type_register_function_get_instance_struct_size (ValaTypeRegisterFunction* self);
char* vala_type_register_function_get_instance_init_func_name (ValaTypeRegisterFunction* self);
char* vala_type_register_function_get_parent_type_name (ValaTypeRegisterFunction* self);
char* vala_type_register_function_get_type_flags (ValaTypeRegisterFunction* self);
ValaCCodeFragment* vala_type_register_function_get_type_interface_init_declaration (ValaTypeRegisterFunction* self);
ValaCCodeFragment* vala_type_register_function_get_type_interface_init_statements (ValaTypeRegisterFunction* self);
ValaCCodeFragment* vala_type_register_function_get_declaration (ValaTypeRegisterFunction* self);
ValaCCodeFragment* vala_type_register_function_get_definition (ValaTypeRegisterFunction* self);
ValaSymbolAccessibility vala_type_register_function_get_accessibility (ValaTypeRegisterFunction* self);
GType vala_type_register_function_get_type (void);

G_END_DECLS

#endif
