/* readonlycollection.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gee/readonlycollection.h>

typedef struct _GeeReadOnlyCollectionIterator GeeReadOnlyCollectionIterator;
typedef struct _GeeReadOnlyCollectionIteratorClass GeeReadOnlyCollectionIteratorClass;
typedef struct _GeeReadOnlyCollectionIteratorPrivate GeeReadOnlyCollectionIteratorPrivate;
struct _GeeReadOnlyCollectionPrivate {
	GeeCollection* _collection;
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};
#define GEE_READ_ONLY_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollectionPrivate))
enum  {
	GEE_READ_ONLY_COLLECTION_DUMMY_PROPERTY,
	GEE_READ_ONLY_COLLECTION_SIZE,
	GEE_READ_ONLY_COLLECTION_COLLECTION,
	GEE_READ_ONLY_COLLECTION_G_TYPE,
	GEE_READ_ONLY_COLLECTION_G_DUP_FUNC,
	GEE_READ_ONLY_COLLECTION_G_DESTROY_FUNC
};
static GeeIterator* gee_read_only_collection_real_iterator (GeeIterable* base);
static gboolean gee_read_only_collection_real_contains (GeeCollection* base, gconstpointer item);
static gboolean gee_read_only_collection_real_add (GeeCollection* base, gconstpointer item);
static gboolean gee_read_only_collection_real_remove (GeeCollection* base, gconstpointer item);
static void gee_read_only_collection_real_clear (GeeCollection* base);

#define GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR (gee_read_only_collection_iterator_get_type ())
#define GEE_READ_ONLY_COLLECTION_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR, GeeReadOnlyCollectionIterator))
#define GEE_READ_ONLY_COLLECTION_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR, GeeReadOnlyCollectionIteratorClass))
#define GEE_READ_ONLY_COLLECTION_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR))
#define GEE_READ_ONLY_COLLECTION_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR))
#define GEE_READ_ONLY_COLLECTION_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR, GeeReadOnlyCollectionIteratorClass))

struct _GeeReadOnlyCollectionIterator {
	GObject parent;
	GeeReadOnlyCollectionIteratorPrivate * priv;
};
struct _GeeReadOnlyCollectionIteratorClass {
	GObjectClass parent;
};
struct _GeeReadOnlyCollectionIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};
#define GEE_READ_ONLY_COLLECTION_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR, GeeReadOnlyCollectionIteratorPrivate))
enum  {
	GEE_READ_ONLY_COLLECTION_ITERATOR_DUMMY_PROPERTY,
	GEE_READ_ONLY_COLLECTION_ITERATOR_G_TYPE,
	GEE_READ_ONLY_COLLECTION_ITERATOR_G_DUP_FUNC,
	GEE_READ_ONLY_COLLECTION_ITERATOR_G_DESTROY_FUNC
};
static gboolean gee_read_only_collection_iterator_real_next (GeeIterator* base);
static gpointer gee_read_only_collection_iterator_real_get (GeeIterator* base);
static GeeReadOnlyCollectionIterator* gee_read_only_collection_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
static gpointer gee_read_only_collection_iterator_parent_class = NULL;
static GeeIteratorIface* gee_read_only_collection_iterator_gee_iterator_parent_iface = NULL;
static GType gee_read_only_collection_iterator_get_type (void);
static gpointer gee_read_only_collection_parent_class = NULL;
static GeeIterableIface* gee_read_only_collection_gee_iterable_parent_iface = NULL;
static GeeCollectionIface* gee_read_only_collection_gee_collection_parent_iface = NULL;
static void gee_read_only_collection_dispose (GObject * obj);


GeeReadOnlyCollection* gee_read_only_collection_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeCollection* collection) {
	GeeReadOnlyCollection * self;
	g_return_val_if_fail (collection == NULL || GEE_IS_COLLECTION (collection), NULL);
	self = g_object_newv (GEE_TYPE_READ_ONLY_COLLECTION, 0, NULL);
	gee_read_only_collection_set_collection (self, collection);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}


static GeeIterator* gee_read_only_collection_real_iterator (GeeIterable* base) {
	GeeReadOnlyCollection * self;
	self = GEE_READ_ONLY_COLLECTION (base);
	if (self->priv->_collection == NULL) {
		return GEE_ITERATOR (gee_read_only_collection_iterator_new (self->priv->g_type, ((GBoxedCopyFunc) self->priv->g_dup_func), self->priv->g_destroy_func));
	}
	return gee_iterable_iterator (GEE_ITERABLE (self->priv->_collection));
}


static gboolean gee_read_only_collection_real_contains (GeeCollection* base, gconstpointer item) {
	GeeReadOnlyCollection * self;
	self = GEE_READ_ONLY_COLLECTION (base);
	if (self->priv->_collection == NULL) {
		return FALSE;
	}
	return gee_collection_contains (self->priv->_collection, item);
}


static gboolean gee_read_only_collection_real_add (GeeCollection* base, gconstpointer item) {
	GeeReadOnlyCollection * self;
	self = GEE_READ_ONLY_COLLECTION (base);
	g_assert_not_reached ();
	return FALSE;
}


static gboolean gee_read_only_collection_real_remove (GeeCollection* base, gconstpointer item) {
	GeeReadOnlyCollection * self;
	self = GEE_READ_ONLY_COLLECTION (base);
	g_assert_not_reached ();
	return FALSE;
}


static void gee_read_only_collection_real_clear (GeeCollection* base) {
	GeeReadOnlyCollection * self;
	self = GEE_READ_ONLY_COLLECTION (base);
	g_assert_not_reached ();
}


static gint gee_read_only_collection_real_get_size (GeeReadOnlyCollection* self) {
	g_return_val_if_fail (GEE_IS_READ_ONLY_COLLECTION (self), 0);
	return gee_collection_get_size (self->priv->_collection);
}


void gee_read_only_collection_set_collection (GeeReadOnlyCollection* self, GeeCollection* value) {
	GeeCollection* _tmp1;
	GeeCollection* _tmp0;
	g_return_if_fail (GEE_IS_READ_ONLY_COLLECTION (self));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->_collection = (_tmp1 = (_tmp0 = value, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (self->priv->_collection == NULL ? NULL : (self->priv->_collection = (g_object_unref (self->priv->_collection), NULL))), _tmp1);
}


static gboolean gee_read_only_collection_iterator_real_next (GeeIterator* base) {
	GeeReadOnlyCollectionIterator * self;
	self = GEE_READ_ONLY_COLLECTION_ITERATOR (base);
	return FALSE;
}


static gpointer gee_read_only_collection_iterator_real_get (GeeIterator* base) {
	GeeReadOnlyCollectionIterator * self;
	self = GEE_READ_ONLY_COLLECTION_ITERATOR (base);
	return NULL;
}


static GeeReadOnlyCollectionIterator* gee_read_only_collection_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	GeeReadOnlyCollectionIterator * self;
	self = g_object_newv (GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR, 0, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}


static void gee_read_only_collection_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeReadOnlyCollectionIterator * self;
	self = GEE_READ_ONLY_COLLECTION_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_read_only_collection_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeReadOnlyCollectionIterator * self;
	self = GEE_READ_ONLY_COLLECTION_ITERATOR (object);
	switch (property_id) {
		case GEE_READ_ONLY_COLLECTION_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_READ_ONLY_COLLECTION_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_READ_ONLY_COLLECTION_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_read_only_collection_iterator_class_init (GeeReadOnlyCollectionIteratorClass * klass) {
	gee_read_only_collection_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeReadOnlyCollectionIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_read_only_collection_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_read_only_collection_iterator_set_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
}


static void gee_read_only_collection_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_read_only_collection_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = gee_read_only_collection_iterator_real_next;
	iface->get = gee_read_only_collection_iterator_real_get;
}


static void gee_read_only_collection_iterator_init (GeeReadOnlyCollectionIterator * self) {
	self->priv = GEE_READ_ONLY_COLLECTION_ITERATOR_GET_PRIVATE (self);
}


static GType gee_read_only_collection_iterator_get_type (void) {
	static GType gee_read_only_collection_iterator_type_id = 0;
	if (G_UNLIKELY (gee_read_only_collection_iterator_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeReadOnlyCollectionIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_read_only_collection_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeReadOnlyCollectionIterator), 0, (GInstanceInitFunc) gee_read_only_collection_iterator_init };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_read_only_collection_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_read_only_collection_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeReadOnlyCollectionIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_read_only_collection_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
	}
	return gee_read_only_collection_iterator_type_id;
}


static void gee_read_only_collection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeReadOnlyCollection * self;
	self = GEE_READ_ONLY_COLLECTION (object);
	switch (property_id) {
		case GEE_READ_ONLY_COLLECTION_SIZE:
		g_value_set_int (value, gee_read_only_collection_real_get_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_read_only_collection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeReadOnlyCollection * self;
	self = GEE_READ_ONLY_COLLECTION (object);
	switch (property_id) {
		case GEE_READ_ONLY_COLLECTION_COLLECTION:
		gee_read_only_collection_set_collection (self, g_value_get_object (value));
		break;
		case GEE_READ_ONLY_COLLECTION_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_READ_ONLY_COLLECTION_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_READ_ONLY_COLLECTION_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_read_only_collection_class_init (GeeReadOnlyCollectionClass * klass) {
	gee_read_only_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeReadOnlyCollectionPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_read_only_collection_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_read_only_collection_set_property;
	G_OBJECT_CLASS (klass)->dispose = gee_read_only_collection_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_SIZE, "size");
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_COLLECTION, g_param_spec_object ("collection", "collection", "collection", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
}


static void gee_read_only_collection_gee_iterable_interface_init (GeeIterableIface * iface) {
	gee_read_only_collection_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = gee_read_only_collection_real_iterator;
}


static void gee_read_only_collection_gee_collection_interface_init (GeeCollectionIface * iface) {
	gee_read_only_collection_gee_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->contains = gee_read_only_collection_real_contains;
	iface->add = gee_read_only_collection_real_add;
	iface->remove = gee_read_only_collection_real_remove;
	iface->clear = gee_read_only_collection_real_clear;
}


static void gee_read_only_collection_init (GeeReadOnlyCollection * self) {
	self->priv = GEE_READ_ONLY_COLLECTION_GET_PRIVATE (self);
}


static void gee_read_only_collection_dispose (GObject * obj) {
	GeeReadOnlyCollection * self;
	self = GEE_READ_ONLY_COLLECTION (obj);
	(self->priv->_collection == NULL ? NULL : (self->priv->_collection = (g_object_unref (self->priv->_collection), NULL)));
	G_OBJECT_CLASS (gee_read_only_collection_parent_class)->dispose (obj);
}


GType gee_read_only_collection_get_type (void) {
	static GType gee_read_only_collection_type_id = 0;
	if (G_UNLIKELY (gee_read_only_collection_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeReadOnlyCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_read_only_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeReadOnlyCollection), 0, (GInstanceInitFunc) gee_read_only_collection_init };
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) gee_read_only_collection_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_collection_info = { (GInterfaceInitFunc) gee_read_only_collection_gee_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_read_only_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeReadOnlyCollection", &g_define_type_info, 0);
		g_type_add_interface_static (gee_read_only_collection_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_type_add_interface_static (gee_read_only_collection_type_id, GEE_TYPE_COLLECTION, &gee_collection_info);
	}
	return gee_read_only_collection_type_id;
}




