/* valaccodeswitchstatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeswitchstatement.h>
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodelinedirective.h>

struct _ValaCCodeSwitchStatementPrivate {
	ValaCCodeExpression* _expression;
	GeeList* case_statements;
	GeeList* default_statements;
};
#define VALA_CCODE_SWITCH_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_SWITCH_STATEMENT, ValaCCodeSwitchStatementPrivate))
enum  {
	VALA_CCODE_SWITCH_STATEMENT_DUMMY_PROPERTY,
	VALA_CCODE_SWITCH_STATEMENT_EXPRESSION
};
static void vala_ccode_switch_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_switch_statement_parent_class = NULL;
static void vala_ccode_switch_statement_dispose (GObject * obj);


ValaCCodeSwitchStatement* vala_ccode_switch_statement_new (ValaCCodeExpression* expression) {
	ValaCCodeSwitchStatement * self;
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (expression), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_SWITCH_STATEMENT, 0, NULL);
	vala_ccode_switch_statement_set_expression (self, expression);
	return self;
}


/**
 * Adds the specified case statement to the list of switch sections.
 *
 * @param case_stmt a case statement
 */
void vala_ccode_switch_statement_add_case (ValaCCodeSwitchStatement* self, ValaCCodeCaseStatement* case_stmt) {
	g_return_if_fail (VALA_IS_CCODE_SWITCH_STATEMENT (self));
	g_return_if_fail (VALA_IS_CCODE_CASE_STATEMENT (case_stmt));
	gee_collection_add (GEE_COLLECTION (self->priv->case_statements), case_stmt);
}


/**
 * Append the specified statement to the default clause.
 *
 * @param stmt a statement
 */
void vala_ccode_switch_statement_add_default_statement (ValaCCodeSwitchStatement* self, ValaCCodeStatement* stmt) {
	g_return_if_fail (VALA_IS_CCODE_SWITCH_STATEMENT (self));
	g_return_if_fail (VALA_IS_CCODE_STATEMENT (stmt));
	gee_collection_add (GEE_COLLECTION (self->priv->default_statements), stmt);
}


static void vala_ccode_switch_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeSwitchStatement * self;
	self = VALA_CCODE_SWITCH_STATEMENT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_indent (writer, vala_ccode_node_get_line (VALA_CCODE_NODE (self)));
	vala_ccode_writer_write_string (writer, "switch (");
	vala_ccode_node_write (VALA_CCODE_NODE (vala_ccode_switch_statement_get_expression (self)), writer);
	vala_ccode_writer_write_string (writer, ")");
	vala_ccode_writer_write_begin_block (writer);
	{
		GeeList* case_stmt_collection;
		GeeIterator* case_stmt_it;
		case_stmt_collection = self->priv->case_statements;
		case_stmt_it = gee_iterable_iterator (GEE_ITERABLE (case_stmt_collection));
		while (gee_iterator_next (case_stmt_it)) {
			ValaCCodeCaseStatement* case_stmt;
			case_stmt = gee_iterator_get (case_stmt_it);
			{
				vala_ccode_node_write (VALA_CCODE_NODE (case_stmt), writer);
				(case_stmt == NULL ? NULL : (case_stmt = (g_object_unref (case_stmt), NULL)));
			}
		}
		(case_stmt_it == NULL ? NULL : (case_stmt_it = (g_object_unref (case_stmt_it), NULL)));
	}
	if (gee_collection_get_size (GEE_COLLECTION (self->priv->default_statements)) > 0) {
		vala_ccode_writer_write_indent (writer, NULL);
		vala_ccode_writer_write_string (writer, "default:");
		vala_ccode_writer_write_newline (writer);
		{
			GeeList* stmt_collection;
			GeeIterator* stmt_it;
			stmt_collection = self->priv->default_statements;
			stmt_it = gee_iterable_iterator (GEE_ITERABLE (stmt_collection));
			while (gee_iterator_next (stmt_it)) {
				ValaCCodeStatement* stmt;
				stmt = gee_iterator_get (stmt_it);
				{
					vala_ccode_node_write (VALA_CCODE_NODE (stmt), writer);
					(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
				}
			}
			(stmt_it == NULL ? NULL : (stmt_it = (g_object_unref (stmt_it), NULL)));
		}
	}
	vala_ccode_writer_write_end_block (writer);
}


ValaCCodeExpression* vala_ccode_switch_statement_get_expression (ValaCCodeSwitchStatement* self) {
	g_return_val_if_fail (VALA_IS_CCODE_SWITCH_STATEMENT (self), NULL);
	return self->priv->_expression;
}


void vala_ccode_switch_statement_set_expression (ValaCCodeSwitchStatement* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_SWITCH_STATEMENT (self));
	_tmp1 = NULL;
	self->priv->_expression = (_tmp1 = g_object_ref (value), (self->priv->_expression == NULL ? NULL : (self->priv->_expression = (g_object_unref (self->priv->_expression), NULL))), _tmp1);
}


static void vala_ccode_switch_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeSwitchStatement * self;
	self = VALA_CCODE_SWITCH_STATEMENT (object);
	switch (property_id) {
		case VALA_CCODE_SWITCH_STATEMENT_EXPRESSION:
		g_value_set_object (value, vala_ccode_switch_statement_get_expression (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_switch_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeSwitchStatement * self;
	self = VALA_CCODE_SWITCH_STATEMENT (object);
	switch (property_id) {
		case VALA_CCODE_SWITCH_STATEMENT_EXPRESSION:
		vala_ccode_switch_statement_set_expression (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_switch_statement_class_init (ValaCCodeSwitchStatementClass * klass) {
	vala_ccode_switch_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeSwitchStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_switch_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_switch_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_switch_statement_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_switch_statement_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_SWITCH_STATEMENT_EXPRESSION, g_param_spec_object ("expression", "expression", "expression", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_switch_statement_init (ValaCCodeSwitchStatement * self) {
	self->priv = VALA_CCODE_SWITCH_STATEMENT_GET_PRIVATE (self);
	self->priv->case_statements = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_CASE_STATEMENT, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal));
	self->priv->default_statements = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_STATEMENT, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal));
}


static void vala_ccode_switch_statement_dispose (GObject * obj) {
	ValaCCodeSwitchStatement * self;
	self = VALA_CCODE_SWITCH_STATEMENT (obj);
	(self->priv->_expression == NULL ? NULL : (self->priv->_expression = (g_object_unref (self->priv->_expression), NULL)));
	(self->priv->case_statements == NULL ? NULL : (self->priv->case_statements = (g_object_unref (self->priv->case_statements), NULL)));
	(self->priv->default_statements == NULL ? NULL : (self->priv->default_statements = (g_object_unref (self->priv->default_statements), NULL)));
	G_OBJECT_CLASS (vala_ccode_switch_statement_parent_class)->dispose (obj);
}


GType vala_ccode_switch_statement_get_type (void) {
	static GType vala_ccode_switch_statement_type_id = 0;
	if (G_UNLIKELY (vala_ccode_switch_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeSwitchStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_switch_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeSwitchStatement), 0, (GInstanceInitFunc) vala_ccode_switch_statement_init };
		vala_ccode_switch_statement_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeSwitchStatement", &g_define_type_info, 0);
	}
	return vala_ccode_switch_statement_type_id;
}




