/* valalocalvariabledeclaration.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALALOCALVARIABLEDECLARATION_H__
#define __VALA_VALALOCALVARIABLEDECLARATION_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/collection.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_LOCAL_VARIABLE_DECLARATION (vala_local_variable_declaration_get_type ())
#define VALA_LOCAL_VARIABLE_DECLARATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE_DECLARATION, ValaLocalVariableDeclaration))
#define VALA_LOCAL_VARIABLE_DECLARATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE_DECLARATION, ValaLocalVariableDeclarationClass))
#define VALA_IS_LOCAL_VARIABLE_DECLARATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE_DECLARATION))
#define VALA_IS_LOCAL_VARIABLE_DECLARATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE_DECLARATION))
#define VALA_LOCAL_VARIABLE_DECLARATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE_DECLARATION, ValaLocalVariableDeclarationClass))

typedef struct _ValaLocalVariableDeclarationPrivate ValaLocalVariableDeclarationPrivate;

/**
 * Represents a local variable declaration in the source code.
 */
struct _ValaLocalVariableDeclaration {
	ValaCodeNode parent;
	ValaLocalVariableDeclarationPrivate * priv;
};
struct _ValaLocalVariableDeclarationClass {
	ValaCodeNodeClass parent;
};

ValaLocalVariableDeclaration* vala_local_variable_declaration_new (ValaTypeReference* type_reference, ValaSourceReference* source_reference);
ValaLocalVariableDeclaration* vala_local_variable_declaration_new_var_type (ValaSourceReference* source_reference);
void vala_local_variable_declaration_add_declarator (ValaLocalVariableDeclaration* self, ValaVariableDeclarator* declarator);
GeeCollection* vala_local_variable_declaration_get_variable_declarators (ValaLocalVariableDeclaration* self);
ValaTypeReference* vala_local_variable_declaration_get_type_reference (ValaLocalVariableDeclaration* self);
void vala_local_variable_declaration_set_type_reference (ValaLocalVariableDeclaration* self, ValaTypeReference* value);
GType vala_local_variable_declaration_get_type (void);

G_END_DECLS

#endif
