/* valainvokable.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAINVOKABLE_H__
#define __VALA_VALAINVOKABLE_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/collection.h>
#include <vala/valasymbol.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_INVOKABLE (vala_invokable_get_type ())
#define VALA_INVOKABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INVOKABLE, ValaInvokable))
#define VALA_IS_INVOKABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INVOKABLE))
#define VALA_INVOKABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_INVOKABLE, ValaInvokableIface))


/**
 * Represents a possibly invokable code object.
 */
struct _ValaInvokableIface {
	GTypeInterface parent;
	gboolean (*is_invokable) (ValaInvokable* self);
	ValaTypeReference* (*get_return_type) (ValaInvokable* self);
	GeeCollection* (*get_parameters) (ValaInvokable* self);
};

gboolean vala_invokable_is_invokable (ValaInvokable* self);
ValaTypeReference* vala_invokable_get_return_type (ValaInvokable* self);
GeeCollection* vala_invokable_get_parameters (ValaInvokable* self);
GType vala_invokable_get_type (void);

G_END_DECLS

#endif
