/* valacodegenerator.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valacodegenerator.h>
#include <vala/valacodecontext.h>
#include <vala/valanamespace.h>
#include <vala/valaclass.h>
#include <vala/valastruct.h>
#include <vala/valainterface.h>
#include <vala/valaenum.h>
#include <vala/valaenumvalue.h>
#include <vala/valacallback.h>
#include <vala/valaconstant.h>
#include <vala/valafield.h>
#include <vala/valamethod.h>
#include <vala/valacreationmethod.h>
#include <vala/valaformalparameter.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valasignal.h>
#include <vala/valaconstructor.h>
#include <vala/valadestructor.h>
#include <vala/valatypeparameter.h>
#include <vala/valablock.h>
#include <vala/valaemptystatement.h>
#include <vala/valadeclarationstatement.h>
#include <vala/valalocalvariabledeclaration.h>
#include <vala/valavariabledeclarator.h>
#include <vala/valainitializerlist.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valaifstatement.h>
#include <vala/valaswitchstatement.h>
#include <vala/valaswitchsection.h>
#include <vala/valaswitchlabel.h>
#include <vala/valawhilestatement.h>
#include <vala/valadostatement.h>
#include <vala/valaforstatement.h>
#include <vala/valaforeachstatement.h>
#include <vala/valabreakstatement.h>
#include <vala/valacontinuestatement.h>
#include <vala/valareturnstatement.h>
#include <vala/valathrowstatement.h>
#include <vala/valatrystatement.h>
#include <vala/valacatchclause.h>
#include <vala/valalockstatement.h>
#include <vala/valaarraycreationexpression.h>
#include <vala/valabooleanliteral.h>
#include <vala/valacharacterliteral.h>
#include <vala/valaintegerliteral.h>
#include <vala/valarealliteral.h>
#include <vala/valastringliteral.h>
#include <vala/valanullliteral.h>
#include <vala/valaliteralexpression.h>
#include <vala/valaparenthesizedexpression.h>
#include <vala/valamemberaccess.h>
#include <vala/valainvocationexpression.h>
#include <vala/valaelementaccess.h>
#include <vala/valabaseaccess.h>
#include <vala/valapostfixexpression.h>
#include <vala/valaobjectcreationexpression.h>
#include <vala/valasizeofexpression.h>
#include <vala/valatypeofexpression.h>
#include <vala/valaunaryexpression.h>
#include <vala/valacastexpression.h>
#include <vala/valapointerindirection.h>
#include <vala/valaaddressofexpression.h>
#include <vala/valareferencetransferexpression.h>
#include <vala/valabinaryexpression.h>
#include <vala/valatypecheck.h>
#include <vala/valaconditionalexpression.h>
#include <vala/valalambdaexpression.h>
#include <vala/valaassignment.h>

enum  {
	VALA_CODE_GENERATOR_DUMMY_PROPERTY
};
static void vala_code_generator_real_emit (ValaCodeGenerator* self, ValaCodeContext* context);
static ValaCodeBinding* vala_code_generator_real_create_namespace_binding (ValaCodeGenerator* self, ValaNamespace* node);
static ValaCodeBinding* vala_code_generator_real_create_class_binding (ValaCodeGenerator* self, ValaClass* node);
static ValaCodeBinding* vala_code_generator_real_create_struct_binding (ValaCodeGenerator* self, ValaStruct* node);
static ValaCodeBinding* vala_code_generator_real_create_interface_binding (ValaCodeGenerator* self, ValaInterface* node);
static ValaCodeBinding* vala_code_generator_real_create_enum_binding (ValaCodeGenerator* self, ValaEnum* node);
static ValaCodeBinding* vala_code_generator_real_create_enum_value_binding (ValaCodeGenerator* self, ValaEnumValue* node);
static ValaCodeBinding* vala_code_generator_real_create_callback_binding (ValaCodeGenerator* self, ValaCallback* node);
static ValaCodeBinding* vala_code_generator_real_create_constant_binding (ValaCodeGenerator* self, ValaConstant* node);
static ValaCodeBinding* vala_code_generator_real_create_field_binding (ValaCodeGenerator* self, ValaField* node);
static ValaCodeBinding* vala_code_generator_real_create_method_binding (ValaCodeGenerator* self, ValaMethod* node);
static ValaCodeBinding* vala_code_generator_real_create_creation_method_binding (ValaCodeGenerator* self, ValaCreationMethod* node);
static ValaCodeBinding* vala_code_generator_real_create_formal_parameter_binding (ValaCodeGenerator* self, ValaFormalParameter* node);
static ValaCodeBinding* vala_code_generator_real_create_property_binding (ValaCodeGenerator* self, ValaProperty* node);
static ValaCodeBinding* vala_code_generator_real_create_property_accessor_binding (ValaCodeGenerator* self, ValaPropertyAccessor* node);
static ValaCodeBinding* vala_code_generator_real_create_signal_binding (ValaCodeGenerator* self, ValaSignal* node);
static ValaCodeBinding* vala_code_generator_real_create_constructor_binding (ValaCodeGenerator* self, ValaConstructor* node);
static ValaCodeBinding* vala_code_generator_real_create_destructor_binding (ValaCodeGenerator* self, ValaDestructor* node);
static ValaCodeBinding* vala_code_generator_real_create_type_parameter_binding (ValaCodeGenerator* self, ValaTypeParameter* node);
static ValaCodeBinding* vala_code_generator_real_create_block_binding (ValaCodeGenerator* self, ValaBlock* node);
static ValaCodeBinding* vala_code_generator_real_create_empty_statement_binding (ValaCodeGenerator* self, ValaEmptyStatement* node);
static ValaCodeBinding* vala_code_generator_real_create_declaration_statement_binding (ValaCodeGenerator* self, ValaDeclarationStatement* node);
static ValaCodeBinding* vala_code_generator_real_create_local_variable_declaration_binding (ValaCodeGenerator* self, ValaLocalVariableDeclaration* node);
static ValaCodeBinding* vala_code_generator_real_create_variable_declarator_binding (ValaCodeGenerator* self, ValaVariableDeclarator* node);
static ValaCodeBinding* vala_code_generator_real_create_initializer_list_binding (ValaCodeGenerator* self, ValaInitializerList* node);
static ValaCodeBinding* vala_code_generator_real_create_expression_statement_binding (ValaCodeGenerator* self, ValaExpressionStatement* node);
static ValaCodeBinding* vala_code_generator_real_create_if_statement_binding (ValaCodeGenerator* self, ValaIfStatement* node);
static ValaCodeBinding* vala_code_generator_real_create_switch_statement_binding (ValaCodeGenerator* self, ValaSwitchStatement* node);
static ValaCodeBinding* vala_code_generator_real_create_switch_section_binding (ValaCodeGenerator* self, ValaSwitchSection* node);
static ValaCodeBinding* vala_code_generator_real_create_switch_label_binding (ValaCodeGenerator* self, ValaSwitchLabel* node);
static ValaCodeBinding* vala_code_generator_real_create_while_statement_binding (ValaCodeGenerator* self, ValaWhileStatement* node);
static ValaCodeBinding* vala_code_generator_real_create_do_statement_binding (ValaCodeGenerator* self, ValaDoStatement* node);
static ValaCodeBinding* vala_code_generator_real_create_for_statement_binding (ValaCodeGenerator* self, ValaForStatement* node);
static ValaCodeBinding* vala_code_generator_real_create_foreach_statement_binding (ValaCodeGenerator* self, ValaForeachStatement* node);
static ValaCodeBinding* vala_code_generator_real_create_break_statement_binding (ValaCodeGenerator* self, ValaBreakStatement* node);
static ValaCodeBinding* vala_code_generator_real_create_continue_statement_binding (ValaCodeGenerator* self, ValaContinueStatement* node);
static ValaCodeBinding* vala_code_generator_real_create_return_statement_binding (ValaCodeGenerator* self, ValaReturnStatement* node);
static ValaCodeBinding* vala_code_generator_real_create_throw_statement_binding (ValaCodeGenerator* self, ValaThrowStatement* node);
static ValaCodeBinding* vala_code_generator_real_create_try_statement_binding (ValaCodeGenerator* self, ValaTryStatement* node);
static ValaCodeBinding* vala_code_generator_real_create_catch_clause_binding (ValaCodeGenerator* self, ValaCatchClause* node);
static ValaCodeBinding* vala_code_generator_real_create_lock_statement_binding (ValaCodeGenerator* self, ValaLockStatement* node);
static ValaCodeBinding* vala_code_generator_real_create_array_creation_expression_binding (ValaCodeGenerator* self, ValaArrayCreationExpression* node);
static ValaCodeBinding* vala_code_generator_real_create_boolean_literal_binding (ValaCodeGenerator* self, ValaBooleanLiteral* node);
static ValaCodeBinding* vala_code_generator_real_create_character_literal_binding (ValaCodeGenerator* self, ValaCharacterLiteral* node);
static ValaCodeBinding* vala_code_generator_real_create_integer_literal_binding (ValaCodeGenerator* self, ValaIntegerLiteral* node);
static ValaCodeBinding* vala_code_generator_real_create_real_literal_binding (ValaCodeGenerator* self, ValaRealLiteral* node);
static ValaCodeBinding* vala_code_generator_real_create_string_literal_binding (ValaCodeGenerator* self, ValaStringLiteral* node);
static ValaCodeBinding* vala_code_generator_real_create_null_literal_binding (ValaCodeGenerator* self, ValaNullLiteral* node);
static ValaCodeBinding* vala_code_generator_real_create_literal_expression_binding (ValaCodeGenerator* self, ValaLiteralExpression* node);
static ValaCodeBinding* vala_code_generator_real_create_parenthesized_expression_binding (ValaCodeGenerator* self, ValaParenthesizedExpression* node);
static ValaCodeBinding* vala_code_generator_real_create_member_access_binding (ValaCodeGenerator* self, ValaMemberAccess* node);
static ValaCodeBinding* vala_code_generator_real_create_member_access_simple_binding (ValaCodeGenerator* self, ValaMemberAccess* node);
static ValaCodeBinding* vala_code_generator_real_create_invocation_expression_binding (ValaCodeGenerator* self, ValaInvocationExpression* node);
static ValaCodeBinding* vala_code_generator_real_create_element_access_binding (ValaCodeGenerator* self, ValaElementAccess* node);
static ValaCodeBinding* vala_code_generator_real_create_base_access_binding (ValaCodeGenerator* self, ValaBaseAccess* node);
static ValaCodeBinding* vala_code_generator_real_create_postfix_expression_binding (ValaCodeGenerator* self, ValaPostfixExpression* node);
static ValaCodeBinding* vala_code_generator_real_create_object_creation_expression_binding (ValaCodeGenerator* self, ValaObjectCreationExpression* node);
static ValaCodeBinding* vala_code_generator_real_create_sizeof_expression_binding (ValaCodeGenerator* self, ValaSizeofExpression* node);
static ValaCodeBinding* vala_code_generator_real_create_typeof_expression_binding (ValaCodeGenerator* self, ValaTypeofExpression* node);
static ValaCodeBinding* vala_code_generator_real_create_unary_expression_binding (ValaCodeGenerator* self, ValaUnaryExpression* node);
static ValaCodeBinding* vala_code_generator_real_create_cast_expression_binding (ValaCodeGenerator* self, ValaCastExpression* node);
static ValaCodeBinding* vala_code_generator_real_create_pointer_indirection_binding (ValaCodeGenerator* self, ValaPointerIndirection* node);
static ValaCodeBinding* vala_code_generator_real_create_addressof_expression_binding (ValaCodeGenerator* self, ValaAddressofExpression* node);
static ValaCodeBinding* vala_code_generator_real_create_reference_transfer_expression_binding (ValaCodeGenerator* self, ValaReferenceTransferExpression* node);
static ValaCodeBinding* vala_code_generator_real_create_binary_expression_binding (ValaCodeGenerator* self, ValaBinaryExpression* node);
static ValaCodeBinding* vala_code_generator_real_create_type_check_binding (ValaCodeGenerator* self, ValaTypeCheck* node);
static ValaCodeBinding* vala_code_generator_real_create_conditional_expression_binding (ValaCodeGenerator* self, ValaConditionalExpression* node);
static ValaCodeBinding* vala_code_generator_real_create_lambda_expression_binding (ValaCodeGenerator* self, ValaLambdaExpression* node);
static ValaCodeBinding* vala_code_generator_real_create_lambda_expression_with_statement_body_binding (ValaCodeGenerator* self, ValaLambdaExpression* node);
static ValaCodeBinding* vala_code_generator_real_create_assignment_binding (ValaCodeGenerator* self, ValaAssignment* node);
static gpointer vala_code_generator_parent_class = NULL;


/**
 * Generate and emit C code for the specified code context.
 *
 * @param context a code context
 */
static void vala_code_generator_real_emit (ValaCodeGenerator* self, ValaCodeContext* context) {
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CODE_CONTEXT (context));
}


void vala_code_generator_emit (ValaCodeGenerator* self, ValaCodeContext* context) {
	VALA_CODE_GENERATOR_GET_CLASS (self)->emit (self, context);
}


static ValaCodeBinding* vala_code_generator_real_create_namespace_binding (ValaCodeGenerator* self, ValaNamespace* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_NAMESPACE (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_namespace_binding (ValaCodeGenerator* self, ValaNamespace* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_namespace_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_class_binding (ValaCodeGenerator* self, ValaClass* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CLASS (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_class_binding (ValaCodeGenerator* self, ValaClass* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_class_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_struct_binding (ValaCodeGenerator* self, ValaStruct* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_STRUCT (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_struct_binding (ValaCodeGenerator* self, ValaStruct* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_struct_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_interface_binding (ValaCodeGenerator* self, ValaInterface* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_INTERFACE (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_interface_binding (ValaCodeGenerator* self, ValaInterface* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_interface_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_enum_binding (ValaCodeGenerator* self, ValaEnum* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_ENUM (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_enum_binding (ValaCodeGenerator* self, ValaEnum* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_enum_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_enum_value_binding (ValaCodeGenerator* self, ValaEnumValue* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_ENUM_VALUE (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_enum_value_binding (ValaCodeGenerator* self, ValaEnumValue* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_enum_value_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_callback_binding (ValaCodeGenerator* self, ValaCallback* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CALLBACK (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_callback_binding (ValaCodeGenerator* self, ValaCallback* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_callback_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_constant_binding (ValaCodeGenerator* self, ValaConstant* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CONSTANT (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_constant_binding (ValaCodeGenerator* self, ValaConstant* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_constant_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_field_binding (ValaCodeGenerator* self, ValaField* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_FIELD (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_field_binding (ValaCodeGenerator* self, ValaField* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_field_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_method_binding (ValaCodeGenerator* self, ValaMethod* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_method_binding (ValaCodeGenerator* self, ValaMethod* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_method_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_creation_method_binding (ValaCodeGenerator* self, ValaCreationMethod* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CREATION_METHOD (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_creation_method_binding (ValaCodeGenerator* self, ValaCreationMethod* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_creation_method_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_formal_parameter_binding (ValaCodeGenerator* self, ValaFormalParameter* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_FORMAL_PARAMETER (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_formal_parameter_binding (ValaCodeGenerator* self, ValaFormalParameter* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_formal_parameter_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_property_binding (ValaCodeGenerator* self, ValaProperty* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_property_binding (ValaCodeGenerator* self, ValaProperty* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_property_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_property_accessor_binding (ValaCodeGenerator* self, ValaPropertyAccessor* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY_ACCESSOR (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_property_accessor_binding (ValaCodeGenerator* self, ValaPropertyAccessor* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_property_accessor_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_signal_binding (ValaCodeGenerator* self, ValaSignal* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SIGNAL (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_signal_binding (ValaCodeGenerator* self, ValaSignal* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_signal_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_constructor_binding (ValaCodeGenerator* self, ValaConstructor* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CONSTRUCTOR (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_constructor_binding (ValaCodeGenerator* self, ValaConstructor* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_constructor_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_destructor_binding (ValaCodeGenerator* self, ValaDestructor* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_DESTRUCTOR (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_destructor_binding (ValaCodeGenerator* self, ValaDestructor* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_destructor_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_type_parameter_binding (ValaCodeGenerator* self, ValaTypeParameter* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_PARAMETER (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_type_parameter_binding (ValaCodeGenerator* self, ValaTypeParameter* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_type_parameter_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_block_binding (ValaCodeGenerator* self, ValaBlock* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_BLOCK (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_block_binding (ValaCodeGenerator* self, ValaBlock* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_block_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_empty_statement_binding (ValaCodeGenerator* self, ValaEmptyStatement* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EMPTY_STATEMENT (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_empty_statement_binding (ValaCodeGenerator* self, ValaEmptyStatement* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_empty_statement_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_declaration_statement_binding (ValaCodeGenerator* self, ValaDeclarationStatement* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_DECLARATION_STATEMENT (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_declaration_statement_binding (ValaCodeGenerator* self, ValaDeclarationStatement* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_declaration_statement_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_local_variable_declaration_binding (ValaCodeGenerator* self, ValaLocalVariableDeclaration* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_LOCAL_VARIABLE_DECLARATION (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_local_variable_declaration_binding (ValaCodeGenerator* self, ValaLocalVariableDeclaration* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_local_variable_declaration_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_variable_declarator_binding (ValaCodeGenerator* self, ValaVariableDeclarator* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_VARIABLE_DECLARATOR (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_variable_declarator_binding (ValaCodeGenerator* self, ValaVariableDeclarator* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_variable_declarator_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_initializer_list_binding (ValaCodeGenerator* self, ValaInitializerList* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_INITIALIZER_LIST (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_initializer_list_binding (ValaCodeGenerator* self, ValaInitializerList* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_initializer_list_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_expression_statement_binding (ValaCodeGenerator* self, ValaExpressionStatement* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION_STATEMENT (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_expression_statement_binding (ValaCodeGenerator* self, ValaExpressionStatement* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_expression_statement_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_if_statement_binding (ValaCodeGenerator* self, ValaIfStatement* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_IF_STATEMENT (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_if_statement_binding (ValaCodeGenerator* self, ValaIfStatement* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_if_statement_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_switch_statement_binding (ValaCodeGenerator* self, ValaSwitchStatement* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SWITCH_STATEMENT (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_switch_statement_binding (ValaCodeGenerator* self, ValaSwitchStatement* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_switch_statement_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_switch_section_binding (ValaCodeGenerator* self, ValaSwitchSection* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SWITCH_SECTION (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_switch_section_binding (ValaCodeGenerator* self, ValaSwitchSection* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_switch_section_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_switch_label_binding (ValaCodeGenerator* self, ValaSwitchLabel* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SWITCH_LABEL (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_switch_label_binding (ValaCodeGenerator* self, ValaSwitchLabel* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_switch_label_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_while_statement_binding (ValaCodeGenerator* self, ValaWhileStatement* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_WHILE_STATEMENT (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_while_statement_binding (ValaCodeGenerator* self, ValaWhileStatement* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_while_statement_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_do_statement_binding (ValaCodeGenerator* self, ValaDoStatement* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_DO_STATEMENT (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_do_statement_binding (ValaCodeGenerator* self, ValaDoStatement* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_do_statement_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_for_statement_binding (ValaCodeGenerator* self, ValaForStatement* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_FOR_STATEMENT (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_for_statement_binding (ValaCodeGenerator* self, ValaForStatement* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_for_statement_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_foreach_statement_binding (ValaCodeGenerator* self, ValaForeachStatement* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_FOREACH_STATEMENT (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_foreach_statement_binding (ValaCodeGenerator* self, ValaForeachStatement* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_foreach_statement_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_break_statement_binding (ValaCodeGenerator* self, ValaBreakStatement* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_BREAK_STATEMENT (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_break_statement_binding (ValaCodeGenerator* self, ValaBreakStatement* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_break_statement_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_continue_statement_binding (ValaCodeGenerator* self, ValaContinueStatement* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CONTINUE_STATEMENT (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_continue_statement_binding (ValaCodeGenerator* self, ValaContinueStatement* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_continue_statement_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_return_statement_binding (ValaCodeGenerator* self, ValaReturnStatement* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_RETURN_STATEMENT (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_return_statement_binding (ValaCodeGenerator* self, ValaReturnStatement* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_return_statement_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_throw_statement_binding (ValaCodeGenerator* self, ValaThrowStatement* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_THROW_STATEMENT (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_throw_statement_binding (ValaCodeGenerator* self, ValaThrowStatement* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_throw_statement_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_try_statement_binding (ValaCodeGenerator* self, ValaTryStatement* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TRY_STATEMENT (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_try_statement_binding (ValaCodeGenerator* self, ValaTryStatement* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_try_statement_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_catch_clause_binding (ValaCodeGenerator* self, ValaCatchClause* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CATCH_CLAUSE (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_catch_clause_binding (ValaCodeGenerator* self, ValaCatchClause* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_catch_clause_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_lock_statement_binding (ValaCodeGenerator* self, ValaLockStatement* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_LOCK_STATEMENT (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_lock_statement_binding (ValaCodeGenerator* self, ValaLockStatement* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_lock_statement_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_array_creation_expression_binding (ValaCodeGenerator* self, ValaArrayCreationExpression* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_array_creation_expression_binding (ValaCodeGenerator* self, ValaArrayCreationExpression* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_array_creation_expression_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_boolean_literal_binding (ValaCodeGenerator* self, ValaBooleanLiteral* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_BOOLEAN_LITERAL (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_boolean_literal_binding (ValaCodeGenerator* self, ValaBooleanLiteral* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_boolean_literal_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_character_literal_binding (ValaCodeGenerator* self, ValaCharacterLiteral* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CHARACTER_LITERAL (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_character_literal_binding (ValaCodeGenerator* self, ValaCharacterLiteral* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_character_literal_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_integer_literal_binding (ValaCodeGenerator* self, ValaIntegerLiteral* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_INTEGER_LITERAL (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_integer_literal_binding (ValaCodeGenerator* self, ValaIntegerLiteral* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_integer_literal_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_real_literal_binding (ValaCodeGenerator* self, ValaRealLiteral* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_REAL_LITERAL (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_real_literal_binding (ValaCodeGenerator* self, ValaRealLiteral* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_real_literal_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_string_literal_binding (ValaCodeGenerator* self, ValaStringLiteral* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_STRING_LITERAL (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_string_literal_binding (ValaCodeGenerator* self, ValaStringLiteral* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_string_literal_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_null_literal_binding (ValaCodeGenerator* self, ValaNullLiteral* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_NULL_LITERAL (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_null_literal_binding (ValaCodeGenerator* self, ValaNullLiteral* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_null_literal_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_literal_expression_binding (ValaCodeGenerator* self, ValaLiteralExpression* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_LITERAL_EXPRESSION (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_literal_expression_binding (ValaCodeGenerator* self, ValaLiteralExpression* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_literal_expression_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_parenthesized_expression_binding (ValaCodeGenerator* self, ValaParenthesizedExpression* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_PARENTHESIZED_EXPRESSION (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_parenthesized_expression_binding (ValaCodeGenerator* self, ValaParenthesizedExpression* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_parenthesized_expression_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_member_access_binding (ValaCodeGenerator* self, ValaMemberAccess* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_MEMBER_ACCESS (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_member_access_binding (ValaCodeGenerator* self, ValaMemberAccess* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_member_access_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_member_access_simple_binding (ValaCodeGenerator* self, ValaMemberAccess* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_MEMBER_ACCESS (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_member_access_simple_binding (ValaCodeGenerator* self, ValaMemberAccess* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_member_access_simple_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_invocation_expression_binding (ValaCodeGenerator* self, ValaInvocationExpression* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_INVOCATION_EXPRESSION (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_invocation_expression_binding (ValaCodeGenerator* self, ValaInvocationExpression* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_invocation_expression_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_element_access_binding (ValaCodeGenerator* self, ValaElementAccess* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_ELEMENT_ACCESS (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_element_access_binding (ValaCodeGenerator* self, ValaElementAccess* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_element_access_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_base_access_binding (ValaCodeGenerator* self, ValaBaseAccess* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_BASE_ACCESS (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_base_access_binding (ValaCodeGenerator* self, ValaBaseAccess* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_base_access_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_postfix_expression_binding (ValaCodeGenerator* self, ValaPostfixExpression* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_POSTFIX_EXPRESSION (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_postfix_expression_binding (ValaCodeGenerator* self, ValaPostfixExpression* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_postfix_expression_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_object_creation_expression_binding (ValaCodeGenerator* self, ValaObjectCreationExpression* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_OBJECT_CREATION_EXPRESSION (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_object_creation_expression_binding (ValaCodeGenerator* self, ValaObjectCreationExpression* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_object_creation_expression_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_sizeof_expression_binding (ValaCodeGenerator* self, ValaSizeofExpression* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SIZEOF_EXPRESSION (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_sizeof_expression_binding (ValaCodeGenerator* self, ValaSizeofExpression* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_sizeof_expression_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_typeof_expression_binding (ValaCodeGenerator* self, ValaTypeofExpression* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPEOF_EXPRESSION (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_typeof_expression_binding (ValaCodeGenerator* self, ValaTypeofExpression* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_typeof_expression_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_unary_expression_binding (ValaCodeGenerator* self, ValaUnaryExpression* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_UNARY_EXPRESSION (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_unary_expression_binding (ValaCodeGenerator* self, ValaUnaryExpression* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_unary_expression_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_cast_expression_binding (ValaCodeGenerator* self, ValaCastExpression* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CAST_EXPRESSION (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_cast_expression_binding (ValaCodeGenerator* self, ValaCastExpression* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_cast_expression_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_pointer_indirection_binding (ValaCodeGenerator* self, ValaPointerIndirection* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_POINTER_INDIRECTION (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_pointer_indirection_binding (ValaCodeGenerator* self, ValaPointerIndirection* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_pointer_indirection_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_addressof_expression_binding (ValaCodeGenerator* self, ValaAddressofExpression* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_ADDRESSOF_EXPRESSION (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_addressof_expression_binding (ValaCodeGenerator* self, ValaAddressofExpression* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_addressof_expression_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_reference_transfer_expression_binding (ValaCodeGenerator* self, ValaReferenceTransferExpression* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_REFERENCE_TRANSFER_EXPRESSION (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_reference_transfer_expression_binding (ValaCodeGenerator* self, ValaReferenceTransferExpression* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_reference_transfer_expression_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_binary_expression_binding (ValaCodeGenerator* self, ValaBinaryExpression* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_BINARY_EXPRESSION (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_binary_expression_binding (ValaCodeGenerator* self, ValaBinaryExpression* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_binary_expression_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_type_check_binding (ValaCodeGenerator* self, ValaTypeCheck* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_CHECK (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_type_check_binding (ValaCodeGenerator* self, ValaTypeCheck* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_type_check_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_conditional_expression_binding (ValaCodeGenerator* self, ValaConditionalExpression* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CONDITIONAL_EXPRESSION (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_conditional_expression_binding (ValaCodeGenerator* self, ValaConditionalExpression* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_conditional_expression_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_lambda_expression_binding (ValaCodeGenerator* self, ValaLambdaExpression* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_LAMBDA_EXPRESSION (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_lambda_expression_binding (ValaCodeGenerator* self, ValaLambdaExpression* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_lambda_expression_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_lambda_expression_with_statement_body_binding (ValaCodeGenerator* self, ValaLambdaExpression* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_LAMBDA_EXPRESSION (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_lambda_expression_with_statement_body_binding (ValaCodeGenerator* self, ValaLambdaExpression* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_lambda_expression_with_statement_body_binding (self, node);
}


static ValaCodeBinding* vala_code_generator_real_create_assignment_binding (ValaCodeGenerator* self, ValaAssignment* node) {
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_ASSIGNMENT (node), NULL);
	return NULL;
}


ValaCodeBinding* vala_code_generator_create_assignment_binding (ValaCodeGenerator* self, ValaAssignment* node) {
	return VALA_CODE_GENERATOR_GET_CLASS (self)->create_assignment_binding (self, node);
}


/**
 * Abstract code visitor generating code.
 */
ValaCodeGenerator* vala_code_generator_new (void) {
	ValaCodeGenerator * self;
	self = g_object_newv (VALA_TYPE_CODE_GENERATOR, 0, NULL);
	return self;
}


static void vala_code_generator_class_init (ValaCodeGeneratorClass * klass) {
	vala_code_generator_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_GENERATOR_CLASS (klass)->emit = vala_code_generator_real_emit;
	VALA_CODE_GENERATOR_CLASS (klass)->create_namespace_binding = vala_code_generator_real_create_namespace_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_class_binding = vala_code_generator_real_create_class_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_struct_binding = vala_code_generator_real_create_struct_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_interface_binding = vala_code_generator_real_create_interface_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_enum_binding = vala_code_generator_real_create_enum_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_enum_value_binding = vala_code_generator_real_create_enum_value_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_callback_binding = vala_code_generator_real_create_callback_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_constant_binding = vala_code_generator_real_create_constant_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_field_binding = vala_code_generator_real_create_field_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_method_binding = vala_code_generator_real_create_method_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_creation_method_binding = vala_code_generator_real_create_creation_method_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_formal_parameter_binding = vala_code_generator_real_create_formal_parameter_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_property_binding = vala_code_generator_real_create_property_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_property_accessor_binding = vala_code_generator_real_create_property_accessor_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_signal_binding = vala_code_generator_real_create_signal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_constructor_binding = vala_code_generator_real_create_constructor_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_destructor_binding = vala_code_generator_real_create_destructor_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_type_parameter_binding = vala_code_generator_real_create_type_parameter_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_block_binding = vala_code_generator_real_create_block_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_empty_statement_binding = vala_code_generator_real_create_empty_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_declaration_statement_binding = vala_code_generator_real_create_declaration_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_local_variable_declaration_binding = vala_code_generator_real_create_local_variable_declaration_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_variable_declarator_binding = vala_code_generator_real_create_variable_declarator_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_initializer_list_binding = vala_code_generator_real_create_initializer_list_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_expression_statement_binding = vala_code_generator_real_create_expression_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_if_statement_binding = vala_code_generator_real_create_if_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_switch_statement_binding = vala_code_generator_real_create_switch_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_switch_section_binding = vala_code_generator_real_create_switch_section_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_switch_label_binding = vala_code_generator_real_create_switch_label_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_while_statement_binding = vala_code_generator_real_create_while_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_do_statement_binding = vala_code_generator_real_create_do_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_for_statement_binding = vala_code_generator_real_create_for_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_foreach_statement_binding = vala_code_generator_real_create_foreach_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_break_statement_binding = vala_code_generator_real_create_break_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_continue_statement_binding = vala_code_generator_real_create_continue_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_return_statement_binding = vala_code_generator_real_create_return_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_throw_statement_binding = vala_code_generator_real_create_throw_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_try_statement_binding = vala_code_generator_real_create_try_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_catch_clause_binding = vala_code_generator_real_create_catch_clause_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_lock_statement_binding = vala_code_generator_real_create_lock_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_array_creation_expression_binding = vala_code_generator_real_create_array_creation_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_boolean_literal_binding = vala_code_generator_real_create_boolean_literal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_character_literal_binding = vala_code_generator_real_create_character_literal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_integer_literal_binding = vala_code_generator_real_create_integer_literal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_real_literal_binding = vala_code_generator_real_create_real_literal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_string_literal_binding = vala_code_generator_real_create_string_literal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_null_literal_binding = vala_code_generator_real_create_null_literal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_literal_expression_binding = vala_code_generator_real_create_literal_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_parenthesized_expression_binding = vala_code_generator_real_create_parenthesized_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_member_access_binding = vala_code_generator_real_create_member_access_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_member_access_simple_binding = vala_code_generator_real_create_member_access_simple_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_invocation_expression_binding = vala_code_generator_real_create_invocation_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_element_access_binding = vala_code_generator_real_create_element_access_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_base_access_binding = vala_code_generator_real_create_base_access_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_postfix_expression_binding = vala_code_generator_real_create_postfix_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_object_creation_expression_binding = vala_code_generator_real_create_object_creation_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_sizeof_expression_binding = vala_code_generator_real_create_sizeof_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_typeof_expression_binding = vala_code_generator_real_create_typeof_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_unary_expression_binding = vala_code_generator_real_create_unary_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_cast_expression_binding = vala_code_generator_real_create_cast_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_pointer_indirection_binding = vala_code_generator_real_create_pointer_indirection_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_addressof_expression_binding = vala_code_generator_real_create_addressof_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_reference_transfer_expression_binding = vala_code_generator_real_create_reference_transfer_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_binary_expression_binding = vala_code_generator_real_create_binary_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_type_check_binding = vala_code_generator_real_create_type_check_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_conditional_expression_binding = vala_code_generator_real_create_conditional_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_lambda_expression_binding = vala_code_generator_real_create_lambda_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_lambda_expression_with_statement_body_binding = vala_code_generator_real_create_lambda_expression_with_statement_body_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_assignment_binding = vala_code_generator_real_create_assignment_binding;
}


static void vala_code_generator_init (ValaCodeGenerator * self) {
}


GType vala_code_generator_get_type (void) {
	static GType vala_code_generator_type_id = 0;
	if (G_UNLIKELY (vala_code_generator_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCodeGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeGenerator), 0, (GInstanceInitFunc) vala_code_generator_init };
		vala_code_generator_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaCodeGenerator", &g_define_type_info, 0);
	}
	return vala_code_generator_type_id;
}




