/* valacodecontext.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALACODECONTEXT_H__
#define __VALA_VALACODECONTEXT_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/collection.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valaunaryexpression.h>
#include <vala/valabinaryexpression.h>
#include <vala/valaassignment.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContextPrivate ValaCodeContextPrivate;

/**
 * The root of the code tree.
 */
struct _ValaCodeContext {
	GObject parent;
	ValaCodeContextPrivate * priv;
};
struct _ValaCodeContextClass {
	GObjectClass parent;
};

ValaCodeContext* vala_code_context_new (void);
GeeCollection* vala_code_context_get_source_files (ValaCodeContext* self);
GeeCollection* vala_code_context_get_c_source_files (ValaCodeContext* self);
void vala_code_context_add_source_file (ValaCodeContext* self, ValaSourceFile* file);
void vala_code_context_add_c_source_file (ValaCodeContext* self, const char* file);
GeeCollection* vala_code_context_get_packages (ValaCodeContext* self);
gboolean vala_code_context_has_package (ValaCodeContext* self, const char* pkg);
void vala_code_context_add_package (ValaCodeContext* self, const char* pkg);
void vala_code_context_accept (ValaCodeContext* self, ValaCodeVisitor* visitor);
void vala_code_context_find_header_cycles (ValaCodeContext* self);
ValaNamespace* vala_code_context_create_namespace (ValaCodeContext* self, const char* name, ValaSourceReference* source_reference);
ValaClass* vala_code_context_create_class (ValaCodeContext* self, const char* name, ValaSourceReference* source_reference);
ValaStruct* vala_code_context_create_struct (ValaCodeContext* self, const char* name, ValaSourceReference* source_reference);
ValaInterface* vala_code_context_create_interface (ValaCodeContext* self, const char* name, ValaSourceReference* source_reference);
ValaEnum* vala_code_context_create_enum (ValaCodeContext* self, const char* name, ValaSourceReference* source_reference);
ValaEnumValue* vala_code_context_create_enum_value (ValaCodeContext* self, const char* name);
ValaEnumValue* vala_code_context_create_enum_value_with_value (ValaCodeContext* self, const char* name, ValaExpression* value);
ValaCallback* vala_code_context_create_callback (ValaCodeContext* self, const char* name, ValaTypeReference* return_type, ValaSourceReference* source_reference);
ValaConstant* vala_code_context_create_constant (ValaCodeContext* self, const char* name, ValaTypeReference* type_reference, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaField* vala_code_context_create_field (ValaCodeContext* self, const char* name, ValaTypeReference* type_reference, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaMethod* vala_code_context_create_method (ValaCodeContext* self, const char* name, ValaTypeReference* return_type, ValaSourceReference* source_reference);
ValaCreationMethod* vala_code_context_create_creation_method (ValaCodeContext* self, const char* name, ValaSourceReference* source_reference);
ValaFormalParameter* vala_code_context_create_formal_parameter (ValaCodeContext* self, const char* name, ValaTypeReference* type_reference, ValaSourceReference* source_reference);
ValaFormalParameter* vala_code_context_create_formal_parameter_with_ellipsis (ValaCodeContext* self, ValaSourceReference* source_reference);
ValaProperty* vala_code_context_create_property (ValaCodeContext* self, const char* name, ValaTypeReference* type_reference, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference);
ValaPropertyAccessor* vala_code_context_create_property_accessor (ValaCodeContext* self, gboolean readable, gboolean writable, gboolean construction, ValaBlock* body, ValaSourceReference* source_reference);
ValaSignal* vala_code_context_create_signal (ValaCodeContext* self, const char* name, ValaTypeReference* return_type, ValaSourceReference* source_reference);
ValaConstructor* vala_code_context_create_constructor (ValaCodeContext* self, ValaSourceReference* source_reference);
ValaDestructor* vala_code_context_create_destructor (ValaCodeContext* self, ValaSourceReference* source_reference);
ValaTypeParameter* vala_code_context_create_type_parameter (ValaCodeContext* self, const char* name, ValaSourceReference* source_reference);
ValaBlock* vala_code_context_create_block (ValaCodeContext* self, ValaSourceReference* source_reference);
ValaEmptyStatement* vala_code_context_create_empty_statement (ValaCodeContext* self, ValaSourceReference* source_reference);
ValaDeclarationStatement* vala_code_context_create_declaration_statement (ValaCodeContext* self, ValaLocalVariableDeclaration* declaration, ValaSourceReference* source_reference);
ValaLocalVariableDeclaration* vala_code_context_create_local_variable_declaration (ValaCodeContext* self, ValaTypeReference* type_reference, ValaSourceReference* source_reference);
ValaLocalVariableDeclaration* vala_code_context_create_local_variable_declaration_var_type (ValaCodeContext* self, ValaSourceReference* source_reference);
ValaVariableDeclarator* vala_code_context_create_variable_declarator (ValaCodeContext* self, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaInitializerList* vala_code_context_create_initializer_list (ValaCodeContext* self, ValaSourceReference* source_reference);
ValaExpressionStatement* vala_code_context_create_expression_statement (ValaCodeContext* self, ValaExpression* expression, ValaSourceReference* source_reference);
ValaIfStatement* vala_code_context_create_if_statement (ValaCodeContext* self, ValaExpression* condition, ValaBlock* true_statement, ValaBlock* false_statement, ValaSourceReference* source_reference);
ValaSwitchStatement* vala_code_context_create_switch_statement (ValaCodeContext* self, ValaExpression* expression, ValaSourceReference* source_reference);
ValaSwitchSection* vala_code_context_create_switch_section (ValaCodeContext* self, ValaSourceReference* source_reference);
ValaSwitchLabel* vala_code_context_create_switch_label (ValaCodeContext* self, ValaExpression* expression, ValaSourceReference* source_reference);
ValaSwitchLabel* vala_code_context_create_switch_label_with_default (ValaCodeContext* self, ValaSourceReference* source_reference);
ValaWhileStatement* vala_code_context_create_while_statement (ValaCodeContext* self, ValaExpression* condition, ValaBlock* body, ValaSourceReference* source_reference);
ValaDoStatement* vala_code_context_create_do_statement (ValaCodeContext* self, ValaBlock* body, ValaExpression* condition, ValaSourceReference* source_reference);
ValaForStatement* vala_code_context_create_for_statement (ValaCodeContext* self, ValaExpression* condition, ValaBlock* body, ValaSourceReference* source_reference);
ValaForeachStatement* vala_code_context_create_foreach_statement (ValaCodeContext* self, ValaTypeReference* type_reference, const char* variable_name, ValaExpression* collection, ValaBlock* body, ValaSourceReference* source_reference);
ValaBreakStatement* vala_code_context_create_break_statement (ValaCodeContext* self, ValaSourceReference* source_reference);
ValaContinueStatement* vala_code_context_create_continue_statement (ValaCodeContext* self, ValaSourceReference* source_reference);
ValaReturnStatement* vala_code_context_create_return_statement (ValaCodeContext* self, ValaExpression* return_expression, ValaSourceReference* source_reference);
ValaThrowStatement* vala_code_context_create_throw_statement (ValaCodeContext* self, ValaExpression* error_expression, ValaSourceReference* source_reference);
ValaTryStatement* vala_code_context_create_try_statement (ValaCodeContext* self, ValaBlock* body, ValaBlock* finally_body, ValaSourceReference* source_reference);
ValaCatchClause* vala_code_context_create_catch_clause (ValaCodeContext* self, ValaTypeReference* type_reference, const char* variable_name, ValaBlock* body, ValaSourceReference* source_reference);
ValaLockStatement* vala_code_context_create_lock_statement (ValaCodeContext* self, ValaExpression* resource, ValaBlock* body, ValaSourceReference* source_reference);
ValaArrayCreationExpression* vala_code_context_create_array_creation_expression (ValaCodeContext* self, ValaTypeReference* element_type, gint rank, ValaInitializerList* initializer_list, ValaSourceReference* source_reference);
ValaBooleanLiteral* vala_code_context_create_boolean_literal (ValaCodeContext* self, gboolean value, ValaSourceReference* source_reference);
ValaCharacterLiteral* vala_code_context_create_character_literal (ValaCodeContext* self, const char* value, ValaSourceReference* source_reference);
ValaIntegerLiteral* vala_code_context_create_integer_literal (ValaCodeContext* self, const char* value, ValaSourceReference* source_reference);
ValaRealLiteral* vala_code_context_create_real_literal (ValaCodeContext* self, const char* value, ValaSourceReference* source_reference);
ValaStringLiteral* vala_code_context_create_string_literal (ValaCodeContext* self, const char* value, ValaSourceReference* source_reference);
ValaNullLiteral* vala_code_context_create_null_literal (ValaCodeContext* self, ValaSourceReference* source_reference);
ValaLiteralExpression* vala_code_context_create_literal_expression (ValaCodeContext* self, ValaLiteral* literal, ValaSourceReference* source_reference);
ValaParenthesizedExpression* vala_code_context_create_parenthesized_expression (ValaCodeContext* self, ValaExpression* inner, ValaSourceReference* source_reference);
ValaMemberAccess* vala_code_context_create_member_access (ValaCodeContext* self, ValaExpression* inner, const char* member_name, ValaSourceReference* source_reference);
ValaMemberAccess* vala_code_context_create_member_access_simple (ValaCodeContext* self, const char* member_name, ValaSourceReference* source_reference);
ValaInvocationExpression* vala_code_context_create_invocation_expression (ValaCodeContext* self, ValaExpression* call, ValaSourceReference* source_reference);
ValaElementAccess* vala_code_context_create_element_access (ValaCodeContext* self, ValaExpression* container, ValaSourceReference* source_reference);
ValaBaseAccess* vala_code_context_create_base_access (ValaCodeContext* self, ValaSourceReference* source_reference);
ValaPostfixExpression* vala_code_context_create_postfix_expression (ValaCodeContext* self, ValaExpression* inner, gboolean increment, ValaSourceReference* source_reference);
ValaObjectCreationExpression* vala_code_context_create_object_creation_expression (ValaCodeContext* self, ValaMemberAccess* member_name, ValaSourceReference* source_reference);
ValaSizeofExpression* vala_code_context_create_sizeof_expression (ValaCodeContext* self, ValaTypeReference* type_reference, ValaSourceReference* source_reference);
ValaTypeofExpression* vala_code_context_create_typeof_expression (ValaCodeContext* self, ValaTypeReference* type_reference, ValaSourceReference* source_reference);
ValaUnaryExpression* vala_code_context_create_unary_expression (ValaCodeContext* self, ValaUnaryOperator operator, ValaExpression* inner, ValaSourceReference* source_reference);
ValaCastExpression* vala_code_context_create_cast_expression (ValaCodeContext* self, ValaExpression* inner, ValaTypeReference* type_reference, ValaSourceReference* source_reference, gboolean is_silent_cast);
ValaPointerIndirection* vala_code_context_create_pointer_indirection (ValaCodeContext* self, ValaExpression* inner, ValaSourceReference* source_reference);
ValaAddressofExpression* vala_code_context_create_addressof_expression (ValaCodeContext* self, ValaExpression* inner, ValaSourceReference* source_reference);
ValaReferenceTransferExpression* vala_code_context_create_reference_transfer_expression (ValaCodeContext* self, ValaExpression* inner, ValaSourceReference* source_reference);
ValaBinaryExpression* vala_code_context_create_binary_expression (ValaCodeContext* self, ValaBinaryOperator operator, ValaExpression* left, ValaExpression* right, ValaSourceReference* source_reference);
ValaTypeCheck* vala_code_context_create_type_check (ValaCodeContext* self, ValaExpression* expression, ValaTypeReference* type_reference, ValaSourceReference* source_reference);
ValaConditionalExpression* vala_code_context_create_conditional_expression (ValaCodeContext* self, ValaExpression* condition, ValaExpression* true_expression, ValaExpression* false_expression, ValaSourceReference* source_reference);
ValaLambdaExpression* vala_code_context_create_lambda_expression (ValaCodeContext* self, ValaExpression* expression_body, ValaSourceReference* source_reference);
ValaLambdaExpression* vala_code_context_create_lambda_expression_with_statement_body (ValaCodeContext* self, ValaBlock* statement_body, ValaSourceReference* source_reference);
ValaAssignment* vala_code_context_create_assignment (ValaCodeContext* self, ValaExpression* left, ValaExpression* right, ValaAssignmentOperator operator, ValaSourceReference* source_reference);
char* vala_code_context_get_library (ValaCodeContext* self);
void vala_code_context_set_library (ValaCodeContext* self, const char* value);
gboolean vala_code_context_get_memory_management (ValaCodeContext* self);
void vala_code_context_set_memory_management (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_assert (ValaCodeContext* self);
void vala_code_context_set_assert (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_checking (ValaCodeContext* self);
void vala_code_context_set_checking (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_ccode_only (ValaCodeContext* self);
void vala_code_context_set_ccode_only (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_compile_only (ValaCodeContext* self);
void vala_code_context_set_compile_only (ValaCodeContext* self, gboolean value);
char* vala_code_context_get_output (ValaCodeContext* self);
void vala_code_context_set_output (ValaCodeContext* self, const char* value);
char* vala_code_context_get_basedir (ValaCodeContext* self);
void vala_code_context_set_basedir (ValaCodeContext* self, const char* value);
char* vala_code_context_get_directory (ValaCodeContext* self);
void vala_code_context_set_directory (ValaCodeContext* self, const char* value);
gboolean vala_code_context_get_debug (ValaCodeContext* self);
void vala_code_context_set_debug (ValaCodeContext* self, gboolean value);
gint vala_code_context_get_optlevel (ValaCodeContext* self);
void vala_code_context_set_optlevel (ValaCodeContext* self, gint value);
gboolean vala_code_context_get_thread (ValaCodeContext* self);
void vala_code_context_set_thread (ValaCodeContext* self, gboolean value);
ValaMethod* vala_code_context_get_module_init_method (ValaCodeContext* self);
void vala_code_context_set_module_init_method (ValaCodeContext* self, ValaMethod* value);
gboolean vala_code_context_get_save_temps (ValaCodeContext* self);
void vala_code_context_set_save_temps (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_save_csources (ValaCodeContext* self);
gboolean vala_code_context_get_save_cheaders (ValaCodeContext* self);
ValaNamespace* vala_code_context_get_root (ValaCodeContext* self);
ValaCodeGenerator* vala_code_context_get_codegen (ValaCodeContext* self);
void vala_code_context_set_codegen (ValaCodeContext* self, ValaCodeGenerator* value);
GType vala_code_context_get_type (void);

G_END_DECLS

#endif
