/* valaccodeformalparameter.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeformalparameter.h>

struct _ValaCCodeFormalParameterPrivate {
	char* _name;
	char* _type_name;
};
#define VALA_CCODE_FORMAL_PARAMETER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_FORMAL_PARAMETER, ValaCCodeFormalParameterPrivate))
enum  {
	VALA_CCODE_FORMAL_PARAMETER_DUMMY_PROPERTY,
	VALA_CCODE_FORMAL_PARAMETER_NAME,
	VALA_CCODE_FORMAL_PARAMETER_TYPE_NAME
};
static void vala_ccode_formal_parameter_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_formal_parameter_parent_class = NULL;
static void vala_ccode_formal_parameter_dispose (GObject * obj);


ValaCCodeFormalParameter* vala_ccode_formal_parameter_new (const char* n, const char* type) {
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeFormalParameter * self;
	g_return_val_if_fail (n != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, n), __params_it++);
	(__params_it->name = "type-name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, type), __params_it++);
	self = g_object_newv (VALA_TYPE_CCODE_FORMAL_PARAMETER, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_ccode_formal_parameter_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeFormalParameter * self;
	self = VALA_CCODE_FORMAL_PARAMETER (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_string (writer, vala_ccode_formal_parameter_get_type_name (self));
	vala_ccode_writer_write_string (writer, " ");
	vala_ccode_writer_write_string (writer, vala_ccode_formal_parameter_get_name (self));
}


char* vala_ccode_formal_parameter_get_name (ValaCCodeFormalParameter* self) {
	g_return_val_if_fail (VALA_IS_CCODE_FORMAL_PARAMETER (self), NULL);
	return self->priv->_name;
}


void vala_ccode_formal_parameter_set_name (ValaCCodeFormalParameter* self, const char* value) {
	char* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_FORMAL_PARAMETER (self));
	_tmp1 = NULL;
	self->priv->_name = (_tmp1 = g_strdup (value), (self->priv->_name = (g_free (self->priv->_name), NULL)), _tmp1);
}


char* vala_ccode_formal_parameter_get_type_name (ValaCCodeFormalParameter* self) {
	g_return_val_if_fail (VALA_IS_CCODE_FORMAL_PARAMETER (self), NULL);
	return self->priv->_type_name;
}


void vala_ccode_formal_parameter_set_type_name (ValaCCodeFormalParameter* self, const char* value) {
	char* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_FORMAL_PARAMETER (self));
	_tmp1 = NULL;
	self->priv->_type_name = (_tmp1 = g_strdup (value), (self->priv->_type_name = (g_free (self->priv->_type_name), NULL)), _tmp1);
}


static void vala_ccode_formal_parameter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeFormalParameter * self;
	self = VALA_CCODE_FORMAL_PARAMETER (object);
	switch (property_id) {
		case VALA_CCODE_FORMAL_PARAMETER_NAME:
		g_value_set_string (value, vala_ccode_formal_parameter_get_name (self));
		break;
		case VALA_CCODE_FORMAL_PARAMETER_TYPE_NAME:
		g_value_set_string (value, vala_ccode_formal_parameter_get_type_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_formal_parameter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeFormalParameter * self;
	self = VALA_CCODE_FORMAL_PARAMETER (object);
	switch (property_id) {
		case VALA_CCODE_FORMAL_PARAMETER_NAME:
		vala_ccode_formal_parameter_set_name (self, g_value_get_string (value));
		break;
		case VALA_CCODE_FORMAL_PARAMETER_TYPE_NAME:
		vala_ccode_formal_parameter_set_type_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_formal_parameter_class_init (ValaCCodeFormalParameterClass * klass) {
	vala_ccode_formal_parameter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeFormalParameterPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_formal_parameter_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_formal_parameter_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_formal_parameter_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_formal_parameter_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_FORMAL_PARAMETER_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_FORMAL_PARAMETER_TYPE_NAME, g_param_spec_string ("type-name", "type-name", "type-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_ccode_formal_parameter_init (ValaCCodeFormalParameter * self) {
	self->priv = VALA_CCODE_FORMAL_PARAMETER_GET_PRIVATE (self);
}


static void vala_ccode_formal_parameter_dispose (GObject * obj) {
	ValaCCodeFormalParameter * self;
	self = VALA_CCODE_FORMAL_PARAMETER (obj);
	(self->priv->_name = (g_free (self->priv->_name), NULL));
	(self->priv->_type_name = (g_free (self->priv->_type_name), NULL));
	G_OBJECT_CLASS (vala_ccode_formal_parameter_parent_class)->dispose (obj);
}


GType vala_ccode_formal_parameter_get_type (void) {
	static GType vala_ccode_formal_parameter_type_id = 0;
	if (G_UNLIKELY (vala_ccode_formal_parameter_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeFormalParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_formal_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeFormalParameter), 0, (GInstanceInitFunc) vala_ccode_formal_parameter_init };
		vala_ccode_formal_parameter_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeFormalParameter", &g_define_type_info, 0);
	}
	return vala_ccode_formal_parameter_type_id;
}




