/* valatrystatement.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALATRYSTATEMENT_H__
#define __VALATRYSTATEMENT_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/collection.h>
#include <vala/valacodenode.h>
#include <vala/valastatement.h>

G_BEGIN_DECLS


#define VALA_TYPE_TRY_STATEMENT (vala_try_statement_get_type ())
#define VALA_TRY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TRY_STATEMENT, ValaTryStatement))
#define VALA_TRY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TRY_STATEMENT, ValaTryStatementClass))
#define VALA_IS_TRY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TRY_STATEMENT))
#define VALA_IS_TRY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TRY_STATEMENT))
#define VALA_TRY_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TRY_STATEMENT, ValaTryStatementClass))

typedef struct _ValaTryStatementPrivate ValaTryStatementPrivate;

/**
 * Represents a try statement in the source code.
 */
struct _ValaTryStatement {
	ValaCodeNode parent;
	ValaTryStatementPrivate * priv;
};
struct _ValaTryStatementClass {
	ValaCodeNodeClass parent;
};

ValaTryStatement* vala_try_statement_new (ValaBlock* body, ValaBlock* finally_body, ValaSourceReference* source_reference);
void vala_try_statement_add_catch_clause (ValaTryStatement* self, ValaCatchClause* clause);
GeeCollection* vala_try_statement_get_catch_clauses (ValaTryStatement* self);
ValaBlock* vala_try_statement_get_body (ValaTryStatement* self);
void vala_try_statement_set_body (ValaTryStatement* self, ValaBlock* value);
ValaBlock* vala_try_statement_get_finally_body (ValaTryStatement* self);
void vala_try_statement_set_finally_body (ValaTryStatement* self, ValaBlock* value);
GType vala_try_statement_get_type (void);

G_END_DECLS

#endif
