/* valasymbolresolver.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valasymbolresolver.h"
#include <gee/collection.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasymbol.h>
#include <vala/valascope.h>
#include <vala/valasymbolresolver.h>
#include <vala/valareport.h>
#include <vala/valacodenode.h>
#include <vala/valasourcereference.h>
#include <vala/valadatatype.h>
#include <vala/valatypeparameter.h>

struct _ValaSymbolResolverPrivate {
	ValaSymbol* root_symbol;
	ValaScope* current_scope;
	GeeCollection* current_using_directives;
};
#define VALA_SYMBOL_RESOLVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SYMBOL_RESOLVER, ValaSymbolResolverPrivate))
enum  {
	VALA_SYMBOL_RESOLVER_DUMMY_PROPERTY
};
static void vala_symbol_resolver_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* file);
static void vala_symbol_resolver_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_symbol_resolver_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_symbol_resolver_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_symbol_resolver_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_symbol_resolver_real_visit_callback (ValaCodeVisitor* base, ValaCallback* cb);
static void vala_symbol_resolver_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_symbol_resolver_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_symbol_resolver_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static void vala_symbol_resolver_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void vala_symbol_resolver_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p);
static void vala_symbol_resolver_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_symbol_resolver_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static void vala_symbol_resolver_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static void vala_symbol_resolver_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c);
static void vala_symbol_resolver_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d);
static void vala_symbol_resolver_real_visit_namespace_reference (ValaCodeVisitor* base, ValaNamespaceReference* ns);
static void vala_symbol_resolver_real_visit_type_reference (ValaCodeVisitor* base, ValaTypeReference* type);
static void vala_symbol_resolver_real_visit_variable_declarator (ValaCodeVisitor* base, ValaVariableDeclarator* decl);
static void vala_symbol_resolver_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list);
static void vala_symbol_resolver_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt);
static void vala_symbol_resolver_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt);
static void vala_symbol_resolver_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause);
static void vala_symbol_resolver_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* e);
static gpointer vala_symbol_resolver_parent_class = NULL;
static void vala_symbol_resolver_dispose (GObject * obj);


/**
 * Resolve symbol names in the specified code context.
 *
 * @param context a code context
 */
void vala_symbol_resolver_resolve (ValaSymbolResolver* self, ValaCodeContext* context)
{
	ValaSymbol* _tmp0;
	ValaScope* _tmp2;
	ValaScope* _tmp1;
	g_return_if_fail (VALA_IS_SYMBOL_RESOLVER (self));
	g_return_if_fail (VALA_IS_CODE_CONTEXT (context));
	_tmp0 = NULL;
	self->priv->root_symbol = (_tmp0 = VALA_SYMBOL (g_object_ref (vala_code_context_get_root (context))), (self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (g_object_unref (self->priv->root_symbol), NULL))), _tmp0);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->current_scope = (_tmp2 = (_tmp1 = vala_symbol_get_scope (self->priv->root_symbol), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), _tmp2);
	vala_code_context_accept (context, VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* file)
{
	ValaSymbolResolver * self;
	GeeCollection* _tmp0;
	ValaScope* _tmp2;
	ValaScope* _tmp1;
	GeeCollection* _tmp3;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_SOURCE_FILE (file));
	_tmp0 = NULL;
	self->priv->current_using_directives = (_tmp0 = vala_source_file_get_using_directives (file), (self->priv->current_using_directives == NULL ? NULL : (self->priv->current_using_directives = (g_object_unref (self->priv->current_using_directives), NULL))), _tmp0);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->current_scope = (_tmp2 = (_tmp1 = vala_symbol_get_scope (self->priv->root_symbol), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), _tmp2);
	vala_source_file_accept_children (file, VALA_CODE_VISITOR (self));
	_tmp3 = NULL;
	self->priv->current_using_directives = (_tmp3 = NULL, (self->priv->current_using_directives == NULL ? NULL : (self->priv->current_using_directives = (g_object_unref (self->priv->current_using_directives), NULL))), _tmp3);
}


static void vala_symbol_resolver_real_visit_class (ValaCodeVisitor* base, ValaClass* cl)
{
	ValaSymbolResolver * self;
	ValaScope* _tmp1;
	ValaScope* _tmp0;
	ValaScope* _tmp7;
	ValaScope* _tmp6;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->current_scope = (_tmp1 = (_tmp0 = vala_symbol_get_scope (((ValaSymbol*) cl)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), _tmp1);
	vala_code_node_accept_children (VALA_CODE_NODE (cl), VALA_CODE_VISITOR (self));
	{
		GeeCollection* type_collection;
		GeeIterator* type_it;
		type_collection = vala_class_get_base_types (cl);
		type_it = gee_iterable_iterator (GEE_ITERABLE (type_collection));
		while (gee_iterator_next (type_it)) {
			ValaTypeReference* type;
			type = gee_iterator_get (type_it);
			{
				if (VALA_IS_CLASS (vala_type_reference_get_data_type (type))) {
					if (vala_class_get_base_class (cl) != NULL) {
						char* _tmp5;
						char* _tmp4;
						char* _tmp3;
						char* _tmp2;
						_tmp5 = NULL;
						_tmp4 = NULL;
						_tmp3 = NULL;
						_tmp2 = NULL;
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) type)), (_tmp5 = g_strdup_printf ("%s: Classes cannot have multiple base classes (`%s' and `%s')", (_tmp2 = vala_symbol_get_full_name (VALA_SYMBOL (cl))), (_tmp3 = vala_symbol_get_full_name (VALA_SYMBOL (vala_class_get_base_class (cl)))), (_tmp4 = vala_symbol_get_full_name (VALA_SYMBOL (vala_type_reference_get_data_type (type)))))));
						(_tmp5 = (g_free (_tmp5), NULL));
						(_tmp4 = (g_free (_tmp4), NULL));
						(_tmp3 = (g_free (_tmp3), NULL));
						(_tmp2 = (g_free (_tmp2), NULL));
						(type == NULL ? NULL : (type = (g_object_unref (type), NULL)));
						(type_collection == NULL ? NULL : (type_collection = (g_object_unref (type_collection), NULL)));
						(type_it == NULL ? NULL : (type_it = (g_object_unref (type_it), NULL)));
						return;
					}
					vala_class_set_base_class (cl, VALA_CLASS (vala_type_reference_get_data_type (type)));
				}
				(type == NULL ? NULL : (type = (g_object_unref (type), NULL)));
			}
		}
		(type_collection == NULL ? NULL : (type_collection = (g_object_unref (type_collection), NULL)));
		(type_it == NULL ? NULL : (type_it = (g_object_unref (type_it), NULL)));
	}
	_tmp7 = NULL;
	_tmp6 = NULL;
	self->priv->current_scope = (_tmp7 = (_tmp6 = vala_scope_get_parent_scope (self->priv->current_scope), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), _tmp7);
}


static void vala_symbol_resolver_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st)
{
	ValaSymbolResolver * self;
	ValaScope* _tmp1;
	ValaScope* _tmp0;
	ValaScope* _tmp3;
	ValaScope* _tmp2;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_STRUCT (st));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->current_scope = (_tmp1 = (_tmp0 = vala_symbol_get_scope (((ValaSymbol*) st)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), _tmp1);
	vala_code_node_accept_children (VALA_CODE_NODE (st), VALA_CODE_VISITOR (self));
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->current_scope = (_tmp3 = (_tmp2 = vala_scope_get_parent_scope (self->priv->current_scope), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), _tmp3);
}


static void vala_symbol_resolver_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface)
{
	ValaSymbolResolver * self;
	ValaScope* _tmp1;
	ValaScope* _tmp0;
	ValaScope* _tmp3;
	ValaScope* _tmp2;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->current_scope = (_tmp1 = (_tmp0 = vala_symbol_get_scope (((ValaSymbol*) iface)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), _tmp1);
	vala_code_node_accept_children (VALA_CODE_NODE (iface), VALA_CODE_VISITOR (self));
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->current_scope = (_tmp3 = (_tmp2 = vala_scope_get_parent_scope (self->priv->current_scope), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), _tmp3);
}


static void vala_symbol_resolver_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en)
{
	ValaSymbolResolver * self;
	ValaScope* _tmp1;
	ValaScope* _tmp0;
	ValaScope* _tmp3;
	ValaScope* _tmp2;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_ENUM (en));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->current_scope = (_tmp1 = (_tmp0 = vala_symbol_get_scope (((ValaSymbol*) en)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), _tmp1);
	vala_code_node_accept_children (VALA_CODE_NODE (en), VALA_CODE_VISITOR (self));
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->current_scope = (_tmp3 = (_tmp2 = vala_scope_get_parent_scope (self->priv->current_scope), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), _tmp3);
}


static void vala_symbol_resolver_real_visit_callback (ValaCodeVisitor* base, ValaCallback* cb)
{
	ValaSymbolResolver * self;
	ValaScope* _tmp1;
	ValaScope* _tmp0;
	ValaScope* _tmp3;
	ValaScope* _tmp2;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_CALLBACK (cb));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->current_scope = (_tmp1 = (_tmp0 = vala_symbol_get_scope (((ValaSymbol*) cb)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), _tmp1);
	vala_code_node_accept_children (VALA_CODE_NODE (cb), VALA_CODE_VISITOR (self));
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->current_scope = (_tmp3 = (_tmp2 = vala_scope_get_parent_scope (self->priv->current_scope), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), _tmp3);
}


static void vala_symbol_resolver_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c)
{
	ValaSymbolResolver * self;
	ValaScope* _tmp1;
	ValaScope* _tmp0;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_CONSTANT (c));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->current_scope = (_tmp1 = (_tmp0 = vala_symbol_get_scope (((ValaSymbol*) c)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), _tmp1);
	vala_code_node_accept_children (VALA_CODE_NODE (c), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_field (ValaCodeVisitor* base, ValaField* f)
{
	ValaSymbolResolver * self;
	ValaScope* _tmp1;
	ValaScope* _tmp0;
	ValaScope* _tmp3;
	ValaScope* _tmp2;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_FIELD (f));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->current_scope = (_tmp1 = (_tmp0 = vala_symbol_get_scope (((ValaSymbol*) f)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), _tmp1);
	vala_code_node_accept_children (VALA_CODE_NODE (f), VALA_CODE_VISITOR (self));
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->current_scope = (_tmp3 = (_tmp2 = vala_scope_get_parent_scope (self->priv->current_scope), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), _tmp3);
}


static void vala_symbol_resolver_real_visit_method (ValaCodeVisitor* base, ValaMethod* m)
{
	ValaSymbolResolver * self;
	ValaScope* _tmp1;
	ValaScope* _tmp0;
	ValaScope* _tmp3;
	ValaScope* _tmp2;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_METHOD (m));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->current_scope = (_tmp1 = (_tmp0 = vala_symbol_get_scope (((ValaSymbol*) m)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), _tmp1);
	vala_code_node_accept_children (VALA_CODE_NODE (m), VALA_CODE_VISITOR (self));
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->current_scope = (_tmp3 = (_tmp2 = vala_scope_get_parent_scope (self->priv->current_scope), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), _tmp3);
}


static void vala_symbol_resolver_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_CREATION_METHOD (m));
	vala_code_node_accept_children (VALA_CODE_NODE (m), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_FORMAL_PARAMETER (p));
	vala_code_node_accept_children (VALA_CODE_NODE (p), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_PROPERTY (prop));
	vala_code_node_accept_children (VALA_CODE_NODE (prop), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_PROPERTY_ACCESSOR (acc));
	vala_code_node_accept_children (VALA_CODE_NODE (acc), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_SIGNAL (sig));
	vala_code_node_accept_children (VALA_CODE_NODE (sig), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_CONSTRUCTOR (c));
	vala_code_node_accept_children (VALA_CODE_NODE (c), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_DESTRUCTOR (d));
	vala_code_node_accept_children (VALA_CODE_NODE (d), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_namespace_reference (ValaCodeVisitor* base, ValaNamespaceReference* ns)
{
	ValaSymbolResolver * self;
	ValaSymbol* _tmp0;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_NAMESPACE_REFERENCE (ns));
	_tmp0 = NULL;
	vala_namespace_reference_set_namespace_symbol (ns, (_tmp0 = vala_scope_lookup (self->priv->current_scope, vala_namespace_reference_get_name (ns))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	if (vala_namespace_reference_get_namespace_symbol (ns) == NULL) {
		char* _tmp1;
		vala_code_node_set_error (VALA_CODE_NODE (ns), TRUE);
		_tmp1 = NULL;
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) ns)), (_tmp1 = g_strdup_printf ("The namespace name `%s' could not be found", vala_namespace_reference_get_name (ns))));
		(_tmp1 = (g_free (_tmp1), NULL));
		return;
	}
}


static void vala_symbol_resolver_real_visit_type_reference (ValaCodeVisitor* base, ValaTypeReference* type)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (type));
	if (vala_type_reference_get_type_name (type) == NULL || g_utf8_collate (vala_type_reference_get_type_name (type), "void") == 0) {
		/* reset transfers_ownership*/
		vala_type_reference_set_transfers_ownership (type, FALSE);
		return;
	}
	if (vala_type_reference_get_namespace_name (type) == NULL) {
		ValaSymbol* sym;
		ValaScope* _tmp0;
		ValaScope* scope;
		sym = NULL;
		_tmp0 = NULL;
		scope = (_tmp0 = self->priv->current_scope, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		while (sym == NULL && scope != NULL) {
			ValaSymbol* _tmp1;
			ValaScope* _tmp3;
			ValaScope* _tmp2;
			_tmp1 = NULL;
			sym = (_tmp1 = vala_scope_lookup (scope, vala_type_reference_get_type_name (type)), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), _tmp1);
			_tmp3 = NULL;
			_tmp2 = NULL;
			scope = (_tmp3 = (_tmp2 = vala_scope_get_parent_scope (scope), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))), (scope == NULL ? NULL : (scope = (g_object_unref (scope), NULL))), _tmp3);
			if (sym != NULL && !(VALA_IS_DATA_TYPE (sym)) && !(VALA_IS_TYPE_PARAMETER (sym))) {
				ValaSymbol* _tmp4;
				/* ignore non-type symbols*/
				_tmp4 = NULL;
				sym = (_tmp4 = NULL, (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), _tmp4);
			}
		}
		if (sym == NULL) {
			{
				GeeCollection* ns_collection;
				GeeIterator* ns_it;
				ns_collection = self->priv->current_using_directives;
				ns_it = gee_iterable_iterator (GEE_ITERABLE (ns_collection));
				while (gee_iterator_next (ns_it)) {
					ValaNamespaceReference* ns;
					ns = gee_iterator_get (ns_it);
					{
						ValaSymbol* local_sym;
						if (vala_code_node_get_error (((ValaCodeNode*) ns))) {
							(ns == NULL ? NULL : (ns = (g_object_unref (ns), NULL)));
							continue;
						}
						local_sym = vala_scope_lookup (vala_symbol_get_scope (vala_namespace_reference_get_namespace_symbol (ns)), vala_type_reference_get_type_name (type));
						if (local_sym != NULL) {
							ValaSymbol* _tmp9;
							ValaSymbol* _tmp8;
							if (sym != NULL) {
								char* _tmp7;
								char* _tmp6;
								char* _tmp5;
								_tmp7 = NULL;
								_tmp6 = NULL;
								_tmp5 = NULL;
								vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) type)), (_tmp7 = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", vala_type_reference_get_type_name (type), (_tmp5 = vala_symbol_get_full_name (sym)), (_tmp6 = vala_symbol_get_full_name (local_sym)))));
								(_tmp7 = (g_free (_tmp7), NULL));
								(_tmp6 = (g_free (_tmp6), NULL));
								(_tmp5 = (g_free (_tmp5), NULL));
								(ns == NULL ? NULL : (ns = (g_object_unref (ns), NULL)));
								(local_sym == NULL ? NULL : (local_sym = (g_object_unref (local_sym), NULL)));
								(ns_it == NULL ? NULL : (ns_it = (g_object_unref (ns_it), NULL)));
								(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
								(scope == NULL ? NULL : (scope = (g_object_unref (scope), NULL)));
								return;
							}
							_tmp9 = NULL;
							_tmp8 = NULL;
							sym = (_tmp9 = (_tmp8 = local_sym, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8))), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), _tmp9);
						}
						(ns == NULL ? NULL : (ns = (g_object_unref (ns), NULL)));
						(local_sym == NULL ? NULL : (local_sym = (g_object_unref (local_sym), NULL)));
					}
				}
				(ns_it == NULL ? NULL : (ns_it = (g_object_unref (ns_it), NULL)));
			}
		}
		if (sym == NULL) {
			char* _tmp10;
			_tmp10 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) type)), (_tmp10 = g_strdup_printf ("The type name `%s' could not be found", vala_type_reference_get_type_name (type))));
			(_tmp10 = (g_free (_tmp10), NULL));
			(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
			(scope == NULL ? NULL : (scope = (g_object_unref (scope), NULL)));
			return;
		}
		if (VALA_IS_TYPE_PARAMETER (sym)) {
			vala_type_reference_set_type_parameter (type, VALA_TYPE_PARAMETER (sym));
		} else {
			if (VALA_IS_DATA_TYPE (sym)) {
				vala_type_reference_set_data_type (type, VALA_DATA_TYPE (sym));
			} else {
				char* _tmp12;
				char* _tmp11;
				_tmp12 = NULL;
				_tmp11 = NULL;
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) type)), (_tmp12 = g_strdup_printf ("`%s' is not a type", (_tmp11 = vala_symbol_get_full_name (sym)))));
				(_tmp12 = (g_free (_tmp12), NULL));
				(_tmp11 = (g_free (_tmp11), NULL));
				(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
				(scope == NULL ? NULL : (scope = (g_object_unref (scope), NULL)));
				return;
			}
		}
		(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
		(scope == NULL ? NULL : (scope = (g_object_unref (scope), NULL)));
	} else {
		ValaSymbol* ns_symbol;
		ValaSymbol* sym;
		ns_symbol = vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), vala_type_reference_get_namespace_name (type));
		if (ns_symbol == NULL) {
			char* _tmp13;
			vala_code_node_set_error (VALA_CODE_NODE (type), TRUE);
			_tmp13 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) type)), (_tmp13 = g_strdup_printf ("The namespace name `%s' could not be found", vala_type_reference_get_namespace_name (type))));
			(_tmp13 = (g_free (_tmp13), NULL));
			(ns_symbol == NULL ? NULL : (ns_symbol = (g_object_unref (ns_symbol), NULL)));
			return;
		}
		sym = vala_scope_lookup (vala_symbol_get_scope (ns_symbol), vala_type_reference_get_type_name (type));
		if (sym == NULL) {
			char* _tmp14;
			_tmp14 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) type)), (_tmp14 = g_strdup_printf ("The type name `%s' does not exist in the namespace `%s'", vala_type_reference_get_type_name (type), vala_type_reference_get_namespace_name (type))));
			(_tmp14 = (g_free (_tmp14), NULL));
			(ns_symbol == NULL ? NULL : (ns_symbol = (g_object_unref (ns_symbol), NULL)));
			(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
			return;
		}
		if (VALA_IS_DATA_TYPE (sym)) {
			vala_type_reference_set_data_type (type, VALA_DATA_TYPE (sym));
		} else {
			char* _tmp16;
			char* _tmp15;
			_tmp16 = NULL;
			_tmp15 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) type)), (_tmp16 = g_strdup_printf ("`%s' is not a type", (_tmp15 = vala_symbol_get_full_name (sym)))));
			(_tmp16 = (g_free (_tmp16), NULL));
			(_tmp15 = (g_free (_tmp15), NULL));
			(ns_symbol == NULL ? NULL : (ns_symbol = (g_object_unref (ns_symbol), NULL)));
			(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
			return;
		}
		(ns_symbol == NULL ? NULL : (ns_symbol = (g_object_unref (ns_symbol), NULL)));
		(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
	}
	if (vala_type_reference_get_pointer_level (type) > 0) {
		ValaTypeReference* referent_type;
		ValaPointer* _tmp18;
		if (vala_type_reference_get_data_type (type) == NULL) {
			char* _tmp17;
			vala_code_node_set_error (VALA_CODE_NODE (type), TRUE);
			_tmp17 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) type)), (_tmp17 = g_strdup_printf ("Pointer to `%s' not supported", vala_type_reference_get_type_name (type))));
			(_tmp17 = (g_free (_tmp17), NULL));
			return;
		}
		referent_type = vala_type_reference_new ();
		vala_type_reference_set_data_type (referent_type, vala_type_reference_get_data_type (type));
		vala_type_reference_set_pointer_level (referent_type, vala_type_reference_get_pointer_level (type) - 1);
		if (vala_data_type_is_reference_type (vala_type_reference_get_data_type (type))) {
			vala_type_reference_set_takes_ownership (referent_type, vala_type_reference_get_takes_ownership (type));
		}
		_tmp18 = NULL;
		vala_type_reference_set_data_type (type, VALA_DATA_TYPE ((_tmp18 = vala_data_type_get_pointer (vala_type_reference_get_data_type (referent_type)))));
		(_tmp18 = (g_object_unref (_tmp18), NULL));
		vala_type_reference_add_type_argument (type, referent_type);
		vala_code_visitor_visit_type_reference (VALA_CODE_VISITOR (self), referent_type);
		(referent_type == NULL ? NULL : (referent_type = (g_object_unref (referent_type), NULL)));
	}
	/* check for array */
	if (vala_type_reference_get_array_rank (type) > 0) {
		ValaTypeReference* element_type;
		element_type = vala_type_reference_new ();
		vala_type_reference_set_data_type (element_type, vala_type_reference_get_data_type (type));
		vala_type_reference_set_type_parameter (element_type, vala_type_reference_get_type_parameter (type));
		{
			GeeList* type_arg_collection;
			GeeIterator* type_arg_it;
			type_arg_collection = vala_type_reference_get_type_arguments (type);
			type_arg_it = gee_iterable_iterator (GEE_ITERABLE (type_arg_collection));
			while (gee_iterator_next (type_arg_it)) {
				ValaTypeReference* type_arg;
				type_arg = gee_iterator_get (type_arg_it);
				{
					vala_type_reference_add_type_argument (element_type, type_arg);
					(type_arg == NULL ? NULL : (type_arg = (g_object_unref (type_arg), NULL)));
				}
			}
			(type_arg_collection == NULL ? NULL : (type_arg_collection = (g_object_unref (type_arg_collection), NULL)));
			(type_arg_it == NULL ? NULL : (type_arg_it = (g_object_unref (type_arg_it), NULL)));
		}
		vala_type_reference_remove_all_type_arguments (type);
		if (vala_type_reference_get_data_type (type) != NULL) {
			ValaArray* _tmp19;
			if (vala_data_type_is_reference_type (vala_type_reference_get_data_type (type))) {
				vala_type_reference_set_takes_ownership (element_type, vala_type_reference_get_takes_ownership (type));
			}
			_tmp19 = NULL;
			vala_type_reference_set_data_type (type, VALA_DATA_TYPE ((_tmp19 = vala_data_type_get_array (vala_type_reference_get_data_type (element_type), vala_type_reference_get_array_rank (type)))));
			(_tmp19 = (g_object_unref (_tmp19), NULL));
		} else {
			ValaArray* _tmp20;
			vala_type_reference_set_takes_ownership (element_type, vala_type_reference_get_takes_ownership (type));
			_tmp20 = NULL;
			vala_type_reference_set_data_type (type, VALA_DATA_TYPE ((_tmp20 = vala_type_parameter_get_array (vala_type_reference_get_type_parameter (element_type), vala_type_reference_get_array_rank (type)))));
			(_tmp20 = (g_object_unref (_tmp20), NULL));
			vala_type_reference_set_type_parameter (type, NULL);
		}
		vala_type_reference_add_type_argument (type, element_type);
		(element_type == NULL ? NULL : (element_type = (g_object_unref (element_type), NULL)));
	}
	if (vala_type_reference_get_data_type (type) != NULL && !vala_data_type_is_reference_type (vala_type_reference_get_data_type (type))) {
		/* reset takes_ownership and transfers_ownership of
		 * value-types for contexts where types are ref by
		 * default (field declarations and method return types)
		 */
		vala_type_reference_set_takes_ownership (type, FALSE);
		vala_type_reference_set_transfers_ownership (type, FALSE);
	}
}


static void vala_symbol_resolver_real_visit_variable_declarator (ValaCodeVisitor* base, ValaVariableDeclarator* decl)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_VARIABLE_DECLARATOR (decl));
	vala_code_node_accept_children (VALA_CODE_NODE (decl), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_INITIALIZER_LIST (list));
	vala_code_node_accept_children (VALA_CODE_NODE (list), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_THROW_STATEMENT (stmt));
	vala_code_node_accept_children (VALA_CODE_NODE (stmt), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_TRY_STATEMENT (stmt));
	vala_code_node_accept_children (VALA_CODE_NODE (stmt), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_CATCH_CLAUSE (clause));
	vala_code_node_accept_children (VALA_CODE_NODE (clause), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* e)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (e));
	vala_code_node_accept_children (VALA_CODE_NODE (e), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_class_init (ValaSymbolResolverClass * klass)
{
	vala_symbol_resolver_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaSymbolResolverPrivate));
	G_OBJECT_CLASS (klass)->dispose = vala_symbol_resolver_dispose;
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_symbol_resolver_real_visit_source_file;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_symbol_resolver_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_symbol_resolver_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_symbol_resolver_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_symbol_resolver_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_callback = vala_symbol_resolver_real_visit_callback;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = vala_symbol_resolver_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_symbol_resolver_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = vala_symbol_resolver_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = vala_symbol_resolver_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_formal_parameter = vala_symbol_resolver_real_visit_formal_parameter;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = vala_symbol_resolver_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property_accessor = vala_symbol_resolver_real_visit_property_accessor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = vala_symbol_resolver_real_visit_signal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constructor = vala_symbol_resolver_real_visit_constructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_destructor = vala_symbol_resolver_real_visit_destructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace_reference = vala_symbol_resolver_real_visit_namespace_reference;
	VALA_CODE_VISITOR_CLASS (klass)->visit_type_reference = vala_symbol_resolver_real_visit_type_reference;
	VALA_CODE_VISITOR_CLASS (klass)->visit_variable_declarator = vala_symbol_resolver_real_visit_variable_declarator;
	VALA_CODE_VISITOR_CLASS (klass)->visit_initializer_list = vala_symbol_resolver_real_visit_initializer_list;
	VALA_CODE_VISITOR_CLASS (klass)->visit_throw_statement = vala_symbol_resolver_real_visit_throw_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_try_statement = vala_symbol_resolver_real_visit_try_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_catch_clause = vala_symbol_resolver_real_visit_catch_clause;
	VALA_CODE_VISITOR_CLASS (klass)->visit_array_creation_expression = vala_symbol_resolver_real_visit_array_creation_expression;
}


static void vala_symbol_resolver_init (ValaSymbolResolver * self)
{
	self->priv = VALA_SYMBOL_RESOLVER_GET_PRIVATE (self);
}


static void vala_symbol_resolver_dispose (GObject * obj)
{
	ValaSymbolResolver * self;
	ValaSymbolResolverClass * klass;
	GObjectClass * parent_class;
	self = VALA_SYMBOL_RESOLVER (obj);
	(self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (g_object_unref (self->priv->root_symbol), NULL)));
	(self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL)));
	(self->priv->current_using_directives == NULL ? NULL : (self->priv->current_using_directives = (g_object_unref (self->priv->current_using_directives), NULL)));
	klass = VALA_SYMBOL_RESOLVER_CLASS (g_type_class_peek (VALA_TYPE_SYMBOL_RESOLVER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_symbol_resolver_get_type (void)
{
	static GType vala_symbol_resolver_type_id = 0;
	if (G_UNLIKELY (vala_symbol_resolver_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSymbolResolverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_symbol_resolver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSymbolResolver), 0, (GInstanceInitFunc) vala_symbol_resolver_init };
		vala_symbol_resolver_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaSymbolResolver", &g_define_type_info, 0);
	}
	return vala_symbol_resolver_type_id;
}




