/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALAMEMBERACCESS_H__
#define __VALAMEMBERACCESS_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee/collection.h>
#include <vala/valaexpression.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_MEMBER_ACCESS (vala_member_access_get_type ())
#define VALA_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess))
#define VALA_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))
#define VALA_IS_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_ACCESS))
#define VALA_IS_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_ACCESS))
#define VALA_MEMBER_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))

typedef struct _ValaMemberAccessPrivate ValaMemberAccessPrivate;

/**
 * Represents an access to a type member in the source code.
 */
struct _ValaMemberAccess {
	ValaExpression parent;
	ValaMemberAccessPrivate * priv;
};
struct _ValaMemberAccessClass {
	ValaExpressionClass parent;
};

ValaMemberAccess* vala_member_access_new (ValaExpression* inner, const char* member_name, ValaSourceReference* source_reference);
ValaMemberAccess* vala_member_access_new_simple (const char* member_name, ValaSourceReference* source_reference);
void vala_member_access_add_type_argument (ValaMemberAccess* self, ValaTypeReference* arg);
GeeCollection* vala_member_access_get_type_arguments (ValaMemberAccess* self);
ValaExpression* vala_member_access_get_inner (ValaMemberAccess* self);
void vala_member_access_set_inner (ValaMemberAccess* self, ValaExpression* value);
char* vala_member_access_get_member_name (ValaMemberAccess* self);
void vala_member_access_set_member_name (ValaMemberAccess* self, const char* value);
gboolean vala_member_access_get_prototype_access (ValaMemberAccess* self);
void vala_member_access_set_prototype_access (ValaMemberAccess* self, gboolean value);
GType vala_member_access_get_type (void);

G_END_DECLS

#endif
