/* valaliteral.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valaliteral.h"
#include <vala/valatypereference.h>
#include <vala/valaliteral.h>

struct _ValaLiteralPrivate {
	ValaTypeReference* _static_type;
};
#define VALA_LITERAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_LITERAL, ValaLiteralPrivate))
enum  {
	VALA_LITERAL_DUMMY_PROPERTY,
	VALA_LITERAL_STATIC_TYPE
};
static gpointer vala_literal_parent_class = NULL;
static void vala_literal_dispose (GObject * obj);


ValaTypeReference* vala_literal_get_static_type (ValaLiteral* self)
{
	g_return_val_if_fail (VALA_IS_LITERAL (self), NULL);
	return self->priv->_static_type;
}


void vala_literal_set_static_type (ValaLiteral* self, ValaTypeReference* value)
{
	ValaTypeReference* _tmp2;
	ValaTypeReference* _tmp1;
	g_return_if_fail (VALA_IS_LITERAL (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_static_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_static_type == NULL ? NULL : (self->priv->_static_type = (g_object_unref (self->priv->_static_type), NULL))), _tmp2);
}


static void vala_literal_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaLiteral * self;
	self = VALA_LITERAL (object);
	switch (property_id) {
		case VALA_LITERAL_STATIC_TYPE:
		g_value_set_object (value, vala_literal_get_static_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_literal_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaLiteral * self;
	self = VALA_LITERAL (object);
	switch (property_id) {
		case VALA_LITERAL_STATIC_TYPE:
		vala_literal_set_static_type (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_literal_class_init (ValaLiteralClass * klass)
{
	vala_literal_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaLiteralPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_literal_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_literal_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_literal_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_LITERAL_STATIC_TYPE, g_param_spec_object ("static-type", "foo", "bar", VALA_TYPE_TYPE_REFERENCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_literal_init (ValaLiteral * self)
{
	self->priv = VALA_LITERAL_GET_PRIVATE (self);
}


static void vala_literal_dispose (GObject * obj)
{
	ValaLiteral * self;
	ValaLiteralClass * klass;
	GObjectClass * parent_class;
	self = VALA_LITERAL (obj);
	(self->priv->_static_type == NULL ? NULL : (self->priv->_static_type = (g_object_unref (self->priv->_static_type), NULL)));
	klass = VALA_LITERAL_CLASS (g_type_class_peek (VALA_TYPE_LITERAL));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_literal_get_type (void)
{
	static GType vala_literal_type_id = 0;
	if (G_UNLIKELY (vala_literal_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLiteralClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_literal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLiteral), 0, (GInstanceInitFunc) vala_literal_init };
		vala_literal_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaLiteral", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_literal_type_id;
}




