/* valadostatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valadostatement.h"
#include <vala/valaexpression.h>
#include <vala/valablock.h>
#include <vala/valasourcereference.h>
#include <vala/valadostatement.h>
#include <vala/valacodevisitor.h>

struct _ValaDoStatementPrivate {
	ValaExpression* _condition;
	ValaBlock* _body;
};
#define VALA_DO_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DO_STATEMENT, ValaDoStatementPrivate))
enum  {
	VALA_DO_STATEMENT_DUMMY_PROPERTY,
	VALA_DO_STATEMENT_BODY,
	VALA_DO_STATEMENT_CONDITION
};
static void vala_do_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_do_statement_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node);
static gpointer vala_do_statement_parent_class = NULL;
static ValaStatementIface* vala_do_statement_vala_statement_parent_iface = NULL;
static void vala_do_statement_dispose (GObject * obj);


/**
 * Creates a new do statement.
 *
 * @param cond   loop condition
 * @param body   loop body
 * @param source reference to source code
 * @return       newly created do statement
 */
ValaDoStatement* vala_do_statement_new (ValaBlock* body, ValaExpression* condition, ValaSourceReference* source_reference)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaDoStatement * self;
	g_return_val_if_fail (VALA_IS_BLOCK (body), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (condition), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	(__params_it->name = "condition", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, condition), __params_it++);
	self = g_object_newv (VALA_TYPE_DO_STATEMENT, __params_it - __params, __params);
	vala_do_statement_set_body (self, body);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_do_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaDoStatement * self;
	self = ((ValaDoStatement*) base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_do_statement_get_body (self)), visitor);
	vala_code_node_accept (VALA_CODE_NODE (vala_do_statement_get_condition (self)), visitor);
	vala_code_visitor_visit_end_full_expression (visitor, vala_do_statement_get_condition (self));
	vala_code_visitor_visit_do_statement (visitor, self);
}


static void vala_do_statement_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node)
{
	ValaDoStatement * self;
	self = ((ValaDoStatement*) base);
	g_return_if_fail (VALA_IS_CODE_NODE (old_node));
	g_return_if_fail (VALA_IS_CODE_NODE (new_node));
	if (VALA_CODE_NODE (vala_do_statement_get_condition (self)) == old_node) {
		vala_do_statement_set_condition (self, VALA_EXPRESSION (new_node));
	}
}


ValaBlock* vala_do_statement_get_body (ValaDoStatement* self)
{
	g_return_val_if_fail (VALA_IS_DO_STATEMENT (self), NULL);
	return self->priv->_body;
}


void vala_do_statement_set_body (ValaDoStatement* self, ValaBlock* value)
{
	ValaBlock* _tmp2;
	ValaBlock* _tmp1;
	g_return_if_fail (VALA_IS_DO_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_body = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL))), _tmp2);
	vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_body), VALA_CODE_NODE (self));
}


ValaExpression* vala_do_statement_get_condition (ValaDoStatement* self)
{
	g_return_val_if_fail (VALA_IS_DO_STATEMENT (self), NULL);
	return self->priv->_condition;
}


void vala_do_statement_set_condition (ValaDoStatement* self, ValaExpression* value)
{
	ValaExpression* _tmp1;
	g_return_if_fail (VALA_IS_DO_STATEMENT (self));
	_tmp1 = NULL;
	self->priv->_condition = (_tmp1 = g_object_ref (value), (self->priv->_condition == NULL ? NULL : (self->priv->_condition = (g_object_unref (self->priv->_condition), NULL))), _tmp1);
	vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_condition), VALA_CODE_NODE (self));
}


static void vala_do_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaDoStatement * self;
	self = VALA_DO_STATEMENT (object);
	switch (property_id) {
		case VALA_DO_STATEMENT_BODY:
		g_value_set_object (value, vala_do_statement_get_body (self));
		break;
		case VALA_DO_STATEMENT_CONDITION:
		g_value_set_object (value, vala_do_statement_get_condition (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_do_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaDoStatement * self;
	self = VALA_DO_STATEMENT (object);
	switch (property_id) {
		case VALA_DO_STATEMENT_BODY:
		vala_do_statement_set_body (self, g_value_get_object (value));
		break;
		case VALA_DO_STATEMENT_CONDITION:
		vala_do_statement_set_condition (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_do_statement_class_init (ValaDoStatementClass * klass)
{
	vala_do_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaDoStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_do_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_do_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_do_statement_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_do_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->replace = vala_do_statement_real_replace;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_DO_STATEMENT_BODY, g_param_spec_object ("body", "foo", "bar", VALA_TYPE_BLOCK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_DO_STATEMENT_CONDITION, g_param_spec_object ("condition", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_do_statement_vala_statement_interface_init (ValaStatementIface * iface)
{
	vala_do_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_do_statement_init (ValaDoStatement * self)
{
	self->priv = VALA_DO_STATEMENT_GET_PRIVATE (self);
}


static void vala_do_statement_dispose (GObject * obj)
{
	ValaDoStatement * self;
	ValaDoStatementClass * klass;
	GObjectClass * parent_class;
	self = VALA_DO_STATEMENT (obj);
	(self->priv->_condition == NULL ? NULL : (self->priv->_condition = (g_object_unref (self->priv->_condition), NULL)));
	(self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL)));
	klass = VALA_DO_STATEMENT_CLASS (g_type_class_peek (VALA_TYPE_DO_STATEMENT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_do_statement_get_type (void)
{
	static GType vala_do_statement_type_id = 0;
	if (G_UNLIKELY (vala_do_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDoStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_do_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDoStatement), 0, (GInstanceInitFunc) vala_do_statement_init };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_do_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_do_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaDoStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_do_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	}
	return vala_do_statement_type_id;
}




