/* valadbussignal.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALADBUSSIGNAL_H__
#define __VALADBUSSIGNAL_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valasignal.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valatypereference.h>
#include <vala/valasourcereference.h>

G_BEGIN_DECLS


#define VALA_TYPE_DBUS_SIGNAL (vala_dbus_signal_get_type ())
#define VALA_DBUS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DBUS_SIGNAL, ValaDBusSignal))
#define VALA_DBUS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DBUS_SIGNAL, ValaDBusSignalClass))
#define VALA_IS_DBUS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DBUS_SIGNAL))
#define VALA_IS_DBUS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DBUS_SIGNAL))
#define VALA_DBUS_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DBUS_SIGNAL, ValaDBusSignalClass))

typedef struct _ValaDBusSignal ValaDBusSignal;
typedef struct _ValaDBusSignalClass ValaDBusSignalClass;
typedef struct _ValaDBusSignalPrivate ValaDBusSignalPrivate;

/**
 * Represents a dynamic bound DBus signal.
 */
struct _ValaDBusSignal {
	ValaSignal parent;
	ValaDBusSignalPrivate * priv;
};
struct _ValaDBusSignalClass {
	ValaSignalClass parent;
};

ValaDBusSignal* vala_dbus_signal_new (const char* name, ValaTypeReference* return_type, ValaSourceReference* source_reference);
GType vala_dbus_signal_get_type (void);

G_END_DECLS

#endif
