/* valatypecheck.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valatypecheck.h"
#include <vala/valatypereference.h>
#include <vala/valasourcereference.h>
#include <vala/valatypecheck.h>
#include <vala/valacodevisitor.h>

struct _ValaTypeCheckPrivate {
	ValaExpression* _expression;
	ValaTypeReference* _type_reference;
};
#define VALA_TYPE_CHECK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TYPE_CHECK, ValaTypeCheckPrivate))
enum  {
	VALA_TYPE_CHECK_DUMMY_PROPERTY,
	VALA_TYPE_CHECK_EXPRESSION,
	VALA_TYPE_CHECK_TYPE_REFERENCE
};
static void vala_type_check_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_type_check_parent_class = NULL;
static void vala_type_check_dispose (GObject * obj);


/**
 * Creates a new type check expression.
 *
 * @param expr   an expression
 * @param type   a data type
 * @param source reference to source code
 * @return       newly created type check expression
 */
ValaTypeCheck* vala_type_check_new (ValaExpression* expr, ValaTypeReference* type, ValaSourceReference* source)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaTypeCheck * self;
	g_return_val_if_fail (VALA_IS_EXPRESSION (expr), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "expression", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, expr), __params_it++);
	(__params_it->name = "type-reference", g_value_init (&__params_it->value, VALA_TYPE_TYPE_REFERENCE), g_value_set_object (&__params_it->value, type), __params_it++);
	self = g_object_newv (VALA_TYPE_TYPE_CHECK, __params_it - __params, __params);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_type_check_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaTypeCheck * self;
	self = ((ValaTypeCheck*) base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_type_check_get_expression (self)), visitor);
	vala_code_node_accept (VALA_CODE_NODE (vala_type_check_get_type_reference (self)), visitor);
	vala_code_visitor_visit_type_check (visitor, self);
}


ValaExpression* vala_type_check_get_expression (ValaTypeCheck* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_CHECK (self), NULL);
	return self->priv->_expression;
}


void vala_type_check_set_expression (ValaTypeCheck* self, ValaExpression* value)
{
	ValaExpression* __temp1;
	g_return_if_fail (VALA_IS_TYPE_CHECK (self));
	__temp1 = NULL;
	self->priv->_expression = (__temp1 = g_object_ref (value), (self->priv->_expression == NULL ? NULL : (self->priv->_expression = (g_object_unref (self->priv->_expression), NULL))), __temp1);
}


ValaTypeReference* vala_type_check_get_type_reference (ValaTypeCheck* self)
{
	g_return_val_if_fail (VALA_IS_TYPE_CHECK (self), NULL);
	return self->priv->_type_reference;
}


void vala_type_check_set_type_reference (ValaTypeCheck* self, ValaTypeReference* value)
{
	ValaTypeReference* __temp3;
	g_return_if_fail (VALA_IS_TYPE_CHECK (self));
	__temp3 = NULL;
	self->priv->_type_reference = (__temp3 = g_object_ref (value), (self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL))), __temp3);
}


static void vala_type_check_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaTypeCheck * self;
	self = VALA_TYPE_CHECK (object);
	switch (property_id) {
		case VALA_TYPE_CHECK_EXPRESSION:
		g_value_set_object (value, vala_type_check_get_expression (self));
		break;
		case VALA_TYPE_CHECK_TYPE_REFERENCE:
		g_value_set_object (value, vala_type_check_get_type_reference (self));
		break;
	}
}


static void vala_type_check_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaTypeCheck * self;
	self = VALA_TYPE_CHECK (object);
	switch (property_id) {
		case VALA_TYPE_CHECK_EXPRESSION:
		vala_type_check_set_expression (self, g_value_get_object (value));
		break;
		case VALA_TYPE_CHECK_TYPE_REFERENCE:
		vala_type_check_set_type_reference (self, g_value_get_object (value));
		break;
	}
}


static void vala_type_check_class_init (ValaTypeCheckClass * klass)
{
	vala_type_check_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaTypeCheckPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_type_check_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_type_check_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_type_check_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_type_check_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TYPE_CHECK_EXPRESSION, g_param_spec_object ("expression", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TYPE_CHECK_TYPE_REFERENCE, g_param_spec_object ("type-reference", "foo", "bar", VALA_TYPE_TYPE_REFERENCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_type_check_init (ValaTypeCheck * self)
{
	self->priv = VALA_TYPE_CHECK_GET_PRIVATE (self);
}


static void vala_type_check_dispose (GObject * obj)
{
	ValaTypeCheck * self;
	ValaTypeCheckClass * klass;
	GObjectClass * parent_class;
	self = VALA_TYPE_CHECK (obj);
	(self->priv->_expression == NULL ? NULL : (self->priv->_expression = (g_object_unref (self->priv->_expression), NULL)));
	(self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL)));
	klass = VALA_TYPE_CHECK_CLASS (g_type_class_peek (VALA_TYPE_TYPE_CHECK));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_type_check_get_type (void)
{
	static GType vala_type_check_type_id = 0;
	if (G_UNLIKELY (vala_type_check_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeCheckClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_type_check_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeCheck), 0, (GInstanceInitFunc) vala_type_check_init };
		vala_type_check_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaTypeCheck", &g_define_type_info, 0);
	}
	return vala_type_check_type_id;
}




