/* valasymbolresolver.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valasymbolresolver.h"
#include <gee/collection.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasymbol.h>
#include <vala/valascope.h>
#include <vala/valasymbolresolver.h>
#include <vala/valareport.h>
#include <vala/valacodenode.h>
#include <vala/valasourcereference.h>
#include <vala/valadatatype.h>
#include <vala/valatypeparameter.h>

struct _ValaSymbolResolverPrivate {
	ValaSymbol* root_symbol;
	ValaScope* current_scope;
	GeeCollection* current_using_directives;
	ValaClass* object_class;
};
#define VALA_SYMBOL_RESOLVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SYMBOL_RESOLVER, ValaSymbolResolverPrivate))
enum  {
	VALA_SYMBOL_RESOLVER_DUMMY_PROPERTY
};
static void vala_symbol_resolver_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* file);
static void vala_symbol_resolver_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_symbol_resolver_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_symbol_resolver_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_symbol_resolver_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_symbol_resolver_real_visit_callback (ValaCodeVisitor* base, ValaCallback* cb);
static void vala_symbol_resolver_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_symbol_resolver_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_symbol_resolver_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static void vala_symbol_resolver_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void vala_symbol_resolver_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p);
static void vala_symbol_resolver_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_symbol_resolver_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static void vala_symbol_resolver_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static void vala_symbol_resolver_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c);
static void vala_symbol_resolver_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d);
static void vala_symbol_resolver_real_visit_namespace_reference (ValaCodeVisitor* base, ValaNamespaceReference* ns);
static void vala_symbol_resolver_real_visit_type_reference (ValaCodeVisitor* base, ValaTypeReference* type);
static void vala_symbol_resolver_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt);
static void vala_symbol_resolver_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt);
static void vala_symbol_resolver_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause);
static gpointer vala_symbol_resolver_parent_class = NULL;
static void vala_symbol_resolver_dispose (GObject * obj);


/**
 * Resolve symbol names in the specified code context.
 *
 * @param context a code context
 */
void vala_symbol_resolver_resolve (ValaSymbolResolver* self, ValaCodeContext* context)
{
	ValaSymbol* __temp0;
	ValaScope* __temp2;
	ValaScope* __temp1;
	ValaSymbol* glib_ns;
	g_return_if_fail (VALA_IS_SYMBOL_RESOLVER (self));
	g_return_if_fail (VALA_IS_CODE_CONTEXT (context));
	__temp0 = NULL;
	self->priv->root_symbol = (__temp0 = VALA_SYMBOL (g_object_ref (vala_code_context_get_root (context))), (self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (g_object_unref (self->priv->root_symbol), NULL))), __temp0);
	__temp2 = NULL;
	__temp1 = NULL;
	self->priv->current_scope = (__temp2 = (__temp1 = vala_symbol_get_scope (self->priv->root_symbol), (__temp1 == NULL ? NULL : g_object_ref (__temp1))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp2);
	/* TODO: don't require GLib namespace in symbol resolver*/
	glib_ns = vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "GLib");
	if (glib_ns != NULL) {
		ValaClass* __temp3;
		__temp3 = NULL;
		self->priv->object_class = (__temp3 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Object")), (self->priv->object_class == NULL ? NULL : (self->priv->object_class = (g_object_unref (self->priv->object_class), NULL))), __temp3);
	}
	vala_code_context_accept (context, VALA_CODE_VISITOR (self));
	(glib_ns == NULL ? NULL : (glib_ns = (g_object_unref (glib_ns), NULL)));
}


static void vala_symbol_resolver_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* file)
{
	ValaSymbolResolver * self;
	GeeCollection* __temp4;
	ValaScope* __temp6;
	ValaScope* __temp5;
	GeeCollection* __temp7;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_SOURCE_FILE (file));
	__temp4 = NULL;
	self->priv->current_using_directives = (__temp4 = vala_source_file_get_using_directives (file), (self->priv->current_using_directives == NULL ? NULL : (self->priv->current_using_directives = (g_object_unref (self->priv->current_using_directives), NULL))), __temp4);
	__temp6 = NULL;
	__temp5 = NULL;
	self->priv->current_scope = (__temp6 = (__temp5 = vala_symbol_get_scope (self->priv->root_symbol), (__temp5 == NULL ? NULL : g_object_ref (__temp5))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp6);
	vala_source_file_accept_children (file, VALA_CODE_VISITOR (self));
	__temp7 = NULL;
	self->priv->current_using_directives = (__temp7 = NULL, (self->priv->current_using_directives == NULL ? NULL : (self->priv->current_using_directives = (g_object_unref (self->priv->current_using_directives), NULL))), __temp7);
}


static void vala_symbol_resolver_real_visit_class (ValaCodeVisitor* base, ValaClass* cl)
{
	ValaSymbolResolver * self;
	ValaScope* __temp9;
	ValaScope* __temp8;
	ValaScope* __temp15;
	ValaScope* __temp14;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_CLASS (cl));
	__temp9 = NULL;
	__temp8 = NULL;
	self->priv->current_scope = (__temp9 = (__temp8 = vala_symbol_get_scope (((ValaSymbol*) cl)), (__temp8 == NULL ? NULL : g_object_ref (__temp8))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp9);
	vala_code_node_accept_children (VALA_CODE_NODE (cl), VALA_CODE_VISITOR (self));
	{
		GeeCollection* type_collection;
		GeeIterator* type_it;
		type_collection = vala_class_get_base_types (cl);
		type_it = gee_iterable_iterator (GEE_ITERABLE (type_collection));
		while (gee_iterator_next (type_it)) {
			ValaTypeReference* type;
			type = gee_iterator_get (type_it);
			{
				if (VALA_IS_CLASS (vala_type_reference_get_data_type (type))) {
					if (vala_class_get_base_class (cl) != NULL) {
						char* __temp13;
						char* __temp12;
						char* __temp11;
						char* __temp10;
						__temp13 = NULL;
						__temp12 = NULL;
						__temp11 = NULL;
						__temp10 = NULL;
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) type)), (__temp13 = g_strdup_printf ("%s: Classes cannot have multiple base classes (`%s' and `%s')", (__temp10 = vala_symbol_get_full_name (VALA_SYMBOL (cl))), (__temp11 = vala_symbol_get_full_name (VALA_SYMBOL (vala_class_get_base_class (cl)))), (__temp12 = vala_symbol_get_full_name (VALA_SYMBOL (vala_type_reference_get_data_type (type)))))));
						(__temp13 = (g_free (__temp13), NULL));
						(__temp12 = (g_free (__temp12), NULL));
						(__temp11 = (g_free (__temp11), NULL));
						(__temp10 = (g_free (__temp10), NULL));
						(type == NULL ? NULL : (type = (g_object_unref (type), NULL)));
						(type_collection == NULL ? NULL : (type_collection = (g_object_unref (type_collection), NULL)));
						(type_it == NULL ? NULL : (type_it = (g_object_unref (type_it), NULL)));
						return;
					}
					vala_class_set_base_class (cl, VALA_CLASS (vala_type_reference_get_data_type (type)));
				}
				(type == NULL ? NULL : (type = (g_object_unref (type), NULL)));
			}
		}
		(type_collection == NULL ? NULL : (type_collection = (g_object_unref (type_collection), NULL)));
		(type_it == NULL ? NULL : (type_it = (g_object_unref (type_it), NULL)));
	}
	if (vala_class_get_base_class (cl) == NULL && cl != self->priv->object_class) {
		ValaTypeReference* object_type;
		object_type = vala_type_reference_new ();
		vala_type_reference_set_data_type (object_type, VALA_DATA_TYPE (self->priv->object_class));
		vala_class_add_base_type (cl, object_type);
		vala_class_set_base_class (cl, self->priv->object_class);
		(object_type == NULL ? NULL : (object_type = (g_object_unref (object_type), NULL)));
	}
	__temp15 = NULL;
	__temp14 = NULL;
	self->priv->current_scope = (__temp15 = (__temp14 = vala_scope_get_parent_scope (self->priv->current_scope), (__temp14 == NULL ? NULL : g_object_ref (__temp14))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp15);
}


static void vala_symbol_resolver_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st)
{
	ValaSymbolResolver * self;
	ValaScope* __temp17;
	ValaScope* __temp16;
	ValaScope* __temp19;
	ValaScope* __temp18;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_STRUCT (st));
	__temp17 = NULL;
	__temp16 = NULL;
	self->priv->current_scope = (__temp17 = (__temp16 = vala_symbol_get_scope (((ValaSymbol*) st)), (__temp16 == NULL ? NULL : g_object_ref (__temp16))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp17);
	vala_code_node_accept_children (VALA_CODE_NODE (st), VALA_CODE_VISITOR (self));
	__temp19 = NULL;
	__temp18 = NULL;
	self->priv->current_scope = (__temp19 = (__temp18 = vala_scope_get_parent_scope (self->priv->current_scope), (__temp18 == NULL ? NULL : g_object_ref (__temp18))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp19);
}


static void vala_symbol_resolver_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface)
{
	ValaSymbolResolver * self;
	ValaScope* __temp21;
	ValaScope* __temp20;
	ValaScope* __temp23;
	ValaScope* __temp22;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	__temp21 = NULL;
	__temp20 = NULL;
	self->priv->current_scope = (__temp21 = (__temp20 = vala_symbol_get_scope (((ValaSymbol*) iface)), (__temp20 == NULL ? NULL : g_object_ref (__temp20))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp21);
	vala_code_node_accept_children (VALA_CODE_NODE (iface), VALA_CODE_VISITOR (self));
	__temp23 = NULL;
	__temp22 = NULL;
	self->priv->current_scope = (__temp23 = (__temp22 = vala_scope_get_parent_scope (self->priv->current_scope), (__temp22 == NULL ? NULL : g_object_ref (__temp22))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp23);
}


static void vala_symbol_resolver_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en)
{
	ValaSymbolResolver * self;
	ValaScope* __temp25;
	ValaScope* __temp24;
	ValaScope* __temp27;
	ValaScope* __temp26;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_ENUM (en));
	__temp25 = NULL;
	__temp24 = NULL;
	self->priv->current_scope = (__temp25 = (__temp24 = vala_symbol_get_scope (((ValaSymbol*) en)), (__temp24 == NULL ? NULL : g_object_ref (__temp24))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp25);
	vala_code_node_accept_children (VALA_CODE_NODE (en), VALA_CODE_VISITOR (self));
	__temp27 = NULL;
	__temp26 = NULL;
	self->priv->current_scope = (__temp27 = (__temp26 = vala_scope_get_parent_scope (self->priv->current_scope), (__temp26 == NULL ? NULL : g_object_ref (__temp26))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp27);
}


static void vala_symbol_resolver_real_visit_callback (ValaCodeVisitor* base, ValaCallback* cb)
{
	ValaSymbolResolver * self;
	ValaScope* __temp29;
	ValaScope* __temp28;
	ValaScope* __temp31;
	ValaScope* __temp30;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_CALLBACK (cb));
	__temp29 = NULL;
	__temp28 = NULL;
	self->priv->current_scope = (__temp29 = (__temp28 = vala_symbol_get_scope (((ValaSymbol*) cb)), (__temp28 == NULL ? NULL : g_object_ref (__temp28))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp29);
	vala_code_node_accept_children (VALA_CODE_NODE (cb), VALA_CODE_VISITOR (self));
	__temp31 = NULL;
	__temp30 = NULL;
	self->priv->current_scope = (__temp31 = (__temp30 = vala_scope_get_parent_scope (self->priv->current_scope), (__temp30 == NULL ? NULL : g_object_ref (__temp30))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp31);
}


static void vala_symbol_resolver_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c)
{
	ValaSymbolResolver * self;
	ValaScope* __temp33;
	ValaScope* __temp32;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_CONSTANT (c));
	__temp33 = NULL;
	__temp32 = NULL;
	self->priv->current_scope = (__temp33 = (__temp32 = vala_symbol_get_scope (((ValaSymbol*) c)), (__temp32 == NULL ? NULL : g_object_ref (__temp32))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp33);
	vala_code_node_accept_children (VALA_CODE_NODE (c), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_field (ValaCodeVisitor* base, ValaField* f)
{
	ValaSymbolResolver * self;
	ValaScope* __temp35;
	ValaScope* __temp34;
	ValaScope* __temp37;
	ValaScope* __temp36;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_FIELD (f));
	__temp35 = NULL;
	__temp34 = NULL;
	self->priv->current_scope = (__temp35 = (__temp34 = vala_symbol_get_scope (((ValaSymbol*) f)), (__temp34 == NULL ? NULL : g_object_ref (__temp34))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp35);
	vala_code_node_accept_children (VALA_CODE_NODE (f), VALA_CODE_VISITOR (self));
	__temp37 = NULL;
	__temp36 = NULL;
	self->priv->current_scope = (__temp37 = (__temp36 = vala_scope_get_parent_scope (self->priv->current_scope), (__temp36 == NULL ? NULL : g_object_ref (__temp36))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp37);
}


static void vala_symbol_resolver_real_visit_method (ValaCodeVisitor* base, ValaMethod* m)
{
	ValaSymbolResolver * self;
	ValaScope* __temp39;
	ValaScope* __temp38;
	ValaScope* __temp41;
	ValaScope* __temp40;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_METHOD (m));
	__temp39 = NULL;
	__temp38 = NULL;
	self->priv->current_scope = (__temp39 = (__temp38 = vala_symbol_get_scope (((ValaSymbol*) m)), (__temp38 == NULL ? NULL : g_object_ref (__temp38))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp39);
	vala_code_node_accept_children (VALA_CODE_NODE (m), VALA_CODE_VISITOR (self));
	__temp41 = NULL;
	__temp40 = NULL;
	self->priv->current_scope = (__temp41 = (__temp40 = vala_scope_get_parent_scope (self->priv->current_scope), (__temp40 == NULL ? NULL : g_object_ref (__temp40))), (self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL))), __temp41);
}


static void vala_symbol_resolver_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_CREATION_METHOD (m));
	vala_code_node_accept_children (VALA_CODE_NODE (m), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_FORMAL_PARAMETER (p));
	vala_code_node_accept_children (VALA_CODE_NODE (p), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_PROPERTY (prop));
	vala_code_node_accept_children (VALA_CODE_NODE (prop), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_PROPERTY_ACCESSOR (acc));
	vala_code_node_accept_children (VALA_CODE_NODE (acc), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_SIGNAL (sig));
	vala_code_node_accept_children (VALA_CODE_NODE (sig), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_CONSTRUCTOR (c));
	vala_code_node_accept_children (VALA_CODE_NODE (c), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_DESTRUCTOR (d));
	vala_code_node_accept_children (VALA_CODE_NODE (d), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_namespace_reference (ValaCodeVisitor* base, ValaNamespaceReference* ns)
{
	ValaSymbolResolver * self;
	ValaSymbol* __temp42;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_NAMESPACE_REFERENCE (ns));
	__temp42 = NULL;
	vala_namespace_reference_set_namespace_symbol (ns, (__temp42 = vala_scope_lookup (self->priv->current_scope, vala_namespace_reference_get_name (ns))));
	(__temp42 == NULL ? NULL : (__temp42 = (g_object_unref (__temp42), NULL)));
	if (vala_namespace_reference_get_namespace_symbol (ns) == NULL) {
		char* __temp43;
		vala_code_node_set_error (VALA_CODE_NODE (ns), TRUE);
		__temp43 = NULL;
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) ns)), (__temp43 = g_strdup_printf ("The namespace name `%s' could not be found", vala_namespace_reference_get_name (ns))));
		(__temp43 = (g_free (__temp43), NULL));
		return;
	}
}


static void vala_symbol_resolver_real_visit_type_reference (ValaCodeVisitor* base, ValaTypeReference* type)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_TYPE_REFERENCE (type));
	if (vala_type_reference_get_type_name (type) == NULL || g_utf8_collate (vala_type_reference_get_type_name (type), "void") == 0) {
		/* reset transfers_ownership*/
		vala_type_reference_set_transfers_ownership (type, FALSE);
		return;
	}
	if (vala_type_reference_get_namespace_name (type) == NULL) {
		ValaSymbol* sym;
		ValaScope* __temp44;
		ValaScope* scope;
		sym = NULL;
		__temp44 = NULL;
		scope = (__temp44 = self->priv->current_scope, (__temp44 == NULL ? NULL : g_object_ref (__temp44)));
		while (sym == NULL && scope != NULL) {
			ValaSymbol* __temp45;
			ValaScope* __temp47;
			ValaScope* __temp46;
			__temp45 = NULL;
			sym = (__temp45 = vala_scope_lookup (scope, vala_type_reference_get_type_name (type)), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), __temp45);
			__temp47 = NULL;
			__temp46 = NULL;
			scope = (__temp47 = (__temp46 = vala_scope_get_parent_scope (scope), (__temp46 == NULL ? NULL : g_object_ref (__temp46))), (scope == NULL ? NULL : (scope = (g_object_unref (scope), NULL))), __temp47);
			if (sym != NULL && !(VALA_IS_DATA_TYPE (sym)) && !(VALA_IS_TYPE_PARAMETER (sym))) {
				ValaSymbol* __temp48;
				/* ignore non-type symbols*/
				__temp48 = NULL;
				sym = (__temp48 = NULL, (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), __temp48);
			}
		}
		if (sym == NULL) {
			{
				GeeCollection* ns_collection;
				GeeIterator* ns_it;
				ns_collection = self->priv->current_using_directives;
				ns_it = gee_iterable_iterator (GEE_ITERABLE (ns_collection));
				while (gee_iterator_next (ns_it)) {
					ValaNamespaceReference* ns;
					ns = gee_iterator_get (ns_it);
					{
						ValaSymbol* local_sym;
						if (vala_code_node_get_error (((ValaCodeNode*) ns))) {
							(ns == NULL ? NULL : (ns = (g_object_unref (ns), NULL)));
							continue;
						}
						local_sym = vala_scope_lookup (vala_symbol_get_scope (vala_namespace_reference_get_namespace_symbol (ns)), vala_type_reference_get_type_name (type));
						if (local_sym != NULL) {
							ValaSymbol* __temp53;
							ValaSymbol* __temp52;
							if (sym != NULL) {
								char* __temp51;
								char* __temp50;
								char* __temp49;
								__temp51 = NULL;
								__temp50 = NULL;
								__temp49 = NULL;
								vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) type)), (__temp51 = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", vala_type_reference_get_type_name (type), (__temp49 = vala_symbol_get_full_name (sym)), (__temp50 = vala_symbol_get_full_name (local_sym)))));
								(__temp51 = (g_free (__temp51), NULL));
								(__temp50 = (g_free (__temp50), NULL));
								(__temp49 = (g_free (__temp49), NULL));
								(ns == NULL ? NULL : (ns = (g_object_unref (ns), NULL)));
								(local_sym == NULL ? NULL : (local_sym = (g_object_unref (local_sym), NULL)));
								(ns_it == NULL ? NULL : (ns_it = (g_object_unref (ns_it), NULL)));
								(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
								(scope == NULL ? NULL : (scope = (g_object_unref (scope), NULL)));
								return;
							}
							__temp53 = NULL;
							__temp52 = NULL;
							sym = (__temp53 = (__temp52 = local_sym, (__temp52 == NULL ? NULL : g_object_ref (__temp52))), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), __temp53);
						}
						(ns == NULL ? NULL : (ns = (g_object_unref (ns), NULL)));
						(local_sym == NULL ? NULL : (local_sym = (g_object_unref (local_sym), NULL)));
					}
				}
				(ns_it == NULL ? NULL : (ns_it = (g_object_unref (ns_it), NULL)));
			}
		}
		if (sym == NULL) {
			char* __temp54;
			__temp54 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) type)), (__temp54 = g_strdup_printf ("The type name `%s' could not be found", vala_type_reference_get_type_name (type))));
			(__temp54 = (g_free (__temp54), NULL));
			(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
			(scope == NULL ? NULL : (scope = (g_object_unref (scope), NULL)));
			return;
		}
		if (VALA_IS_TYPE_PARAMETER (sym)) {
			vala_type_reference_set_type_parameter (type, VALA_TYPE_PARAMETER (sym));
		} else {
			vala_type_reference_set_data_type (type, VALA_DATA_TYPE (sym));
		}
		(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
		(scope == NULL ? NULL : (scope = (g_object_unref (scope), NULL)));
	} else {
		ValaSymbol* ns_symbol;
		ValaSymbol* sym;
		ns_symbol = vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), vala_type_reference_get_namespace_name (type));
		if (ns_symbol == NULL) {
			char* __temp55;
			vala_code_node_set_error (VALA_CODE_NODE (type), TRUE);
			__temp55 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) type)), (__temp55 = g_strdup_printf ("The namespace name `%s' could not be found", vala_type_reference_get_namespace_name (type))));
			(__temp55 = (g_free (__temp55), NULL));
			(ns_symbol == NULL ? NULL : (ns_symbol = (g_object_unref (ns_symbol), NULL)));
			return;
		}
		sym = vala_scope_lookup (vala_symbol_get_scope (ns_symbol), vala_type_reference_get_type_name (type));
		if (sym == NULL) {
			char* __temp56;
			__temp56 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) type)), (__temp56 = g_strdup_printf ("The type name `%s' does not exist in the namespace `%s'", vala_type_reference_get_type_name (type), vala_type_reference_get_namespace_name (type))));
			(__temp56 = (g_free (__temp56), NULL));
			(ns_symbol == NULL ? NULL : (ns_symbol = (g_object_unref (ns_symbol), NULL)));
			(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
			return;
		}
		vala_type_reference_set_data_type (type, VALA_DATA_TYPE (sym));
		(ns_symbol == NULL ? NULL : (ns_symbol = (g_object_unref (ns_symbol), NULL)));
		(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
	}
	if (vala_type_reference_get_pointer_level (type) > 0) {
		ValaTypeReference* referent_type;
		ValaPointer* __temp58;
		if (vala_type_reference_get_data_type (type) == NULL) {
			char* __temp57;
			vala_code_node_set_error (VALA_CODE_NODE (type), TRUE);
			__temp57 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) type)), (__temp57 = g_strdup_printf ("Pointer to `%s' not supported", vala_type_reference_get_type_name (type))));
			(__temp57 = (g_free (__temp57), NULL));
			return;
		}
		referent_type = vala_type_reference_new ();
		vala_type_reference_set_data_type (referent_type, vala_type_reference_get_data_type (type));
		vala_type_reference_set_pointer_level (referent_type, vala_type_reference_get_pointer_level (type) - 1);
		if (vala_data_type_is_reference_type (vala_type_reference_get_data_type (type))) {
			vala_type_reference_set_takes_ownership (referent_type, vala_type_reference_get_takes_ownership (type));
		}
		__temp58 = NULL;
		vala_type_reference_set_data_type (type, VALA_DATA_TYPE ((__temp58 = vala_data_type_get_pointer (vala_type_reference_get_data_type (referent_type)))));
		(__temp58 = (g_object_unref (__temp58), NULL));
		vala_type_reference_add_type_argument (type, referent_type);
		vala_code_visitor_visit_type_reference (VALA_CODE_VISITOR (self), referent_type);
		(referent_type == NULL ? NULL : (referent_type = (g_object_unref (referent_type), NULL)));
	}
	/* check for array */
	if (vala_type_reference_get_array_rank (type) > 0) {
		ValaTypeReference* element_type;
		element_type = vala_type_reference_new ();
		vala_type_reference_set_data_type (element_type, vala_type_reference_get_data_type (type));
		vala_type_reference_set_type_parameter (element_type, vala_type_reference_get_type_parameter (type));
		{
			GeeList* type_arg_collection;
			GeeIterator* type_arg_it;
			type_arg_collection = vala_type_reference_get_type_arguments (type);
			type_arg_it = gee_iterable_iterator (GEE_ITERABLE (type_arg_collection));
			while (gee_iterator_next (type_arg_it)) {
				ValaTypeReference* type_arg;
				type_arg = gee_iterator_get (type_arg_it);
				{
					vala_type_reference_add_type_argument (element_type, type_arg);
					(type_arg == NULL ? NULL : (type_arg = (g_object_unref (type_arg), NULL)));
				}
			}
			(type_arg_collection == NULL ? NULL : (type_arg_collection = (g_object_unref (type_arg_collection), NULL)));
			(type_arg_it == NULL ? NULL : (type_arg_it = (g_object_unref (type_arg_it), NULL)));
		}
		vala_type_reference_remove_all_type_arguments (type);
		if (vala_type_reference_get_data_type (type) != NULL) {
			ValaArray* __temp59;
			if (vala_data_type_is_reference_type (vala_type_reference_get_data_type (type))) {
				vala_type_reference_set_takes_ownership (element_type, vala_type_reference_get_takes_ownership (type));
			}
			__temp59 = NULL;
			vala_type_reference_set_data_type (type, VALA_DATA_TYPE ((__temp59 = vala_data_type_get_array (vala_type_reference_get_data_type (element_type), vala_type_reference_get_array_rank (type)))));
			(__temp59 = (g_object_unref (__temp59), NULL));
		} else {
			ValaArray* __temp60;
			vala_type_reference_set_takes_ownership (element_type, vala_type_reference_get_takes_ownership (type));
			__temp60 = NULL;
			vala_type_reference_set_data_type (type, VALA_DATA_TYPE ((__temp60 = vala_type_parameter_get_array (vala_type_reference_get_type_parameter (element_type), vala_type_reference_get_array_rank (type)))));
			(__temp60 = (g_object_unref (__temp60), NULL));
			vala_type_reference_set_type_parameter (type, NULL);
		}
		vala_type_reference_add_type_argument (type, element_type);
		(element_type == NULL ? NULL : (element_type = (g_object_unref (element_type), NULL)));
	}
	if (vala_type_reference_get_data_type (type) != NULL && !vala_data_type_is_reference_type (vala_type_reference_get_data_type (type))) {
		/* reset takes_ownership and transfers_ownership of
		 * value-types for contexts where types are ref by
		 * default (field declarations and method return types)
		 */
		vala_type_reference_set_takes_ownership (type, FALSE);
		vala_type_reference_set_transfers_ownership (type, FALSE);
	}
}


static void vala_symbol_resolver_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_THROW_STATEMENT (stmt));
	vala_code_node_accept_children (VALA_CODE_NODE (stmt), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_TRY_STATEMENT (stmt));
	vala_code_node_accept_children (VALA_CODE_NODE (stmt), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause)
{
	ValaSymbolResolver * self;
	self = ((ValaSymbolResolver*) base);
	g_return_if_fail (VALA_IS_CATCH_CLAUSE (clause));
	vala_code_node_accept_children (VALA_CODE_NODE (clause), VALA_CODE_VISITOR (self));
}


static void vala_symbol_resolver_class_init (ValaSymbolResolverClass * klass)
{
	vala_symbol_resolver_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaSymbolResolverPrivate));
	G_OBJECT_CLASS (klass)->dispose = vala_symbol_resolver_dispose;
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_symbol_resolver_real_visit_source_file;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_symbol_resolver_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_symbol_resolver_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_symbol_resolver_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_symbol_resolver_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_callback = vala_symbol_resolver_real_visit_callback;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = vala_symbol_resolver_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_symbol_resolver_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = vala_symbol_resolver_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = vala_symbol_resolver_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_formal_parameter = vala_symbol_resolver_real_visit_formal_parameter;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = vala_symbol_resolver_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property_accessor = vala_symbol_resolver_real_visit_property_accessor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = vala_symbol_resolver_real_visit_signal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constructor = vala_symbol_resolver_real_visit_constructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_destructor = vala_symbol_resolver_real_visit_destructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace_reference = vala_symbol_resolver_real_visit_namespace_reference;
	VALA_CODE_VISITOR_CLASS (klass)->visit_type_reference = vala_symbol_resolver_real_visit_type_reference;
	VALA_CODE_VISITOR_CLASS (klass)->visit_throw_statement = vala_symbol_resolver_real_visit_throw_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_try_statement = vala_symbol_resolver_real_visit_try_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_catch_clause = vala_symbol_resolver_real_visit_catch_clause;
}


static void vala_symbol_resolver_init (ValaSymbolResolver * self)
{
	self->priv = VALA_SYMBOL_RESOLVER_GET_PRIVATE (self);
}


static void vala_symbol_resolver_dispose (GObject * obj)
{
	ValaSymbolResolver * self;
	ValaSymbolResolverClass * klass;
	GObjectClass * parent_class;
	self = VALA_SYMBOL_RESOLVER (obj);
	(self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (g_object_unref (self->priv->root_symbol), NULL)));
	(self->priv->current_scope == NULL ? NULL : (self->priv->current_scope = (g_object_unref (self->priv->current_scope), NULL)));
	(self->priv->current_using_directives == NULL ? NULL : (self->priv->current_using_directives = (g_object_unref (self->priv->current_using_directives), NULL)));
	(self->priv->object_class == NULL ? NULL : (self->priv->object_class = (g_object_unref (self->priv->object_class), NULL)));
	klass = VALA_SYMBOL_RESOLVER_CLASS (g_type_class_peek (VALA_TYPE_SYMBOL_RESOLVER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_symbol_resolver_get_type (void)
{
	static GType vala_symbol_resolver_type_id = 0;
	if (G_UNLIKELY (vala_symbol_resolver_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSymbolResolverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_symbol_resolver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSymbolResolver), 0, (GInstanceInitFunc) vala_symbol_resolver_init };
		vala_symbol_resolver_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaSymbolResolver", &g_define_type_info, 0);
	}
	return vala_symbol_resolver_type_id;
}




