/* valasymbol.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALASYMBOL_H__
#define __VALASYMBOL_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee/collection.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

/**
 * Represents a node in the symbol tree.
 */
struct _ValaSymbol {
	ValaCodeNode parent;
	ValaSymbolPrivate * priv;
};
struct _ValaSymbolClass {
	ValaCodeNodeClass parent;
	char* (*get_cprefix) (ValaSymbol* self);
	char* (*get_lower_case_cname) (ValaSymbol* self, const char* infix);
	char* (*get_lower_case_cprefix) (ValaSymbol* self);
	GeeCollection* (*get_cheader_filenames) (ValaSymbol* self);
};

char* vala_symbol_get_full_name (ValaSymbol* self);
char* vala_symbol_get_cprefix (ValaSymbol* self);
char* vala_symbol_get_lower_case_cname (ValaSymbol* self, const char* infix);
char* vala_symbol_get_lower_case_cprefix (ValaSymbol* self);
GeeCollection* vala_symbol_get_cheader_filenames (ValaSymbol* self);
char* vala_symbol_camel_case_to_lower_case (const char* camel_case);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
ValaScope* vala_symbol_get_owner (ValaSymbol* self);
void vala_symbol_set_owner (ValaSymbol* self, ValaScope* value);
char* vala_symbol_get_name (ValaSymbol* self);
void vala_symbol_set_name (ValaSymbol* self, const char* value);
gboolean vala_symbol_get_active (ValaSymbol* self);
void vala_symbol_set_active (ValaSymbol* self, gboolean value);
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
GType vala_symbol_get_type (void);

G_END_DECLS

#endif
