/* valaexpression.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valaexpression.h"
#include <vala/valatypereference.h>
#include <vala/valasymbol.h>
#include <vala/valaexpression.h>

struct _ValaExpressionPrivate {
	ValaTypeReference* _static_type;
	ValaTypeReference* _expected_type;
	ValaSymbol* _symbol_reference;
	gboolean _ref_leaked;
	gboolean _ref_missing;
	gboolean _ref_sink;
	gboolean _can_fail;
};
#define VALA_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_EXPRESSION, ValaExpressionPrivate))
enum  {
	VALA_EXPRESSION_DUMMY_PROPERTY,
	VALA_EXPRESSION_STATIC_TYPE,
	VALA_EXPRESSION_EXPECTED_TYPE,
	VALA_EXPRESSION_SYMBOL_REFERENCE,
	VALA_EXPRESSION_REF_LEAKED,
	VALA_EXPRESSION_REF_MISSING,
	VALA_EXPRESSION_REF_SINK,
	VALA_EXPRESSION_CAN_FAIL
};
static gpointer vala_expression_parent_class = NULL;
static void vala_expression_dispose (GObject * obj);


ValaTypeReference* vala_expression_get_static_type (ValaExpression* self)
{
	g_return_val_if_fail (VALA_IS_EXPRESSION (self), NULL);
	return self->priv->_static_type;
}


void vala_expression_set_static_type (ValaExpression* self, ValaTypeReference* value)
{
	ValaTypeReference* __temp2;
	ValaTypeReference* __temp1;
	g_return_if_fail (VALA_IS_EXPRESSION (self));
	__temp2 = NULL;
	__temp1 = NULL;
	self->priv->_static_type = (__temp2 = (__temp1 = value, (__temp1 == NULL ? NULL : g_object_ref (__temp1))), (self->priv->_static_type == NULL ? NULL : (self->priv->_static_type = (g_object_unref (self->priv->_static_type), NULL))), __temp2);
}


ValaTypeReference* vala_expression_get_expected_type (ValaExpression* self)
{
	g_return_val_if_fail (VALA_IS_EXPRESSION (self), NULL);
	return self->priv->_expected_type;
}


void vala_expression_set_expected_type (ValaExpression* self, ValaTypeReference* value)
{
	ValaTypeReference* __temp5;
	ValaTypeReference* __temp4;
	g_return_if_fail (VALA_IS_EXPRESSION (self));
	__temp5 = NULL;
	__temp4 = NULL;
	self->priv->_expected_type = (__temp5 = (__temp4 = value, (__temp4 == NULL ? NULL : g_object_ref (__temp4))), (self->priv->_expected_type == NULL ? NULL : (self->priv->_expected_type = (g_object_unref (self->priv->_expected_type), NULL))), __temp5);
}


ValaSymbol* vala_expression_get_symbol_reference (ValaExpression* self)
{
	g_return_val_if_fail (VALA_IS_EXPRESSION (self), NULL);
	return self->priv->_symbol_reference;
}


void vala_expression_set_symbol_reference (ValaExpression* self, ValaSymbol* value)
{
	g_return_if_fail (VALA_IS_EXPRESSION (self));
	self->priv->_symbol_reference = value;
}


gboolean vala_expression_get_ref_leaked (ValaExpression* self)
{
	g_return_val_if_fail (VALA_IS_EXPRESSION (self), FALSE);
	return self->priv->_ref_leaked;
}


void vala_expression_set_ref_leaked (ValaExpression* self, gboolean value)
{
	g_return_if_fail (VALA_IS_EXPRESSION (self));
	self->priv->_ref_leaked = value;
}


gboolean vala_expression_get_ref_missing (ValaExpression* self)
{
	g_return_val_if_fail (VALA_IS_EXPRESSION (self), FALSE);
	return self->priv->_ref_missing;
}


void vala_expression_set_ref_missing (ValaExpression* self, gboolean value)
{
	g_return_if_fail (VALA_IS_EXPRESSION (self));
	self->priv->_ref_missing = value;
}


gboolean vala_expression_get_ref_sink (ValaExpression* self)
{
	g_return_val_if_fail (VALA_IS_EXPRESSION (self), FALSE);
	return self->priv->_ref_sink;
}


void vala_expression_set_ref_sink (ValaExpression* self, gboolean value)
{
	g_return_if_fail (VALA_IS_EXPRESSION (self));
	self->priv->_ref_sink = value;
}


gboolean vala_expression_get_can_fail (ValaExpression* self)
{
	g_return_val_if_fail (VALA_IS_EXPRESSION (self), FALSE);
	return self->priv->_can_fail;
}


void vala_expression_set_can_fail (ValaExpression* self, gboolean value)
{
	g_return_if_fail (VALA_IS_EXPRESSION (self));
	self->priv->_can_fail = value;
}


static void vala_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaExpression * self;
	self = VALA_EXPRESSION (object);
	switch (property_id) {
		case VALA_EXPRESSION_STATIC_TYPE:
		g_value_set_object (value, vala_expression_get_static_type (self));
		break;
		case VALA_EXPRESSION_EXPECTED_TYPE:
		g_value_set_object (value, vala_expression_get_expected_type (self));
		break;
		case VALA_EXPRESSION_SYMBOL_REFERENCE:
		g_value_set_object (value, vala_expression_get_symbol_reference (self));
		break;
		case VALA_EXPRESSION_REF_LEAKED:
		g_value_set_boolean (value, vala_expression_get_ref_leaked (self));
		break;
		case VALA_EXPRESSION_REF_MISSING:
		g_value_set_boolean (value, vala_expression_get_ref_missing (self));
		break;
		case VALA_EXPRESSION_REF_SINK:
		g_value_set_boolean (value, vala_expression_get_ref_sink (self));
		break;
		case VALA_EXPRESSION_CAN_FAIL:
		g_value_set_boolean (value, vala_expression_get_can_fail (self));
		break;
	}
}


static void vala_expression_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaExpression * self;
	self = VALA_EXPRESSION (object);
	switch (property_id) {
		case VALA_EXPRESSION_STATIC_TYPE:
		vala_expression_set_static_type (self, g_value_get_object (value));
		break;
		case VALA_EXPRESSION_EXPECTED_TYPE:
		vala_expression_set_expected_type (self, g_value_get_object (value));
		break;
		case VALA_EXPRESSION_SYMBOL_REFERENCE:
		vala_expression_set_symbol_reference (self, g_value_get_object (value));
		break;
		case VALA_EXPRESSION_REF_LEAKED:
		vala_expression_set_ref_leaked (self, g_value_get_boolean (value));
		break;
		case VALA_EXPRESSION_REF_MISSING:
		vala_expression_set_ref_missing (self, g_value_get_boolean (value));
		break;
		case VALA_EXPRESSION_REF_SINK:
		vala_expression_set_ref_sink (self, g_value_get_boolean (value));
		break;
		case VALA_EXPRESSION_CAN_FAIL:
		vala_expression_set_can_fail (self, g_value_get_boolean (value));
		break;
	}
}


static void vala_expression_class_init (ValaExpressionClass * klass)
{
	vala_expression_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaExpressionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_expression_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_expression_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_expression_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_EXPRESSION_STATIC_TYPE, g_param_spec_object ("static-type", "foo", "bar", VALA_TYPE_TYPE_REFERENCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_EXPRESSION_EXPECTED_TYPE, g_param_spec_object ("expected-type", "foo", "bar", VALA_TYPE_TYPE_REFERENCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_EXPRESSION_SYMBOL_REFERENCE, g_param_spec_object ("symbol-reference", "foo", "bar", VALA_TYPE_SYMBOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_EXPRESSION_REF_LEAKED, g_param_spec_boolean ("ref-leaked", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_EXPRESSION_REF_MISSING, g_param_spec_boolean ("ref-missing", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_EXPRESSION_REF_SINK, g_param_spec_boolean ("ref-sink", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_EXPRESSION_CAN_FAIL, g_param_spec_boolean ("can-fail", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_expression_init (ValaExpression * self)
{
	self->priv = VALA_EXPRESSION_GET_PRIVATE (self);
	self->temp_vars = gee_array_list_new (g_object_ref, g_object_unref, g_direct_equal);
}


static void vala_expression_dispose (GObject * obj)
{
	ValaExpression * self;
	ValaExpressionClass * klass;
	GObjectClass * parent_class;
	self = VALA_EXPRESSION (obj);
	(self->priv->_static_type == NULL ? NULL : (self->priv->_static_type = (g_object_unref (self->priv->_static_type), NULL)));
	(self->priv->_expected_type == NULL ? NULL : (self->priv->_expected_type = (g_object_unref (self->priv->_expected_type), NULL)));
	(self->temp_vars == NULL ? NULL : (self->temp_vars = (g_object_unref (self->temp_vars), NULL)));
	klass = VALA_EXPRESSION_CLASS (g_type_class_peek (VALA_TYPE_EXPRESSION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_expression_get_type (void)
{
	static GType vala_expression_type_id = 0;
	if (G_UNLIKELY (vala_expression_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaExpression), 0, (GInstanceInitFunc) vala_expression_init };
		vala_expression_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaExpression", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_expression_type_id;
}




