/* valadeclarationstatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALADECLARATIONSTATEMENT_H__
#define __VALADECLARATIONSTATEMENT_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodenode.h>
#include <vala/valastatement.h>

G_BEGIN_DECLS


#define VALA_TYPE_DECLARATION_STATEMENT (vala_declaration_statement_get_type ())
#define VALA_DECLARATION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatement))
#define VALA_DECLARATION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementClass))
#define VALA_IS_DECLARATION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DECLARATION_STATEMENT))
#define VALA_IS_DECLARATION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DECLARATION_STATEMENT))
#define VALA_DECLARATION_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementClass))

typedef struct _ValaDeclarationStatementPrivate ValaDeclarationStatementPrivate;

/**
 * Represents a local variable declaration statement in the source code.
 */
struct _ValaDeclarationStatement {
	ValaCodeNode parent;
	ValaDeclarationStatementPrivate * priv;
};
struct _ValaDeclarationStatementClass {
	ValaCodeNodeClass parent;
};

ValaDeclarationStatement* vala_declaration_statement_new (ValaLocalVariableDeclaration* decl, ValaSourceReference* source);
ValaLocalVariableDeclaration* vala_declaration_statement_get_declaration (ValaDeclarationStatement* self);
void vala_declaration_statement_set_declaration (ValaDeclarationStatement* self, ValaLocalVariableDeclaration* value);
GType vala_declaration_statement_get_type (void);

G_END_DECLS

#endif
