/* valaccodecasestatement.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALACCODECASESTATEMENT_H__
#define __VALACCODECASESTATEMENT_H__

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_CASE_STATEMENT (vala_ccode_case_statement_get_type ())
#define VALA_CCODE_CASE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CASE_STATEMENT, ValaCCodeCaseStatement))
#define VALA_CCODE_CASE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CASE_STATEMENT, ValaCCodeCaseStatementClass))
#define VALA_IS_CCODE_CASE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CASE_STATEMENT))
#define VALA_IS_CCODE_CASE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CASE_STATEMENT))
#define VALA_CCODE_CASE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CASE_STATEMENT, ValaCCodeCaseStatementClass))

typedef struct _ValaCCodeCaseStatement ValaCCodeCaseStatement;
typedef struct _ValaCCodeCaseStatementClass ValaCCodeCaseStatementClass;
typedef struct _ValaCCodeCaseStatementPrivate ValaCCodeCaseStatementPrivate;

/**
 * Represents a case block in a switch statement in C code.
 */
struct _ValaCCodeCaseStatement {
	ValaCCodeStatement parent;
	ValaCCodeCaseStatementPrivate * priv;
};
struct _ValaCCodeCaseStatementClass {
	ValaCCodeStatementClass parent;
};

ValaCCodeCaseStatement* vala_ccode_case_statement_new (ValaCCodeExpression* expression);
void vala_ccode_case_statement_add_statement (ValaCCodeCaseStatement* self, ValaCCodeStatement* stmt);
ValaCCodeExpression* vala_ccode_case_statement_get_expression (ValaCCodeCaseStatement* self);
void vala_ccode_case_statement_set_expression (ValaCCodeCaseStatement* self, ValaCCodeExpression* value);
GType vala_ccode_case_statement_get_type (void);

G_END_DECLS

#endif
