/* valacatchclause.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valacatchclause.h"
#include <vala/valatypereference.h>
#include <vala/valablock.h>
#include <vala/valavariabledeclarator.h>
#include <vala/valasourcereference.h>
#include <vala/valacatchclause.h>
#include <vala/valacodevisitor.h>

struct _ValaCatchClausePrivate {
	ValaTypeReference* _type_reference;
	char* _variable_name;
	ValaBlock* _body;
	ValaVariableDeclarator* _variable_declarator;
};
#define VALA_CATCH_CLAUSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CATCH_CLAUSE, ValaCatchClausePrivate))
enum  {
	VALA_CATCH_CLAUSE_DUMMY_PROPERTY,
	VALA_CATCH_CLAUSE_TYPE_REFERENCE,
	VALA_CATCH_CLAUSE_VARIABLE_NAME,
	VALA_CATCH_CLAUSE_BODY,
	VALA_CATCH_CLAUSE_VARIABLE_DECLARATOR
};
static void vala_catch_clause_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_catch_clause_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_catch_clause_parent_class = NULL;
static void vala_catch_clause_dispose (GObject * obj);


/**
 * Creates a new catch clause.
 *
 * @param type_reference   error type
 * @param variable_name    error variable name
 * @param body             error handler body
 * @param source_reference reference to source code
 * @return                 newly created catch clause
 */
ValaCatchClause* vala_catch_clause_new (ValaTypeReference* type_reference, const char* variable_name, ValaBlock* body, ValaSourceReference* source_reference)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaCatchClause * self;
	g_return_val_if_fail (type_reference == NULL || VALA_IS_TYPE_REFERENCE (type_reference), NULL);
	g_return_val_if_fail (body == NULL || VALA_IS_BLOCK (body), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	__params = g_new0 (GParameter, 4);
	__params_it = __params;
	(__params_it->name = "type-reference", g_value_init (&__params_it->value, VALA_TYPE_TYPE_REFERENCE), g_value_set_object (&__params_it->value, type_reference), __params_it++);
	(__params_it->name = "variable-name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, variable_name), __params_it++);
	(__params_it->name = "body", g_value_init (&__params_it->value, VALA_TYPE_BLOCK), g_value_set_object (&__params_it->value, body), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source_reference), __params_it++);
	self = g_object_newv (VALA_TYPE_CATCH_CLAUSE, __params_it - __params, __params);
	return self;
}


static void vala_catch_clause_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaCatchClause * self;
	self = VALA_CATCH_CLAUSE (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_catch_clause (visitor, self);
}


static void vala_catch_clause_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaCatchClause * self;
	self = VALA_CATCH_CLAUSE (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_catch_clause_get_type_reference (self)), visitor);
	vala_code_node_accept (VALA_CODE_NODE (vala_catch_clause_get_body (self)), visitor);
}


ValaTypeReference* vala_catch_clause_get_type_reference (ValaCatchClause* self)
{
	g_return_val_if_fail (VALA_IS_CATCH_CLAUSE (self), NULL);
	return self->priv->_type_reference;
}


void vala_catch_clause_set_type_reference (ValaCatchClause* self, ValaTypeReference* value)
{
	ValaTypeReference* __temp2;
	ValaTypeReference* __temp1;
	g_return_if_fail (VALA_IS_CATCH_CLAUSE (self));
	__temp2 = NULL;
	__temp1 = NULL;
	self->priv->_type_reference = (__temp2 = (__temp1 = value, (__temp1 == NULL ? NULL : g_object_ref (__temp1))), (self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL))), __temp2);
}


char* vala_catch_clause_get_variable_name (ValaCatchClause* self)
{
	g_return_val_if_fail (VALA_IS_CATCH_CLAUSE (self), NULL);
	return self->priv->_variable_name;
}


void vala_catch_clause_set_variable_name (ValaCatchClause* self, const char* value)
{
	char* __temp5;
	const char* __temp4;
	g_return_if_fail (VALA_IS_CATCH_CLAUSE (self));
	__temp5 = NULL;
	__temp4 = NULL;
	self->priv->_variable_name = (__temp5 = (__temp4 = value, (__temp4 == NULL ? NULL : g_strdup (__temp4))), (self->priv->_variable_name = (g_free (self->priv->_variable_name), NULL)), __temp5);
}


ValaBlock* vala_catch_clause_get_body (ValaCatchClause* self)
{
	g_return_val_if_fail (VALA_IS_CATCH_CLAUSE (self), NULL);
	return self->priv->_body;
}


void vala_catch_clause_set_body (ValaCatchClause* self, ValaBlock* value)
{
	ValaBlock* __temp8;
	ValaBlock* __temp7;
	g_return_if_fail (VALA_IS_CATCH_CLAUSE (self));
	__temp8 = NULL;
	__temp7 = NULL;
	self->priv->_body = (__temp8 = (__temp7 = value, (__temp7 == NULL ? NULL : g_object_ref (__temp7))), (self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL))), __temp8);
}


ValaVariableDeclarator* vala_catch_clause_get_variable_declarator (ValaCatchClause* self)
{
	g_return_val_if_fail (VALA_IS_CATCH_CLAUSE (self), NULL);
	return self->priv->_variable_declarator;
}


void vala_catch_clause_set_variable_declarator (ValaCatchClause* self, ValaVariableDeclarator* value)
{
	ValaVariableDeclarator* __temp11;
	ValaVariableDeclarator* __temp10;
	g_return_if_fail (VALA_IS_CATCH_CLAUSE (self));
	__temp11 = NULL;
	__temp10 = NULL;
	self->priv->_variable_declarator = (__temp11 = (__temp10 = value, (__temp10 == NULL ? NULL : g_object_ref (__temp10))), (self->priv->_variable_declarator == NULL ? NULL : (self->priv->_variable_declarator = (g_object_unref (self->priv->_variable_declarator), NULL))), __temp11);
}


static void vala_catch_clause_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCatchClause * self;
	self = VALA_CATCH_CLAUSE (object);
	switch (property_id) {
		case VALA_CATCH_CLAUSE_TYPE_REFERENCE:
		g_value_set_object (value, vala_catch_clause_get_type_reference (self));
		break;
		case VALA_CATCH_CLAUSE_VARIABLE_NAME:
		g_value_set_string (value, vala_catch_clause_get_variable_name (self));
		break;
		case VALA_CATCH_CLAUSE_BODY:
		g_value_set_object (value, vala_catch_clause_get_body (self));
		break;
		case VALA_CATCH_CLAUSE_VARIABLE_DECLARATOR:
		g_value_set_object (value, vala_catch_clause_get_variable_declarator (self));
		break;
	}
}


static void vala_catch_clause_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCatchClause * self;
	self = VALA_CATCH_CLAUSE (object);
	switch (property_id) {
		case VALA_CATCH_CLAUSE_TYPE_REFERENCE:
		vala_catch_clause_set_type_reference (self, g_value_get_object (value));
		break;
		case VALA_CATCH_CLAUSE_VARIABLE_NAME:
		vala_catch_clause_set_variable_name (self, g_value_get_string (value));
		break;
		case VALA_CATCH_CLAUSE_BODY:
		vala_catch_clause_set_body (self, g_value_get_object (value));
		break;
		case VALA_CATCH_CLAUSE_VARIABLE_DECLARATOR:
		vala_catch_clause_set_variable_declarator (self, g_value_get_object (value));
		break;
	}
}


static void vala_catch_clause_class_init (ValaCatchClauseClass * klass)
{
	vala_catch_clause_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCatchClausePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_catch_clause_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_catch_clause_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_catch_clause_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_catch_clause_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_catch_clause_real_accept_children;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CATCH_CLAUSE_TYPE_REFERENCE, g_param_spec_object ("type-reference", "foo", "bar", VALA_TYPE_TYPE_REFERENCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CATCH_CLAUSE_VARIABLE_NAME, g_param_spec_string ("variable-name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CATCH_CLAUSE_BODY, g_param_spec_object ("body", "foo", "bar", VALA_TYPE_BLOCK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CATCH_CLAUSE_VARIABLE_DECLARATOR, g_param_spec_object ("variable-declarator", "foo", "bar", VALA_TYPE_VARIABLE_DECLARATOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_catch_clause_init (ValaCatchClause * self)
{
	self->priv = VALA_CATCH_CLAUSE_GET_PRIVATE (self);
}


static void vala_catch_clause_dispose (GObject * obj)
{
	ValaCatchClause * self;
	ValaCatchClauseClass * klass;
	GObjectClass * parent_class;
	self = VALA_CATCH_CLAUSE (obj);
	(self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL)));
	(self->priv->_variable_name = (g_free (self->priv->_variable_name), NULL));
	(self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL)));
	(self->priv->_variable_declarator == NULL ? NULL : (self->priv->_variable_declarator = (g_object_unref (self->priv->_variable_declarator), NULL)));
	klass = VALA_CATCH_CLAUSE_CLASS (g_type_class_peek (VALA_TYPE_CATCH_CLAUSE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_catch_clause_get_type ()
{
	static GType vala_catch_clause_type_id = 0;
	if (G_UNLIKELY (vala_catch_clause_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCatchClauseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_catch_clause_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCatchClause), 0, (GInstanceInitFunc) vala_catch_clause_init };
		vala_catch_clause_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaCatchClause", &g_define_type_info, 0);
	}
	return vala_catch_clause_type_id;
}




