/* valaccodefunctioncall.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaccodefunctioncall.h"
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodenode.h>

struct _ValaCCodeFunctionCallPrivate {
	ValaCCodeExpression* _call;
	GList* arguments;
};
#define VALA_CCODE_FUNCTION_CALL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCallPrivate))
enum  {
	VALA_CCODE_FUNCTION_CALL_DUMMY_PROPERTY,
	VALA_CCODE_FUNCTION_CALL_CALL
};
static void vala_ccode_function_call_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_function_call_parent_class = NULL;
static void vala_ccode_function_call_dispose (GObject * obj);


ValaCCodeFunctionCall* vala_ccode_function_call_new (ValaCCodeExpression* call)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeFunctionCall * self;
	g_return_val_if_fail (call == NULL || VALA_IS_CCODE_EXPRESSION (call), NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	(__params_it->name = "call", g_value_init (&__params_it->value, VALA_TYPE_CCODE_EXPRESSION), g_value_set_object (&__params_it->value, call), __params_it++);
	self = g_object_newv (VALA_TYPE_CCODE_FUNCTION_CALL, __params_it - __params, __params);
	return self;
}


/**
 * Appends the specified expression to the list of arguments.
 *
 * @param expr a C code expression
 */
void vala_ccode_function_call_add_argument (ValaCCodeFunctionCall* self, ValaCCodeExpression* expr)
{
	g_return_if_fail (VALA_IS_CCODE_FUNCTION_CALL (self));
	g_return_if_fail (VALA_IS_CCODE_EXPRESSION (expr));
	self->priv->arguments = g_list_append (self->priv->arguments, g_object_ref (expr));
}


/**
 * Returns a copy of the list of arguments.
 *
 * @return list of arguments
 */
GList* vala_ccode_function_call_get_arguments (ValaCCodeFunctionCall* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_FUNCTION_CALL (self), NULL);
	return g_list_copy (self->priv->arguments);
}


static void vala_ccode_function_call_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeFunctionCall * self;
	gboolean first;
	self = VALA_CCODE_FUNCTION_CALL (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_node_write (VALA_CCODE_NODE (vala_ccode_function_call_get_call (self)), writer);
	vala_ccode_writer_write_string (writer, " (");
	first = TRUE;
	{
		GList* __temp1;
		GList* expr_it;
		__temp1 = NULL;
		__temp1 = self->priv->arguments;
		for (expr_it = __temp1; expr_it != NULL; expr_it = expr_it->next) {
			ValaCCodeExpression* expr;
			expr = expr_it->data;
			{
				if (!first) {
					vala_ccode_writer_write_string (writer, ", ");
				} else {
					first = FALSE;
				}
				if (expr != NULL) {
					vala_ccode_node_write (VALA_CCODE_NODE (expr), writer);
				}
			}
		}
	}
	vala_ccode_writer_write_string (writer, ")");
}


ValaCCodeExpression* vala_ccode_function_call_get_call (ValaCCodeFunctionCall* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_FUNCTION_CALL (self), NULL);
	return self->priv->_call;
}


void vala_ccode_function_call_set_call (ValaCCodeFunctionCall* self, ValaCCodeExpression* value)
{
	ValaCCodeExpression* __temp4;
	ValaCCodeExpression* __temp3;
	g_return_if_fail (VALA_IS_CCODE_FUNCTION_CALL (self));
	__temp4 = NULL;
	__temp3 = NULL;
	self->priv->_call = (__temp4 = (__temp3 = value, (__temp3 == NULL ? NULL : g_object_ref (__temp3))), (self->priv->_call == NULL ? NULL : (self->priv->_call = (g_object_unref (self->priv->_call), NULL))), __temp4);
}


static void vala_ccode_function_call_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeFunctionCall * self;
	self = VALA_CCODE_FUNCTION_CALL (object);
	switch (property_id) {
		case VALA_CCODE_FUNCTION_CALL_CALL:
		g_value_set_object (value, vala_ccode_function_call_get_call (self));
		break;
	}
}


static void vala_ccode_function_call_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeFunctionCall * self;
	self = VALA_CCODE_FUNCTION_CALL (object);
	switch (property_id) {
		case VALA_CCODE_FUNCTION_CALL_CALL:
		vala_ccode_function_call_set_call (self, g_value_get_object (value));
		break;
	}
}


static void vala_ccode_function_call_class_init (ValaCCodeFunctionCallClass * klass)
{
	vala_ccode_function_call_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeFunctionCallPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_function_call_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_function_call_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_function_call_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_function_call_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_FUNCTION_CALL_CALL, g_param_spec_object ("call", "foo", "bar", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_function_call_init (ValaCCodeFunctionCall * self)
{
	self->priv = VALA_CCODE_FUNCTION_CALL_GET_PRIVATE (self);
}


static void vala_ccode_function_call_dispose (GObject * obj)
{
	ValaCCodeFunctionCall * self;
	ValaCCodeFunctionCallClass * klass;
	GObjectClass * parent_class;
	self = VALA_CCODE_FUNCTION_CALL (obj);
	(self->priv->_call == NULL ? NULL : (self->priv->_call = (g_object_unref (self->priv->_call), NULL)));
	(self->priv->arguments == NULL ? NULL : (self->priv->arguments = (g_list_foreach (self->priv->arguments, (GFunc) g_object_unref, NULL), g_list_free (self->priv->arguments), NULL)));
	klass = VALA_CCODE_FUNCTION_CALL_CLASS (g_type_class_peek (VALA_TYPE_CCODE_FUNCTION_CALL));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_function_call_get_type ()
{
	static GType vala_ccode_function_call_type_id = 0;
	if (G_UNLIKELY (vala_ccode_function_call_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeFunctionCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_function_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeFunctionCall), 0, (GInstanceInitFunc) vala_ccode_function_call_init };
		vala_ccode_function_call_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeFunctionCall", &g_define_type_info, 0);
	}
	return vala_ccode_function_call_type_id;
}




