/* valaproperty.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALAPROPERTY_H__
#define __VALAPROPERTY_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valamember.h>
#include <vala/valalockable.h>
#include <vala/valamemberaccessibility.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaPropertyPrivate ValaPropertyPrivate;

/**
 * Represents a property declaration in the source code.
 */
struct _ValaProperty {
	ValaMember parent;
	ValaPropertyPrivate * priv;
};
struct _ValaPropertyClass {
	ValaMemberClass parent;
};

ValaProperty* vala_property_new (const char* _name, ValaTypeReference* type, ValaPropertyAccessor* _get_accessor, ValaPropertyAccessor* _set_accessor, ValaSourceReference* source);
char* vala_property_get_upper_case_cname (ValaProperty* self);
ValaCCodeConstant* vala_property_get_canonical_cconstant (ValaProperty* self);
void vala_property_process_attributes (ValaProperty* self);
gboolean vala_property_equals (ValaProperty* self, ValaProperty* prop2);
char* vala_property_get_name (ValaProperty* self);
void vala_property_set_name (ValaProperty* self, const char* value);
ValaTypeReference* vala_property_get_type_reference (ValaProperty* self);
void vala_property_set_type_reference (ValaProperty* self, ValaTypeReference* value);
ValaPropertyAccessor* vala_property_get_get_accessor (ValaProperty* self);
void vala_property_set_get_accessor (ValaProperty* self, ValaPropertyAccessor* value);
ValaPropertyAccessor* vala_property_get_set_accessor (ValaProperty* self);
void vala_property_set_set_accessor (ValaProperty* self, ValaPropertyAccessor* value);
ValaMemberAccessibility vala_property_get_access (ValaProperty* self);
void vala_property_set_access (ValaProperty* self, ValaMemberAccessibility value);
ValaFormalParameter* vala_property_get_this_parameter (ValaProperty* self);
void vala_property_set_this_parameter (ValaProperty* self, ValaFormalParameter* value);
gboolean vala_property_get_no_accessor_method (ValaProperty* self);
void vala_property_set_no_accessor_method (ValaProperty* self, gboolean value);
gboolean vala_property_get_interface_only (ValaProperty* self);
void vala_property_set_interface_only (ValaProperty* self, gboolean value);
gboolean vala_property_get_is_abstract (ValaProperty* self);
void vala_property_set_is_abstract (ValaProperty* self, gboolean value);
gboolean vala_property_get_is_virtual (ValaProperty* self);
void vala_property_set_is_virtual (ValaProperty* self, gboolean value);
gboolean vala_property_get_overrides (ValaProperty* self);
void vala_property_set_overrides (ValaProperty* self, gboolean value);
ValaProperty* vala_property_get_base_property (ValaProperty* self);
void vala_property_set_base_property (ValaProperty* self, ValaProperty* value);
ValaProperty* vala_property_get_base_interface_property (ValaProperty* self);
void vala_property_set_base_interface_property (ValaProperty* self, ValaProperty* value);
GType vala_property_get_type ();

G_END_DECLS

#endif
