/* valainterface.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALAINTERFACE_H__
#define __VALAINTERFACE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valadatatype.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterfacePrivate ValaInterfacePrivate;

/**
 * Represents a class declaration in the source code.
 */
struct _ValaInterface {
	ValaDataType parent;
	ValaInterfacePrivate * priv;
};
struct _ValaInterfaceClass {
	ValaDataTypeClass parent;
};

ValaInterface* vala_interface_new (const char* _name, ValaSourceReference* source);
void vala_interface_add_type_parameter (ValaInterface* self, ValaTypeParameter* p);
void vala_interface_add_prerequisite (ValaInterface* self, ValaTypeReference* type);
GList* vala_interface_get_prerequisites (ValaInterface* self);
void vala_interface_add_method (ValaInterface* self, ValaMethod* m);
GList* vala_interface_get_methods (ValaInterface* self);
void vala_interface_add_property (ValaInterface* self, ValaProperty* prop);
GList* vala_interface_get_properties (ValaInterface* self);
void vala_interface_add_signal (ValaInterface* self, ValaSignal* sig);
GList* vala_interface_get_signals (ValaInterface* self);
char* vala_interface_get_lower_case_csuffix (ValaInterface* self);
void vala_interface_set_lower_case_csuffix (ValaInterface* self, const char* csuffix);
void vala_interface_process_attributes (ValaInterface* self);
char* vala_interface_get_type_cname (ValaInterface* self);
void vala_interface_set_type_cname (ValaInterface* self, const char* type_cname);
gboolean vala_interface_get_is_static (ValaInterface* self);
void vala_interface_set_is_static (ValaInterface* self, gboolean value);
GType vala_interface_get_type ();

G_END_DECLS

#endif
