/* valaccodefragment.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaccodefragment.h"
#include <ccode/valaccodefragment.h>

struct _ValaCCodeFragmentPrivate {
	GList* children;
};
#define VALA_CCODE_FRAGMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_FRAGMENT, ValaCCodeFragmentPrivate))
enum  {
	VALA_CCODE_FRAGMENT_DUMMY_PROPERTY
};
static void vala_ccode_fragment_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_fragment_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_fragment_real_write_combined (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_fragment_parent_class = NULL;
static void vala_ccode_fragment_dispose (GObject * obj);


/**
 * Appends the specified code node to this code fragment.
 *
 * @param node a C code node
 */
void vala_ccode_fragment_append (ValaCCodeFragment* self, ValaCCodeNode* node)
{
	g_return_if_fail (VALA_IS_CCODE_FRAGMENT (self));
	g_return_if_fail (VALA_IS_CCODE_NODE (node));
	self->priv->children = g_list_append (self->priv->children, g_object_ref (node));
}


/**
 * Returns a copy of the list of children.
 *
 * @return children list
 */
GList* vala_ccode_fragment_get_children (ValaCCodeFragment* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_FRAGMENT (self), NULL);
	return g_list_copy (self->priv->children);
}


static void vala_ccode_fragment_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeFragment * self;
	self = VALA_CCODE_FRAGMENT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	{
		GList* __temp1;
		GList* node_it;
		__temp1 = NULL;
		__temp1 = self->priv->children;
		for (node_it = __temp1; node_it != NULL; node_it = node_it->next) {
			ValaCCodeNode* node;
			node = node_it->data;
			{
				vala_ccode_node_write (node, writer);
			}
		}
	}
}


static void vala_ccode_fragment_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeFragment * self;
	self = VALA_CCODE_FRAGMENT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	{
		GList* __temp2;
		GList* node_it;
		__temp2 = NULL;
		__temp2 = self->priv->children;
		for (node_it = __temp2; node_it != NULL; node_it = node_it->next) {
			ValaCCodeNode* node;
			node = node_it->data;
			{
				vala_ccode_node_write_declaration (node, writer);
			}
		}
	}
}


static void vala_ccode_fragment_real_write_combined (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeFragment * self;
	self = VALA_CCODE_FRAGMENT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	{
		GList* __temp3;
		GList* node_it;
		__temp3 = NULL;
		__temp3 = self->priv->children;
		for (node_it = __temp3; node_it != NULL; node_it = node_it->next) {
			ValaCCodeNode* node;
			node = node_it->data;
			{
				vala_ccode_node_write_combined (node, writer);
			}
		}
	}
}


static void vala_ccode_fragment_class_init (ValaCCodeFragmentClass * klass)
{
	vala_ccode_fragment_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeFragmentPrivate));
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_fragment_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_fragment_real_write;
	VALA_CCODE_NODE_CLASS (klass)->write_declaration = vala_ccode_fragment_real_write_declaration;
	VALA_CCODE_NODE_CLASS (klass)->write_combined = vala_ccode_fragment_real_write_combined;
}


static void vala_ccode_fragment_init (ValaCCodeFragment * self)
{
	self->priv = VALA_CCODE_FRAGMENT_GET_PRIVATE (self);
}


static void vala_ccode_fragment_dispose (GObject * obj)
{
	ValaCCodeFragment * self;
	ValaCCodeFragmentClass * klass;
	GObjectClass * parent_class;
	self = VALA_CCODE_FRAGMENT (obj);
	(self->priv->children == NULL ? NULL : (self->priv->children = (g_list_foreach (self->priv->children, (GFunc) g_object_unref, NULL), g_list_free (self->priv->children), NULL)));
	klass = VALA_CCODE_FRAGMENT_CLASS (g_type_class_peek (VALA_TYPE_CCODE_FRAGMENT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_fragment_get_type ()
{
	static GType vala_ccode_fragment_type_id = 0;
	if (G_UNLIKELY (vala_ccode_fragment_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeFragmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_fragment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeFragment), 0, (GInstanceInitFunc) vala_ccode_fragment_init };
		vala_ccode_fragment_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeFragment", &g_define_type_info, 0);
	}
	return vala_ccode_fragment_type_id;
}




