/* valaccodecommaexpression.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaccodecommaexpression.h"
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodecommaexpression.h>
#include <ccode/valaccodenode.h>

struct _ValaCCodeCommaExpressionPrivate {
	GList* inner;
};
#define VALA_CCODE_COMMA_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_COMMA_EXPRESSION, ValaCCodeCommaExpressionPrivate))
enum  {
	VALA_CCODE_COMMA_EXPRESSION_DUMMY_PROPERTY
};
static void vala_ccode_comma_expression_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_comma_expression_parent_class = NULL;
static void vala_ccode_comma_expression_dispose (GObject * obj);


/**
 * Appends the specified expression to the expression list.
 *
 * @param expr a C code expression
 */
void vala_ccode_comma_expression_append_expression (ValaCCodeCommaExpression* self, ValaCCodeExpression* expr)
{
	g_return_if_fail (VALA_IS_CCODE_COMMA_EXPRESSION (self));
	g_return_if_fail (VALA_IS_CCODE_EXPRESSION (expr));
	self->priv->inner = g_list_append (self->priv->inner, g_object_ref (expr));
}


static void vala_ccode_comma_expression_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeCommaExpression * self;
	gboolean first;
	self = VALA_CCODE_COMMA_EXPRESSION (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	first = TRUE;
	vala_ccode_writer_write_string (writer, "(");
	{
		GList* __temp0;
		GList* expr_it;
		__temp0 = NULL;
		__temp0 = self->priv->inner;
		for (expr_it = __temp0; expr_it != NULL; expr_it = expr_it->next) {
			ValaCCodeExpression* expr;
			expr = expr_it->data;
			{
				if (!first) {
					vala_ccode_writer_write_string (writer, ", ");
				} else {
					first = FALSE;
				}
				vala_ccode_node_write (VALA_CCODE_NODE (expr), writer);
			}
		}
	}
	vala_ccode_writer_write_string (writer, ")");
}


static void vala_ccode_comma_expression_class_init (ValaCCodeCommaExpressionClass * klass)
{
	vala_ccode_comma_expression_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeCommaExpressionPrivate));
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_comma_expression_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_comma_expression_real_write;
}


static void vala_ccode_comma_expression_init (ValaCCodeCommaExpression * self)
{
	self->priv = VALA_CCODE_COMMA_EXPRESSION_GET_PRIVATE (self);
}


static void vala_ccode_comma_expression_dispose (GObject * obj)
{
	ValaCCodeCommaExpression * self;
	ValaCCodeCommaExpressionClass * klass;
	GObjectClass * parent_class;
	self = VALA_CCODE_COMMA_EXPRESSION (obj);
	(self->priv->inner == NULL ? NULL : (self->priv->inner = (g_list_foreach (self->priv->inner, (GFunc) g_object_unref, NULL), g_list_free (self->priv->inner), NULL)));
	klass = VALA_CCODE_COMMA_EXPRESSION_CLASS (g_type_class_peek (VALA_TYPE_CCODE_COMMA_EXPRESSION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_comma_expression_get_type ()
{
	static GType vala_ccode_comma_expression_type_id = 0;
	if (G_UNLIKELY (vala_ccode_comma_expression_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeCommaExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_comma_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeCommaExpression), 0, (GInstanceInitFunc) vala_ccode_comma_expression_init };
		vala_ccode_comma_expression_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeCommaExpression", &g_define_type_info, 0);
	}
	return vala_ccode_comma_expression_type_id;
}




