/* valasourcereference.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valasourcereference.h"
#include <vala/valasourcefile.h>
#include <vala/valasourcereference.h>

struct _ValaSourceReferencePrivate {
	ValaSourceFile* _file;
	gint _first_line;
	gint _first_column;
	gint _last_line;
	gint _last_column;
	char* _comment;
};
#define VALA_SOURCE_REFERENCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferencePrivate))
enum  {
	VALA_SOURCE_REFERENCE_DUMMY_PROPERTY,
	VALA_SOURCE_REFERENCE_FILE,
	VALA_SOURCE_REFERENCE_FIRST_LINE,
	VALA_SOURCE_REFERENCE_FIRST_COLUMN,
	VALA_SOURCE_REFERENCE_LAST_LINE,
	VALA_SOURCE_REFERENCE_LAST_COLUMN,
	VALA_SOURCE_REFERENCE_COMMENT
};
static gpointer vala_source_reference_parent_class = NULL;
static void vala_source_reference_dispose (GObject * obj);


/**
 * Creates a new source reference.
 *
 * @param file         a source file
 * @param first_line   first line number
 * @param first_column first column number
 * @param last_line    last line number
 * @param last_column  last column number
 * @return             newly created source reference
 */
ValaSourceReference* vala_source_reference_new (ValaSourceFile* _file, gint _first_line, gint _first_column, gint _last_line, gint _last_column)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaSourceReference * self;
	g_return_val_if_fail (_file == NULL || VALA_IS_SOURCE_FILE (_file), NULL);
	__params = g_new0 (GParameter, 5);
	__params_it = __params;
	(__params_it->name = "file", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_FILE), g_value_set_object (&__params_it->value, _file), __params_it++);
	(__params_it->name = "first-line", g_value_init (&__params_it->value, G_TYPE_INT), g_value_set_int (&__params_it->value, _first_line), __params_it++);
	(__params_it->name = "first-column", g_value_init (&__params_it->value, G_TYPE_INT), g_value_set_int (&__params_it->value, _first_column), __params_it++);
	(__params_it->name = "last-line", g_value_init (&__params_it->value, G_TYPE_INT), g_value_set_int (&__params_it->value, _last_line), __params_it++);
	(__params_it->name = "last-column", g_value_init (&__params_it->value, G_TYPE_INT), g_value_set_int (&__params_it->value, _last_column), __params_it++);
	self = g_object_newv (VALA_TYPE_SOURCE_REFERENCE, __params_it - __params, __params);
	return self;
}


/**
 * Creates a new commented source reference.
 *
 * @param file         a source file
 * @param first_line   first line number
 * @param first_column first column number
 * @param last_line    last line number
 * @param last_column  last column number
 * @param comment      code comment
 * @return             newly created source reference
 */
ValaSourceReference* vala_source_reference_new_with_comment (ValaSourceFile* _file, gint _first_line, gint _first_column, gint _last_line, gint _last_column, const char* _comment)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaSourceReference * self;
	g_return_val_if_fail (_file == NULL || VALA_IS_SOURCE_FILE (_file), NULL);
	__params = g_new0 (GParameter, 6);
	__params_it = __params;
	(__params_it->name = "file", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_FILE), g_value_set_object (&__params_it->value, _file), __params_it++);
	(__params_it->name = "first-line", g_value_init (&__params_it->value, G_TYPE_INT), g_value_set_int (&__params_it->value, _first_line), __params_it++);
	(__params_it->name = "first-column", g_value_init (&__params_it->value, G_TYPE_INT), g_value_set_int (&__params_it->value, _first_column), __params_it++);
	(__params_it->name = "last-line", g_value_init (&__params_it->value, G_TYPE_INT), g_value_set_int (&__params_it->value, _last_line), __params_it++);
	(__params_it->name = "last-column", g_value_init (&__params_it->value, G_TYPE_INT), g_value_set_int (&__params_it->value, _last_column), __params_it++);
	(__params_it->name = "comment", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, _comment), __params_it++);
	self = g_object_newv (VALA_TYPE_SOURCE_REFERENCE, __params_it - __params, __params);
	return self;
}


/**
 * Returns a string representation of this source reference.
 *
 * @return human-readable string
 */
char* vala_source_reference_to_string (ValaSourceReference* self)
{
	g_return_val_if_fail (VALA_IS_SOURCE_REFERENCE (self), NULL);
	return (g_strdup_printf ("%s:%d.%d-%d.%d", vala_source_file_get_filename (vala_source_reference_get_file (self)), vala_source_reference_get_first_line (self), vala_source_reference_get_first_column (self), vala_source_reference_get_last_line (self), vala_source_reference_get_last_column (self)));
}


ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self)
{
	g_return_val_if_fail (VALA_IS_SOURCE_REFERENCE (self), NULL);
	return self->priv->_file;
}


void vala_source_reference_set_file (ValaSourceReference* self, ValaSourceFile* value)
{
	g_return_if_fail (VALA_IS_SOURCE_REFERENCE (self));
	self->priv->_file = value;
}


gint vala_source_reference_get_first_line (ValaSourceReference* self)
{
	g_return_val_if_fail (VALA_IS_SOURCE_REFERENCE (self), 0);
	return self->priv->_first_line;
}


void vala_source_reference_set_first_line (ValaSourceReference* self, gint value)
{
	g_return_if_fail (VALA_IS_SOURCE_REFERENCE (self));
	self->priv->_first_line = value;
}


gint vala_source_reference_get_first_column (ValaSourceReference* self)
{
	g_return_val_if_fail (VALA_IS_SOURCE_REFERENCE (self), 0);
	return self->priv->_first_column;
}


void vala_source_reference_set_first_column (ValaSourceReference* self, gint value)
{
	g_return_if_fail (VALA_IS_SOURCE_REFERENCE (self));
	self->priv->_first_column = value;
}


gint vala_source_reference_get_last_line (ValaSourceReference* self)
{
	g_return_val_if_fail (VALA_IS_SOURCE_REFERENCE (self), 0);
	return self->priv->_last_line;
}


void vala_source_reference_set_last_line (ValaSourceReference* self, gint value)
{
	g_return_if_fail (VALA_IS_SOURCE_REFERENCE (self));
	self->priv->_last_line = value;
}


gint vala_source_reference_get_last_column (ValaSourceReference* self)
{
	g_return_val_if_fail (VALA_IS_SOURCE_REFERENCE (self), 0);
	return self->priv->_last_column;
}


void vala_source_reference_set_last_column (ValaSourceReference* self, gint value)
{
	g_return_if_fail (VALA_IS_SOURCE_REFERENCE (self));
	self->priv->_last_column = value;
}


char* vala_source_reference_get_comment (ValaSourceReference* self)
{
	g_return_val_if_fail (VALA_IS_SOURCE_REFERENCE (self), NULL);
	return self->priv->_comment;
}


void vala_source_reference_set_comment (ValaSourceReference* self, const char* value)
{
	char* __temp8;
	const char* __temp7;
	g_return_if_fail (VALA_IS_SOURCE_REFERENCE (self));
	__temp8 = NULL;
	__temp7 = NULL;
	self->priv->_comment = (__temp8 = (__temp7 = value, (__temp7 == NULL ? NULL : g_strdup (__temp7))), (self->priv->_comment = (g_free (self->priv->_comment), NULL)), __temp8);
}


static void vala_source_reference_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaSourceReference * self;
	self = VALA_SOURCE_REFERENCE (object);
	switch (property_id) {
		case VALA_SOURCE_REFERENCE_FILE:
		g_value_set_object (value, vala_source_reference_get_file (self));
		break;
		case VALA_SOURCE_REFERENCE_FIRST_LINE:
		g_value_set_int (value, vala_source_reference_get_first_line (self));
		break;
		case VALA_SOURCE_REFERENCE_FIRST_COLUMN:
		g_value_set_int (value, vala_source_reference_get_first_column (self));
		break;
		case VALA_SOURCE_REFERENCE_LAST_LINE:
		g_value_set_int (value, vala_source_reference_get_last_line (self));
		break;
		case VALA_SOURCE_REFERENCE_LAST_COLUMN:
		g_value_set_int (value, vala_source_reference_get_last_column (self));
		break;
		case VALA_SOURCE_REFERENCE_COMMENT:
		g_value_set_string (value, vala_source_reference_get_comment (self));
		break;
	}
}


static void vala_source_reference_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaSourceReference * self;
	self = VALA_SOURCE_REFERENCE (object);
	switch (property_id) {
		case VALA_SOURCE_REFERENCE_FILE:
		vala_source_reference_set_file (self, g_value_get_object (value));
		break;
		case VALA_SOURCE_REFERENCE_FIRST_LINE:
		vala_source_reference_set_first_line (self, g_value_get_int (value));
		break;
		case VALA_SOURCE_REFERENCE_FIRST_COLUMN:
		vala_source_reference_set_first_column (self, g_value_get_int (value));
		break;
		case VALA_SOURCE_REFERENCE_LAST_LINE:
		vala_source_reference_set_last_line (self, g_value_get_int (value));
		break;
		case VALA_SOURCE_REFERENCE_LAST_COLUMN:
		vala_source_reference_set_last_column (self, g_value_get_int (value));
		break;
		case VALA_SOURCE_REFERENCE_COMMENT:
		vala_source_reference_set_comment (self, g_value_get_string (value));
		break;
	}
}


static void vala_source_reference_class_init (ValaSourceReferenceClass * klass)
{
	vala_source_reference_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaSourceReferencePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_source_reference_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_source_reference_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_source_reference_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_SOURCE_REFERENCE_FILE, g_param_spec_object ("file", "foo", "bar", VALA_TYPE_SOURCE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_SOURCE_REFERENCE_FIRST_LINE, g_param_spec_int ("first-line", "foo", "bar", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_SOURCE_REFERENCE_FIRST_COLUMN, g_param_spec_int ("first-column", "foo", "bar", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_SOURCE_REFERENCE_LAST_LINE, g_param_spec_int ("last-line", "foo", "bar", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_SOURCE_REFERENCE_LAST_COLUMN, g_param_spec_int ("last-column", "foo", "bar", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_SOURCE_REFERENCE_COMMENT, g_param_spec_string ("comment", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_source_reference_init (ValaSourceReference * self)
{
	self->priv = VALA_SOURCE_REFERENCE_GET_PRIVATE (self);
}


static void vala_source_reference_dispose (GObject * obj)
{
	ValaSourceReference * self;
	ValaSourceReferenceClass * klass;
	GObjectClass * parent_class;
	self = VALA_SOURCE_REFERENCE (obj);
	(self->priv->_comment = (g_free (self->priv->_comment), NULL));
	klass = VALA_SOURCE_REFERENCE_CLASS (g_type_class_peek (VALA_TYPE_SOURCE_REFERENCE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_source_reference_get_type ()
{
	static GType vala_source_reference_type_id = 0;
	if (G_UNLIKELY (vala_source_reference_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSourceReferenceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_source_reference_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSourceReference), 0, (GInstanceInitFunc) vala_source_reference_init };
		vala_source_reference_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaSourceReference", &g_define_type_info, 0);
	}
	return vala_source_reference_type_id;
}




