/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaobjectcreationexpression.h"
#include <vala/valatypereference.h>
#include <vala/valamethod.h>
#include <vala/valamemberaccess.h>
#include <vala/valasourcereference.h>
#include <vala/valaobjectcreationexpression.h>
#include <vala/valacodevisitor.h>

struct _ValaObjectCreationExpressionPrivate {
	ValaTypeReference* _type_reference;
	ValaMethod* _constructor;
	ValaMemberAccess* _member_name;
	GList* argument_list;
};
#define VALA_OBJECT_CREATION_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionPrivate))
enum  {
	VALA_OBJECT_CREATION_EXPRESSION_DUMMY_PROPERTY,
	VALA_OBJECT_CREATION_EXPRESSION_TYPE_REFERENCE,
	VALA_OBJECT_CREATION_EXPRESSION_CONSTRUCTOR,
	VALA_OBJECT_CREATION_EXPRESSION_MEMBER_NAME
};
static void vala_object_creation_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node);
static gpointer vala_object_creation_expression_parent_class = NULL;
static void vala_object_creation_expression_dispose (GObject * obj);


/**
 * Creates a new object creation expression.
 *
 * @param type   object type to create
 * @param source reference to source code
 * @return       newly created object creation expression
 */
ValaObjectCreationExpression* vala_object_creation_expression_new (ValaMemberAccess* name, ValaSourceReference* source)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaObjectCreationExpression * self;
	g_return_val_if_fail (VALA_IS_MEMBER_ACCESS (name), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "member-name", g_value_init (&__params_it->value, VALA_TYPE_MEMBER_ACCESS), g_value_set_object (&__params_it->value, name), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	self = g_object_newv (VALA_TYPE_OBJECT_CREATION_EXPRESSION, __params_it - __params, __params);
	return self;
}


/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void vala_object_creation_expression_add_argument (ValaObjectCreationExpression* self, ValaExpression* arg)
{
	g_return_if_fail (VALA_IS_OBJECT_CREATION_EXPRESSION (self));
	g_return_if_fail (VALA_IS_EXPRESSION (arg));
	self->priv->argument_list = g_list_append (self->priv->argument_list, g_object_ref (arg));
	(vala_code_node_set_parent_node (VALA_CODE_NODE (arg), VALA_CODE_NODE (self)), vala_code_node_get_parent_node (VALA_CODE_NODE (arg)));
}


/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
GList* vala_object_creation_expression_get_argument_list (ValaObjectCreationExpression* self)
{
	g_return_val_if_fail (VALA_IS_OBJECT_CREATION_EXPRESSION (self), NULL);
	return g_list_copy (self->priv->argument_list);
}


static void vala_object_creation_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	self = VALA_OBJECT_CREATION_EXPRESSION (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	if (vala_object_creation_expression_get_type_reference (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_object_creation_expression_get_type_reference (self)), visitor);
	}
	if (vala_object_creation_expression_get_member_name (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_object_creation_expression_get_member_name (self)), visitor);
	}
	vala_code_visitor_visit_begin_object_creation_expression (visitor, self);
	{
		GList* __temp1;
		GList* arg_it;
		__temp1 = NULL;
		__temp1 = g_list_copy (self->priv->argument_list);
		for (arg_it = __temp1; arg_it != NULL; arg_it = arg_it->next) {
			ValaExpression* arg;
			arg = arg_it->data;
			{
				/* iterate over list copy as list may change in loop body*/
				vala_code_node_accept (VALA_CODE_NODE (arg), visitor);
			}
		}
		(__temp1 == NULL ? NULL : (__temp1 = (g_list_free (__temp1), NULL)));
	}
	vala_code_visitor_visit_end_object_creation_expression (visitor, self);
}


static void vala_object_creation_expression_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node)
{
	ValaObjectCreationExpression * self;
	GList* l;
	self = VALA_OBJECT_CREATION_EXPRESSION (base);
	g_return_if_fail (VALA_IS_CODE_NODE (old_node));
	g_return_if_fail (VALA_IS_CODE_NODE (new_node));
	l = g_list_find (self->priv->argument_list, old_node);
	if (l != NULL) {
		if (vala_code_node_get_parent_node (new_node) != NULL) {
			return;
		}
		self->priv->argument_list = g_list_insert_before (self->priv->argument_list, l, g_object_ref (new_node));
		self->priv->argument_list = g_list_remove_link (self->priv->argument_list, l);
		(vala_code_node_set_parent_node (new_node, VALA_CODE_NODE (self)), vala_code_node_get_parent_node (new_node));
	}
}


ValaTypeReference* vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self)
{
	g_return_val_if_fail (VALA_IS_OBJECT_CREATION_EXPRESSION (self), NULL);
	return self->priv->_type_reference;
}


void vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self, ValaTypeReference* value)
{
	ValaTypeReference* __temp4;
	ValaTypeReference* __temp3;
	g_return_if_fail (VALA_IS_OBJECT_CREATION_EXPRESSION (self));
	__temp4 = NULL;
	__temp3 = NULL;
	self->priv->_type_reference = (__temp4 = (__temp3 = value, (__temp3 == NULL ? NULL : g_object_ref (__temp3))), (self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL))), __temp4);
}


ValaMethod* vala_object_creation_expression_get_constructor (ValaObjectCreationExpression* self)
{
	g_return_val_if_fail (VALA_IS_OBJECT_CREATION_EXPRESSION (self), NULL);
	return self->priv->_constructor;
}


void vala_object_creation_expression_set_constructor (ValaObjectCreationExpression* self, ValaMethod* value)
{
	ValaMethod* __temp7;
	ValaMethod* __temp6;
	g_return_if_fail (VALA_IS_OBJECT_CREATION_EXPRESSION (self));
	__temp7 = NULL;
	__temp6 = NULL;
	self->priv->_constructor = (__temp7 = (__temp6 = value, (__temp6 == NULL ? NULL : g_object_ref (__temp6))), (self->priv->_constructor == NULL ? NULL : (self->priv->_constructor = (g_object_unref (self->priv->_constructor), NULL))), __temp7);
}


ValaMemberAccess* vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self)
{
	g_return_val_if_fail (VALA_IS_OBJECT_CREATION_EXPRESSION (self), NULL);
	return self->priv->_member_name;
}


void vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self, ValaMemberAccess* value)
{
	ValaMemberAccess* __temp10;
	ValaMemberAccess* __temp9;
	g_return_if_fail (VALA_IS_OBJECT_CREATION_EXPRESSION (self));
	__temp10 = NULL;
	__temp9 = NULL;
	self->priv->_member_name = (__temp10 = (__temp9 = value, (__temp9 == NULL ? NULL : g_object_ref (__temp9))), (self->priv->_member_name == NULL ? NULL : (self->priv->_member_name = (g_object_unref (self->priv->_member_name), NULL))), __temp10);
}


static void vala_object_creation_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaObjectCreationExpression * self;
	self = VALA_OBJECT_CREATION_EXPRESSION (object);
	switch (property_id) {
		case VALA_OBJECT_CREATION_EXPRESSION_TYPE_REFERENCE:
		g_value_set_object (value, vala_object_creation_expression_get_type_reference (self));
		break;
		case VALA_OBJECT_CREATION_EXPRESSION_CONSTRUCTOR:
		g_value_set_object (value, vala_object_creation_expression_get_constructor (self));
		break;
		case VALA_OBJECT_CREATION_EXPRESSION_MEMBER_NAME:
		g_value_set_object (value, vala_object_creation_expression_get_member_name (self));
		break;
	}
}


static void vala_object_creation_expression_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaObjectCreationExpression * self;
	self = VALA_OBJECT_CREATION_EXPRESSION (object);
	switch (property_id) {
		case VALA_OBJECT_CREATION_EXPRESSION_TYPE_REFERENCE:
		vala_object_creation_expression_set_type_reference (self, g_value_get_object (value));
		break;
		case VALA_OBJECT_CREATION_EXPRESSION_CONSTRUCTOR:
		vala_object_creation_expression_set_constructor (self, g_value_get_object (value));
		break;
		case VALA_OBJECT_CREATION_EXPRESSION_MEMBER_NAME:
		vala_object_creation_expression_set_member_name (self, g_value_get_object (value));
		break;
	}
}


static void vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass)
{
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaObjectCreationExpressionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_object_creation_expression_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_object_creation_expression_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_object_creation_expression_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_object_creation_expression_real_accept;
	VALA_CODE_NODE_CLASS (klass)->replace = vala_object_creation_expression_real_replace;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_OBJECT_CREATION_EXPRESSION_TYPE_REFERENCE, g_param_spec_object ("type-reference", "foo", "bar", VALA_TYPE_TYPE_REFERENCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_OBJECT_CREATION_EXPRESSION_CONSTRUCTOR, g_param_spec_object ("constructor", "foo", "bar", VALA_TYPE_METHOD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_OBJECT_CREATION_EXPRESSION_MEMBER_NAME, g_param_spec_object ("member-name", "foo", "bar", VALA_TYPE_MEMBER_ACCESS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_object_creation_expression_init (ValaObjectCreationExpression * self)
{
	self->priv = VALA_OBJECT_CREATION_EXPRESSION_GET_PRIVATE (self);
}


static void vala_object_creation_expression_dispose (GObject * obj)
{
	ValaObjectCreationExpression * self;
	ValaObjectCreationExpressionClass * klass;
	GObjectClass * parent_class;
	self = VALA_OBJECT_CREATION_EXPRESSION (obj);
	(self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL)));
	(self->priv->_constructor == NULL ? NULL : (self->priv->_constructor = (g_object_unref (self->priv->_constructor), NULL)));
	(self->priv->_member_name == NULL ? NULL : (self->priv->_member_name = (g_object_unref (self->priv->_member_name), NULL)));
	(self->priv->argument_list == NULL ? NULL : (self->priv->argument_list = (g_list_foreach (self->priv->argument_list, (GFunc) g_object_unref, NULL), g_list_free (self->priv->argument_list), NULL)));
	klass = VALA_OBJECT_CREATION_EXPRESSION_CLASS (g_type_class_peek (VALA_TYPE_OBJECT_CREATION_EXPRESSION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_object_creation_expression_get_type ()
{
	static GType vala_object_creation_expression_type_id = 0;
	if (G_UNLIKELY (vala_object_creation_expression_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_init };
		vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
	}
	return vala_object_creation_expression_type_id;
}




