/* valalambdaexpression.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valalambdaexpression.h"
#include <vala/valablock.h>
#include <vala/valamethod.h>
#include <vala/valasourcereference.h>
#include <vala/valalambdaexpression.h>
#include <vala/valacodevisitor.h>

struct _ValaLambdaExpressionPrivate {
	ValaExpression* _expression_body;
	ValaBlock* _statement_body;
	ValaMethod* _method;
	GList* parameters;
};
#define VALA_LAMBDA_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionPrivate))
enum  {
	VALA_LAMBDA_EXPRESSION_DUMMY_PROPERTY,
	VALA_LAMBDA_EXPRESSION_EXPRESSION_BODY,
	VALA_LAMBDA_EXPRESSION_STATEMENT_BODY,
	VALA_LAMBDA_EXPRESSION_METHOD
};
static void vala_lambda_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_lambda_expression_parent_class = NULL;
static void vala_lambda_expression_dispose (GObject * obj);


/**
 * Creates a new lambda expression.
 *
 * @param body   expression body
 * @param source reference to source code
 * @return       newly created lambda expression
 */
ValaLambdaExpression* vala_lambda_expression_new (ValaExpression* body, ValaSourceReference* source)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaLambdaExpression * self;
	g_return_val_if_fail (VALA_IS_EXPRESSION (body), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "expression-body", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, body), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	self = g_object_newv (VALA_TYPE_LAMBDA_EXPRESSION, __params_it - __params, __params);
	return self;
}


/**
 * Creates a new lambda expression with statement body.
 *
 * @param body   statement body
 * @param source reference to source code
 * @return       newly created lambda expression
 */
ValaLambdaExpression* vala_lambda_expression_new_with_statement_body (ValaBlock* body, ValaSourceReference* source)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaLambdaExpression * self;
	g_return_val_if_fail (VALA_IS_BLOCK (body), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "statement-body", g_value_init (&__params_it->value, VALA_TYPE_BLOCK), g_value_set_object (&__params_it->value, body), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source), __params_it++);
	self = g_object_newv (VALA_TYPE_LAMBDA_EXPRESSION, __params_it - __params, __params);
	return self;
}


/**
 * Appends implicitly typed parameter.
 *
 * @param param parameter name
 */
void vala_lambda_expression_add_parameter (ValaLambdaExpression* self, const char* param)
{
	g_return_if_fail (VALA_IS_LAMBDA_EXPRESSION (self));
	g_return_if_fail (param != NULL);
	self->priv->parameters = g_list_append (self->priv->parameters, g_strdup (param));
}


/**
 * Returns copy of parameter list.
 *
 * @return parameter list
 */
GList* vala_lambda_expression_get_parameters (ValaLambdaExpression* self)
{
	g_return_val_if_fail (VALA_IS_LAMBDA_EXPRESSION (self), NULL);
	return g_list_copy (self->priv->parameters);
}


static void vala_lambda_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaLambdaExpression * self;
	self = VALA_LAMBDA_EXPRESSION (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_begin_lambda_expression (visitor, self);
	if (vala_lambda_expression_get_method (self) == NULL) {
		if (vala_lambda_expression_get_expression_body (self) != NULL) {
			vala_code_node_accept (VALA_CODE_NODE (vala_lambda_expression_get_expression_body (self)), visitor);
			vala_code_visitor_visit_end_full_expression (visitor, vala_lambda_expression_get_expression_body (self));
		} else {
			if (vala_lambda_expression_get_statement_body (self) != NULL) {
				vala_code_node_accept (VALA_CODE_NODE (vala_lambda_expression_get_statement_body (self)), visitor);
			}
		}
	}
	vala_code_visitor_visit_end_lambda_expression (visitor, self);
	if (vala_lambda_expression_get_method (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_lambda_expression_get_method (self)), visitor);
	}
}


ValaExpression* vala_lambda_expression_get_expression_body (ValaLambdaExpression* self)
{
	g_return_val_if_fail (VALA_IS_LAMBDA_EXPRESSION (self), NULL);
	return self->priv->_expression_body;
}


void vala_lambda_expression_set_expression_body (ValaLambdaExpression* self, ValaExpression* value)
{
	ValaExpression* __temp3;
	ValaExpression* __temp2;
	g_return_if_fail (VALA_IS_LAMBDA_EXPRESSION (self));
	__temp3 = NULL;
	__temp2 = NULL;
	self->priv->_expression_body = (__temp3 = (__temp2 = value, (__temp2 == NULL ? NULL : g_object_ref (__temp2))), (self->priv->_expression_body == NULL ? NULL : (self->priv->_expression_body = (g_object_unref (self->priv->_expression_body), NULL))), __temp3);
}


ValaBlock* vala_lambda_expression_get_statement_body (ValaLambdaExpression* self)
{
	g_return_val_if_fail (VALA_IS_LAMBDA_EXPRESSION (self), NULL);
	return self->priv->_statement_body;
}


void vala_lambda_expression_set_statement_body (ValaLambdaExpression* self, ValaBlock* value)
{
	ValaBlock* __temp6;
	ValaBlock* __temp5;
	g_return_if_fail (VALA_IS_LAMBDA_EXPRESSION (self));
	__temp6 = NULL;
	__temp5 = NULL;
	self->priv->_statement_body = (__temp6 = (__temp5 = value, (__temp5 == NULL ? NULL : g_object_ref (__temp5))), (self->priv->_statement_body == NULL ? NULL : (self->priv->_statement_body = (g_object_unref (self->priv->_statement_body), NULL))), __temp6);
}


ValaMethod* vala_lambda_expression_get_method (ValaLambdaExpression* self)
{
	g_return_val_if_fail (VALA_IS_LAMBDA_EXPRESSION (self), NULL);
	return self->priv->_method;
}


void vala_lambda_expression_set_method (ValaLambdaExpression* self, ValaMethod* value)
{
	ValaMethod* __temp9;
	ValaMethod* __temp8;
	g_return_if_fail (VALA_IS_LAMBDA_EXPRESSION (self));
	__temp9 = NULL;
	__temp8 = NULL;
	self->priv->_method = (__temp9 = (__temp8 = value, (__temp8 == NULL ? NULL : g_object_ref (__temp8))), (self->priv->_method == NULL ? NULL : (self->priv->_method = (g_object_unref (self->priv->_method), NULL))), __temp9);
}


static void vala_lambda_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaLambdaExpression * self;
	self = VALA_LAMBDA_EXPRESSION (object);
	switch (property_id) {
		case VALA_LAMBDA_EXPRESSION_EXPRESSION_BODY:
		g_value_set_object (value, vala_lambda_expression_get_expression_body (self));
		break;
		case VALA_LAMBDA_EXPRESSION_STATEMENT_BODY:
		g_value_set_object (value, vala_lambda_expression_get_statement_body (self));
		break;
		case VALA_LAMBDA_EXPRESSION_METHOD:
		g_value_set_object (value, vala_lambda_expression_get_method (self));
		break;
	}
}


static void vala_lambda_expression_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaLambdaExpression * self;
	self = VALA_LAMBDA_EXPRESSION (object);
	switch (property_id) {
		case VALA_LAMBDA_EXPRESSION_EXPRESSION_BODY:
		vala_lambda_expression_set_expression_body (self, g_value_get_object (value));
		break;
		case VALA_LAMBDA_EXPRESSION_STATEMENT_BODY:
		vala_lambda_expression_set_statement_body (self, g_value_get_object (value));
		break;
		case VALA_LAMBDA_EXPRESSION_METHOD:
		vala_lambda_expression_set_method (self, g_value_get_object (value));
		break;
	}
}


static void vala_lambda_expression_class_init (ValaLambdaExpressionClass * klass)
{
	vala_lambda_expression_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaLambdaExpressionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_lambda_expression_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_lambda_expression_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_lambda_expression_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_lambda_expression_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_LAMBDA_EXPRESSION_EXPRESSION_BODY, g_param_spec_object ("expression-body", "foo", "bar", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_LAMBDA_EXPRESSION_STATEMENT_BODY, g_param_spec_object ("statement-body", "foo", "bar", VALA_TYPE_BLOCK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_LAMBDA_EXPRESSION_METHOD, g_param_spec_object ("method", "foo", "bar", VALA_TYPE_METHOD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_lambda_expression_init (ValaLambdaExpression * self)
{
	self->priv = VALA_LAMBDA_EXPRESSION_GET_PRIVATE (self);
}


static void vala_lambda_expression_dispose (GObject * obj)
{
	ValaLambdaExpression * self;
	ValaLambdaExpressionClass * klass;
	GObjectClass * parent_class;
	self = VALA_LAMBDA_EXPRESSION (obj);
	(self->priv->_expression_body == NULL ? NULL : (self->priv->_expression_body = (g_object_unref (self->priv->_expression_body), NULL)));
	(self->priv->_statement_body == NULL ? NULL : (self->priv->_statement_body = (g_object_unref (self->priv->_statement_body), NULL)));
	(self->priv->_method == NULL ? NULL : (self->priv->_method = (g_object_unref (self->priv->_method), NULL)));
	(self->priv->parameters == NULL ? NULL : (self->priv->parameters = (g_list_foreach (self->priv->parameters, (GFunc) g_free, NULL), g_list_free (self->priv->parameters), NULL)));
	klass = VALA_LAMBDA_EXPRESSION_CLASS (g_type_class_peek (VALA_TYPE_LAMBDA_EXPRESSION));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_lambda_expression_get_type ()
{
	static GType vala_lambda_expression_type_id = 0;
	if (G_UNLIKELY (vala_lambda_expression_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLambdaExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_lambda_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLambdaExpression), 0, (GInstanceInitFunc) vala_lambda_expression_init };
		vala_lambda_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaLambdaExpression", &g_define_type_info, 0);
	}
	return vala_lambda_expression_type_id;
}




