/* valaforstatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALAFORSTATEMENT_H__
#define __VALAFORSTATEMENT_H__
typedef struct _ValaForStatementPrivate ValaForStatementPrivate;

#include <glib.h>
#include <glib-object.h>
#include <vala/valastatement.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_FOR_STATEMENT (vala_for_statement_get_type ())
#define VALA_FOR_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FOR_STATEMENT, ValaForStatement))
#define VALA_FOR_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FOR_STATEMENT, ValaForStatementClass))
#define VALA_IS_FOR_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FOR_STATEMENT))
#define VALA_IS_FOR_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FOR_STATEMENT))
#define VALA_FOR_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FOR_STATEMENT, ValaForStatementClass))


/**
 * Represents a for iteration statement in the source code.
 */
struct _ValaForStatement {
	ValaStatement parent;
	ValaForStatementPrivate * priv;
};
struct _ValaForStatementClass {
	ValaStatementClass parent;
};

ValaForStatement* vala_for_statement_new (ValaExpression* cond, ValaStatement* _body, ValaSourceReference* source);
void vala_for_statement_add_initializer (ValaForStatement* self, ValaExpression* init);
GList* vala_for_statement_get_initializer (ValaForStatement* self);
void vala_for_statement_add_iterator (ValaForStatement* self, ValaExpression* iter);
GList* vala_for_statement_get_iterator (ValaForStatement* self);
ValaExpression* vala_for_statement_get_condition (ValaForStatement* self);
void vala_for_statement_set_condition (ValaForStatement* self, ValaExpression* value);
ValaStatement* vala_for_statement_get_body (ValaForStatement* self);
void vala_for_statement_set_body (ValaForStatement* self, ValaStatement* value);
GType vala_for_statement_get_type ();

G_END_DECLS

#endif
