/* valacodenode.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valacodenode.h"
#include <ccode/valaccodelinedirective.h>
#include <vala/valacodenode.h>
#include <vala/valasymbol.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valaattribute.h>
#include <vala/valasourcefile.h>

struct _ValaCodeNodePrivate {
	ValaCodeNode* _parent_node;
	ValaSymbol* _symbol;
	ValaSourceReference* _source_reference;
	gboolean _error;
	ValaCCodeNode* _ccodenode;
};
#define VALA_CODE_NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CODE_NODE, ValaCodeNodePrivate))
enum  {
	VALA_CODE_NODE_DUMMY_PROPERTY,
	VALA_CODE_NODE_PARENT_NODE,
	VALA_CODE_NODE_SYMBOL,
	VALA_CODE_NODE_SOURCE_REFERENCE,
	VALA_CODE_NODE_CCODENODE,
	VALA_CODE_NODE_ERROR
};
static void vala_code_node_real_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
static void vala_code_node_real_accept_children (ValaCodeNode* self, ValaCodeVisitor* visitor);
static void vala_code_node_real_replace (ValaCodeNode* self, ValaCodeNode* old_node, ValaCodeNode* new_node);
static char* vala_code_node_real_to_string (ValaCodeNode* self);
static gpointer vala_code_node_parent_class = NULL;
static void vala_code_node_dispose (GObject * obj);


/**
 * Visits this code node with the specified CodeVisitor.
 *
 * @param visitor the visitor to be called while traversing
 */
static void vala_code_node_real_accept (ValaCodeNode* self, ValaCodeVisitor* visitor)
{
	g_return_if_fail (VALA_IS_CODE_NODE (self));
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
}


void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor)
{
	VALA_CODE_NODE_GET_CLASS (self)->accept (self, visitor);
}


/**
 * Visits all children of this code node with the specified CodeVisitor.
 *
 * @param visitor the visitor to be called while traversing
 */
static void vala_code_node_real_accept_children (ValaCodeNode* self, ValaCodeVisitor* visitor)
{
	g_return_if_fail (VALA_IS_CODE_NODE (self));
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
}


void vala_code_node_accept_children (ValaCodeNode* self, ValaCodeVisitor* visitor)
{
	VALA_CODE_NODE_GET_CLASS (self)->accept_children (self, visitor);
}


static void vala_code_node_real_replace (ValaCodeNode* self, ValaCodeNode* old_node, ValaCodeNode* new_node)
{
	g_return_if_fail (VALA_IS_CODE_NODE (self));
	g_return_if_fail (VALA_IS_CODE_NODE (old_node));
	g_return_if_fail (VALA_IS_CODE_NODE (new_node));
}


void vala_code_node_replace (ValaCodeNode* self, ValaCodeNode* old_node, ValaCodeNode* new_node)
{
	VALA_CODE_NODE_GET_CLASS (self)->replace (self, old_node, new_node);
}


/**
 * Returns the specified attribute.
 *
 * @param name attribute name
 * @return     attribute
 */
ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const char* name)
{
	g_return_val_if_fail (VALA_IS_CODE_NODE (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		GList* __temp2;
		GList* a_it;
		__temp2 = NULL;
		__temp2 = self->attributes;
		for (a_it = __temp2; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* a;
			a = a_it->data;
			{
				/* FIXME: use hash table*/
				if (g_utf8_collate (vala_attribute_get_name (a), name) == 0) {
					ValaAttribute* __temp0;
					__temp0 = NULL;
					return (__temp0 = a, (__temp0 == NULL ? NULL : g_object_ref (__temp0)));
				}
			}
		}
	}
	return VALA_ATTRIBUTE (NULL);
}


/**
 * Returns a string that represents this code node.
 *
 * @return a string representation
 */
static char* vala_code_node_real_to_string (ValaCodeNode* self)
{
	g_return_val_if_fail (VALA_IS_CODE_NODE (self), NULL);
	if (vala_code_node_get_source_reference (self) != NULL) {
		return vala_source_reference_to_string (vala_code_node_get_source_reference (self));
	}
	return g_strdup ("(unknown)");
}


char* vala_code_node_to_string (ValaCodeNode* self)
{
	return VALA_CODE_NODE_GET_CLASS (self)->to_string (self);
}


ValaCodeNode* vala_code_node_get_parent_node (ValaCodeNode* self)
{
	g_return_val_if_fail (VALA_IS_CODE_NODE (self), NULL);
	return self->priv->_parent_node;
}


void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value)
{
	ValaCodeNode* __temp8;
	ValaCodeNode* __temp7;
	g_return_if_fail (VALA_IS_CODE_NODE (self));
	__temp8 = NULL;
	__temp7 = NULL;
	self->priv->_parent_node = (__temp8 = (__temp7 = value, (__temp7 == NULL ? NULL : g_object_ref (__temp7))), (self->priv->_parent_node == NULL ? NULL : (self->priv->_parent_node = (g_object_unref (self->priv->_parent_node), NULL))), __temp8);
}


ValaSymbol* vala_code_node_get_symbol (ValaCodeNode* self)
{
	g_return_val_if_fail (VALA_IS_CODE_NODE (self), NULL);
	return self->priv->_symbol;
}


void vala_code_node_set_symbol (ValaCodeNode* self, ValaSymbol* value)
{
	ValaSymbol* __temp11;
	ValaSymbol* __temp10;
	g_return_if_fail (VALA_IS_CODE_NODE (self));
	__temp11 = NULL;
	__temp10 = NULL;
	self->priv->_symbol = (__temp11 = (__temp10 = value, (__temp10 == NULL ? NULL : g_object_ref (__temp10))), (self->priv->_symbol == NULL ? NULL : (self->priv->_symbol = (g_object_unref (self->priv->_symbol), NULL))), __temp11);
}


ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self)
{
	g_return_val_if_fail (VALA_IS_CODE_NODE (self), NULL);
	return self->priv->_source_reference;
}


void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value)
{
	ValaSourceReference* __temp14;
	ValaSourceReference* __temp13;
	g_return_if_fail (VALA_IS_CODE_NODE (self));
	__temp14 = NULL;
	__temp13 = NULL;
	self->priv->_source_reference = (__temp14 = (__temp13 = value, (__temp13 == NULL ? NULL : g_object_ref (__temp13))), (self->priv->_source_reference == NULL ? NULL : (self->priv->_source_reference = (g_object_unref (self->priv->_source_reference), NULL))), __temp14);
}


ValaCCodeNode* vala_code_node_get_ccodenode (ValaCodeNode* self)
{
	g_return_val_if_fail (VALA_IS_CODE_NODE (self), NULL);
	return self->priv->_ccodenode;
}


void vala_code_node_set_ccodenode (ValaCodeNode* self, ValaCCodeNode* value)
{
	ValaCCodeNode* __temp18;
	ValaCCodeNode* __temp17;
	g_return_if_fail (VALA_IS_CODE_NODE (self));
	if (vala_code_node_get_source_reference (self) != NULL) {
		ValaCCodeLineDirective* __temp16;
		__temp16 = NULL;
		(vala_ccode_node_set_line (value, (__temp16 = vala_ccode_line_directive_new (vala_source_file_get_filename (vala_source_reference_get_file (vala_code_node_get_source_reference (self))), vala_source_reference_get_first_line (vala_code_node_get_source_reference (self))))), vala_ccode_node_get_line (value));
		(__temp16 == NULL ? NULL : (__temp16 = (g_object_unref (__temp16), NULL)));
	}
	__temp18 = NULL;
	__temp17 = NULL;
	self->priv->_ccodenode = (__temp18 = (__temp17 = value, (__temp17 == NULL ? NULL : g_object_ref (__temp17))), (self->priv->_ccodenode == NULL ? NULL : (self->priv->_ccodenode = (g_object_unref (self->priv->_ccodenode), NULL))), __temp18);
}


gboolean vala_code_node_get_error (ValaCodeNode* self)
{
	g_return_val_if_fail (VALA_IS_CODE_NODE (self), FALSE);
	return self->priv->_error;
}


void vala_code_node_set_error (ValaCodeNode* self, gboolean value)
{
	g_return_if_fail (VALA_IS_CODE_NODE (self));
	self->priv->_error = value;
}


static void vala_code_node_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCodeNode * self;
	self = VALA_CODE_NODE (object);
	switch (property_id) {
		case VALA_CODE_NODE_PARENT_NODE:
		g_value_set_object (value, vala_code_node_get_parent_node (self));
		break;
		case VALA_CODE_NODE_SYMBOL:
		g_value_set_object (value, vala_code_node_get_symbol (self));
		break;
		case VALA_CODE_NODE_SOURCE_REFERENCE:
		g_value_set_object (value, vala_code_node_get_source_reference (self));
		break;
		case VALA_CODE_NODE_CCODENODE:
		g_value_set_object (value, vala_code_node_get_ccodenode (self));
		break;
		case VALA_CODE_NODE_ERROR:
		g_value_set_boolean (value, vala_code_node_get_error (self));
		break;
	}
}


static void vala_code_node_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCodeNode * self;
	self = VALA_CODE_NODE (object);
	switch (property_id) {
		case VALA_CODE_NODE_PARENT_NODE:
		vala_code_node_set_parent_node (self, g_value_get_object (value));
		break;
		case VALA_CODE_NODE_SYMBOL:
		vala_code_node_set_symbol (self, g_value_get_object (value));
		break;
		case VALA_CODE_NODE_SOURCE_REFERENCE:
		vala_code_node_set_source_reference (self, g_value_get_object (value));
		break;
		case VALA_CODE_NODE_CCODENODE:
		vala_code_node_set_ccodenode (self, g_value_get_object (value));
		break;
		case VALA_CODE_NODE_ERROR:
		vala_code_node_set_error (self, g_value_get_boolean (value));
		break;
	}
}


static void vala_code_node_class_init (ValaCodeNodeClass * klass)
{
	vala_code_node_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCodeNodePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_code_node_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_code_node_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_code_node_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_code_node_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_code_node_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace = vala_code_node_real_replace;
	VALA_CODE_NODE_CLASS (klass)->to_string = vala_code_node_real_to_string;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CODE_NODE_PARENT_NODE, g_param_spec_object ("parent-node", "foo", "bar", VALA_TYPE_CODE_NODE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CODE_NODE_SYMBOL, g_param_spec_object ("symbol", "foo", "bar", VALA_TYPE_SYMBOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CODE_NODE_SOURCE_REFERENCE, g_param_spec_object ("source-reference", "foo", "bar", VALA_TYPE_SOURCE_REFERENCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CODE_NODE_CCODENODE, g_param_spec_object ("ccodenode", "foo", "bar", VALA_TYPE_CCODE_NODE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CODE_NODE_ERROR, g_param_spec_boolean ("error", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_code_node_init (ValaCodeNode * self)
{
	self->priv = VALA_CODE_NODE_GET_PRIVATE (self);
}


static void vala_code_node_dispose (GObject * obj)
{
	ValaCodeNode * self;
	ValaCodeNodeClass * klass;
	GObjectClass * parent_class;
	self = VALA_CODE_NODE (obj);
	(self->priv->_parent_node == NULL ? NULL : (self->priv->_parent_node = (g_object_unref (self->priv->_parent_node), NULL)));
	(self->priv->_symbol == NULL ? NULL : (self->priv->_symbol = (g_object_unref (self->priv->_symbol), NULL)));
	(self->priv->_source_reference == NULL ? NULL : (self->priv->_source_reference = (g_object_unref (self->priv->_source_reference), NULL)));
	(self->attributes == NULL ? NULL : (self->attributes = (g_list_foreach (self->attributes, (GFunc) g_object_unref, NULL), g_list_free (self->attributes), NULL)));
	(self->priv->_ccodenode == NULL ? NULL : (self->priv->_ccodenode = (g_object_unref (self->priv->_ccodenode), NULL)));
	klass = VALA_CODE_NODE_CLASS (g_type_class_peek (VALA_TYPE_CODE_NODE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_code_node_get_type ()
{
	static GType vala_code_node_type_id = 0;
	if (G_UNLIKELY (vala_code_node_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCodeNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeNode), 0, (GInstanceInitFunc) vala_code_node_init };
		vala_code_node_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaCodeNode", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_code_node_type_id;
}




