/* valacatchclause.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALACATCHCLAUSE_H__
#define __VALACATCHCLAUSE_H__
typedef struct _ValaCatchClausePrivate ValaCatchClausePrivate;

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_CATCH_CLAUSE (vala_catch_clause_get_type ())
#define VALA_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClause))
#define VALA_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))
#define VALA_IS_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CATCH_CLAUSE))
#define VALA_IS_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CATCH_CLAUSE))
#define VALA_CATCH_CLAUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))


/**
 * Represents a catch clause in a try statement in the source code.
 */
struct _ValaCatchClause {
	ValaCodeNode parent;
	ValaCatchClausePrivate * priv;
};
struct _ValaCatchClauseClass {
	ValaCodeNodeClass parent;
};

ValaCatchClause* vala_catch_clause_new (ValaTypeReference* type_reference, const char* variable_name, ValaBlock* body, ValaSourceReference* source_reference);
ValaTypeReference* vala_catch_clause_get_type_reference (ValaCatchClause* self);
void vala_catch_clause_set_type_reference (ValaCatchClause* self, ValaTypeReference* value);
char* vala_catch_clause_get_variable_name (ValaCatchClause* self);
void vala_catch_clause_set_variable_name (ValaCatchClause* self, const char* value);
ValaBlock* vala_catch_clause_get_body (ValaCatchClause* self);
void vala_catch_clause_set_body (ValaCatchClause* self, ValaBlock* value);
ValaVariableDeclarator* vala_catch_clause_get_variable_declarator (ValaCatchClause* self);
void vala_catch_clause_set_variable_declarator (ValaCatchClause* self, ValaVariableDeclarator* value);
GType vala_catch_clause_get_type ();

G_END_DECLS

#endif
