/* valaccodedostatement.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaccodedostatement.h"
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodedostatement.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodenode.h>

struct _ValaCCodeDoStatementPrivate {
	ValaCCodeStatement* _body;
	ValaCCodeExpression* _condition;
};
#define VALA_CCODE_DO_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_DO_STATEMENT, ValaCCodeDoStatementPrivate))
enum  {
	VALA_CCODE_DO_STATEMENT_DUMMY_PROPERTY,
	VALA_CCODE_DO_STATEMENT_BODY,
	VALA_CCODE_DO_STATEMENT_CONDITION
};
static void vala_ccode_do_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_do_statement_parent_class = NULL;
static void vala_ccode_do_statement_dispose (GObject * obj);


ValaCCodeDoStatement* vala_ccode_do_statement_new (ValaCCodeStatement* stmt, ValaCCodeExpression* cond)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeDoStatement * self;
	g_return_val_if_fail (stmt == NULL || VALA_IS_CCODE_STATEMENT (stmt), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cond), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "body", g_value_init (&__params_it->value, VALA_TYPE_CCODE_STATEMENT), g_value_set_object (&__params_it->value, stmt), __params_it++);
	(__params_it->name = "condition", g_value_init (&__params_it->value, VALA_TYPE_CCODE_EXPRESSION), g_value_set_object (&__params_it->value, cond), __params_it++);
	self = g_object_newv (VALA_TYPE_CCODE_DO_STATEMENT, __params_it - __params, __params);
	return self;
}


static void vala_ccode_do_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeDoStatement * self;
	self = VALA_CCODE_DO_STATEMENT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_indent (writer);
	vala_ccode_writer_write_string (writer, "do");
	/* while shouldn't be on a separate line */
	if (VALA_IS_CCODE_BLOCK (vala_ccode_do_statement_get_body (self))) {
		ValaCCodeBlock* __temp0;
		ValaCCodeBlock* cblock;
		__temp0 = NULL;
		cblock = (__temp0 = VALA_CCODE_BLOCK (vala_ccode_do_statement_get_body (self)), (__temp0 == NULL ? NULL : g_object_ref (__temp0)));
		(vala_ccode_block_set_suppress_newline (cblock, TRUE), vala_ccode_block_get_suppress_newline (cblock));
		(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	}
	vala_ccode_node_write (VALA_CCODE_NODE (vala_ccode_do_statement_get_body (self)), writer);
	vala_ccode_writer_write_string (writer, " while (");
	vala_ccode_node_write (VALA_CCODE_NODE (vala_ccode_do_statement_get_condition (self)), writer);
	vala_ccode_writer_write_string (writer, ");");
}


ValaCCodeStatement* vala_ccode_do_statement_get_body (ValaCCodeDoStatement* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_DO_STATEMENT (self), NULL);
	return self->priv->_body;
}


void vala_ccode_do_statement_set_body (ValaCCodeDoStatement* self, ValaCCodeStatement* value)
{
	ValaCCodeStatement* __temp3;
	ValaCCodeStatement* __temp2;
	g_return_if_fail (VALA_IS_CCODE_DO_STATEMENT (self));
	__temp3 = NULL;
	__temp2 = NULL;
	self->priv->_body = (__temp3 = (__temp2 = value, (__temp2 == NULL ? NULL : g_object_ref (__temp2))), (self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL))), __temp3);
}


ValaCCodeExpression* vala_ccode_do_statement_get_condition (ValaCCodeDoStatement* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_DO_STATEMENT (self), NULL);
	return self->priv->_condition;
}


void vala_ccode_do_statement_set_condition (ValaCCodeDoStatement* self, ValaCCodeExpression* value)
{
	ValaCCodeExpression* __temp5;
	g_return_if_fail (VALA_IS_CCODE_DO_STATEMENT (self));
	__temp5 = NULL;
	self->priv->_condition = (__temp5 = g_object_ref (value), (self->priv->_condition == NULL ? NULL : (self->priv->_condition = (g_object_unref (self->priv->_condition), NULL))), __temp5);
}


static void vala_ccode_do_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeDoStatement * self;
	self = VALA_CCODE_DO_STATEMENT (object);
	switch (property_id) {
		case VALA_CCODE_DO_STATEMENT_BODY:
		g_value_set_object (value, vala_ccode_do_statement_get_body (self));
		break;
		case VALA_CCODE_DO_STATEMENT_CONDITION:
		g_value_set_object (value, vala_ccode_do_statement_get_condition (self));
		break;
	}
}


static void vala_ccode_do_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeDoStatement * self;
	self = VALA_CCODE_DO_STATEMENT (object);
	switch (property_id) {
		case VALA_CCODE_DO_STATEMENT_BODY:
		vala_ccode_do_statement_set_body (self, g_value_get_object (value));
		break;
		case VALA_CCODE_DO_STATEMENT_CONDITION:
		vala_ccode_do_statement_set_condition (self, g_value_get_object (value));
		break;
	}
}


static void vala_ccode_do_statement_class_init (ValaCCodeDoStatementClass * klass)
{
	vala_ccode_do_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeDoStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_do_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_do_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_do_statement_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_do_statement_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_DO_STATEMENT_BODY, g_param_spec_object ("body", "foo", "bar", VALA_TYPE_CCODE_STATEMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_DO_STATEMENT_CONDITION, g_param_spec_object ("condition", "foo", "bar", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_ccode_do_statement_init (ValaCCodeDoStatement * self)
{
	self->priv = VALA_CCODE_DO_STATEMENT_GET_PRIVATE (self);
}


static void vala_ccode_do_statement_dispose (GObject * obj)
{
	ValaCCodeDoStatement * self;
	ValaCCodeDoStatementClass * klass;
	GObjectClass * parent_class;
	self = VALA_CCODE_DO_STATEMENT (obj);
	(self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL)));
	(self->priv->_condition == NULL ? NULL : (self->priv->_condition = (g_object_unref (self->priv->_condition), NULL)));
	klass = VALA_CCODE_DO_STATEMENT_CLASS (g_type_class_peek (VALA_TYPE_CCODE_DO_STATEMENT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_do_statement_get_type ()
{
	static GType vala_ccode_do_statement_type_id = 0;
	if (G_UNLIKELY (vala_ccode_do_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeDoStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_do_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeDoStatement), 0, (GInstanceInitFunc) vala_ccode_do_statement_init };
		vala_ccode_do_statement_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeDoStatement", &g_define_type_info, 0);
	}
	return vala_ccode_do_statement_type_id;
}




