/* valavaluetype.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valavaluetype.h>

struct _ValaValueTypePrivate {
	ValaTypesymbol* _type_symbol;
};
#define VALA_VALUE_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_VALUE_TYPE, ValaValueTypePrivate))
enum  {
	VALA_VALUE_TYPE_DUMMY_PROPERTY,
	VALA_VALUE_TYPE_TYPE_SYMBOL
};
static gpointer vala_value_type_parent_class = NULL;
static void vala_value_type_dispose (GObject * obj);


ValaValueType* vala_value_type_new (ValaTypesymbol* type_symbol) {
	ValaValueType * self;
	g_return_val_if_fail (type_symbol == NULL || VALA_IS_TYPESYMBOL (type_symbol), NULL);
	self = g_object_newv (VALA_TYPE_VALUE_TYPE, 0, NULL);
	vala_data_type_set_data_type (VALA_DATA_TYPE (self), type_symbol);
	vala_value_type_set_type_symbol (self, type_symbol);
	return self;
}


ValaTypesymbol* vala_value_type_get_type_symbol (ValaValueType* self) {
	g_return_val_if_fail (VALA_IS_VALUE_TYPE (self), NULL);
	return self->priv->_type_symbol;
}


void vala_value_type_set_type_symbol (ValaValueType* self, ValaTypesymbol* value) {
	g_return_if_fail (VALA_IS_VALUE_TYPE (self));
	self->priv->_type_symbol = value;
}


static void vala_value_type_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaValueType * self;
	self = VALA_VALUE_TYPE (object);
	switch (property_id) {
		case VALA_VALUE_TYPE_TYPE_SYMBOL:
		g_value_set_object (value, vala_value_type_get_type_symbol (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_value_type_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaValueType * self;
	self = VALA_VALUE_TYPE (object);
	switch (property_id) {
		case VALA_VALUE_TYPE_TYPE_SYMBOL:
		vala_value_type_set_type_symbol (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_value_type_class_init (ValaValueTypeClass * klass) {
	vala_value_type_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaValueTypePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_value_type_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_value_type_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_value_type_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_VALUE_TYPE_TYPE_SYMBOL, g_param_spec_object ("type-symbol", "type-symbol", "type-symbol", VALA_TYPE_TYPESYMBOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_value_type_init (ValaValueType * self) {
	self->priv = VALA_VALUE_TYPE_GET_PRIVATE (self);
}


static void vala_value_type_dispose (GObject * obj) {
	ValaValueType * self;
	self = VALA_VALUE_TYPE (obj);
	G_OBJECT_CLASS (vala_value_type_parent_class)->dispose (obj);
}


GType vala_value_type_get_type (void) {
	static GType vala_value_type_type_id = 0;
	if (G_UNLIKELY (vala_value_type_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaValueTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_value_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaValueType), 0, (GInstanceInitFunc) vala_value_type_init };
		vala_value_type_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaValueType", &g_define_type_info, 0);
	}
	return vala_value_type_type_id;
}




