/* valaformalparameter.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __VALA_VALAFORMALPARAMETER_H__
#define __VALA_VALAFORMALPARAMETER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <vala/valasymbol.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameterPrivate ValaFormalParameterPrivate;

/**
 * Represents a formal parameter in method and callback signatures.
 */
struct _ValaFormalParameter {
	ValaSymbol parent_instance;
	ValaFormalParameterPrivate * priv;
};
struct _ValaFormalParameterClass {
	ValaSymbolClass parent_class;
};

ValaFormalParameter* vala_formal_parameter_new (const char* _name, ValaDataType* type, ValaSourceReference* source);
ValaFormalParameter* vala_formal_parameter_new_with_ellipsis (ValaSourceReference* source);
void vala_formal_parameter_process_attributes (ValaFormalParameter* self);
ValaFormalParameter* vala_formal_parameter_copy (ValaFormalParameter* self);
ValaDataType* vala_formal_parameter_get_type_reference (ValaFormalParameter* self);
void vala_formal_parameter_set_type_reference (ValaFormalParameter* self, ValaDataType* value);
gboolean vala_formal_parameter_get_ellipsis (ValaFormalParameter* self);
void vala_formal_parameter_set_ellipsis (ValaFormalParameter* self, gboolean value);
ValaExpression* vala_formal_parameter_get_default_expression (ValaFormalParameter* self);
void vala_formal_parameter_set_default_expression (ValaFormalParameter* self, ValaExpression* value);
gboolean vala_formal_parameter_get_no_array_length (ValaFormalParameter* self);
void vala_formal_parameter_set_no_array_length (ValaFormalParameter* self, gboolean value);
gboolean vala_formal_parameter_get_construct_parameter (ValaFormalParameter* self);
void vala_formal_parameter_set_construct_parameter (ValaFormalParameter* self, gboolean value);
double vala_formal_parameter_get_cparameter_position (ValaFormalParameter* self);
void vala_formal_parameter_set_cparameter_position (ValaFormalParameter* self, double value);
double vala_formal_parameter_get_carray_length_parameter_position (ValaFormalParameter* self);
void vala_formal_parameter_set_carray_length_parameter_position (ValaFormalParameter* self, double value);
double vala_formal_parameter_get_cdelegate_target_parameter_position (ValaFormalParameter* self);
void vala_formal_parameter_set_cdelegate_target_parameter_position (ValaFormalParameter* self, double value);
GType vala_formal_parameter_get_type (void);

G_END_DECLS

#endif
