/* valacodebinding.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valacodebinding.h>

enum  {
	VALA_CODE_BINDING_DUMMY_PROPERTY
};
static gpointer vala_code_binding_parent_class = NULL;


/**
 * Generate code for this source code node.
 */
void vala_code_binding_emit (ValaCodeBinding* self) {
	VALA_CODE_BINDING_GET_CLASS (self)->emit (self);
}


static void vala_code_binding_class_init (ValaCodeBindingClass * klass) {
	vala_code_binding_parent_class = g_type_class_peek_parent (klass);
}


static void vala_code_binding_init (ValaCodeBinding * self) {
}


GType vala_code_binding_get_type (void) {
	static GType vala_code_binding_type_id = 0;
	if (G_UNLIKELY (vala_code_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCodeBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeBinding), 0, (GInstanceInitFunc) vala_code_binding_init };
		vala_code_binding_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaCodeBinding", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_code_binding_type_id;
}




