/* valaattributeprocessor.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __VALA_VALAATTRIBUTEPROCESSOR_H__
#define __VALA_VALAATTRIBUTEPROCESSOR_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodevisitor.h>
#include <vala/valacodecontext.h>
#include <vala/valasourcefile.h>
#include <vala/valanamespace.h>
#include <vala/valaclass.h>
#include <vala/valastruct.h>
#include <vala/valainterface.h>
#include <vala/valaenum.h>
#include <vala/valamethod.h>
#include <vala/valacreationmethod.h>
#include <vala/valaformalparameter.h>
#include <vala/valaproperty.h>
#include <vala/valadelegate.h>
#include <vala/valaconstant.h>
#include <vala/valafield.h>
#include <vala/valasignal.h>

G_BEGIN_DECLS


#define VALA_TYPE_ATTRIBUTE_PROCESSOR (vala_attribute_processor_get_type ())
#define VALA_ATTRIBUTE_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE_PROCESSOR, ValaAttributeProcessor))
#define VALA_ATTRIBUTE_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE_PROCESSOR, ValaAttributeProcessorClass))
#define VALA_IS_ATTRIBUTE_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE_PROCESSOR))
#define VALA_IS_ATTRIBUTE_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE_PROCESSOR))
#define VALA_ATTRIBUTE_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE_PROCESSOR, ValaAttributeProcessorClass))

typedef struct _ValaAttributeProcessor ValaAttributeProcessor;
typedef struct _ValaAttributeProcessorClass ValaAttributeProcessorClass;
typedef struct _ValaAttributeProcessorPrivate ValaAttributeProcessorPrivate;

/**
 * Code visitor processing attributes associated with code nodes.
 */
struct _ValaAttributeProcessor {
	ValaCodeVisitor parent_instance;
	ValaAttributeProcessorPrivate * priv;
};
struct _ValaAttributeProcessorClass {
	ValaCodeVisitorClass parent_class;
};

void vala_attribute_processor_process (ValaAttributeProcessor* self, ValaCodeContext* context);
ValaAttributeProcessor* vala_attribute_processor_new (void);
GType vala_attribute_processor_get_type (void);

G_END_DECLS

#endif
