/* valatypeparameter.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALATYPEPARAMETER_H__
#define __VALATYPEPARAMETER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_TYPE_PARAMETER (vala_type_parameter_get_type ())
#define VALA_TYPE_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPE_PARAMETER, ValaTypeParameter))
#define VALA_TYPE_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPE_PARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPE_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPE_PARAMETER))
#define VALA_IS_TYPE_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPE_PARAMETER))
#define VALA_TYPE_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPE_PARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameterPrivate ValaTypeParameterPrivate;

/**
 * Represents a generic type parameter in the source code.
 */
struct _ValaTypeParameter {
	ValaCodeNode parent;
	ValaTypeParameterPrivate * priv;
	ValaDataType* type;
};
struct _ValaTypeParameterClass {
	ValaCodeNodeClass parent;
};

ValaTypeParameter* vala_type_parameter_new (const char* _name, ValaSourceReference* source);
ValaArray* vala_type_parameter_get_array (ValaTypeParameter* self, gint rank);
gboolean vala_type_parameter_equals (ValaTypeParameter* self, ValaTypeParameter* param2);
char* vala_type_parameter_get_name (ValaTypeParameter* self);
void vala_type_parameter_set_name (ValaTypeParameter* self, const char* value);
GType vala_type_parameter_get_type ();

G_END_DECLS

#endif
