/* valaflags.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALAFLAGS_H__
#define __VALAFLAGS_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valadatatype.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_FLAGS (vala_flags_get_type ())
#define VALA_FLAGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FLAGS, ValaFlags))
#define VALA_FLAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FLAGS, ValaFlagsClass))
#define VALA_IS_FLAGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FLAGS))
#define VALA_IS_FLAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FLAGS))
#define VALA_FLAGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FLAGS, ValaFlagsClass))

typedef struct _ValaFlagsPrivate ValaFlagsPrivate;

/**
 * Represents a flags declaration in the source code.
 */
struct _ValaFlags {
	ValaDataType parent;
	ValaFlagsPrivate * priv;
};
struct _ValaFlagsClass {
	ValaDataTypeClass parent;
};

ValaFlags* vala_flags_new (const char* name, ValaSourceReference* source_reference);
void vala_flags_add_value (ValaFlags* self, ValaFlagsValue* value);
char* vala_flags_get_cprefix (ValaFlags* self);
void vala_flags_set_cprefix (ValaFlags* self, const char* cprefix);
void vala_flags_process_attributes (ValaFlags* self);
GType vala_flags_get_type ();

G_END_DECLS

#endif
